Ext.define('NewComponent.controller.MainRUM',{
	extend:'Ext.app.Controller',
	views:['AddNewRUMComponent'],
	requires:['NewComponent.view.AddNewRUMComponent'],
	refs:[
		{selector:'addnewrumcomponent', ref:'addnewrumcomponent'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'addnewrumcomponent':
			{
				'boxready': this.afterMainRender
			},
			'addnewrumcomponent button[id="backButton"]':
			{
				'click':this.addNewBack
			},
			'addnewrumcomponent button[id="addButton"]':
			{
				'click':this.addComponent
			},
			'addnewrumcomponent button[id="updateButton"]':
			{
				'click':this.updateComponent
			},
			'addnewrumcomponent button[id="javaDownload"]':
			{
				'click':this.javaDownload
			}, 
			'addnewrumcomponent button[id="dotnetDownload"]':
			{
				'click':this.dotnetDownload
			},
			'addnewrumcomponent button[id="scriptDownload"]':
			{
				'click':this.scriptDownload
			}, 
		});
	},
	buildMainData: function()
	{
		var urlStr = 'NewComponent/data/EgNewServerJson.jsp?&serverType='+encodeURIComponent(serverType)+'&selectedServerGroup='+serverCategory;
				
		if (currentAction == 'add')
		{
			urlStr += '&server=new';
		}
		else if (currentAction == 'manage')
		{
			urlStr = "NewComponent/data/EgNewServerJson.jsp?"+qryStr;
		}
		else
		{
			urlStr += '&server='+encodeURIComponent(server)+'&modifyserver=true';
		}
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		jsonDataCache = publicJSON;
	},
	getData: function(urlStr,needToCache)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
		if (needToCache)
		{
			jsonDataCache = publicJSON;
		}
	},
	afterMainRender: function()
	{	
		if(fromTopology=='yes')
		{
			Ext.getCmp('backButton').hide();
			Ext.getCmp('pageDescription').hide();
		}
		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
						Ext.getCmp('addCategory').setValue('-1');
						Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
						Ext.getCmp('stype').setValue('-1');
						Ext.getCmp('addPageContainer').hide();
						Ext.getCmp('buttonContainer').hide();
						return;
					}
				}
			});
		}

		Ext.getCmp('addCategory').getStore().loadRawData(publicJSON.category);
		Ext.getCmp('addCategory').setValue(publicJSON.selectedServerGroup);
		Ext.getCmp('stype').getStore().loadRawData(publicJSON.componentTypes);
		Ext.getCmp('stype').setValue(publicJSON.serverType);
		Ext.getCmp('addCategoryShown').setValue(publicJSON.selectedServerGroupDisp);
		Ext.getCmp('stypeShown').setValue(publicJSON.serverTypeDisp);

		if(publicJSON.serverType == 'Real_user_monitor')
		{
			Ext.getCmp('rumUserNameGr').show();
			Ext.getCmp('rumUserNameGr').enable();
			Ext.getCmp('rumUsernameNo').setValue(true);	
			
			Ext.getCmp('rumApplyCleanUpNo').setValue(true);	
			
			Ext.getCmp('rumExpType').getStore().loadRawData([{"displayField":"Choose a selector expression","valueField":"Choose a selector expression"},{"displayField":"CSS Selector","valueField":"CSS Selector"},{"displayField":"DOM Locator","valueField":"DOM Locator"},{"displayField":"XPath Locator","valueField":"XPath Locator"}]);
			Ext.getCmp('rumExpType').select(Ext.getCmp('rumExpType').getStore().getAt(0));
			rumHiddenField = publicJSON.hiddenVals;
			//Ext.getCmp('rumContainer').show();
			//Ext.getCmp('addPageContainer').hide();
			{
				Ext.Ajax.request(
				{
					url: 'NewComponent/data/newRUMServerJson.jsp?currentAction='+currentAction+'&compName='+encodeURIComponent(compName),
					method: 'POST',
					async:false,
					success: function(response)
					{
						if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
						{
							var responseData = response.responseText;
							var jsonText = responseData.substring(0,responseData.indexOf('&*&'));
							var textFileDatas = responseData.substring((responseData.indexOf('&*&')+3),responseData.indexOf('^%^'));
							var jsFileDatas = responseData.substring((responseData.indexOf('~|~')+3 )); 
							publicJSON = Ext.decode(jsonText);
							if(currentAction == 'modify')
							{
								//var dispSiteName = publicJSON['realAssociatedSite'];
								Ext.getCmp('addButton').hide();
								Ext.getCmp('updateButton').show();
								var dispCompName = compName.substring(0,compName.indexOf(':'));				
								Ext.getCmp('rumNickName').setValue(dispCompName);
								//Ext.getCmp('rumNickName').setReadOnly( true );
								Ext.getCmp('rumRemoteAgents').getStore().loadRawData(publicJSON['remoteAgentsList']);
								selectedRemoteAgent = publicJSON['realRemoteAgent'];
								Ext.getCmp('rumRemoteAgents').select(selectedRemoteAgent);
								Ext.getCmp('rumCollectUrl').getStore().loadRawData(publicJSON['realDataCollectorURL']);

								//urlForSelectedComp=publicJSON['urlForSelectedComp'];
								rumCollectorCmp=publicJSON['urlForSelectedComp'];
								var filePresence=publicJSON['isEGRUMfile'];
								Ext.getCmp('rumCollectUrl').select(rumCollectorCmp);
								
								rumUsername=publicJSON['rumUserName'];
								if(rumUsername == 'yes')
								{
									Ext.getCmp('rumUsernameYes').setValue(rumUsername);
									
									Ext.getCmp('rumExpType').show();
									Ext.getCmp('rumExpType').enable();
									rumExpType = publicJSON['rumExpressionType'];
									Ext.getCmp('rumExpType').select(rumExpType);
									
									rumSelectorPath = publicJSON['rumSelectorName'];
									Ext.getCmp('rumSelectorPath').setValue(rumSelectorPath);
									Ext.getCmp('rumSelectorPath').show();
									Ext.getCmp('rumSelectorPath').enable();
									
									rumSelectorPathIndex = publicJSON['rumSelectorIndex'];
									Ext.getCmp('rumSelectorPathIndex').setValue(rumSelectorPathIndex);
									if(rumSelectorPathIndex != "0")
									{
										Ext.getCmp('rumSelectorPathIndex').show();
										Ext.getCmp('rumSelectorPathIndex').enable();
									}else 
									{
										Ext.getCmp('rumSelectorPathIndex').hide();
										Ext.getCmp('rumSelectorPathIndex').disable();
									}
									
									rumApplyCleanUp = publicJSON['rumCleanUpRule'];
									Ext.getCmp('rumApplyCleanUpYes').setValue(rumApplyCleanUp);
									Ext.getCmp('rumApplyCleanUpGr').enable();
									Ext.getCmp('rumApplyCleanUpGr').show();
									if(rumApplyCleanUp == "yes")
									{
										rumExtractionRule = publicJSON['rumExtractionRule'];
										Ext.getCmp('rumExtractionRule').setValue(rumExtractionRule);
										Ext.getCmp('rumExtractionRule').enable();
										Ext.getCmp('rumExtractionRule').show();
									}
									else 
									{
										Ext.getCmp('rumApplyCleanUpNo').setValue(rumApplyCleanUp);
										Ext.getCmp('rumExtractionRule').disable();
										Ext.getCmp('rumExtractionRule').hide();
										Ext.getCmp('updateButton').hide();
									}
								}
								else 
								{
									Ext.getCmp('rumUsernameNo').setValue(rumUsername);
									Ext.getCmp('updateButton').hide();
								}

								//rumAlternateUrl = publicJSON['alternateCollectorUrl']; 
								//Ext.getCmp('rumAlternateUrl').setValue(rumAlternateUrl);
								
								/*var selectedLanguages = publicJSON['selectedLanguages']; 
								if(selectedLanguages != null && selectedLanguages != undefined)
								{
									if(selectedLanguages.indexOf('Java') != -1)
										Ext.getCmp('checkbox1').setValue(true);
									
									if(selectedLanguages.indexOf('Dotnet') != -1)
										Ext.getCmp('checkbox2').setValue(true); 

									if(selectedLanguages.indexOf('Others') != -1)
										Ext.getCmp('checkbox3').setValue(true); 
									else
										Ext.getCmp('checkbox3').setValue(false); 

									//Ext.getCmp('checkbox1').disable();
									//Ext.getCmp('checkbox2').disable();
									//Ext.getCmp('checkbox3').disable();
								}*/
								
	
								if(filePresence == 'exists')
								{
									Ext.getCmp('downloadLinkPanel').show();
									collectorType = publicJSON['collectorType'];
									//if(Ext.getCmp('checkbox3').getValue())
									//{
									//	if(collectorType == 'Cloud')
									//		Ext.getCmp('cloudDownloadContainer').hide();
									//	else
									//		Ext.getCmp('cloudDownloadContainer').show();
									//}
									Ext.getCmp('includeScript').setValue(textFileDatas);
									Ext.getCmp('includeJSScript').setValue(jsFileDatas);
									if(Ext.getCmp('radioOne').getValue()){
										Ext.getCmp('includeScript').show();
										Ext.getCmp('includeJSScript').hide();
									}
									
									var urlNew = publicJSON['urlReplacement'];
									var urlJavaNew = publicJSON['urlJavaReplacement'];
									var urlDotNetNew = publicJSON['urlDotNetReplacement'];
									Ext.getCmp('downloadUrl').setValue('<a href="javascript:ctrler.scriptDownload();" style="text-decoration: underline;">'+urlNew+'</a>');
									Ext.getCmp('javaDownloadUrl').setValue('<a href="javascript:ctrler.javaDownload();" style="text-decoration: underline;">'+urlJavaNew+'</a>');
									Ext.getCmp('dotnetDownloadUrl').setValue('<a href="javascript:ctrler.dotnetDownload();" style="text-decoration: underline;">'+urlDotNetNew+'</a>');

									if (rumOSCheck.indexOf("Win")> -1) 
										Ext.getCmp('dotnetDownloadContainer').show();
									else
										Ext.getCmp('dotnetDownloadContainer').hide();
								}
							}
							else
							{
								//Ext.getCmp('rumNickName').setReadOnly(false);
								Ext.getCmp('addButton').show();
								Ext.getCmp('updateButton').hide();
								Ext.getCmp('downloadLinkPanel').hide();
								if(servicePage!=null && servicePage=='servicePageAddview')
								{
									Ext.getCmp('rumNickName').setValue(onGoingSite+"-RUM");
									Ext.getCmp('rumCollectUrl').getStore().loadRawData(publicJSON['realDataCollectorURL']);
								}
								Ext.getCmp('rumRemoteAgents').getStore().loadRawData(publicJSON['remoteAgentsList']);
								Ext.getCmp('rumRemoteAgents').select(Ext.getCmp('rumRemoteAgents').getStore().getAt(0));
								Ext.getCmp('rumCollectUrl').getStore().loadRawData(publicJSON['realDataCollectorURL']);
								Ext.getCmp('rumCollectUrl').select(Ext.getCmp('rumCollectUrl').getStore().getAt(0));
								//Ext.getCmp('rumAlternateUrl').setValue(Ext.getCmp('rumCollectUrl').getStore().getAt(0).data.displayField);
							}
						}
					}
				});
			}
		}
	},
	addNewBack: function()
	{
		if (fromAPP == "NotificationManager")
		{
			window.location.href = "/final/admin/EgViewManagerNotificationDetails.jsp?type="+requestType+"&fromWizard="+fromWizard;
		}
		else if (fromAPP == 'ManUnmanSystems')
		{
			window.location.href = "/final/admin/EgManageServers.jsp?nick="+encodeURIComponent(compNick)+"&fromWizard="+fromWizard;
		}
		else
		{
			var tmpURL = backHref;
			var idx = tmpURL.indexOf("?");
			if (idx > -1)
			{
				tmpURL = tmpURL.substring(0,idx);
			}
			tmpURL+="?category="+serverCategory+"&comptype="+encodeURIComponent(serverType)+"&fromWizard="+fromWizard;
			window.location.href = tmpURL;
		}
	},
	addComponent : function(button)
	{
		var isValid = this.addComponentValidation();
		if (!isValid)
		{
			return;
		}
	},
	updateComponent : function(button)
	{
		var isValid = this.addComponentValidation();
		if (!isValid)
		{
			return;
		}
	},
	addComponentValidation : function()
	{
		var me= this;
		var compType = Ext.getCmp('stype').getValue();
		compType = encodeURIComponent(compType);
		if(compType == 'Real_user_monitor')
		{
			var nickNameObj = Ext.getCmp('rumNickName');
			var nickNameVal = Ext.getCmp('rumNickName').getValue();
			var urlObj = Ext.getCmp('rumCollectUrl');
			var alternateUrlObj = Ext.getCmp('rumAlternateUrl');
			var url = Ext.getCmp('rumCollectUrl').getValue();
			var rumExpType = Ext.getCmp('rumExpType').getValue();
			var rumSelectorPath = Ext.getCmp('rumSelectorPath').getValue();
			var rumExtractionRule = Ext.getCmp('rumExtractionRule').getValue();
			var rumUsernameYes = Ext.getCmp('rumUsernameYes').getValue();
			var rumApplyCleanUpYes = Ext.getCmp('rumApplyCleanUpYes').getValue();
			var rumSelectorPathIndex = Ext.getCmp('rumSelectorPathIndex').getValue();
			
			var rumExpTypeObj = Ext.getCmp('rumExpType');
			var rumSelectorPathObj = Ext.getCmp('rumSelectorPath');
			var rumExtractionRuleObj = Ext.getCmp('rumExtractionRule');
			var rumUsernameYesObj = Ext.getCmp('rumUsernameYes');
			var rumApplyCleanUpYesObj = Ext.getCmp('rumApplyCleanUpYes');
			var rumSelectorPathIndexObj = Ext.getCmp('rumSelectorPathIndex');
			
			/*var alternateUrl = Ext.getCmp('rumAlternateUrl').getValue();
			var isJavaSelected = Ext.getCmp('checkbox1').getValue();
			var isDotNetSelected = Ext.getCmp('checkbox2').getValue();
			var isOthersSelected = Ext.getCmp('checkbox3').getValue();*/
			
			if(!checkblank(nickNameVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							nickNameObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(!checkspace(nickNameVal))
			{
				nickNameObj.focus(true);
				return false;
			}
			else if(!checkspecial(nickNameVal,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?/")) 
			{
				nickNameObj.focus(true);
				return false;
			}
			/*else if(!checkblank(alternateUrl))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg17,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							alternateUrlObj.focus(true);
						}
					}
				});
				return false;
			}*/

			if(isDoubleByteMgr=="false")
			{
				if(!validateSingleByte(nickNameVal))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						width: 700,
						fn: function(response) {
							if(response == 'ok') {
								nickNameObj.focus(true);
							}
						}
					});
					return false;
				}
				else if(!this.checkdots(nickNameVal))
				{
					nickNameObj.focus(true);
					return false;
				}
				else if(nickNameVal.toLowerCase() == compType.toLowerCase())
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg26,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								nickNameObj.focus(true);
							}
						}
					});
					return false;
				}
			}
			else if(!this.checkForHostType(nickNameVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg20 + alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							nickNameObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(url == '')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg42,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							urlObj.focus(true);
						}
					}
				});
				return false;
			}
			
			
			/*if(!validateSingleUrl(alternateUrl) )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg44,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							alternateUrlObj.focus(true);
						}
					}
				});
				return false;
			}
			else if(alternateUrl != null && alternateUrl.indexOf("::") >= 0 && !validateIPv6Url(alternateUrl))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg44,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							alternateUrlObj.focus(true);
						}
					}
				});
				return false;
			}*/
			/*else if(!isJavaSelected && !isDotNetSelected && !isOthersSelected)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg45,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							nickNameObj.focus(true);
						}
					}
				});
				return false;
			}*/
			
			if(rumUsernameYes){
				if(rumExpType == "Choose a selector expression")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg63,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								rumExpTypeObj.focus(true);
							}
						}
					});
					return false;
				}	
				if(!checkblank(rumSelectorPath))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg62,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								rumSelectorPathObj.focus(true);
							}
						}
					});
					return false;
				}	
				if(!checkblank(rumSelectorPathIndex))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg65,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								rumSelectorPathIndexObj.focus(true);
							}
						}
					});
					return false;
				}	
				
				if(validateRumIndex(rumSelectorPathIndex))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg66,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								rumSelectorPathIndexObj.focus(true);
							}
						}
					});
					return false;
				}	
				if(rumApplyCleanUpYes)
				{
					if(!checkblank(rumExtractionRule))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg64,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(response) {
								if(response == 'ok') {
									rumExtractionRuleObj.focus(true);
								}
							}
						});
						return false;
					}
				}
			}
			
			
		}
		me.actualAdd();
	},
	checkdots : function(fieldvalue)
	{
		var val = fieldvalue;
		if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg31,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else
		{
			for(var k=0;k < val.length;k++)
			{
				if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg41,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	},
	checkForHostType : function(compType)
	{
		var servers = jsonDataCache.servTypes;
		for (var s=0; s<servers.length;s++)
		{
			if(servers[s] == compType)
			{
				return false;
			}
		}
		return true;
	},
	actualAdd: function()
	{
		var me= this;
		var allow = true;
		var selCType = Ext.getCmp('stype').getValue();
		selCType = encodeURIComponent(selCType);
		var parameters = '';
		if(selCType == 'Real_user_monitor')
		{
			var rumNickName = Ext.getCmp('rumNickName').getValue();
			rumNickName = encodeURIComponent(rumNickName);
			var rumService='';
			var rumUrl = Ext.getCmp('rumCollectUrl').getValue();
			//var rumAlternateUrl = Ext.getCmp('rumAlternateUrl').getValue();
			var rumRemAgent = Ext.getCmp('rumRemoteAgents').getValue();
			var dispCompName = compName.substring(0,compName.indexOf(':'));
			/*var isJavaSelected = Ext.getCmp('checkbox1').getValue();
			var isDotNetSelected = Ext.getCmp('checkbox2').getValue();
			var isOthersSelected = Ext.getCmp('checkbox3').getValue();*/
			parameters = "&isRumServer=yes&rumNickName="+rumNickName+"&rumService="+rumService+"&rumUrl="+rumUrl+"&rumRemAgent="+rumRemAgent+"&dispCompName="+dispCompName;
			me.addServerComponent(allow, parameters);
		}
	},
	addServerComponent : function(allow, params)
	{
		var parameters = params;
		var selCType = Ext.getCmp('stype').getValue();
		selCType = encodeURIComponent(selCType);
		if(allow)
		{
			var mainObj = this;
			var urlStr = "/final/admin/NewComponent/data/EgRUMHostCheckJson.jsp?strPass=&from=addNew&server=new&isAggregateType=false";
			if (currentAction == 'modify')
			{
				urlStr = "/final/admin/NewComponent/data/EgRUMHostCheckJson.jsp?isAggregateType=false&modifyserver=true";
			}
			if(fromTopology!=null && fromTopology=='yes')
			{
				urlStr += "&frmTopology="+fromTopology+"&topoSegName=Topo_Auto";
			}
			var hiddenParams = publicJSON.hiddenVals;
			if(selCType == 'Real_user_monitor')
			{
				urlStr += parameters;
				hiddenParams = rumHiddenField;
			}
			var me = Ext.getCmp('hiddenContnr');
			me.removeAll();
			Ext.suspendLayouts();
			for (var param in hiddenParams) {
					me.add({
						xtype: 'hidden',
						name: param,
						value: hiddenParams[param]
					});
			}
			Ext.resumeLayouts(true);
			
			var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
			tmpMask.show();
		
			if(Ext.getCmp('includeScript') != undefined)
				Ext.getCmp('includeScript').setValue('');
			
			if(Ext.getCmp('includeJSScript') != undefined)
				Ext.getCmp('includeJSScript').setValue('');

			this.getAddnewrumcomponent().submit({
				url: urlStr,
				method: 'POST',
				success: function(form, action){
					tmpMask.hide();
					var resObj  = action.response.responseText;
					publicJSON = Ext.decode(resObj);
					var requestStatus = publicJSON.requestStatus;
					
					if (requestStatus=='failed')
					{
						if(publicJSON.error_type=='alert')
						{
							Ext.Msg.show({
								title: publicJSON.error_Info.error_Title,
								msg: alertMsg33+'<br>'+publicJSON.error_Info.error_Msg_1+'<br>'+publicJSON.error_Info.error_Msg_2,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							publicJSON = jsonDataCache;
						}
						else if (publicJSON.error_type=='confirm')
						{
							Ext.Msg.show({
								title: publicJSON.error_Info.error_Title,
								msg: publicJSON.error_Info.error_Msg_1+"<br>Host IP/Name : "+publicJSON.error_Info.IP+"<br>Nick name : "+publicJSON.error_Info.nickName+'<br>'+publicJSON.error_Info.error_Msg_2,
								buttons: Ext.Msg.YESNO,
								icon: 'iconConfirmation',
								fn: function(response) {
									if(response == 'yes') 
									{
										var forwardURL = publicJSON.error_Info.forward_URL;
										var oldIP = publicJSON.error_Info.IP;
										var oldNick = publicJSON.error_Info.nickName;
										var hiddenParams = publicJSON.hiddenValues;
										var me = Ext.getCmp('hiddenContnr');
										me.removeAll();
										Ext.suspendLayouts();
										for (var param in hiddenParams) {
											var paramVal = hiddenParams[param];
											if (param == 'hostip')
											{
												paramVal = oldIP;
											}
											else if (param == 'hostname')
											{
												paramVal = oldNick;
											}
											me.add({
												xtype: 'hidden',
												name: param,
												value: paramVal
											});
										}
										Ext.resumeLayouts(true);
										forwardURL ="/final/admin/NewComponent/data/"+forwardURL;
										mainObj.forwardGivenURL(forwardURL);									
									}
									else
									{
										//Ext.getCmp('hostip').setValue("");
										Ext.getCmp('hostname').setValue("");
										//ctrler.compTypesSelection();
										var selectedCType = encodeURIComponent(selCType);
										var selectedCategory = Ext.getCmp('addCategory').getValue();
										selectedCategory = encodeURIComponent(selectedCategory);
										var url = 'NewComponent/data/EgNewServerJson.jsp?selectedServerGroup='+selectedCategory+"&server=new&serverType="+selectedCType;
										ctrler.getData(url,true);
									}
								}
							});
						}
					}
					else if (requestStatus=='success')
					{
						if (publicJSON.forward)
						{
							var forwardURL = publicJSON.forward_URL;
							var hiddenParams = publicJSON.hiddenValues;
							var me = Ext.getCmp('hiddenContnr');
							me.removeAll();
							Ext.suspendLayouts();
							for (var param in hiddenParams) {
									me.add({
										xtype: 'hidden',
										name: param,
										value: hiddenParams[param]
									});
							}
							Ext.resumeLayouts(true);
							forwardURL ="/final/admin/NewComponent/data/"+forwardURL;
							mainObj.forwardGivenURL(forwardURL);
						}
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					 tmpMask.hide();
					 switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
							break;
						case Ext.form.action.Action.SERVER_INVALID:
						   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
					}
				}
			});
		}
	},
	forwardGivenURL : function(forwardURL)
	{
		var parentWindow = window.parent;
		var resMsg = alertMsg34;
		if (currentAction == 'modify')
		{
			resMsg = alertMsg35;
		}
		var thisCtrl = this;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAddnewrumcomponent().submit({
				url: forwardURL,
				method: 'POST',
				timeout:120,
				//standardSubmit:true,
				success: function(form, action){
				tmpMask.hide();
				var resObj  = action.response.responseText;
				var publicJSON = Ext.decode(resObj);
				var requestStatus = publicJSON['requestStatus'];
				if(requestStatus == 'success')
				{
					if(fromTopology=='yes')
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: alertMsg42,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									parentWindow.closedManagedWindow();
								}
							}
						});
					}
					else
					{
						var cType = publicJSON.compType;
						cType = encodeURIComponent(cType);
						if(cType == 'Real_user_monitor')
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: resMsg,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function(response) {
									if(response == 'ok') {
										compName=Ext.getCmp('rumNickName').getValue();
										var cmpUrl=Ext.getCmp('rumCollectUrl').getValue();
										var newComp=compName;
										compName=compName+":NULL";
										if((rumCollectorCmp!=null && rumCollectorCmp!='' && (rumCollectorCmp!=cmpUrl)))
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: 'The RUM data collector for this component ('+newComp+') has been modified. Please download the agent file from this component and deploy it in the corresponding application.',
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation',
												fn: function(response) {
													if(response == 'ok') 
													{
														var strURL = "EgNewServer.jsp?server="+encodeURIComponent(compName)+"&serverType=Real_user_monitor&modifyserver=true&serverGategory=-1&fromWizard="+fromWizard
														if (fromAPP == 'wizard')
														{
															strURL += "&fromAPP="+fromAPP+'&wizCType='+encodeURIComponent(wizCType);

														}
														window.location.href = strURL;
													}
												}
											});
										}
										else
										{
											var strURL = "EgNewServer.jsp?server="+encodeURIComponent(compName)+"&serverType=Real_user_monitor&modifyserver=true&serverGategory=-1&fromWizard="+fromWizard;
											if (fromAPP == 'wizard')
											{
												strURL += "&fromAPP="+fromAPP+'&wizCType='+encodeURIComponent(wizCType);
											}
											window.location.href = strURL;
										}
									}
									else
									{
										Ext.getCmp('downloadLinkPanel').hide();
									}
								}
							});
						}
					}
				}
				else if (requestStatus == 'failed')
				{
					var resObj  = action.response.responseText;
					var publicJSON = Ext.decode(resObj);
					var requestStatus = publicJSON['requestStatus'];
					Ext.Msg.show({
						title:publicJSON.Error_Title,
						msg: alertMsg33 + '<br>' + publicJSON.Error_Info.Error_Msg_1 + '<br>' + publicJSON.Error_Info.Error_Msg_2,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								if(fromTopology=='yes')
								{
									parentWindow.closedManagedWindow();
								}
								else
								{
									if (fromAPP == 'wizard')
									{
										window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard+'&server='+encodeURIComponent(wizCType);
									}
									else
									{
										var url = '/final/admin/EgDispServer.jsp?&category=-1&comptype=-1&fromWizard='+fromWizard;
										window.location.href = url;
									}
								}
							}
						}
					});
				}
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				tmpMask.hide();
				 switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', alertMsg33+'. Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', alertMsg33+'. Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', alertMsg33+'. '+action.result.msg);
				}
			}
		});
	},
	javaDownload: function()
	{
		javaDownload();
	},
	dotnetDownload: function()
	{
		dotnetDownload();
	},
	rumUsernameChange : function()
	{
		var opt = Ext.getCmp('rumUsernameNo').getValue();
		var  intOpt = 'no';
		if(!opt)
		{
			intOpt = 'yes';
			
			Ext.getCmp('rumExpType').show();
			Ext.getCmp('rumExpType').enable();
			
			Ext.getCmp('rumApplyCleanUpGr').show();
			Ext.getCmp('rumApplyCleanUpGr').enable();
			
			var cleanUpRuleExists = Ext.getCmp('rumApplyCleanUpYes').getValue();
			
			if(cleanUpRuleExists)
			{
				Ext.getCmp('rumExtractionRule').enable();
				Ext.getCmp('rumExtractionRule').show();
			}
			
			rumLabelChange();
		}
		else
		{
			Ext.getCmp('rumExpType').hide();
			Ext.getCmp('rumExpType').disable();

			Ext.getCmp('rumSelectorPath').hide();
			Ext.getCmp('rumSelectorPath').disable();
			
			Ext.getCmp('rumSelectorPathIndex').hide();
			Ext.getCmp('rumSelectorPathIndex').disable();
						
			Ext.getCmp('rumApplyCleanUpGr').hide();
			Ext.getCmp('rumApplyCleanUpGr').disable();
			
			Ext.getCmp('rumExtractionRule').hide();
			Ext.getCmp('rumExtractionRule').disable();
			
		}
	},
	rumApplyCleanUpChange : function()
	{
		var opt = Ext.getCmp('rumApplyCleanUpNo').getValue();
		var  intOpt = 'no';
		if(!opt)
		{
			intOpt = 'yes';
			
			Ext.getCmp('rumExtractionRule').show();
			Ext.getCmp('rumExtractionRule').enable();
		}
		else
		{
			Ext.getCmp('rumExtractionRule').hide();
			Ext.getCmp('rumExtractionRule').disable();

		}
	},
	
	rumLabelChange : function()
	{
		rumLabelChange();
	},
	scriptDownload: function()
	{
		scriptDownload();
	}
});

function scriptDownload() 
{
	var compName = Ext.getCmp('rumNickName').getValue();
	window.location.href = 'NewComponent/data/newRUMServerJson.jsp?currentAction=modify&compName='+encodeURIComponent(compName)+'&download=true&javaDownload=false&dotnetDownload=false&com.eg.CSRF_NONCE='+csrfToken+"&fromWizard="+fromWizard;

}

function javaDownload()
{
	var compName = Ext.getCmp('rumNickName').getValue();
	window.location.href = 'NewComponent/data/newRUMServerJson.jsp?currentAction=modify&compName='+encodeURIComponent(compName)+'&download=false&javaDownload=true&dotnetDownload=false&com.eg.CSRF_NONCE='+csrfToken+"&fromWizard="+fromWizard;
}

function dotnetDownload()
{
	var compName = Ext.getCmp('rumNickName').getValue();
	window.location.href = 'NewComponent/data/newRUMServerJson.jsp?currentAction=modify&compName='+encodeURIComponent(compName)+'&download=false&javaDownload=false&dotnetDownload=true&com.eg.CSRF_NONCE='+csrfToken+"&fromWizard="+fromWizard;
}
function validateSingleUrl(paramValue)
{
	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;

	if (toMatch.test(paramValue))
	{
		return true;
	}
	else
	{
		return false;
	}
}
function validateRumIndex(paramValue)
{
	if (isNaN(paramValue) || paramValue < 0 )
	{
		return true;
	}
	else
	{
		return false;
	}
}

function validateIPv6Url(srcUrl)
{
	var idx = srcUrl.indexOf(":");
	if (idx == -1) // Not an URL
	{
		return false; 
	}
	tmpUrl = srcUrl.substring(idx+1);
	if (srcUrl.toLowerCase().startsWith("http"))
	{
		idx = srcUrl.indexOf("/");
		urlPrefix = srcUrl.substring(0,idx+2);
		tmpUrl = srcUrl.substring(idx+2);
	}
	var lastIndex = tmpUrl.lastIndexOf(":");
	if (lastIndex >=0)
	{
		tmpUrl = tmpUrl.substring(0,lastIndex);
	}
	if(checkIPv6(tmpUrl))
	{
		return true;
	}
	else
	{
		return false;
	}
}
function rumLabelChange()
{
	var newRumExpType= Ext.getCmp('rumExpType').getValue();
	if(newRumExpType == "Choose a selector expression")
	{
		Ext.getCmp('rumSelectorPath').disable();
		Ext.getCmp('rumSelectorPath').hide();
		
		Ext.getCmp('rumSelectorPathIndex').disable();
		Ext.getCmp('rumSelectorPathIndex').hide();
	}
	else if(newRumExpType == "CSS Selector" || newRumExpType == "DOM Locator" || newRumExpType == "XPath Locator")
	{
		Ext.getCmp('rumSelectorPath').enable();
		Ext.getCmp('rumSelectorPath').show();
		
		Ext.getCmp('rumSelectorPathIndex').enable();
		Ext.getCmp('rumSelectorPathIndex').show();
		
		if(newRumExpType == "CSS Selector")
		{
			Ext.getCmp('rumSelectorPath').setFieldLabel(label_rumCssSelectorPath);
			Ext.getCmp('rumSelectorPathIndex').setFieldLabel(label_rumCssSelectorPathindex);
		}
		if(newRumExpType == "DOM Locator")
		{
			Ext.getCmp('rumSelectorPath').setFieldLabel(label_rumDomSelectorPath);
			Ext.getCmp('rumSelectorPathIndex').setFieldLabel(label_rumDomSelectorPathindex);
		}
		if(newRumExpType == "XPath Locator")
		{
			Ext.getCmp('rumSelectorPath').setFieldLabel(label_rumXpathSelectorPath);
			Ext.getCmp('rumSelectorPathIndex').setFieldLabel(label_rumXpathSelectorPathindex);
		}
	}
}
