var originalShow = Ext.window.MessageBox.prototype.show;
Ext.override(Ext.window.MessageBox,{

	minWidth : 300,

	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar != '.' && lastChar != '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 8;
			Ext.applyIf(cfg,{width : tmpWidth});
		}
		originalShow.apply(this, arguments);
	},

	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar != '.' && lastChar != '?')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},

	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) 
		{
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.override(Ext.form.field.File,{
	listeners: {
		change: function(field, value) {
			if(value.indexOf("\\")> -1)
				filename = value.substring(value.lastIndexOf("\\")+1,value.length);
			else if(value.indexOf("/")> -1)
				filename = value.substring(value.lastIndexOf("/")+1,value.length);
			else
				filename = value;
			field.setRawValue(filename);
		}
	}
});

Ext.define('NewComponent.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'newcomponentview',

	requires: [
		'NewComponent.view.AddNewComponent',
		'NewComponent.view.AddNewNodeComponent',
		'utilities.ScrollCombo'
	],

	initComponent: function() {

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}
		var addXtype = '';
		if(serverType == 'Real_user_monitor')
		{
			addXtype = 'addnewrumcomponent';
		}
		else if(serverType == 'NodeJS')
		{
			addXtype = 'addnewnodecomponent';
		}
		else
		{
			addXtype = 'addnewcomponent';
		}
		this.items = [
			{
				xtype: addXtype
			}
		];

		this.callParent();
	},
	listeners: {
		afterrender:function()
		{
				if (!Ext.isEmpty(initiate))
				{
					Ext.getCmp('backButton').hide();
				}
				else
				{
					Ext.getCmp('backButton').show();
				}
		},
		'beforerender': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				if(serverType == 'Real_user_monitor')
				{
					Ext.getCmp('addnewrumcomponent').isWizard=(true);
					if (!Ext.isEmpty(initiate))
					{
						Ext.getCmp('addnewrumcomponent').closable= true;
					}
				}
				else
				{
					Ext.getCmp('addnewcomponent').isWizard=(true);
					if (!Ext.isEmpty(initiate))
					{
						Ext.getCmp('addnewcomponent').closable= true;
					}
				}
			}
		},
		'beforeadd': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				if(serverType == 'Real_user_monitor')
				{
					if (!Ext.isEmpty(Ext.getCmp('addnewrumcomponent')))
					{
						Ext.getCmp('addnewrumcomponent').isWizard=(true);
					}
				}
				else
				{
					if (!Ext.isEmpty(Ext.getCmp('addnewcomponent')))
					{
						Ext.getCmp('addnewcomponent').isWizard=(true);
					}
				}
			}
		}
	}

});



