
Ext.define('NotificationManager.controller.Main',{
	extend:'Ext.app.Controller',
	views : ['Main','ErrorPage'],
	refs: [
		{selector:'main',ref:'main'},
	],
	init: function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main button[id="back"]':
			{
				'click':this.historyBack
			},
		});
	},
	buildMainData : function()
	{
		if (type == "1" || type == "6")
		{
			this.getNotReportingAgentsInfo();
		}
		else if (type != "5")
		{
			Ext.Ajax.request({
				url : 'NotificationManager/data/EgViewManagerNotificationDetailsJson.jsp?type='+type,
				method : 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			});
		}
	},
	historyBack : function()
	{
		if (clsTrial != null && clsTrial == "Yes")
		{
			window.location.href = "/final/portal/LogonSimulator.jsp?from=login";
		}
		else
		{
			window.location.href = "/final/admin/EgAdminOperations.jsp?from=dashboard";
		}
	},
	afterMainRender : function()
	{
		var gridObj = Ext.getCmp('agentReporting');
		var discoveredcompsummary = Ext.getCmp('discoveredcompsummary');
		var unconfiguredAgentSummary = Ext.getCmp('unconfiguredAgentSummary');
		var oracleSIDConfiguration = Ext.getCmp('oracleSIDConfiguration');
		gridObj.hide();
		discoveredcompsummary.hide();
		unconfiguredAgentSummary.hide();
		oracleSIDConfiguration.hide();
		if (type == "1")
		{
			gridObj.getStore().loadRawData(publicJSON.agentsGrid);
			gridObj.setTitle(publicJSON.notReportingAgentsCount);
			gridObj.show();
			Ext.getCmp('main').setTitle(intnlMessage29);
		}
		else if (type == "2")
		{
			discoveredcompsummary.getStore().loadRawData(publicJSON.groupingGridArr);
			discoveredcompsummary.show();
			discoveredcompsummary.setTitle(publicJSON.totalDiscoveredComponents);
			Ext.getCmp('main').setTitle(intnlMessage26);
		}
		else if (type == "3")
		{
			unconfiguredAgentSummary.getStore().loadRawData(publicJSON.unconfiguredAgents);
			unconfiguredAgentSummary.setTitle(publicJSON.totalAgents);
			unconfiguredAgentSummary.show();
			Ext.getCmp('main').setTitle(intnlMessage25);
		}
		else if (type == "4")
		{
			Ext.getCmp('main').setTitle(intnlMessage31);
			oracleSIDConfiguration.show();
			Ext.getCmp('oraNoSidInfo').getStore().loadRawData(publicJSON.oraGridData);
		}
		else if (type == "6")
		{
			gridObj.getStore().loadRawData(publicJSON.agentsGrid);
			gridObj.setTitle(publicJSON.notInstalledAgentsCount);
			gridObj.show();
			Ext.getCmp('time').hide();
			Ext.getCmp('main').setTitle(intnlMessage32);
		}
	},
	startupActivities : function(showActivity)
	{
		if (showActivity)
		{
			var activityWindow = Ext.create('Ext.window.Window',{
				id : 'activityWindow',
				frame : true,
				title : 'Manager Notification',
				floating : true,
				items : [
					{
						xtype : 'container',
						flex : 1,
						html : "<div style='text-align:left;font-size:11px;width:350px;margin:10 10 5 10; background-color: #FEEFB3;border:red 1px solid;padding:5px;'><div><img src='/final/admin/eg_images/eg_warning.gif'/></div><div style='margin:4px 4px'>The following components have not been configured for agentless monitoring</div></div><div style='text-align:left;font-size:11px;width:350px;margin:5 10 10 10; background-color: #FEEFB3;border:red 1px solid;padding:5px;'><div><img src='/final/admin/eg_images/eg_warning.gif'/></div><div style='margin:4px 4px'>The following components have not been configured for agentless monitoring</div></div>"
					}
				]
			});
			activityWindow.setPosition(Ext.getCmp('homepanel').getWidth() - 430,30);
			activityWindow.show();
		}
	},
	showManagerTasks : function()
	{
		if (Ext.getCmp('mgrTaskWindow') == undefined || Ext.getCmp('mgrTaskWindow') == null)
		{
			Ext.widget('window',{
				id : 'mgrTaskWindow',
				title : 'Manager Tasks',
				width : 600,
				height: 500,
				closeAction: 'destroy',
				doClose: function() {
					this.destroy();
				},
			}).show();
		}
	},
	showManagerNotifications : function()
	{
		if (Ext.getCmp('mgrNotificationWindow') == undefined || Ext.getCmp('mgrNotificationWindow') == null)
		{
			Ext.widget('window',{
				id : 'mgrNotificationWindow',
				title : 'Notifications',
				width : 600,
				height: 500,
				closeAction: 'destroy',
				doClose: function() {
					this.destroy();
				},
			}).show();
		}
	},
	updateDeferText : function(ct, column, e, t, eOpts)
	{
		var tmpStore = Ext.getCmp('unconfiguredTestsSummary').getStore();
		if (tmpStore.getCount() == 0)
		{
			var deferMessageObj = Ext.select("#deferMessage");
			if (deferMessageObj != null && deferMessageObj != undefined)
			{
				if (unconfigComponentState == "allconfigured")
				{
					deferMessageObj.update(intnlMessage14);
				}
				else
				{
					deferMessageObj.update(intnlMessage15);
				}
			}
		}
	},
	getNotReportingAgentsInfo : function()
	{
		Ext.Ajax.request({
			url : 'NotificationManager/data/EgAgentsNotRunningDetailsJson.jsp',
			method : 'POST',
			async : false,
			params: {
				'type':type
			},
			success: function(response)
			{
				publicJSON = Ext.decode(response.responseText);
			}
		});
	},
	searchOnChange : function(obj)
	{
		this.searchAgents(obj.getValue());
	},
	searchAgents : function(strValue)
	{
		var url1 = "";
		if (strValue == null || strValue=="" || strValue.length == 0)
		{
			url1 = "NotificationManager/data/EgAgentsNotRunningDetailsJson.jsp";
		}
		else if(strValue != null)
		{
			url1 = "NotificationManager/data/EgAgentsNotRunningDetailsJson.jsp?egTitleSearchStr="+encodeURI(strValue);
		}

		Ext.Ajax.request({
			url : url1,
			method : 'POST',
			success: function(response)
			{
				var agentsInfo = Ext.decode(response.responseText);
				var gridObj = Ext.getCmp('agentReporting');
				gridObj.getStore().loadRawData(agentsInfo.agentsGrid);
				Ext.getCmp('displayMessage7').setValue(agentsInfo.notReportingAgentsCount);
			}
		});
	},
	modifyOracleComponent: function (compName)
	{
		if (compName.indexOf(":") < 0)
		{
			compName += ":NULL";
		}
		compName = encodeURIComponent(compName);
		var url = "EgNewServer.jsp?server="+compName+"&serverType=Oracle_server&modifyserver=true&serverGategory=-1&fromAPP=NotificationManager&requestType=4";
		window.location.href = url;
	},
	manageComponent : function()
	{
		window.location.href = "EgConfigEnv.jsp?reqfrom=managerNofification&type=4&srvtype=Oracle_server";
	}
});

function loadURL(activity, actionType,rowIndex,store)
{
	if (activity == "component")
	{
		if (actionType == "agg")
		{
			var server = Ext.getCmp('aggView').getStore().getAt(rowIndex).get("hiddenColumn");
			window.location.href = "/final/admin/EgAggregateTree.jsp?qctr=1&server="+encodeURIComponent(server)+"&reqfrom=home";
		}
		else
		{
			var server = Ext.getCmp('componentView').getStore().getAt(rowIndex).get("hiddenColumn");
			window.location.href = "/final/admin/EgDispServer.jsp?qctr=1&server="+encodeURIComponent(server)+"&reqfrom=home";
		}
	}
	else if (activity == "tests")
	{
		var componentType = Ext.getCmp('unconfiguredTestsSummary').getStore().getAt(rowIndex).get("hiddenColumn");
		var uri ="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType="+encodeURIComponent(componentType)+"&showTestType="+actionType;
		window.location.href = uri;
	}
	else if (activity == "agents")
	{
		var uri = "";
		if (actionType == "" || actionType.length == 0)
		{
			uri = "/final/admin/EgServerList.jsp?agent=PremiumAgents&reqfrom=home";
		}
		else
		{
			var agent =  Ext.getCmp('agentSummary').getStore().getAt(rowIndex).get("hiddenColumn");
			uri = "/final/admin/EgServerList.jsp?agent="+agent+"&reqfrom=home&status="+actionType;
		}
		window.location.href = uri;
	}
}

function addComponent(actualName,ip,hostname,port,localname)
{
	var url ="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+encodeURIComponent(ip)+"&hostname="+encodeURIComponent(hostname)+"&discPort="+port+"&fromHomePopup=yes&requestType=2&fromAPP=NotificationManager";
	window.location.href = url;
}

function loadConfigPage(server)
{
	var actualServerName = server.substring(server.indexOf("#$#")+3);
	actualServerName = actualServerName.substring(0,actualServerName.indexOf("#$#"));
	window.location.href = "EgConfigEnv.jsp?reqfrom=managerNofification&srvtype="+encodeURIComponent(actualServerName);
}

function loadUserSummaryDetails(row)
{
	var userStore = Ext.getCmp('userSummaryDetails').getStore();
	var userType = userStore.getAt(row).get("hiddenColumn");
	window.location.href = "EgDispUserSites.jsp?expiry="+userType+"&reqfrom=home";
}



