var action = "";
var componentRawData="";
Ext.define('PasswordProfiles.controller.Main',{
	extend:'Ext.app.Controller',
	views:['PasswordProfilesView'],
	requires:['PasswordProfiles.view.PasswordProfilesView'],
	requires:['PasswordProfiles.view.EgConfigurePasswordProfile'],
	refs:[
		{selector:'passwordprofilesview', ref:'passwordprofilesview'},
		{selector:'egconfigurepasswordprofile', ref:'egconfigurepasswordprofile'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData();
		this.control({
			'passwordprofilesview':
			{
				'boxready': this.afterMainRender
			},
			'passwordprofilesview button[id="addButton"]':
			{
				'click':this.addNewPwdProfile
			},
			'egconfigurepasswordprofile button[id="addMoreBtn"]': 
			{
				'click': this.addMorePwdProfile
			},
			'egconfigurepasswordprofile button[id="clearPwdProfile"]': 
			{
				'click': this.clearPwdProfiles
			},
			'egconfigurepasswordprofile button[id="updatePwdProfile"]': 
			{
				'click': this.updatePwdProfiles
			},
			'passwordprofilesview trigger[id="searchBox"]':
			{
				'change': this.searchComponent
			}

		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'PasswordProfiles/data/EgPasswordProfiles.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					componentRawData = publicJSON['pwdProfileDetails'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		Ext.getCmp('pwdProfsGrid').getStore().clearFilter(true);
		Ext.getCmp('pwdProfsGrid').getStore().loadRawData(publicJSON['pwdProfileDetails']);
		var isProfilesConfigured = publicJSON['isProfilesConfigured'];
		if (isProfilesConfigured)
		{
			Ext.getCmp('searchBox').setDisabled(false);
			Ext.getCmp('pwdProfsGrid').getSelectionModel().deselectAll(true);
		}
		else
		{
			Ext.getCmp('searchBox').setDisabled(true);
		}
	},
	addNewPwdProfile: function(btn) 
	{  //Config Multiple Pwd profile
		Ext.widget('egconfigurepasswordprofile').show();
		action = "add";

		var multidom = '';
		inputsmulti ++;
		ismulti = 'false';

	},
	clearPwdProfiles: function(btn) 
	{
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addMoreBtn').setText('Add');
		Ext.getCmp('NoMultiUsrPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updatePwdProfile').disable();
		Ext.getCmp('clearPwdProfile').disable();
	},
	updatePwdProfiles: function(btn) 
	{
		var isValidData = true;
	//	var arrUserNames = new Array();
		var isNewProfile = publicJSON.isNewProfile;
		var profileName = Ext.getCmp('profileName').getValue();

		if(!checkblank(profileName))
		{
			Ext.Msg.show({
				title: configPwdProfTitle,
				msg: enterProfile,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('profileName').focus(true,true);
				}
			});
			isValidData = false;
			return;
		}
		else if (profileName.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: configPwdProfTitle,
				msg: _checkdots,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('profileName').focus(true,true);
				}
			});
			isValidData = false;
			return;
		}
		//else if (!checkSpecial(profileName,"@*+=|:;\"\'<>\/[]?,"))
		else if (!checkSpecial(profileName,"`~!@#$%^&*()+={}[]|\\:;\"\'<,?\/"))
		{
			Ext.Msg.show({
				title: configPwdProfTitle,
				msg: _checkspecial,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function()
				{
					Ext.getCmp('profileName').focus(true,true);
				}
			});
			isValidData = false;
			return;
		}
		else if (profileName.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: configPwdProfTitle,
				msg: _checkSpaces,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('profileName').focus(true,true);
				}
			});
			isValidData = false;
			return;
		}

		if (isNewProfile)
		{
			var existProfNames = publicJSON.existProfNames;
			if (existProfNames != 'undefined' && existProfNames != null && existProfNames.length > 0)
			{
				var myProfArr = existProfNames.split(",");
				for (i=0;i<myProfArr.length;i++)
				{
					if(myProfArr[i].toLowerCase() == profileName.toLowerCase())
					{
						Ext.Msg.show({
							title: configPwdProfTitle,
							msg: duplicateProfileNtAlwd+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('profileName').focus(true,true);
							}
						});
						isValidData = false;
						return;
					}
				}
			}
			
		}

		var multiinputs = inputsmulti;
		for (var mul=1;mul<multiinputs;mul++)
		{
			if (Ext.getCmp('domain'+mul) == undefined)
			{
				continue;
			}

			var domain = Ext.getCmp('domain'+mul).getValue();
			var uname = Ext.getCmp('user'+mul).getValue();
			var pass = Ext.getCmp('pwd'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwd'+mul).getValue();

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('user'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('user'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (!checkSpecial(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('user'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('user'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('user'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}

		//	var x_idx = arrUserNames.indexOf(uname);
		//	if (x_idx != -1)
		//	{
		//		Ext.Msg.show({
		//			title: configPwdProfTitle,
		//			msg: duplicateNtAlwd,
		//			buttons: Ext.Msg.OK,
		//			icon: 'iconExclamation',
		//			fn: function() {
		//				Ext.getCmp('user'+mul).focus(true,true);
		//			}
		//		});
		//		return;
		//	}
		//	arrUserNames[mul] = uname;

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}

			if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (domain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}

			if(pass == "")
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwd'+mul).focus(true,true);
				isValidData = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: configPwdProfTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwd'+mul).focus(true,true);
					}
				});
				isValidData = false;
				return;
			}
		}

		if (isValidData)
		{
			var multiProfileVal = "";

			for(var mulusr=1; mulusr<multiinputs; mulusr++)
			{
				if (Ext.getCmp('domain'+mulusr) == undefined)
				{
					continue;
				}

				var multidomain= Ext.getCmp('domain'+mulusr).getValue();
				if(Ext.isEmpty(multidomain) || multidomain == null) 
				{
					multidomain = "none";
				}
				var multiUname = Ext.getCmp('user'+mulusr).getValue();
				if(Ext.isEmpty(multiUname) || multiUname == null) 
				{
					multiUname = "none";
				}
				var multipass = Ext.getCmp('pwd'+mulusr).getValue();
				var multiconfpasswd = Ext.getCmp('confpwd'+mulusr).getValue();

				if(Ext.isEmpty(multipass) || multipass == null) 
				{
					multipass = "none";
					multiconfpasswd = "none";
				}
				
				if(multidomain != null && multiUname != null && multipass != null && multiconfpasswd != null )
				{
					var tmpVal = multiUname+"~Hash~"+multipass+"~Hash~"+multidomain;
					multiProfileVal = multiProfileVal+tmpVal+"|";
				}
			}

			var endsWithSep = multiProfileVal.lastIndexOf("|");
			if ( (multiProfileVal.length - 1) == endsWithSep)
			{
				multiProfileVal = multiProfileVal.substring(0,endsWithSep);
			}

			var urlStr = 'PasswordProfiles/data/EgPasswordProfilesp.jsp?action='+action+'&profName='+profileName;
			Ext.Ajax.request({
				url: urlStr,
				params: {
					'password': multiProfileVal
				},
				method:'POST',
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						resultJson = Ext.decode(jsonText);
						Ext.Msg.show({
							title: configPwdProfTitle,
							msg: resultJson.Result,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('egconfigurepasswordprofile').destroy();
								ctrler.buildMainData();
								ctrler.afterMainRender();
							}
						});
					}

				},
				failure: function()
				{

				}
			});
		}
		
	},
	showModifyProfileWindow: function(grid, rowIndex, colIndex)
	{
		action = "modify";
		Ext.widget('egconfigurepasswordprofile').show();
		inputsmulti = 2;

		var obj = grid.getStore().getAt(rowIndex);
		var profName = obj.get('PwdProfName');
		var urlStr = 'PasswordProfiles/data/EgPasswordProfiles.jsp?profName='+profName;
		Ext.Ajax.request({
			url: urlStr,
			method: 'POST',
			//async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					var selectedProfileValue = publicJSON.selectedProfileValue; 
					Ext.getCmp('profileName').setValue(profName);
					Ext.getCmp('profileName').setReadOnly(true);
					var existDatas = new Array();
					if (!Ext.isEmpty(selectedProfileValue))
					{
						existDatas = selectedProfileValue.split("|");
						Ext.suspendLayouts();
						for (var k =0;k<existDatas.length-1;k++ )
						{
							ctrler.addMorePwdProfile();
						}
						Ext.resumeLayouts(true);

						for (m=1;m<existDatas.length+1;m++)
						{
							var strPwdProfile = existDatas[m-1];
							var splitDetails = strPwdProfile.split("~Hash~");
							var usrName = splitDetails[0];
							var password = "";
							var domainName = "";
							// A profile may not have all 3(user name, pwd, domain) values
							if (splitDetails.length > 1)
							{
								password = splitDetails[1];
							}
							if (splitDetails.length > 2)
							{
								domainName = splitDetails[2];
							}
							var splituser = strPwdProfile.split("~Hash~");
							var splitpass = strPwdProfile.split("~Hash~");

							Ext.getCmp('domain'+m).setValue(domainName);
							Ext.getCmp('user'+m).setValue(usrName);
							Ext.getCmp('pwd'+m).setValue(password);
							Ext.getCmp('confpwd'+m).setValue(password);
						}
					}
				}
			}
		});

	},
	modifyProfile: function(profName)
	{
		var userName = Ext.getCmp('usrName').getValue();
		var password = Ext.getCmp('pwd').getValue();
		var domainName = Ext.getCmp('domainName').getValue();
		
		var urlStr = 'PasswordProfiles/data/EgPasswordProfilesp.jsp?action=modify&userName='+userName+'&pwd='+password+'&domain='+domainName+'&profName='+profName;

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	addMorePwdProfile: function() 
	{
		if (inputs == totalInputs)
		{
			Ext.Msg.show({
				title: configPwdProfTitle,
				msg: limitedLevel,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var mainForm = Ext.getCmp('egconfigurepasswordprofile');
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		var conIdMulti = "conmulti_"+inputsmulti
		var tmpMultiContainer = {
			xtype : 'fieldset',
			id : conIdMulti,
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeMultiContact(conIdMulti);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:120
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Domain,
							id:'domain'+inputsmulti,
							value: 'none',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							id:'user'+inputsmulti,
							value: 'none',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: PasswordLbl,
							id:'pwd'+inputsmulti,
							inputType: 'password',
							value: 'none',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: CnfPassLbl,
							id:'confpwd'+inputsmulti,
							inputType: 'password',
							value: 'none',
							columnWidth: 0.5
						}
					]
				}
			]
		}
		backupmulticontainer.add(tmpMultiContainer);
		mainForm.doLayout();
		inputsmulti++;
		Ext.getCmp('addMoreBtn').setText('Add More');
		Ext.getCmp('updatePwdProfile').enable();
		Ext.getCmp('clearPwdProfile').enable();
		Ext.getCmp('NoMultiUsrPattern').hide();
	},
	deleteComponent: function(grid, rowIndex, colIndex)
	{
		grid = Ext.getCmp('pwdProfsGrid');
		var DispValues = grid.getStore().getAt(rowIndex);
		var deleteProfName = DispValues.get('PwdProfName');
		var isActiveProfile = DispValues.get('isActiveProfile');
		var confirmMsg = deleteConfirmAlert+" '"+deleteProfName+"' ?";
		if (isActiveProfile)
		{
			confirmMsg = deleteActiveProfileAlert+". "+ deleteConfirmAlert+" '"+deleteProfName+"' ?";
		}

		Ext.Msg.show({
			title: configPwdProfTitle,
			msg: confirmMsg,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					Ext.Ajax.request({
						url:'PasswordProfiles/data/EgPasswordProfilesp.jsp?action=delete&profName='+deleteProfName,
						method:'POST',
						async : false,
						scope:this,
						success:function(response)
						{
							Ext.Msg.show({
								title: configPwdProfTitle,
								msg: alert1,
								buttons: Ext.Msg.OK,
								//width: alert1.length * 7,
								icon: 'iconInformation',
								fn: function() {
									ctrler.buildMainData();
									ctrler.afterMainRender();
								}
							});
						}
					});
				}
			}
		});
	},
	searchComponent : function()
    {
		var compStore = componentRawData;
		var compObj = Ext.getCmp('pwdProfsGrid');
		var findVal = Ext.getCmp('searchBox').getValue();

		if ( Ext.isEmpty( findVal) || findVal == undefined )
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');

			Ext.getCmp('pwdProfsGrid').show();
			compObj.getStore().loadRawData(compStore);
			Ext.getCmp('pwdProfsGrid').getSelectionModel().deselectAll(true);
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');

			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['PwdProfName', 'UserName', 'DomainName','isActiveProfile'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['PwdProfName'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'PwdProfName': compStore[i]['PwdProfName'],
						'UserName': compStore[i]['UserName'],
						'isActiveProfile': compStore[i]['isActiveProfile'],
						'DomainName': compStore[i]['DomainName']
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
				Ext.getCmp('pwdProfsGrid').getSelectionModel().deselectAll(true);
				Ext.getCmp('pwdProfsGrid').show();
			}
			else
			{
				compObj.getStore().removeAll();
				Ext.getCmp('pwdProfsGrid').store.loadData('');
				Ext.getCmp('pwdProfsGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoProfNameSearch+'.</td></tr></table></td></tr></table>';
				Ext.getCmp('pwdProfsGrid').getView().refresh();
			}
		}
	}


});


function removeMultiContact(containerID) 
{
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismulti = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addMoreBtn').setText('Add');
		if (ismulti == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('updatePwdProfile').disable();
			Ext.getCmp('clearPwdProfile').disable();
		}
	}
}

function checkSpecial(field,s_spl)
{
	obj_val = field;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

