Ext.define('PasswordProfiles.view.PasswordProfilesView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.passwordprofilesview',
	cls:'outerpanel',
	margin :'8 8 0 8',
	frame:true,
	title: pageTitle,
	header:{cls:'textUpper'},

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems:[
		{
			xtype:'toolbar',
			dock:'top',
			cls:'adminHeadInfoText',
			layout:{pack:'center'},
			height: 25,
			border:true,
			padding: 3,
			items:[
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle">&nbsp;'+pageDesc+'</center>',
				}
			]
		}
	],

	items: [
		{
			xtype: 'customgrid',
			id:'pwdProfsGrid',
			store: new Ext.data.Store({
				fields: ['PwdProfName', 'UserName', 'DomainName','isActiveProfile'],
				data : []
			}),
			autoScroll: true,
			flex: 1,
			cls:'gridSkin',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: pfLbl,
						dataIndex: 'PwdProfName',
						width: 250
					},
					{
						text: usrLbl,
						dataIndex: 'UserName',
						flex:1
					},
					{
						text: domainLbl,
						dataIndex: 'DomainName',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls:'iconModify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.showModifyProfileWindow(grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+label_Modify+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						//iconCls: 'iconDelete',
						sortable: false,
						//handler: function(grid, rowIndex, colIndex) {
							//ctrler.deleteComponent(grid, rowIndex, colIndex);
						//},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+label_Delete+"' data-qclass='yellowTip'";
							var isActive = store.getAt(row).get("isActiveProfile");
							if(isActive)
							{
								return '<div class="iconDeleteDisabled"></div>';
							}
							else
							{
								return "<div style='cursor:pointer' onclick=\"javascript:ctrler.deleteComponent('"+record+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
							}
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					id: 'searchBox',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls: 'whitedropdown_search',
					emptyText: 'Search',
					disabled: true,
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function()
					{
						this.reset();
					},
					onTrigger2Click: function()
					{
						ctrler.searchComponent();
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items: [
						{
							xtype: 'button',
							cls:'button20',
							text: addProfile,
							id: 'addButton',
							name: 'addButton'
						},
					]
				}
			],
			emptyText: emptyGridMsg,
			viewConfig: {
				deferEmptyText: false
			}
		}
	]

});



