<%
/*
 * This page loads all password profiles related details
 */
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	rootJSON.put("isNewProfile",true);
	JSONArray profDetails = new JSONArray();
	EgPwdProfile pwdProf = new EgPwdProfile();

	IniFile pwdProfIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_pwdprofile.ini");
	String pwdPrfSub = "Password_Profiles";
	String profName= request.getParameter("profName"); 
	if (profName != null && profName.length() > 0) 
	{
		rootJSON.put("isNewProfile",false);

		String value = pwdProfIni.getValue(pwdPrfSub, profName);
		if (!com.egurkha.util.StringUtils.isNull(value)) 
		{
			if ( value.indexOf("|") != -1)
			{
				ArrayList multiEntryProfile = StringUtils.egTokenizer(value,"|");
				int tokens = multiEntryProfile.size();
				if (multiEntryProfile != null && multiEntryProfile.size() > 0)
				{
					ArrayList tmpList = new ArrayList();
					for (int m=0;m<multiEntryProfile.size();m++)
					{
						String strValue = (String) multiEntryProfile.get(m);
						if (com.egurkha.util.StringUtils.isNull(strValue))
						{
							continue;
						}

						ArrayList profileDatas = StringUtils.egTokenizer(strValue,"~Hash~");
						int toknsSize = profileDatas.size();
						String userName = profileDatas.get(0).toString();
						String password = "none";
						String domainName = "none";
						if (toknsSize > 1)
						{
							password = EgCrypt.decrypt(profileDatas.get(1).toString());
						}
						if (toknsSize > 2)
						{
							domainName = profileDatas.get(2).toString();
						}
						strValue = userName+"~Hash~"+password+"~Hash~"+domainName;
						tmpList.add(strValue);
					}

					if (tmpList != null && tmpList.size() > 0)
					{
						value = getIniProfileFormat(tmpList);
					}
				}
			}
			else
			{
				ArrayList profileEntry = StringUtils.egTokenizer(value,"~Hash~");
				int toknsSize = profileEntry.size();
				String userName = profileEntry.get(0).toString();
				String password = "none";
				String domainName = "none";
				// A profile may not have all 3(user name, pwd, domain) values
				if (toknsSize > 1)
				{
					password = EgCrypt.decrypt(profileEntry.get(1).toString());
				}
				if (toknsSize > 2)
				{
					domainName = profileEntry.get(2).toString();
				}

				value = userName+"~Hash~"+password+"~Hash~"+domainName;
			}
		}
		rootJSON.put("selectedProfileValue",value);
	}
	else
	{
		rootJSON.put("isProfilesConfigured",false);
		JSONObject jsObj = new JSONObject();
		String[] pwdPfs = pwdProfIni.getVariables(pwdPrfSub);
		if(pwdPfs != null)
		{
			ArrayList existProfileNames = new ArrayList();

			for(int i = 0; i < pwdPfs.length; i++)
			{
				String pwdID = pwdPfs[i];
				String value = pwdProfIni.getValue(pwdPrfSub,pwdID);
				jsObj = new JSONObject();
				jsObj.put("PwdProfName",pwdID);
				existProfileNames.add(pwdID);
				
				if (!com.egurkha.util.StringUtils.isNull(value)) 
				{
					String userName = "";
					String domainName = "";

					if ( value.indexOf("|") != -1)
					{
						ArrayList multiEntryProfile = StringUtils.egTokenizer(value,"|");
						int tokens = multiEntryProfile.size();
						if (multiEntryProfile != null && multiEntryProfile.size() > 0)
						{
							ArrayList tmpList = new ArrayList();
							for (int m=0;m<multiEntryProfile.size();m++)
							{
								String strValue = (String) multiEntryProfile.get(m);
								if (com.egurkha.util.StringUtils.isNull(strValue))
								{
									continue;
								}

								ArrayList profileDatas = StringUtils.egTokenizer(strValue,"~Hash~");
								int toknsSize = profileDatas.size();
								String tmpUsrName = (String) profileDatas.get(0);
								String tmpDomName = "none";
								if (com.egurkha.util.StringUtils.isNull(tmpUsrName))
								{
									tmpUsrName = "none";
								}
								if (toknsSize > 2)
								{
									tmpDomName = profileDatas.get(2).toString();
								}
								userName = userName + tmpUsrName + ",";
								domainName = domainName + tmpDomName + ",";
							}
						}
					}
					else
					{
						ArrayList profileEntry = StringUtils.egTokenizer(value,"~Hash~");
						int toknsSize = profileEntry.size();
						userName =  (String) profileEntry.get(0);
						domainName = "none";
						if (toknsSize > 2)
						{
							domainName = profileEntry.get(2).toString();
						}
					}

					if (!com.egurkha.util.StringUtils.isNull(userName) && userName.endsWith(","))
					{
						userName = userName.substring(0,userName.length()-1);
					}

					if (!com.egurkha.util.StringUtils.isNull(domainName) && domainName.endsWith(","))
					{
						domainName = domainName.substring(0,domainName.length()-1);
					}

					boolean isActiveProfile = pwdProf.isActiveProfile(pwdID);
					jsObj.put("UserName",userName);
					jsObj.put("DomainName",domainName);
					jsObj.put("isActiveProfile",isActiveProfile);
				}
				profDetails.add(jsObj);
			}

			if (existProfileNames != null && existProfileNames.size() > 0)
			{
				String tmpProfName = com.egurkha.util.StringUtils.getString(existProfileNames);
				rootJSON.put("existProfNames",tmpProfName);
			}
		}

		if (profDetails != null && !profDetails.isEmpty())
		{
			rootJSON.put("isProfilesConfigured",true);
		}
		rootJSON.put("pwdProfileDetails",profDetails);
	}

	out.println(rootJSON);

%>


<%!

private String getIniProfileFormat(ArrayList tmpList)
{
	String resultStr = "";
	for (int r=0;r<tmpList.size();r++)
	{
		String tmpData = (String) tmpList.get(r);
		if (r == 0)
		{
			resultStr = tmpData+"|";
		}
		else
		{
			resultStr = resultStr + tmpData +"|";
		}
	}
	if (!com.egurkha.util.StringUtils.isNull(resultStr) && resultStr.endsWith("|"))
	{
		resultStr = resultStr.substring(0,resultStr.length()-1);
	}
	return resultStr;
}
%>