<%
/*
 * This page works as process file
 */
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Password Profiles");
	
	String profileName = request.getParameter("profName");
	String action = request.getParameter("action");
	String value = request.getParameter("password");
	String pwdPrfSub = "Password_Profiles";
	String delim = "~Hash~";
	String pwdProfFile = EgConfigInfo.egMgrConfigDir+"eg_pwdprofile.ini";
	IniFile pwdProfIni = new IniFile(pwdProfFile);
	String prevVal4Audit = "";
	

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	EgPwdProfile pwdProf = new EgPwdProfile();
	egurkha.ServiceBean servicer = new egurkha.ServiceBean();

	if (action.equals("add") || action.equals("modify"))
	{
		//pwdProf.updateProfile(profileName, userName, password, domainName);

		pwdProf.updateProfiles(profileName, value);
		rootJSON.put("successUpdate","true");

		if (action.equals("modify"))
		{
			prevVal4Audit = pwdProfIni.getValue(pwdPrfSub,profileName);
			pwdProf.updateTestParamsInAgentsIni(profileName); //Updating agents.ini if the profile has any specific configuration
			boolean specsUpdated = pwdProf.updateTestParamsInSpecsIni(profileName); //Updating specs.ini if the profile has any default configuration
			if(specsUpdated) // If specs has any changes, then have to rebuild the eg_agents.ini
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				servicer.stopDiscovery();
				servicer.startDiscovery("1");
				EgConfigFilesSync.releaseInstance(infraIni);
			}
		}

		if (action.equals("add"))
		{
			rootJSON.put("Result","The password profile has been added successfully");
			auditLogThread.setValue("Activity","Add Password Profile");
			auditLogThread.setValue("Description","The password profile \""+profileName+"\" has been added successfully.");

		}
		else
		{
			rootJSON.put("Result","The password profile has been updated successfully");
			auditLogThread.setValue("Activity","Modify Password Profile");
			auditLogThread.setValue("Description","The password profile \""+profileName+"\" has been modified successfully.");
			
			StringTokenizer stt = new StringTokenizer(prevVal4Audit,"|");
			String prevVals = "";
			while(stt.hasMoreTokens())
			{
				String profInfo = stt.nextToken();
				ArrayList profVals = StringUtils.egTokenizer(profInfo,delim);
				String tmpStr = "";
				for (int p=0; p<profVals.size(); p++)
				{
					if (p==1)
					{
						tmpStr += " **** /";
					}
					else
					{
						tmpStr += " "+profVals.get(p).toString()+" /";
					}
				}
				if (tmpStr.endsWith("/")) tmpStr = tmpStr.substring(0,tmpStr.length()-1);
				prevVals += tmpStr+",";
			}
			if (prevVals.endsWith(",")) prevVals = prevVals.substring(0,prevVals.length()-1);
			auditLogThread.setPreviousValue("User Credentials (User / Password / Domain)",prevVals);

			stt = new StringTokenizer(value,"|");
			String currVals = "";
			while(stt.hasMoreTokens())
			{
				String profInfo = stt.nextToken();
				ArrayList profVals = StringUtils.egTokenizer(profInfo,delim);
				String tmpStr = "";
				for (int p=0; p<profVals.size(); p++)
				{
					if (p==1)
					{
						tmpStr += " **** /";
					}
					else
					{
						tmpStr += " "+profVals.get(p).toString()+" /";
					}
				}
				if (tmpStr.endsWith("/")) tmpStr = tmpStr.substring(0,tmpStr.length()-1);
				currVals += tmpStr+",";
			}
			if (currVals.endsWith(",")) currVals = currVals.substring(0,currVals.length()-1);

			auditLogThread.setCurrentValue("User Credentials (User / Password / Domain)",currVals);
		}

		auditLogThread.sendItToDB();
	}
	else if (action.equals("delete"))
	{
		ArrayList allSubjects = new ArrayList();
		ArrayList allDefaultVars = new ArrayList();

		pwdProf.deleteProfile(profileName); // deleted profile entry line

		ArrayList tmpSubjects = pwdProf.getAllDefaultConfigurationSubjects();
		if (tmpSubjects != null && tmpSubjects.size() > 0)
		{
			allSubjects.addAll(tmpSubjects);
		}
		tmpSubjects = new ArrayList();
		tmpSubjects = pwdProf.getAllSpecificConfigurationSubjects();
		if (tmpSubjects != null && tmpSubjects.size() > 0)
		{
			allSubjects.addAll(tmpSubjects);
		}

		tmpSubjects = new ArrayList();
		tmpSubjects = pwdProf.getAllTestDefaultConfigurationSubjects();
		if (tmpSubjects != null && tmpSubjects.size() > 0)
		{
			allDefaultVars.addAll(tmpSubjects);
		}

		ArrayList aListPwdProfIniEntries = new ArrayList();
		if (allSubjects != null && allSubjects.size() > 0)
		{
			for (int aa=0;aa<allSubjects.size();aa++)
			{
				String strSubject = (String) allSubjects.get(aa);
				if (strSubject != null && strSubject.endsWith("#^#"+profileName))
				{
					aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,strSubject,"",""));
				}
			}
		}

		if (allDefaultVars != null && allDefaultVars.size() > 0)
		{
			String defSubject = "Default_Configuration";
			for (int bb=0;bb<allDefaultVars.size();bb++)
			{
				String strVariable = (String) allDefaultVars.get(bb);
				if (strVariable != null && strVariable.endsWith("#^#"+profileName))
				{
					aListPwdProfIniEntries.add(new IniHelper(IniHelper.DELETE,defSubject,strVariable,""));
				}
			}
		}
	
		if (aListPwdProfIniEntries != null)
		{
			IniFile writePwdProfIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_pwdprofile.ini");
			for (int i=0;i<aListPwdProfIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListPwdProfIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null )
				{
					if (iniAction.equals(IniHelper.DELETE))
					{
						if (!StringUtils.isNull(key))
						{
							writePwdProfIniSync.deleteValue(sub,key);
						}
						else
						{
							writePwdProfIniSync.deleteSubject(sub);
						}
					}
				}
			}
			writePwdProfIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(writePwdProfIniSync);
		}
		rootJSON.put("Result","The password profile has been deleted successfully");
		auditLogThread.setValue("Activity","Delete Password Profile");
		auditLogThread.setValue("Description","The password profile \""+profileName+"\" has been deleted successfully.");
		auditLogThread.sendItToDB();
	}


	out.println(rootJSON);

%>