Ext.define('QuickMaintenance.controller.Main', {
    extend: 'Ext.app.Controller',
    requires: ['QuickMaintenance.view.Main', 'QuickMaintenance.view.CreatePolicyView'],
    refs: [{
        selector: 'main',
        ref: 'main'
    }, {
        selector: 'createpolicyview',
        ref: 'createpolicyview'
    }, {
        selector: 'modifypolicyGrid',
        ref: 'modifypolicyGrid'
    }],
    init: function () {
        app = this;
        this.control({
            'main': {
                'boxready': this.afterMainRender
            },
            'main button[id="addPolicyBtn"]': {
                'click': this.loadAddPolicyPage
            },
            'main button[id="homeIconBtn"]': {
                'click': this.loadListPage
            },
            'createpolicyview combo[id=Frequency]': {
                'select': this.changeFrequency
            },
            'createpolicyview button[id=Addfrequency1]': {
                'click': this.addFrequency
            },
            'createpolicyview combo[id=associateOptions]': {
                'change': this.AssociateTypeComboChange
            },
            'createpolicyview combo[id=subFilter1]': {
                'change': this.SubFilter1ComboChange
            },
            'createpolicyview combo[id=subFilter2]': {
                'change': this.SubFilter2ComboChange
            },
            'createpolicyview button[id=modifyupdateBtn]': {
                'click': this.updatePolicy
            },
            'createpolicyview trigger[name="searchbox"]': {
                'change': this.textFieldSearch
            },
			'createpolicyview trigger[name="searchbox2"]': {
                'change': this.textFieldSearch
            },
            'main button[id="DeleteQMPoliciesBtn"]': {
                'click': this.loadDeleteMultiplePoliciesUI
            }
        });
    },
    goManitanalysis: function () {
        viewport = Ext.ComponentQuery.query('viewport')[0];
        viewport.removeAll();
        document.location.href = 'MaintenanceAnalysis.jsp';
    },
    goToPolicyMigration: function () {
		var separt4Obj = Ext.getCmp('separt4');
		var policyGrpObj = Ext.getCmp('policyGrpListIcon');
		var separt5Obj = Ext.getCmp('separt5');
		var migratePolicyGrpBtnObj = Ext.getCmp('migratePolicyGrpBtn');
		if (isPolicyGrpAvailable == 'true')
		{
			Ext.Msg.confirm(MaintenanceMsg, migrationMsg, function (buttonText) {
				if (buttonText == "yes") {
					var progressBar = Ext.MessageBox.progress({
						title: polGrpMigrationLbl,
						value: 5,
						width: 350,
						increment: 15,
						closable: false,
						progressText: progBarConnectingText,
						wait: true,
						waitConfig: {
							interval: 200
						},
						msg: '<b>' + progBarMigratingText + '</b>',
						scope: this,
						handler: function () {
							this.updateText('Done!');
						}
						//	buttons: Ext.MessageBox.CANCEL
					});
					Ext.Ajax.request({
						url: '../servlet/com.eg.EgMaintenanceMigrationServlet',
						scope: this,
						success: function (response) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var isMigrationSucessful = jsonData['isMigrationSucessful'];
							if (isMigrationSucessful == 'true') {
								isPolicyGrpEnabled = 'no';
								progressBar.hide();
								separt4Obj.hide();
								policyGrpObj.hide();
								separt5Obj.hide();
								migratePolicyGrpBtnObj.hide();

								var associate_elemtsObj = Ext.getCmp('associate_elemts');
								var listSearchObj = Ext.getCmp('listSearch');
								var separt1Obj = Ext.getCmp('separt1');
								var separt2Obj = Ext.getCmp('separt2');								
								var DeleteQMPoliciesBtnObj = Ext.getCmp('DeleteQMPoliciesBtn');

								associate_elemtsObj.show();
								listSearchObj.show();
								separt1Obj.show();
								separt2Obj.show();
								DeleteQMPoliciesBtnObj.show();

								Ext.getCmp('dataViewId').store.load();
								Ext.Msg.show({
									title: MaintenanceMsg,
									msg: polGrpMigrationSuccesMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							} else {
								isPolicyGrpEnabled = 'yes';
								separt4Obj.show();
								policyGrpObj.show();
								separt5Obj.show();
								migratePolicyGrpBtnObj.show();
								Ext.Msg.show({
									title: MaintenanceMsg,
									msg: policGrpMigrationFailureMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
						}
					});
				}
			});
		}
		else
		{
			Ext.Msg.show({
				title: MaintenanceMsg,
				msg: NopolicGrpMigrationMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation'
			});
		}
    },
    goPolicyGroup: function () {
        viewport = Ext.ComponentQuery.query('viewport')[0];
        viewport.removeAll();
        document.location.href = 'Maintenancegroup.jsp';
    },
    loadDeleteMultiplePoliciesUI: function () {
        var temPolcies = polNames;
        var policyDelComboData = new Array();
        var dataViewObj = Ext.getCmp('dataViewId');
        var dataViewStore = dataViewObj.getStore();
		
        if (!Ext.isEmpty(dataViewStore)) {
            var polictListData = dataViewStore.getAt(0).get('policyListData');
            for (var i = 0; i < polictListData.length; i++) {
                var polcy = polictListData[i]['Policyname'];
                var internal_Policyname = polictListData[i]['Internal_Policyname'];
                var allowToEditPolicy = polictListData[i]['allowToEditPolicy'];
				var policyname = polcy;
				if (isLimitedAdmin == 'true' && policyname.indexOf('|$|') == -1) 
				{
					policyname = polcy+ '|$|' + userLoginID;
				}	
				if(policyname!=null && policyname.indexOf("(")>0)
				{
					var policyname1 = policyname.split("(");					
					policyname = policyname1[0].trim()+"|$|"+policyname1[1].substring(0,policyname1[1].lastIndexOf(")"));
				}	
				if (allowToEditPolicy)
				{
					policyDelComboData.push({
						displayField: polcy,
						valueField: internal_Policyname
					});
				}
            }
        }
        if (policyDelComboData != null && policyDelComboData.length == 0) {
			if(isLimitedAdmin)
			{
				Ext.Msg.show({
					title: MaintenanceMsg,
					msg: deleteMultiplePolicyAlertForLimitedAdmin,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
			}
			else
			{
				Ext.Msg.show({
					title: MaintenanceMsg,
					msg: deleteMultiplePolicyAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
			}
            return;
        }

        Ext.create('Ext.window.Window', {
            id: 'deleteQMainPolWin',
            name: 'deleteQMainPolWin',
            title: deleteMultiPolicyTooltipText,
			doClose: function(){
				Ext.Ajax.request({
					url:'/final/admin/QuickMaintenance/data/QuickMaintenanceListJson.jsp',
					method:'POST'
				});
				this.destroy();
			},
            closeAction: 'destroy',
            bodyPadding: '5 5 5 5',
			padding:'3 10 10 10',
            modal: true,
            items: [{
                xtype: 'multiselect',
                id: 'delPolCombo',
                name: 'delPolCombo',
                margin: '5 0 0 0',
                baseCls: 'egmultiselect',
                border: true,
                bodyPadding: 0,
                multiSelect: true,
                scroll: false,
                autoScroll: false,
                height: 180,
                layout: 'fit',
                width: 280,
                displayField: 'displayField',
                valueField: 'valueField',
                store: Ext.create('Ext.data.Store', {
                    fields: ['valueField', 'displayField'],
                    data: policyDelComboData
                })
            }, {
                xtype: 'button',
                text: deletelbl,
                id: 'DeleteMPolBtn',
                cls: 'button20',
                width: 80,
                margin: '5 0 20 95',
                handler: function () {
                    quickMainApp.getController("Main").deleteMultiPolicies();
                }
            }]
        }).show();

		Ext.Ajax.request({
			url: 'QuickMaintenance/data/quickmainpolicyhelpJson.jsp',
			method: 'POST',
			async: false
		});

    },
    deleteMultiPolicies: function () {
        var mpolicies = Ext.getCmp('delPolCombo').getValue();
		if (mpolicies.length > 0)
		{			
			Ext.Msg.confirm(MaintenanceMsg, deleteAllPoliciesAlert, function (buttonText) {
				if (buttonText == "yes") {
					Ext.Ajax.request({
						url: '/final/admin/QuickMaintenance/data/egMaintenanceDeletion.jsp?mpolicies='+encodeURIComponent(mpolicies)+'&from=deleteallQuickMaintenancepolicies',
						//params: 'mpolicies='+encodeURIComponent(mpolicies) + '&from=deleteallQuickMaintenancepolicies',
						scope: this,
						method: 'POST',
						success: function (response) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var result = jsonData['result'];
							if (result == 'success') {
								var associate_elemtsObj = Ext.getCmp('associate_elemts');
								var listSearchObj = Ext.getCmp('listSearch');
								var separt1Obj = Ext.getCmp('separt1');
								var separt2Obj = Ext.getCmp('separt2');
								var DeleteQMPoliciesBtnObj = Ext.getCmp('DeleteQMPoliciesBtn');
								if (jsonData['isUnplannedPoliciesAvailable'] == true)
								{
									polNames = jsonData['PolicyNames'];
									associate_elemtsObj.show();
									listSearchObj.show();
									separt1Obj.show();
									DeleteQMPoliciesBtnObj.show();
									separt2Obj.show();
								}
								else
								{
									polNames = jsonData['PolicyNames'];
									associate_elemtsObj.hide();
									listSearchObj.hide();
									separt1Obj.hide();
									DeleteQMPoliciesBtnObj.hide();
									separt2Obj.hide();
								}

								Ext.getCmp('dataViewId').store.load();
								Ext.getCmp('deleteQMainPolWin').close();
								Ext.Msg.show({
									title: MaintenanceMsg,
									msg: multiPolicyDeleteMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
						}
					});
				}
			});
		}
		else
		{
			Ext.Msg.show({
				title: MaintenanceMsg,
				msg: deleteUnplannedNoSelectedMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

    },
    textFieldSearch: function (field, event) {
        var itemSelectorObj = Ext.getCmp('associatepolicies');
		var avaiableElementsMultiSelect=null;
        if (!Ext.isEmpty(itemSelectorObj) && itemSelectorObj.hasOwnProperty('fromField')) {
			if(itemSelectorObj.hasOwnProperty('toField'))
			{
				avaiableElementsMultiSelect=itemSelectorObj['toField'];
			}
            itemSelectorObj = itemSelectorObj['fromField'];
        }
        if ((Ext.String.trim(field.value) != null)) {
            var regex = RegExp(field.value, 'i');
			if(!Ext.isEmpty(itemSelectorObj))
			{
				var elementsItems = itemSelectorObj.getStore();
				if(!Ext.isEmpty(elementsItems))
				{
					elementsItems.clearFilter(true);
					elementsItems.filter(new Ext.util.Filter({
						caseSensitive: true,
						filterFn: function (object) {
							var match = false;
							Ext.Object.each(object.data, function (property, value) {
								match = match || regex.test(String(value));
							});
							return match;
						}
					}));
				}
			}
			if(!Ext.isEmpty(avaiableElementsMultiSelect))
			{
				var availableElementsItems = avaiableElementsMultiSelect.getStore();
				if(!Ext.isEmpty(availableElementsItems))
				{
					availableElementsItems.clearFilter(true);
					availableElementsItems.filter(new Ext.util.Filter({
						caseSensitive: true,
						filterFn: function (object) {
							var match = false;
							Ext.Object.each(object.data, function (property, value) {
								match = match || regex.test(String(value));
							});
							return match;
						}
					}));
				}
			}
        } else {
			if(!Ext.isEmpty(itemSelectorObj))
			{
				itemSelectorObj.getStore().clearFilter(true);
			}
			if(!Ext.isEmpty(avaiableElementsMultiSelect))
			{
				avaiableElementsMultiSelect.getStore().clearFilter(true);
			}
        }
        field.focus();
    },
    getDataViewPanel: function (lastLoadedUrl) {
		if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify')
		{
			Ext.getCmp('quickMainBackBtn').show();
			Ext.getCmp('separt6').show();
		}
		else
		{
			Ext.getCmp('quickMainBackBtn').hide();
			Ext.getCmp('separt6').hide();
		}
        var isAssociatedChecked = Ext.getCmp('associate_elemts').checked;
        var myglobal_var = '';
        var store = new Ext.data.Store({
            fields: [{
                name: 'errMsg',
                type: 'string'
            }, {
                name: 'screenLabels',
                type: 'object'
            }, {
                name: 'policyListData',
                type: 'array'
            }],
            proxy: {
                type: 'ajax',
                url: lastLoadedUrl,
                //url: 'tempjsondata.json',
                reader: {
                    type: 'json',
                }
            }
        });
        store.load();
        var mainviewobj = Ext.getCmp('main');
        mainviewobj.removeAll();


		Ext.getCmp('addPolicyBtn').show();
		Ext.getCmp('separt3').show();
		Ext.getCmp('maintenanceAnalysisBtn').show();

		var policyGrpObj = Ext.getCmp('policyGrpListIcon');
		var migratePolicyGrpBtnObj = Ext.getCmp('migratePolicyGrpBtn');
		var separt4Obj = Ext.getCmp('separt4');

		var associate_elemtsObj = Ext.getCmp('associate_elemts');
		var listSearchObj = Ext.getCmp('listSearch');
		var separt1Obj = Ext.getCmp('separt1');
		var separt2Obj = Ext.getCmp('separt2');
		var separt5Obj = Ext.getCmp('separt5');
		var DeleteQMPoliciesBtnObj = Ext.getCmp('DeleteQMPoliciesBtn');
		if (isUnplannedPoliciesAvailable == 'true')
		{
			associate_elemtsObj.show();
			listSearchObj.show();
			separt1Obj.show();
			DeleteQMPoliciesBtnObj.show();
			separt2Obj.show();
		}
		else
		{
			associate_elemtsObj.hide();
			listSearchObj.hide();
			separt1Obj.hide();
			DeleteQMPoliciesBtnObj.hide();
			separt2Obj.hide();
		}
		if (isPolicyGrpEnabled.toLowerCase() == 'yes')
		{
			separt4Obj.show();
			policyGrpObj.show();
			separt5Obj.show();
			migratePolicyGrpBtnObj.show();
		}
		else
		{
			separt4Obj.hide();
			policyGrpObj.hide();
			separt5Obj.hide();
			migratePolicyGrpBtnObj.hide();
		}

        //Ext.getCmp('QuickMaintenancePageDescComp').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;' + listPageDesc + '</center>');
        mainviewobj.setTitle(homeTitle);
		this.setToolTipForPanel(listPageDesc);

        /*   */
        /*  Group Name */

        if (isAssociatedChecked) {
		 var cwidth2=Ext.getBody().getViewSize().width-5;
            var dataContainer = Ext.create('Ext.panel.Panel', {

                cls: 'maintenanceShadow',
                scroll: true,
				flex:1,
				margin:10,
                border: true,
                items: [{
                    xtype: 'dataview',
                    id: 'dataViewId',
					flex:1,
                    store: store,
                    tpl: [
						'<tpl for=".">',
							'<tpl if="!Ext.isEmpty(policyListData)">',
								'<div class="maintenanceTable"  style="margin:0px !important">',
									'<table id="tableId" border="0" align="center" width="100%"><col width="20%"><col width="30%"><col width="50%">',
										'<thead>',
											'<tr>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.Policy_Name}</th>',
												'<th class="maintenanceTableHeader" style="height:25px;padding:0px !important"><table border="0" width="100%" height="100%" class="mainten_font"><col width="50%"><col width="50%"><tr>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.TimeFrequency}</th>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.Timeline}</th></tr></table></th>',
												'<th class="maintenanceTableHeader mainten_font" style="height:25px;padding-left: 10px;">{screenLabels.AssociatedElements}</th>',
											'</tr>',
										'</thead>',
										'<tbody>',
											'<tpl for="policyListData">',
											'<tr class="tableTrBgEven {bg}">',
												//'<tpl if="xcount===1">',
												//	'<td class="mhover mainten_font">',
												//'<tpl elseif="xindex===xcount">',
												//	'<td class="mhover mainten_font">',
												//'<tpl else>',
													'<td class="mhover mainten_font">',
												//'</tpl>',
														'<table border="0" align="center" >',
															'<tr class="removeBg">',
																'<td class="font_bold12" valign="top" style="border:0px !important">',
																	'<div>{Policyname}</div>',
																'</td>',
						//'</tr>',
						//'<tr>',								
						/*  Inner EDIT DELETE Elements */
																'<tpl if="allowToEditPolicy">',
																	'<tpl for="iconClass">',
																		'<td style="border:0px !important;padding:0px !important">',
																			'<div class="controlles" style="display:none;">',
																				'<div style="float:left;width:16px;"><img data-qtip="' + modifyPolicyTooltipText + '" data-qclass="yellowTip" data="{iconPolicyname}" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="cursor:pointer" class="{icon1} modifypolicy" valign="middle" /></div>',
																			'</div>',
																		'</td>',
																		'<td style="border:0px !important;padding:0px !important">',
																			'<div class="controlles" style="display:none;">',
																				'<div style="float:left"><img data-qtip="' + deletePolicyTooltipText + '" data-qclass="yellowTip" data="{iconPolicyname}" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="cursor:pointer" class="{icon2} deletepolicy" valign="middle" /></div>',
																			'</div>',
																		'</td>',
																	'</tpl>',
						/*  Inner EDIT DELETE Ends */			'</tpl>',
															'</tr>',
														'</table>',
													'</td>',
												//'<tpl if="xindex===0">',
													'<td  style="padding:0px !important;" valign="top"><div class="maintenanceInnerTable">',
												//'<tpl else>',
												//	'<td  style="" class="quickMaiteninset" valign="top">',
												//'</tpl>',
														'<table id="tableId" border="0" align="center" width="100%" ><col width="50%"><col width="50%">',
															'<tpl for="TimeFrequency">',
																'{% var isLastNod=false; if(xindex==xcount){isLastNod=true;} %}',
																'<tr>',
																	'<td style="width:50%;padding:6px 10px 5px 10px" valign="top" >',
																		'<div >{date}</div>',
																	'</td>',
																	/*'<tpl if="xindex===xcount">',
																	'<td class="tdBorderHtml padding4" style="width:50%" valign="top" >',
																		'<div >{date}</div>',
																	'</td>',
																	'<tpl elseif="xindex===1">',
																		'<td class="tdBorderHtml padding4" style="width:50%" valign="top" >',
																			'<div >{date}</div>',
																		'</td>',
																	'<tpl else>',
																		'<td class="tdBorderHtml padding4" style="width:50%" valign="top" >',
																			'<div >{date}</div>',
																		'</td>',
																	'</tpl>',*/
																	'{% var isTimeFreqLastNod=false; if(xindex==xcount){ if(isLastNod){isTimeFreqLastNod=true;}} %}',
																	/*'<tpl if="xindex===xcount">',
																		'<td valign="top" style="{[isLastNod === true ? "border-top: 0px;border-left: 0px;border-top: 0px;border-left: 0px;border-right: 0px !important;border:1px solid red" : "border-top: 0px;border-left: 0px;border:1px solid green;border-top: 0px;border-left: 0px;border-right: 0px !important;"]}class="tdBorderHtml"  valign="top" >',
																	'<tpl else>',
																		'<td class="tdBorderHtml" style="border-top: 0px;border-left: 0px;border-top: 0px;border-left: 0px;border-right: 0px !important;" valign="top" >',
																	'</tpl>',*/
																	'<td valign="top" style="padding:6px 10px 5px 10px">',
						/* '<td class="tdBorderHtml" style="" valign="top">', */
																			//'<table id="tableId" border="0" align="center" width="100%">',
																				'<tpl for="time">',
																				//	'<tr>',
																				'<tpl if="xindex===xcount">',
																					/*	'<td style="{[isTimeFreqLastNod===true?"border-top: 0px;border-left: 0px;padding-left: 6px;padding-top: 10px;border-right: 0;" : "border-top: 0px;border-left: 0px;padding-left: 6px;padding-top: 10px;border-right: 0;"]}class="tdBorderHtml" style="" valign="top" >',*/
																							'<div style="clear:both">{timePeriods}</div>',
																					//	'</td>',

																				'<tpl else>',
																					//	'<td class="tdBorderHtml padding4" style=" " valign="top" >',
																							'<div style="clear:both">{timePeriods}</div>',
																					//	'</td>',
																				'</tpl>',
																				//	'</tr>',
																				'</tpl>',
																			//'</table>',
																		'</td>',
																	'</tr>',
																	'</tpl>',
														'</table>',
													'</td>',
												'<tpl if="(Ext.isEmpty(AssociatedElements) || AssociatedElements == null) && (Ext.isEmpty(AssociatedElementsForCompTestDesc) || AssociatedElementsForCompTestDesc == null)">',
													'<td  valign="middle">',
												'<tpl else>', // else
													'<td style="padding:0px !important;" valign="top"><div class="maintenanceInnerTable">',
												'</tpl>',
														'<table border="0" align="left" width="100%">',
															'<tpl if="!Ext.isEmpty(AssociatedElements) && AssociatedElements!=null">',
																'<tpl for="AssociatedElements">',
																	'<tr>',
																		'<td class="font_bold12" style="width:70px;padding:6px 10px 5px 10px">',
																			'<div >{AssciatedName}</div>',
																		'</td>',
																		'<td class="mainten_font" colspan="3" style="padding:6px 10px 5px 10px">',
																			'<div >{AssciatedValue}</div>',
																		'</td>',
																	'</tr>',
																'</tpl>',
															'</tpl>',
															'<tpl if="!Ext.isEmpty(AssociatedElementsForCompTestDesc) && AssociatedElementsForCompTestDesc!=null">',
															'<tpl for="AssociatedElementsForCompTestDesc">',
																'<tr>',
																	'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																		'<div style="width: 100px;">{AssociatedTitle}</div>',
																	'</td>',
																	'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																		'<div>{AssciatedName1}</div>',
																	'</td>',
																	'<tpl if="AssociatedTitle===\'Descriptors for Component\'" >',
																		'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																			'<div>{AssciatedName3}</div>',
																		'</td>',
																		'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																			'<div>{AssciatedName2}</div>',
																		'</td>',
																	'<tpl else>',
																		'<td class="font_bold12" colspan="2" style="padding:6px 10px 5px 10px">',
																			'<div>{AssciatedName2}</div>',
																		'</td>',
																	'</tpl>',
																'</tr>',
															'<tpl if="!Ext.isEmpty(AssociateTitleobj) && AssociateTitleobj!=null">',
																'<tpl for = "AssociateTitleobj">',
																	'<tr>',
																		'<td style="width:25%;padding:6px 10px 5px 10px"  valign="top"></td>',
																		'<td class="mainten_font" style="width:25%;padding:6px 10px 5px 10px"  valign="top">',
																			'<div style="white-space:wrap;word-wrap: break-word !important;">{AssciatedName}</div>',
																		'</td>',
																		'<tpl if="AssociatedTitle===\'Descriptors for Component\'" >',
																			'<td class="mainten_font" style="width:25%;padding:6px 10px 5px 10px"  valign="top">',
																				'<div style="white-space:wrap;word-wrap: break-word !important;">{TestName}</div>',
																			'</td>',
																			'<td class="mainten_font" style="width:25%;padding:6px 10px 5px 10px" valign="top">',
																				'<div style="white-space:wrap;word-wrap: break-word !important;width:300px">{AssciatedValue}</div>',
																			'</td>',
																		'<tpl else>',
																			'<td class="mainten_font" style="padding:6px 10px 5px 10px" colspan="2"  valign="top">',
																				'<div style="white-space:wrap;word-wrap: break-word !important;width:400px;">{AssciatedValue}</div>',
																			'</td>',
																		'</tpl>',
																	'</tr>',
																'</tpl>', //tpl for ends
																'</tpl>', //tpl if ends
															'</tpl>', //tpl for ends
															'</tpl>', //tpl if ends
															'<tpl if="(Ext.isEmpty(AssociatedElements) || AssociatedElements == null) && (Ext.isEmpty(AssociatedElementsForCompTestDesc) || AssociatedElementsForCompTestDesc == null)">',
																'<tr>',
																	'<td class="mainten_font" style="width:60px;" valign="middle">',
																		'<div style="text-align:center;width:400px;margin:10px auto 10px auto;"><div class="iconInformation font_normal12" style="margin:0px auto"> </div><div class="mainten_font">{AssociatedElementsNoData}</div></div>',
																	'</td>',
																'</tr>',
															'</tpl>',
														'</table>',
														'</div>',
													'</td>',
												'</tr>',
											'</tpl>',
										'</tbody>',
									'</table>',
								'</div>',
							'<tpl else>', // else
								'<table>',
									'<tr>',
										'<td class="mainten_font" style="width:60px">',
											'<div style="text-align:center;width:'+cwidth2+'px;margin:15% auto 10px auto;;height:100px" class="commonErrorMsgText"><div class="iconInformation font_normal12" style="margin:0px auto"> </div>{errMsg}</div>',
										'</td>',
									'</tr>',
								'</table>',
							'</tpl>', // else ends
						'</tpl>',
						'<div class="x-clear"></div>'
                    ],
                    itemSelector: 'div.x-table'
                }]
            });
        } else {
		 var cwidth2=Ext.getBody().getViewSize().width-5;
            var dataContainer = Ext.create('Ext.panel.Panel', {
                id: 'contdiv',
                cls: 'maintenanceShadow',
                scroll: true,
                border: true,
				margin:10,
                items: [{
                    xtype: 'dataview',
                    id: 'dataViewId',
                    //itemId : 'Associate',
                    store: store,
                    tpl: [
                        '<tpl for=".">',
							'<tpl if="!Ext.isEmpty(policyListData)">',
								'<div class="maintenanceTable"  style="margin:0px !important">',
									'<table id="tableId" border="0" align="center" width="100%">',
										'<thead>',
											'<tr>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.Policy_Name}</th>',
												'<th class="maintenanceTableHeader" style="height:25px;"><table border="0" width="100%" height="100%" class="mainten_font"><col width="50%"><col width="50%"><tr>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.TimeFrequency}</th>',
												'<th class="maintenanceTableHeader" style="height:25px;padding-left: 10px;">{screenLabels.Timeline}</th></tr></table></th>',
											'</tr>',
										'</thead>',
										'<tbody>',
											'<tpl for="policyListData">',
											'<tr class="tableTrBgEven {bg}">',
												/*'<tpl if="xindex===xcount">',
													'<td class="mhover mainten_font quickMaiteninset border_alt" style="width:202px;border-top: 0px;height:50px" >',
												'<tpl else>',
													'<td class="mhover mainten_font quickMaiteninset border_alt" style="width:202px;border-top: 0px;" >',
												'</tpl>',*/
												'<td class="mhover mainten_font" style="width:202px;height:50px">',
														'<table id="tableId" border="0" align="center" class="Policyname" width="50%" >',
															'<tr class="removeBg">',
																'<td class="font_bold12" style="border:0px !important" valign="top" >',
																	'<div>{Policyname}</div>',
																'</td>',
																'<td style="border:0px !important;padding:0px !important">',
																
						/*  Inner EDIT DELETE Elements */
																'<tpl if="allowToEditPolicy">',
																	'<tpl for="iconClass">',
																		'<td style="border:0px !important;padding:0px !important">',
																			'<div class="controlles" style="display:none;">',
																				'<div style="float:left;width:16px;"><img data-qtip="' + modifyPolicyTooltipText + '" data-qclass="yellowTip" data="{iconPolicyname}" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="cursor:pointer" class="{icon1} modifypolicy" valign="middle" /></div>',
																			'</div>',
																		'</td>',
																		'<td style="border:0px !important;padding:0px !important">',
																			'<div class="controlles" style="display:none;">',
																				'<div style="float:left"><img data-qtip="' + deletePolicyTooltipText + '" data-qclass="yellowTip" data="{iconPolicyname}" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="cursor:pointer" class="{icon2} deletepolicy" valign="middle" /></div>',
																			'</div>',
																		'</td>',
																	'</tpl>',
						/*  Inner EDIT DELETE Ends */			'</tpl>',

																'</td>',
															'</tr>',
														'</table>',
													'</td>',
												/*	'<tpl if="xindex+1===xcount">',
													'<td  style="border-top: 0px;border-left: 0px" class="quickMaiteninset monitorsettingsborder" valign="top">',
													'<tpl else>',
													 '<td  style="border-top: 0px;border-left: 0px" class="quickMaiteninset border_alt" valign="top">',
													'</tpl>',*/
													'<td  style="padding:0px !important;" valign="top"><div class="maintenanceInnerTable">',
														'<table border="0" align="center" width="100%" ><col width="50%"><col width="50%">',
															'<tpl for="TimeFrequency">',
															'<tr>',
																'<tpl if="xindex===xcount">',
																'<td class="mainten_font" valign="top" >',
																	'<div >{date}</div>',
																'</td>',
																'<tpl else>',
																'<td class="mainten_font" valign="top" >',
																	'<div >{date}</div>',
																'</td>',
																'</tpl>',
																	'<td valign="top">',
																		'<tpl for="time">',
																			'<tpl if="xindex===xcount">',
																				'<div style="clear:both">{timePeriods}</div>',
																			'<tpl else>',
																				'<div style="clear:both">{timePeriods}</div>',
																			'</tpl>',
																		'</tpl>',
																	'</td>',
																'</tr>',
															'</tpl>',
														'</table>',
													'</div></td>',
												'</tr>',
											'</tpl>',
										'</tbody>',
									'</table>',
								'</div>',
							'<tpl else>', // else
								'<table>',
									'<tr>',
										'<td class="mainten_font" style="width:60px">',
											'<div style="text-align:center;width:'+cwidth2+'px;margin:15% auto 10px auto;;height:100px" class="commonErrorMsgText  font_normal12"><div class="iconInformation" style="margin:0px auto"> </div>{errMsg}</div>',
										'</td>',
									'</tr>',
								'</table>',
							'</tpl>', // else ends
							'</tpl>',
								'<div class="x-clear"></div>'
                    ],
                    itemSelector: 'div.x-table'
                }]
            });
        }
        Ext.getBody().on('click', function (event, target) {
            this.modifyGroups(target.getAttribute('data'));
        }, this, {
            delegate: '.modify'
        });
        Ext.getBody().on('click', function (event, target) {
            var dataViewObj = Ext.getCmp('dataViewId');
            this.deleteGroups(target.getAttribute('data'), dataViewObj);
        }, this, {
            delegate: '.delete'
        });


        /*  Policy Name */
        Ext.getBody().on('click', function (event, target) {
            this.modifyPolicies(target.getAttribute('data'));
        }, this, {
            delegate: '.modifypolicy'
        });
        Ext.getBody().on('click', function (event, target) {
            var dataViewObj = Ext.getCmp('dataViewId');
            this.deletePolicies(target.getAttribute('data'), dataViewObj);
        }, this, {
            delegate: '.deletepolicy'
        });

        mainviewobj.removeAll();
        mainviewobj.add(dataContainer);
        mainviewobj.doLayout();
    },
	setToolTipForPanel: function(tipMsg) {
		new Ext.ToolTip({
			target: document.getElementById('homeTitle'),
			anchor: 'top',
			anchorOffset:42,
			mouseOffset: [-55, 0],
			html: tipMsg,
			cls: "adminInfoTooltip"
		});
	},
    modifyPolicies: function (policyName) {
        Ext.Ajax.request({
            url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?from=defaultLoad&policyToView=' + encodeURI(policyName) + '&operation=modify',
            scope: this,
            method: 'GET',
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                var mainViewPage = this.getMain();
                mainViewPage.removeAll();
                Ext.getCmp('associate_elemts').hide();
                Ext.getCmp('listSearch').hide();
                Ext.getCmp('addPolicyBtn').hide();
                Ext.getCmp('DeleteQMPoliciesBtn').hide();
                Ext.getCmp('policyGrpListIcon').hide();
                Ext.getCmp('migratePolicyGrpBtn').hide();
                Ext.getCmp('maintenanceAnalysisBtn').hide();

				if (!Ext.isEmpty(fromWizard))
				{
					Ext.getCmp('quickMainBackBtn').hide();
				}
				else
				{
					Ext.getCmp('quickMainBackBtn').show();
				}

                Ext.getCmp('separt1').hide();
                Ext.getCmp('separt2').hide();
                Ext.getCmp('separt3').hide();
                Ext.getCmp('separt4').hide();
                Ext.getCmp('separt5').hide();
				Ext.getCmp('separt6').hide();
                //Ext.getCmp('QuickMaintenancePageDescComp').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;' + policyCreatePageDesc + '</center>');
                mainViewPage.setTitle(modifyTitle);
				this.setToolTipForPanel(policyCreatePageDesc);
                mainViewPage.add({
                    xtype: 'createpolicyview',
                    jsonData: jsonData
                });
                isMaintenanceConfigPage = true;
            }
        });
    },
    updatePolicy: function () {
        var createpolicyview = this.getCreatepolicyview();
        var op = createpolicyview.jsonData['operation'];
        var existingComponents = '';
        if (createpolicyview.jsonData.hasOwnProperty('existingComponents')) {
            existingComponents = createpolicyview.jsonData['existingComponents'];
			existingComponents = this.filterEncode(existingComponents);
        }
        var policyname = '';
        if (op == "create") {
            policyname = Ext.getCmp('PolicyText1').getValue();
			var internalPolicyName = policyname;//for validation
			if (isLimitedAdmin == 'true' && policyname.indexOf('|$|') == -1) //Limited admin
			{
				internalPolicyName = policyname + '|$|' + userLoginID;
			}
            if (policyname == "" || policyname.length == 0) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: emptyPolicyName,
                    buttons: Ext.Msg.OK,
                    icon : 'iconExclamation'
                });
                return;
            }
            if (policyname.match(/[ ]/) != null) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: spaceMsg,
                    buttons: Ext.Msg.OK,
                    icon : 'iconExclamation'
                });
                return;
            }			
			if (this.checkSpecialCharacter(policyname)) {
            //if (policyname.match(/[~!@#$%^&*()-+={}:<>?\|`,]/) != null) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: specialcharacterMsg,
                    buttons: Ext.Msg.OK,
                    icon : 'iconExclamation'
                });
                return;
            }
	    if (policyname.length > 32) {
           
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: policyNameMaxLengthMsg,
                    buttons: Ext.Msg.OK,
                    icon : 'iconExclamation'
                });
                return;
            }
            if (!isNewPolicyCreated && polNames.indexOf("#" + internalPolicyName + "#") > -1) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: policyExistsMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            if (isDoubleByteEnabled == "false") {
                if (!validateSingleByte(policyname)) {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: doubleByteMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconExclamation'
                    });
                    return;
                }
            }
        } else {
            policyname = createpolicyview.jsonData['policyToView'];
        }
        if (isLimitedAdmin == 'true' && policyname.indexOf('|$|') == -1) //Limited admin -- To maintain selections whilst policy creation
        {
            policyname = policyname+ '|$|' + userLoginID;
        }
        var selectedAssociateOption = Ext.getCmp('associateOptions').getValue();
        var selectedSubFilter1Value = Ext.getCmp('subFilter1').getValue();
        var comTyp = '';
        var test1 = '';
        var comp = ''
        var infratype = ''
        var infraelementname = '';
        var testForComp = '';
        if (selectedAssociateOption != null && selectedAssociateOption == "Component") {
            var selectedSubFilter2Value = Ext.getCmp('subFilter2').getValue();
            if (selectedSubFilter2Value != null && selectedSubFilter2Value == "-1") {
                if (selectedSubFilter1Value == "Zone") {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: chooseZoneMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconExclamation'
                    });
                    return;
                } else if (selectedSubFilter1Value == "Segment") {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: chooseSegmentMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconExclamation'
                    });
                    return;
                } else if (selectedSubFilter1Value == "Service") {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: chooseServiceMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconExclamation'
                    });
                    return;
                } else if (selectedSubFilter1Value == "Component Type") {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: chooseCtypeMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconExclamation'
                    });
                    return;
                }
            }
            if (selectedSubFilter1Value == "Component Type") {
                comTyp = selectedSubFilter1Value;
            } else {
                infratype = selectedSubFilter1Value;
                infraelementname = selectedSubFilter2Value;
            }
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Descriptor") {
            if (selectedSubFilter1Value != null && selectedSubFilter1Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseTestMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            test1 = selectedSubFilter1Value;
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Descriptor for Component") {
            if (selectedSubFilter1Value != null && selectedSubFilter1Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseCompMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            comp = selectedSubFilter1Value;
            var selectedSubFilter2Value = Ext.getCmp('subFilter2').getValue();
            if (selectedSubFilter2Value != null && selectedSubFilter2Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseTestMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            test1 = selectedSubFilter2Value;
            testForComp = selectedSubFilter2Value;

        } else if (selectedAssociateOption != null && selectedAssociateOption == "Test For Host") {
            if (selectedSubFilter1Value != null && selectedSubFilter1Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseTestMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            infratype = selectedSubFilter1Value;
			test1 = selectedSubFilter1Value;
            var selectedSubFilter2Value = Ext.getCmp('subFilter2').getValue();
            if (selectedSubFilter2Value != null && selectedSubFilter2Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseCtypeMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            infraelementname = selectedSubFilter2Value;
			testForComp = selectedSubFilter2Value;
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Test For Component") {
            if (selectedSubFilter1Value != null && selectedSubFilter1Value == "-1") {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: chooseTestMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
            infratype = selectedSubFilter1Value;
			test1 = selectedSubFilter1Value;
        }
        /*		var existingPlolicyEntries = '';//modifyPolicyJSON['existingPlolicyEntries'];
		if(op!="create")
		{
			existingPlolicyEntries = createpolicyview.jsonData['existingPlolicyEntries'];
		}*/
        var gridObj = Ext.getCmp('modifyqpolicy');
        var gridData = gridObj.store.data.items;
        var gridLength = gridObj.store.data.length;
        var sub = true;
        if (gridLength == 0) {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: addTimeFreqMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        }
        var mgrDisplayDateFormat2 = 'MM/dd/yyyy';
        if (mgrDisplayDateFormat == null || mgrDisplayDateFormat == "null" || mgrDisplayDateFormat == "") {
            mgrDisplayDateFormat = mgrDisplayDateFormat2;
        }
        var policyEntries = '';
        for (var i = 0; i < gridData.length; i++) {
            var rowData = gridData[i].data;
            var valueField = rowData.valueField;
            policyEntries += "," + valueField;
        }
        if (policyEntries != null && policyEntries.indexOf(",") == 0) {
            policyEntries = policyEntries.substring(1);
        }
        var disElms = Ext.getCmp('associatepolicies').getValue();
        var Arr = new Array();
        for (var i = 0; i < Ext.getCmp('associatepolicies').getStore().getCount(); i++) {
            var isData = false;
            var allValue = Ext.getCmp('associatepolicies').getStore().getAt(i).get('valueField');
            for (var j = 0; j < disElms.length; j++) {
                if (allValue == disElms[j]) {
                    isData = true;
                    break;
                }
            }
            if (!isData) {
                Arr.push(allValue);
            }
        }  
		var sub = true;
		if(op!=null && op=="create" && !isNewPolicyCreated)
		{			
			if (Arr.length == 0) {
				Ext.Msg.show({
					title: MaintenanceMsg,
					msg: assElements,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				sub = false;
				return;
			}
		}
		var assArr = Arr.toString();
		assArr = this.filterEncode(assArr);
		disElms = this.filterEncode(disElms.toString());
        var urlParams = "from=submit&type=showPolicies&policyEntries=" + encodeURIComponent(policyEntries) + "&policyName=" + encodeURIComponent(policyname) + "&combination=" + selectedAssociateOption + "&comp=" + encodeURI(comp) + "&comptype=" + encodeURIComponent(comTyp) + "&test=" + encodeURIComponent(test1) + "&infratypename=" + encodeURIComponent(infratype) + "&serverType=" + encodeURIComponent(infraelementname) + '&fdissociate=' + encodeURIComponent(disElms) + '&fassociate=' + encodeURIComponent(assArr) +"&operation=" + op + "&cache=" + (new Date()).getTime() + "&testcomp=" + encodeURIComponent(testForComp);

		if(existingComponents!=undefined && existingComponents!=null && existingComponents!='' && !Ext.isEmpty(existingComponents))
			urlParams += "&existingComponents=" + encodeURIComponent(existingComponents);

        var meC = this;
        Ext.Ajax.request({
            url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?',
            params: urlParams,
            scope: this,
            method: 'POST',
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
				isUnplannedPoliciesAvailable = 'true';
                polNames += policyname + '#';
				
                if (op == "create" && !isNewPolicyCreated) {
                    isNewPolicyCreated = true;
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: policyCreationMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconInformation'
                    });
                } else {
                    Ext.Msg.show({
                        title: MaintenanceMsg,
                        msg: policyModifyMsg,
                        buttons: Ext.Msg.OK,
                        icon: 'iconInformation'
                    });
                }
                //meC.getDataViewPanel('QuickMaintenanceListJson.jsp');
            },
            failure: function (response) {
                console.log(response);
            }
        });

        //		&existingPlolicyEntries='+encodeURIComponent(existingPlolicyEntries)+'&policyName='+encodeURIComponent(policyname)+'&policyEntries='+encodeURIComponent(policyEntries)
        //		'&fassociate='+assPolices+'&fdissociate='+Arr
    },
	checkSpecialCharacter : function(policyname) {
		var splChar = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/";
		for ( var i = 0; i < policyname.length; i++) {
			var check_char = splChar.indexOf(policyname.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
			}
		}
		return false;
	},
    loadElementsForAssociate: function (urlParams) {
        var createpolicyview = this.getCreatepolicyview();
        Ext.Ajax.request({
            url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?',
            params: urlParams,
            scope: this,
            method: 'POST',
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                var associatepolicies = Ext.getCmp('associatepolicies');
                associatepolicies.getStore().loadRawData(jsonData['availableElements']);
                associatepolicies.setValue(jsonData['disAssociatedElements']);
                createpolicyview.jsonData['existingComponents'] = jsonData['existingComponents'];
				if (!Ext.isEmpty(fromWizard) || (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify'))
				{
					var tmpStrComponent  = new Array();
					if (strServer.toLowerCase() == 'oracle_server')
					{
						if (compName.indexOf(',') != -1)
						{
							var nick = compName.substring(0,compName.lastIndexOf(':'));
							var sid = compName.substring(compName.lastIndexOf(':')+1,compName.length);
							var sidStr = sid.split(',');
							
							for (var i=0;i<sidStr.length;i++)
							{
								tmpStrComponent.push(nick+':'+sidStr[i]);
							}
						} 
					}
					if (!Ext.isEmpty(tmpStrComponent))
					{
						var list = associatepolicies.toField.boundList;
						var store = list.getStore();
						for (var j=0;j<tmpStrComponent.length;j++)
						{
							var str = tmpStrComponent[j];
							var fieldIndex = store.findExact("valueField",str);
							if (fieldIndex != -1)
							{
								list.getSelectionModel().select(fieldIndex);
								selected = associatepolicies.getSelections(associatepolicies.toField.boundList);
								associatepolicies.moveRec(false, selected);
							}
						}
						associatepolicies.fromField.boundList.getSelectionModel().selectAll();
						associatepolicies.fromField.boundList.refresh();
					}
					else
					{
						if (compName.length > 0)
						{
							var list = associatepolicies.toField.boundList;
							var store = list.getStore();
							var fieldIndex = store.findExact("valueField",compName);
							if (fieldIndex != -1)
							{
								list.getSelectionModel().select(fieldIndex);
								selected = associatepolicies.getSelections(associatepolicies.toField.boundList);
								associatepolicies.moveRec(false, selected);
								associatepolicies.fromField.boundList.getSelectionModel().select(selected);
								associatepolicies.fromField.boundList.refresh();
							}
						}
					}
				}
            },
            failure: function (response) {
                console.log(response);
            }
        });
    },
	filterEncode: function(text)
	{
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
    SubFilter2ComboChange: function (combo) {
        var pol_val = '';
        var createpolicyview = this.getCreatepolicyview();
        var op = createpolicyview.jsonData['operation'];
        if (op == "modify") {
            pol_val = createpolicyview.jsonData['policyToView'];
        }
        var selectedAssociateOption = Ext.getCmp('associateOptions').getValue();
        var selectedSubFilter1Value = Ext.getCmp('subFilter1').getValue();
        var selectedSubFilter2Value = combo.getValue();
		selectedSubFilter2Value = this.filterEncode(selectedSubFilter2Value);
        var comboUrlParams = '';

		if ((selectedAssociateOption != null && selectedAssociateOption == "Host") && (selectedSubFilter1Value == "Zone" || selectedSubFilter1Value == "Segment" || selectedSubFilter1Value == "Service" || selectedSubFilter1Value == "Component Type")) 
		{
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Host&comptype=&test=&comp=&infratypename=' + encodeURIComponent(selectedSubFilter1Value) + '&serverType=' + encodeURIComponent(selectedSubFilter2Value) + '&testcomp=&isTest=no&search=';
        }
        else if ((selectedAssociateOption != null && selectedAssociateOption == "Component") && (selectedSubFilter1Value == "Zone" || selectedSubFilter1Value == "Segment" || selectedSubFilter1Value == "Service" || selectedSubFilter1Value == "Component Type")) {
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Component&comptype=&test=&comp=&infratypename=' + encodeURIComponent(selectedSubFilter1Value) + '&serverType=' + encodeURIComponent(selectedSubFilter2Value) + '&testcomp=&isTest=no&search=';
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Descriptor for Component") {
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Descriptor For Component&comptype=&test=&comp=' + encodeURIComponent(selectedSubFilter1Value) + '&testcomp=' + encodeURIComponent(selectedSubFilter2Value) + '&isTest=no&search=';
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Test For Host") {
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Test For Host&comptype=all&test=' + encodeURIComponent(selectedSubFilter1Value) + '&comp=&infratypename=Component Type&serverType=' + encodeURIComponent(selectedSubFilter2Value) + '&testcomp=&isTest=no&search=';
        } else {
            return;
        }
        this.loadElementsForAssociate(comboUrlParams);
    },
    SubFilter1ComboChange: function (combo) {
        Ext.getCmp('associatepolicies').getStore().removeAll();
        var pol_val = '';
        var createpolicyview = this.getCreatepolicyview();
        var op = createpolicyview.jsonData['operation'];
        if (op == "modify") {
            pol_val = createpolicyview.jsonData['policyToView'];
        }
        var selectedAssociateOption = Ext.getCmp('associateOptions').getValue();
        var selectedSubFilter1Value = combo.getValue();
		selectedSubFilter1Value = this.filterEncode(selectedSubFilter1Value);
        var comboUrlParams = '';
		
		if ((selectedAssociateOption != null && selectedAssociateOption == "Host") && (selectedSubFilter1Value == "Zone" || selectedSubFilter1Value == "Segment" || selectedSubFilter1Value == "Service" || selectedSubFilter1Value == "Component Type")) {
            comboUrlParams = 'from=infraelement&type=showPolicies&policyName=' + encodeURI(pol_val) + '&combination=Host&infratypename=' + selectedSubFilter1Value + '&serverType=-1';
        }
        else if ((selectedAssociateOption != null && selectedAssociateOption == "Component") && (selectedSubFilter1Value == "Zone" || selectedSubFilter1Value == "Segment" || selectedSubFilter1Value == "Service" || selectedSubFilter1Value == "Component Type")) {
            comboUrlParams = 'from=infraelement&type=showPolicies&policyName=' + encodeURI(pol_val) + '&combination=Component&infratypename=' + selectedSubFilter1Value + '&serverType=-1';
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Descriptor for Component") {
            comboUrlParams = 'from=testComponent&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Descriptor For Component&comp=' + encodeURIComponent(selectedSubFilter1Value) + '&testcomp=-1';
        } else if (selectedAssociateOption != null && selectedAssociateOption == "Test For Host") {
            comboUrlParams = 'from=infraelement&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Test For Host&infratypename=' + encodeURIComponent(selectedSubFilter1Value) + '&serverType=-1';
        } else if (selectedAssociateOption == "Test") {
            var isTest = "";
            if (selectedSubFilter1Value != "all") {
                isTest = "no";
            }
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Test&comptype=' + encodeURIComponent(selectedSubFilter1Value) + '&test=&comp=&infratypename=&serverType=&testcomp=&isTest=' + isTest + '&search=';
        } else if (selectedAssociateOption == "Test For Component") {
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Test For Component&comptype=&test=' + encodeURIComponent(selectedSubFilter1Value) + '&comp=&infratypename=Component Type&serverType=&testcomp=&isTest=no&search=';
        } else if (selectedAssociateOption == "Descriptor") {
            comboUrlParams = 'from=selectboxes&policyName=' + encodeURIComponent(pol_val) + '&type=showPolicies&combination=Descriptor&comptype=&test=' + encodeURIComponent(selectedSubFilter1Value) + '&comp=&infratypename=Component Type&serverType=&testcomp=&isTest=no&search=';
        }
        if (selectedAssociateOption != null && (selectedAssociateOption == "Host" || selectedAssociateOption == "Component" || selectedAssociateOption == "Descriptor for Component" || selectedAssociateOption == "Test For Host")) {
            Ext.Ajax.request({
                url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?',
                params: comboUrlParams,
                scope: this,
                method: 'POST',
                success: function (response) {
                    var jsonText = response.responseText;
                    //	console.log(jsonText);
                    var jsonData = Ext.decode(jsonText);
                    var subFilter2Combo = Ext.getCmp('subFilter2');
                    subFilter2Combo.setFieldLabel(jsonData['ComboLabel']);
                    var comboStre = subFilter2Combo.getStore();
					if(!Ext.isEmpty(comboStre))
					{
						comboStre.removeAll();
						subFilter2Combo.suspendEvents(true);
						comboStre.loadRawData(jsonData['ComboOptions']);
						if (!Ext.isEmpty(fromWizard) || (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify'))
						{
							subFilter2Combo.setValue(strServer);
						}
						else
						{
							subFilter2Combo.setValue(jsonData['selectedComboOption']);
						}
						subFilter2Combo.resumeEvents();
					}
                    subFilter2Combo.show();
                },
                failure: function (response) {
                    console.log(response);
                }
            });
        } else {
            this.loadElementsForAssociate(comboUrlParams);
        }
    },
    addFrequency: function () {
        var createpolicyview = this.getCreatepolicyview();
        var tFreqObj = Ext.getCmp('Frequency');
        var timeFrequenyCmboValue = tFreqObj.getValue();
        var frequencyDisplayVal = tFreqObj.getRawValue();
        var frequencyVal = tFreqObj.getValue();
        var str_hrValue = Ext.getCmp('str_hr').getValue();
        var start_minValue = Ext.getCmp('start_min').getValue();
        var end_hrValue = Ext.getCmp('end_hr').getValue();
        var end_MinValue = Ext.getCmp('end_Min').getValue();		
        if (timeFrequenyCmboValue == 'dow') {
            frequencyVal = Ext.getCmp('dayID').getValue();
            frequencyDisplayVal = Ext.getCmp('dayID').getRawValue();
            var frequencyRepeatVal = Ext.getCmp('repeatID').getValue();
            var frequencyDisplayRepeatVal = Ext.getCmp('repeatID').getRawValue();
			if(frequencyRepeatVal!=null && frequencyRepeatVal!='Every')
			{
				frequencyVal=frequencyVal+"$"+frequencyRepeatVal;
				//frequencyDisplayVal = frequencyDisplayVal+" ("+frequencyDisplayRepeatVal+")";
				frequencyDisplayVal = frequencyDisplayRepeatVal+" "+frequencyDisplayVal.toLowerCase()+" of the month";
			}
        }else if (timeFrequenyCmboValue == 'dom') {
            frequencyVal = Ext.getCmp('dateID').getValue();
            frequencyDisplayVal = Ext.getCmp('dateID').getRawValue();
			frequencyDisplayVal = "Every "+frequencyDisplayVal+" day of the month";
        }
		else if (timeFrequenyCmboValue == 'date') {
            var fromDate = Ext.getCmp('fromDatePicker').getValue();
            var toDate = Ext.getCmp('toDatePicker').getValue();
            fromDate = Ext.Date.dateFormat(fromDate, mgrDateFormat);
            toDate = Ext.Date.dateFormat(toDate, mgrDateFormat);
			var frmtFromDate = formatDate(new Date(getDateFromFormat(fromDate, mgrDisplayDateFormat)), "MM/dd/yyyy");
			var frmtToDate = formatDate(new Date(getDateFromFormat(toDate, mgrDisplayDateFormat)), "MM/dd/yyyy");
	
			var currentDate = createpolicyview.jsonData['startDate'];
			currentDate = formatDate(new Date(getDateFromFormat(currentDate, mgrDisplayDateFormat)), "MM/dd/yyyy");
            var currentHrs = createpolicyview.jsonData['startHr'];
            var currentMins = createpolicyview.jsonData['startMin'];

            if (new Date(frmtFromDate + " " + str_hrValue + ":" + start_minValue) < new Date(currentDate + " " + currentHrs + ":" + currentMins)) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: dateMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                sub = false;
                return;
           }
           if (!checkDateTime(frmtFromDate,frmtToDate, str_hrValue, end_hrValue, start_minValue, end_MinValue)) {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: timeMsg,
                    buttons: Ext.Msg.OK,
                    icon:'iconExclamation'
                });
                sub = false;
                return;
            }
            if (str_hrValue.length == 1) {
                str_hrValue = '0' + str_hrValue;
            }
            if (start_minValue.length == 1) {
                start_minValue = '0' + start_minValue
            }
            if (end_hrValue.length == 1) {
                end_hrValue = '0' + end_hrValue;
            }
            if (end_MinValue.length == 1) {
                end_MinValue = '0' + end_MinValue;
            }
            frequencyVal = fromDate + " - " + toDate;
            frequencyDisplayVal = fromDate + " - " + toDate;
        }
        var sub = true;
        if (timeFrequenyCmboValue == '-1') {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: timeFreqMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        } else if (timeFrequenyCmboValue == 'dow' && Ext.getCmp('dayID').getValue() == '-1') {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: dayCmboMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        }  else if (timeFrequenyCmboValue == 'dow' && Ext.getCmp('repeatID').getValue() == '-1') {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: repeatCmboMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        } else if (timeFrequenyCmboValue == 'dom' && Ext.getCmp('dateID').getValue() == '-1') {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: dateCmboMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        }else if (timeFrequenyCmboValue != '*' && timeFrequenyCmboValue != 'date' && eval(str_hrValue + "*60+" + start_minValue) >= eval(end_hrValue + "*60+" + end_MinValue)) {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: hoursMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        } else if (timeFrequenyCmboValue == "*" && eval(str_hrValue + "*60+" + start_minValue) >= eval(end_hrValue + "*60+" + end_MinValue)) {
            Ext.Msg.show({
                title: MaintenanceMsg,
                msg: hoursMsg,
                buttons: Ext.Msg.OK,
                icon: 'iconExclamation'
            });
            sub = false;
            return;
        }
        if (sub) {
            var timelineObj = new Object();
            var entryExists = false;
            var op = createpolicyview.jsonData['operation'];
            /*			if( (op!=null && op=="modify") && existpolicydetails == '')
			{
				if(createpolicyview.jsonData.hasOwnProperty('existingPlolicyEntries') && !Ext.isEmpty(createpolicyview.jsonData['existingPlolicyEntries']))
				{
					console.log("exist policy"+createpolicyview.jsonData['existingPlolicyEntries']);
					existpolicydetails = createpolicyview.jsonData['existingPlolicyEntries'];
				}
			}*/
            var valueForProcessing = '';
            if (timeFrequenyCmboValue == 'date') {
                var fromDate1 = fromDate;
                var toDate1 = toDate;
                if (fromDate1 != null && fromDate1.length > 0) {
                    fromDate1 = Ext.util.Format.trim(fromDate1);
                }
                if (toDate1 != null && toDate1.length > 0) {
                    toDate1 = Ext.util.Format.trim(toDate1);
                }
                //fromDate1 = formatDate(new Date(getDateFromFormat(fromDate1, mgrDisplayDateFormat)), "MM/dd/yyyy");
               // toDate1 = formatDate(new Date(getDateFromFormat(toDate1, mgrDisplayDateFormat)), "MM/dd/yyyy");
				fromDate1 = formatDate(new Date(getDateFromFormat(fromDate1, currentDateFormat)), "MM/dd/yyyy");
				toDate1 = formatDate(new Date(getDateFromFormat(toDate1, currentDateFormat)), "MM/dd/yyyy");
                valueForProcessing = str_hrValue + ":" + start_minValue + "-" + end_hrValue + ":" + end_MinValue + "#" + fromDate1 + "|" + toDate1;
            } else {
                valueForProcessing = str_hrValue + ":" + start_minValue + "-" + end_hrValue + ":" + end_MinValue + "#" + frequencyVal;
            }
            if (existpolicydetails != null && existpolicydetails != "") {
                var policydetails = existpolicydetails.split(",");
                for (var i = 0; i < policydetails.length; i++) {
                    if (policydetails[i].toLowerCase() == valueForProcessing.toLowerCase()) {
                        entryExists = true;
                        break;
                    }
                }
            }
            if (!entryExists) {
                existpolicydetails = existpolicydetails + "," + valueForProcessing;
                var timelineDisp = "From  " + str_hrValue + ":" + start_minValue + " Hrs To  " + end_hrValue + ":" + end_MinValue + " Hrs";

                this.getModifypolicyGrid().store.add({
                    timeFrequency: frequencyDisplayVal,
                    timeline: timelineDisp,
                    valueField: valueForProcessing
                });

            } else {
                Ext.Msg.show({
                    title: MaintenanceMsg,
                    msg: selectionExistsMsg,
                    buttons: Ext.Msg.OK,
                    icon: 'iconExclamation'
                });
                return;
            }
        }
        /*var modifypolicyGrid = Ext.getCmp('modifyqpolicy');
		var selectedDispFreq = Ext.getCmp('Frequency').getRawValue();
		var selectedFreq = Ext.getCmp('Frequency').getValue();
		var startHrVal=Ext.getCmp('str_hr').getValue();
		var startMinVal=Ext.getCmp('start_min').getValue();
		var endHrVal=Ext.getCmp('end_hr').getValue();
		var endMinVal=Ext.getCmp('end_Min').getValue();
		var tline=''
		var tDispline=''
		if(selectedFreq!=null && selectedFreq=="date")
		{
			var stDateVal = Ext.getCmp('fromDatePicker').getValue();
			var endDateVal = Ext.getCmp('toDatePicker').getValue();
			var fromDispDate=formatDate(stDateVal, mgrDisplayDateFormat);
			var fromDate1=formatDate(stDateVal, "MM/dd/yyyy");
			var toDispDate=formatDate(endDateVal,mgrDisplayDateFormat);
			var toDate1=formatDate(endDateVal, "MM/dd/yyyy");
			tDispline=fromDispDate+" "+startHrVal+":"+startMinVal+" - "+toDispDate+" "+endHrVal+":"+endMinVal;
			tline=fromDate1+" "+startHrVal+":"+startMinVal+" - "+toDate1+" "+endHrVal+":"+endMinVal;

		}
		else
		{
			tDispline = startHrVal+":"+startMinVal+" - "+endHrVal+":"+endMinVal;
			tline = tDispline;
		}
		modifypolicyGrid.getStore().add({
				timeFrequency : selectedDispFreq, timeline : tDispline , selectedFreq : selectedFreq, selectedTimeline : tline
		});*/
    },
    changeFrequency: function (combo) {

        var selectedFreq = combo.getValue();
        //	console.log(selectedFreq);
		Ext.getCmp('dateOfWeeks').hide();
        if (selectedFreq != null && selectedFreq == "date") {
            var createpolicyview = this.getCreatepolicyview();
            Ext.getCmp('dayID').hide();
            Ext.getCmp('repeatID').hide();
            Ext.getCmp('monthLbl').hide();
            Ext.getCmp('OccursEveryLbl').hide();
            Ext.getCmp('occursLbl1').hide();
            Ext.getCmp('dateID').hide();
            Ext.getCmp('dayLbl').hide();
            Ext.getCmp('fromDatePicker').show();
            Ext.getCmp('toDatePicker').show();

            Ext.getCmp('str_hr').setValue(createpolicyview.jsonData['startHr']);
            Ext.getCmp('start_min').setValue(createpolicyview.jsonData['startMin']);
            Ext.getCmp('end_hr').setValue(createpolicyview.jsonData['endHr']);
            Ext.getCmp('end_Min').setValue(createpolicyview.jsonData['endMin']);
        } else {
            if (selectedFreq != null && selectedFreq == "dow") {
                Ext.getCmp('dayID').show();
                Ext.getCmp('repeatID').show();
				Ext.getCmp('monthLbl').show();
				Ext.getCmp('OccursEveryLbl').show();
				Ext.getCmp('dateOfWeeks').show();
            } else {
                Ext.getCmp('dayID').hide();
                Ext.getCmp('repeatID').hide();
				Ext.getCmp('monthLbl').hide();
				Ext.getCmp('OccursEveryLbl').hide();
            }

            if (selectedFreq != null && selectedFreq == "dom") {
                Ext.getCmp('dateID').show();
                Ext.getCmp('occursLbl1').show();
                Ext.getCmp('dayLbl').show();
                
            } else {
                Ext.getCmp('dateID').hide();
				Ext.getCmp('occursLbl1').hide();
                Ext.getCmp('dayLbl').hide();
				
            }
            Ext.getCmp('fromDatePicker').hide();
            Ext.getCmp('toDatePicker').hide();
            Ext.getCmp('str_hr').setValue("00");
            Ext.getCmp('start_min').setValue("00");
            Ext.getCmp('end_hr').setValue("23");
            Ext.getCmp('end_Min').setValue("59");
        }
    },
    loadAddPolicyPage: function () {
        Ext.Ajax.request({
            url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?from=defaultLoad&operation=create',
            scope: this,
            method: 'GET',
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);

                var mainViewPage = this.getMain();
                mainViewPage.removeAll();
                Ext.getCmp('associate_elemts').hide();
                Ext.getCmp('listSearch').hide();
                Ext.getCmp('addPolicyBtn').hide();
                Ext.getCmp('DeleteQMPoliciesBtn').hide();
                Ext.getCmp('policyGrpListIcon').hide();
                Ext.getCmp('migratePolicyGrpBtn').hide();
                Ext.getCmp('maintenanceAnalysisBtn').hide();
				if (!Ext.isEmpty(fromWizard))
				{
					Ext.getCmp('quickMainBackBtn').hide();
				}
				else
				{
					Ext.getCmp('quickMainBackBtn').show();
				}
                Ext.getCmp('separt1').hide();
                Ext.getCmp('separt2').hide();
                Ext.getCmp('separt3').hide();
                Ext.getCmp('separt4').hide();
                Ext.getCmp('separt5').hide();
				Ext.getCmp('separt6').hide();
                //Ext.getCmp('QuickMaintenancePageDescComp').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;' + policyCreatePageDesc + '</center>');
                mainViewPage.setTitle(addPolicyTitle);
				this.setToolTipForPanel(policyCreatePageDesc);
                mainViewPage.add({
                    xtype: 'createpolicyview',
                    jsonData: jsonData
                });
                isMaintenanceConfigPage = true;
            }
        });

    },
    AssociateTypeComboChange: function (combo) {
        //Ext.getCmp('searchbox').hide();
		//Ext.getCmp('searchbox2').hide();
        Ext.getCmp('associatepolicies').getStore().removeAll();
        Ext.getCmp('associatepolicies').reset();
		
/*		var subfilter1obj = Ext.getCmp('subFilter1');
		if(!Ext.isEmpty(subfilter1obj))
		{
			var subfilter1Strobj = subfilter1obj.getStore();
			if(!Ext.isEmpty(subfilter1Strobj))
			{
				subfilter1Strobj.removeAll();
				subfilter1obj.reset();
			}
		}

		var subfilter2obj = Ext.getCmp('subFilter2');
		if(!Ext.isEmpty(subfilter2obj))
		{
			var subfilter2Strobj = subfilter2obj.getStore();
			if(!Ext.isEmpty(subfilter2Strobj))
			{
				subfilter2Strobj.removeAll();
				subfilter2obj.reset();
			}
		} */

        var pol_val = '';
        var createpolicyview = this.getCreatepolicyview();
        var op = createpolicyview.jsonData['operation'];
        if (op == "modify") {
            pol_val = createpolicyview.jsonData['policyToView'];
        }
        var selectedAssociatedType = combo.getValue();
        var comboUrlParams = '';
		if (selectedAssociatedType == "Host") {
			comboUrlParams = 'from=infratypes&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Host&infratypename=Zone&serverType=-1';
		}
		else if (selectedAssociatedType == "Component") {
			comboUrlParams = 'from=infratypes&type=showPolicies&policyName=' + encodeURI(pol_val) + '&combination=Component&infratypename=Zone&serverType=-1';
		} else if (selectedAssociatedType == "Test") {
			comboUrlParams = 'from=componenttype&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Test&comptype=all&isTest=yes';
		} else if (selectedAssociatedType == "Descriptor") {
			comboUrlParams = 'from=test&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Descriptor&test=';
		} else if (selectedAssociatedType == "Descriptor for Component") {
			comboUrlParams = 'from=component&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Descriptor For Component&comp=&testcomp=';
		} else if (selectedAssociatedType == "Test For Host") {
			comboUrlParams = 'from=infratypes&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Test For Host&infratypename=-1&serverType=';
		} else if (selectedAssociatedType == "Test For Component") {
			comboUrlParams = 'from=infratypes&policyName=' + encodeURI(pol_val) + '&type=showPolicies&combination=Test For Component&infratypename=-1&serverType=-1';
		}
		Ext.Ajax.request({
			url: '/final/admin/QuickMaintenance/data/QuickMaintenancep.jsp?',
			params: comboUrlParams,
			scope: this,
			method: 'POST',
			success: function (response) {
				var jsonText = response.responseText;                    	
				var jsonData = Ext.decode(jsonText);

				var subFilter1 = Ext.getCmp('subFilter1');
				subFilter1.setFieldLabel(jsonData['ComboLabel']);
                var comboStr = subFilter1.getStore();
				if(!Ext.isEmpty(comboStr))
				{
					comboStr.removeAll();					
					comboStr.loadRawData(jsonData['ComboOptions']);
				}
				if (!Ext.isEmpty(fromWizard) || (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify'))
				{
					subFilter1.setValue('Component Type');
				}
				else
				{
					subFilter1.setValue(jsonData['selectedComboOption']);
				}
				subFilter1.show();

				if (selectedAssociatedType == "Host" || selectedAssociatedType == "Component" || selectedAssociatedType == "Test"  || selectedAssociatedType == "Descriptor for Component" || selectedAssociatedType == "Test For Host") {
                        if (selectedAssociatedType == "Test") {
                            Ext.getCmp('subFilter2').hide();
							//var searchbox=Ext.getCmp('searchbox');
							//searchbox.setWidth(200);
							//searchbox.show();
                        }
						else{
                            //var searchbox=Ext.getCmp('searchbox');
							//searchbox.setWidth(175);
							//searchbox.show();
                        }
                        subFilter1.fireEvent('select', subFilter1);
                    } else {
                       //var searchbox=Ext.getCmp('searchbox');
						//searchbox.setWidth(200);
						//searchbox.show();
                        Ext.getCmp('subFilter2').hide();
                    }
                },
                failure: function (response) {
                    console.log(response);
                }
            });
    },
    loadListPage: function () {
        this.getDataViewPanel('/final/admin/QuickMaintenance/data/QuickMaintenanceListJson.jsp');
        isMaintenanceConfigPage = false;
    },
    afterMainRender: function () {
		if (!Ext.isEmpty(fromWizard) || (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify'))
		{
			this.loadAddPolicyPage();
		}
		else
		{
			this.getDataViewPanel('/final/admin/QuickMaintenance/data/QuickMaintenanceListJson.jsp');
		}
	},
    deletePolicies: function (policyName, dataViewObj) {	
		
		var policyDispName = policyName;

		if (policyDispName && policyDispName.indexOf('|$|') > -1){
			policyDispName = policyName.substring(0, policyName.indexOf('|$|'));
			if(isLimitedAdmin != 'true'){
				policyDispName += '(' + policyName.substring(policyName.indexOf('|$|') + 3 ) + ')';// For admin user
			} 
		}

        Ext.Msg.confirm(MaintenanceMsg, deletePolicyAlertLbl + ' ' + policyDispName + ' ?', function (buttonText) {
            if (buttonText == "yes") {
                Ext.Ajax.request({
                    url: '/final/admin/QuickMaintenance/data/egMaintenanceDeletion.jsp',
                    params: 'PolicyName=' + encodeURIComponent(policyName) + '&from=QuickMaintenancePolicyDeletion',
                    scope: this,
                    method: 'POST',
                    success: function (response) {
                        var jsonText = response.responseText;
                        var jsonData = Ext.decode(jsonText);
                        var result = jsonData['result'];
                        if (result == 'success') {
							var associate_elemtsObj = Ext.getCmp('associate_elemts');
							var listSearchObj = Ext.getCmp('listSearch');
							var separt1Obj = Ext.getCmp('separt1');
							var separt2Obj = Ext.getCmp('separt2');
							var DeleteQMPoliciesBtnObj = Ext.getCmp('DeleteQMPoliciesBtn');

							if (jsonData['isUnplannedPoliciesAvailable'] == true)
							{
								polNames = jsonData['PolicyNames'];
								associate_elemtsObj.show();
								listSearchObj.show();
								separt1Obj.show();
								DeleteQMPoliciesBtnObj.show();
								separt2Obj.show();
							}
							else
							{	
								polNames = jsonData['PolicyNames'];
								associate_elemtsObj.hide();
								listSearchObj.hide();
								separt1Obj.hide();
								DeleteQMPoliciesBtnObj.hide();
								separt2Obj.hide();
							}
                            dataViewObj.store.load();
                            Ext.Msg.show({
                                title: MaintenanceMsg,
                                msg: policyDeleteMsg,
                                buttons: Ext.Msg.OK,
                                icon: 'iconInformation'
                            });
                        }
                    }
                });
            }
        });

    }
});
