Ext.define('QuickMenu.controller.Main',{
	extend: 'Ext.app.Controller',
		views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		this.control({
			
			'main combo[id="moduleCombo"]':
			{
				'change': this.comboLoad
			},
			'main button[id="finishbtn"]':
			{
				'click': this.updateData
			},
			'main button[id="assignMorebtn"]':
			{
				'click': this.updateData
			},
			'main button[id="backbtn"]':
			{
				'click':this.onBackBtnClick
			},
			'main button[id="clearbtn"]':
			{
				'click': this.updateData
			}
		});
	},
	comboLoad: function()
	{
		var modulename= Ext.getCmp('moduleCombo').getValue();
		Ext.Ajax.request({
			url:'/final/admin/QuickMenu/data/egQuickMenuJSON.jsp?moduleName='+modulename+'&newwindow='+newwin,
			method:'post',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var enableDisableList = publicJson['enableDisableList'];
				var selectedDisabledList = publicJson['selecteddisabledList'];
				var selectedEnabledList = publicJson['selectedEnabledList'];
		
				Ext.getCmp('itemselect').getStore().loadRawData(enableDisableList);
				Ext.getCmp('itemselect').setValue(selectedDisabledList);
			}
		});
	},
	updateData : function(btn)
	{
		var mode='';
		
		var btnId=btn.getId();

		if ( btnId == 'finishbtn')
		{
			mode='finish';
		}
		else if(btnId == 'clearbtn')
		{
			mode= 'clear';
		}else{
			mode= 'assign';
		}
		var modulename= Ext.getCmp('moduleCombo').getValue();
		var disabledLinks = Ext.getCmp('itemselect').getValue();
		var Arr = new Array();
		for (var i=0;i<Ext.getCmp('itemselect').getStore().getCount() ;i++)
		{
			var isData = false;
			var allValue = Ext.getCmp('itemselect').getStore().getAt(i).get('valueField');
			for( var j=0; j<disabledLinks.length; j++)
			{
				if( allValue == disabledLinks[j] )
				{
					isData = true;
					break;
				}
			}
			if( !isData )
			{
				Arr[Arr.length]=allValue;
			}
			var enabledLinks = Arr;
		}
		if( mode == 'assign' )
		{
			if(!Ext.isEmpty(enabledLinks)){
				Ext.Ajax.request({
				url:'/final/admin/QuickMenu/data/egQuickMenup.jsp?moduleName='+modulename+'&enabledQMList='+encodeURIComponent(enabledLinks.toString())+'&mode='+mode,
					method:'post',
					timeout:120000,
					scope:this,
					success:function(response)
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var successMsg = jsonData['success'];
						if ( successMsg == "true")
						{
							Ext.Msg.show({
								title: quickLinkTitle,
								msg: successMessage,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						}
					}
				});
			}
			else
			{
				Ext.Msg.show({
					title:quickLinkTitle,
					msg:errorMsgEnable,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}
		else
		{
			var update=false;
			var errorMsg;
			if(mode == 'clear'){
				if(!Ext.isEmpty(enabledLinks)){
					enabledLinks='';
					update=true;
				}else{
					errorMsg=errorMsgDisable;
				}
			}else{
				if(!Ext.isEmpty(enabledLinks)){
					update=true;
				}else{
					errorMsg=errorMsgEnable;
				}
			}
			if(update==true){
				Ext.Ajax.request({
				url:"/final/admin/QuickMenu/data/egQuickMenup.jsp?moduleName="+modulename+"&enabledQMList="+encodeURIComponent(enabledLinks.toString())+"&mode="+mode,
					method:'POST',
					scope:this,
					timeout:120000,
					success:function(response)
					{
						var jsonText = response.responseText;
						var publicJson = Ext.decode(jsonText);
						Ext.Msg.show({
							title:publicJson['Title'],
							msg:publicJson['Msg'],
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function (buttonId) {
								if (buttonId == "ok") {
									window.history.back();
								}
							}
						});
					}
				});
			}
			else{
				Ext.Msg.show({
					title:quickLinkTitle,
					msg:errorMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}
	},
	onBackBtnClick:function()
	{
		window.history.back();
	}
});



