Ext.define('RUMCollector.controller.AddRumCtrl',{
	extend: 'Ext.app.Controller',

	view: ['RUMCollector'],

	refs: [
		{
			selector: 'rumagent',
			ref: 'rumagent'
		},
	],

	init: function(){
		this.control({
			'rumagent': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildAddFieldData: function(){
		var hostname = Ext.getCmp('Hostname').getValue();
		var qstring = '';
		if (btnText == 'Add New RUM')
		{
			qstring = "addNew&ragent=null";
		}
		else
		{
			qstring = "changeip&ragent="+encodeURI(hostname);
		}
		Ext.Ajax.request({
			url: 'RUMCollector/data/EgNewRUMCollectorJson.jsp?Rtype='+qstring,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function(){
		Ext.getCmp('rumUrl').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Data Collector URL']);
		Ext.getCmp('Hostname').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Host/Nick Name']);
		Ext.getCmp('rumPrivateUrl').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Data Collector Private URL']);
	}

});



