Ext.define('RUMCollector.controller.DeleteRumCtrl',{
	extend: 'Ext.app.Controller',

	view: ['DeleteRUMCollectors'],

	refs: [
		{
			selector: 'deleterumcollector',
			ref: 'deleterumcollector'
		},
	],

	init: function(){
		this.control({
			'deleterumcollector':
			{
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildDeleteFieldData: function() {
		Ext.Ajax.request({
			url: 'RUMCollector/data/DeleteRUMCollectorsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildInternalHostsData: function(HostName) {
		Ext.Ajax.request({
			url: 'RUMCollector/data/deletegroupsremotepJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildAssDissAgnt: function(HostName) {
		Ext.Ajax.request({
			url: 'RUMCollector/data/DeleteRUMCollectorsJson.jsp?eagent='+HostName,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function() {
		
		Ext.getCmp('NoDelSearchFound').hide();
		Ext.getCmp('agents').getStore().loadRawData(publicJSON['remoteAgentArray']);
		Ext.getCmp('deleteBtn').setText(publicJSON['screenLabels']['admin.common.Delete']);
	}

});



