Ext.define('RUMCollector.controller.Main',{
	extend:'Ext.app.Controller',

	views:['RUMCollectors','RUMCollector','AssignRUMCollector','DeleteRUMCollectors'],
	requires : ['RUMCollector.view.RUMCollector'],

	refs:[
		{selector:'rumcollectors', ref:'rumcollectors'},
		{selector:'assignremoteagent', ref:'assignremoteagent'},
		{selector:'deleterumcollector', ref:'deleterumcollector'},
		{selector:'rumcollector', ref:'rumcollector'},
		
	],

	init:function(){
		appRmtCnt = this;
		this.buildMainData()

		this.control({
			'rumcollectors': {
				'afterrender': this.afterMainRender
			},
			'rumcollectors trigger[name="gridRmtSearch"]': {
				'change': this.mainGridSearch
			},
			'rumcollectors button[id="addRumCollector"]': {
				'click': this.addRum
			},
			'rumcollectors button[id="DeleteRmtOver"]': {
				'click': this.deleteOver
			},
			'rumcollector button[id="updateBtn"]': {
				'click' : this.addUpdate
			},
			'rumcollectors button[id="associateDissociate"]': {
				'click': this.associateDissociate
			},
			'rumcollectors button[id="deleteRUMColector"]': {
				'click': this.deleteRUMCollector
			},
			'assignremoteagent combo[id="rmtAgent"]': {
				'select': this.comboLoad
			},
			'assignremoteagent button[id="UpdateBTN"]': {
				'click': this.updation
			},
			'assignremoteagent button[id="backbutton"]': {
				'click': this.backbutton
			},
			'deleterumcollector button[id="deleteBtn"]': {
				'click' : this.deletefun
			},
			'deleterumcollector trigger[name="agentsearch"]': {
				'change': this.mainFormEvent
			},
			'deleterumcollector button[id="backDelbutton"]': {
				'click': this.backDelButton
			},

		});
	},
	buildMainData: function(){
		Ext.Ajax.request({
			url: 'RUMCollector/data/EgDispRUMCollectorJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					
				}
			}
		});
	},

	handleDeleteIconClick: function(gridView, rowIndex, colIndex){
		
		var DispValues = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var HostName = DispValues.get('Hostname');
		this.deleteTask(HostName,rowIndex);
	},

	handleEditIconClick: function(gridView, rowIndex, colIndex){
		btnText = 'Change RUM';
		var rec = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var HostName = rec.get('Hostname');
		var rumUrl = rec.get('rumUrl');
		var rumPrivateUrl = rec.get('rumPrivateUrl');
		this.showEditWindow(HostName,rumUrl,rumPrivateUrl);
	},

	showEditWindow: function(HostName,rumUrl,rumPrivateUrl){
		
		Ext.widget('rumcollector').show();
		Ext.getCmp('Hostname').setValue(HostName).setReadOnly(true);
		Ext.getCmp('rumUrl').setValue(rumUrl);
		Ext.getCmp('rumPrivateUrl').setValue(rumPrivateUrl);
		Ext.getCmp('updateBtn').setText('Update');
		Ext.getCmp('AddModRmtView').setTitle(rmtModPageTitle);
		this.getController('RUMCollector.controller.AddRumCtrl').buildAddFieldData();
		Ext.getCmp('rumUrl').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Data Collector URL']);
		Ext.getCmp('Hostname').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Host/Nick Name']);
		Ext.getCmp('rumPrivateUrl').setFieldLabel(publicJSON['screenLabels']['admin.remote.RUM Data Collector Private URL']);
		rumCollectorUrl=rumUrl;

	},
    commonDelete: function(HostName,rowIndex){
		var me = this;
		Ext.Msg.show({
			title: 'DELETE RUM DATA COLLECTOR',
			msg: deleteSingleRmtAgntMsg+"'"+HostName+"'"+"?",
			buttons: Ext.Msg.YESNO,
			fn: function(response) {
			if(response === 'yes') {
					Ext.Ajax.request({
					url: 'RUMCollector/data/EgnewrumcollectorspJson.jsp?mode=del&hostname='+HostName,
					method: 'POST',
					success: function( response )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1']);
							}
							else
							{
								var resultStatus = publicJSON['error'];
								Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1']);
							}
							Ext.getCmp('gridRmtSearch').setRawValue('');
							me.buildMainData();
							var resultsData = publicJSON['gridRmtAgents'];
							if (resultsData == null || resultsData.length == 0)
							{
								Ext.getCmp('gridRmtSearch').disable()
								Ext.getCmp('associateDissociate').disable();
								Ext.getCmp('deleteRUMColector').disable();
								Ext.getCmp('gridRmtDisplay').store.loadData('');
								Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtDesc+'</td></tr></table></td></tr></table>';
								Ext.getCmp('gridRmtDisplay').getView().refresh();
							}
							else
							{
								Ext.getCmp('gridRmtSearch').enable()
								Ext.getCmp('gridRmtDisplay').show();
								Ext.getCmp('associateDissociate').enable();
								Ext.getCmp('deleteRUMColector').enable();
								Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
								var view = Ext.getCmp('gridRmtDisplay').getView();
								var headerCt = view.headerCt;
								var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
								if (checkHd) {
									checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
								}
							}
						}
					}
				});
			}
		}
	});
	},
    deleteTask: function(HostName,rowIndex){
		this.commonDelete(HostName,rowIndex);
	},

	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridRmtSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request({
		url: 'RUMCollector/data/EgDispRUMCollectorJson.jsp?egTitleSearchStr='+gridsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['gridRmtAgents'];
			Ext.getCmp('gridRmtDisplay').show();
			Ext.getCmp('associateDissociate').enable();
			Ext.getCmp('deleteRUMColector').enable();
			if (value != null && value.length > 0)
			{
				Ext.getCmp('gridRmtDisplay').store.loadData(publicJSON['gridRmtAgents']);
			}
			else
			{
				Ext.getCmp('gridRmtDisplay').store.loadData('');
				Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+','+"'"+gridsearch+"'"+'</td></tr></table></td></tr></table>';
				Ext.getCmp('gridRmtDisplay').getView().refresh();
			}
		}
		});
	},
	addRum: function(btn){
		btnText = btn.text;
		Ext.widget('rumcollector').show();
		Ext.getCmp('updateBtn').setText('Add');
		Ext.getCmp('AddModRmtView').setTitle(rumAddPageTitle);

		this.getController('RUMCollector.controller.AddRumCtrl').buildAddFieldData();
		this.getController('RUMCollector.controller.AddRumCtrl').afterMainRender();
	},

	deleteOver: function(){
		
		var HostNameToDel = Ext.getCmp('DispRmtHostName').getValue();
		window.location.href = "RUMCollector/data/EgnewrumcollectorspJson.jsp?mode=del&eagent="+HostNameToDel;
	},
	checkdots: function(){
		var hostname = Ext.getCmp('Hostname').getValue();
		if(hostname.charAt(0) == '.' || hostname.charAt(hostname.length - 1) == '.')
		{
			Ext.Msg.alert("RUM DATA COLLECTOR",checkdots);
			return false;
		}
		else
		{
			for(var k=0;k < hostname.length;k++)
			{
				if(hostname.charAt(k) == '.' && hostname.charAt(k + 1) == '.')
				{
					Ext.Msg.alert("RUM DATA COLLECTOR",checkconsecutivedots);
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	},
	validationForAddModify: function(){
		var rumUrl = Ext.getCmp('rumUrl').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();
		var checkD =this;
		var checkDotVal = checkD.checkdots();

		var isAllowHostName = "<%=isAllowHostName%>";	
		var regExp = /^(([0-9]+\.)+){3}[0-9]+$/;
		var hostnameIsIP = regExp.test(hostname);
		var isExist = false;
		var host_Name=true;
		if (btnText == 'Add New RUM')
		{
			
			if (rmtListStr != null)
			{
				for(var j=0;j<rmtListStr.length;j++)
				{
					var rmt_varListStr = rmtListStr[j].trim();
					if(rmt_varListStr.toLowerCase() == hostname.toLowerCase())
					isExist = true;
				}
			}
		}
		if(hostname!=null && hostname=='')
		{
			Ext.Msg.alert("RUM Data Collector","Please Enter RUM Data Collector Nick Name");
			Ext.getCmp('Hostname').focus();
			return false;
		}
		else if(!checkblank(hostname))
		{
			Ext.Msg.alert("RUM DATA COLLECTOR",checkBlankHostName);;
			return false;
		}
		else if(!checkspace(hostname))
		{
			Ext.getCmp('Hostname').focus();
			return false;
		}
		else if(!checkspecial(hostname,"`~!@#$%^&*()+={}[]|:;\"\'<>,?\\\/"))
		{
			Ext.getCmp('Hostname').focus();
			return false;
		}
		else if(!checkDotVal)
		{
			Ext.getCmp('Hostname').focus();
			return false;
		}
		else if(rumUrl!=null && rumUrl=='')
		{
			Ext.Msg.alert("RUM Data Collector","Please Enter RUM Data Collector URL");
			Ext.getCmp('rumUrl').focus();
			return false;
		}
		else if(isExist)
		{
			Ext.Msg.alert("RUM DATA COLLECTOR",hostNameByOtherAgent);
			Ext.getCmp('Hostname').focus();
			return false;
		}
		//else if((!validateSingleUrl(rumUrl) )
		else if((!validateSingleUrl(rumUrl) ) && (!validateIPv6Url(rumUrl)))
		{
			Ext.Msg.alert("RUM DATA COLLECTOR",'Invalid URL');
			Ext.getCmp('rumUrl').focus();
			return false;
		}
		//else if(rumUrl != null && rumUrl.indexOf("::") >= 0 && !validateIPv6Url(rumUrl))
		//{
			//Ext.getCmp('rumUrl').focus();
		//}
		else
		{
			return true;
		}
	},
	associateDissociate: function(btn){
		assignRUM = "";
		Ext.getCmp('remoteviewport').removeAll();
		this.getController('RUMCollector.controller.AssignRumCtrl').buildFieldData();
		Ext.getCmp('remoteviewport').add({xtype: 'assignremoteagent'});
		this.getController('RUMCollector.controller.AssignRumCtrl').afterMainRender();
	},
	backbutton: function(){
		fromAssignRum = "";
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'rumcollectors'});
		this.afterMainRender();
	},

	deleteRUMCollector: function(btn){
		Ext.getCmp('remoteviewport').removeAll();
		this.getController('RUMCollector.controller.DeleteRumCtrl').buildDeleteFieldData();
		Ext.getCmp('remoteviewport').add({xtype: 'deleterumcollector'});
		this.getController('RUMCollector.controller.DeleteRumCtrl').afterMainRender();
		var hasDelRumAgnt = publicJSON['remoteAgentArray'];
		if (hasDelRumAgnt = "" || hasDelRumAgnt.length == 0)
		{
			Ext.getCmp('agentsearch').disable();
		}
		else
		{
			Ext.getCmp('agentsearch').enable();
		}
	},
	deletefun: function(){
		var deleteRemote = Ext.getCmp('agents').getValue();
		if (deleteRemote.length == 0 || deleteRemote == "")
		{
			Ext.Msg.alert(deleteRumPageTitle,publicJSON['screenLabels']['admin.common.Please select RUM Collector(s)']);
		}
		else
		{
			Ext.MessageBox.confirm(deleteRumPageTitle, deleteMsg,this.deleting,this);
		}
	},

	handleDeleteSelected: function() {
		//alert("handleDeleteSelected");
		var grid=Ext.getCmp('gridRmtDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.alert('RUM Data Collectors',noRmtSelected);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Hostname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.confirm('RUM Data Collectors',deleteSelected, function(buttonText) {
			if (buttonText == "yes") 
			{
				var qrString = "from=deleteRUMCollectorsPage"+"&rumCollectors="+selectedGroups;
				Ext.Ajax.request({
				url: 'RUMCollector/data/deletegroupsremotepJson.jsp?index=RUM&'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							//Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1'],appRmtCnt.buildMainData());
							Ext.MessageBox.alert({
							title: resultStatus['title'],
							msg: resultStatus['message1'],
							icon:'iconInformation',
							buttons: Ext.Msg.OK,
							fn: function()
							{
								Ext.getCmp('gridRmtDisplay').getSelectionModel().deselectAll(true);
								appRmtCnt.buildMainData();
								appRmtCnt.afterMainRender();

							}
							});
						}
						else
						{
							var errorStatus = publicJSON['error'];
							Ext.MessageBox.alert(errorStatus['title'],errorStatus['message1'],errorStatus['message2'],errorStatus['message3'],errorStatus['message4'],refreshDelete);
						}
					}
					//Ext.getCmp('gridRmtDisplay').store.loadData(publicJSON['gridRmtAgents']);
				}
			});
			}
		});
	},

	deleting: function(btn){
		this.getController('RUMCollector.controller.DeleteRumCtrl').buildDeleteFieldData();
		if (btn == 'yes')
		{
			var rumCollector = Ext.getCmp('agents').getValue();
			if (rumCollector == null)
			{
				Ext.Msg.alert(deleteRumPageTitle,publicJSON['screenLabels']['admin.common.Please select RUM Collector(s)']);
			}
			else
			{
				var DeleteUrl = publicJSON['deleteLink'];
				var qrString = "from=deleteRUMCollectorsPage"+"&rumCollectors="+rumCollector;
				Ext.Ajax.request({
				url: 'RUMCollector/data/deletegroupsremotepJson.jsp?index=RUM&'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1'],refreshDelete);
						}
						else
						{
							var errorStatus = publicJSON['error'];
							Ext.MessageBox.alert(errorStatus['title'],errorStatus['message1'],errorStatus['message2'],errorStatus['message3'],errorStatus['message4'],refreshDelete);
						}
					}
					Ext.getCmp('agentsearch').setRawValue('');
				}
			});
			}
		}
	},

	mainFormEvent : function(obj){
		this.getController('RUMCollector.controller.DeleteRumCtrl').buildDeleteFieldData();
		var compsearch = Ext.getCmp('agentsearch').getValue();
		if (compsearch == "" || compsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		
		Ext.Ajax.request({
		url: 'RUMCollector/data/DeleteRUMCollectorsJson.jsp?compsearch='+compsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['searchArr'];
			if (value != null && value.length > 0)
			{
				Ext.getCmp('agents').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('rmtTitleLblId').show();
				Ext.getCmp('NoDelSearchFound').hide();
				Ext.getCmp('agents').getStore().loadRawData(publicJSON['searchArr']);
			}
			else
			{
				Ext.getCmp('agents').hide();
				Ext.getCmp('deleteBtn').hide();
				Ext.getCmp('rmtTitleLblId').hide();
				Ext.getCmp('NoDelSearchFound').show();
				Ext.getCmp('DelSearch').update('<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+','+"'"+compsearch+"'"+'</td></tr></table></td></tr></table>');
			}
		}
		});
	},
	comboLoad: function(){
		
		this.getController('RUMCollector.controller.AssignRumCtrl').buildFieldData();

		var eagent = Ext.getCmp('rmtAgent').getValue();
		if (eagent == -1)
		{
			eagent = "null";
		}
		Ext.Ajax.request({
				url: 'RUMCollector/data/EgConfigRUMCollectorsJson.jsp?eagent='+eagent,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					if (Ext.getCmp('itemselectrumcollector').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectrumcollector').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselectrumcollector').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectrumcollector').toField.store.removeAll();
					}

					Ext.getCmp('itemselectrumcollector').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
					Ext.getCmp('itemselectrumcollector').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
				}
			});
	},
	updation: function(btn){
		var eagent = Ext.getCmp('rmtAgent').getValue();
		if (eagent == '-1')
		{
			Ext.Msg.alert(assignRumPageTitle,publicJSON['screenLabels']['admin.test.Please choose a RUM Collector']);
		}
		else
		{
			var existingAgents = publicJSON['existingAgents'];
			
			if (existingAgents != null && existingAgents != "undefined")
			{
				var existAgentsArr = existingAgents.split(",");
			}

			var prevManagedHostByOther = publicJSON['ManagedHostByOthrAgnt'];
			var updateUrrl = publicJSON['UpdateLink'];
			var itemSelectorVal = publicJSON['itemSelectorArray']

			var managedHostsByOther = Ext.getCmp('itemselectrumcollector').getValue();
			
			if (managedHostsByOther == undefined && managedHostsByOther!='')
			{
				Ext.Msg.alert(assignRumPageTitle,publicJSON['screenLabels']['admin.remote.Please choose atleast one RUM Collector to manage or unmanage']);
				return;
			}

			var fmanage = new Array();
			var Arr = new Array();
			var noOfManAgent = Ext.getCmp('itemselectrumcollector').fromField.store.getCount();
			var allValue = new Array();
			for (var i=0;i < noOfManAgent;i++)
			{
				allValue[allValue.length]=Ext.getCmp('itemselectrumcollector').fromField.store.getAt(i).get('valueField');
			}
			for (var m=0;m<allValue.length;m++ )
			{
				var isData = false;
				if (existingAgents != null && existingAgents.length > 0)
				{
					var existAgentsArr = existingAgents.split(",");
					for (var j=0;j<existAgentsArr.length;j++ )
					{

						if (allValue[m] == existAgentsArr[j])
						{
							isData = true;
							break;
						}
					}
					if (!isData)
					{
						Arr[Arr.length] = allValue[m];
					}
				}
				else
				{
					Arr[Arr.length] = allValue[m];
				}
			}
			var funmanage = Arr;

			if (existingAgents == "undefined" || existingAgents == null)
			{
				existingAgents = "null";
			}
			newmanageCmp=funmanage;
			//alert("funmanage"+funmanage);
			var qrString = "fmanage="+fmanage+"&existingAgents="+existingAgents+"&funmanage="+funmanage+"&eagent="+eagent;
			if(funmanage!=null && funmanage!='')
			{
				Ext.Ajax.request({
				url: 'RUMCollector/data/EgconfigrumcollectorspJson.jsp?'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resulturl = publicJSON['resultUrl'];
							Ext.Msg.alert(assignRumPageTitle,publicJSON['screenLabels']['SucessfullyUpdated'],refreshAssignRum);
						}
						else
						{
							var errorStatus = publicJSON['error'];
							Ext.MessageBox.alert(errorStatus['title'],errorStatus['message1'],refreshAssignRum);
						}
					}
				}
				});
			}else
			{
				Ext.Msg.alert(assignRumPageTitle,'The association/disassociation of hosts could not be completed.');
			}
			
		}
	},
	backDelButton: function(btn){
		fromDeleteRum = "";
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'rumcollectors'});
		this.afterMainRender();
	},
	afterMainRender : function(){
		
		if (fromAssignRum != null && fromAssignRum == "true")
		{
			
			Ext.getCmp('remoteviewport').removeAll();
			this.getController('RUMCollector.controller.AssignRumCtrl').buildFieldData();
			Ext.getCmp('remoteviewport').add({xtype: 'assignremoteagent'});
			this.getController('RUMCollector.controller.AssignRumCtrl').buildGivenAgentData(assignRUM);
			this.getController('RUMCollector.controller.AssignRumCtrl').afterMainRender();
		}
		else if (fromDeleteRum != null && fromDeleteRum == "true")
		{
			Ext.getCmp('remoteviewport').removeAll();
			this.getController('RUMCollector.controller.DeleteRumCtrl').buildDeleteFieldData();
			Ext.getCmp('remoteviewport').add({xtype: 'deleterumcollector'});
			this.getController('RUMCollector.controller.DeleteRumCtrl').afterMainRender();
			
		}
		else
		{
			
			var resultsData = publicJSON['gridRmtAgents'];
			if (resultsData == null || resultsData.length == 0)
			{
				Ext.getCmp('associateDissociate').disable();
				Ext.getCmp('deleteRUMColector').disable();
				Ext.getCmp('gridRmtDisplay').store.loadData('');
				Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtDesc+'</td></tr></table></td></tr></table>';
				Ext.getCmp('gridRmtDisplay').getView().refresh();
			}
			else
			{
				Ext.getCmp('associateDissociate').enable();
				Ext.getCmp('deleteRUMColector').enable();
				Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
			}
			var noRmtFound = publicJSON['NoRmtFound'];
			if (noRmtFound == "true")
			{
				Ext.getCmp('gridRmtSearch').disable();
			}
			else
			{
				Ext.getCmp('gridRmtSearch').enable();
			}
		}
	},
		addUpdate : function(btn){
		var me = this;
		this.getController('RUMCollector.controller.AddRumCtrl').buildAddFieldData();
		var rumUrl = Ext.getCmp('rumUrl').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();

		var mode= '';
		if (btnText == 'Add New Collector')
		{
			mode = 'add';
		}
		else
		{
			mode = 'modifyUrl';
		}
		var me = this;
		var checkValidation = me.validationForAddModify();

		if (checkValidation)
		{
			var rumUrl = Ext.getCmp('rumUrl').getValue();
			var rumPrivateUrl = Ext.getCmp('rumPrivateUrl').getValue();

			var hostname = Ext.getCmp('Hostname').getValue();
			//var qrString =mode+"&rumUrl="+rumUrl+"&hostname="+hostname+"&rumPrivateUrl="+rumPrivateUrl;
			var qrString =mode+"&rumUrl="+encodeURIComponent(rumUrl)+"&hostname="+hostname+"&rumPrivateUrl="+encodeURIComponent(rumPrivateUrl);
			Ext.Ajax.request({
			url: 'RUMCollector/data/EgnewrumcollectorspJson.jsp?mode='+qrString,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success")
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.alert(resultStatus['title'],resultStatus['message1'],
						function(btn){
							Ext.getCmp('AddModRmtView').destroy();
							if(mode=='modifyUrl')
							{
								if(rumCollectorUrl!=rumUrl)
								{
									
									Ext.Msg.alert('RUM Data Collector','The RUM Data Collector URL has been modified. Please download the agent files from the modified components and deploy it in the corresponding applications.');
									rumCollectorUrl=rumUrl;
								}
								
							}
						});
						
						
					}
					else
					{
						
						var errorStatus = publicJSON['error'];
						Ext.MessageBox.alert(errorStatus['title'],errorStatus['message1']+errorStatus['message2'],
							function(btn){
								Ext.getCmp('AddModRmtView').destroy();
						});

						
					}
					me.buildMainData();
					var resultsData = publicJSON['gridRmtAgents'];
					Ext.getCmp('gridRmtSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					Ext.getCmp('deleteRUMColector').enable();

					Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridRmtSearch').setRawValue('');
				}
			}
		});
		}
	}

});

	function refreshDelete(btn){
		
		Ext.Ajax.request({
		url: 'RUMCollector/data/DeleteRUMCollectorsJson.jsp',
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				 publicJSON = Ext.decode( jsonText );
			}
		}
	});
	Ext.getCmp('agents').getStore().loadData(publicJSON['remoteAgentArray']);
	}

	function refreshAssignRum(btn){
	var eagent = Ext.getCmp('rmtAgent').getValue();
	
	Ext.Ajax.request({
		url: 'RUMCollector/data/EgConfigRUMCollectorsJson.jsp?eagent='+eagent,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			//var noOfmanageCmp=Ext.getCmp('itemselectrumcollector').fromField.store.getCount();
			
			if (Ext.getCmp('itemselectrumcollector').fromField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectrumcollector').fromField.store.removeAll();
			}
			if (Ext.getCmp('itemselectrumcollector').toField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectrumcollector').toField.store.removeAll();
			}
			if(newmanageCmp!=null && newmanageCmp!='')
			{
				
				Ext.Msg.alert('RUM Data Collector','The RUM Data Collector has been assigned/modified for one or more components. Please download the agent files from the modified components and deploy it in the corresponding applications.');
			}
			Ext.getCmp('itemselectrumcollector').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
			Ext.getCmp('itemselectrumcollector').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);

		}
	});
}


function validateSingleUrl(paramValue)
{
	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;

	if (toMatch.test(paramValue))
	{
		return true;
	}
	else
	{
		return false;
	}
}

function validateIPv6Url(srcUrl)
{
	var idx = srcUrl.indexOf(":");
	if (idx == -1) // Not an URL
	{
		return false; 
	}
	tmpUrl = srcUrl.substring(idx+1);
	if (srcUrl.toLowerCase().startsWith("http"))
	{
		idx = srcUrl.indexOf("/");
		urlPrefix = srcUrl.substring(0,idx+2);
		tmpUrl = srcUrl.substring(idx+2);
	}
	var lastIndex = tmpUrl.lastIndexOf(":");
	if (lastIndex >=0)
	{
		tmpUrl = tmpUrl.substring(0,lastIndex);
	}
	var firstPos = tmpUrl.indexOf("[");
	var lastPos = tmpUrl.indexOf("]");
	if (firstPos >=0 && lastPos >=0)
	{
		tmpUrl = tmpUrl.substring(firstPos+1,lastPos);
	}
	if(checkIPv6(tmpUrl))
	{
		return true;
	}
	else
	{
		return false;
	}
}
