Ext.define('RUMCollector.view.DeleteRUMCollectors', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.deleterumcollector',
	cls:'outerpanel',
	id:'deleteRUMColector',
	title: deleteRumPageTitle,
	margin:'8 8 0 8',

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		layout:{pack:'center'},
		width:'100%',
		height: 25,
		padding: 3,
		items: [
				{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+deleteRumPageDesc+".</center>",
				
			}
		]
	}],

	items: [
		{
			xtype:'container',
			layout:'vbox',
			padding:3,
			items:[
					{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					id: 'agentsearch',
					name: 'agentsearch',
					margin: '1 5 1 3',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
				 
					   // TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
					   // single triggerCls config. Should rethink this, perhaps something more structured like a list of
					   // trigger config objects that hold cls, handler, etc.
					   // triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
						me.trigger1Cls = me.triggerCls;
						}
					 
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						Ext.getCmp('agents').show();
						Ext.getCmp('deleteBtn').show();
						Ext.getCmp('NoDelSearchFound').hide();
						this.reset(); 
					},
					onTrigger2Click : function() {
						appRmtCnt.mainFormEvent();
					}
				}
			]
		},
		{
			xtype: 'container',
			id: 'NoDelSearchFound',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 15,
			items: [
				{
					xtype: 'label',
					id: 'DelSearch',
					html: '<table><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/exclamation-icon.gif"></td></tr><tr><td align="center" style="font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:10px">'+NoRmtFound+'</td></tr></table></td></tr></table>',
				}
			]
		},
		{
			xtype: 'container',
			id: 'rmtTitleLblId',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'label',
					text: rmtTitleLbl,
					style: {'font-weight':'bold'},
					width: 400
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch',
			},
			flex: 1,
			margin: '15 10 10 10',
			items: [
				{
					xtype: 'multiselectfieldSi',
					cls:'multiselect',
					width: 400,
					autoScroll: true,
					scroll: false,
					name: 'multiselect',
					id: 'agents',
					name: 'agents',
					value: '',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 20 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: 'Delete',
					id: 'deleteBtn',
					width: 80
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'backDelbutton',
			text : bckLabel
		}
	]

});



