Ext.define('RemoteAgent.controller.AddRmtCtrl',{
	extend: 'Ext.app.Controller',

	view: ['RemoteAgent'],

	refs: [
		{
			selector: 'remoteagent',
			ref: 'remoteagent'
		},
	],

	init: function(){
		this.control({
			'remoteagent': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildAddFieldData: function(){
		var hostname = Ext.getCmp('Hostname').getValue();
		var qstring = '';
		if (btnText == 'Add')
		{
			qstring = "addNew&ragent=null";
		}
		else
		{
			qstring = "changeip&ragent="+encodeURI(hostname);
		}
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgNewRemoteAgentsJson.jsp?Rtype='+qstring,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function(){
		Ext.getCmp('HostIp').focus();

		Ext.getCmp('hostIpCt').setFieldLabel(publicJSON['screenLabels']['admin.remote.Agent IP Address']);
		Ext.getCmp('Hostname').setFieldLabel(publicJSON['screenLabels']['admin.remote.Agent Host/Nick Name']);
		Ext.getCmp('addAsExtAgent').setFieldLabel(publicJSON['screenLabels']['admin.remote.Add as External agent']);
		Ext.getCmp('updateBtn').setText(publicJSON['screenLabels']['admin.remote.Update']);

		Ext.getCmp('HostIp').setValue(publicJSON['hostValue']['AgentIp']);
		Ext.getCmp('Hostname').setValue(publicJSON['hostValue']['AgenthostNic']);

		var rtype = publicJSON['rtype'];
		var HostIp = Ext.getCmp('HostIp').getValue();
		if (RmtIpAgent == HostIp)
		{
			Ext.getCmp('addAsExtAgent').hide();
		}

		var notextAgent = publicJSON['extnothasragent'];
		if (notextAgent == 'No')
		{
			Ext.getCmp('addAsExtAgent').hide();
		}
		else
		{
			Ext.getCmp('addAsExtAgent').show();
			Ext.getCmp('addasExtNo').setValue(true);
		}

		//if (rtype == 'changeip')
		//{
			//Ext.getCmp('HostIp').setReadOnly(true);
		//}
	}

});



