Ext.define('RemoteAgent.controller.AgentVmStatistics',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'vmstatistics', ref:'vmstatistics'},
		{selector:'vmcomponenttable', ref:'vmcomponenttable'},
	],
	init:function(){
		me = this;
		this.control({
			'vmstatistics':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	afterMainRender: function()
	{
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgVmLogDetailsJson.jsp?reqfrom=navlink&from=navlink',
			method: 'POST',
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					vmComponentWindow = Ext.widget('vmcomponenttable');
					var jsonText = response.responseText;
					var publicJson = Ext.decode(jsonText);
					var remoteAgentArr = publicJson['remoteAgentArr'];
					Ext.getCmp('remoteAgentCombo').getStore().removeAll();
					Ext.getCmp('remoteAgentCombo').getStore().loadRawData(remoteAgentArr);
					Ext.getCmp('remoteAgentCombo').setValue(remoteAgentArr[0].valueField);
					Ext.getCmp('noRemoteAgentSelectContainer').show();
				}
			},
			failure: function()
			{
			}
		});
	},
});



