Ext.define('RemoteAgent.controller.AssignRmtCtrl',{
	extend:'Ext.app.Controller',

	views:['AssignRemoteAgent'],

	refs:[
		{
			selector:'assignremoteagent',
			ref:'assignremoteagent'
		},
	],

	init:function(){
		this.control({
			'assignremoteagent': {
				'afterrender': this.afterMainRender
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgConfigRemoteAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildGivenAgentData: function(assignAgent){
		var me = this;
		var othereagent = "null";
		if (assignAgent == -1)
		{
			assignAgent = "null";
		}
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgConfigRemoteAgentsJson.jsp?eagent='+assignAgent+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectremoteagent').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectremoteagent').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectremoteagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectremoteagent').toField.store.removeAll();
				}

				Ext.getCmp('itemselectremoteagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
				me.initializeFields2();
				if (assignAgent == "null")
				{
					Ext.getCmp('otherRmtAgent').setDisabled(true);
				}
				else
				{
					Ext.getCmp('otherRmtAgent').setDisabled(false);
				}
				Ext.getCmp('itemselectremoteagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	initializeFields : function(){
		var me=this;
		var executiveForm = this.getAssignremoteagent().getForm();
		if (assignAgent != null || assignAgent != '')
		{
			me.setValueWithOptionInList(executiveForm, 'rmtAgent', publicJSON['remoteAgentsArray'],assignAgent);
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'rmtAgent', publicJSON['remoteAgentsArray'],'');
		}
	},

	initializeFields2 : function(){
		var me=this;
		var executiveForm = this.getAssignremoteagent().getForm();
		me.setValueWithOptionInList(executiveForm, 'otherRmtAgent', publicJSON['otherRemoteAgentsArray'],'');
	},

	setValueWithOptionInList : function(form, fieldName, list, value){
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(){
		Ext.getCmp('rmtAgent').setFieldLabel(publicJSON['screenLabels']['admin.test.Remote agent']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.remote.Update']);

		var vectorVal = publicJSON['vector'];
		var host = vectorVal.toString().split(",");

		if (vectorVal.length >= 1)
		{
			var warnSam = "<div style='text-align:center;font-size:11px;width:700px;margin:0 auto; background-color: #FEEFB3;border:red 1px solid;padding:5px;'><center><div class='iconExclamation'></div></center><div style='margin:2px 4px'>The following components have not been configured for agentless monitoring</div><div style='margin:4px 4px'><b>"+host+"</b></div><div >Immediately go to&nbsp;<a href='EgDispServer.jsp?qctr=0'><b>Add / Modify</b></a>&nbsp;and configure the remote agents of these components</div></div>";
			Ext.getCmp('warningMsg').update(warnSam);
		}
		else
		{
			Ext.getCmp('warningMsg').hide();
		}
		this.initializeFields();
		this.initializeFields2();
	}

});



