Ext.define('RemoteAgent.controller.DeleteRmtCtrl',{
	extend: 'Ext.app.Controller',

	view: ['DeleteRemoteAgents'],

	refs: [
		{
			selector: 'deleteremoteagents',
			ref: 'deleteremoteagents'
		},
	],

	init: function(){
		this.control({
			'deleteremoteagents':
			{
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildDeleteFieldData: function() {
		Ext.Ajax.request({
			url: 'RemoteAgent/data/DeleteRemoteAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildInternalHostsData: function(HostName) {
		Ext.Ajax.request({
			url: 'RemoteAgent/data/deletegroupsremotepJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildAssDissAgnt: function(HostName) {
		Ext.Ajax.request({
			url: 'RemoteAgent/data/DeleteRemoteAgentsJson.jsp?eagent='+HostName,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function() {
		Ext.getCmp('NoDelSearchFound').hide();
		Ext.getCmp('agents').getStore().loadRawData(publicJSON['remoteAgentArray']);
		Ext.getCmp('deleteBtn').setText(publicJSON['screenLabels']['admin.common.Delete']);
	}

});



