Ext.define('RemoteAgent.controller.Main',{
	extend:'Ext.app.Controller',

	views:['RemoteAgents','RemoteAgent','AssignRemoteAgent','DeleteRemoteAgents','VmComponentTable','VMStatistics'],
	requires : ['RemoteAgent.view.RemoteAgent', 'RemoteAgent.view.FileUploadForm', 'RemoteAgent.view.FileUpload'],

	refs:[
		{selector:'remoteagents', ref:'remoteagents'},
		{selector:'assignremoteagent', ref:'assignremoteagent'},
		{selector:'deleteremoteagents', ref:'deleteremoteagents'},
		{selector:'remoteagent', ref:'remoteagent'},
		{selector:'vmstatistics', ref:'vmstatistics'},
		{selector:'vmcomponenttable', ref:'vmcomponenttable'},
		{selector:'fileuploadform', ref:'fileuploadform'}
	],

	init:function(){
		appRmtCnt = this;
		this.buildMainData()

		this.control({
			'remoteagents': {
				'afterrender': this.afterMainRender
			},
			'remoteagents trigger[name="gridRmtSearch"]': {
				'change': this.mainGridSearch
			},
			'remoteagents button[id="addRmtAgent"]': {
				'click': this.addAgent
			},
			'remoteagents button[id="DeleteRmtOver"]': {
				'click': this.deleteOver
			},
			'remoteagent button[id="updateBtn"]': {
				'click' : this.addUpdate
			},
			'remoteagents button[id="associateDissociate"]': {
				'click': this.associateDissociate
			},
			//'remoteagents button[id="deleteRmtAgent"]': {
				//'click': this.deleteAgent
			//},
			'remoteagents button[id="vMStatistics"]': {
				'click': this.agentVmStatistics
			},
			'remoteagents button[id="dwnldAgent"]': {
				'click': this.dwnldAgent
			},
			'assignremoteagent combo[id="rmtAgent"]': {
				'select': this.comboFromFieldLoad
			},
			'assignremoteagent combo[id="otherRmtAgent"]': {
				'select': this.comboToFieldLoad
			},
			'assignremoteagent button[id="UpdateBTN"]': {
				'click': this.updation
			},
			'assignremoteagent button[id="backbutton"]': {
				'click': this.backbutton
			},
			'deleteremoteagents button[id="deleteBtn"]': {
				'click' : this.deletefun
			},
			'deleteremoteagents trigger[name="agentsearch"]': {
				'change': this.mainFormEvent
			},
			'deleteremoteagents button[id="backDelbutton"]': {
				'click': this.backDelButton
			},
			'vmstatistics button[id="backVmStaticsBtn"]': {
				'click': this.backVMStatisticsEvent
			},
			'vmstatistics combo[id="remoteAgentCombo"]':
			{
				'change': this.remoteAgentComboChangeEvent
			},
			'vmstatistics [id="physicalServerVmsPoweredonGrid"]':
			{
				'cellclick': this.showVmTableCellClickEvent,
			},
			'vmstatistics button[id="refreshButton"]':
			{
				'click': this.refreshFile
			},
			'remoteagents button[action="openPopupWin"]': {
				'click': this.openPopupWin
			},
			'fileupload button[action="bulkAgentAction"]': {
				click : this.bulkAgentAction
			}
		});
	},
	refreshFile: function ()
	{
		if (vmComponentWindow.isVisible())
		{
			vmComponentWindow.close();
		}
		Ext.getCmp('noRemoteAgentSelectContainer').hide();
		if(loading)
		{
			Ext.Msg.show({
				title: 'Warning',
				msg: alreadyLoading,
				buttons : Ext.Msg.OK,
				icon: 'iconExclamation'
				});
			return false;
		}
		else
		{
			var rmAgent = Ext.getCmp('remoteAgentCombo').getValue();
			if(rmAgent == "-1")
			{
				Ext.Msg.show({
					title: pageName2,
					msg: selectOneMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
					});
				return false;
			}
			this.remoteAgentComboChangeEvent();
		}
	},
	showVmTableCellClickEvent: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		var fieldName = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		if (fieldName != null && fieldName == 'physicalServer')
		{
			componentName = Ext.getCmp('remoteAgentCombo').getValue();
			var type = publicJson['phyServerwithTypeObj'][cellvalue];
			var homepage = Ext.getCmp('remoteviewport');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			loading = true;
			myMask.show();

			Ext.Ajax.request({
				url:'RemoteAgent/data/EgVmLogDisplayJson.jsp?componentName='+encodeURIComponent(componentName)+'&file=eg_vm.ini&vmtable=true&from=vm&phyServer='+cellvalue+'&type='+type,
				method:'post',	
				scope:this,
				success:function(response)
				{	
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
					{
						var jsonText = response.responseText;
						jsonData = Ext.decode(jsonText);
						vmComponentWindow = Ext.widget('vmcomponenttable');
						myMask.hide();
						loading = false;
						vmComponentWindow.show();
						var type = jsonData['type'];
						var componentViewGridArr = jsonData['componentViewGridArr'];
						var componentViewGridTitle = jsonData['componentViewGridTitle'];
						if (componentViewGridTitle != null && !Ext.isEmpty(componentViewGridTitle))
						{
							Ext.getCmp('vmComponentTableWindowId').setTitle(componentViewGridTitle);
						}

						if (componentViewGridArr != null && !Ext.isEmpty(componentViewGridArr))
						{
							Ext.getCmp('noVmDetailsContainer').hide();
							Ext.getCmp('hyperComponentViewGrid').hide();
							Ext.getCmp('xenComponentViewGrid').hide();
							Ext.getCmp('esxComponentViewGrid').hide();
							var typeOfHeaders = jsonData[type];
							if (type != null && !Ext.isEmpty(type) && type == 'esx')
							{
								if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
								{
									Ext.getCmp('esx1').setText(typeOfHeaders[0]);
									Ext.getCmp('esx2').setText(typeOfHeaders[1]);
									Ext.getCmp('esx3').setText(typeOfHeaders[2]);
									Ext.getCmp('esx4').setText(typeOfHeaders[3]);
									Ext.getCmp('esx5').setText(typeOfHeaders[4]);
									Ext.getCmp('esx6').setText(typeOfHeaders[5]);
									Ext.getCmp('esx7').setText(typeOfHeaders[6]);
								}
								Ext.getCmp('esxComponentViewGrid').show();
								Ext.getCmp('esxComponentViewGrid').getStore().removeAll();
								Ext.getCmp('esxComponentViewGrid').getStore().loadRawData(componentViewGridArr);
							}
							else if (type != null && !Ext.isEmpty(type) && (type == 'xen' || type == 'Xen'))
							{
								if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
								{
									Ext.getCmp('xen1').setText(typeOfHeaders[0]);
									Ext.getCmp('xen2').setText(typeOfHeaders[1]);
									Ext.getCmp('xen3').setText(typeOfHeaders[2]);
									Ext.getCmp('xen4').setText(typeOfHeaders[3]);
									Ext.getCmp('xen5').setText(typeOfHeaders[4]);
								}
								Ext.getCmp('xenComponentViewGrid').show();
								Ext.getCmp('xenComponentViewGrid').getStore().removeAll();
								Ext.getCmp('xenComponentViewGrid').getStore().loadRawData(componentViewGridArr);
							}
							else if (type != null && !Ext.isEmpty(type) && type == 'hyper')
							{
								if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
								{
									Ext.getCmp('hyper1').setText(typeOfHeaders[0]);
									Ext.getCmp('hyper2').setText(typeOfHeaders[1]);
									Ext.getCmp('hyper3').setText(typeOfHeaders[3]);
									Ext.getCmp('hyper4').setText(typeOfHeaders[2]);
								}
								Ext.getCmp('hyperComponentViewGrid').show();
								Ext.getCmp('hyperComponentViewGrid').getStore().removeAll();
								Ext.getCmp('hyperComponentViewGrid').getStore().loadRawData(componentViewGridArr);
							}
						}
						else
						{
							NoDataMsg = jsonData['NoDataMsg'];
							Ext.getCmp('xenComponentViewGrid').hide();
							Ext.getCmp('esxComponentViewGrid').hide();
							Ext.getCmp('hyperComponentViewGrid').hide();
							Ext.getCmp('noVmDetailsContainer').show();
						}
					}
				}
			});
		}
	},
	remoteAgentComboChangeEvent: function()
	{
		componentName = Ext.getCmp('remoteAgentCombo').getValue();
		if(componentName!=null && componentName == "-1" && !firstTime)
		{
			Ext.Msg.show({
				title: pageName2,
				msg: selectOneMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
				});
			return false;
		}
		else if (componentName != null && componentName != '-1')
		{
			firstTime = false;
			var homepage = Ext.getCmp('remoteviewport');
			myMask = new Ext.LoadMask(homepage, {msg:label4});
			loading = true;
			myMask.show();
			Ext.Ajax.request({
				url: 'RemoteAgent/data/EgVmLogDisplayJson.jsp?componentName='+encodeURIComponent(componentName)+'&file=eg_vm.ini&vmtable=false',
				method: 'POST',
				scope: this,
				timeout: 6000000,
				success: function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
					{

						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						var isNoData = publicJson['isNoData'];
						if (isNoData)
						{
							var noDataMsg = publicJson['NoDataMsg'];
							Ext.getCmp('noRemoteAgentSelectContainer').show();
							Ext.getCmp('noRemoteAgentSelectedLabel').update(noDataMsg);
						}
						else
						{
							Ext.getCmp('noRemoteAgentSelectContainer').hide();
							var phyServerVmsPoweredonGridArr = publicJson['phyServerVmsPoweredonGridArr'];
							var phyServerTitle = publicJson['phyServerTitle'];
							var validUserTitle = publicJson['validUserTitle'];
							var vmsValidUserGridArr = publicJson['vmsValidUserGridArr'];
							var insideViewFailedVmsGridArr = publicJson['insideViewFailedVmsGridArr'];
							var vmagentFailedVmsGridArr = publicJson['vmagentFailedVmsGridArr'];
							var insideViewTitle = publicJson['insideViewTitle'];
							var agentViewTitle = publicJson['agentViewTitle'];
							var poweredVmGridHeaders = publicJson[phyServerTitle];
							var validUserGridHeaders = publicJson[validUserTitle];
							var insideViewGridHeaders = publicJson[insideViewTitle];
							var agentViewTitleHeaders = publicJson[agentViewTitle];
							if(phyServerVmsPoweredonGridArr!=null && !Ext.isEmpty(phyServerVmsPoweredonGridArr) )
							{
								if(poweredVmGridHeaders != null && !Ext.isEmpty(poweredVmGridHeaders))
								{
										Ext.getCmp('poweredVmGrid1').setText(poweredVmGridHeaders[0]);
										Ext.getCmp('poweredVmGrid2').setText(poweredVmGridHeaders[1]);
										Ext.getCmp('poweredVmGrid3').setText(poweredVmGridHeaders[2]);
										Ext.getCmp('poweredVmGrid4').setText(poweredVmGridHeaders[3]);
								}
								Ext.getCmp('physicalServerVmsPoweredonGrid').show();
								Ext.getCmp('physicalServerVmsPoweredonGrid').setTitle(phyServerTitle);
								Ext.getCmp('physicalServerVmsPoweredonGrid').getStore().removeAll();
								Ext.getCmp('physicalServerVmsPoweredonGrid').getStore().loadRawData(phyServerVmsPoweredonGridArr);
							}
							if(vmsValidUserGridArr!=null && !Ext.isEmpty(vmsValidUserGridArr) )
							{
								Ext.getCmp('vmsValidUserGrid').show();
								if(validUserGridHeaders != null && !Ext.isEmpty(validUserGridHeaders))
								{
									Ext.getCmp('validUserGrid1').setText(validUserGridHeaders[0]);
									Ext.getCmp('validUserGrid2').setText(validUserGridHeaders[1]);
									Ext.getCmp('validUserGrid3').setText(validUserGridHeaders[2]);
									Ext.getCmp('validUserGrid4').setText(validUserGridHeaders[3]);
								}
								Ext.getCmp('vmsValidUserGrid').setTitle(validUserTitle);
								Ext.getCmp('vmsValidUserGrid').getStore().removeAll();
								Ext.getCmp('vmsValidUserGrid').getStore().loadRawData(vmsValidUserGridArr);
							}
							if(insideViewFailedVmsGridArr!=null && !Ext.isEmpty(insideViewFailedVmsGridArr) )
							{
								Ext.getCmp('insideViewFailedVmsGrid').show();
								if(insideViewGridHeaders != null && !Ext.isEmpty(insideViewGridHeaders))
								{
									Ext.getCmp('insideViewGrid1').setText(insideViewGridHeaders[0]);
									Ext.getCmp('insideViewGrid2').setText(insideViewGridHeaders[1]);
									Ext.getCmp('insideViewGrid3').setText(insideViewGridHeaders[2]);
									Ext.getCmp('insideViewGrid4').setText(insideViewGridHeaders[3]);
								}
								Ext.getCmp('insideViewFailedVmsGrid').setTitle(insideViewTitle);
								Ext.getCmp('insideViewFailedVmsGrid').getStore().removeAll();
								Ext.getCmp('insideViewFailedVmsGrid').getStore().loadRawData(insideViewFailedVmsGridArr);
							}
							if(vmagentFailedVmsGridArr!=null && !Ext.isEmpty(vmagentFailedVmsGridArr) )
							{
								Ext.getCmp('agentFailedVmsGrid').show();
								if(agentViewTitleHeaders != null && !Ext.isEmpty(agentViewTitleHeaders))
								{
									Ext.getCmp('agentViewGrid1').setText(agentViewTitleHeaders[0]);
									Ext.getCmp('agentViewGrid2').setText(agentViewTitleHeaders[1]);
									Ext.getCmp('agentViewGrid3').setText(agentViewTitleHeaders[2]);
									Ext.getCmp('agentViewGrid4').setText(agentViewTitleHeaders[3]);
								}
								Ext.getCmp('agentFailedVmsGrid').setTitle(agentViewTitle);
								Ext.getCmp('agentFailedVmsGrid').getStore().removeAll();
								Ext.getCmp('agentFailedVmsGrid').getStore().loadRawData(vmagentFailedVmsGridArr);
							}
						}
						
						myMask.hide();
						loading = false;
					}
				}
			});
		}
	},

	buildMainData: function(){
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgDispRemoteAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					if (!Ext.isEmpty(publicJSON.strrmtList))
					{
						var existList = publicJSON.strrmtList;
						rmtListStr = existList.split(',');
					}
				}
			}
		});
	},

	showAssignHosts: function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		assignAgent = row.get('Hostname');
		
		Ext.getCmp('remoteviewport').removeAll();
		this.getController('RemoteAgent.controller.AssignRmtCtrl').buildFieldData();
		Ext.getCmp('remoteviewport').add({xtype: 'assignremoteagent'});
		this.getController('RemoteAgent.controller.AssignRmtCtrl').buildGivenAgentData(assignAgent);
		this.getController('RemoteAgent.controller.AssignRmtCtrl').afterMainRender();
	},

	handleDeleteIconClick: function(gridView, rowIndex, colIndex){
		var DispValues = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var HostName = DispValues.get('Hostname');
		this.deleteTask(HostName,rowIndex);
	},

	handleEditIconClick: function(gridView, rowIndex, colIndex){
		btnText = 'Change IP';
		var rec = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		var HostName = rec.get('Hostname');
		var HostIP = rec.get('HostIP');
		this.showEditWindow(HostName,HostIP);
	},

	showEditWindow: function(HostName,HostIP){
		Ext.widget('remoteagent').show();
		Ext.getCmp('Hostname').setValue(HostName).disable();
		Ext.getCmp('HostIp').setValue(HostIP);
		Ext.getCmp('updateBtn').setText('Update');
		Ext.getCmp('AddModRmtView').setTitle(rmtModPageTitle);

		this.getController('RemoteAgent.controller.AddRmtCtrl').buildAddFieldData();
		extListStr = publicJSON['extAgentsArr'];

		var enableNickNameEdit = publicJSON['enableNickNameEdit'];
		if(enableNickNameEdit)
		{
			Ext.getCmp('Hostname').setValue(HostName).enable();
		}
		Ext.getCmp('HostIp').focus();

		Ext.getCmp('hostIpCt').setFieldLabel(publicJSON['screenLabels']['admin.remote.Agent IP Address']);
		Ext.getCmp('Hostname').setFieldLabel(publicJSON['screenLabels']['admin.remote.Agent Host/Nick Name']);
		Ext.getCmp('addAsExtAgent').setFieldLabel(publicJSON['screenLabels']['admin.remote.Add as External agent']);

		Ext.getCmp('HostIp').setValue(publicJSON['hostValue']['AgentIp']);
		Ext.getCmp('Hostname').setValue(publicJSON['hostValue']['AgenthostNic']);

		var rtype = publicJSON['rtype'];
		
		if (RmtIpAgent == HostIp)
		{
			Ext.getCmp('addAsExtAgent').hide();
		}

		var notextAgent = publicJSON['extnothasragent'];
		if (notextAgent == 'No')
		{
			Ext.getCmp('addAsExtAgent').hide();
		}
		else
		{
			Ext.getCmp('addAsExtAgent').show();
			Ext.getCmp('addasExtNo').setValue(true);
		}

		oldHostIp = publicJSON['hostValue']['AgentIp'];
		oldNickName = publicJSON['hostValue']['AgenthostNic'];

		//if (rtype == 'changeip')
		//{
			//Ext.getCmp('Hostname').setReadOnly(true);
		//}
	},

	commonDelete: function(HostName,rowIndex){
		var me = this;
		Ext.Msg.show({
			title: 'DELETE REMOTE AGENT',
			msg: deleteSingleRmtAgntMsg+"'"+HostName+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon : 'iconConfirmation',
			fn: function(response) {
			if(response === 'yes') {
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					tmpMask.show();
					Ext.Ajax.request({
					url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?mode=del&eagent='+encodeURIComponent(HostName),
					method: 'POST',
					success: function( response )
					{
						tmpMask.hide();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								var doubleAlert = publicJSON['doubleAlert'];
								if (doubleAlert != undefined && doubleAlert == 'true')
								{
									Ext.Msg.show({
										title:resultStatus['title'],
										msg: resultStatus['message1'],
										buttons: Ext.Msg.OKCANCEL,
										icon : 'iconConfirmation',
										fn: function(response) {
											if (response == 'ok')
											{
												tmpMask.show();
												Ext.Ajax.request({
												url: 'ExternalAgent/data/EgnewextagentspJson.jsp?mode=del&eagent='+encodeURIComponent(HostName),
												method: 'POST',
												success: function( response )
												{
													tmpMask.hide();
													var jsonText = response.responseText;
													publicJSON = Ext.decode(jsonText);
													if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
													{
														var resultStatus = publicJSON['requestStatus'];
														if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
														{
															var result = publicJSON['result'];
															Ext.Msg.show(
															{
																title : result['title'],
																msg : result['message1'],
																buttons : Ext.Msg.OK,
																icon : 'iconInformation'
															});
														}
														else
														{
															var resultStatus = publicJSON['error'];
															Ext.MessageBox.show(
															{
																titel : resultStatus['title'],
																msg : resultStatus['message1'],
																buttons : Ext.Msg.OK,
																icon : 'iconExclamation'
															});
														}
													}
												},
												failure: function()
												{
													tmpMask.hide();
												}
												});
											}
										}
									});
								}
								else
								{
									Ext.Msg.show({
										title:resultStatus['title'],
										msg: resultStatus['message1'],
										buttons : Ext.Msg.OK,
										icon : 'iconInformation'
									});
								}
							}
							else
							{
								var resultStatus = publicJSON['error'];
								Ext.MessageBox.show(
								{
									title : resultStatus['title'],
									msg : resultStatus['message1'],
									buttons : Ext.Msg.OK,
									icon : 'iconExclamation'
								});
							}
							Ext.getCmp('gridRmtSearch').setRawValue('');
							me.buildMainData();
							var resultsData = publicJSON['gridRmtAgents'];
							if (resultsData == null || resultsData.length == 0)
							{
								Ext.getCmp('gridRmtSearch').disable()
								Ext.getCmp('gridRmtDisplay').hide();
								Ext.getCmp('associateDissociate').disable();
								//Ext.getCmp('deleteRmtAgent').disable();
							}
							else
							{
								Ext.getCmp('gridRmtSearch').enable()
								Ext.getCmp('gridRmtDisplay').show();
								Ext.getCmp('associateDissociate').enable();
								//Ext.getCmp('deleteRmtAgent').enable();
								Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
								var view = Ext.getCmp('gridRmtDisplay').getView();
								var headerCt = view.headerCt;
								var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
								if (checkHd) {
									checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
								}
							}
						}
						me.buildMainData();
						var resultsData = publicJSON['gridRmtAgents'];
						Ext.getCmp('gridRmtSearch').enable();
						Ext.getCmp('associateDissociate').enable();
						//Ext.getCmp('deleteRmtAgent').enable();

						Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
						Ext.getCmp('gridRmtSearch').setRawValue('');
					},
					failure: function()
					{
						tmpMask.hide();
					}
				});
			}
		}
	});
	},

	deleteTask: function(HostName,rowIndex){
		this.commonDelete(HostName,rowIndex);
	},

	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridRmtSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request({
		url: 'RemoteAgent/data/EgDispRemoteAgentsJson.jsp?egTitleSearchStr='+gridsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['gridRmtAgents'];
			Ext.getCmp('gridRmtDisplay').show();
			Ext.getCmp('associateDissociate').enable();
			//Ext.getCmp('deleteRmtAgent').enable();
			if (value != null && value.length > 0)
			{
				Ext.getCmp('gridRmtDisplay').store.loadData(publicJSON['gridRmtAgents']);
			}
			else
			{
				Ext.getCmp('gridRmtDisplay').store.loadData('');
				Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+'.</td></tr></table></td></tr></table>';
				Ext.getCmp('gridRmtDisplay').getView().refresh();
			}
		}
		});
	},

	addAgent: function(btn){
		btnText = 'Add';
		Ext.widget('remoteagent').show();
		Ext.getCmp('updateBtn').setText('Add');
		Ext.getCmp('AddModRmtView').setTitle(rmtAddPageTitle);

		this.getController('RemoteAgent.controller.AddRmtCtrl').buildAddFieldData();
		this.getController('RemoteAgent.controller.AddRmtCtrl').afterMainRender();
	},
	openPopupWin: function ()
	{
		Ext.widget('fileupload').show();
	},
	bulkAgentAction: function() {
		var me = this;
		var uploadObj = Ext.getCmp('FILE_0').getValue();
		var actionType = Ext.getCmp('bulkRemoteAgent').getValue().actionType;
		var alertWinTitle = addOrDeleteRmtAgentInBulkTitle;// default title
		if(actionType == 'add') {
			alertWinTitle = addRmtAgentInBulkTitle;
		} else if(actionType == 'delete') {
			alertWinTitle = deleteRmtAgentInBulkTitle;
		}
		if (uploadObj != null && uploadObj != '' && uploadObj != undefined && uploadObj != 'undefined')
		{
			var getFileName = uploadObj;
			getFileName = getFileName.substring(getFileName.lastIndexOf('.') + 1);
			if (getFileName == 'csv')
			{
				var URL ="";
				if(actionType == 'add') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=addRemoteAgent"; //defualt
					me.doAction(URL);
				} else if(actionType == 'delete') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=deleteRemoteAgent";
					Ext.Msg.show({
					title: alertWinTitle,
					msg: deleteSelected,
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function(response) {
						if(response == 'yes') {
							me.doAction(URL);
						}
					}
					});
				}
			} else {
				Ext.Msg.show({
					title: alertWinTitle,
					msg: selectValidFile,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
			}
		} else {
			Ext.Msg.show({
			title: alertWinTitle,
			msg: selectCompsListFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	},
	doAction: function(URL) {
			var compListForm = this.getFileuploadform().getForm();
			var actionType = Ext.getCmp('bulkRemoteAgent').getValue().actionType;
			var alertWinTitle = addOrDeleteRmtAgentInBulkTitle;// default title
			if(actionType == 'add') {
				alertWinTitle = addRmtAgentInBulkTitle;
			} else if(actionType == 'delete') {
				alertWinTitle = deleteRmtAgentInBulkTitle;
			}
				if (compListForm.isValid())
				{
					var tmpMask = new Ext.LoadMask('fileUpload', {msg: 'Please wait...'});
					tmpMask.show();//
					compListForm.submit(
					{
						url: URL,
						scope: this,
						async: true,
						//waitMsg: 'Please wait upload in progress',
						method: 'POST',
						enctype: 'multipart/form-data',
						success: function (form, action)
						{
							tmpMask.hide();
							var jsonText = action.response.responseText;
								jsonText = Ext.decode(jsonText);
							var errorMsg = jsonText['errorMsg'];
							var errorInfo = jsonText['errorInfo'];

							var resultMsg = jsonText['resultMsg'];
							var tempErrorMsg = jsonText['tempErrorMsg'];
							var ErrMsgsJson = jsonText['ErrMsgsJson'];
							if (!Ext.isEmpty(jsonText))
							{
								if(Ext.isEmpty(tempErrorMsg))
								{
									if(!Ext.isEmpty(resultMsg))
									{
										Ext.Msg.show({
										title: alertWinTitle,
										msg: resultMsg,
										icon: 'iconInformation',
										buttons: Ext.Msg.OK
										});
									} else {

										 if(!Ext.isEmpty(ErrMsgsJson))
										{
											Ext.Msg.show({
												title: alertWinTitle,
												msg: errorMsg,
												icon: 'iconExclamation',
												buttons: Ext.Msg.OK
											});
											
										} else if(!Ext.isEmpty(errorInfo)) {
											Ext.Msg.show({
												title: alertWinTitle,
												msg: errorInfo,
												icon: 'iconInformation',
												buttons: Ext.Msg.OK
											});
										} else if(!Ext.isEmpty(errorMsg)) {
											Ext.Msg.show({
												title: alertWinTitle,
												msg: errorMsg,
												icon: 'iconExclamation',
												buttons: Ext.Msg.OK
											});
										}
										
									}
								} else {
									Ext.Msg.show({
										title: alertWinTitle,
										
										msg: tempErrorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								}
							} 
						},
						failure: function (form, action)
						{	
							tmpMask.hide();
							Ext.Msg.show({
								title: alertWinTitle,
								msg: 'Failure Notice',
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});
						}
					});
				}

	},
	deleteOver: function(){
		var HostNameToDel = Ext.getCmp('DispRmtHostName').getValue();
		window.location.href = "RemoteAgent/data/EgnewremoteagentspJson.jsp?mode=del&eagent="+encodeURIComponent(HostNameToDel);
	},

	addUpdate : function(btn){
		var hostip = Ext.getCmp('HostIp').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();

		var me = this;
		var checkValidation = me.validationForAddModify();

		var extListHasAgent = false;
		if (btnText != 'Add')
		{
			if(oldHostIp != null && oldNickName != null && oldHostIp != hostip && oldNickName != hostname)
			{
				Ext.Msg.show(
				{
					title : rmtPageTitle,
					msg : checkSingleEdit + '.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('HostIp').focus(true);
					}
				});
				checkValidation = false;
			}
			else
			{
				for (var l=0;l<extListStr.length;l++)
				{
					var extListStrSa = extListStr[l].trim();
					if (extListStrSa == oldNickName)
					{
						extListHasAgent = true;
					}
				}
			}
		}

		if (checkValidation)
		{
			if(oldNickName != hostname)
			{
				if(extListHasAgent)
				{
					Ext.Msg.show(
					{
						title : rmtPageTitle,
						msg : sameNameAlert1+'. '+sameNameAlert2+'. '+sameNameAlert3,
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(response) {
							if(response == 'yes') 
							{
								me.addUpdateProcess();
							}
						}
					});
				}
				else
				{
					me.addUpdateProcess();
				}
			}
			else
			{
				me.addUpdateProcess();
			}
		}
	},

	addUpdateProcess : function()
	{
		var me = this;
		this.getController('RemoteAgent.controller.AddRmtCtrl').buildAddFieldData();

		var hostip = Ext.getCmp('HostIp').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();

		var mode= '';
		if (btnText == 'Add')
		{
			mode = 'add';
		}
		else
		{
			mode = 'modifyip';
		}

		var mode = publicJSON['mode'];
		
		var external = '';
		var isExternal = Ext.getCmp('addasExtYes').getValue();
		if (isExternal == true)
		{
			external = 'true';
		}
		else
		{
			external = 'false';
		}
		var eagent = null;
		
		var qrString = external+"&mode="+mode+"&hostip="+hostip+"&hostname="+encodeURIComponent(hostname)+"&old_name="+oldNickName+"&old_ip="+oldHostIp+"&eagent="+eagent;

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		tmpMask.show();
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?external='+qrString,
			method: 'POST',
			success: function( response )
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						var addToExternal = publicJSON['addToExternal'];
						var toExtAgent = publicJSON['toExternalModify'];
						if (addToExternal == undefined && toExtAgent == undefined)
						{
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								width : 400,
								fn : function(btn){
									Ext.getCmp('AddModRmtView').destroy();
								}
							});
						}

						if (addToExternal != null && addToExternal == 'true')
						{
							var queryStr = "NewAgnt&remoteUpdateResult=0&addAsExternal=true&clientEmulation=false&hostip="+hostip+"&hostname="+encodeURI(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype='+queryStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title :resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												width : 400,
												fn : function(btn)
												{
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
										else
										{
											var errorStatus = publicJSON['error'];
											Ext.MessageBox.show(
											{
												title : errorStatus['title'],
												msg : errorStatus['message1']+errorStatus['message2'],
												icon : 'iconExclamation',
												buttons: Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
						if (toExtAgent != null && toExtAgent == 'true')
						{
							var queryModStr = "NewAgnt&addAsExternal=true&clientEmulation=false&hostip="+hostip+"&hostname="+encodeURI(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype='+queryModStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title : resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
										else
										{
											var errorStatus = publicJSON['error'];
											Ext.MessageBox.show(
											{
												title : errorStatus['title'],
												msg : errorStatus['message1']+errorStatus['message2'],
												icon : 'iconExclamation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
					}
					else
					{
						var errorStatus = publicJSON['error'];
						var errType = publicJSON.error_type;
						if (errType=='confirmNickSuggestion')
						{
							Ext.Msg.confirm({
								title: errorStatus['title'],
								msg: errorStatus['message1']+errorStatus['message2'],
								buttons: Ext.Msg.YESNO,
								icon: 'iconConfirmation',
								fn: function(response) {
									if(response == 'yes') 
									{
										var forwardURL = errorStatus.forward_URL;
										var IP = errorStatus.IP;
										var Nick = errorStatus.nickName;
										forwardURL ="RemoteAgent/data/"+forwardURL;
										me.forwardGivenURL(forwardURL,IP,Nick);
									}
									else
									{
										Ext.getCmp('Hostname').focus();
									}
								}
							});
						}
						else
						{
							Ext.MessageBox.show(
							{
								title : errorStatus['title'],
								msg : errorStatus['message1']+errorStatus['message2'],
								icon : 'iconExclamation',
								buttons : Ext.Msg.OK,
								fn : function(btn){
									if (errType=='alert')
									{
										Ext.getCmp('Hostname').focus();
									}
									else
									{
										Ext.getCmp('AddModRmtView').destroy();
									}
								}
							});

							var AddSameAsExt = publicJSON['AddSameAsExt'];
							if (AddSameAsExt != undefined && AddSameAsExt == 'true')
							{
								Ext.Msg.show({
									title:errorStatus['title'],
									msg: errorStatus['message1']+errorStatus['message2'],
									buttons : Ext.Msg.OKCANCEL,
									icon : 'iconExclamation',
									fn: function(response) {
										if (response == 'ok')
										{
											tmpMask.show();
											Ext.Ajax.request({
												url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype=NewAgnt&addAsExternal=true&clientEmulation=false&hostip='+hostip+"&hostname="+encodeURI(hostname),
												method: 'POST',
												success: function( response )
												{
													tmpMask.hide();
													var jsonText = response.responseText;
													publicJSON = Ext.decode(jsonText);
													if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
													{
														var resultStatus = publicJSON['requestStatus'];
														if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
														{
															var result = publicJSON['result'];
															Ext.MessageBox.show(
															{
																title : result['title'],
																msg : result['message1'],
																buttons : Ext.Msg.OK,
																icon : 'iconInformation',
																fn : function(btn){
																	Ext.getCmp('AddModRmtView').destroy();
																}
															});
														}
													}
												},
												failure: function()
												{
													tmpMask.hide();
												}
											});
										}
										else
										{
											Ext.getCmp('AddModRmtView').destroy();
										}
									}
								});
							}
						}
					}
					me.buildMainData();
					var resultsData = publicJSON['gridRmtAgents'];
					Ext.getCmp('gridRmtSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					//Ext.getCmp('deleteRmtAgent').enable();

					Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridRmtSearch').setRawValue('');
				}
			},
			failure: function()
			{
				tmpMask.hide();
			}
		});
	},

	forwardGivenURL : function(forwardURL,hostip,hostname)
	{
		var me = this;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		tmpMask.show();
		Ext.Ajax.request({
			url: forwardURL,
			method: 'POST',
			success: function( response )
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						var addToExternal = publicJSON['addToExternal'];
						var toExtAgent = publicJSON['toExternalModify'];
						if (addToExternal == undefined && toExtAgent == undefined)
						{
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								width : 400,
								fn : function(btn){
									Ext.getCmp('AddModRmtView').destroy();
								}
							});
						}

						if (addToExternal != null && addToExternal == 'true')
						{
							var queryStr = "NewAgnt&remoteUpdateResult=0&addAsExternal=true&clientEmulation=false&hostip="+hostip+"&hostname="+encodeURI(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype='+queryStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title :resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												width : 400,
												fn : function(btn)
												{
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
										else
										{
											var errorStatus = publicJSON['error'];
											Ext.MessageBox.show(
											{
												title : errorStatus['title'],
												msg : errorStatus['message1']+errorStatus['message2'],
												icon : 'iconExclamation',
												buttons: Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
						if (toExtAgent != null && toExtAgent == 'true')
						{
							var queryModStr = "NewAgnt&addAsExternal=true&clientEmulation=false&hostip="+hostip+"&hostname="+encodeURI(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype='+queryModStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title : resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
										else
										{
											var errorStatus = publicJSON['error'];
											Ext.MessageBox.show(
											{
												title : errorStatus['title'],
												msg : errorStatus['message1']+errorStatus['message2'],
												icon : 'iconExclamation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModRmtView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
					}
					else
					{
						var errorStatus = publicJSON['error'];
						Ext.MessageBox.show(
						{
							title : errorStatus['title'],
							msg : errorStatus['message1']+errorStatus['message2'],
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('AddModRmtView').destroy();
							}
						});

						var AddSameAsExt = publicJSON['AddSameAsExt'];
						if (AddSameAsExt != undefined && AddSameAsExt == 'true')
						{
							Ext.Msg.show({
								title:errorStatus['title'],
								msg: errorStatus['message1']+errorStatus['message2'],
								buttons : Ext.Msg.OKCANCEL,
								icon : 'iconExclamation',
								fn: function(response) {
									if (response == 'ok')
									{
										tmpMask.show();
										Ext.Ajax.request({
											url: 'ExternalAgent/data/EgnewextagentspJson.jsp?Btype=NewAgnt&addAsExternal=true&clientEmulation=false&hostip='+hostip+"&hostname="+encodeURI(hostname),
											method: 'POST',
											success: function( response )
											{
												tmpMask.hide();
												var jsonText = response.responseText;
												publicJSON = Ext.decode(jsonText);
												if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
												{
													var resultStatus = publicJSON['requestStatus'];
													if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
													{
														var result = publicJSON['result'];
														Ext.MessageBox.show(
														{
															title : result['title'],
															msg : result['message1'],
															buttons : Ext.Msg.OK,
															icon : 'iconInformation',
															fn : function(btn){
																Ext.getCmp('AddModRmtView').destroy();
															}
														});
													}
												}
											},
											failure: function()
											{
												tmpMask.hide();
											}
										});
									}
									else
									{
										Ext.getCmp('AddModRmtView').destroy();
									}
								}
							});
						}
					}
					me.buildMainData();
					var resultsData = publicJSON['gridRmtAgents'];
					Ext.getCmp('gridRmtSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					//Ext.getCmp('deleteRmtAgent').enable();

					Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridRmtSearch').setRawValue('');
				}
			},
			failure: function()
			{
				tmpMask.hide();
			}
		});
	},

	checkdots: function(){
		var hostname = Ext.getCmp('Hostname').getValue();
		if(hostname.charAt(0) == '.' || hostname.charAt(hostname.length - 1) == '.')
		{
			Ext.Msg.show(
			{
				title : "REMOTE AGENT",
				msg : checkdots + '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return false;
		}
		else
		{
			for(var k=0;k < hostname.length;k++)
			{
				if(hostname.charAt(k) == '.' && hostname.charAt(k + 1) == '.')
				{
					Ext.Msg.show(
					{
						title : "REMOTE AGENT",
						msg : checkconsecutivedots +'.',
						buttons : Ext.Msg.OK,
						icon : 'iconExclamation'
					});
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	},

	validationForAddModify: function(){
		var hostip = Ext.getCmp('HostIp').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();

		var checkD =this;
		var checkDotVal = checkD.checkdots();

		var regExp = /^(([0-9]+\.)+){3}[0-9]+$/;
		var hostnameIsIP = regExp.test(hostname);
		var isExist = false;
		var isCompExist = false;
		var host_Name=true;
		if(isDouble == "false")
			host_Name = validateSingleByte(hostname);

		if (btnText == 'Add')
		{
			if (rmtListStr != null)
			{
				for(var j=0;j<rmtListStr.length;j++)
				{
					var rmt_varListStr = rmtListStr[j].trim();
					if(rmt_varListStr.toLowerCase() == hostname.toLowerCase())
					isExist = true;
				}
			}
			/* 
			 * This condition is used to check whether the given remote agent nickname 
			 * is already existing as a comp nickname or not
			 * for eg: Add an agentless comp tomcat_01 with remote agent 'rem01' and external agent 'ext01'
			 * and then add an agentless comp 'rem01' with remote agent 'rem02' and external agent 'ext02'
			 * In eg_agents.ini (for the comp 'tomcat_01'), the tests under the remote agent 'rem01' was moved to 
			 * the remote agent 'rem02'. At Test specific configuration page (for the comp 'tomcat_01')
			 * it shows only external tests (other corresponding tests are not shown).
			 */
			if (remAgentCompListArr != null && remAgentCompListArr != "")
			{
				for(var j=0;j<remAgentCompListArr.length;j++)
				{
					var rmt_cmp_varListStr = remAgentCompListArr[j].trim();
					if(rmt_cmp_varListStr.toLowerCase() == hostname.toLowerCase())
					isCompExist = true;
				}
			}
		}

		var comValidIPVar = commonValidationsExtjs(hostip);
		var validateIPVar = validateIpExtjs(hostip);
		var validHostFieldIPVar = validateHostFieldExtjs(hostip);
		var checkspaceIPVar = checkspaceExtjs(hostip);
		var checkSpecialIPVar = checkSpecialExtjs(hostip,"`~!@#$%^&*()+={}[]|;\"\'<>,?/");
		var checkspaceNameVar = checkspaceExtjs(hostname);
		var checkSpecialNameVar = checkSpecialExtjs(hostname,"`~!@#$%^&*()+={}[]|:;\"\'<>,?\\\/");

		var internalAgentMappedWithHostName = false;
		for(var i = 0; i < intAgentsListStr.length; i++)
		{
			if(intAgentsListStr[i].trim() == hostname.trim())
			{
				internalAgentMappedWithHostName = true;
				break;
			}
		}

		if(!checkblank(hostip))
		{
			if (isAllowHostName=='false')
			{
				Ext.Msg.show(
				{
					title : rmtPageTitle,
					msg : checkBlankIP + '.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
			else
			{
				Ext.Msg.show({
					title : rmtPageTitle,
					msg : checkBlankIPName + '.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
			}
			Ext.getCmp('HostIp').focus();
		}
		else if(comValidIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(comValidIPVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('HostIp').focus();
				}
			});
		}
		else if(isAllowHostName == 'false' && validateIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(validateIPVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('HostIp').focus();
				}
			});
		}
		else if(isAllowHostName=='true' && validHostFieldIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(validHostFieldIPVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('HostIp').focus();
				}
			});
			return;
		}
		else if(isAllowHostName=='true' && checkspaceIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkspaceIPVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('HostIp').focus();
				}
			});
		}
		else if (isAllowHostName=='true' && checkSpecialIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkSpecialIPVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('HostIp').focus();
				}
			});
		}
		else if(!checkblank(hostname))
		{
			Ext.Msg.show({
				title : rmtPageTitle,
				msg : checkBlankHostName + '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
		}
		else if(hostname.trim().toLowerCase() == "none")
		{
			Ext.Msg.show({
				title : rmtPageTitle,
				msg : 'You are not allowed to use eG reserved keyword \''+hostname+'\' for remote agent' + '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
		}
		else if(checkspaceNameVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkspaceNameVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus();
				}
			});
		}
		else if(checkSpecialNameVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkSpecialNameVar);
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus();
				}
			});
		}
		else if(!checkDotVal)
		{
			Ext.getCmp('Hostname').focus();
		}
		else if(hostnameIsIP && hostip != hostname)
		{
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : hostNameIsIP+ '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			Ext.getCmp('Hostname').focus();
		}
		//else if(isExist)
		//{
			//Ext.Msg.show({
				//title : rmtPageTitle,
				//msg : hostNameByOtherAgent+ '.',
				//buttons : Ext.Msg.OK,
				//icon : 'iconExclamation'
			//});
			//Ext.getCmp('Hostname').focus();
		//}
		else if(isCompExist)
		{
			Ext.Msg.show({
				title : rmtPageTitle,
				msg : hostNameByOtherComp+ '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			Ext.getCmp('Hostname').focus();
		}
		else if(!host_Name)
		{
			Ext.Msg.show({
				title : rmtPageTitle,
				msg : checkDBL+ '.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			Ext.getCmp('Hostname').focus();
		}
		else if(internalAgentMappedWithHostName)
		{
			Ext.Msg.show(
			{
				title : rmtPageTitle,
				msg : intAgentMappingAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		else
		{
			return true;
		}
	},

	getRespectiveMsg: function(Var){
		
		switch(Var)
		{
			case '1' : return _checkIp;
			case '2' : return _validateHostDot;
			case '3' : return _validateHostUScore;
			case '4' : return _validateHostHypen;
			case '5' : return _checkspaceIp;
			case '6' : return _checkAlpha;
			case '7' : return _checkspecial;
			case '8' : return _valIp;
			case '9' : return _validateIp;
			case '10' : return _checknum;
			case '11' : return _chkIpv6;
			case '12' : return _doubleColon;
			case '13' : return _grpIpv6;
			case '14' : return _digitIpv6;
			case '15' : return _validateIpv6;
			case '16' : return _checkNumberLabel;
			case '17' : return _checkblank;
		}
	},

	associateDissociate: function(btn){
		assignAgent = "";
		Ext.getCmp('remoteviewport').removeAll();
		this.getController('RemoteAgent.controller.AssignRmtCtrl').buildFieldData();
		Ext.getCmp('remoteviewport').add({xtype: 'assignremoteagent'});
		this.getController('RemoteAgent.controller.AssignRmtCtrl').afterMainRender();
	},

	comboFromFieldLoad: function(){
		var me = this;
		this.getController('RemoteAgent.controller.AssignRmtCtrl').buildFieldData();

		var eagent = Ext.getCmp('rmtAgent').getValue();
		var othereagent = "null";
		if (eagent == -1)
		{
			eagent = "null";
		}

		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgConfigRemoteAgentsJson.jsp?eagent='+encodeURIComponent(eagent)+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectremoteagent').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectremoteagent').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectremoteagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectremoteagent').toField.store.removeAll();
				}

				Ext.getCmp('itemselectremoteagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
				me.getController('RemoteAgent.controller.AssignRmtCtrl').initializeFields2();
				
				if (eagent == "null")
				{
					Ext.getCmp('otherRmtAgent').setDisabled(true);
				}
				else
				{
					Ext.getCmp('otherRmtAgent').setDisabled(false);
				}
				Ext.getCmp('itemselectremoteagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	comboToFieldLoad: function(){
		this.getController('RemoteAgent.controller.AssignRmtCtrl').buildFieldData();

		var eagent = Ext.getCmp('rmtAgent').getValue();
		var othereagent = Ext.getCmp('otherRmtAgent').getValue();
		if (eagent == -1)
		{
			Ext.getCmp('otherRmtAgent').setValue(-1);
			eagent = "null";
		}
		if (othereagent == -1)
		{
			othereagent = "null";
		}
		Ext.Ajax.request({
			url: 'RemoteAgent/data/EgConfigRemoteAgentsJson.jsp?eagent='+encodeURIComponent(eagent)+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectremoteagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectremoteagent').toField.store.removeAll();
				}
				Ext.getCmp('itemselectremoteagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	updation: function(btn){
		var me = this;
		var allRemoteAgentsArr = new Array();
		var eagentObj = Ext.getCmp('rmtAgent');
		var eagent = eagentObj.getValue();
		var allRemAgentsCount =  eagentObj.getStore().getCount();
		for(var k=0; k<allRemAgentsCount; k++)
		{
			allRemoteAgentsArr[k] = eagentObj.getStore().getAt(k).get('valueField');
		}
		if (eagent == '-1')
		{
			Ext.Msg.show(
			{
				title : assignRmtPageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please choose a remote agent'] +'.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
		}
		else
		{
			var existingAgents = publicJSON['existingAgents'];
			if (existingAgents != null && existingAgents != "undefined")
			{
				var existAgentsArr = existingAgents.split(",");
			}

			var prevManagedHostByOther = publicJSON['ManagedHostByOthrAgnt'];
			var updateUrrl = publicJSON['UpdateLink'];
			var itemSelectorVal = publicJSON['itemSelectorArray']

			var managedHostsByOther = Ext.getCmp('itemselectremoteagent').getValue();
			if (managedHostsByOther == undefined)
			{
				Ext.Msg.show(
				{
					title : assignRmtPageTitle,
					msg : publicJSON['screenLabels']['admin.remote.Please choose atleast one agent to manage or unmanage']+'.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation'
				});
				return;
			}

			var fmanage = new Array();
			var Arr = new Array();
			var noOfManAgent = Ext.getCmp('itemselectremoteagent').fromField.store.getCount();
			var ManAgents = Ext.getCmp('itemselectremoteagent').fromField.getValue();

			var allValue = new Array();
			for (var i=0;i < noOfManAgent;i++)
			{
				allValue[allValue.length]=Ext.getCmp('itemselectremoteagent').fromField.store.getAt(i).get('valueField');
			}
			if(me.remoteHasCompNick(allRemoteAgentsArr,allValue))
			{
				Ext.Msg.show(
				{
					title : assignRmtPageTitle,
					msg : publicJSON['screenLabels']['admin.remote.Please select another agent, as this agent name is already mapped to remote agent']+'.',
					buttons : Ext.Msg.OK,
					icon : 'iconExclamation',
					fn : function(response) {
						if (response === 'ok') {
							me.comboFromFieldLoad();
						}
					}
				});
				return;
			}
				
			for (var m=0;m<allValue.length;m++ )
			{
				var isData = false;
				if (existingAgents != null && existingAgents.length > 0)
				{
					var existAgentsArr = existingAgents.split(",");
					for (var j=0;j<existAgentsArr.length;j++ )
					{

						if (allValue[m] == existAgentsArr[j])
						{
							isData = true;
							break;
						}
					}
					if (!isData)
					{
						Arr[Arr.length] = allValue[m];
					}
				}
				else
				{
					Arr[Arr.length] = allValue[m];
				}
			}
			var funmanage = Arr;

			if (existingAgents == "undefined" || existingAgents == null)
			{
				existingAgents = "null";
			}

			var hiddenRemoteObj = Ext.getCmp('assignhiddenRemotecontainer');
			var temp = {
				xtype: 'hiddenfield',
				name: 'fmanage',
				value: fmanage
			};
			hiddenRemoteObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'existingAgents',
				value: existingAgents
			};
			hiddenRemoteObj.add(temp);
		
			temp = {
				xtype: 'hiddenfield',
				name: 'funmanage',
				value: funmanage
			};
			hiddenRemoteObj.add(temp);
			
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show(); 

			var hiddenAssignRemoObj = Ext.getCmp('assignremoteagent').getForm();
			hiddenAssignRemoObj.submit({
			url: 'RemoteAgent/data/EgconfigremoteagentspJson.jsp?eagent='+encodeURIComponent(eagent),
			method: 'POST',
			timeout: 500000,
			standardSubmit: false,
			success: function( form,action )
			{
				myMask.hide(); 
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resulturl = publicJSON['resultUrl'];
						Ext.Msg.show(
						{
							title : assignRmtPageTitle,
							msg : publicJSON['screenLabels']['SucessfullyUpdated'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : function(btn)
							{
								me.comboFromFieldLoad();
							}
						});
					}
					else
					{
						var errorStatus = publicJSON['error'];
						Ext.Msg.show(
						{
							title : errorStatus['title'],
							msg : errorStatus['message1'],
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function(btn)
							{
								me.comboFromFieldLoad();
							}
						});
					}
				}
				hiddenRemoteObj.removeAll();
			},
			failure: function(form, action)
			{
				myMask.hide(); 
				hiddenRemoteObj.removeAll();
			}
		});
		}
	},

	remoteHasCompNick: function(allRemoteAgents,allValues){
		var isCompHasRemoteNick = false;
		if(allRemoteAgents != undefined && allRemoteAgents != "" && allValues != undefined && allValues != "")
		{
			var allRemoteAgentsArr = new Array();
			var allValuesArr = new Array();
			if(allRemoteAgents.indexOf(","))
			{
				allRemoteAgentsArr = allRemoteAgents.toString().split(",");
			}
			if(allValues.indexOf(","))
			{
				allValuesArr = allValues.toString().split(",");
			}
			for(var h=0; h<allRemoteAgentsArr.length; h++)
			{
				var remAgentVal = allRemoteAgentsArr[h].toLowerCase();
				for(var f=0; f<allValuesArr.length; f++)
				{
					if(remAgentVal == allValuesArr[f].toLowerCase())
					{
						isCompHasRemoteNick = true;
						break;
					}
				}
			}
		}
		return isCompHasRemoteNick;
	},

	backbutton: function(){
		if (fromPage == 'AgentStatus')
		{
			window.location.href="/final/admin/EgServerList.jsp?from=AgentAssign&agentType=RemoteAgents&agentStatus=All";
		}
		else if (fromPage == 'Discovery')
		{
			window.location.href="/final/admin/EgDiscoveryPane.jsp?selectedNode=node2";
		}
		else
		{
			fromAssignRem = "";
			Ext.getCmp('remoteviewport').removeAll();
			this.buildMainData();
			Ext.getCmp('remoteviewport').add({xtype: 'remoteagents'});
			this.afterMainRender();
		}
	},

	deleteAgent: function(btn){
		Ext.getCmp('remoteviewport').removeAll();
		this.getController('RemoteAgent.controller.DeleteRmtCtrl').buildDeleteFieldData();
		Ext.getCmp('remoteviewport').add({xtype: 'deleteremoteagents'});
		this.getController('RemoteAgent.controller.DeleteRmtCtrl').afterMainRender();
		var hasDelRemAgnt = publicJSON['remoteAgentArray'];
		if (hasDelRemAgnt = "" || hasDelRemAgnt.length == 0)
		{
			Ext.getCmp('agentsearch').disable();
		}
		else
		{
			Ext.getCmp('agentsearch').enable();
		}
	},
	agentVmStatistics: function(btn){
		Ext.getCmp('remoteviewport').removeAll();
		Ext.getCmp('remoteviewport').add({xtype: 'vmstatistics'});
		this.getController('RemoteAgent.controller.AgentVmStatistics').afterMainRender();
	},
	
	dwnldAgent: function()
	{
		window.location.href="/final/admin/EgDownloadAgentPack.jsp?from=Remote&fromWizard="+fromWizard;
	},

	deletefun: function(){
		var deleteRemote = Ext.getCmp('agents').getValue();
		if (deleteRemote.length == 0 || deleteRemote == "")
		{
			Ext.Msg.show(
			{
				title : deleteRmtPageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please select remote agent(s)']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			Ext.MessageBox.show(
			{
				title : deleteRmtPageTitle, 
				msg : deleteMsg,
				fn : this.deleting,
				icon : 'iconConfirmation',
				buttons : Ext.Msg.YESNO,
				scope :this
			});
		}
	},

	handleDeleteSelected: function() {
		var grid=Ext.getCmp('gridRmtDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.show(
			{
				title : 'Remote Agents',
				msg : noRmtSelected + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Hostname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.show(
		{
			title : 'Remote Agents',
			msg : deleteSelected + '.', 
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var qrString = "from=deleteRemoteAgentsPage"+"&remoteAgents="+encodeURIComponent(selectedGroups);
					Ext.Ajax.request({
						url: 'RemoteAgent/data/deletegroupsremotepJson.jsp?index=Remote&'+qrString,
						method: 'POST',
						success: function( response )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
							{
								var resultStatus = publicJSON['requestStatus'];
								if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
								{
									var resultStatus = publicJSON['result'];
									Ext.MessageBox.show(
									{
										title : resultStatus['title'],
										msg : resultStatus['message1'],
										icon : 'iconInformation',
										buttons : Ext.Msg.OK,
										fn : appRmtCnt.buildMainData()
									});
								}
								else
								{
									var errorStatus = publicJSON['error'];
									Ext.MessageBox.show(
									{
										title : errorStatus['title'],
										msg : errorStatus['message1'],
										icon : 'iconExclamation',
										buttons : Ext.Msg.OK,
										fn : refreshDelete
									});
								}
							}
							Ext.getCmp('gridRmtDisplay').store.loadData(publicJSON['gridRmtAgents']);
						}
					});
				}
			}
		});
	},

	deleting: function(btn){
		this.getController('RemoteAgent.controller.DeleteRmtCtrl').buildDeleteFieldData();
		if (btn == 'yes')
		{
			var remoteAgent = Ext.getCmp('agents').getValue();
			if (remoteAgent == null)
			{
				Ext.Msg.show(
				{
					title : deleteRmtPageTitle,
					msg : publicJSON['screenLabels']['admin.common.Please select remote agent(s)'] + '.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
			}
			else
			{
				var DeleteUrl = publicJSON['deleteLink'];
				var qrString = "from=deleteRemoteAgentsPage"+"&remoteAgents="+encodeURIComponent(remoteAgent);
				Ext.Ajax.request({
				url: 'RemoteAgent/data/deletegroupsremotepJson.jsp?index=Remote&'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.show(
							{
								title: resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								fn : refreshDelete
							});
						}
						else
						{
							var errorStatus = publicJSON['error'];
							Ext.MessageBox.show(
							{
								title : errorStatus['title'],
								msg : errorStatus['message1'],
								icon : 'iconExclamation',
								buttons : Ext.Msg.OK,
								fn : refreshDelete
							});
						}
					}
					Ext.getCmp('agentsearch').setRawValue('');
				}
			});
			}
		}
	},

	mainFormEvent : function(obj){
		this.getController('RemoteAgent.controller.DeleteRmtCtrl').buildDeleteFieldData();
		var compsearch = Ext.getCmp('agentsearch').getValue();
		if (compsearch == "" || compsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		
		Ext.Ajax.request({
		url: 'RemoteAgent/data/DeleteRemoteAgentsJson.jsp?compsearch='+compsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['searchArr'];
			if (value != null && value.length > 0)
			{
				Ext.getCmp('agents').show();
				Ext.getCmp('delRmtLabel').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('NoDelSearchFound').hide();
				Ext.getCmp('agents').getStore().loadRawData(publicJSON['searchArr']);
			}
			else
			{
				Ext.getCmp('agents').hide();
				Ext.getCmp('delRmtLabel').hide();
				Ext.getCmp('deleteBtn').hide();
				Ext.getCmp('NoDelSearchFound').show();
				Ext.getCmp('DelSearch').update('<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+'.</td></tr></table></td></tr></table>');
			}
		}
		});
	},

	backDelButton: function(btn){
		fromDeleteRem = "";
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'remoteagents'});
		this.afterMainRender();
	},

	backVMStatisticsEvent: function(btn){
		Ext.getCmp('remoteviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('remoteviewport').add({xtype: 'remoteagents'});
		this.afterMainRender();
	},

	afterMainRender : function(){
		if (fromAssignRem != null && fromAssignRem == "true")
		{
			Ext.getCmp('remoteviewport').removeAll();
			this.getController('RemoteAgent.controller.AssignRmtCtrl').buildFieldData();
			Ext.getCmp('remoteviewport').add({xtype: 'assignremoteagent'});
			this.getController('RemoteAgent.controller.AssignRmtCtrl').buildGivenAgentData(assignAgent);
			this.getController('RemoteAgent.controller.AssignRmtCtrl').afterMainRender();
		}
		else if (fromDeleteRem != null && fromDeleteRem == "true")
		{
			Ext.getCmp('remoteviewport').removeAll();
			this.getController('RemoteAgent.controller.DeleteRmtCtrl').buildDeleteFieldData();
			Ext.getCmp('remoteviewport').add({xtype: 'deleteremoteagents'});
			this.getController('RemoteAgent.controller.DeleteRmtCtrl').afterMainRender();
		}
		else
		{
			if(isLimitedAdmin == "true")
			{
				Ext.getCmp("bulkAddAgent").hide();
			}
			else
			{
				Ext.getCmp("bulkAddAgent").show();
			}
			var resultsData = publicJSON['gridRmtAgents'];
			if (resultsData == null || resultsData.length == 0)
			{
				Ext.getCmp('associateDissociate').disable();
				//Ext.getCmp('deleteRmtAgent').disable();
				Ext.getCmp('gridRmtDisplay').store.loadData('');
				Ext.getCmp('gridRmtDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtDesc+'.</td></tr></table></td></tr></table>';
				Ext.getCmp('gridRmtDisplay').getView().refresh();
			}
			else
			{
				Ext.getCmp('associateDissociate').enable();
				//Ext.getCmp('deleteRmtAgent').enable();
				Ext.getCmp('gridRmtDisplay').getStore().loadRawData(resultsData);
			}
			var noRmtFound = publicJSON['NoRmtFound'];
			if (noRmtFound == "true")
			{
				Ext.getCmp('gridRmtSearch').disable();
			}
			else
			{
				Ext.getCmp('gridRmtSearch').enable();
			}
		}
	}

});

	function refreshDelete(btn){
		Ext.Ajax.request({
		url: 'RemoteAgent/data/DeleteRemoteAgentsJson.jsp',
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
		}
	});
	Ext.getCmp('agents').getStore().loadData(publicJSON['remoteAgentArray']);
}

	function refreshAssignRmt(btn){
	var eagent = Ext.getCmp('rmtAgent').getValue();

	Ext.Ajax.request({
		url: 'RemoteAgent/data/EgConfigRemoteAgentsJson.jsp?eagent='+encodeURIComponent(eagent),
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			if (Ext.getCmp('itemselectremoteagent').fromField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectremoteagent').fromField.store.removeAll();
			}
			if (Ext.getCmp('itemselectremoteagent').toField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectremoteagent').toField.store.removeAll();
			}
			Ext.getCmp('itemselectremoteagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
			Ext.getCmp('itemselectremoteagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
		}
	});
}



