var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		var hideIconVal = view.getStore().getAt(rowIndex);
		var hostOrgName = hideIconVal.get('Hostname');
		var hostOrgIp = hideIconVal.get('HostIP');
		var isRemOrgIP = (RmtIpAgent==hostOrgName);
		if (isRemOrgIP)
		{
			//meta.tdCls = Ext.baseCSSPrefix;
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
		}
		if(record.get('isDisabled'))
		{
			//meta.tdCls = Ext.baseCSSPrefix;
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
		}
		else
		{
			//meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif" class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
			if (record.get('isDisabled')){
				Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
			}
			else 
			{
				var AssoDissAgntRem = record.get('AssoDissRemAgnt');
				var internalAgentRem = record.get('internalRemAgent');
				var hostOrgName = record.get('Hostname');
				if (RmtIpAgent == hostOrgName)
				{
					Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
				}
				else
				{
					if (AssoDissAgntRem || internalAgentRem)
					{
						Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
					}
					else
					{
						Ext.getCmp('gridRmtDisplay').getSelectionModel().select(rowIndex, true);
					}
				}
			}
			rowIndex++;
		}
		var view = Ext.getCmp('gridRmtDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
			Ext.getCmp('gridRmtDisplay').getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.getCmp('gridRmtDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('RemoteAgent.view.RemoteAgents', {
	extend: 'Ext.form.Panel',
	//extend: 'utilities.innerScrollContainer',
	alias: 'widget.remoteagents',
	id: 'mainRemoteAgent',
	title: homeTitle,
	margin:'8 8 0 8',
	//cls:'outerpanel',
	ui:'simplePanel simplePanelHeaderBorder',

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	/*dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		layout:{pack:'center'},
		width:'100%',
		height: 25,
		padding: 3,
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+rmtPageDesc+'.</center>'
			}
		]
	}],*/

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			scroll: true,
			id: 'gridRmtDisplay',
			store:new Ext.data.Store({
				fields: ['Hostname','HostIP','AssoDissRemAgnt','internalRemAgent','isDisabled'],
				data: []
			}),
			autoScroll: true,
			flex: 1,
			selModel:mySelectionModel,
			listeners : {
				beforeselect: function(selModel, record, index) {
					if (record.get('isDisabled')) {
						 return false;
					}
				},
				rowclick : function (in_this, rowIndex, e) {
					var record = in_this.getStore().getAt(rowIndex);
					if (record.get('isDisabled')){
						in_this.getSelectionModel().deselectRow(rowIndex);
					}
				}
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoRmtFound+'.</td></tr></table></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: lbl_AgntHst,
						dataIndex: 'Hostname',
						id: 'DispRmtHostName',
						flex: 1
					},
					{
						text: lbl_AgntIP,
						dataIndex: 'HostIP',
						id: 'DispRmtHostIP',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						id: 'EditRmtOver',
						sortable: false,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+label_Modify+"' data-qclass='yellowTip'";
							var hostOrgName = record.get('Hostname');
							if (RmtIpAgent == hostOrgName)
							{
								return '<div class="iconModifyDisabled"></div>';
							}
							else
							{
								return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconModify'></div>";
							}
						}
					},
					{
						dataIndex: 'AssignHostsLink',
						width: 36,
						sortable: false,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							result = "";
							var result = '<center><a href="javascript:appRmtCnt.showAssignHosts('+row+',\'gridRmtDisplay\');"><div class="iconShowAssociates"  data-qtip="'+label_AssAgent+'" data-qclass="yellowTip"></div></a></center>';
							return result;
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="'+label_delSel+'" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'DeleteRmtOver',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appRmtCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+label_Delete+"' data-qclass='yellowTip'";

							var AssoDissAgntRem = record.get('AssoDissRemAgnt');
							var internalAgentRem = record.get('internalRemAgent');
							var hostOrgName = record.get('Hostname');
							if (RmtIpAgent == hostOrgName)
							{
								return '<div class="iconDeleteDisabled"></div>';
							}
							else
							{
								if (AssoDissAgntRem || internalAgentRem)
								{
									return '<div class="iconDeleteDisabled"></div>';
								}
								else
								{
									return "<div style='cursor:pointer' onclick=\"javascript:appRmtCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
								}
							}

						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					id: 'gridRmtSearch',
					name: 'gridRmtSearch',
					emptyText: 'Search',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appRmtCnt.mainGridSearch();
					},
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items: [
						{
							xtype: 'button',
							cls:'button20',
							text: lbl_AddAgnt,
							id: 'addRmtAgent'
						},
						{
							xtype: 'button',
							cls:'button20',
							text: bulkAddOrDeleteTitle,
							action: 'openPopupWin',
							id: 'bulkAddAgent'
						},
						{
							xtype: 'button',
							cls: 'button20',
							text: lbl_AssHost,
							id: 'associateDissociate'
						},
						//{
							//xtype: 'button',
							//cls:'button20',
							//text: lbl_DelAgnt,
							//id: 'deleteRmtAgent',
							//listeners: {
								//"afterrender":function()
								//{
									//Ext.create("Ext.tip.ToolTip",{target:this.id,anchor:"top",cls:"yellowTip",trackMouse:true,html:lbl_DelToolAgnt});
								//}
							//}
						//},
						{
							xtype: 'button',
							cls:'button20',
							text: lbl_VM,
							id: 'vMStatistics'
						},
						{
							xtype: 'button',
							cls:'button20',
							text: downAgent,
							id: 'dwnldAgent',
							hidden: hideDwnldAgent
						}
					]
				}
			]
		}
	],
	listeners: {
		close: function() 
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: rmtPageDesc+'.',
				cls: "adminInfoTooltip"
			});
		}
	}

});



