var cmd = Ext.create('RemoteControl.view.ConfigureControlActionCmd');
Ext.define('RemoteControl.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'configurecontrolactionForm',ref:'configurecontrolactionForm'},
		{selector:'cmd',ref:'cmd'}
	],
	init:function()
	{
		var me = this;
		this.control({
			'configurecontrolactionForm button[name="execute"]':{
				'click':this.showResult
			},
			'configurecontrolactionForm combo[id="commandOpts"]':{
				'select':this.changeCommand
			},
			'main' :
			{
				'boxready' : this.loadDefaultValues
			},
			'main  #upbutton':
			{
				'click':this.toggleForm
			},
			'main button[id="bckBtn"]':
			{
				'click' : this.goBack
			}
		});
	},
	loadDefaultValues: function()
	{
		var me = this;
		Ext.Ajax.request({
				url : '/final/admin/RemoteControl/data/ConfigureControlActionJson.jsp',
				method : 'POST',
				params: defaultParams+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicJson = jsonData;
					var thisForm = me.getConfigurecontrolactionForm()
					var screenLabels = publicJson['screenLabels'];

					var AgentIp = Ext.getCmp('AgentIp');
					AgentIp.setValue(publicJson['pageParams']['selectedAgent']);

					var AgentMode = Ext.getCmp('AgentMode');
					AgentMode.setValue(publicJson['pageParams']['selectedAgentMode']);

					var commandOpts = Ext.getCmp('commandOpts');
					commandOpts.getStore().loadRawData(publicJson['commandOpts']);
					commandOpts.setValue(publicJson['pageParams']['selectedCmd']);

					var arugumentsTextBox = Ext.getCmp('arugumentsTextBox');
					arugumentsTextBox.setValue(publicJson['pageParams']['arguments']);

					var outputRqrdCombo = Ext.getCmp('outputRqrd');
					outputRqrdCombo.getStore().loadRawData(publicJson['yesNoOpts']);
					outputRqrdCombo.setValue(publicJson['pageParams']['outputRequired']);

					var timeOutTextbox = Ext.getCmp('timeOutTextbox');
					timeOutTextbox.setValue(publicJson['pageParams']['selectedTimeOutPeriod']);

					var backButtonNeeded = publicJson['pageParams']['backButtonNeeded'];
					if (backButtonNeeded != null && backButtonNeeded == 'Yes') {
						Ext.getCmp('bckBtn').show();
					}
				},
				failure: function(response)
				{
				}
			});
	},
	goBack : function()
	{
		window.location.href = '/final/admin/EgServerList.jsp?reqfrom=navlink&from_remote_control_page=true&s_agent_type='+agent_type;
	},
	toggleForm:function()
	{
		var ornt = Ext.getCmp('configcontrolform');
		ornt.toggleCollapse(true);
	},
	showResult : function()
	{
		var thisForm = this.getConfigurecontrolactionForm().getForm();
		var AgentIp = thisForm.findField('AgentIp').getValue();
		var AgentMode = thisForm.findField('AgentMode').getValue();
		var commandOpts = thisForm.findField('commandOpts').getValue();
		var cmdSyntax = thisForm.findField('cmdSyntax').getValue();
		var aruguments = thisForm.findField('arugumentsTextBox').getValue();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();

		if(commandOpts == "-1")
		{
			Ext.Msg.show({
				title:'Remote Control',
				 msg: commandAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else if(commandOpts=='-2') // this is for other option
		{
			commandOpts = cmdSyntax;
			if(cmdSyntax == "")
			{
				Ext.Msg.show({
					title:'Remote Control',
					msg: 'Please provide a command syntax',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
		}
		else
		{
			if(aruguments!=null && (aruguments!="none" && aruguments!=""))
				commandOpts = commandOpts+ " "+aruguments;
		}
		if(!checkNumberValue("+",timeOut) || timeOut.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title:'Remote Control',
				msg: timeoutInpAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else
		{
			var remoteCmd = this.getCmd();
			remoteCmd.removeAll();
			var commandOpts1 = commandOpts.replace(/\r\n|\r|\n/g,'#');

			var hiddenQStr = publicJson['hiddenQStr'];
			var paramsForReq = "isJsonResp=true&response1=yes&&agentIP="+encodeURIComponent(AgentIp)+"&agentMode1="+encodeURIComponent(AgentMode)
			+"&selCmd="+encodeURIComponent(commandOpts)+"&txtCmd1="+encodeURIComponent(commandOpts)
			+"&arguments="+encodeURIComponent(aruguments)+"&txtCmd="+encodeURIComponent(commandOpts1)+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+'&agent_type='+agent_type;
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			var rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Command is being processed. Please wait for few seconds."
			});
			rcLoadMask.show();
			Ext.Ajax.request({
				url : '/final/admin/RemoteControl/data/ConfigureControlActionp.jsp',
				method : 'POST',
				params: paramsForReq,
				timeout:timeOutValForAjax,
				scope:this,
				success: function(response)
				{
					rcLoadMask.hide();
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData))
					{
						var errorMessage = jsonData['errorMessage'];
						if(errorMessage!=null && errorMessage!="-")
						{
							var emptyPanelContainer = Ext.getCmp('emptyPanelContainer');
							emptyPanelContainer.update('<table height="100%"><tr><td align="center" height="100%"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"/></td></tr><tr><td align="center" class="commonErrorMsgText" height="20px">'+errorMessage+'</td></tr></table></td></tr></table>');
							Ext.getCmp('emtyPanel').show();
						}
						else
						{
							Ext.getCmp('emtyPanel').hide();
							var newMode = jsonData['newMode'];
							if(newMode!=null && newMode=='true')
							{
								window.location.href = jsonData['forwardUrl'];
							}
							else
							{
								var result = jsonData['output'];
								var updatepanel = Ext.getCmp('remote_cmd');
								updatepanel.update(result);
								updatepanel.doLayout();
								remoteCmd.show();
							}
						}
					}
				},
				failure:function()
				{
					rcLoadMask.hide();
					var updatepanel=Ext.getCmp('remote_cmd');
					var output="<ul  style='font-weight:500;font-size:11px; font-weight:bold;color:#fff;margin:10px'><li>Command execution was timed out<\/li><\/ul>";
					updatepanel.update(output);
					updatepanel.doLayout();
					remoteCmd.show();
				}
			});
		}
	},
	changeCommand :  function(combo)
	{
		var thisForm = this.getConfigurecontrolactionForm().getForm();
		if(combo.getValue()=='-2')
		{
			thisForm.findField('cmdSyntax').show();
			thisForm.findField('arugumentsTextBox').hide();
		}
		else
		{
			thisForm.findField('cmdSyntax').hide();
			thisForm.findField('arugumentsTextBox').show();
		}
	},
	resizeMe:function()
	{
		cmd.setWidth(Ext.getBody().getViewSize().width -10);
		cmd.setHeight(Ext.getBody().getViewSize().height -10)
	},
	showCmd:function()
	{
		cmd.show();
	},
	cmdBack:function(bt)
	{
		cmd.hide();
	}
});



