Ext.define('ResetThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'resetthresholdview', ref:'resetthresholdview'},
		{selector:'resetdefaultthresholdmeasures', ref:'resetdefaultthresholdmeasures'}
	],
	init:function(){
		me = this,
		this.control({

			'resetthresholdview' : 
			{
				'afterrender': this.afterMainRender,
			},
			'resetthresholdview button[id="resetAllBtn"]':
			{
				'click': this.resetAllThresholds,
			},
			'resetthresholdview button[id="specificResetBtn"]':
			{
				'click': this.updateSpecificResetThresholds,
			}
		});
	},
	actionToPerform: function(obj) {
		var selectedAction = obj.value;
		var testNameComboObj = Ext.getCmp('testName');
		var isAffectFactorySettings = publicJson.isAffectFactorySettings;

		if (!Ext.isEmpty(selectedAction) && selectedAction == 'resetall')
		{
			if (isAffectFactorySettings)
			{
				testNameComboObj.hide();
				testNameComboObj.setDisabled(true);
				testNameComboObj.setValue(publicJson.testListArray[0].valueField);
			}

			Ext.getCmp("specificResetBtn").setText("Reset");

			var specificLevelGridObj = Ext.getCmp('specificThreshLevelGrid');
			var actionComboObj = Ext.getCmp('specificThreshLevelGrid').tools[0];
			
			var gridTitle = publicJson['gridTitle'];
			if (!Ext.isEmpty(gridTitle))
			{
				specificLevelGridObj.setTitle(gridTitle);
			}

			var threshLevelListArr = publicJson.threshLevelListArr;

			if (!Ext.isEmpty(actionComboObj.value) && actionComboObj.value == 'resetall')
			{
				if (!Ext.isEmpty(threshLevelListArr) && threshLevelListArr != undefined)
				{
					Ext.getCmp('threshTestBar').show();
					Ext.getCmp('threshTestBarText').update('<i>'+pageDescForResetAllGrid+'<br>'+genericMsgForResetAllGrid+"</i>");
					specificLevelGridObj.getStore().removeAll();
					specificLevelGridObj.getStore().loadRawData(threshLevelListArr);
					specificLevelGridObj.getSelectionModel().selectAll(true);
					Ext.getCmp('specificResetBtn').setDisabled(false);
				}
				else
				{
					Ext.getCmp('threshTestBar').hide();

					specificLevelGridObj.getSelectionModel().deselectAll(true);
					specificLevelGridObj.getStore().removeAll();
					Ext.getCmp('specificResetBtn').setDisabled(true);
				}
			}
		}
		else if (!Ext.isEmpty(selectedAction) && selectedAction == 'resettest')
		{
			testNameComboObj.show();
			testNameComboObj.setDisabled(false);

			testNameComboObj.setValue(publicJson.testListArray[0].valueField);
			testNameComboObj.fireEvent('select', testNameComboObj);
			
			Ext.getCmp("specificResetBtn").setText("Delete");

			var specificLevelGridObj = Ext.getCmp('specificThreshLevelGrid');
			Ext.getCmp('threshTestBar').hide();

			specificLevelGridObj.getSelectionModel().deselectAll(true);
			specificLevelGridObj.getStore().removeAll();
			Ext.getCmp('specificResetBtn').setDisabled(true);
		}
	},
	updateSpecificResetThresholds:  function() 
	{
		var threshLevelsSelected = false;
		var allowToSubmit = true;
		var dataRecord = Ext.getCmp('specificThreshLevelGrid').getStore().getCount();
		var testName = Ext.getCmp('testName').getValue();
		var actionComboObj = Ext.getCmp('actionCombo');
		var selectedThreshLevels = Array();
		var availLevelForTest = Array();
		for (var i = 0;i < dataRecord ;i++ )
		{
			var record = Ext.getCmp('specificThreshLevelGrid').getStore().getAt(i);
			isChecked = Ext.getCmp('specificThreshLevelGrid').getSelectionModel().isSelected(record);

			var levelName = record.get('thresholdLevels');
			availLevelForTest.push(levelName);
			if (isChecked)
			{
				threshLevelsSelected = true;
				selectedThreshLevels.push(levelName);
			}
		}

		var selectAllLevels = false;
		if (dataRecord == selectedThreshLevels.length)
		{
			selectAllLevels = true;
		}

		if (!threshLevelsSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg:resetMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			allowToSubmit = false;
		}

		if (allowToSubmit)
		{
			var isDefaultChangeForResetAll = publicJson.isDefaultChangeForResetAll;
			var isDefaultDescChangeForResetAll = publicJson.isDefaultDescChangeForResetAll;

			var infoMsg = deleteAllDefThreshConfMsg;
			var params = "operation=resetAll&selectAll="+selectAllLevels+"&selectedThreshLevels="+selectedThreshLevels+"&isDefaultDescriptorChange="+isDefaultDescChangeForResetAll+"&isDefaultChange="+isDefaultChangeForResetAll;
			var urlVal = 'ResetThreshold/data/EgApplyResetAllThresholds.jsp?'+params;

			if (!Ext.isEmpty(actionComboObj) && actionComboObj.getValue() == 'resettest')
			{
				infoMsg = deleteDefaultThreshConfMsg;

				var isDescChange = publicJson.isDefaultDescriptorChange;
				var isDefaultChange = publicJson.isDefaultChange;

				params = "operation=reset&selectAll="+selectAllLevels+"&selectedThreshLevels="+selectedThreshLevels+"&availLevelForTest="+availLevelForTest+"&testName="+testName+"&isDefaultDescriptorChange="+isDescChange+"&isDefaultChange="+isDefaultChange;
				urlVal = 'ResetThreshold/data/EgApplyResetDefaultThresholds.jsp?'+params;

			}

			Ext.Msg.show({
				title: pageName,
				msg: infoMsg,
				icon: 'iconConfirmation',
				buttons: Ext.Msg.YESNO,
				fn: function (response) {
					if (response == "yes")
					{
						me.allowToSpecificReset(urlVal);
					}
				}
			});
		}
	},
	afterMainRender : function()
	{
		params = 'reqfrom=navlink';
		var qStr = '';
		if (strTestName != null && strTestName != 'undefined' && strTestName.length > 0)
		{
			qStr = 'testName='+strTestName;
		}
		
		
		if (qStr != null && qStr.length > 0)
		{
			params = qStr;
		}

		Ext.Ajax.request({
			url:'ResetThreshold/data/EgResetThresholdsJson.jsp?'+params,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText))
				{
					publicJson = Ext.decode(jsonText);
					var resetBlock = Ext.getCmp('resultContainer');
					var hasManageServers = publicJson.hasManageServers;
					if (!Ext.isEmpty(hasManageServers) && hasManageServers)
					{
						var isAffectFactorySettings = publicJson.isAffectFactorySettings;
						var actionComboArr = publicJson.actionComboArr;
						var threshChangeTestList = publicJson.testListArray;

						var newSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
							selType: 'checkboxmodel',
							mode: 'MULTI',
							checkOnly: true,
							deselectAll: function() {
								var rowIndex=0;
								while(typeof(Ext.getCmp('specificThreshLevelGrid').getStore().getAt(rowIndex))!='undefined') {
									var record = Ext.getCmp('specificThreshLevelGrid').getStore().getAt(rowIndex);
									Ext.getCmp('specificThreshLevelGrid').getSelectionModel().deselect(rowIndex, true);
									rowIndex++;
								}
								var view = Ext.getCmp('specificThreshLevelGrid').getView();
								var headerCt = view.headerCt;
								var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
								if (checkHd)
								{
									//checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
								}
							}
						});

						var tmpGrid = {
							xtype: 'customgrid',
							cls: 'gridSkin',
							id: 'specificThreshLevelGrid',
							name: 'specificThreshLevelGrid',
							store: new Ext.data.Store({
								fields: ['thresholdLevels'],
								data: []
							}),
							height: 305,
							width: 600,
							selModel: newSelectionModel,
												hideHeaders: true,

							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false,
									isCheckerHd: true
								},
								items: [
									{
										text: levelsTitle,
										dataIndex: 'thresholdLevels',
										id: 'specificLevel',
										checked: true,
										hideHeaders: true,

										flex: 1
									}
								]
							},
							tools:[
								{
									xtype: 'scrollcombo',
									id: 'actionCombo',
									name: 'actionCombo',
									fieldLabel: actionComboLbl,
									labelSeparator: '',
									labelAlign: 'top',
									width: 250,
									//labelWidth: 80,
									padding: 5,
									store: new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: actionComboArr,
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									value: 'resetall',
									queryMode: 'local',
									editable: false,
									listeners: {
										select: function()
										{
											me.actionToPerform(this);
										}
									}
								},
								{
									xtype: 'scrollcombo',
									id: 'testName',
									name: 'testName',
									fieldLabel: label2,
									labelSeparator: '',
									labelAlign: 'top',
									//width: 450,
									//labelWidth: 80,
									padding: 5,
									store: new Ext.data.Store(
									{
										fields: ['displayField','valueField','groupField'],
										data: threshChangeTestList
									}),
									displayField: 'displayField',
									groupField: 'groupField',
									valueField: 'valueField',
									queryMode: 'local',
									editable: false,
									listConfig: {
										tpl: Ext.create('Ext.XTemplate',
											'<ul><tpl for=".">',
											'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
											'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
											'</tpl>',
											'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
											'</tpl>' +
											'</ul>',
											{
												getGroupLabel: function (values) {
													return values.groupField
												}
											}
										)
									},
									listeners: {
										select: function()
										{
											me.testNameChange();
										}
									},
									hidden: true
								}
							],
							margin: 10,
							dockedItems: [
								{
									xtype: 'toolbar',
									dock: 'top',
									hidden: true,
									id: 'threshTestBar',
									name: 'threshTestBar',
									padding: 5,
									border:true,
									items: [
										{
											xtype: 'component',
											id:'threshTestBarText',
											name:'threshTestBarText',
											html: "<i>"+pageDescForResetAllGrid+'<br>'+genericMsgForResetAllGrid+"</i>",
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'toolbar',
									dock: 'bottom',
									cls: 'testConfigToolbarBg',
									ui: 'footer',
									padding: 5,
									layout: {pack:'center'},
									items: [
										{
											xtype: 'button',
											cls: 'button20',
											id: 'specificResetBtn',
											name: 'specificResetBtn',
											text: 'Reset',
											width: 80
										}
									]
								}
							]
						};
						Ext.suspendLayouts();
						resetBlock.removeAll();
						resetBlock.add(tmpGrid);
						Ext.getCmp('specificThreshLevelGrid').tools[0].value='resetall';
						var specificLevelGridObj = Ext.getCmp('specificThreshLevelGrid');
						var actionComboObj = Ext.getCmp('specificThreshLevelGrid').tools[0];
						var gridTitle = publicJson['gridTitle'];
						if (!Ext.isEmpty(gridTitle))
						{
							specificLevelGridObj.setTitle(gridTitle);
						}
						var threshLevelListArr = publicJson.threshLevelListArr;
						Ext.resumeLayouts(true);

						if (!Ext.isEmpty(actionComboObj.value) && actionComboObj.value == 'resetall')
						{
							if (!Ext.isEmpty(threshLevelListArr) && threshLevelListArr != undefined)
							{
								Ext.getCmp('threshTestBar').show();
								specificLevelGridObj.getStore().removeAll();
								specificLevelGridObj.getStore().loadRawData(threshLevelListArr);
								specificLevelGridObj.getSelectionModel().selectAll(true);
								Ext.getCmp('specificResetBtn').setDisabled(false);
							}
							else
							{
								Ext.getCmp('threshTestBar').hide();

								specificLevelGridObj.getSelectionModel().deselectAll(true);
								specificLevelGridObj.getStore().removeAll();
								Ext.getCmp('specificResetBtn').setDisabled(true);
							}

							if (isAffectFactorySettings)
							{
								Ext.getCmp('specificThreshLevelGrid').tools[1].value=threshChangeTestList[0].valueField;
							}
							else
							{
								Ext.getCmp('testName').hide();
								Ext.getCmp('testName').setDisabled(true);

							}
						}
					}
					else
					{
						//Ext.getCmp('resetAllBtn').setDisabled(true);
						noServerTypeMsg = publicJson.screenLabels['NoServerTypeMsg'];
						var tmpMsgContainer = {
							xtype: 'container',
							id: 'noManageServers',
							name: 'noManageServers',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: 15,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noServerTypeMsg+'</td></tr></table></td></tr></table>'
								}
							]
						};
						Ext.suspendLayouts();
						resetBlock.removeAll();
						resetBlock.add(tmpMsgContainer);
						Ext.resumeLayouts(true);
					}
				}
			}
		});
	},
	testNameChange: function ()
	{
		var testName = Ext.getCmp('testName').getValue();
		var testDispName = Ext.getCmp('testName').getRawValue();
		Ext.getCmp('specificResetBtn').setDisabled(true);
		if (testName != null && !Ext.isEmpty(testName))
		{
			strTestName = testName;

			var resetBlock = Ext.getCmp('resultContainer');

			var myMask = null;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if(!Ext.isEmpty(Ext.get(wholeViewport))){
				myMask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				myMask.show();
			}
		
			Ext.Ajax.request({
				url:'ResetThreshold/data/EgResetThresholdsJson.jsp?&testName='+testName,
				method:'POST',
				scope:this,
				timeout: 600000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						var isAddedResetBtn = false;

						var specificLevelGridObj = Ext.getCmp('specificThreshLevelGrid');
						var gridTitle = publicJson['gridTitle'];
						if (!Ext.isEmpty(gridTitle))
						{
							specificLevelGridObj.setTitle(gridTitle);
						}
						var dispTestName = Ext.getCmp('testName').getRawValue();
						var specificThreshLevelListArr = publicJson.specificThreshLevelListArr;
						if (!Ext.isEmpty(specificThreshLevelListArr) && specificThreshLevelListArr != undefined)
						{
							Ext.getCmp('threshTestBar').show();
							Ext.getCmp('threshTestBarText').update('<i>'+dispTestName+' '+pageDescForGrid+'.<br>'+genericMsgForResetGrid+"</i>");
							specificLevelGridObj.getStore().removeAll();
							specificLevelGridObj.getStore().loadRawData(specificThreshLevelListArr);
							specificLevelGridObj.getSelectionModel().selectAll(true);
							Ext.getCmp('specificResetBtn').setDisabled(false);
						}
						else
						{
							Ext.getCmp('threshTestBar').hide();

							specificLevelGridObj.getSelectionModel().deselectAll(true);
							specificLevelGridObj.getStore().removeAll();
							Ext.getCmp('specificResetBtn').setDisabled(true);
						}
						myMask.hide();
					}
				},
				failure: function(response) {
					myMask.hide();
					Ext.getCmp('specificResetBtn').setDisabled(true);
				}
			});
		}
	},
	updateResetAllThresholds: function ()
	{
		var levelsSelected = false;
		var allowToSubmit = true;
		var dataRecord = Ext.getCmp('resetAllThresholdGrid').getStore().getCount();
		var selectedLevels = Array();
		for (var i = 0;i < dataRecord ;i++ )
		{
			var record = Ext.getCmp('resetAllThresholdGrid').getStore().getAt(i);
			isChecked = Ext.getCmp('resetAllThresholdGrid').getSelectionModel().isSelected(record);

			if (isChecked)
			{
				levelsSelected = true;
				selectedLevels.push(record.get('thresholdLevels'));
			}
		}

		var selectAll = false;
		if (dataRecord == selectedLevels.length)
		{
			selectAll = true;
		}

		if (!levelsSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg:resetMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			allowToSubmit = false;
		}

		if (allowToSubmit)
		{
			Ext.Msg.show({
				title: pageName,
				msg: deleteDefaultThreshConfMsg,
				icon: 'iconConfirmation',
				buttons: Ext.Msg.YESNO,
				fn: function (response) {
					if (response == "yes")
					{
						var params = "operation=resetAll&selectAll="+selectAll+"&selectedThreshLevels="+selectedLevels;
						var urlVal = 'ResetThreshold/data/EgApplyResetAllThresholds.jsp?'+params;

						me.allowToReset(urlVal);
					}
				}
			});
		}
	},
	allowToSpecificReset: function(urlVal) 
	{
		var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
		myHomeMask.show();

		var formObj = this.getResetthresholdview().getForm();
		if (formObj.isValid())
		{
			var successMsg = successMsg2;
			var actionComboObj = Ext.getCmp('actionCombo');
			if (!Ext.isEmpty(actionComboObj) && actionComboObj.getValue() == 'resettest')
			{
				successMsg = successMsg1;
			}

			this.getResetthresholdview().submit({
				url: urlVal,
				method: 'POST',
				timeout: 9000,
				success: function (form, action) 
				{
					myHomeMask.hide();
					var jsonText = action.response.responseText;
					if (action.response.status == 200 && !Ext.isEmpty(jsonText))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: successMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function() {
								strTestName = '';
								me.afterMainRender();
							}
						});
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK,
						fn: function() {
							strTestName='';
							me.afterMainRender();
						}
					});
				}
			});
		}
	},
	allowToReset: function(urlVal) 
	{
		var myHomeMask = new Ext.LoadMask(Ext.getCmp('resetWindow'), {msg:"Updating..."});
		myHomeMask.show();

		if (!Ext.isEmpty(urlVal))
		{
			Ext.Ajax.request({
				url: urlVal,
				method: 'POST',
				timeout: 60009000,
				success: function (response) 
				{
					myHomeMask.hide();
					var jsonText = response.responseText;
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: successMsg1,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('resetWindow').destroy();
								me.afterMainRender();
							}
						});
					}
				},
				failure: function() 
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK,
						fn: function() {
							Ext.getCmp('resetWindow').destroy();
							me.afterMainRender();
						}
					});
				}
			});
		}
	},
	resetAllThresholds: function()
	{
		var newCheckGridSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
			selType: 'checkboxmodel',
			mode: 'MULTI',
			checkOnly: true,
			deselectAll: function() {
				var rowIndex=0;
				while(typeof(Ext.getCmp('resetAllThresholdGrid').getStore().getAt(rowIndex))!='undefined') {
					var record = Ext.getCmp('resetAllThresholdGrid').getStore().getAt(rowIndex);
					Ext.getCmp('resetAllThresholdGrid').getSelectionModel().deselect(rowIndex, true);
					rowIndex++;
				}
				var view = Ext.getCmp('resetAllThresholdGrid').getView();
				var headerCt = view.headerCt;
				var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
				if (checkHd)
				{
					//checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
				}
			}
		});

		Ext.widget('window', {
			extend: 'Ext.window.Window',
			title: resetMsg4,
			id : 'resetWindow',
			closeAction: 'destory',
			width: 500,
			//height: 355,
			modal: true,
			doClose: function() {
				this.destroy();
			},
			items : [
				{
					xtype: 'container',
					id: 'tmpResetAllThreshContainer',
					name: 'tmpResetAllThreshContainer'
				}
			]
		}).show();

		var tmpGrid = 
		{
			xtype: 'customgrid',
			cls: 'gridSkin',
			id: 'resetAllThresholdGrid',
			name: 'resetAllThresholdGrid',
			store: new Ext.data.Store({
				fields: ['thresholdLevels'],
				data: []
			}),
			height: 300,
			selModel: newCheckGridSelectionModel,
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false,
					isCheckerHd: true
				},
				items: [
					{
						text: levelsTitle,
						dataIndex: 'thresholdLevels',
						id: 'level',
						checked: true,
						flex: 1
					}
				]
			},
			margin: 10,
			dockedItems: [
				{
					xtype: 'toolbar',
					dock: 'top',
					padding: 5,
					border:true,
					items: [
						{
							xtype: 'component',
							html: '<i>'+pageDescForResetAllGrid+'</i>',
							margin: '0 0 0 5'
						}
					]
				},
				{
					xtype: 'toolbar',
					dock: 'bottom',
					cls: 'testConfigToolbarBg',
					ui: 'footer',
					padding: 5,
					layout: {pack:'center'},
					items: [
						{
							xtype: 'button',
							cls: 'button20',
							id: 'applyResetBtn',
							name: 'applyResetBtn',
							text: 'Reset',
							width: 80,
							handler: function() {
								me.updateResetAllThresholds();
							}
						}
					]
				}
			]
		}
		var tmpObj = Ext.getCmp('tmpResetAllThreshContainer');
		Ext.suspendLayouts();
		tmpObj.removeAll();
		tmpObj.add(tmpGrid);
		Ext.resumeLayouts(true);
		Ext.getCmp('resetWindow').center();

		var resetAllGridObj = Ext.getCmp('resetAllThresholdGrid');
		var gridTitle = publicJson['gridTitle'];
		if (!Ext.isEmpty(gridTitle))
		{
			resetAllGridObj.setTitle(gridTitle);
		}
		var threshLevelListArr = publicJson.threshLevelListArr;
		if (!Ext.isEmpty(threshLevelListArr) && threshLevelListArr != undefined)
		{
			resetAllGridObj.getStore().loadRawData(threshLevelListArr);
			resetAllGridObj.getSelectionModel().selectAll(true);
		}
	}
});



