Ext.define('SaveSchedule.controller.Schedules',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs: [{selector:'main',ref:'main'}] ,
	init:function(){
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' : this.scheduleRender
			},
			'main button[id="saveBtn"]':
			{
				'click': this.saveButtonCalled
			}
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/admin/SaveSchedule/data/saveScheduleResponse.jsp?com.eg.CSRF_NONCE='+csrfToken,
			params:queryString,
			method: 'POST',
			scope:this,
			async:false,
			success: function(response){
				var jsonText = response.responseText;
				jsonData = Ext.decode(jsonText);
			}
		});
	},
	scheduleRender : function()
	{
		if(!Ext.isEmpty(jsonData))
		{
			if(requestFor!=null && requestFor=='schedule_modify'){
				Ext.getCmp("saveschedule").getHeader().show();
				Ext.getCmp('saveschedule').getEl().setStyle({margin : '8px 8px 0px 8px'});
				Ext.getCmp('saveschedule').doLayout();
			}
			this.loadData(jsonData);
			Ext.getCmp('sch_name').setFieldLabel(jsonData.screenLabels['reporter.common.Schedule Name']);
			Ext.getCmp('mail_freq').setFieldLabel(jsonData.screenLabels['reporter.common.Mail']);
			Ext.getCmp('mail_id').setFieldLabel(jsonData.screenLabels['reporter.common.Mail Id']);
			Ext.getCmp('receive_type').setFieldLabel(jsonData.screenLabels['reporter.common.Schedule Type']);
			Ext.getCmp('schedule_held_on').setFieldLabel(jsonData.screenLabels['reporter.common.Receiving Type']);
		}
	},
	saveButtonCalled : function()
	{
		var field = Ext.getCmp('timeAt');
		var value = field.getValue();
		var formattedValue = Ext.Date.format(value, 'H:i');
		var fromHours = formattedValue.substring(0,formattedValue.indexOf(':'));
		var fromMinutes = formattedValue.substring(formattedValue.indexOf(':')+1);

		var formObj = Ext.getCmp("saveschedule").getForm();
		if(formObj.isValid())
		{
			var oldname = Ext.getCmp("sch_name").getValue();
			var sch_name  = formObj.findField("sch_name").getValue();
			var details  = formObj.findField("details").getValue();
			var scheduleMailFormat  = formObj.findField("scheduleMailFormat").getValue();
			var scheduleMailreceiveType  = Ext.getCmp("receive_type").getValue();
			var mail_id  = formObj.findField("mail_id").getValue();
			var mail_freq  = formObj.findField("mail_freq").getValue();

			if(!checkblank(sch_name))
			{
				Ext.Msg.show({
					title: saveSchedule,
					msg: errorMsg1,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				formObj.findField("sch_name").focus();
				return false;
			}
			else if(!validateTextBoxWithSpecialChars(sch_name,scheduleMailreceiveType,true))
			{
				formObj.findField("sch_name").focus();
				return false;
			}
			else if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false" && !validateSingleByte(sch_name))
			{
				Ext.Msg.show({
					title:saveSchedule,
					msg: schedule_DBLerror_msg,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if(mail_freq.toLowerCase()=="none")
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: errorMsg2,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false") && !checkmultiplemailid(mail_id,false))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: _checkmail,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if((isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false") && !validateSingleByte(mail_id))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: mailID_DBLerror_msg,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else
			{
				if(successfulLogons=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Successful_AuditLog");
				}
				else if(failedLogons=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Failed_AuditLog");
				}
				if(adminAuditLog=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Admin_AuditLog");
				}
				else if(monitorAuditLog=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Monitor_AuditLog");
				}
				else if(reporterAuditLog=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Reporter_AuditLog");
				}
				else if(configAuditLog=="true")
				{
					formObj.findField("sch_name").setValue(oldname+"#Config_AuditLog");
				}

				var homepage = Ext.getCmp('viewPortId');
				myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
				myMask.show();
				var closeFn =  window.parent;
				formObj.submit({
					url:submitScheduleURL,
					method: 'POST',
					params:{"fromHours":fromHours,"fromMinutes":fromMinutes},
					//standardSubmit: true,
					success : function(form, action){
						myMask.hide();
						if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText))
						{
							var publicJSON = Ext.decode(action.response.responseText);
							if (publicJSON.hasSaved)
							{
								Ext.Msg.show({
									title : saveSchedules,
									msg : savedMsg,
									icon : 'iconInformation',
									buttons : Ext.Msg.OK,
									fn : function(btn){
										if (!Ext.isEmpty(requestFor) && requestFor.toLowerCase() == 'schedule_modify')
										{
											window.location.href = "/final/admin/viewSchedule.jsp?cmd=View&fromNavLink=true&menuForVM=true";
										}
										else
										{
											closeFn.doCloseWin();
										}
									}
								});
							}
							else
							{
								formObj.findField("sch_name").setValue(oldname);
								Ext.Msg.alert(saveSchedules,errorMsg);
							}
						}
					},
					failure : function(form, action)
					{
						formObj.findField("sch_name").setValue(oldname);
					}

				});
			}
		}
		else
		{
			var sch_name  = formObj.findField("sch_name").getValue();
			var mail_id  = formObj.findField("mail_id").getValue();
			var mail_freq  = formObj.findField("mail_freq").getValue();
			if(!checkblank(sch_name))
			{
				Ext.Msg.show({
					title: saveSchedule,
					msg: errorMsg1,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				formObj.findField("sch_name").focus();
				return false;
			}
			else if(validateTextBoxWithSpecialChars(sch_name,'InLine',true))
			{
				return;
			}
			if(mail_id!="" && mail_id!=null)
			{
			   var flag = true;
				var s_spl="`~!#$%^&*()+={}[]\\|?;\"\'\/<>";
				for(var i=0; i<s_spl.length; i++)
				{
					check_char = mail_id.indexOf(s_spl.charAt(i));
					if(check_char >-1)
					{
						flag = false;
					}
				}
				if(flag==false)
				{
					Ext.Msg.show({
					title:saveSchedule,
					msg: _checkmail,//"Special Character Can't Allow Except @ and  .     ",
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
					 });
					return(flag);
				}
			}
			if(!validateTextBoxwithspace(sch_name,true))
			{
				formObj.findField("sch_name").focus();
				return false;
			}
			else if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false" && !validateSingleByte(sch_name))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: schedule_DBLerror_msg,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if(mail_freq.toLowerCase()=="none")
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: errorMsg2,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false") && !checkmultiplemailid(mail_id,false))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: _checkmail,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="true") && !checkmultiplemailid(mail_id,false))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: _checkmail,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
			else if((isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false") && !validateSingleByte(mail_id))
			{
				Ext.Msg.show({
					title:saveSchedule,
					 msg: mailID_DBLerror_msg,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				 });
				return false;
			}
		}
	},
	loadData : function(jsonData)
	{
		submitScheduleURL = jsonData.pageParams.submitURL;

		Ext.getCmp("mail_onlbl").setText(jsonData.screenLabels['reporter.common.Mail On']);
		Ext.getCmp('receive_type').getStore().loadRawData(jsonData.scheduleMailreceiveTypeJson);
		Ext.getCmp('receive_type').setValue(jsonData.pageParams.scheduleMailReceive);

		var createSchedule = false;
		if(jsonData.pageParams.scheduleName == null || jsonData.pageParams.scheduleName.length==0)
		{
			createSchedule = true;
		}

		Ext.getCmp('sch_name').setValue(jsonData.pageParams.scheduleName);
		Ext.getCmp('mail_id').setValue(jsonData.pageParams['mail_id']);

		Ext.getCmp('mail_freq').getStore().loadRawData(jsonData.mailFreqJSON);
		Ext.getCmp('mail_freq').suspendEvents(false);
		Ext.getCmp('mail_freq').setValue(jsonData.pageParams.selectedMailFreq_value);
		Ext.getCmp('mail_freq').resumeEvents();

		if(jsonData.pageParams.selectedMailFreq_value === 'Weekly'){
			Ext.getCmp('mail_onn').hide();
			Ext.getCmp('days_of_week').hide();
			Ext.getCmp('mail_on').show();
		}

		Ext.getCmp("mail_on").getStore().loadRawData(jsonData.mailOnJSON);
		Ext.getCmp("mail_on").suspendEvents(false);
		Ext.getCmp("mail_on").setValue(jsonData.pageParams.selectedMailOn_value);
		Ext.getCmp("mail_on").resumeEvents();

		if(jsonData.pageParams.selectedMailFreq_value === 'Days_of_the_week'){
			Ext.getCmp('mail_onn').hide();
			Ext.getCmp('days_of').show();
			Ext.getCmp('mail_on').hide();
		}

		Ext.getCmp("days_of_week").getStore().loadRawData(jsonData.mailOnJSON);
		Ext.getCmp("days_of_week").suspendEvents(false);
		Ext.getCmp("days_of_week").setValue(jsonData.pageParams.Selected_days);
		Ext.getCmp("days_of_week").resumeEvents();

		if(jsonData.pageParams.selectedMailFreq_value === 'Monthly'){
			Ext.getCmp('mail_on').hide();
			Ext.getCmp('days_of').hide();
			Ext.getCmp('mail_onn').show();
		}
		var valfield=jsonData.pageParams.selectedMailOn_value;
		Ext.getCmp("mail_onn").getStore().loadRawData(jsonData.mailOnJSON1);
		Ext.getCmp("mail_onn").suspendEvents(false);
		if(isNaN(valfield))
		{
			Ext.getCmp("mail_onn").setValue((jsonData.mailOnJSON1[0].valueField));
		}
		else
		{
			Ext.getCmp("mail_onn").setValue(jsonData.pageParams.selectedMailOn_value);
		}
		Ext.getCmp("mail_onn").resumeEvents();

		Ext.getCmp('schedule_held_on').getStore().loadRawData(jsonData.scheduleTypeJson);
		Ext.getCmp('schedule_held_on').suspendEvents(false);
		Ext.getCmp('schedule_held_on').setValue(jsonData.pageParams.selectedScheduleType);
		Ext.getCmp('schedule_held_on').resumeEvents();

		if(jsonData.pageParams.selectedScheduleType === 'AnyTime')
		{
			Ext.getCmp('timeAt').show();
		}

		Ext.getCmp('timeAt').setValue(jsonData.pageParams.selectedScheduleHr + ':' + jsonData.pageParams.selectedScheduleMin);

		if(createSchedule)
		{
			Ext.getCmp('saveschedule').getHeader().hide();
		}
		else if(jsonData.pageParams.backButtonNeeded=="true")
		{
			Ext.getCmp('saveschedule').getHeader().show();
			Ext.getCmp("bckButton").show();
		}
		if(jsonData.pageParams.ShowScheduleFormat==true)
		{
			Ext.getCmp("schedule_format").show();
			Ext.getCmp("scheduleMailFormat").getStore().loadRawData(jsonData.scheduleMailFormatJson);
			Ext.getCmp("scheduleMailFormat").setFieldLabel(jsonData.screenLabels['reporter.common.Schedule Format']);
			Ext.getCmp("scheduleMailFormat").setValue(jsonData.pageParams.scheduleMailFormat);
		}
		if(jsonData.hasOwnProperty('hiddenParams'))
		{
			var me = Ext.getCmp('saveschedule');
			var frmObj = me.getForm();
			var hiddenFields = jsonData.hiddenParams;
			for (var hiddenField in hiddenFields) {
				if (!frmObj.findField("'" + hiddenField + "'")) {
					me.add({
						xtype : 'hidden',
						id  : hiddenField,
						name : hiddenField,
						value : hiddenFields[hiddenField]
					});
				}
				else
				{
					frmObj.findField("'" + hiddenField + "'").setValue(hiddenFields[hiddenField]);
				}
			}
		}
		if(createSchedule)
		{
			Ext.getCmp('gridDisplay').hide();
		}
		else
		{
			var errMsg=jsonData.screenLabels.errorMsg;
			if(!Ext.isEmpty(errMsg) && errMsg !='undefined')
			{
				Ext.MessageBox.alert(saveSchedule,errMsg);
			}
			Ext.getCmp('gridDisplay').getStore().loadRawData(jsonData['gridDataArray']);
			Ext.getCmp('gridDisplay').setTitle(jsonData.screenLabels['reporter.common.Details of Your Selection']);
			Ext.getCmp('gridDisplay').show();
		}
	}
});