Ext.define('Segments.controller.ConfigSegmentControl',{
	extend:'Ext.app.Controller',
	views:['ComponentSegment'],
	refs:[
		{selector:'componentsegment', ref:'componentsegment'},
	],
	init:function(){
		//this.buildFieldData()

		this.control({
			'ComponentSegment':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(mode,segmentName){
		Ext.Ajax.request({
			url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segmentName)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(segmentName){
		var me=this;
		var executiveForm = this.getComponentsegment().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (segmentName == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'segmentNameCombo', publicJSON['ExistingSegmentNames'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'segmentNameCombo', publicJSON['ExistingSegmentNames'],segmentName);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		Ext.getCmp(fieldName).getStore().clearFilter(true);
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(mode,segmentName,zoneName)
	{
		var me=this;
		var executiveForm = this.getComponentsegment().getForm();
		var newsegment='';
		var myzonename=zoneName;
		if(zoneName==null || zoneName=='null' || zoneName=='')
		{
			myzonename='all';
		}
		if(mode=='modify')
		{
			Ext.getCmp('segmentNameCombo').show(true);
			newsegment=false;
			this.initializeFields(segmentName);
		}
		else if(mode=="add")
		{
			Ext.getCmp('segmentName').show(true);
			newsegment=true;
		}

		var val = Ext.getCmp('association').getValue();
		var thisSegment='';
		var showIndOnlyParam = '';
		if(mode=='add')
		{
			thisSegment='aa';
			if(val == true)
				showIndOnlyParam = 'false'
			else
				showIndOnlyParam = 'true';
		}
		else
		{
			thisSegment = segmentName;
			showIndOnlyParam = 'false';
		}

		//var zone = Ext.getCmp('assocZoneCombo').getValue();
		Ext.Ajax.request({
			url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&zone='+encodeURIComponent(myzonename)+'&segment='+encodeURIComponent(thisSegment)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,//+'&showIndOnlyParam='+showIndOnlyParam,//+'&newsegment='+newsegment,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				Ext.getCmp('imagecombo').getStore().suspendEvents(true);
				Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass('serviceOthersSmall');
				Ext.getCmp('imagecombo').getStore().resumeEvents();
				Ext.getCmp('imagecombo').setValue("serviceOthersSmall");

				if(mode=='modify')
				{
					Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
					$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
				}
				Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
				Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
				Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
				Ext.getCmp('compTypeCombo').getStore().resumeEvents();
				Ext.getCmp('compTypeCombo').setValue('-1');
				Ext.getCmp('componentsList').getStore().suspendEvents(true);
				Ext.getCmp('componentsList').getStore().clearFilter(true);
				Ext.getCmp('componentsList').getStore().loadRawData(publicJSON['ComponentList']);
				Ext.getCmp('componentsList').getStore().resumeEvents();
				Ext.getCmp('componentsList').setValue('-1');
//				if(myzonename != null && myzonename == '-1')
//				{
//					myzonename = 'all';
//				}
//				Ext.getCmp('assocZoneCombo').setValue(myzonename);
//				Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
				var zoneAssociation = publicJSON['AssociatedToZone'];
				if(zoneAssociation=='true')
				{
		//			Ext.getCmp('assocZoneCombo').setDisabled(false);
					Ext.getCmp('componentLbl').show(true);
					Ext.getCmp('assocZoneCombo').enable();
					Ext.getCmp('assocZoneCombo').getStore().suspendEvents(true);
					Ext.getCmp('assocZoneCombo').getStore().loadRawData(publicJSON['AssociatedZones']);
					Ext.getCmp('assocZoneCombo').getStore().resumeEvents();
					Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
				}
				else
				{
					Ext.getCmp('assocZoneCombo').disable();
					Ext.getCmp('componentLbl').hide();
				}
				var showIndOnly = publicJSON['showIndCheck'];
				if(!showIndOnly && mode=='modify')
				{
					Ext.getCmp('association').setValue(true);
				}
				var topologyUrl = publicJSON['topologyUrl'];
				if(mode=='modify')
				{
					//Ext.getCmp('assocZoneCombo').setValue(myzonename);
//					Ext.getCmp('assocZoneCombo').setDisabled(true);
					Ext.getCmp('topologyPanel').setVisible(true);
					Ext.getCmp('topologyFrame').setVisible(true);
					Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:948px;border:0px" height="536" scrolling="no"></iframe>');

//					var isZone = publicJSON['isZone'];
//					if(isZone=='true')
//					{
//						table = '<table width="100%" cellspacing="0" cellpadding="0" border="0" style="font-size:12px">';
//						table += '<tr><td align="left"><table border="0" cellspacing="0" cellspacing="0" style="font-size:12px"><tr>';
//						var serviceArr = publicJSON['AssociatedServiceList'];
//						if(serviceArr!=null && serviceArr!=undefined && serviceArr.length>0)
//						{
//							table += '<td width="120" class="padding4"><i>Service(s) mapping</i></td><td width="10" class="padding4">:</td>';
//							table += '<td class="padding4">';
//							var fieldValue='';
//							for(var s=0;s<serviceArr.length;s++)
//							{
//								var serviceName = serviceArr[s];
//								var serviceUrl = publicJSON['AssociatedServiceUrl'][serviceName];
//								table += '<a style="text-decoration:none;" href='+serviceUrl+'>'+serviceName+'</a>';
//								if(s!=(serviceArr.length-1))
//								{
//									table +=", ";
//								}
//							}
//							table += '</td>';
//						}
//						var AssociatedZoneForEdit = publicJSON['AssociatedZoneForEdit'];
//						var configZoneLink = publicJSON['configZoneLink'];
//						var dissociateZonelink = publicJSON['dissociateZonelink'];
//
//						table += '</tr>';
//						table += '<tr><td width="120"  class="padding4" align="left" nowrap><i>Zone mapping</i></td><td width="10"  class="padding4">:</td>';
//						table += '<td align="left"  class="padding4"><a style="text-decoration:none;" href='+configZoneLink+'>'+AssociatedZoneForEdit+'</a>';
//						if(publicJSON['disassString']!=null && publicJSON['disassString']!=undefined)
//						{
//							table += ' (<a style="text-decoration:none;" href=# onclick="javascript:disassociateZone();">Disassociate)';
//						}
//						table +='</td></tr></table></td></tr>';
//						table += '</table>';
//
//						Ext.getCmp('associationPanel').show();
//						Ext.getCmp('associationDiv').show();
//						Ext.getCmp('associationDiv').update(
//						{
//							html:table
//						});
//					}
//					else
//					{
//						Ext.getCmp('associationPanel').hide();
//						Ext.getCmp('associationDiv').hide();
//					}
				}
				else
				{
					//Ext.getCmp('assocZoneCombo').setValue(myzonename);
//					Ext.getCmp('assocZoneCombo').setDisabled(false);
					Ext.getCmp('topologyPanel').setVisible(false);
					Ext.getCmp('topologyFrame').setVisible(false);
				}

				/*Ext.getCmp('itemselectHosts').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.service.FromFieldTitle']);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').setValue(publicJSON['existingServicesArr']);
				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);*/

			}
		});
		Ext.getCmp('segmentName').focus();
	}
});



