var proceed = true;
var check = "";
Ext.define('Segments.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ComponentSegments','ComponentSegment','maximizeWindow','RenameSegment','GroupDetails','RenameGroup','ManagedComponents'],
	requires : ['Segments.view.RenameSegment'],
	refs:[
		{selector:'componentsegments', ref:'componentsegments'},
		{selector:'componentsegment', ref:'componentsegment'},
		{selector:'renamesegment', ref:'renamesegment'},
		{selector:'maximizewindow', ref:'maximizewindow'},
		{selector:'groupdetails', ref:'groupdetails'},
		{selector:'renamegroup', ref:'renamegroup'},
		{selector:'managedcomponents', ref:'managedcomponents'},
	],
	init:function(){
		appCnt = this;
		this.buildFieldData()

		this.control({
			'componentsegments':
			{
				'afterrender': this.afterMainRender
			},
			'componentsegments [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'componentsegments trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'componentsegments button[id="addSegment"]': {
				'click': this.addSegment
			},
			'componentsegments button[id="autoTopPreview"]': {
				'click': this.autoTopologyPreview
			},
			'componentsegment textfield[id="segmentName"]':
			{
				'blur': this.validateName
			},
			'componentsegment combo[id="imagecombo"]':
			{
				'select': this.validation
			},
			'componentsegment combo[id="segmentNameCombo"]':
			{
				'select': this.comboLoad
			},
			'componentsegment multiselectSi[id="assocZoneCombo"]':
			{
				'change': this.zoneComboLoad
			},
			'componentsegment checkbox[id="association"]':
			{
				'change': this.checkBoxLoad
			},
			'componentsegment checkbox[id="discComp"]':
			{
				'change': this.showNewDiscoveredComp
			},
			'componentsegment combo[id="compTypeCombo"]':
			{
				'select': this.compTypeLoad
			},
			'componentsegment combo[id="componentsList"]':
			{
				'select': this.multiselectLoad
			},
			'componentsegment button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'componentsegment button[id="deleteBtn"]':
			{
				'click': this.deleteSegment
			},
			'renamesegment button[id="renameBTN"]':
			{
				'click': this.renameSegment
			},
			'componentsegment button[id="iconDefaultTopo"]':
			{
				'click': this.defaultPosition
			},
			'componentsegment button[id="iconAutoTopo"]':
			{
				'click': this.autoPosition
			},
			'componentsegment button[id="iconSave"]':
			{
				'click': this.savePosition
			},
			'componentsegment button[id="iconAutofit"]':
			{
				'click': this.autoFit
			},
			'componentsegment button[id="iconReset"]':
			{
				'click': this.resetPosition
			},
			'componentsegment button[id="iconMaximize"]':
			{
				'click': this.iconMaximize
			},
			'groupdetails button[id="addBtn"]': 
			{
				'click': this.manageGrpComponent
			},
			'groupdetails button[id="removeBtn"]': 
			{
				'click': this.removeGrpComponent
			},
			'renamegroup button[id="renameGrpbtn"]':
			{
				'click': this.renameBtnClick
			},
			'maximizewindow button[id="iconSavePopup"]':
			{
				'click': this.savePosition
			},
			'maximizewindow button[id="iconAutoFitPopup"]':
			{
				'click': this.autoFit
			},
			'maximizewindow button[id="iconResetPopup"]':
			{
				'click': this.resetPosition
			}
		});
	},
	defaultPosition:function()
	{
		window.frames[0].defaultPosition();
	},
	autoPosition: function()
	{
		window.frames[0].autoPositions();
	},
	resetPosition: function(obj)
	{
		if (!Ext.isEmpty(obj))
		{
			if (obj.getId() == 'iconReset')
			{
				window.frames[0].resetPositions(check);
			}
			else if (obj.getId() == 'iconResetPopup')
			{
				window.frames[1].resetPositions(check);
			}
		}
		else
		{
			window.frames[0].resetPositions(check);
		}
	},
	iconMaximize: function()
	{
		var ht = Ext.getBody().getViewSize().height;
		var wt = Ext.getBody().getViewSize().width;
		var htt = window.frames[0].document.body.scrollHeight;
		var topologyUrl = window.frames[0].openBigDiv(check);
		Ext.widget('maximizewindow').show();
		Ext.getCmp('topologyMaxFrame').update('<iframe id="maxWindow" src="' + topologyUrl+ '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
	},
	
	autoFit: function(obj)
	{
		if (obj.getId() == 'iconAutofit')
		{
			window.frames[0].autoFit();
		}
		else if (obj.getId() == 'iconAutoFitPopup')
		{
			window.frames[1].autoFit();
		}
		
	},
	savePosition: function(obj)
	{
		if (obj.getId() == 'iconSave')
		{
			window.frames[0].savePositions('save',check);
		}
		else if (obj.getId() == 'iconSavePopup')
		{
			window.frames[1].savePositions('save',check);
		}
		
	},
	showNewDiscoveredComp: function()
	{
		check = Ext.getCmp("discComp").checked;
		window.frames[0].newDiscComp(check);
	},
	expandAllRows:function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(!expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	collapseAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	backbutton: function()
	{
		if(returnToMain=='true')
		{
			if (!Ext.isEmpty(mainUrl))
			{
				if (mainUrl.indexOf('.jsp?') != -1)
				{
					mainUrl += '&fromWizard='+fromWizard
				}
				else
				{
					mainUrl += '?fromWizard='+fromWizard
				}
			}

			window.location.href=mainUrl;
			return;
		}
		else if (returnTo == 'userpage')
		{
			window.location.href = backHref + "&username="+username + "&selectedTab=3"+'&fromWizard='+fromWizard;
			return;
		}
		else if (returnTo == 'comp_mng_umng')
		{
			window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (returnTo == 'agg_mng_umng')
		{
			window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (returnTo == 'discovery_mng_umng')
		{
			window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11"+'&fromWizard='+fromWizard;
			return;
		}
		else if (returnTo == 'comp_add_modify')
		{
			window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (returnTo == 'comp_add_mod_new')
		{
			window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
			return;
		}

		if (pageFrom == "topology")
		{
			window.location.href="EgAutoTopology.jsp";
		}
		else
		{
			window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
		}
		
	},
	
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var isDisabled = hideIcon.get('isDisabled');
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		if (isDisabled == 'true')
		{
			Ext.get(icons[0]).removeCls('x-hidden');
			Ext.get(icons[1]).removeCls('x-hidden');
		}
		else
		{
			Ext.get(icon).removeCls('x-hidden');
		}
	});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},

	handleEditIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Edit';
		var rec = Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var Segmentname = rec.get('Segmentname');
//		var zoneName = rec.get('Zonename');
		var zoneName = 'all';
		var configGroupController = this.getController('Segments.controller.ConfigSegmentControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("modify",Segmentname);
		Ext.getCmp('viewport').add({xtype: 'componentsegment'});
		var modifyUrl = rec.get('ModifyUrl');
		configGroupController.afterMainRender("modify",Segmentname,zoneName);
		this.discCompIconHide();
	},
	
	handleRenameIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Rename';
		var rec = grid.getStore().getAt(rowIndex);
		var Segmentname = rec.get('Segmentname');
		this.showEditWindow(Segmentname);
	},

	discCompIconHide : function()
	{
		var segName = Ext.getCmp('segmentNameCombo').getValue();
		var urlString ='Segments/data/EgAdminTopologyJson.jsp?&fromAction=newCompHideIcon'+'&segName='+segName+"&mode=modify";
		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			success: function(response)
			{				
				if (response.status == 200 && !Ext.isEmpty( response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var isIconhide = publicJSON['IsNewCompIconHide'];
					if(isIconhide)
					{
						Ext.getCmp("discComp").hide();
					}
					else
					{
						Ext.getCmp("discComp").show();
					}
				}
			}
		});
	},
	changeImage: function(image)
	{
		var mode = publicJSON['mode'];
		if(mode=='modify')
		{
			Ext.MessageBox.confirm(mainPageTitle, alertMsg36, function(buttonText) {
				if (buttonText == "yes") 
				{
					var segName = Ext.getCmp('segmentNameCombo').getValue();
					var zone = '';
					if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
						zone = Ext.getCmp('assocZoneCombo').getValue();
					var newsegment='false';
					var jsonUrl = 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&imageName='+image+'&validate=true&callFrom=fromItemSelector';
					Ext.Ajax.request({
						url: jsonUrl,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								Ext.Msg.show({
												title : mainPageTitle,
												msg : alertMsg37,
												icon : 'iconInformation',
												buttons : Ext.Msg.OK
											});
							}
						}
					})
				}
				else
				{
					var segName = Ext.getCmp('segmentNameCombo').getValue();
					var zone = '';
					if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
						zone = Ext.getCmp('assocZoneCombo').getValue();
					var url = 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&zone='+encodeURIComponent(zone)+'&returnToMain=false&mainUrl=false';
					Ext.Ajax.request({
						url: url,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
								Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
								$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
							}
						}
					})
				}
			});
		}
	},
	showEditWindow: function(Segmentname){
		Ext.widget('renamesegment').show();
		Ext.getCmp('currentname').setValue(Segmentname);

		Ext.Ajax.request({
			url: 'Segments/data/renamehelpJson.jsp',
			method: 'POST'
		});

	},
	
	renameSegment: function()
	{
		var rename='Segment';
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		var doubleByteName=true;
		
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.show({
				title : 'Rename Segment',
				msg : publicJSON['screenLabels']['admin.common.field value cannot be blank']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.show({
				title : 'Rename Segment',
				msg : publicJSON['screenLabels']['sameName']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.show({
						title : 'Rename Segment',
						msg : publicJSON['screenLabels']['admin.common.DBL not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.show({
					title : 'Rename Segment',
					msg :publicJSON['screenLabels']['admin.common.space not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.show({
					title : 'Rename Segment',
					msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
		}
		var renameUrl = "Segments/data/renameJson.jsp?old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name)+"&rename="+rename;
		Ext.Ajax.request({
			url: renameUrl,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
					}
					else
					{
						Ext.Msg.alert(renameJSON.rename,renameJSON.message);
					}
				}
			}
		});
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		var DispValues = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
		var segmentname = DispValues.get('Segmentname');
		Ext.Msg.show({
			title : mainPageTitle,
			msg : publicJSON['screenLabels']['deleteiconMsg1']+' "'+segmentname+'" '+publicJSON['screenLabels']['deleteiconMsg2'],
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var resultUrl = "Segments/data/EgdelsegmentpJson.jsp?segment="+encodeURIComponent(segmentname)+"&destiny=segments&reqfrom=navlink";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var myjsonText = response.responseText;
								var myjsonObj = Ext.decode( myjsonText );
								var isDeleted = myjsonObj['deleteSegment'];	
								if(isDeleted=='true')
								{
									window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
								}
								else
								{
									Ext.Msg.show({
										title : mainPageTitle,
										msg : myjsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']+'.',
										icon: 'iconExclamation',
										buttons : Ext.Msg.OK
									});
								}
							}
						}
					});
				}
			}
		});
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.show({
				title : mainPageTitle,
				msg : publicJSON['screenLabels']['no segment selected']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Segmentname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.show({
			title : mainPageTitle,
			msg : publicJSON['screenLabels']['deleteforSelectedMessage'],
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var resultUrl = "Segments/data/EgdelsegmentpJson.jsp?segment="+encodeURIComponent(selectedGroups)+"&destiny=segments&reqfrom=navlink";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var myjsonText = response.responseText;
								var myjsonObj = Ext.decode( myjsonText );
								var isDeleted = myjsonObj['deleteSegment'];	
								if(isDeleted=='true')
								{
									window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
								}
								else
								{
									Ext.Msg.alert(mainPageTitle,myjsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']+'.');
								}
							}
						}
					});
				}
			}
		});
	},

	
	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'Segments/data/EgDispSegmentsJson.jsp?reqfrom=navlink&fromWizard='+fromWizard,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	loadTopologyFrame : function(Segmentname,zoneName)
	{
		btnText = 'Edit';
		var configGroupController = this.getController('Segments.controller.ConfigSegmentControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("modify",Segmentname);
		Ext.getCmp('viewport').add({xtype: 'componentsegment'});
		//var modifyUrl = rec.get('ModifyUrl');
		configGroupController.afterMainRender("modify",Segmentname,zoneName);
	},
	afterMainRender : function()
	{
		if (pageFrom == "topology")
		{
			this.loadTopologyFrame(segmentName,zoneName);
		}
		else
		{
			if((returnTo!=null && returnTo!='null' && returnTo=='segments') || returnToMain=='true' || returnTo == 'userpage' || returnTo == 'comp_mng_umng' || returnTo == 'agg_mng_umng' || returnTo == 'discovery_mng_umng' || returnTo == 'comp_add_modify' || returnTo == 'comp_add_mod_new')
			{
				var configGroupController = this.getController('Segments.controller.ConfigSegmentControl');
				Ext.getCmp('viewport').removeAll();
				configGroupController.buildFieldData("modify",segmentName);
				Ext.getCmp('viewport').add({xtype: 'componentsegment'});
				configGroupController.afterMainRender("modify",segmentName,zoneName);
				return;
			}
			
			var resultsData = publicJSON['gridValues'];
//			if (resultsData == null || resultsData.length == 0)
//			{
//				Ext.getCmp('gridDisplay').hide();
//				Ext.getCmp('NoExtPresent').show();
//			}
//			else
//			{
				Ext.getCmp('gridDisplay').show();
				//Ext.getCmp('NoExtPresent').hide();
				Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
				Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
				Ext.getCmp('gridDisplay').getStore().resumeEvents();
			//}
			if(publicJSON['disableAddSeg'] === "true")
			{
				Ext.getCmp('NoExtPresent').show();
				Ext.getCmp('gridDisplay').hide();
			}
			else
			{
				Ext.getCmp('NoExtPresent').hide();
				Ext.getCmp('gridDisplay').show();
			}
			var noExtFound = publicJSON['NoExtFound'];
			if (noExtFound == "true")
			{
				Ext.getCmp('gridSearch').disable();
			}
			else
			{
				Ext.getCmp('gridSearch').enable();
			}
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'Segments/data/EgDispSegmentsJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch)+'&fromWizard='+fromWizard,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				//Ext.getCmp('NoExtPresent').hide();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridValues']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+srchVal+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		});
	},
	addSegment : function()
	{	
		var isValidName = publicJSON['screenLabels']['isValid'];
		if(isValidName=="false")
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.ErroInAddingSegment']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			var configGroupController = this.getController('Segments.controller.ConfigSegmentControl');
			Ext.getCmp('viewport').removeAll();
			configGroupController.buildFieldData("add","aa");
			Ext.getCmp('viewport').add({xtype: 'componentsegment'});
			configGroupController.afterMainRender("add","aa","all");
		}
	},

	autoTopologyPreview: function()
	{
		window.location.href="EgDispAutoTopology.jsp?fromWizard="+fromWizard;
	},
	validateName: function()
	{
		Ext.EventManager.on("backbutton","mousedown",function(c,d,e)
		{
			proceed = false;
		},this);
		if (proceed)
		{
			var segName = Ext.getCmp('segmentName').getValue();
			//this.validation();
			if(segName != null && segName.trim().length > 0)
			{
				if(this.specialCharacterCheck(segName))
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('segmentName').focus();
						}
					});
					return false;
				}
				Ext.Ajax.request({
					url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+publicJSON['mode']+'&segment='+encodeURIComponent(segName)+'&validate=firsttime'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonObj = Ext.decode( jsonText );
							var isValidName = jsonObj['screenLabels']['isValid'];
							if(isValidName=="false")
							{
								Ext.getCmp('compTypeCombo').disable();
								Ext.getCmp('assocZoneCombo').disable();
								Ext.getCmp('segmentName').focus();
								Ext.Msg.show({
									title : pageTitle,
									msg : jsonObj['screenLabels']['admin.common.ErroInAddingSegment']+'.',
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
								return false;
							}
							else
							{
								Ext.getCmp('assocZoneCombo').enable();
								Ext.getCmp('compTypeCombo').enable();
							}
						}
					}
				});
			}
		}
		else
		{
			this.backbutton();
		}
	},
	comboLoad: function()
	{
		var segmentCombo = Ext.getCmp('segmentNameCombo').getValue();
		Ext.getCmp('compTypeCombo').setValue('-1');
		Ext.getCmp("discComp").setValue(false);
		this.discCompIconHide();
		Ext.Ajax.request({
			url: 'Segments/data/EgAdminTopologyJson.jsp?segment='+encodeURIComponent(segmentCombo)+"&mode="+'modify'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
				
				var showIndOnly = publicJSON['showIndCheck'];
				if(!showIndOnly)
				{
					Ext.getCmp('association').setValue(true);
				}
				else
				{
					Ext.getCmp('association').setValue(false);
				}

				var showIndOnlyParam = Ext.getCmp('association').getValue();
				Ext.Ajax.request({
					url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+publicJSON['mode']+'&segment='+encodeURIComponent(segmentCombo)+'&newsegment=false'+'&zone='+encodeURIComponent(publicJSON['selectedZone'])+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl+'&showIndOnlyParam='+!showIndOnlyParam,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
						}

						var zoneAssociation = publicJSON['AssociatedToZone'];
						if(zoneAssociation=='true')
						{
							Ext.getCmp('componentLbl').show(true);
							Ext.getCmp('assocZoneCombo').enable();
							Ext.getCmp('assocZoneCombo').getStore().suspendEvents(true);
							Ext.getCmp('assocZoneCombo').getStore().loadRawData(publicJSON['AssociatedZones']);
							Ext.getCmp('assocZoneCombo').getStore().resumeEvents();
							Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
						}
						else
						{
							Ext.getCmp('assocZoneCombo').disable();
							Ext.getCmp('componentLbl').hide();
						}

						Ext.getCmp('segmentNameCombo').getStore().loadRawData(publicJSON['ExistingSegmentNames']);
						var topologyUrl = publicJSON['topologyUrl'];
						Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
						Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
						Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
						Ext.getCmp('compTypeCombo').getStore().resumeEvents();
						Ext.getCmp('compTypeCombo').setValue('-1');

						Ext.getCmp('componentsList').getStore().suspendEvents(true);
						Ext.getCmp('componentsList').getStore().clearFilter(true);
						Ext.getCmp('componentsList').getStore().loadRawData(publicJSON['ComponentList']);
						Ext.getCmp('componentsList').getStore().resumeEvents();
						//var listLabel = "Start Component";
						//if(publicJSON['screenLabels']['ListBoxLabel']!=undefined)
							//listLabel = "Start Component ["+publicJSON['screenLabels']['ListBoxLabel']+"]";
						//	listLabel = publicJSON['screenLabels']['ListBoxLabel']+" components";
						Ext.getCmp('componentsList').setFieldLabel(startComp);
						Ext.getCmp('componentsList').setValue('-1');
						Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
						Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
						
						if(!Ext.getCmp('topologyFrame').isVisible() && !Ext.getCmp('topologyPanel').isVisible())
						{
							Ext.getCmp('topologyPanel').setVisible(true);
							Ext.getCmp('topologyFrame').setVisible(true);
						}
						Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:948px;border:0px;" height="536" scrolling="no"></iframe>');
//						var isZone = publicJSON['isZone'];
//						if(isZone=='true')
//						{
//							table = '<table width="100%" cellspacing="0" cellpadding="0" border="0" style="font-size:12px">';
//							table += '<tr><td align="left"><table border="0" cellspacing="4" cellspacing="0" style="font-size:12px"><tr>';
//							var serviceArr = publicJSON['AssociatedServiceList'];
//							if(serviceArr!=null && serviceArr!=undefined && serviceArr.length>0)
//							{
//								table += '<td width="120"><i>Service(s) mapping</i></td><td width="10">:</td>';
//								table += '<td>';
//								var fieldValue='';
//								for(var s=0;s<serviceArr.length;s++)
//								{
//									var serviceName = serviceArr[s];
//									var serviceUrl = publicJSON['AssociatedServiceUrl'][serviceName];
//									table += '<a style="text-decoration:none;" href='+serviceUrl+'>'+serviceName+'</a>';
//									if(s!=(serviceArr.length-1))
//									{
//										table +=", ";
//									}
//								}
//								table += '</td>';
//							}
//							var AssociatedZoneForEdit = publicJSON['AssociatedZoneForEdit'];
//							var configZoneLink = publicJSON['configZoneLink'];
//							var dissociateZonelink = publicJSON['dissociateZonelink'];
//							
//							table += '</tr>';
//							table += '<tr><td width="120" align="left" nowrap><i>Zone mapping</i></td><td width="10">:</td>';
//							table += '<td align="left"><a style="text-decoration:none;" href='+configZoneLink+'>'+AssociatedZoneForEdit+'</a>';
//							if(publicJSON['disassString']!=null && publicJSON['disassString']!=undefined)
//							{
//								table += ' (<a style="text-decoration:none;" href=# onclick="javascript:disassociateZone();">Disassociate)';
//							}
//							table +='</td></tr></table></td></tr>';
//							table += '</table>';	

//							Ext.getCmp('associationPanel').show();
//							Ext.getCmp('associationDiv').show();
//							Ext.getCmp('associationDiv').update(
//							{
//								html:table
//							});
//						}
//						else
//						{
//							Ext.getCmp('associationPanel').hide();
//							Ext.getCmp('associationDiv').hide();
//						}
						Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
						$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
					}
				});
			}
		});
		//this.zoneComboLoad();
	},
	multiselectLoad: function(combo)
	{
		var mode = publicJSON['mode'];
		var compname = Ext.getCmp('componentsList').getValue();
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zone = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zone = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var componentType = Ext.getCmp('compTypeCombo').getValue();
		var flag = this.validation();

		if(flag)
		{
			Ext.Ajax.request({
				url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					var isValidName = publicJSON['screenLabels']['isValid']; 
					if(isValidName=="false")
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.ErroInAddingSegment']);
						Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
						return false;
					}
					else
					{
						if(combo==undefined || combo=='undefined')// For checkbox
						{
							if(componentType!='-1')
							{
								Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
								Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
								Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
								Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
							}
						}
						else
						{
							Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
							Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
							Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
							Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
						}
					}
					if (publicJSON.isSearchNeededForFromField == true)
					{
						
						Ext.getCmp("searchFieldContainer").show()
						if (publicJSON.isSearchNeededForFromField == true)
						{
							Ext.getCmp('unAssociateCmpSeacrchBox').setDisabled(false);
						}
						else
						{
							Ext.getCmp('unAssociateCmpSeacrchBox').setDisabled(true);
						} 
						
					}
					else
					{
						Ext.getCmp("searchFieldContainer").hide();
					}

					if (publicJSON.isSearchNeededForToField == true)
					{
						Ext.getCmp("searchFieldContainer").show()
						if (publicJSON.isSearchNeededForToField == true)
						{
							Ext.getCmp('associateCmpSeacrchBox').setDisabled(false);
						}
						else
						{
							Ext.getCmp('associateCmpSeacrchBox').setDisabled(true);
						} 
						
					}
					else
					{
						Ext.getCmp("searchFieldContainer").hide();
					}
				}
			});
		}
		else
		{
			Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
			//Ext.getCmp('association').setValue(showIndOnlyParam);
		}
	},
	checkBoxLoad: function()
	{
		var mode = publicJSON['mode'];
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zone = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zone = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('componentsList').getValue();
		
		var flag = this.validation();
		if(flag)
		{
			Ext.Ajax.request({
				url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						var isValidName = publicJSON['screenLabels']['isValid']; 
						if(isValidName=="false")
						{
							Ext.Msg.show({
								title : pageTitle,
								msg : publicJSON['screenLabels']['admin.common.ErroInAddingSegment']+'.',
								icon : 'iconExclamation',
								buttons : Ext.Msg.YESNO
							});
							Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
							//Ext.getCmp('association').setValue(false);
							return false;
						}
						else
						{
							Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
							Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
							Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
							Ext.getCmp('compTypeCombo').getStore().resumeEvents();
							Ext.getCmp('compTypeCombo').setValue(compType);
							Ext.getCmp('componentsList').getStore().loadRawData(publicJSON['ComponentList']);
							//Ext.getCmp('componentsList').setValue(compName);

							if(compType!='-1')
							{
								Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
								Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
								Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
								Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
							}
						}
					}
				}
			});
		}
		else
		{
			Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
			//Ext.getCmp('association').setValue(false);
		}
		//this.multiselectLoad();
		this.compTypeLoad();
	},
	compTypeLoad: function()
	{
		var mode = publicJSON['mode'];
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zone = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zone = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var componentType = Ext.getCmp('compTypeCombo').getValue();
		var flag = this.validation();

		if(flag)
		{
			Ext.Ajax.request({
				url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					var isValidName = publicJSON['screenLabels']['isValid']; 
					if(isValidName=="false")
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : publicJSON['screenLabels']['admin.common.ErroInAddingSegment']+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK
						});
						Ext.getCmp('compTypeCombo').setValue('-1');
						return false;
					}
					else
					{	
						Ext.getCmp('componentsList').getStore().suspendEvents(true);
						Ext.getCmp('componentsList').getStore().clearFilter(true);
						Ext.getCmp('componentsList').getStore().removeAll();
						Ext.getCmp('componentsList').getStore().loadRawData(publicJSON['ComponentList']);
						Ext.getCmp('componentsList').getStore().resumeEvents();
						//var listLabel = "Start Component";
						//if(publicJSON['screenLabels']['ListBoxLabel']!=undefined)
							//listLabel = "Start Component ["+publicJSON['screenLabels']['ListBoxLabel']+"]";
						//	listLabel = publicJSON['screenLabels']['ListBoxLabel']+" components";
						Ext.getCmp('componentsList').setFieldLabel(startComp);
						Ext.getCmp('componentsList').setValue('-1');
						Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
						Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
						//Ext.getCmp('ListBoxLabel').setText(publicJSON['screenLabels']['ListBoxLabel']);
						//Ext.getCmp('compTypeCombo').setValue('-1');
					}
				}
			});
		}
		else
		{
			Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
			Ext.getCmp('compTypeCombo').setValue('-1');
			
			//Ext.getCmp('association').setValue(showIndOnlyParam);
		}
	},
	zoneComboLoad: function(combo)
	{
		var mode = publicJSON['mode'];
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			if (!Ext.isEmpty(Ext.getCmp('segmentName').getValue()))
			{
				segName = Ext.getCmp('segmentName').getValue();
			}
			else
			{
				segName = "aa";
			}
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zone = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zone = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('componentsList').getValue();
		
		Ext.Ajax.request({
			url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var isValidName = publicJSON['screenLabels']['isValid']; 
				if(isValidName=="false")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.ErroInAddingSegment']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
					Ext.getCmp('assocZoneCombo').setValue(Ext.getCmp('assocZoneCombo').getStore().getAt(0));
//						Ext.getCmp('association').setValue(false);
					return false;
				}
				else
				{
					Ext.getCmp('compTypeCombo').getStore().suspendEvents(true);
					Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
					Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJSON['ComponentTypeList']);
					Ext.getCmp('compTypeCombo').getStore().resumeEvents();
					Ext.getCmp('compTypeCombo').setValue('-1');
					Ext.getCmp('componentsList').getStore().suspendEvents(true);
					Ext.getCmp('componentsList').getStore().clearFilter(true);
					Ext.getCmp('componentsList').getStore().loadRawData(publicJSON['ComponentList']);
					Ext.getCmp('componentsList').getStore().resumeEvents();
					Ext.getCmp('componentsList').setValue('-1');
					Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
					Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
				}
			}
		});
		return true;
	},
	deleteSegment: function()
	{
		var mode = publicJSON['mode'];
		var compName = Ext.getCmp('componentsList').getValue();
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zoneName = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zoneName = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		Ext.Ajax.request({
			url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zoneName)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(compType)+'&compname='+encodeURIComponent(compName)+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var siteAssociated = publicJSON['site_associated'];
					var zoneAssociated = publicJSON['zone_associated'];

					if(siteAssociated=='false' && zoneAssociated=='false')
					{
						Ext.Msg.confirm('Segment', publicJSON['screenLabels']['admin.common.Delete Segment'], function(buttonText) {
							if (buttonText == "yes") 
							{
							    Ext.Ajax.request({
									url: 'Segments/data/EgdelsegmentpJson.jsp?qctr='+publicJSON['qctr']+'&segment='+encodeURIComponent(segName)+'&destiny=segments'+'&comptype='+encodeURIComponent(compType)+ "&compname=" +encodeURIComponent(compName)+"&zone="+encodeURIComponent(zoneName)+"&zoneAssociated="+zoneAssociated+"&reqfrom=navlink",
									method: 'POST',
									async: false,
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											var jsonObj = Ext.decode( jsonText );
											var deleteSegment = jsonObj['deleteSegment'];
											if(deleteSegment=='true')
											{
												if(returnToMain=='true')
												{
													if (!Ext.isEmpty(mainUrl))
													{
														if (mainUrl.indexOf('.jsp?') != -1)
														{
															mainUrl += '&fromWizard='+fromWizard
														}
														else
														{
															mainUrl += '?fromWizard='+fromWizard
														}
													}

													window.location.href=mainUrl;
													return;
												}
												else if (returnTo == 'userpage')
												{
													window.location.href = backHref + "&username="+username + "&selectedTab=3"+"&fromWizard="+fromWizard;
													return;
												}
												else if (returnTo == 'comp_mng_umng')
												{
													window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
													return;
												}
												else if (returnTo == 'agg_mng_umng')
												{
													window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
													return;
												}
												else if (returnTo == 'discovery_mng_umng')
												{
													window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11"+"&fromWizard="+fromWizard;
													return;
												}
												else if (returnTo == 'comp_add_modify')
												{
													window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
													return;
												}
												else if (returnTo == 'comp_add_mod_new')
												{
													window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
													return;
												}
												if (pageFrom == "topology")
												{
													window.location.href="EgAutoTopology.jsp";
												}
												else
												{
													window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
												}
											}
											else
											{
												Ext.Msg.show({
													title : pageTitle,
													msg : jsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']+'.',
													icon : 'iconExclamation',
													buttons : Ext.Msg.OK
												});
												return false;
											}
										}
									}
								});
							}
						});
					}
					else
					{
						Ext.Ajax.request({
							url: 'Segments/data/EgdelsegmentpJson.jsp?qctr='+publicJSON['qctr']+'&segment='+encodeURIComponent(segName)+'&destiny=topology'+'&comptype='+encodeURIComponent(compType)+ "&compname=" +encodeURIComponent(compName)+"&zone="+encodeURIComponent(publicJSON['HiddenValues']['zone'])+"&zoneAssociated="+zoneAssociated+"&reqfrom=navlink",
							method: 'POST',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonText = response.responseText;
									var jsonObj = Ext.decode( jsonText );
									var deleteSegment = jsonObj['deleteSegment'];
									if(deleteSegment=='false')
									{
										Ext.Msg.show({
											title : pageTitle,
											msg : jsonObj['screenLabels']['admin.error.ErrorInDeletingSegment']+'.',
											icon : 'iconExclamation',
											buttons : Ext.Msg.OK
										});
										return false;
									}
									else if(deleteSegment=='true')
									{
										if(returnToMain=='true')
										{
											if (!Ext.isEmpty(mainUrl))
											{
												if (mainUrl.indexOf('.jsp?') != -1)
												{
													mainUrl += '&fromWizard='+fromWizard
												}
												else
												{
													mainUrl += '?fromWizard='+fromWizard
												}
											}

											window.location.href=mainUrl;
											return;
										}
										else if (returnTo == 'userpage')
										{
											window.location.href = backHref + "&username="+username + "&selectedTab=3"+"&fromWizard="+fromWizard;
											return;
										}
										else if (returnTo == 'comp_mng_umng')
										{
											window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
											return;
										}
										else if (returnTo == 'agg_mng_umng')
										{
											window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
											return;
										}
										else if (returnTo == 'discovery_mng_umng')
										{
											window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11"+"&fromWizard="+fromWizard;
											return;
										}
										else if (returnTo == 'comp_add_modify')
										{
											window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
											return;
										}
										else if (returnTo == 'comp_add_mod_new')
										{
											window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
											return;
										}
										if (pageFrom == "topology")
										{
											window.location.href="EgAutoTopology.jsp";
										}
										else
										{
											window.location.href="EgComponentSegments.jsp?fromWizard="+fromWizard;
										}
									}
								}
							}
						});
					}
				}
			}
		});
	},
	manageGrpComponent:function()
	{
		var frames;
		try{
			frames = window.frames;
		}catch(e){
			frames = document.frames;
		}
		var maxWin = Ext.getCmp('topologyMaxFrame');
		var thissegment = "";
		var compname = "";
		var compStatus = "";
		if(maxWin == undefined)
		{
			thissegment = frames[0].document.getElementById("segment").value;
			compname = frames[0].document.getElementById("h_cmpName").value;
			compStatus = frames[0].document.getElementById("h_status").value;
		}
		else
		{
			thissegment = frames[1].document.getElementById("segment").value;
			compname = frames[1].document.getElementById("h_cmpName").value;
			compStatus = frames[1].document.getElementById("h_status").value;
		}
		var htt = window.frames[0].document.body.scrollHeight;
		var selectedList=[];
		var store = Ext.getCmp('GrpDetailsDisplay').getStore();
		var selModel = Ext.getCmp('GrpDetailsDisplay').getSelectionModel();
		var grpName = compname;
		if(compname.endsWith(":NULL"))
		{
			grpName = grpName.replace(":NULL","");
		}
		store.each(function(rec)
		{
			var CompVal = rec.get('CompVal');//Citrix_XcXenApp_server:192.168.11.9:1494
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(CompVal);
			}
		});
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment)+"&grpname="+compname+"&compStatus="+encodeURIComponent(compStatus)+"&groupNameVal="+encodeURIComponent(compname);
		var url2 = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(grpName)+"&segment="+encodeURIComponent(thissegment)+"&compName="+encodeURIComponent(compname);
		var selectedComps = selectedList.toString();
		if(selectedComps!=null && selectedComps.length>0)
		{
			var action = "manageGrpComp";
			url = url+"&test=" + selectedComps+"&action="+action+"&fromPage=configSegment";
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						var isManagedComp = myJsonObj['isManagedComp'];
						var msgString = myJsonObj['msgString'];
						var isNewCompExceedLicense = myJsonObj['isNewCompExceedLicense'];
						if(isManagedComp == true)
						{
							Ext.MessageBox.show({
								title : grpDetails,
								msg : managedCompAlert,
								buttons: Ext.Msg.OK,
								icon : 'iconInformation',
								width : 300,
								fn : function(btn)
								{
									var win = Ext.WindowManager.getActive();
									if (win) {
										win.close();
									}
									this.showGroupDetails(grpName);
								}
							});
						}
						else if (isNewCompExceedLicense == true)
						{
							var win = Ext.WindowManager.getActive();
							if (win) {
								win.close();
							}
							Ext.widget('managedcomponents').show();
							if(myJsonObj['callBasicErrorPage']==true)
							{
								var errCompMsg = myJsonObj['ErrorMessage'];
								var licenseMsg = myJsonObj['licenseMsg'];
								var messageText1 = errCompMsg +""+licenseMsg
								var htmlText= '<div class="error_panel" style="text-align:center"><div style="margin:0px auto;align:center;width:50px" class="iconExclamation"></div>'+messageText1+'</div>'
								Ext.getCmp('errorMsg').setText(htmlText,false);
								Ext.getCmp('ErrorMessage').show();
							}
						}
						else
						{
							Ext.MessageBox.show({
								title : grpDetails,
								msg : "Group has been added successfully.",
								buttons: Ext.Msg.OK,
								icon : 'iconInformation',
								width : 300,
								fn : function(btn)
								{
									var win = Ext.WindowManager.getActive();
									if (win) {
										win.close();
									}
									var newEltcheck = Ext.getCmp("discComp").checked;
									if(maxWin == undefined)
									{
										window.frames[0].newDiscComp(newEltcheck);
									}
									else
									{
										var topourl = window.frames[0].openBigDiv(newEltcheck);
										Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
										window.frames[0].newDiscComp(newEltcheck);
									}
								}
							});
						}
						Ext.widget('groupdetails').hide();
					}
				}
			});
		}
		else
		{
			Ext.Msg.alert(grpDetails,selectComptoManage);
		}
	},
	removeGrpComponent:function()
	{
		var frames;
		try
		{
			frames = window.frames;
		}
		catch(e)
		{
			frames = document.frames;
		}
		var thissegment = "";
		var grpStatus = "";
		var compname = "";
		var maxWin = Ext.getCmp('topologyMaxFrame');
		if(maxWin == undefined)
		{
			thissegment = frames[0].document.getElementById("segment").value;
			compname = frames[0].document.getElementById("h_cmpName").value;
			grpStatus = frames[0].document.getElementById("h_status").value;
		}
		else
		{
			thissegment = frames[1].document.getElementById("segment").value;
			compname = frames[1].document.getElementById("h_cmpName").value;
			grpStatus = frames[1].document.getElementById("h_status").value;
		}
		var htt = window.frames[0].document.body.scrollHeight;
		var grpName = compname;
		if(compname.endsWith(":NULL"))
		{
			grpName = grpName.replace(":NULL","");
		}
		var selectedList=[];
		var store = Ext.getCmp('GrpDetailsDisplay').getStore();
		var selModel = Ext.getCmp('GrpDetailsDisplay').getSelectionModel();
		var gridCount = Ext.getCmp('GrpDetailsDisplay').getStore().getCount();
		var selCount = Ext.getCmp('GrpDetailsDisplay').getSelectionModel().getSelection().length;
		store.each(function(rec)
		{
			var CompVal = rec.get('CompVal');
			var isSelected = selModel.isSelected(rec);
			if(isSelected)
			{
				selectedList.push(CompVal);
			}
		});
		var action = "removeGrpComp";
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?segment="+encodeURIComponent(thissegment)+"&action="+encodeURIComponent(action)+"&compname="+encodeURIComponent(compname)+"&compStatus="+grpStatus;
		var url2 = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(grpName)+"&segment="+encodeURIComponent(thissegment)+"&compName="+encodeURIComponent(compname)+"&compStatus="+grpStatus;
		var myUrl = "/final/admin/AutoTopology/data/EgAutoTopologyMainPageD3JS.jsp?index=main&segment="+encodeURI(thissegment);
		var selectedComps = selectedList.toString();
		if((gridCount-selCount) == 0)
		{
			Ext.Msg.alert(pageTitle,associateAtleastOneComp);
		}
		else if(selectedComps!=null && selectedComps.length>0)
		{
			url = url+"&removeComp="+selectedComps;
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if (response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var myjsonText = response.responseText;
						var myJsonObj = Ext.decode( myjsonText );
						Ext.MessageBox.show({
						title : grpDetails,
						msg : dissociateMsg,
						buttons: Ext.Msg.OK,
						icon : 'iconInformation',
						width : 300,
						fn : function(btn)
						{
								Ext.Ajax.request({
								url: url2,
								method: 'POST',
								async: false,
								success: function( response )
								{
									if (response.status == 200 && !Ext.isEmpty(response.responseText))
									{
										var myjson = response.responseText;
										var myJsonObj = Ext.decode( myjson );
										var disp = myJsonObj['GroupDetails'];
										var GrpDetailsDisplayobj = Ext.getCmp('GrpDetailsDisplay').getStore();
										GrpDetailsDisplayobj.suspendEvents(true);
										GrpDetailsDisplayobj.clearFilter(true);
										GrpDetailsDisplayobj.loadRawData(myJsonObj['GroupDetails']);
										GrpDetailsDisplayobj.resumeEvents();
										var win = Ext.WindowManager.getActive();
										if (win) {
											win.close();
										}
										var newEltcheck = Ext.getCmp("discComp").checked;
										if(maxWin == undefined)
										{
											window.frames[0].newDiscComp(newEltcheck);
										}
										else
										{
											var topourl = window.frames[0].openBigDiv(newEltcheck);
											Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
											window.frames[0].newDiscComp(newEltcheck);
										}
									}
								}
							});
						}
					});
					}
					Ext.widget('groupdetails').hide();
				}
			});
		}
		else if(selectedComps.length <= 0)
		{
			Ext.Msg.alert(grpDetails,selectComptoDissociate);
		}
	},
	renameBtnClick:function()
	{
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		var action = "renameGrpName";
		var maxWin = Ext.getCmp('topologyMaxFrame');
		var htt = window.frames[0].document.body.scrollHeight;
		var grpStatus = "";
		if(maxWin == undefined)
		{
			grpStatus = frames[0].document.getElementById("h_status").value;
		}
		else
		{
			grpStatus = frames[1].document.getElementById("h_status").value;
		}
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : lblNoBlank,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : lblSameName,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.show({
						title : renameTitle,
						msg : lblNoDBL,
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : lblNoSpace,
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
					});
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : lblNoSplChar,
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
		}
		var url = "AutoTopology/data/EgAutoManageComponentsJson.jsp?action="+encodeURIComponent(action)+"&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name)+"&compStatus="+grpStatus;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						Ext.MessageBox.show({
							title : renameGrpTitle,
							msg : renameJSON.message,
							buttons: Ext.Msg.OK,
							icon : 'iconInformation',
							width : 300,
							fn : function(btn)
							{
								var win = Ext.WindowManager.getActive();
								if (win) {
									win.close();
								}
								var newEltcheck = Ext.getCmp("discComp").checked;
								if(maxWin == undefined)
								{
									window.frames[0].newDiscComp(newEltcheck);
								}
								else
								{
									var topourl = window.frames[0].openBigDiv(newEltcheck);
									Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
									window.frames[0].newDiscComp(newEltcheck);
								}
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title : renameGrpTitle,
							msg : renameJSON.message,
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
					}
				}
				Ext.widget('renamegroup').hide();
			}
		});
	},
	
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	validation: function()
	{
		var mode = publicJSON['mode'];
		var segName='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
		}
		
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];

		if (segName==null || segName.length == 0)
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please enter a name']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function()
				{
					Ext.getCmp('segmentName').focus();
				}
			});
			return false;
		}
		else
		{
			for(count = 0; count < segName.length; count++)
			{
				var check_char = s_spl.indexOf(segName.charAt(count));
				if(!isDouble)
				{
					var charValue=segName.charCodeAt(count);
					if(charValue>255)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : publicJSON['screenLabels']['admin.common.DBL not allowed']+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function()
							{
								Ext.getCmp('segmentName').focus();
							}
						});
						return false;
					}
				}
				if(segName.charAt(count) == ' ')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.space not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('segmentName').focus();
						}
					});
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('segmentName').focus();
						}
					});
					return false;
				}
				else if(segName == "independent_servers")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.Cannot add segment by name']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('segmentName').focus();
						}
					});
					return false;
				}
				//else
				//{
					//Ext.Ajax.request({
						//url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+publicJSON['mode']+'&segment='+encodeURIComponent(segName)+'&validate=firsttime'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
						//method: 'POST',
						//async: false,
						//success: function( response )
						//{
							//if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							//{
								//var jsonText = response.responseText;
								//var jsonObj = Ext.decode( jsonText );
								//var isValidName = jsonObj['screenLabels']['isValid'];
								//if(isValidName=="false")
								//{
									//Ext.getCmp('compTypeCombo').disable();
									////Ext.getCmp('assocZoneCombo').disable();

									//Ext.Msg.show({
										//title : pageTitle,
										//msg : jsonObj['screenLabels']['admin.common.ErroInAddingSegment']+'.',
										//icon : 'iconExclamation',
										//buttons : Ext.Msg.OK,
										//fn : function()
										//{
											//Ext.getCmp('segmentName').focus();
										//}
									//});
									//return false;
								//}
								//else
								//{
									//Ext.getCmp('assocZoneCombo').enable();
									//Ext.getCmp('compTypeCombo').enable();
								//}
							//}
						//}
					//});
				//}
			}

		}
		return true;
	},
	searchComponent : function(strComponent,searchVal,searchType,id1)
	{
		var me = this , id = id1;
		var mode = publicJSON['mode'];
		var compname = Ext.getCmp('componentsList').getValue();
		var segName = '';
		var newsegment='';
		if(mode=='add')
		{
			segName = Ext.getCmp('segmentName').getValue();
			newsegment='true';
		}
		else if(mode=='modify')
		{
			segName = Ext.getCmp('segmentNameCombo').getValue();
			newsegment='false';
		}
		var zone = '';
		if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
			zone = Ext.getCmp('assocZoneCombo').getValue();
		var showIndOnlyParam = Ext.getCmp('association').getValue();
		var componentType = Ext.getCmp('compTypeCombo').getValue();
		
		if (searchVal == "" || searchVal.length == 0)
		{
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','block');
		}
		
		var urlString = '';
		if (searchVal.length == 0 || searchVal == "Search" )
		{
			
			urlString ='Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl;
			
		}
		else
		{
			urlString ='Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+'&validate=true'+'&strSearch='+searchVal+'&searchType='+searchType+'&strComponent='+strComponent+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl;
			
		}
		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			success: function(response)
			{				
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					
				}
				Ext.getCmp('itemselectHostsForSegment').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHostsForSegment').getStore().resumeEvents();
				Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
			}
		});
	}
});

function OpenManageDiv(servertype,comptitle)
{
	var segName = Ext.getCmp('segmentNameCombo').getValue();
	var compstatus = "NEW";
	var newServerUrl = "EgNewServer.jsp?server=new&from=inventory&compstatus="+ encodeURIComponent(compstatus)+"&serverType="+encodeURIComponent(servertype)+"&allExternalTests=true&from=addnew&isAggregateLink=false&frmTopology=yes&frmPage=configSeg&comptitle="+encodeURIComponent(comptitle)+"&topoSegName="+encodeURIComponent(segName);
	var w ;
	if(!w)
	{
		w = new Ext.Window({
			layout: 'fit',
			title: 'Manage components',
			id:'manageWindow',
			listeners :
			{
				'beforedestroy':function()
				{
					assignNewComp(servertype,comptitle);
				}
			},
			closeAction: 'destroy',
			width:850,
			padding:'5 10 10 10',
			height:550,
			border: false, 
			html: '<iframe id="newCompId" width="100%" src='+newServerUrl+' style="height:100%;border:0" scrolling="no"></iframe>',
		});
	}
	w.show();
}

function assignNewComp(servertype,comptitle)
{
	var maxWin = Ext.getCmp('topologyMaxFrame');
	var htt = window.frames[0].document.body.scrollHeight;
	var segName = Ext.getCmp('segmentNameCombo').getValue();
	var urlString ='Segments/data/EgAdminTopologyJson.jsp?&comptype='+encodeURIComponent(servertype)+'&compname='+encodeURIComponent(comptitle)+'&fromAction=newComp'+'&segName='+segName;
	Ext.Ajax.request({
		url : urlString,
		method: 'POST',
		success: function(response)
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
				var flag = publicJSON['isNewCompManged'];
				if(flag)
				{
					var newEltcheck = Ext.getCmp("discComp").checked;
					if(maxWin == undefined)
					{
						window.frames[0].newDiscComp(newEltcheck);
					}
					else
					{
						var topourl = window.frames[0].openBigDiv(newEltcheck);
						Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
						window.frames[0].newDiscComp(newEltcheck);
					}
				}
			}
		}
	});
}

function disassociateZone()
{
	var dissociateZonelink = publicJSON['dissociateZonelink'];
	if(dissociateZonelink!=null)
	{
		Ext.Msg.confirm('Segment',alertMsg38,function(buttonText) {
		if (buttonText == "yes"){
				Ext.Ajax.request({
					url: dissociateZonelink,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonObj = Ext.decode( jsonText );
							if(jsonObj['removeElements']=='false')
							{
								Ext.Msg.show({
									title : pageTitle,
									msg : jsonObj['screenLabels']['admin.common.ErrorInRemovingComponents']+'.',
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
							}
							else
							{
								window.location.href=jsonObj['ForwardPageTo']+"?fromWizard="+fromWizard;
							}
						}
					}
				});
			}
		});
	}
}

function closedManagedWindow()
{
	var windowObj = Ext.getCmp('manageWindow');
	if (windowObj != null && windowObj != undefined)
	{
		windowObj.destroy();
	}
}

function showGroupDetails(thisGrpName)
{
	var maxWin = Ext.getCmp('topologyMaxFrame');
	var compName = "";
	var compStatus = "";
	if(maxWin == undefined)
	{
		compName = frames[0].document.getElementById("h_cmpName").value;
		compStatus = frames[0].document.getElementById("h_status").value;
	}
	else 
	{
		compName = frames[1].document.getElementById("h_cmpName").value;
		compStatus = frames[1].document.getElementById("h_status").value;
	}
	var unmanagedCmpList = [];
	var newCmpList = [];
	Ext.widget('groupdetails').show();
	Ext.getCmp('GrpDetailsHeader').update('<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+grpDetailsMsg+" "+'<b>'+thisGrpName+'</b>'+" "+'</center>');
	var url = 'AutoTopology/data/EgTopologyGroupDetailsJson.jsp?index=details&grptitle='+encodeURIComponent(thisGrpName)+"&compName="+encodeURIComponent(compName)+"&compStatus="+compStatus;
	Ext.Ajax.request({
		url: url,
		method: 'POST',
		async: false,
		success: function(response)
		{
			if ( response.status == 200 && !Ext.isEmpty(response.responseText))
			{
				var jsonText = response.responseText;
				var mypublicJSON = Ext.decode( jsonText );
				var manageBtnDis = mypublicJSON['manageBtnDis'];
				var GrpDetailsDisplayobj = Ext.getCmp('GrpDetailsDisplay').getStore();
				GrpDetailsDisplayobj.suspendEvents(true);
				GrpDetailsDisplayobj.loadRawData(mypublicJSON['GroupDetails']);
				GrpDetailsDisplayobj.resumeEvents();
				GrpDetailsDisplayobj.each(function(rec)
				{
					var compstatus = rec.get('compstatus');//* or # 192.168.11.9:1494
					if(compstatus.startsWith("#"))
					{
						unmanagedCmpList.push(compstatus);
					}
					else if(compstatus.startsWith("*"))
					{
						newCmpList.push(compstatus);
					}
				});
				if(unmanagedCmpList.length<=0)
				{
					Ext.getCmp('unmanagemsg').hide();
				}
				if(newCmpList.length<=0)
				{
					Ext.getCmp('discmsg').hide();
				}
				if(newCmpList.length<=0 && unmanagedCmpList.length<=0)
				{
					Ext.getCmp('msgbox').hide();
				}
				if(manageBtnDis == 'disablebtn')
				{
					Ext.getCmp('addBtn').setDisabled(true);
				}
			}
		}
	});
}

function showRename()
{
	var frames;
	try{
		frames = window.frames;
	}catch(e){
		frames = document.frames;
	}
	var maxWin = Ext.getCmp('topologyMaxFrame');
	var grpName = "";
	if(maxWin == undefined)
	{
		grpName = frames[0].document.getElementById("h_cmpName").value;
	}
	else
	{
		grpName = frames[1].document.getElementById("h_cmpName").value;
	}
	Ext.widget('renamegroup').show();
	if(grpName.endsWith(":NULL"))
	{
		grpName = grpName.replace(":NULL","");
	}
	Ext.getCmp('currentname').setValue(grpName);
}

function manageGrpFunction(url)
{
	var maxWin = Ext.getCmp('topologyMaxFrame');
	var htt = window.frames[0].document.body.scrollHeight;
	var enableDrag = 'false';
	url = url+"&enableDrag="+encodeURIComponent(enableDrag)+'&index=main&com.eg.CSRF_NONCE='+csrfToken;
	Ext.Ajax.request({
		url: url,
		method: 'POST',
		async: false,
		success: function( response )
		{
			if (response.status == 200 && !Ext.isEmpty(response.responseText))
			{
				var jsonText = response.responseText;
				var mypublicJSON = Ext.decode( jsonText);
				var status = mypublicJSON['status'];
				var grpStatus = mypublicJSON['grpStatus'];
				var grpStatusMsg = mypublicJSON['grpStatusMsg'];
				if(grpStatusMsg.startsWith("Result:"))
				{
					grpStatusMsg = grpStatusMsg.replace("Result:","");
				}
				var filePath = mypublicJSON['filePath'];
				if(status != 'eG_CLI_0030')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: compErrMsg1 + "<br>" + compErrMsg2 + "<br>" + filePath,
						buttons: Ext.Msg.OK,
						icon: "iconExclamation"
					});
				}
				else if(grpStatus !="eG_CLI_Res_0323")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : grpStatusMsg,
						buttons : Ext.Msg.OK,
						icon : 'iconExclamation'
					});
				}
				else if(grpStatus =="eG_CLI_Res_0323")
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : grpStatusMsg,
						buttons : Ext.Msg.OK,
						icon : 'iconInformation'
					});
				}
				var newEltcheck = Ext.getCmp("discComp").checked;
				if(maxWin == undefined)
				{
					window.frames[0].newDiscComp(newEltcheck);
				}
				else
				{
					var topourl = window.frames[0].openBigDiv(newEltcheck);
					Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
					window.frames[0].newDiscComp(newEltcheck);
				}
			}
		}
	});
}

function openAssign(servertype,comptitle)
{
	var segName = Ext.getCmp('segmentNameCombo').getValue();
	var maxWin = Ext.getCmp('topologyMaxFrame');
	var htt = window.frames[0].document.body.scrollHeight;
	var urlString ='Segments/data/EgAdminTopologyJson.jsp?&comptype='+encodeURIComponent(servertype)+'&compname='+encodeURIComponent(comptitle)+'&fromAction=newComp'+'&segName='+segName;
	Ext.Ajax.request({
		url : urlString,
		method: 'POST',
		success: function(response)
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
				var flag = publicJSON['isNewCompManged'];
				if(flag)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : assignComp,
						buttons : Ext.Msg.OK,
						icon : 'iconInformation',
						fn : function(btn)
						{
							var newEltcheck = Ext.getCmp("discComp").checked;
							if(maxWin == undefined)
							{
								window.frames[0].newDiscComp(newEltcheck);
							}
							else
							{
								var topourl = window.frames[0].openBigDiv(newEltcheck);
								Ext.getCmp('topologyMaxFrame').update('<iframe src="' + topourl + '" style="width:1308px;border:0px" height='+htt+' scrolling="no"></iframe>');
								window.frames[0].newDiscComp(newEltcheck);
							}
						}
					});
				}
			}
		}
	});
}
