Ext.define('AlwaysVisibleTip', {
    extend: 'Ext.slider.Tip',
	id:'mytip',
	cls: 'yellowTip',
    init: function(slider) {
        var me = this;

        me.callParent(arguments);
        slider.removeListener('dragend', me.hide);
        slider.on({
            scope: me,
            change: me.onSlide,
            afterrender: {
                fn: function() {
                    me.onSlide(slider, null, slider.thumbs[0]);
					tip_hide_task.delay(2000);


                },
                delay: 100
            }
        });
    }
});
var tip_hide_task = new Ext.util.DelayedTask(function(){
      Ext.getCmp('mytip').hide();
});
Ext.define('Segments.view.ComponentSegment', {
	extend: 'Ext.form.Panel',
	alias: 'widget.componentsegment',
	id: 'componentsegment',

	ui:'simplePanel simplePanelHeaderBorder',
	//cls:'outerpanel',
	requires:[
		'Ext.ux.OptGroupItemSelectorRv',
		'utilities.ScrollCombo',
		'utilities.innerScrollContainer',
		'Ext.ux.form.MultiSelectSI'
	],
	title:createSegTitle,
	margin:'8 8 0 8',
	//header:{cls:'textUpper'},
	scroll : true,
	autoScroll : true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' '
	},
	/*dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
			xtype: 'component',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp&nbsp'+configPageDesc+'.</center>'

		}

		]
	}],*/
  
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 10 10 10',
			items : [
				{
					xtype: 'fieldcontainer',
					layout: {
						type: 'vbox',
						pack: 'start'
					},
					defaults: {
						margin: '10 10 5 10',
						width: 250,
						labelAlign: 'top',
						labelSeparator: ' '
					},
					width: 270,
					border: 1,
					style: {
						borderColor: 'lightGrey',
						borderStyle: 'solid'
					},
					items: [
						{
							xtype: 'textfield',
							cls:'textbox',
							name: 'segmentName',
							id: 'segmentName',
							fieldLabel: Segmentname,
							//allowBlank: false,
							labelStyle: 'white-space: nowrap;',
							hidden:true,
							maxLength:32,
							enforceMaxLength:true
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: Segmentname,
							id:'segmentNameCombo',
							name:'segmentNameCombo',
							displayField:'displayField',
							valueField:'valueField',
							queryMode: 'local',
							emptyText:'--Select--',
							parent:this,
							hidden:true,
							selectOnFocus:true,
							labelStyle: 'white-space: nowrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
							//,editable:false
						},
						{
							xtype: 'radiogroup',
							fieldLabel: segmentType,
							id: 'segtype',
							columns: 2,
							vertical: false,
							hidden:true,
							items: [
								{ boxLabel: 'Auto', name: 'rb1', inputValue: '1' ,id: 'auto'},
								{ boxLabel: 'Manual', name: 'rb1', inputValue: '2',id: 'manual',checked: true}
							]
						},
						{
							xtype: 'scrollcombo',
							cls:'imagecombo',
							store:new Ext.data.Store({
								fields: ['abbr','name'],
								data: []
							}),
							id:'imagecombo',
							name:'imagecombo',
							displayField:'name',
							valueField:'abbr',
							queryMode: 'local',
							editable: false,
							typeAhead: false,
							editable:false,
							fieldLabel: imagecombo,

							tpl: Ext.create('Ext.XTemplate',
								'<ul>',
								'<tpl for=".">',
								 '<li class="x-boundlist-item"><img  src="/final/images/clear.png" style="vertical-align:middle;display:inline-block;" class={abbr} />{name}</li>',
								'</tpl>',
								'</ul>'
							   ),
							   listeners:{
								select:function(combo, records, eOpts){
								 var record = records[0];
								 var image = record.get('abbr');
								 appCnt.changeImage(image);
								 cls = image;
								 if(image){
								 $('#'+combo.inputEl.id).removeClass().addClass(cls);
									}
								}
							}
						},
						{
							xtype: 'container',
							id: 'componentLbl',
							name: 'componentLbl',
							items: [
								{
									xtype: 'label',
									text: filterBy,
									//cls: 'font_bold11'
								},
								{
									xtype: 'multiselectSi',
									cls:'multiselect',
									margin: '4 0 0 0',
									width: 250,
									height: 110,
									autoScroll: true,
									scroll: false,
									name: 'assocZoneCombo',
									id: 'assocZoneCombo',
									value: 'all',
									store: new Ext.data.Store ({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local'
								}
							]
						},
						{
							xtype: 'checkbox',
							boxLabel: otherSegComps,
							id:'association',
							name:'association',
							checked: false,
							cls: 'checkbt'
						},
						{
							xtype: 'scrollcombo',
							fieldLabel: startCompType,
							//listConfig:{maxHeight:150},
							cls: 'dropdown',
							id:'compTypeCombo',
							name:'compTypeCombo',
							displayField:'displayField',
							valueField:'valueField',
							queryMode: 'local',
							emptyText:'--Select--',
							parent:this,
							selectOnFocus:true,
							labelStyle: 'white-space: nowrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							//editable:false
						},
						{
							xtype: 'scrollcombo',
							fieldLabel: startComp,
							//listConfig:{maxHeight:100},
							cls: 'dropdown',
							id:'componentsList',
							name:'componentsList',
							displayField:'displayField',
							valueField:'valueField',
							queryMode: 'local',
							emptyText:'--Select--',
							parent:this,
							selectOnFocus:true,
							labelStyle: 'white-space: nowrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							margin: '10 10 9 10',
							//editable:false
						}
					]
				},
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					},
					width: 680,
					margin: '0 0 0 5',
					border: 1,
					style: {
						borderColor: 'lightGrey',
						borderStyle: 'solid'
					},
					items : [
						{
							xtype: 'container',
							border: false,
							style: 'border: 1px solid red',
							id : 'searchFieldContainer',
							//hidden:true,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							margin: '10 0 0 10',
							items: [
								{
									xtype: 'container',
									border: false,
									style: 'border: 1px solid yellow',
									flex: 1,
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									items: [
										{
											xtype: 'trigger',
											id : 'unAssociateCmpSeacrchBox',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											cls: 'whitedropdown_search',
											emptyText: 'Search Other Components',
											margin: '0 0 5 0',
											//hidden: true,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}

												// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function() {
												this.reset();
											},
											onTrigger2Click: function() {
												appCnt.searchComponent("unAssociateCmp",this.getValue(),"unAssociateCmpSeacrch","unAssociateCmpSeacrchBox");
											},
											listeners :
											{
												change : function(obj)
												{
													appCnt.searchComponent("unAssociateCmp",obj.getValue(),"unAssociateCmpSeacrch","unAssociateCmpSeacrchBox");
												},
												specialkey: function(field, e){
													// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
													// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
													if (e.getKey() == e.ENTER) {
														appCnt.searchComponent("unAssociateCmp",field.getValue(),"unAssociateCmpSeacrch","unAssociateCmpSeacrchBox");
													}
												}
											}
										}
									]
								},
								{
									xtype: 'tbspacer',
									width: 100
								},
								{
									xtype: 'container',
									border: false,
									style: 'border: 1px solid blue',
									flex: 1,
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									items: [
										{
											xtype: 'trigger',
											//hidden:true,
											id : 'associateCmpSeacrchBox',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											cls: 'whitedropdown_search',
											emptyText: 'Search Associated Components',
											margin: '0 0 5 0',
											//hidden: true,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}

												// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function() {
												this.reset();
											},
											onTrigger2Click: function() {
												appCnt.searchComponent("associateCmp",this.getValue(),"associateCmpSeacrch","associateCmpSeacrchBox");
											},
											listeners :
											{
												change : function(obj)
												{
													appCnt.searchComponent("associateCmp",obj.getValue(),"associateCmpSeacrch","associateCmpSeacrchBox");
												},
												specialkey: function(field, e){
													// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
													// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
													if (e.getKey() == e.ENTER) {
														appCnt.searchComponent("associateCmp",field.getValue(),"associateCmpSeacrch","associateCmpSeacrchBox");
													}
												}
											}
										}
									]
								}
							]
						},
						{
							xtype: 'optgroupitemselector',
							cls:'multiselect',
							id: 'itemselectHostsForSegment',
							name: 'itemselectHostsForSegment',
							//baseCls: 'egmultiselect',
							buttons: ['add','addConnects','remove'],
							buttonsText: {
								add: 'Uses >>',
								addConnects: 'Connects >>',
								remove: '<< Remove'
							},
							createButtons: function(){
								var me = this,
									buttons = [];

								if (!me.hideNavIcons) {
									Ext.Array.forEach(me.buttons, function(name) {
										buttons.push({
											xtype: 'button',
											 // This listeners added for common use of button tool tip with yellow color style -- Start
											listeners:{
												'afterrender':function(){
													Ext.create("Ext.tip.ToolTip",{
														target:this.id,
														anchor:"top",
														cls:"yellowTip",
														trackMouse:true,
														html:me.buttonsText[name]});
												}
											},
											// end here
											//tooltip: me.buttonsText[name],
											handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
											cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
											//iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
											text : me.buttonsText[name],
											navBtn: true,
											scope: me,
											cls : 'button20',
											width : 89,
											margin: '4 0 0 0'
										});
									});
								}
								return buttons;
							},
							setupItems: function() {
								var me = this;

								me.fromField = me.createList(me.fromTitle);
								me.toField = me.createList(me.toTitle);

								return {
									border: false,
									layout: {
										type: 'hbox',
										align: 'stretch'
									},
									items: [
										me.fromField,
										{
											xtype: 'container',
											margins: '0 4',
											width: 89,
											layout: {
												type: 'vbox',
												pack: 'center'
											},
											items: me.createButtons()
										},
										me.toField
									]
								};
							},
							toTitle:toTitle,
							fromTitle:fromTitle,
							height: 408,
							margin: '10 10 10 10',
							displayField: 'displayField',
							valueField: 'valueField',
							groupField : 'groupField',
							store: Ext.create('Ext.data.Store', {
								fields: ['valueField', 'displayField','groupField'],
								data: []
							}),
							queryMode : 'local'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '0',
			id:'frameContainer',
			padding: 5,
			items: [
				{
					xtype:'panel',
					cls:'datapanel',
					border:true,
					title: panelHeader,
					width: 950,
					//height: 920,
					layout:{ type:'vbox',align:'stretch'},
					id:'topologyPanel',
					frame: false,
					parent:this,
					hidden:true,
					margin: 10,
					items: [
					{
						xtype: "component",
						id:'topologyFrame',
						name:'topologyFrame',
						html:''
					}
					],
					tools: [
						{
							xtype: 'container',
							margin: '0 0px 0 0px',
							cls: 'iconBg',
								items: [{
									xtype: 'button',
									iconCls: 'iconAutoLayout',
									itemId: 'iconAutoTopo',
									id: 'iconAutoTopo',
									hidden: isHideAutoLayoutIcon,
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'Auto Layout'
											});
										}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}
							]
						},
						{
							xtype: 'tbseparator',
							hidden:isHideAutoLayoutIcon
						},
						{
							xtype: 'checkbox',
							boxLabel:discCompBtn,
							id:'discComp',
							name:'discComp',
							checked: false,
							cls: 'checkbt',
						},
						{
							xtype: 'tbseparator'
						},
						{
							xtype: 'container',
							margin: '0 0px 0 0px',
							cls: 'iconBg',
							//disabled: true,
								items: [{
									xtype: 'button',
								   iconCls: 'iconAutofit',
									itemId:'iconAutofit',
									id: 'iconAutofit',
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Fit'
											});
										}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}
							]
						},
						{
							xtype: 'tbseparator',
						},
						{
							xtype: 'container',
							margin: '0 0px 0 0px',
							cls: 'iconBg',
							//disabled: true,
								items: [{
									xtype: 'button',
								   iconCls: 'iconSave',
									itemId:'iconSave',
									id: 'iconSave',
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Save position'
											});
										}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}
							]
						},
						{
							xtype: 'tbseparator',
						},
						{
							xtype: 'container',
							margin: '0 0px 0 0px',
							cls: 'iconBg',
							//disabled: true,
								items: [{
								xtype: 'button',
								iconCls: 'iconRefresh',
								itemId:'iconReset',
								id: 'iconReset',
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: 'Reset position'
										});
									}
								},
								style: {
									background: 'none',
									border: '0px'
								}
								}
							]
						},
						{
							xtype: 'tbseparator',
						},
						{
							xtype: 'container',
							margin: '0 0px 0 0px',
							cls: 'iconBg',
							hidden:true,
							//disabled: true,
							items: [
								{
									xtype: 'button',
									iconCls: 'iconMaximize',
									itemId:'iconMaximize',
									id: 'iconMaximize',
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'New Window'
											});
										}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}
							]
						},
						{
							xtype: 'tbseparator',
							hidden:true
						},
						{
							xtype : 'button',
							cls:'button20',
							id : 'deleteBtn',
							text : delSegment
						}
					]
//					,
//					bbar: [
//						{
//							xtype:'panel',
//							title: '<div style="text-align:center;">'+panelDivTitle+'</div>',
//							id:'associationPanel',
//							layout: 'fit',
//							width: 950,
//							height:63,
//							hidden:true,
//							parent:this,
//							border:false,
//							items : [
//								{
//									xtype: 'component',
//									id:'associationDiv',
//									name:'associationDiv',
//									hidden:true,
//									html: '<a href="www.google.com">Google</a>'
//								}
//							]
//						}
//					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'hiddencontainer',
			hidden: true
		},
		{
			xtype: 'container',
			id: 'hiddenprocesscontainer',
			hidden: true
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'backbutton',
			iconCls:'iconBack',
			text : backBtn
		}
	],
	listeners: {
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('createSegTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: configPageDesc+'.',
				cls: "adminInfoTooltip"
			});
		}
	}
});



