Ext.define('Segments.view.GroupDetails', {
	extend: 'Ext.window.Window',
	alias: 'widget.groupdetails',
	id : 'groupdetails',
	requires:['utilities.CustomGrid'],

	ui:'simplePanel simplePanelHeaderBorder',
	title: grpDetailsTitle,
	width: 600,
	padding:'5 10 10 10',
	modal: true,

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: "button",
					cls: "quickMenuWhiteButton",
					id: "addBtn",
					text: "Manage",
					margin: 5,
					width: 90
				},
				{
					xtype: "button",
					cls: "quickMenuWhiteButton",
					id: "removeBtn",
					text: "Dissociate",
					margin: 5,
					width: 90
				}
			]
		}
	],

	items: [
		/*{
			xtype: 'component',
			id:'GrpDetailsHeader',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+'Hosts associated to group</center>',
			cls:'adminHeadInfoText',
			height: 25,
			border:true,
			padding: 3
		},*/
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'GrpDetailsDisplay',
			selModel :new Ext.selection.CheckboxModel(
			{
				checkOnly: true,
				width:50,
				injectCheckbox: 'first',
			}),
			store:new Ext.data.Store(
			{
				fields: ['Hostname','Portno','Componenttype','CompVal','compstatus'],
				 data:[]
			}),
			height: 300,
			autoScroll: true,
			scroll: true,
			margin: 10,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: hostnameText,
						dataIndex: 'Hostname',
						id: 'DispHostname',
						flex:1
					},
					{
						text:portText,
						dataIndex: 'Portno',
						id: 'DispPortno',
						width: 80
					},
					{
						text:compTypeText,
						dataIndex: 'Componenttype',
						id: 'DispComponenttype',
						flex: 1
					}
				]
			},

			dockedItems: [
				{
					dock: 'bottom',
					id:'msgbox',
					layout:{
						type:'vbox',
						pack:'start',
						align: 'left'
					},
					border: false,
					padding : 5,
					items: [
						{
							xtype: "text",
							id: "discmsg",
							text: "* Newly discovered components",
						},
						{
							xtype: "text",
							id: "unmanagemsg", 
							text: "# Unmanaged components",
							margin: "10 0 5 0"
						},
					]
				}
			]
		}
	],
	listeners: {
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('grpDetailsTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: 'Hosts associated to group.',
				cls: "adminInfoTooltip"
			});
		}
	}
});



