var ht = Ext.getBody().getViewSize().height;
var wt = Ext.getBody().getViewSize().width;

Ext.define('Segments.view.maximizeWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.maximizewindow',
	id : 'maximizewindow',
	autoScroll: true,
	title: "Topology",
	width: (wt-16),
	height: ht,
	modal: true,
	margin: '8 0 0 0',
	closeAction: 'destroy',
	listeners: {
		close : function () {
			var topologyUrl = window.frames[1].openBigDiv(check);
			Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:948px;border:0px;" scrolling="no" height="536"></iframe>');
		}
	},
	items: [
		{
			xtype: "component",
			id:'topologyMaxFrame',
			name:'topologyMaxFrame',
			html:''
		}
	],
	tools: [
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconAutoFitPopup',
				itemId:'iconAutoFitPopup',
				id: 'iconAutoFitPopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Fit'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
		},
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconSavePopup',
				itemId:'iconSavePopup',
				id: 'iconSavePopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Save position'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
		},
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconRefreshPopup',
				itemId:'iconResetPopup',
				id: 'iconResetPopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Reset position'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
		}
	]
});



