
Ext.define('ServiceAssignment.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'}
	],
	init:function()
	{
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.loadMain
			},
			'main button[id="csv"]':
			{
				'click':this.saveInCSVFormat
			}
		})
	},
	saveInCSVFormat : function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+trackerLanguage;
	},
	buildMainData : function()
	{
		var defaultUrl = 'ServiceAssignment/data/EgMiscReportsJson.jsp?flag='+s_flag+'&reqfrom=navlink&date='+new Date().getTime();
		Ext.Ajax.request({
			url : defaultUrl,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadMain: function()
	{
		var userdetails = Ext.getCmp('userEntity');
		var NoEntity = publicJSON['NoEntity'];
		var userRawData = publicJSON['Entities'];
		if (userRawData != null && !Ext.isEmpty(userRawData))
		{
			userdetails.getStore().loadRawData(userRawData);
		}
		else
		{
			userdetails.store.loadRawData('');
			if (NoEntity == true)
			{
				userdetails.getView().emptyText="<div style='margin:30% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+pageIntnl2+"</div></td></tr></table></div>";
			}
			else
			{
				userdetails.getView().emptyText="<div style='margin:30% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+pageIntnl3+"</div></td></tr></table></div>";
			}
			userdetails.getView().refresh();
		}
		
		var userNameGrid = Ext.getCmp('userNameGrid');
		var NoUser = publicJSON['NoUser'];
		var usersData = publicJSON['Users'];

		if (usersData != null && !Ext.isEmpty(usersData))
		{
			userNameGrid.getStore().loadRawData(usersData);
		}
		else
		{
			userNameGrid.store.loadRawData('');
			if (NoUser == true)
			{
				userNameGrid.getView().emptyText="<div style='margin:30% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+userIntnl2+"</div></td></tr></table></div>";
			}
			else
			{
				userNameGrid.getView().emptyText="<div style='margin:30% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+userIntnl3+"</div></td></tr></table></div>";
			}
			userNameGrid.getView().refresh();
		}

		if ((userRawData != null && !Ext.isEmpty(userRawData)) || (usersData != null && !Ext.isEmpty(usersData)))
		{
			Ext.getCmp('csv').setDisabled(false);
		}
		else
		{
			Ext.getCmp('csv').setDisabled(true);
		}
	}
});



