Ext.define('ServiceGroups.controller.ConfigServiceGroupControl',{
	extend:'Ext.app.Controller',
	views:['ServiceGroup'],
	refs:[
		{selector:'servicegroup', ref:'servicegroup'},
	],
	init:function(){
		//this.buildFieldData()
		this.control({
			'servicegroup':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(modify,serviceGrpName){
		var site='';
		var service='';
		if(modify=='false')
		{
			site='new';
			service='true';
		}
		else if(modify=='true')
		{
			site=serviceGrpName;
			service='';
		}
		Ext.Ajax.request({
			url: 'ServiceGroups/data/EgConfigServiceGroupJson.jsp?modify='+modify+'&site='+encodeURIComponent(site)+'&service='+encodeURIComponent(service),
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(site){
		var me=this;
		var executiveForm = this.getServicegroup().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (site == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'serviceGrpCombo', publicJSON['ExistingServiceGroupNames'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'serviceGrpCombo', publicJSON['ExistingServiceGroupNames'],site);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(modify,serviceGrpName)
	{
		var me=this;
		var executiveForm = this.getServicegroup().getForm();
		var site='';
		var service='';
		if(modify=='false')
		{
			site='new';
			service='true';
		}
		else if(modify=='true')
		{
			site=serviceGrpName;
			service='';
		}
		var modifyServiceGrpName="";
		if(modify=='true')
		{
			modifyServiceGrpName = site;
			Ext.getCmp('serviceGrpCombo').show(true);
			this.initializeFields(site);
		}
		else if(modify=="false")
		{
			Ext.getCmp('serviceGrpName').show(true);
		}
		Ext.Ajax.request({
			url: 'ServiceGroups/data/EgConfigServiceGroupJson.jsp?modify='+modify+'&site='+encodeURIComponent(site)+'&service='+encodeURIComponent(service),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				Ext.getCmp('itemselectHosts').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.service.FromFieldTitle']);
				Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').getStore().resumeEvents();
				Ext.getCmp('itemselectHosts').setValue(publicJSON['existingServicesArr']);
				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
			}
		});
	}
});



