Ext.define('ServiceGroups.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ServiceGroups','ServiceGroup','RenameServiceGroup'],
	refs:[
		{selector:'servicegroups', ref:'servicegroups'},
		{selector:'servicegroup', ref:'servicegroup'},
		{selector:'renameservicegroup', ref:'renameservicegroup'},
	],
	init:function(){
		appCnt = this;
		this.buildFieldData()

		this.control({
			'servicegroups':
			{
				'afterrender': this.afterMainRender
			},
			'servicegroups [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'servicegroups trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'servicegroups button[id="addServiceGroup"]': {
				'click': this.addServiceGroup
			},
			'servicegroup combo[id="serviceGrpCombo"]':
			{
				'select': this.comboLoad
			},
			'servicegroup button[id="UpdateBTN"]':
			{
				'click': this.updation
			},
			'servicegroup button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'renameservicegroup button[id="renameBTN"]':
			{
				'click': this.renameServiceGroup
			}
		});
	},
	backbutton: function()
	{
		//if(returnToMain=='true')
		//{
			//window.location.href=mainUrl;
			//return;
		//}

		//if (returnToMain == "userpage")
		//{
			//window.location.href = backHref + "&username="+username + "&selectedTab=3";
			//return;
		//}
		//window.location.href="EgComponentServiceGroup.jsp";

		window.location.href = "EgComponentServiceGroup.jsp?fromWizard=" + fromWizard;
		if (comeFrom != null && comeFrom !== undefined && comeFrom != "")
		{
			if (comeFrom == "comp_mng_umng") 
			{
				window.location.href = "EgConfigEnv.jsp?srvtype=" + comptype + "&activeCompTypes=" + activeCompTypes + "&fromWizard=" + fromWizard;
				return;
			}
			else 
			{
				if (comeFrom == "agg_mng_umng")
				{
					window.location.href = "aggConfigEnv.jsp?srvtype=" + comptype + "&activeCompTypes=" + activeCompTypes + "&fromWizard=" + fromWizard;
					return;
				}
				else if (comeFrom == "discovery_mng_umng") 
				{
					window.location.href = "EgDiscoveryPane.jsp?server=" + comptype + "&activeCompTypes=" + activeCompTypes + "&selectedNode=node11";
					return;
				}
				else if (comeFrom == "comp_add_modify")
				{
					window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
					return;
				}
				else if (comeFrom == "comp_add_mod_new")
				{
					window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
					return;
				}
			}
		}
		else
		{
			if (returnToMain == "true") {
            window.location.href = mainUrl;
            return;
			}
			if (returnToMain == "userpage") {
				window.location.href = backHref + "&username=" + username + "&selectedTab=3";
				return;
			}
		}
	},
	
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	handleRenameIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Rename';
		var rec = grid.getStore().getAt(rowIndex);
		var serviceGroupName = rec.get('Servicegroupname');
		this.showEditWindow(serviceGroupName);
	},
	showEditWindow: function(serviceGroupName)
	{
		Ext.widget('renameservicegroup').show();
		Ext.getCmp('currentname').setValue(serviceGroupName);

		Ext.Ajax.request({
			url: 'ServiceGroups/data/renamehelpJson.jsp',
			method: 'POST'
		});

	},
	renameServiceGroup: function()
	{
		
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.field value cannot be blank']);
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['sameName']);
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
				return false;
			}
		}
		
		var renameUrl = "ServiceGroups/data/renameJson.jsp?rename=Service Group&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name);
		Ext.Ajax.request({
			url: renameUrl,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						window.location.href="EgComponentServiceGroup.jsp";
					}
					else
					{
						Ext.Msg.alert(renameJSON.rename,renameJSON.message);
						
					}
				}
				
			}
		});
		
	},
	handleEditIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Edit';
		var rec = Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var groupName = rec.get('Servicegroupname');
		var configGroupController = this.getController('ServiceGroups.controller.ConfigServiceGroupControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("true");
		Ext.getCmp('viewport').add({xtype: 'servicegroup'});
		configGroupController.afterMainRender("true",groupName);
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		var DispValues = grid.getStore().getAt(rowIndex);
		var groupName = DispValues.get('Servicegroupname');
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['deleteiconMsg1']+" '"+groupName+"' "+ publicJSON['screenLabels']['deleteiconMsg2'], function(buttonText) {
			if (buttonText == "yes") 
			{
				var myUrl = "ServiceGroups/data/EgconfigservicegrouppJson.jsp?mode=del&sitename="+encodeURIComponent(groupName)+"&reqfrom=navlink";
				Ext.Ajax.request({
					url: myUrl,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var myObj = Ext.decode( jsonText );
							var updated = myObj['updated'];
							if(updated=='true')
								window.location.href = 'EgComponentServiceGroup.jsp';
						}
					}
				});
			}
		});
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.alert(mainPageTitle,publicJSON['screenLabels']['no group selected']);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Servicegroupname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['deleteforSelectedMessage'], function(buttonText) {
			if (buttonText == "yes") 
			{
				var myUrl = "ServiceGroups/data/EgconfigservicegrouppJson.jsp?sitename="+encodeURIComponent(selectedGroups)+"&mode=del&reqfrom=navlink";
				Ext.Ajax.request({
					url: myUrl,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var myObj = Ext.decode( jsonText );
							var updated = myObj['updated'];
							if(updated=='true')
								window.location.href = 'EgComponentServiceGroup.jsp';
						}
					}
				});
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'ServiceGroups/data/EgDispServiceGroupJson.jsp?reqfrom=navlink',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		if(returnToMain=='true' || returnToMain == 'userpage')
		{
			var configGroupController = this.getController('ServiceGroups.controller.ConfigServiceGroupControl');
			Ext.getCmp('viewport').removeAll();
			configGroupController.buildFieldData("true");
			Ext.getCmp('viewport').add({xtype: 'servicegroup'});
			configGroupController.afterMainRender("true",site);
			return;
		}
		else if (comeFrom == "comp_mng_umng" || comeFrom == "agg_mng_umng" || comeFrom == "discovery_mng_umng" || comeFrom == "comp_add_modify" || comeFrom == "comp_add_mod_new") {
			var configGrpController = this.getController("ServiceGroups.controller.ConfigServiceGroupControl");
			Ext.getCmp("viewport").removeAll();
			configGrpController.buildFieldData("modify", servicegroup);
			Ext.getCmp("viewport").add({
				xtype: "servicegroup"
			});
			configGrpController.afterMainRender("true", servicegroup);
			return;
		}
		var resultsData = publicJSON['gridValues'];
		Ext.getCmp('gridDisplay').show();
		Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
		Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
		Ext.getCmp('gridDisplay').getStore().resumeEvents();

		if(publicJSON['disableAddSerGroup'] === "true")
		{
			Ext.getCmp('NoExtPresent').show();
			Ext.getCmp('gridDisplay').hide();
		}
		else
		{
			Ext.getCmp('NoExtPresent').hide();
			Ext.getCmp('gridDisplay').show();
		}

		var noExtFound = publicJSON['NoExtFound'];
		if (noExtFound == "true")
		{
			Ext.getCmp('gridSearch').disable();
		}
		else
		{
			Ext.getCmp('gridSearch').enable();
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'ServiceGroups/data/EgDispServiceGroupJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridValues']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+nodata+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		});
	},
	addServiceGroup : function()
	{
		var configGroupController = this.getController('ServiceGroups.controller.ConfigServiceGroupControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("false");
		Ext.getCmp('viewport').add({xtype: 'servicegroup'});
		configGroupController.afterMainRender("false","");
	},
	
	comboLoad: function()
	{
		var modify = publicJSON['modify'];
		var service = publicJSON['service'];
		var groupCombo = Ext.getCmp('serviceGrpCombo').getValue();
		Ext.Ajax.request({
			url: 'ServiceGroups/data/EgConfigServiceGroupJson.jsp?site='+encodeURIComponent(groupCombo)+"&modify="+modify+'&service='+encodeURIComponent(service),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				
				Ext.getCmp('itemselectHosts').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.service.FromFieldTitle']);
				Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').getStore().resumeEvents();
				Ext.getCmp('itemselectHosts').setValue(publicJSON['existingServicesArr']);
				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
			}
		});
	},
	updation: function(btn)
	{
		var configGroupController = this.getController('ServiceGroups.controller.ConfigServiceGroupControl');
		var modify = publicJSON['modify'];
		var service = publicJSON['service'];
		var groupname = '';
		if(modify=="false")
			groupname = Ext.getCmp('serviceGrpName').getValue();
		else
			groupname = Ext.getCmp('serviceGrpCombo').getValue();
		
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";

		if(groupname!=null)
		{
			if(groupname.charAt(0) == '.' || groupname.charAt(groupname.length - 1) == '.')
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.starts with dot not allowed']);
				return false;
			}
			for(count = 0; count < groupname.length; count++)
			{
				var check_char = s_spl.indexOf(groupname.charAt(count));
				if(groupname.charAt(count) == ' ')
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
					return false;
				}
				if(groupname.charAt(count) == '.' && groupname.charAt(count + 1) == '.')
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.starts with dot not allowed in consecutive position']);
					return false;
				}
			}
		}
		
		if (groupname==null || groupname.length == 0)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please enter a name']);
		}
		else
		{
			//var updateUrl = publicJSON['updateUrl'];
			var updateUrl = 'ServiceGroups/data/EgconfigservicegrouppJson.jsp';
			var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();

			var Arr = new Array();
			for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<unmanagedHostList.length ;j++ )
				{
					if (allValue == unmanagedHostList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length]=allValue;
				}
			}
			var tempmanagedHostList = Arr;
			var managedHostList = tempmanagedHostList.toString();

			Ext.Ajax.request({
				url: 'ServiceGroups/data/EgConfigServiceGroupJson.jsp?site='+encodeURIComponent(groupname)+"&modify="+modify+"&validate=true"+'&service='+encodeURIComponent(service),
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonObj = Ext.decode( jsonText );
						var isValidName = jsonObj['screenLabels']['isValid']; 
						if(isValidName=="false")
						{
							Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.common.ErroInAddingGroup']);
							return;
						}
						else
						{
							if(managedHostList=="")
							{
								Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please choose a component']);
								return;
							}
							var oldGroupName='';
							var previousValues = '';
							var oldcomps = '';
							if(modify=="true")
							{
								oldGroupName = publicJSON['oldGroupName'];
								previousValues = publicJSON['previousValues'];
								oldcomps = publicJSON['oldcomps'];
							}
							var mode=publicJSON['mode'];
							
							//var resultUrl  = updateUrl+"modify="+modify+"&sitename="+groupname+"&service="+service+"&srvlist="+managedHostList+"&mode="+mode; //+"&oldGroupName="+oldGroupName+"&oldComps="+oldcomps+"&previousValues="+previousValues;
							
							//if(modify=='true')
								//resultUrl = resultUrl+"&oldGroupName="+oldGroupName+"&oldComps="+oldcomps+"&previousValues="+previousValues;
							
							Ext.Ajax.request({
							url: updateUrl,
							method: 'POST',
							params: {
								'modify' : modify,
								'sitename' : groupname,
								'service' : service,
								'srvlist' : managedHostList,
								'mode' : mode,
								'oldGroupName' : oldGroupName,
								'oldComps' : oldcomps,
								'previousValues' : previousValues
							},
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonTxt = response.responseText;
									var jsonObject = Ext.decode( jsonTxt );
									var updated = jsonObject['updated'];
									var updatedUrl = jsonObject['ForwardPage'];
									if(updated=='true')
									{
										if(modify=='false')
											window.location.href = updatedUrl;
										else
										{
											Ext.Msg.show({
												title : pageTitle,
												msg : "Service Group '"+groupname+"' "+jsonObj['screenLabels']['admin.common.updated successfully'],
												buttons : Ext.Msg.OK,
												icon : 'iconInformation'
											});
											configGroupController.buildFieldData("true");
											configGroupController.afterMainRender("true",groupname);
										}
									}
									else if(updated=='false')
									{
										Ext.Msg.alert(pageTitle,jsonObject['screenLabels']['ErrorMessage']);
										return false;
									}
								}
							}});
						}
					}
				}
			});
		}
	}
});



