Ext.define('ServiceGroups.view.ServiceGroups', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.servicegroups',
	id: 'mainServiceGroups',
	cls:'outerpanel',
	title: mainPageTitle,
	header:{cls:'textUpper'},
	margin:'8 8 0 8',

	requires: [
		'Ext.grid.*',
		'utilities.CustomGrid',
		'utilities.ScrollCombo',
		'utilities.innerScrollContainer'
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp&nbsp'+pageDescc+'.</center>'
			}
		]
	}],

	layout : {
		type : 'vbox',
		align : 'stretch'
	},

	items: [
		{
			xtype: 'container',
			id: 'NoExtPresent',
			hidden:true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noSerMsg+'</div></td></tr></table>',
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'gridDisplay',
			flex : 1,
			autoScroll: true,
			store:new Ext.data.Store({
				fields: ['Servicegroupname'],
				data: []
			}),
			selModel: {
				selType: 'checkboxmodel',
				mode: 'MULTI',
				checkOnly: true
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noGroupMsg+'</div></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: Servicegroupname,
						dataIndex: 'Servicegroupname',
						id: 'DispServicegroupname',
						flex:1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var tmpDiv = "";
							tmpDiv = '<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout-fixed" align="center"><tr><td width="1%" align="left"><div class="serviceGroup20_GRAY"></div></td><td style="text-decoration:none;vertical-align:middle" align="left" width="65%" class="font_normal11"><a  href=\'javascript:appCnt.handleEditIconClick("'+Ext.getCmp("gridDisplay")+'","'+row+'","'+col+'")\'>'+record.get('Servicegroupname')+'</a></td></tr></table>';
							return tmpDiv;
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						id: 'EditOver',
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {

							appCnt.handleEditIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						id: 'RenameOver',
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconRename',
						//tooltip: 'Rename',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleRenameIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Rename' data-qclass='yellowTip'";
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						id: 'DeleteOver',
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";

						},
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleDeleteIconClick(grid, rowIndex, colIndex);
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					id: 'gridSearch',
					name: 'gridSearch',
					emptyText: 'Search',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++)
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls:'button20',
							text: addSGrp,
							id: 'addServiceGroup'
						}
					]
				}
			]
		}
	]

});



