Ext.define('Services.controller.ConfigServiceControl',{
	extend:'Ext.app.Controller',
	views:['ComponentService','TopologyItems','Main'],
	//requires : ['Services.view.FormItems'],
	refs:[
		{selector:'componentservice', ref:'componentservice'},
		{selector:'topologyitems', ref:'topologyitems'},
		{selector:'main', ref:'main'}
	],
	init:function(){
		//this.buildFieldData();

		this.control({
			'componentservice':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(url){
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(site){
		var me=this;
		var executiveForm = this.getComponentservice().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (site == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'servicecombo', publicJSON['ExistingServiceNames'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'servicecombo', publicJSON['ExistingServiceNames'],site);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(obj)
	{
		var me=this;
		var executiveForm = this.getComponentservice().getForm();

		var strsite = obj.site;
		var modify = obj.action;

		var servicenameObj = Ext.getCmp('hiddenServName');
		var modeObj = Ext.getCmp('hiddenActionMode');

		if(servicenameObj != undefined)
		{
			strsite = servicenameObj.getValue();
		}
		if(modeObj != undefined)
		{
			modify = modeObj.getValue();
		}

		/*if(comeFrom!=null && comeFrom=='Eglogicaltopologyp')
		{
			var topoController = this.getController('Services.controller.LogicalTopology');
			var qs = "site=" + site + "&segment=" + segment + "&ass_servers=" + ass_servers+'&action=modify'+"&service="+service+"&zone="+zone+'&comefrom=Eglogicaltopologyp';

			Ext.getCmp('viewport').removeAll();
			topoController.buildFieldData(qs);
			Ext.getCmp('viewport').add({xtype: 'topologyitems'});
			topoController.afterMainRender();
			return;
		}*/

		var modifyGroupName="";
		if(modify=='true')
		{
			//modifyGroupName = groupName;
			Ext.getCmp('servicecombo').show(true);
			Ext.getCmp('servicename').hide();
			Ext.getCmp('servicecombo').getStore().loadRawData(publicJSON['ExistingServiceNames']);
			Ext.getCmp('servicecombo').setValue(strsite);
			//this.initializeFields(strsite);
		}
		else if(modify=="false")
		{
			Ext.getCmp('servicename').show(true);
			Ext.getCmp('servicecombo').hide();
		}
		var s_site="";
		if(modify=='true')
			s_site = Ext.getCmp('servicecombo').getValue();
		else if(modify=="false")
			s_site = Ext.getCmp('servicename').getValue();

		var siteOrService = publicJSON['siteOrService'];
		if(siteOrService == 'Site')
		{
			Ext.getCmp('rumAssociatedLabel').show();
		}
		else
		{
			Ext.getCmp('rumAssociatedLabel').hide();
		}
		allow = publicJSON['isSiteAssociated'];

		if(allow == 'true')
		{

			var siteForComp = publicJSON['componentForSelectedSite'];
			var selectedCategory="-1";
			var selectedCType="Real_user_monitor";
			selectedCType = encodeURIComponent(selectedCType);
			selectedCategory = encodeURIComponent(selectedCategory);
			var s_rumComp=siteForComp;
			siteForComp=siteForComp+":NULL";
			Ext.getCmp('rumAssociatedLabel').update('<style="font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:10px">RUM Component "'+s_rumComp+'" is associated to this site.&nbsp;&nbsp;<a href="EgNewServer.jsp?isAggregateLink=false&server='+siteForComp+'&serverType='+selectedCType+'&modifyserver=true&siteSupport=false&treeViewSrc=null&serverGategory='+selectedCategory+'&servicePage=servicePageView" style="text-decoration: underline;">Click here</a>&nbsp;to view/modify.');
		}
		else
		{
			var onGoingSite = publicJSON['onGoingSite'];
			var selectedCategory="-1";
			var selectedCType="Real_user_monitor";
			selectedCType = encodeURIComponent(selectedCType);
			selectedCategory = encodeURIComponent(selectedCategory);
			//Ext.getCmp('rumAssociatedLabel').update('<style="font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:10px">RUM Component not associated.&nbsp;&nbsp;<a href="EgNewServer.jsp?server=new&serverType='+selectedCType+'&from=addnew&isAggregateLink=false&treeViewSrc=null&servicePage=servicePageAddview&serverGategory='+selectedCategory+'&onGoingSite='+onGoingSite+'" style="text-decoration: underline;">Click here</a>&nbsp;to add.');
		}
		var selectedSegment = publicJSON['selectedSegment'];
		var isSiteOrService = publicJSON['isSite'];

		var displayCheckbox = publicJSON['displayCheckBox'];
		var isAggregateSite = publicJSON['isAggregateSite'];
		if(displayCheckbox)
		{
			Ext.getCmp('aggcombo').show(true);
			Ext.getCmp('siteAlias').setDisabled(true);
		}
		else
		{
			Ext.getCmp('siteAlias').setDisabled(false);
			Ext.getCmp('aggcombo').hide();
		}
		if(modify=='true')
		{
			if(isSiteOrService!=null && isSiteOrService=='true')
			{
				Ext.getCmp('siteAlias').setValue(publicJSON['aliasValue']);
				Ext.getCmp('siteAlias').show();
				Ext.getCmp('siteAlias').setDisabled(false);
				Ext.getCmp('sitecombo').setValue('Yes');
				Ext.getCmp('sitecombo').show();
				Ext.getCmp('sitecombo').setDisabled(true);
			}
			else
			{
				Ext.getCmp('sitecombo').setValue('No');
				Ext.getCmp('sitecombo').hide();
				Ext.getCmp('siteAlias').setValue(publicJSON['aliasValue']);
				Ext.getCmp('siteAlias').hide();
			}

			Ext.getCmp('segmentcombo').getStore().removeAll();
			Ext.getCmp('segmentcombo').getStore().suspendEvents(true);
			Ext.getCmp('segmentcombo').getStore().loadRawData(publicJSON['segmentList']);
			Ext.getCmp('segmentcombo').getStore().resumeEvents();
			Ext.getCmp('segmentcombo').setValue(publicJSON['selectedSegment']);

			Ext.getCmp('itemselectHostsForService').getStore().suspendEvents(true);
			Ext.getCmp('itemselectHostsForService').getStore().loadRawData(publicJSON['itemSelectorValue']);
			Ext.getCmp('itemselectHostsForService').getStore().resumeEvents();
			Ext.getCmp('itemselectHostsForService').setValue(publicJSON['existingComponentsArr']);

			Ext.getCmp('aggcombo').hide();
			if(isAggregateSite=='true')
			{
				/* added newly - To show whether the site is an aggregate site or not */
				Ext.getCmp('aggcombo').show();
				Ext.getCmp('aggcombo').setValue('Yes');
				Ext.getCmp('aggcombo').setDisabled(true);
				/* added newly */
				if(publicJSON['displaySiteMap']=='true')
				{
					Ext.getCmp('mappingcombo').show(true);
					Ext.getCmp('mappingcombo').getStore().suspendEvents(true);
					Ext.getCmp('mappingcombo').getStore().loadRawData(publicJSON['aggregateSite']);
					Ext.getCmp('mappingcombo').getStore().resumeEvents();
					Ext.getCmp('mappingcombo').setValue(publicJSON['mappingSiteName']);
				}
			}

			if(isAggregateSite=='true' && isSiteOrService=='true')
			{
				//Ext.getCmp('siteAlias').setDisabled(true);
				Ext.getCmp('siteAlias').hide();
			}
			/*else
			{
				Ext.getCmp('siteAlias').setDisabled(false);
				if(isSiteOrService=='false')
				{
					//Ext.getCmp('siteAlias').setDisabled(true);
					Ext.getCmp('siteAlias').hide();
				}
				else
					Ext.getCmp('siteAlias').show();
			}*/
		}

		/*Ext.Ajax.request({
			url: 'Services/data/EgConfigSitesJson.jsp?modify='+modify+'&site='+s_site+'&service='+s_service+'&segment='+segment+'&zone='+s_zone,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}*/

				var associatedToZone = publicJSON['AssociatedToZone'];
				if(associatedToZone=='true')
				{
					Ext.getCmp('componentLbl').show();
					Ext.getCmp('zonecombo').enable();
					Ext.getCmp('zonecombo').getStore().suspendEvents(true);
					Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['zonelist']);
					Ext.getCmp('zonecombo').getStore().resumeEvents();
					Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
				}
				else
				{
					Ext.getCmp('componentLbl').hide();
					Ext.getCmp('zonecombo').disable();
				}

//				if(associatedToZone=='true')
//				{
//					if(modify=='false')
//					{
//						Ext.getCmp('zonecombo').setDisabled(false);  @Magesh
//					}
//					else
//					{
//						if(publicJSON['AssociatedZone']=='-1')
//						{
//							Ext.getCmp('componentLbl').hide();
//							Ext.getCmp('zonecombo').disable();
//						}
//						else
//						{
//							Ext.getCmp('componentLbl').show();
//							Ext.getCmp('zonecombo').enable();
//							Ext.getCmp('zonecombo').getStore().suspendEvents(true);
//							Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['zonelist']);
//							Ext.getCmp('zonecombo').getStore().resumeEvents();
//							Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
//						}
//					}
//				}
//				else
//				{
//					if(publicJSON['AssociatedZone']=='-1')     // @Magesh
//					{
//							Ext.getCmp('componentLbl').hide();
//							Ext.getCmp('zonecombo').disable();
//					}
//				}
				if(modify=='false')
				{
					Ext.getCmp('segmentcombo').getStore().suspendEvents(true);
					Ext.getCmp('segmentcombo').getStore().loadRawData(publicJSON['segmentList']);
					Ext.getCmp('segmentcombo').getStore().resumeEvents();
					Ext.getCmp('segmentcombo').setValue('-1');
					Ext.getCmp('sitecombo').setValue('No');
					Ext.getCmp('sitecombo').hide();
					Ext.getCmp('siteAlias').setDisabled(false);
					Ext.getCmp('siteAlias').hide();

					Ext.getCmp('aggcombo').setValue('No');
				}
				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
				Ext.getCmp('domaincombo').getStore().suspendEvents(true);
				Ext.getCmp('domaincombo').getStore().loadRawData(publicJSON['domainArray']);
				Ext.getCmp('domaincombo').getStore().resumeEvents();
				Ext.getCmp('domaincombo').setValue('Others');
				Ext.getCmp('imagecombo').getStore().clearFilter(true);
				
				Ext.getCmp('imagecombo').getStore().suspendEvents(true);
				Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass('serviceOthersSmall');
				Ext.getCmp('imagecombo').getStore().resumeEvents();
				Ext.getCmp('imagecombo').setValue("serviceOthersSmall");
				if(modify=='true')
				{
					Ext.getCmp('domaincombo').setValue(publicJSON['selectedDomain']);
					Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
					$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
				}
			//}
		//});
		//this.segmentComboLoad();
		if (Ext.getCmp('mappingcombo').isVisible())
		{
			Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
		}
		Ext.getCmp('servicename').focus();
	}
});
