Ext.define('Services.controller.LogicalTopology',{
	extend:'Ext.app.Controller',
	views:['TopologyItems'],
	refs:[
		{selector:'topologyitems', ref:'topologyitems'}
	],

	init:function(){
		this.buildFieldData()
		this.control({
			'topologyitems':
			{
				'afterrender': this.afterMainRender
			}
		});
	},

	buildFieldData: function(url){
		
		Ext.Ajax.request({
			url: 'Services/data/EgLogicalTopologyJson.jsp',
			method: 'POST',
			params:url+"&segmentFromTopo="+segmentFromTopo+"&zoneFromTopo="+zoneFromTopo,
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function(jsonText){
		publicJSON = Ext.decode( jsonText );
		Ext.getCmp('topologyPanel').setTitle("&nbsp;TOPOLOGY FOR '"+publicJSON['siteServiceName']+ "'");
		var topologyUrl = publicJSON['graphData'];
		Ext.getCmp('topologyFrame').update('<iframe id="logicalTopology" src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px solid green"></iframe>');
	},

	getRenderMd : function(){
		Ext.getCmp('topologyPanel').setTitle("&nbsp;TOPOLOGY FOR '"+publicJSON['siteServiceName']+ "'");
		var topologyUrl = publicJSON['graphData'];
		Ext.getCmp('topologyFrame').update('<iframe id="logicalTopology" src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px solid red"></iframe>');
	}

});



