Ext.define('Services.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ComponentServices','ComponentService','TopologyItems','ConfigureSegment','RenameService','Main','maximizeWindow'],
	//requires : ['Services.view.FormItems'],
	refs:[
		{selector:'componentservices', ref:'componentservices'},
		{selector:'topologyitems', ref:'topologyitems'},
		{selector:'configuresegment', ref:'configuresegment'},
		{selector:'componentservice', ref:'componentservice'},
		{selector:'renameservice', ref:'renameservice'},
		{selector:'main', ref:'main'},
		{selector:'maximizewindow', ref:'maximizewindow'}
	],
	init:function(){
		appCnt = this;
		this.buildFieldData();

		this.control({
			'componentservices':
			{
				'afterrender': this.afterMainRender
			},
			'componentservices [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'componentservices trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'componentservices button[id="addService"]': {
				'click': this.addService
			},
			'componentservice combo[id="servicecombo"]':
			{
				'select':this.serviceComboLoad
			},
			'componentservice combo[id="sitecombo"]':
			{
				'select':this.siteComboLoad
			},
			'componentservice multiselectSi[id="zonecombo"]':
			{
				'change': this.zoneComboLoad 
			},
			'componentservice combo[id="aggcombo"]':
			{
				'select': this.aggComboLoad
			},
			/*'componentservice multiselect[id="segmentcombo"]':
			{
				'change':this.segmentComboLoad
			},*/
			'componentservice combo[id="segmentcombo"]':
			{
				'select':this.segmentComboLoad
			},
			'componentservice button[id="UpdateBTN"]':
			{
				'click': this.updation
			},
			//'componentservice button[id="backbutton"]': // modified
			//{
				//'click': this.backbutton
			//},
			'main button[id="backbutton"]': // modified
			{
				'click': this.backbutton
			},
			'topologyitems button[id="backbutton"]':
			{
				'click': this.backToConfig
			},
			'configuresegment button[id="topoUpdateBtn"]':
			{
				'click': this.updateTopology
			},
			'topologyitems button[id="iconAutoTopo"]':
			{
				'click': this.autoPosition
			},
			'topologyitems button[id="iconReset"]':
			{
				'click': this.resetPosition
			},
			'topologyitems button[id="iconMaximize"]':
			{
				'click': this.iconMaximize
			},
			'topologyitems button[id="iconSave"]':
			{
				'click': this.savePosition
			},
			'topologyitems button[id="iconAutofit"]':
			{
				'click': this.autoFit
			},
			'configuresegment button[id="indiconReset"]':
			{
				'click': this.resetPosition
			},
			'configuresegment button[id="indiconMaximize"]':
			{
				'click': this.iconMaximize
			},
			'configuresegment button[id="indiconAutofit"]':
			{
				'click': this.autoFit
			},
			'configuresegment button[id="indiconSave"]':
			{
				'click': this.savePosition
			},
			'topologyitems button[id="goToConfigureService"]':
			{
				'click': this.goToConfigureService
			},
			'configuresegment button[id="indgoToConfigureService"]':
			{
				'click': this.goToConfigureService
			},
			'componentservice button[id="goToTopoPage"]':
			{
				'click': this.goToTopoPage
			},
			'renameservice button[id="renameBTN"]':
			{
				'click': this.renameService
			},
			'maximizewindow button[id="iconAutofitPopup"]':
			{
				'click': this.autoFit
			},
			'maximizewindow button[id="iconSavePopup"]':
			{
				'click': this.savePosition
			},
			'maximizewindow button[id="iconResetPopup"]':
			{
				'click': this.resetPosition
			},
			'componentservice textfield[id="servicename"]':
			{
				'blur': this.validateName
			},
		});
	},
	validateName: function()
	{
		var serName = Ext.getCmp('servicename').getValue();
		if(serName != null && serName.trim().length > 0)
		{
			if(this.specialCharacterCheck(serName))
			{
				Ext.Msg.show({
					title : pageTitle,
					msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function()
					{
						Ext.getCmp('servicename').focus();
					}
				});
				return false;
			}
		}
	},
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	tabChange: function(tab)
	{
		var selectedTab = tab;
		var tabPanel = Ext.getCmp('maintab');
		if(selectedTab.toLowerCase() == "mainservviewtab")
		{
			appCnt.loadServiceTabData();
			Ext.getCmp('configuresegment').remove("indtopologyPanel");
			tabPanel.child('#segmentTab').tab.hide();
		}
		if (selectedTab.toLowerCase() == "topoitemstab")
		{
			try
			{
				//Loading Page newly
				var srcUrl = Ext.get('logicalTopology').dom.src;
				Ext.get('logicalTopology').dom.src = srcUrl;	
			}
			catch (e)
			{
			}
			Ext.getCmp('configuresegment').remove("indtopologyPanel");
			tabPanel.child('#segmentTab').tab.hide();
		}
	},
	goToConfigureService: function() 
	{
		Ext.getCmp('maintab').setActiveTab(0);
		appCnt.tabChange("mainservviewtab");
	},
	loadServiceTabData: function()
	{
		var s_zone='';
		if(Ext.getCmp('zonecombo').getValue() != undefined)
			s_zone = Ext.getCmp('zonecombo').getValue();
		else
			s_zone = 'all';

		service = "";

		var siteConfigURL = publicJSON['backBtnUrl'];
		var siteName = publicJSON['siteName'];
		//var s_segment = getSegmentNameFromURL(siteConfigURL);
		//if(s_segment != null && s_segment != "" && s_segment != undefined)
		//{
			//Ext.getCmp('hiddenSegName').setValue(s_segment);
		//}
		//else
		//{
			//s_segment = Ext.getCmp('hiddenSegName').getValue();
		//}
		s_segment = publicJSON['selectedSegment'];
		if(siteConfigURL != null && siteConfigURL != "" && siteConfigURL != undefined)
		{
			Ext.getCmp('hiddenServName').setValue(siteName.trim());
			Ext.getCmp('hiddenActionMode').setValue("true");
			var modifyUrl = "Services/data/EgConfigSitesJson.jsp?site="+encodeURIComponent(siteName)+"&modify=true"+"&zone="+encodeURIComponent(s_zone)+"&segment="+encodeURIComponent(s_segment)+"&service="+encodeURIComponent(service);
			modifyUrl = modifyUrl +"&segmentFromTopo="+segmentFromTopo+"&zoneFromTopo="+zoneFromTopo;
			var configGroupController = this.getController('Services.controller.ConfigServiceControl');
			configGroupController.buildFieldData(modifyUrl);
			configGroupController.init();
			configGroupController.afterMainRender(siteName.trim(),'true');
		}
		Ext.getCmp('goToTopoPage').show();
	},
	goToTopoPage: function()
	{
		Ext.getCmp('maintab').setActiveTab(2);
		//var serviceName = Ext.getCmp('servicecombo').getValue();
		//var segName = Ext.getCmp('segmentcombo').getValue();
		//appCnt.loadTopoDiagram(serviceName,segName,"");
	},
	resetPosition: function(obj)
	{
		if (obj.getId() == 'iconReset' || obj.getId() == 'indiconReset')
		{
			window.frames[0].resetPostion(0);
		}
		else if (obj.getId() == 'iconResetPopup')
		{
			if (Ext.getCmp('maintab').getActiveTab().id == 'topologyitems')
			{
				window.frames[1].resetPostion(1);
			}
			else
			{
				window.frames[2].resetPostion(2);
			}
		}
	},
	iconMaximize: function(obj)
	{
		var ht = Ext.getBody().getViewSize().height;
		var wt = Ext.getBody().getViewSize().width;
		var htt = window.frames[0].document.body.scrollHeight;
		var topologyUrl = "";
		topologyUrl = window.frames[0].openBigDiv(0);
		Ext.widget('maximizewindow').show();
		var ht = Ext.getBody().getViewSize().height;
		var wt = Ext.getBody().getViewSize().width;
		Ext.getCmp('topologyMaxFrame').update('<iframe id="maxWindow" src="' + topologyUrl+ '" style="border:0px" width='+wt+' height='+ht+' scrolling="no"></iframe>');
	},
	autoFit: function(obj)
	{
		if (obj.getId() == 'iconAutofit' || obj.getId() == 'indiconAutofit')
		{
			window.frames[0].autoFit(0);
		}
		else if (obj.getId() == 'iconAutofitPopup')
		{
			if (Ext.getCmp('maintab').getActiveTab().id == 'topologyitems')
			{
				window.frames[1].autoFit(1);
			}
			else
			{
				window.frames[2].autoFit(2);
			}
		}
	},
	savePosition: function(obj)
	{
		if (obj.getId() == 'iconSave' || obj.getId() == 'indiconSave')
		{
			window.frames[0].savePosition(0);
		}
		else if (obj.getId() == 'iconSavePopup')
		{
			if (Ext.getCmp('maintab').getActiveTab().id == 'topologyitems')
			{
				window.frames[1].savePosition(1);
			}
			else
			{
				window.frames[2].savePosition(2);
			}
		}
	},
	expandAllRows:function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(!expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	collapseAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	renameService: function()
	{
		
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.field value cannot be blank']);
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['sameName']);
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
				return false;
			}
		}
		
		var renameUrl = "Services/data/renameJson.jsp?rename=Service&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name);
		Ext.Ajax.request({
			url: renameUrl,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						window.location.href="EgComponentServices.jsp?fromWizard="+fromWizard;
					}
					else
					{
						Ext.Msg.alert(renameJSON.rename,renameJSON.message);
						
					}
				}
				
			}
		});
		
	},
	backbutton: function()
	{
		if (comeFrom == "userpage")
		{
			window.location.href = backHref + "&username="+username + "&selectedTab=3"+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'comp_mng_umng')
		{
			window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'agg_mng_umng')
		{
			window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'discovery_mng_umng')
		{
			window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11";
			return;
		}
		else if (comeFrom == 'comp_add_modify')
		{
			window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'comp_add_mod_new')
		{
			window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
			return;
		}

		if(returnToMain=='true')
		{
			if (!Ext.isEmpty(mainUrl))
			{
				if (mainUrl.indexOf('.jsp?') != -1)
				{
					mainUrl += '&fromWizard='+fromWizard
				}
				else
				{
					mainUrl += '?fromWizard='+fromWizard
				}
			}


			window.location.href=mainUrl;
			if(returnToTopology==null || returnToTopology!='true' && returnToTopology=='null')
				return false;
		}
		if(returnToTopology!=null && returnToTopology=='true' && returnToTopology!='null')
		{
			var url = "EgComponentSegments.jsp?qctr=0&segment="+segmentFromTopo+"&mode=modify"+"&zone="+zoneFromTopo+"&returnTo=segments"+"&returnToMain="+returnToMain+"&mainUrl="+mainUrl+"&fromWizard="+fromWizard;
			window.location.href=url;
		}
		else
		{
			window.location.href="EgComponentServices.jsp?fromWizard="+fromWizard;
		}
	},
	
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var isDisabled = hideIcon.get('isDisabled');
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		if (isDisabled == 'true')
		{
			Ext.get(icons[0]).removeCls('x-hidden');
		}
		else
		{
			Ext.get(icon).removeCls('x-hidden');
		}
	});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	handleRenameIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Rename';
		var rec = grid.getStore().getAt(rowIndex);
		var Servicename = rec.get('FullName');
		if(Servicename.indexOf("(")>-1)
			Servicename = Servicename.substring(0,Servicename.indexOf("("));
		this.showEditWindow(Servicename);
	},
	showEditWindow: function(Servicename){
		Ext.widget('renameservice').show();
		Ext.getCmp('currentname').setValue(Servicename);

		Ext.Ajax.request({
			url: 'Services/data/renamehelpJson.jsp',
			method: 'POST'
		});
	},
	
	handleEditIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Edit';
		var rec = Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var Servicename = rec.get('FullName');
		if(Servicename.indexOf("(")>-1)
			Servicename = Servicename.substring(0,Servicename.indexOf("("));
		var configGroupController = this.getController('Services.controller.ConfigServiceControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData(rec.get('ModifyUrl'));
		configGroupController.init();
		Ext.getCmp('viewport').add({
			xtype: 'main'
		});

		var segment = getSegmentNameFromURL(rec.get('ModifyUrl'));

		Ext.getCmp('hiddenServName').setValue(Servicename.trim());
		Ext.getCmp('hiddenActionMode').setValue("true");
		var tabPanel = Ext.getCmp('maintab');
		tabPanel.child('#topoItemsTab').tab.show();
		tabPanel.setActiveTab(2);
		Ext.getCmp('goToTopoPage').show();
		appCnt.loadTopoDiagram(Servicename.trim(),segment,"");
		//configGroupController.afterMainRender(Servicename.trim(),'true');
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		var DispValues = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
		var groupName = DispValues.get('FullName');
		if(groupName.indexOf("(")>-1)
			groupName = groupName.substring(0,groupName.indexOf("("));
		groupName = groupName.trim();
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['deleteIconClick1']+' \''+groupName+'\' '+publicJSON['screenLabels']['deleteIconClick2'],function(buttonText) {
			if (buttonText == "yes") 
			{
				var resultUrl = "Services/data/EgconfigsitespJson.jsp?sitename="+encodeURIComponent(groupName)+"&mode=del&reqfrom=navlink";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var myjsonText = response.responseText;
							var myjsonObj = Ext.decode( myjsonText );
							var isUpdated = myjsonObj['isUpdated'];
							var myupdateUrl = myjsonObj['ForwardPage'];
							if(isUpdated=='true')
							{
								if (!Ext.isEmpty(myupdateUrl))
								{
									if (myupdateUrl.indexOf("?") != -1)
									{
										myupdateUrl+="&fromWizard="+fromWizard;
									}
									else
									{
										myupdateUrl+="?fromWizard="+fromWizard;
									}
								}
								window.location.href = myupdateUrl;
							}
						}
					}
				});
			}
		});
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.alert(mainPageTitle,publicJSON['screenLabels']['no service selected']);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('FullName');
			if(id!=null)
			{
				if(id.indexOf("(")>-1)
					id = id.substring(0,id.indexOf("("));
				id = id.trim();
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['deleteBtnClick']+'?',function(buttonText) {
			if (buttonText == "yes") 
			{
				var resultUrl = "Services/data/EgconfigsitespJson.jsp?sitename="+encodeURIComponent(selectedGroups)+"&mode=del&reqfrom=navlink";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var myjsonText = response.responseText;
							var myjsonObj = Ext.decode( myjsonText );
							var isUpdated = myjsonObj['isUpdated'];
							var myupdateUrl = myjsonObj['ForwardPage'];
							if(isUpdated=='true')
							{
								if (!Ext.isEmpty(myupdateUrl))
								{
									if (myupdateUrl.indexOf("?") != -1)
									{
										myupdateUrl+="&fromWizard="+fromWizard;
									}
									else
									{
										myupdateUrl+="?fromWizard="+fromWizard;
									}
								}
								window.location.href=myupdateUrl;
							}
						}
					}
				});
			}
		});
	},

	
	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'Services/data/EgDispSitesJson.jsp?reqfrom=navlink&fromWizard='+fromWizard,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	backToConfig: function()
	{
		var siteConfigURL = publicJSON['backBtnUrl'];
		var siteName = publicJSON['siteName'];
		siteConfigURL = siteConfigURL+"&comefrom=logicaltopologyTemp";
		//window.location.href = siteConfigURL;
		
		//var configGroupController = this.getController('Services.controller.ConfigServiceControl');
		//Ext.getCmp('viewport').removeAll();
		//configGroupController.buildFieldData(siteConfigURL);
		//Ext.getCmp('viewport').add({xtype: 'main'});
		//configGroupController.afterMainRender(siteName,'true');
		return;
	},
	afterMainRender : function()
	{
		//if(comeFrom!=null)
		//{
			if(comeFrom=='Eglogicaltopologyp')
			{
				var topoController = this.getController('Services.controller.ServiceTopology');
				var qs = "site=" + encodeURIComponent(site) + "&segment=" + encodeURIComponent(segment) + "&ass_servers=" + encodeURIComponent(ass_servers)+'&action=modify'+"&service="+encodeURIComponent(service)+"&zone="+encodeURIComponent(zone)+'&comefrom=Eglogicaltopologyp';
				qs=qs+"&returnToTopology="+returnToTopology;
				qs=qs+"&returnToMain="+returnToMain+"&mainUrl="+mainUrl;
				Ext.getCmp('viewport').removeAll();
				jsonText = topoController.buildFieldData(qs);
				//Ext.getCmp('viewport').add({xtype: 'topologyitems'});
				Ext.getCmp('viewport').add({xtype: 'main'});
				var tabPanel = Ext.getCmp('maintab');
				tabPanel.child('#segmentTab').tab.show();
				tabPanel.setActiveTab(1);
				//Ext.getCmp('goToConfigureService').show();
				topoController.afterMainRender(jsonText);
				return;
			}
			else if(comeFrom=='topology' || comeFrom=='logicaltopology' || returnToMain=='true' || comeFrom == "userpage" || comeFrom == "comp_mng_umng" || comeFrom == "agg_mng_umng" || comeFrom == "discovery_mng_umng" || comeFrom == 'comp_add_modify' || comeFrom == 'comp_add_mod_new')
			{
				var modifyUrl = "Services/data/EgConfigSitesJson.jsp?site="+encodeURIComponent(site)+"&modify=true"+"&zone="+encodeURIComponent(zone)+"&segment="+encodeURIComponent(segment)+"&service="+encodeURIComponent(service);
				modifyUrl = modifyUrl +"&segmentFromTopo="+segmentFromTopo+"&zoneFromTopo="+zoneFromTopo;
				var configGroupController = this.getController('Services.controller.ConfigServiceControl');
				Ext.getCmp('viewport').removeAll();
				configGroupController.buildFieldData(modifyUrl);
				configGroupController.init();
				Ext.getCmp('viewport').add({
					xtype: 'main',
					site: site,
					action: 'true'
				});

				Ext.getCmp('hiddenServName').setValue(site);
				Ext.getCmp('hiddenActionMode').setValue("true");
				var tabPanel = Ext.getCmp('maintab');
				tabPanel.child('#topoItemsTab').tab.show();
				tabPanel.setActiveTab(2);
				Ext.getCmp('goToTopoPage').show();
				appCnt.loadTopoDiagram(site,segment,"");

				//configGroupController.afterMainRender(site,'true');
				return;
			}
		//}
		

		var resultsData = publicJSON['gridValues'];
		Ext.getCmp('gridDisplay').show();
		Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
		Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
		Ext.getCmp('gridDisplay').getStore().resumeEvents();

		if(publicJSON['disableAddSer'] === "true")
		{
			Ext.getCmp('NoExtPresent').show();
			Ext.getCmp('gridDisplay').hide();
		}
		else
		{
			Ext.getCmp('NoExtPresent').hide();
			Ext.getCmp('gridDisplay').show();
		}
		var noExtFound = publicJSON['NoExtFound'];
		if (noExtFound == "true")
		{
			Ext.getCmp('gridSearch').disable();
		}
		else
		{
			Ext.getCmp('gridSearch').enable();
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'Services/data/EgDispSitesJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch)+'&fromWizard='+fromWizard,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridValues']);
					Ext.getCmp('gridDisplay').getStore().resumeEvents();
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+nodata+'</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		});
	},
	addService : function()
	{
		var isValidName = publicJSON['screenLabels']['isValid'];
		if(isValidName=="false")
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.ErroInAddingService']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			var configGroupController = this.getController('Services.controller.ConfigServiceControl');
			Ext.getCmp('viewport').removeAll();
			var url = publicJSON['AddServiceUrl'];
			var strsite = publicJSON['strsite'];
			configGroupController.buildFieldData(url);
			configGroupController.init();
			Ext.getCmp('viewport').add({
				xtype: 'main'
			});

			Ext.getCmp('hiddenServName').setValue(strsite);
			Ext.getCmp('hiddenActionMode').setValue("false");
			var tabPanel = Ext.getCmp('maintab');
			tabPanel.child('#topoItemsTab').tab.hide();
			tabPanel.setActiveTab(0);
			Ext.getCmp('goToTopoPage').hide();
			configGroupController.afterMainRender(strsite,"false");
		}
	},

	serviceComboLoad: function()
	{
		var me = this;
		var modify = publicJSON['modify'];
		Ext.getCmp('servicecombo').getStore().loadRawData(publicJSON['ExistingServiceNames']);
		var servicecombo = Ext.getCmp('servicecombo').getValue();
		var selectedSegment = publicJSON['selectedSegment'];
		appCnt.loadTopoDiagram(servicecombo,selectedSegment,"serviceComboLoad");
		Ext.Ajax.request({
			url: 'Services/data/EgConfigSitesJson.jsp?site='+encodeURIComponent(servicecombo)+"&modify=true",
			method: 'POST',
			async: false,
			success: function( response )
			{
				if (response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

//				if(associatedToZone=='true')
//				{
//					if(modify=='false')
//					{
////						Ext.getCmp('zonecombo').setDisabled(false);
//						Ext.getCmp('componentLbl').show();
//						Ext.getCmp('zonecombo').enable();
//						Ext.getCmp('zonecombo').getStore().suspendEvents(true);
//						Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['zonelist']);
//						Ext.getCmp('zonecombo').getStore().resumeEvents();
//						Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
//					}
//					else
//					{
//						if(publicJSON['AssociatedZone'] == '-1')
//						{
//							Ext.getCmp('componentLbl').hide();
//							Ext.getCmp('zonecombo').disable();
//						}
//						else
//						{
//							Ext.getCmp('componentLbl').show();
//							Ext.getCmp('zonecombo').enable();
//							Ext.getCmp('zonecombo').getStore().suspendEvents(true);
//							Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['zonelist']);
//							Ext.getCmp('zonecombo').getStore().resumeEvents();
//							Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
//						}
//					}
//				}
//				else
//				{
//					Ext.getCmp('componentLbl').hide();
//					Ext.getCmp('zonecombo').disable();
//				}

				var isSiteOrService = publicJSON['isSite'];

				//adding rum component start
				if(isSiteOrService=='false')
				{
					Ext.getCmp('rumAssociatedLabel').hide();
				}
				else
				{
					Ext.getCmp('rumAssociatedLabel').show();
					if(allow == 'true')
					{
						var siteForComp = publicJSON['componentForSelectedSite'];
						var selectedCategory="-1";
						var selectedCType="Real_user_monitor";
						selectedCType = encodeURIComponent(selectedCType);
						selectedCategory = encodeURIComponent(selectedCategory);
						var s_rumComp=siteForComp;
						siteForComp=siteForComp+":NULL";
						Ext.getCmp('rumAssociatedLabel').update('<style="font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:10px">RUM Component "'+s_rumComp+'" is associated to this site.<br/><a href="EgNewServer.jsp?isAggregateLink=false&server='+encodeURIComponent(siteForComp)+'&serverType='+selectedCType+'&modifyserver=true&siteSupport=false&treeViewSrc=null&serverGategory='+selectedCategory+'&servicePage=servicePageView" style="text-decoration: underline;">Click here</a>&nbsp;to view/modify.');
					}
					else
					{
						Ext.getCmp('rumAssociatedLabel').hide();
					}
				}
				//end 
				if(isSiteOrService!=null && isSiteOrService!='null' && isSiteOrService=='true')
				{
					Ext.getCmp('siteAlias').setValue(publicJSON['aliasValue']);
					Ext.getCmp('siteAlias').show();
					Ext.getCmp('siteAlias').setDisabled(false);
					Ext.getCmp('sitecombo').setValue('Yes');
					Ext.getCmp('sitecombo').show();
				}
				else
				{
					Ext.getCmp('sitecombo').setValue('No');
					Ext.getCmp('sitecombo').hide();
					Ext.getCmp('siteAlias').setValue(publicJSON['aliasValue']);
					Ext.getCmp('siteAlias').hide();
				}

				//var selectedSegment = "-1";
				var associatedToZone = publicJSON['AssociatedToZone'];
				allow = publicJSON['isSiteAssociated'];
				if(associatedToZone=='true')
				{
					Ext.getCmp('componentLbl').show();
					Ext.getCmp('zonecombo').enable();
					Ext.getCmp('zonecombo').getStore().suspendEvents(true);
					Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['zonelist']);
					Ext.getCmp('zonecombo').getStore().resumeEvents();
					Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
				}
				else
				{
					Ext.getCmp('componentLbl').hide();
					Ext.getCmp('zonecombo').disable();
				}

				var displayCheckbox = publicJSON['displayCheckBox'];
				var isAggregateSite = publicJSON['isAggregateSite'];
				if(displayCheckbox && isAggregateSite=='true')
				{
					Ext.getCmp('aggcombo').show(true);
					Ext.getCmp('aggcombo').setDisabled(true);
					if(isAggregateSite=='true')
					{
						Ext.getCmp('aggcombo').setValue('Yes');
						if(publicJSON['displaySiteMap']=='true')
						{
							//Ext.getCmp('mappingcombo').show(true);
							Ext.getCmp('mappingcombo').getStore().suspendEvents(true);
							Ext.getCmp('mappingcombo').getStore().loadRawData(publicJSON['aggregateSite']);
							Ext.getCmp('mappingcombo').getStore().resumeEvents();
							Ext.getCmp('mappingcombo').setValue(publicJSON['mappingSiteName']);
							Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
						}
					}
					else
					{
						Ext.getCmp('aggcombo').setValue('No');
						Ext.getCmp('mappingcombo').hide();
						Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'0px 0px 10px 0px'});
					}
				}
				else
				{
					Ext.getCmp('aggcombo').hide();
					Ext.getCmp('mappingcombo').hide();
					Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'0px 0px 10px 0px'});
				}
				if(modify=='true')
				{
					if(isSiteOrService!=null && isSiteOrService!='null' && isSiteOrService=='true')
					{
						Ext.getCmp('sitecombo').setDisabled(true);
					}
					Ext.getCmp('aggcombo').setDisabled(true);
				}
				Ext.getCmp('segmentcombo').getStore().removeAll();
				Ext.getCmp('segmentcombo').getStore().suspendEvents(true);
				Ext.getCmp('segmentcombo').getStore().loadRawData(publicJSON['segmentList']);
				Ext.getCmp('segmentcombo').getStore().resumeEvents();
				Ext.getCmp('segmentcombo').setValue(publicJSON['selectedSegment']);

				var url = 'Services/data/EgConfigSitesJson.jsp?site='+encodeURIComponent(servicecombo)+"&modify="+modify+"&segment="+encodeURIComponent(publicJSON['selectedSegment']);
				setTimeout(me.loadItemSelectorData(url),15000);
				if(isAggregateSite=='true' && isSiteOrService=='true')
				{
					Ext.getCmp('siteAlias').hide();
				}

				Ext.getCmp('domaincombo').setValue(publicJSON['selectedDomain']);
				Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
				$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
			}
		});
		//this.zoneComboLoad();
	},

	loadItemSelectorData : function(url)
	{
		Ext.Ajax.request({
//			url: 'Services/data/EgConfigSitesJson.jsp?site='+encodeURIComponent(servicecombo)+"&modify="+modify+"&segment="+encodeURIComponent(selectedSegment),
			url : url,
			method: 'POST',
			success: function( response )
			{
				if (response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText1 = response.responseText;
					var jsonResultData = Ext.decode( jsonText1 );

					Ext.getCmp('itemselectHostsForService').getStore().removeAll();
					Ext.getCmp('itemselectHostsForService').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHostsForService').getStore().loadRawData(jsonResultData['itemSelectorValue']);
					Ext.getCmp('itemselectHostsForService').getStore().resumeEvents();
					Ext.getCmp('itemselectHostsForService').setValue(jsonResultData['existingComponentsArr']);
					//Ext.getCmp('itemselectHostsForService').getStore().sort('groupField','ASC');
				}
			}
		});
	},
	siteComboLoad : function()
	{
		var siteValue = Ext.getCmp('sitecombo').getValue();
		var aggSite = Ext.getCmp('aggcombo').getValue();
		if(siteValue=="Yes" || siteValue=="yes")
		{
			var displayCheckbox = publicJSON['displayCheckBox'];
			if(displayCheckbox)
			{
				Ext.getCmp('aggcombo').show(true);
				if(aggSite=='Yes')
					Ext.getCmp('siteAlias').hide();
				else
					Ext.getCmp('siteAlias').show();
			}
			else
			{
				Ext.getCmp('siteAlias').show();
				Ext.getCmp('aggcombo').hide();
			}
		}
		else if(siteValue='No')
		{
			Ext.getCmp('siteAlias').setValue('');
			Ext.getCmp('siteAlias').hide();
			Ext.getCmp('aggcombo').hide();
		}
		Ext.getCmp('segmentcombo').setValue('-1');
		this.zoneComboLoad();
	},
	zoneComboLoad: function()
	{
		var me = this;
		Ext.getCmp('segmentcombo').setValue(publicJSON['selectedSegment']);
		var modify = publicJSON['modify'];
		var s_site="";
		var s_service="";
		if(modify=='true')
			s_site = Ext.getCmp('servicecombo').getValue();
		else if(modify=="false")
			s_site = Ext.getCmp('servicename').getValue();

		var siteValue = Ext.getCmp('sitecombo').getValue();
		if(siteValue=="Yes")
			s_service="false";
		else if(siteValue=="No")
			s_service="true";

		var s_zone = '';
		if(Ext.getCmp('zonecombo').getValue() != undefined)
			s_zone = Ext.getCmp('zonecombo').getValue();
		if(s_zone==null || s_zone=='null')
			s_zone='all';

		var isAggregateSite='false';
		var aggValue = Ext.getCmp('aggcombo').getValue();
		var isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
		if(aggValue!=null && isDiplayCheckBox)
		{
			if(aggValue=='Yes')
				isAggregateSite='true';
			else if(aggValue=='No')
				isAggregateSite='false';
		}
		//var segment = publicJSON['segment'];
		var segmentcombo = Ext.getCmp('segmentcombo').getValue();
		if(segmentcombo != null && segmentcombo != "" && segmentcombo != undefined)
		{
			Ext.Ajax.request({
				url: 'Services/data/EgConfigSitesJson.jsp?service='+encodeURIComponent(s_service)+"&modify="+modify+"&site="+encodeURIComponent(s_site)+"&zone="+encodeURIComponent(s_zone)+'&segment='+encodeURIComponent(segmentcombo)+'&isAggregateSite='+isAggregateSite,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}

					Ext.getCmp('segmentcombo').getStore().removeAll();
					Ext.getCmp('segmentcombo').getStore().suspendEvents(true);
					Ext.getCmp('segmentcombo').getStore().loadRawData(publicJSON['segmentList']);
					Ext.getCmp('segmentcombo').getStore().resumeEvents();
					Ext.getCmp('segmentcombo').setValue(publicJSON['selectedSegment']);

					var url = 'Services/data/EgConfigSitesJson.jsp?site='+encodeURIComponent(s_site)+"&modify="+modify+"&segment="+encodeURIComponent(publicJSON['selectedSegment']);
					setTimeout(me.loadItemSelectorData(url),15000);

					var displaySiteMap = publicJSON['displaySiteMap'];
					//console.log("displaySiteMap ZoneComboload : ",displaySiteMap);
					if(displaySiteMap=='false')
					{
						Ext.getCmp('mappingcombo').hide();
						Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'0px 0px 10px 0px'});
					}
					else
					{
						Ext.getCmp('mappingcombo').show(true);
						Ext.getCmp('mappingcombo').getStore().suspendEvents(true);
						Ext.getCmp('mappingcombo').getStore().loadRawData(publicJSON['aggregateSite']);
						Ext.getCmp('mappingcombo').getStore().resumeEvents();
						Ext.getCmp('mappingcombo').setValue(publicJSON['mappingSiteName']);
						Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
					}
				}
			});
		}
		//else // to maintain the previous data in the itemselector
		//{
			//var fromFieldData = Ext.getCmp('itemselectHostsForService').fromField.getStore().data.items;
			//Ext.getCmp('itemselectHostsForService').getStore().removeAll();
			//Ext.getCmp('itemselectHostsForService').setValue('');
			//Ext.getCmp('itemselectHostsForService').fromField.getStore().loadRecords(fromFieldData,true);//here@@@@@@@
			//Ext.getCmp('itemselectHostsForService').fromField.getStore().sort('groupField','ASC');//here@@@@@@@
		//}
	},
	aggComboLoad: function()
	{
		var siteValue = Ext.getCmp('sitecombo').getValue();
		var aggSite = Ext.getCmp('aggcombo').getValue();
		if(siteValue=="Yes" || siteValue=="yes")
		{
			var displayCheckbox = publicJSON['displayCheckBox'];
			if(displayCheckbox)
			{
				if(aggSite=='Yes')
				{
					Ext.getCmp('siteAlias').hide();
					Ext.getCmp('siteAlias').setValue('');
				}
				else
					Ext.getCmp('siteAlias').show();
			}
			else
			{
				Ext.getCmp('siteAlias').show();
			}
		}
		else if(siteValue='No')
		{
			Ext.getCmp('siteAlias').hide();
			Ext.getCmp('siteAlias').setValue('');
		}
		this.zoneComboLoad();
	},

	segmentComboLoad: function()
	{
		var modify = publicJSON['modify'];
		var s_site="";
		var s_service="";
		if(modify=='true')
			s_site = Ext.getCmp('servicecombo').getValue();
		else if(modify=="false")
			s_site = Ext.getCmp('servicename').getValue();
		else
			s_site = Ext.getCmp('servicecombo').getValue();

		if (Ext.getCmp('servicecombo').getValue() != null && Ext.getCmp('servicecombo').getValue() != undefined)
		{
			modify = 'true';
		}
		else
		{
			modify = 'false';
		}

		var siteValue = '';
		if(Ext.getCmp('sitecombo').isVisible())
		{
			siteValue = Ext.getCmp('sitecombo').getValue();
			if(siteValue=="Yes")
				s_service="false";
			else if(siteValue=="No")
				s_service="true";
		}
		else
		{
			siteValue = publicJSON['isSite'];
			if(siteValue=='true') s_service='false';
			else s_service = 'true';
		}
		var s_zone='';
		if(Ext.getCmp('zonecombo').getValue() != undefined)
			s_zone = Ext.getCmp('zonecombo').getValue();
		else
			s_zone = 'all';

		var isAggregateSite = publicJSON['isAggregateSite'];
		var isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
		if(isDiplayCheckBox && publicJSON['displayCheckBox'])
		{
			var aggValue = Ext.getCmp('aggcombo').getValue();
			if(aggValue=='Yes')
				isAggregateSite='true';
			else if(aggValue=='No')
				isAggregateSite='false';
		}
		var s_alias ='';
		var aliasDisplayed = Ext.getCmp('siteAlias').isVisible();
		if(aliasDisplayed)
			s_alias = Ext.getCmp('siteAlias').getValue();
		else
			s_alias = publicJSON['aliasValue'];
		if(s_alias==null || s_alias=='undefined')
			s_alias='';

		var s_segment = Ext.getCmp('segmentcombo').getValue();
		//var s_segment = Ext.getCmp('segmentcombo').getSubmitValue();

		var surl='Services/data/EgConfigSitesJson.jsp?service='+encodeURIComponent(s_service)+"&modify="+modify+"&site="+encodeURIComponent(s_site)+"&zone="+encodeURIComponent(s_zone)+'&segment='+encodeURIComponent(s_segment);
		surl=surl+'&isAggregateSite='+isAggregateSite+"&validate=true";
		if(s_service=='false')
			surl=surl+"&aliasname="+encodeURIComponent(s_alias);
		
		//var segment = publicJSON['segment'];alert(segment+"  "+s_segment);
		if(s_segment != null && s_segment!='' && s_segment!='undefined')
		{
			Ext.Ajax.request({
				url: surl,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					Ext.getCmp('segmentcombo').getStore().removeAll();
					Ext.getCmp('segmentcombo').getStore().suspendEvents(true);
					Ext.getCmp('segmentcombo').getStore().loadRawData(publicJSON['segmentList']);
					Ext.getCmp('segmentcombo').getStore().resumeEvents();
					var isValidName = publicJSON['screenLabels']['isValid']; 
					if(isValidName=="false")
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.ErroInAddingService']);
						Ext.getCmp('segmentcombo').setValue('-1');
						return;
					}
					else
					{
						Ext.getCmp('itemselectHostsForService').getStore().removeAll();
						Ext.getCmp('itemselectHostsForService').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHostsForService').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHostsForService').getStore().resumeEvents();
						Ext.getCmp('itemselectHostsForService').setValue(publicJSON['existingComponentsArr']);

						var displaySiteMap = publicJSON['displaySiteMap'];
						if(displaySiteMap=='false')
						{
							Ext.getCmp('mappingcombo').hide();
							Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'0px 0px 10px 0px'});
						}
						else
						{
							Ext.getCmp('mappingcombo').show(true);
							Ext.getCmp('mappingcombo').getStore().suspendEvents(true);
							Ext.getCmp('mappingcombo').getStore().loadRawData(publicJSON['aggregateSite']);
							Ext.getCmp('mappingcombo').getStore().resumeEvents();
							Ext.getCmp('mappingcombo').setValue(publicJSON['mappingSiteName']);
							Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
						}
					}
				}
			});
		}
		//else // to maintain the previous data in the itemselector
		//{
			//var fromFieldData = Ext.getCmp('itemselectHostsForService').fromField.getStore().data.items;
			//Ext.getCmp('itemselectHostsForService').getStore().removeAll();
			//Ext.getCmp('itemselectHostsForService').setValue('');
			//Ext.getCmp('itemselectHostsForService').fromField.getStore().loadRecords(fromFieldData,true); //here@@@@@@@
			////Ext.getCmp('itemselectHostsForService').getStore().sort('groupField','ASC');
		//}
	},
	updateTopology: function()
	{
		var myTopoMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myTopoMask.show(); 

		//var updateUrl = publicJSON['updateUrlForTopology'];
		var updateUrl = 'Services/data/Eglogicaltopologyp.jsp?';
		var unmanagedHostList = Ext.getCmp('itemselectComps').getValue();

		var Arr = new Array();
		for (var i=0;i<Ext.getCmp('itemselectComps').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectComps').getStore().getAt(i).get('valueField');
			var isData = false;
			for (var j=0;j<unmanagedHostList.length ;j++ )
			{
				if (allValue == unmanagedHostList[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				Arr[Arr.length]=allValue;
			}
		}
		var tempmanagedHostList = Arr;
		var managedHostList = tempmanagedHostList.toString();

		var hiddenLogicalTopoObj = Ext.getCmp('hiddenlogicalTopocontainer');
		var logtemp = {
			xtype: 'hiddenfield',
			name: 'srvlist',
			value: unmanagedHostList
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'ass_servlist',
			value: managedHostList
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'assservers',
			value: publicJSON['ass_servers']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'site',
			value: publicJSON['siteName']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'str_ex_servers',
			value: publicJSON['str_ex_servers']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'str_ass_servers',
			value: publicJSON['str_ass_servers']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'zoneFromTopo',
			value: publicJSON['zoneFromTopo']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var logtemp = {
			xtype: 'hiddenfield',
			name: 'segmentFromTopo',
			value: publicJSON['segmentFromTopo']
		};
		hiddenLogicalTopoObj.add(logtemp);

		var resultUrl = updateUrl+"&service="+encodeURIComponent(publicJSON['service'])+'&segment='+encodeURIComponent(publicJSON['segment'])+'&zone='+encodeURIComponent(publicJSON['zoneName'])+'&action='+publicJSON['action'];

		resultUrl=resultUrl+'&alias='+encodeURIComponent(publicJSON['alias_name']);

		//if(comeFrom!=null && comeFrom=='topology')
		//{
			resultUrl=resultUrl+"&returnToTopology="+returnToTopology;
		//}
		resultUrl=resultUrl+"&returnToMain="+returnToMain+"&mainUrl="+mainUrl;
		//resultUrl=resultUrl;

		var hiddenLogObj = Ext.getCmp('configuresegment').getForm();
		hiddenLogObj.submit({
			url: resultUrl,
			method: 'POST',
			standardSubmit: false,
			success: function( form,action )
			{
				myTopoMask.hide();
				var jsonText = action.response.responseText;
				jsonObj = Ext.decode(jsonText);

				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var url = jsonObj['ForwardPage'];
					if (!Ext.isEmpty(url))
					{
						if (url.indexOf("?") != -1)
						{
							url+="&fromWizard="+fromWizard;
						}
						else
						{
							url+="?fromWizard="+fromWizard;
						}
					}
					window.location.href=url; 
				}
				hiddenLogicalTopoObj.removeAll();
			},
			failure: function()
			{
				myTopoMask.hide();
				hiddenLogicalTopoObj.removeAll();
			}
		});
	},
	updation: function(btn)
	{
		var imageName = Ext.getCmp('imagecombo').getValue();
		var domainName = Ext.getCmp('domaincombo').getValue();
		var modify = publicJSON['modify'];
		if(modify==null || modify=='null') 
		{
			modify='false';
		}
		else if (modify=='undefined')
		{
			modify='true';
		}
		var topoController = this.getController('Services.controller.ServiceTopology');
		var topoController1 = this.getController('Services.controller.LogicalTopology');

		var isDouble = publicJSON['isDouble'];
		var s_site="";
		var s_service="false";
		if(modify=='true')
			s_site = Ext.getCmp('servicecombo').getValue();
		else if(modify=='false')
			s_site = Ext.getCmp('servicename').getValue();
		
		var siteValue = '';
		if(Ext.getCmp('sitecombo').isVisible())
		{
			siteValue = Ext.getCmp('sitecombo').getValue();
			if(siteValue=="Yes")
				s_service="false";
			else if(siteValue=="No")
				s_service="true";
		}
		else
		{
			siteValue = publicJSON['isSite'];
			if(siteValue=='true') s_service='false';
			else s_service = 'true';
		}
		var s_segment = Ext.getCmp('segmentcombo').getValue();
		var s_zone='';
		if(Ext.getCmp('zonecombo').getValue() != undefined)
			s_zone = Ext.getCmp('zonecombo').getValue();
		else
			s_zone = 'all';
		
		var s_alias ='';
		var aliasDisplayed = Ext.getCmp('siteAlias').isVisible();
		if(aliasDisplayed)
			s_alias = Ext.getCmp('siteAlias').getValue();
		else
			s_alias = publicJSON['aliasValue'];
		if(s_alias==null || s_alias=='undefined')
			s_alias='';
		
		var isAggregateSite = publicJSON['isAggregateSite'];
		var isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
		if(isDiplayCheckBox && publicJSON['displayCheckBox'])
		{
			var aggValue = Ext.getCmp('aggcombo').getValue();
			if(aggValue=='Yes')
				isAggregateSite='true';
			else if(aggValue=='No')
				isAggregateSite='false';
		}
		var s_spl = "`~!@#$%^&*()+=[]{}|\\;\"\'<>,?\/";
		var s_spl_alias = "`~!@#$%^&*()+=[]{}|\\;\"\'<>?\/";
		var check_val="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:,.-_";

		if(s_site!=null && s_site.trim().length > 0)
		{
			if(s_site.charAt(0) == '.' || s_site.charAt(s_site.length - 1) == '.')
			{
				Ext.Msg.show({
					title : pageTitle,
					msg : publicJSON['screenLabels']['admin.service.starts with dot not allowed'],
					icon : 'iconInformation',
					buttons : Ext.Msg.OK,
					fn: function()
					{
						Ext.getCmp('servicename').focus();
					}
				});
				return false;
			}
			if(aliasDisplayed && s_alias!=null && s_alias!='undefined')
			{
				if(s_alias.charAt(0) == '.' || s_alias.charAt(s_alias.length - 1) == '.')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.service.alias starts with dot not allowed'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn: function()
						{
							Ext.getCmp('servicename').focus();
						}
					});
					//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.alias starts with dot not allowed']);
					return false;
				}
			}
			for(count = 0; count < s_site.length; count++)
			{
				var check_char = s_spl.indexOf(s_site.charAt(count));
				if(s_site.charAt(count) == ' ')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.space not allowed'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn: function()
						{
							Ext.getCmp('servicename').focus();
						}
					});
					//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.special characters not allowed'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn: function()
						{
							Ext.getCmp('servicename').focus();
						}
					});
					//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
					return false;
				}
				if(!isDouble)
				{
					var charValue=s_site.charCodeAt(count);
					if(charValue>255)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : publicJSON['screenLabels']['admin.common.DBL not allowed'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn: function()
							{
								Ext.getCmp('servicename').focus();
							}
						});
						//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
						return false;
					}
				}
				if(s_site.charAt(count) == '.' && s_site.charAt(count + 1) == '.')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.service.Dot not allowed in consecutive position'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK,
						fn: function()
						{
							Ext.getCmp('servicename').focus();
						}
					});
					//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.Dot not allowed in consecutive position']);
					return false;
				}
			}
			if(s_service=='false' && isAggregateSite=='false')
			{
				if(s_alias.charAt(0) == ',' || s_alias.charAt(s_alias.length -1) == ',')
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.enter alias name']);
					return false;
				}
				for (c = 0; c < s_alias.length; c++) 
				{
					var check_char_alias = s_spl_alias.indexOf(s_alias.charAt(c));
					var check_al_char = check_val.indexOf(s_alias.charAt(c))
		
					if(s_alias.charAt(c) == ' ')
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
						return false;
					}
					else if(check_char_alias >= 0)
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
						return false;
					}
					else if(s_alias.charAt(c) == '.' && s_alias.charAt(c + 1) == '.')
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.Dot not allowed in consecutive position']);
						return false;
					}
					else if(s_alias.charAt(c) == ',' && s_alias.charAt(c + 1) == ',')
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.cannot have comma']);
						return false;
					}
					else if(check_al_char == -1)
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.only english characters']);
						return false;
					}
					else if(!validateAlias())
					{
						return false;
					}
				}
			}
			if(s_segment == "-1")
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please select a segment']);
				return false;
			}
		}
		if (s_site==null || s_site.trim().length == 0 || s_site == "")
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please enter a name'],
				icon : 'iconInformation',
				buttons : Ext.Msg.OK,
				fn: function()
				{
					Ext.getCmp('servicename').focus();
				}
			});
		}
		else
		{
			if(domainName==null || domainName=='-1' || domainName.length==0)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please select a domain']);
				return false;
			}
			if(imageName==null || imageName=='-1' || imageName.length==0)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please select a image']);
				return false;
			}
			var updateUrl = "Services/data/EgconfigsitespJson.jsp?";
			var unmanagedHostList = Ext.getCmp('itemselectHostsForService').getValue();

			var Arr = new Array();
			var rumCount = 0;
			var siteForComp = publicJSON['componentForSelectedSite'];
			var isSameComp = false;
			for (var i=0;i<Ext.getCmp('itemselectHostsForService').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectHostsForService').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<unmanagedHostList.length ;j++ )
				{
					if (allValue == unmanagedHostList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					if(allValue.indexOf('Real_user_monitor') == 0)
					{
						rumCount++;
						if(allValue.indexOf(siteForComp) > 0)
						{
							isSameComp = true;
						}
					}
					Arr[Arr.length]=allValue;
				}
			}
			var isSiteAssociated = publicJSON['isSiteAssociated'];
			//if(isSiteAssociated == 'true' && !isSameComp)
			//{
				//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.RumComp']+siteForComp+publicJSON['screenLabels']['admin.common.RumAlreadyAssociated']+'. '+publicJSON['screenLabels']['admin.common.CannotAssociated']+'.');
				//return;
			//}
			//if(rumCount>1)
			//{
				//Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.MoreRum']+'. '+publicJSON['screenLabels']['admin.common.OnlyOneRumAssociation']+'.');
				//return;
			//}
			var tempmanagedHostList = Arr;
			var managedHostList = tempmanagedHostList.toString();
			var segTokCount = publicJSON['segTokCount'];
			var aggregatemappingsite = '';
			var proceed='true';
			var buttonText = Ext.getCmp('UpdateBTN').getText();
			if(segTokCount >= 0)
			{
				if(buttonText=="Add")
				{
					if (managedHostList=="")
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please choose a component']);
						Ext.getCmp('itemselectHostsForService').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHostsForService').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHostsForService').getStore().resumeEvents();
						Ext.getCmp('itemselectHostsForService').setValue(publicJSON['existingComponentsArr']);
						return;
					}
					
				}
				else
				{
					if(isAggregateSite=='true')
					{
						aggregatemappingsite = Ext.getCmp('mappingcombo').getValue();
						if(aggregatemappingsite == '-1')
						{
							Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please select a site to map']);
							return false;
						}
						else
							proceed='true';
					}
					else
						proceed='true';
				}
			}
			else
				proceed='true';
			
			/*var flagEnable = false;
			var managedHost_Only = new Array();
			var managedStr = publicJSON['existingHosts'];
			managedStr = ","+managedStr+",";
			var newlyManagedHost="";
			var newlyManagedHostTokens = managedHostList.split(",");
			for(i = 0; i < newlyManagedHostTokens.length; i++)
			{
				newlyManagedHost = newlyManagedHostTokens[i];
				if(managedStr.indexOf(","+newlyManagedHost+",") == -1)
				{
					managedHost_Only[i] = newlyManagedHost;
					flagEnable = true;
				}
			}

			var flagDisable = false;
			var unManagedHosts_Only = new Array();
			var unManagedStr = publicJSON['notExistingHosts'];
			var unmanagedHostListVal = unmanagedHostList.toString();
			var newlyUnManagedHost="";
			var newlyUnManagedHostTokens = unmanagedHostListVal.split(",");
			unManagedStr = ","+unManagedStr+",";
			for(i = 0; i < newlyUnManagedHostTokens.length; i++)
			{
				newlyUnManagedHost = newlyUnManagedHostTokens[i];
				if(unManagedStr.indexOf(","+newlyUnManagedHost+",") == -1)
				{
					unManagedHosts_Only[i] = newlyUnManagedHost;
					flagDisable = true;
				}
			}*/
			
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show(); 

			Ext.Ajax.request({
				url: 'Services/data/EgConfigSitesJson.jsp?site='+encodeURIComponent(s_site)+"&modify="+modify+"&validate=true"+"&segment="+encodeURIComponent(s_segment)+"&service="+encodeURIComponent(s_service)+"&zone="+encodeURIComponent(s_zone)+'&aliasname='+encodeURIComponent(s_alias)+'&isAggregateSite='+isAggregateSite+"&segmentFromTopo="+segmentFromTopo+"&zoneFromTopo="+zoneFromTopo,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonObj = Ext.decode( jsonText );
						var isValidName = jsonObj['screenLabels']['isValid']; 
						if(isValidName=="false")
						{
							Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.common.ErroInAddingService']);
							myMask.hide(); 
							return;
						}
						else
						{
							var oldServiceName='';
							if(modify=="true")
							{
								oldServiceName = publicJSON['oldServiceName'];
							}
							var previousValues=publicJSON['previousValues'];
							var oldcomps=publicJSON['oldcomps'];
							var currentRemovedElements = publicJSON['currentRemovedElements'];

							var hiddenProcessObj = Ext.getCmp('hiddenprocesscontainer');
							var temp = {
								xtype: 'hiddenfield',
								name: 'srvlist',
								value: managedHostList
							};
							hiddenProcessObj.add(temp);

							temp = {
								xtype: 'hiddenfield',
								name: 'unassolist',
								value: unmanagedHostList
							};
							hiddenProcessObj.add(temp);

							var resultUrl  = updateUrl+"sitename="+encodeURIComponent(s_site)+"&modify="+modify+"&segment="+encodeURIComponent(s_segment)+"&service="+encodeURIComponent(s_service)+"&zone="+encodeURIComponent(s_zone)+"&mode="+publicJSON['mode']+'&alias='+encodeURIComponent(s_alias)+'&isAggregateSite='+isAggregateSite+'&aggregatemappingsite='+aggregatemappingsite;

							if(modify=='true')
							{
									temp = {
									xtype: 'hiddenfield',
									name: 'oldComps',
									value: oldcomps
								};
								hiddenProcessObj.add(temp);

									temp = {
									xtype: 'hiddenfield',
									name: 'oldServiceName',
									value: oldServiceName
								};
								hiddenProcessObj.add(temp);

									temp = {
									xtype: 'hiddenfield',
									name: 'previousValues',
									value: previousValues
								};
								hiddenProcessObj.add(temp);

									temp = {
									xtype: 'hiddenfield',
									name: 'currentRemovedElements',
									value: currentRemovedElements
								};
								hiddenProcessObj.add(temp);
								resultUrl = resultUrl;
							}

							resultUrl = resultUrl+"&imageName="+imageName+"&domainName="+domainName;
							var hiddenSrvObj = Ext.getCmp('componentservice').getForm();
							hiddenSrvObj.submit({
							url: resultUrl,
							method: 'POST',
							timeout: 500000,
							standardSubmit: false,
							success: function( form,action )
							{
								myMask.hide(); 
								var jsTxt = action.response.responseText;

								if ( !Ext.isEmpty( jsTxt ) && action.response.status == 200 )
								{
									var jsObj = Ext.decode( jsTxt );
									var isUpdated = jsObj['isUpdated'];
									var isEmpty = jsObj['isEmpty'];
									if(isUpdated=='true')
									{
										var hiddenTopoObj = Ext.getCmp('hiddenTopocontainer');
										var tempTopo = {
											xtype: 'hiddenfield',
											name: 'ass_servers',
											value: managedHostList
										};
										hiddenTopoObj.add(tempTopo);

										tempTopo = {
											xtype: 'hiddenfield',
											name: 'segment',
											value: s_segment
										};
										hiddenTopoObj.add(tempTopo);

										tempTopo = {
											xtype: 'hiddenfield',
											name: 'service',
											value: s_service
										};
										hiddenTopoObj.add(tempTopo);

										var qs="site="+encodeURIComponent(s_site)+"&zone="+encodeURIComponent(s_zone)+"&action=modify&alias="+encodeURIComponent(s_alias)+"&comefrom=Egconfigsitesp"+"&segment="+encodeURIComponent(s_segment);
										//if(comeFrom!=null && comeFrom=='topology')
										//{
											qs=qs+"&returnToTopology="+returnToTopology;
										//}
										qs=qs+"&returnToMain="+returnToMain+"&mainUrl="+mainUrl;

										var hiddenTopoProcessObj = Ext.getCmp('componentservice').getForm();

										hiddenTopoProcessObj.submit({
											url: 'Services/data/EgLogicalTopologyJson.jsp?'+qs+"&segmentFromTopo="+s_segment+"&zoneFromTopo="+zoneFromTopo,
											method: 'POST',
											timeout: 500000,
											standardSubmit: false,
											success: function( form,action )
											{
												var jsonText = action.response.responseText;
												publicJSON = Ext.decode(jsonText);
												var tabPanelObj = Ext.getCmp('maintab');
												if(isEmpty=='true')
												{
													var tabPanelObj = Ext.getCmp('maintab');
													tabPanelObj.child('#mainServViewTab').tab.show();
													tabPanelObj.setActiveTab(0);
													appCnt.segmentComboLoad();
													tabPanelObj.child('#topoItemsTab').tab.hide();
													Ext.getCmp('goToTopoPage').hide();
													topoController.afterMainRender(jsonText);
													topoController1.afterMainRender(jsonText);
												}
												else
												{
													if (managedHostList=="")
													{
														var tabPanelObj = Ext.getCmp('maintab');
														tabPanelObj.child('#mainServViewTab').tab.show();
														tabPanelObj.setActiveTab(0);
														appCnt.loadServiceTabData();
														appCnt.segmentComboLoad();
														topoController.afterMainRender(jsonText);
														topoController1.afterMainRender(jsonText);
													}
													else
													{
														tabPanelObj.child('#segmentTab').tab.show();
														topoController.afterMainRender(jsonText);
														tabPanelObj.setActiveTab(1);
														tabPanelObj.child('#topoItemsTab').tab.show();
														Ext.getCmp('goToTopoPage').show();
														topoController1.afterMainRender(jsonText);
													}
												}
												hiddenTopoObj.removeAll();
											},
											failure: function()
											{
												hiddenTopoObj.removeAll();
											}
										});
									}
									else
									{
										Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please choose a component']);
										Ext.getCmp('itemselectHostsForService').getStore().suspendEvents(true);
										Ext.getCmp('itemselectHostsForService').getStore().loadRawData(publicJSON['itemSelectorValue']);
										Ext.getCmp('itemselectHostsForService').getStore().resumeEvents();
										Ext.getCmp('itemselectHostsForService').setValue(publicJSON['existingComponentsArr']);
										hiddenProcessObj.removeAll();
										Ext.Msg.show({
											title : pageTitle,
											msg : jsObj['screenLabels']['ErrorInUpdation']+'.',
											icon : 'iconError',
											buttons : Ext.Msg.OK
										});
										return false;
									}
									/*var the_iframe = Ext.getCmp('topologyFrame').getEl().dom;
									var topologyUrl = publicJSON['graphData'];
									the_iframe.src = topologyUrl;*/

								}
								hiddenProcessObj.removeAll();
							},
							failure: function(form, action)
							{
								myMask.hide(); 
								hiddenProcessObj.removeAll();
							}
							});
						}
					}
				}
			});
		}
	},
	loadTopoDiagram: function(siteName,segment,reqFrom)
	{
		var topoController = this.getController('Services.controller.LogicalTopology');
		var s_segment = segment;
		var siteName = siteName;
		var s_zone='';
		if(Ext.getCmp('zonecombo').getValue() != undefined)
			s_zone = Ext.getCmp('zonecombo').getValue();
		else
			s_zone = 'all';

		var associatedComps = publicJSON['associatedComponentsArr'];
		if(ass_servers == null || ass_servers == "")
		{
			if(associatedComps != null && associatedComps != "" && associatedComps != undefined)
			{
				ass_servers = associatedComps;
			}
		}

		Ext.Ajax.request({
			url: 'Services/data/EgLogicalTopologyJson.jsp',
			method: 'POST',
			params: 'site='+encodeURIComponent(siteName)+'&action=modify&zoneFromTopo='+zoneFromTopo+'&zone='+encodeURIComponent(s_zone)+'&comefrom=Egconfigsitesp&segmentFromTopo='+segmentFromTopo+'&mainUrl='+mainUrl+'&returnToMain='+returnToMain+'&returnToTopology='+returnToTopology+'&segment='+encodeURIComponent(s_segment)+'&ass_servers='+encodeURIComponent(ass_servers),
			timeout: 500000,
			success: function(response)
			{
				var jsonText = response.responseText;
				if(reqFrom != "serviceComboLoad")
				{
					var tabPanelObj = Ext.getCmp('maintab');
					tabPanelObj.child('#topoItemsTab').tab.show();
					tabPanelObj.setActiveTab(2);
				}
				topoController.afterMainRender(jsonText);
			},
			failure: function()
			{
			}
		});
	}
});



function validateAlias()
{
	var s_site='';
	if(modify=='true')
		s_site = Ext.getCmp('servicecombo').getValue();
	else if(modify=="false")
		s_site = Ext.getCmp('servicename').getValue();

	var s_alias = Ext.getCmp('siteAlias').getValue();
	var max_no_of_alias = eval(6);

	if(s_alias.indexOf(",") > -1)
	{
		var alias_list =  s_alias.split(',');
		if(alias_list.length > max_no_of_alias)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Maxnumber']);
			return false;
		}
		for(var x=0;x < alias_list.length;x++)
		{
			if(alias_list[x] == s_site)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.sameName']);
				return false;
			}
			else if(!checkUniqueAlias(alias_list[x]))
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.unique name']);
				return false;
			}
			else if(alias_list[x].length > 128)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Maxlength']);
				return false;
			}
		}
	}
	else
	{
		if(s_alias == s_site)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.sameName']);
			return false;
		}
		else if(s_alias.length > 128)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Maxlength']);
			return false;
		}
	}
	return true;
}
function checkUniqueAlias(aliasname)
{
	var s_alias = Ext.getCmp('siteAlias').getValue();
	var alias_list =  s_alias.split(',');
	var count = 0;

	for(var k=0;k < alias_list.length;k++)
	{
		if(alias_list[k] == aliasname)
		{
			count = count + 1;
		}
	}
	if(count > 1)
	{	
		return false;
	}
	else
	{
		return true;
	}
}

function getSegmentNameFromURL(url)
{
	var segment = "";
	if(url != null && url != "" && url != undefined)
	{
		var temp1 = url;
		var temp2 = temp1.split("&");
		for(var i= 0 ; i < temp2.length; i++)
		{
			var val = temp2[i];
			if(val.indexOf("segment=") > -1)
			{
				var temp = val.split("=");
				segment = temp[1];
				break;
			}
		}
	}
	return segment;
}



