Ext.define('Services.controller.ServiceTopology',{
	extend:'Ext.app.Controller',
	views:['ConfigureSegment'],
	refs:[
		{selector:'configuresegment', ref:'configuresegment'}
	],

	init:function(){
		this.buildFieldData()
		this.control({
			'configuresegment':
			{
				'afterrender': this.afterMainRender
			}
		});
	},

	buildFieldData: function(url){
		var jsonText;
		Ext.Ajax.request({
			url: 'Services/data/EgLogicalTopologyJson.jsp',
			method: 'POST',
			params:url+"&segmentFromTopo="+segmentFromTopo+"&zoneFromTopo="+zoneFromTopo,
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		return jsonText;
	},

	afterMainRender : function(jsonText){
		publicJSON = Ext.decode( jsonText );
		//var tabPanelObj = Ext.getCmp('maintab');
		//tabPanelObj.child('#segmentTab').tab.show();
		var seg = publicJSON['segmentFromTopo'];
		var serverval = publicJSON['itemSelectorValue'];
		
		if (seg != null && seg != 'Independent_servers')
		{
			if (serverval != null && serverval.length > 0)
			{	
				
				Ext.getCmp('configuresegment').setTitle("Preview/Associate and Dissociate Elements");
				Ext.getCmp('field1').show();
				Ext.getCmp('field1').setTitle("Associate/Dissociate Elements of '"+seg+"'");

				Ext.getCmp('itemselectComps').show();
				Ext.getCmp('topoUpdateCtn').show();
				Ext.getCmp('itemselectComps').getStore().suspendEvents(true);
				Ext.getCmp('itemselectComps').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectComps').getStore().resumeEvents();
				Ext.getCmp('itemselectComps').setValue(publicJSON['disassociatedComponentsArr']);
			}
			else
			{
				Ext.getCmp('configuresegment').setTitle("Preview");
				Ext.getCmp('field1').hide();
				Ext.getCmp('itemselectComps').hide();
				Ext.getCmp('topoUpdateCtn').hide();
			}
		}
		else
		{
			Ext.getCmp('configuresegment').setTitle("Preview");
			Ext.getCmp('field1').hide();
			Ext.getCmp('itemselectComps').hide();
			Ext.getCmp('topoUpdateCtn').hide();
		}
		
		Ext.getCmp('configuresegment').add({
			xtype:'panel',
			cls:'datapanel',
			title: panelHeader,
			id:'indtopologyPanel',
			margin: '5 0 10 0',
			frame: false,
			border: true,
			parent:this,
			flex: 1,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			items : [
				{
					xtype: "component",
					id:'indtopologyFrame',
					name:'indtopologyFrame',
					html:'',
					flex: 1
				}
			],
			tools: [
				{
					xtype: 'container',
					margin: '0 0px 0 0px',
					cls: 'iconBg',
					items: [{
						xtype: 'button',
						iconCls: 'iconAutofit',
						itemId:'indiconAutofit',
						id: 'indiconAutofit',
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Fit'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px'
						}
					}]
				},
				{
					xtype: 'tbseparator',
				},
				{
					xtype: 'container',
					margin: '0 0px 0 0px',
					cls: 'iconBg',
					items: [{
						xtype: 'button',
						iconCls: 'iconSave',
						itemId:'indiconSave',
						id: 'indiconSave',
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Save position'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px'
						}
					}]
				},
				{
					xtype: 'tbseparator',
				},
				{
					xtype: 'container',
					margin: '0 0px 0 0px',
					cls: 'iconBg',
					items: [{
						xtype: 'button',
						iconCls: 'iconRefresh',
						itemId:'indiconReset',
						id: 'indiconReset',
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Reset position'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px'
						}
					}]
				},
				{
					xtype: 'tbseparator',
				},
				{
					xtype: 'container',
					margin: '0 0px 0 0px',
					cls: 'iconBg',
					hidden:true,
					items: [{
						xtype: 'button',
						iconCls: 'iconMaximize',
						itemId:'indiconMaximize',
						id: 'indiconMaximize',
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'New Window'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px'
						}
					}]
				},
				{
					xtype: 'tbseparator',
					hidden:true,
				},
				{
					xtype: 'button',
					cls:'button20',
					id:'indgoToConfigureService',
					name:'indgoToConfigureService',
					text: buttonTitle1,
					width: 110,
					margin: '2 0 2 3'
				}
			]
		});
		
		Ext.getCmp('indtopologyPanel').setTitle(panelHeader+"&nbsp;FOR '"+publicJSON['siteServiceName']+ "'");	

		var topologyUrl = publicJSON['indgraphData'];
		Ext.getCmp('indtopologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px solid blue"></iframe>');

		var topoController1 = this.getController('Services.controller.LogicalTopology');
		topoController1.afterMainRender(jsonText);
	}

});



