var originalShow = Ext.window.MessageBox.prototype.show;

Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;

			Ext.applyIf(cfg,{width : tmpWidth});
		}
		originalShow.apply(this, arguments);
	},

	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},

	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.define('Services.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'viewport',

	requires: [
		'Ext.ux.ItemSelectorRv',
		'Services.view.Main',
		'Services.view.ComponentServices',
		'Services.view.TopologyItems',
		'Services.view.ConfigureSegment'
	],

	initComponent: function() {

		Ext.get('loadmask').remove();

		this.items = [
			{
				xtype: 'componentservices'
			}
		];

		this.callParent();
	},
	listeners: {
		'beforerender': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				Ext.getCmp('mainComponentServices').closable=(true);
			}
		},
		'beforeadd': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				if (!Ext.isEmpty(Ext.getCmp('mainComponentServices')))
				{
					Ext.getCmp('mainComponentServices').closable=(true);
				}
			}
		}
	}

});



