var ht = Ext.getBody().getViewSize().height;
var wt = Ext.getBody().getViewSize().width;

Ext.define('Services.view.maximizeWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.maximizewindow',
	id : 'maximizewindow',
	autoScroll: false,
	title: "Topology",
	width: (wt-16),
	height: ht,
	modal: true,
	closeAction: 'destroy',
	listeners: {
		close : function () {
			var topologyUrl = window.frames[0].openBigDiv(0);
			topologyUrl = topologyUrl.replace("EgAdminServiceD3JS.jsp","EgTopologyAS.jsp");
			if (!Ext.isEmpty(Ext.getCmp('indtopologyFrame')))
			{
				Ext.getCmp('indtopologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px solid blue"></iframe>');
			}
			if (!Ext.isEmpty(Ext.getCmp('topologyFrame')))
			{
				Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" scrolling="no" style="width:100%;height:100%;border:0px solid blue"></iframe>');
			}					
		}
	},
	items: [
		{
			xtype: "component",
			id:'topologyMaxFrame',
			name:'topologyMaxFrame',
			html:''
		}
	],
	tools: [
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconAutofit',
				itemId:'iconAutofitPopup',
				id: 'iconAutofitPopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Fit'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
			hidden:true
		},
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconSavePopup',
				itemId:'iconSavePopup',
				id: 'iconSavePopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Save position'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
		},
		{
			xtype: 'container',
			margin: '0 0px 0 0px',
			cls: 'iconBg',
			items: [{
				xtype: 'button',
			   iconCls: 'iconRefreshPopup',
				itemId:'iconResetPopup',
				id: 'iconResetPopup',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Reset position'
						});
					}
				},
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		},
		{
			xtype: 'tbseparator',
		}
	]
});



