<%

/****************************************************************************
*	Name			:	EgAdminServiceD3JS.jsp
*	Version			:	eG 6.2v
*	Purpose			:	To display the service topology by using D3JS
*	Creation Date	:	01-JUN-2015

*---Prantish A
*****************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ taglib prefix = "egui" uri="../../../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String topologySkin = _user.getAdminSkin();
	String site = request.getParameter("site");
	String segmentName = request.getParameter("segment");
	String phyTopology = request.getParameter("physical_topology");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");
	String autoPosition = request.getParameter("autoPosition");
	String seglist = request.getParameter("seglist");
	String csrfToken = request.getParameter("com.eg.CSRF_NONCE");

	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini";
	IniFile iniFile = new IniFile(iniFilePath);
	String topologyRenderingMode = iniFile.getValue("TOPOLOGY_OPTIONS", "TopologyRenderingMode");
	//String topologyPosition = iniFile.getValue("TOPOLOGY_OPTIONS", "TopologyPosition");
	String link = "";
	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;


	if(topologyRenderingMode == null){
		topologyRenderingMode = "manual";
	}
	/**
	if(topologyPosition == null){
		System.out.println("topologyPosition == null");
		topologyPosition = "left";
	}
	*/

	
	StringBuffer topoUrl = new StringBuffer();
	topoUrl.append("/final/admin/Services/data/EgTopologyJSON.jsp?physical_topology=0&segment=");
	topoUrl.append(EgURLEncoder.encode(segmentName, "UTF-8"));
	topoUrl.append("&site=");
	topoUrl.append(site);
	topoUrl.append("&fromPage=admin&default=");
	topoUrl.append(defaultPos);
	topoUrl.append("&topologyRenderingMode=");
	topoUrl.append(topologyRenderingMode);
	topoUrl.append("&autoPosition=");
	topoUrl.append(autoPosition);
	topoUrl.append("&com.eg.CSRF_NONCE="+csrfToken);
	link = topoUrl.toString();
	
%>
<!doctype html>
<!--Here css cls is added to html tag for popup window, when the theme is dark. -->
<%
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark")) {
%>
	<html class = "content-frame">
<% 
	} else {
%>
	<html>
<% 
	} 
%>
<head>
<title><%=site%></title>
<link rel="stylesheet" href="/final/styles/jquery-ui.min.css">
<egui:skin ui="admin"/>

<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script src="/final/scripts/d3.min.js" charset="utf-8"></script>
<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/jquery/jquery-ui.js"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script type="text/javascript" src="/final/scripts/admind3Topology.js"></script>

<meta charset="utf-8">
<script>
var compPosition = new Map;
var csrfToken = '<%=csrfToken%>';

function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}

function savePosition(frameid)
{
	savePositions("save");
}

function deleteZoomPositionsforMonitor()
{
	var segmentname ='<%=segmentName%>';
	//if(segmentname == 'Independent_servers')
	{
		var siteName = '<%=site%>';
		segmentname = siteName+"~|#|~"+segmentname+"~|#|~Service~Monitor";
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	//var zoomHidden = document.getElementById("zoom").value;
	var params;
	//if (str == 'zoom')
	{
		params = "action=zoom&segment="+segmentname+"&zoom=-1";
		params += "&translate=";
	}
	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status != 200) 
				{
					//alert("Error occured while saving. Please try again ...."+xmlhttp.status);
				}
				else
				{					
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}

function savePositions(str)
{
	var segmentname = '<%=segmentName%>';
	var siteName = '<%=site%>';

	var topologyRenderingMode = '<%=topologyRenderingMode%>';
	var url = '/final/servlet/com.eg.EgSegmentPositionServlet';

	segmentname = siteName+"~|#|~"+segmentname;

	var	pan_X ;
	var	pan_Y ;
	var zoomVal = $('.slider').slider("option", "value");
	
	
	try {
		pan_X = int_X;
		pan_Y = int_Y;
	} catch(e){
		//pan_X = $( window ).width()/2;// default pan X value is -8
		pan_X = -8;// default pan X value is -8
		
		pan_Y = -8;// default pan Y value is -8
		//pan_Y = $( window ).height()/2;// default pan Y value is -8
	}
	
	
	//var zoomHidden = document.getElementById("zoom").value;
	var zoomVal = $('.slider').slider("option", "value");
	var zoomHidden = 100;
	var params;
	if(str == 'save')
	{
		var keys = compPosition.listKeys();
		params ='action=' + str + '&segment=' + segmentname + '&total=' + keys.length + '&zoom=' + zoomVal + '&pan_X=' + pan_X + '&pan_Y=' + pan_Y + '&topologyRenderingMode=' + topologyRenderingMode; 
		
		for(var k=0; k < keys.length; k++)
		{
			var key = keys[k];
			var val = compPosition.get(key);
			params = params + '&key' + k + '=' + key + '&val' + k + '=' + val;
		}
	}
	

	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST", url, true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status == 200) 
				{
					if(str == 'save')
					{
						Ext.Msg.show({
							title : 'SERVICES',
							msg : 'Component positions have been saved successfully.',
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
						deleteZoomPositionsforMonitor();
					}
				}
				else 
				{
					Ext.Msg.show({
						title : 'SERVICES',
						msg : 'Error occured. Please try again ...',
						icon : 'iconExclamation',
						buttons : Ext.Msg.Ok
					});
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}
function moveEnd(obj)
{
	
	var key = obj.compID;
	var val = obj.x + '#' + obj.y;
	compPosition.put(key, val);

}
//function openBigDiv()
//{
	//var mySegment = '<%=segmentName%>';
	//var site ='<%=site%>';
	//var phyTopo = '<%=phyTopology%>';
	//var screenWidth = screen.width;
	//var screenheight = screen.height;
	//var myUrl = 'Services/data/EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(mySegment) + '&view=full&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+"&com.eg.CSRF_NONCE="+csrfToken;

	//newwindow =  window.open(myUrl,'Topology','width=' + screen.width + ',height=' + screen.height + ', status=yes,scrollbars=no,resizable=yes');
	//if (window.focus) {newwindow.focus()}
		//return false;
//}

function openBigDiv(frameid)
{
	var myurl = openBigDivs(frameid);
	return myurl;
}

function openBigDivs(frameid)
{
	var mySegment = '<%=segmentName%>';
	var site = '<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var myUrl = "";
	if ("<%=seglist%>" != "null")
	{
		myUrl = 'Services/data/EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(mySegment) + '&view=full&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+"&com.eg.CSRF_NONCE="+csrfToken+"&seglist="+encodeURIComponent("<%=seglist%>");
	}
	else
	{
		myUrl = 'Services/data/EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(mySegment) + '&view=full&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+"&com.eg.CSRF_NONCE="+csrfToken;
	}
	
	return myUrl;
}

function autoPositions()
{
	var segmentname ='<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	//var zoom = document.getElementById('zoom').value;
	var zoom = 100;
	var isfull = '<%=isFull%>';
	var myUrl = 'EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(segmentname) + '&default=false&zoom=' + zoom + '&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo + '&autoPosition=true&com.eg.CSRF_NONCE='+csrfToken;
	if(isfull == 'true')
		myUrl = myUrl + '&view=full';

	setTimeout(function(){
		window.location = myUrl;
	}, 0);
}

function resetPostion(frameid)
{
	resetPositions();
}
function autoFit(frameid)
{
	autoFit();
}

function autoFit()
{
	$('#fit').trigger('click');
}

function resetPositions()
{
	var segmentname ='<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	//var zoom = document.getElementById('zoom').value;
	var zoom = 100;
	var isfull = '<%=isFull%>';
	var myUrl = "";
	if ("<%=seglist%>" != "null")
	{
		myUrl = 'EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(segmentname) + '&default=true&zoom=' + zoom + '&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+'&com.eg.CSRF_NONCE='+csrfToken+"&seglist="+encodeURIComponent("<%=seglist%>");
	}
	else
	{
		myUrl = 'EgAdminServiceD3JS.jsp?segment=' + encodeURIComponent(segmentname) + '&default=true&zoom=' + zoom + '&site=' + encodeURIComponent(site) + '&physical_topology=' + phyTopo+'&com.eg.CSRF_NONCE='+csrfToken;
	}
	if(isfull == 'true')
		myUrl = myUrl + '&view=full';
		setTimeout(function(){
		window.location = myUrl;
	}, 0);
}
</script>
<egui:skin ui="admin"/>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script>
	Ext.onReady(function(){
		window.parent.Ext.getCmp("iconSave").enable();
		window.parent.Ext.getCmp("iconReset").enable();
		window.parent.Ext.getCmp("iconMaximize").enable();
	});
</script>
</head>
<body>
<div id="diagram"></div>
<div  class="div_scroll" style="width:50%;height:auto;border:0px solid black;" id="alarmsListDiv">
</div>

<script>

function loadPopup(qUrl)
{	
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?") + 1);
		tmpUrl = 'componentMeasureTabSet.jsp?'+tmpUrl;
		window.open(tmpUrl, 'GRAPHS', 'toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}

function getPaperHeight(paperHeight)
{	
	var winHeight = $( window ).height();
	if(paperHeight < winHeight){
		paperHeight = winHeight;
	}
	return paperHeight;
}
function getPaperWidth(paperWidth)
{	
	var winWidth = $( window ).width();
	if(paperWidth < winWidth){
		paperWidth = winWidth;
	}
	return paperWidth;
}
$(window).ready(function(){
	isAutoFit = ('<%=topologyRenderingMode%>' == 'auto') ? true : false;
	var url = '<%=link%>';
	Ext.Ajax.request({
			url: url,
			success: function(respons)
			{
				if (respons.status == 200 && !Ext.isEmpty(respons.responseText))
				{
					var response = respons.responseText;
					var jsonData = Ext.decode(response);
					var rootJson = jsonData['rootJson'];
					var allNodes = rootJson.nodes;

					for(var i = 0; i < allNodes.length; i++)
					{
						var key = allNodes[i].compID;
						var val = allNodes[i].x + '#' + allNodes[i].y;
						compPosition.put(key, val);
					}
					var paperHeight = jsonData.rootJson.paper['height'];
					var paperWidth = jsonData.rootJson.paper['width'];
					var zoomLevel = jsonData.rootJson.paper['zoomLevel'];
					paperHeight = getPaperHeight(paperHeight);
					paperWidth = getPaperWidth(paperWidth);

					var zoomLevel = jsonData.rootJson.paper['zoomLevel'];
					var pan_X = jsonData.rootJson.paper['pan_X'];
					var pan_Y = jsonData.rootJson.paper['pan_Y'];
					paperHeight = getPaperHeight(paperHeight);
					paperWidth = getPaperWidth(paperWidth);

					if(zoomLevel == null || zoomLevel.length == 0 || zoomLevel == 100){
						zoomLevel = 1;// default zoom value is 1
					}
					if( pan_X == null || pan_X.length == 0 ){
						pan_X = -8;// default pan X value is -8
					}
					if( pan_Y == null || pan_Y.length == 0 ){
						pan_Y = -8;// default pan Y value is -8
					}
					
					$('#diagram').renderSvg({
						renderTo: '#diagram',
						collideLayout: isAutoFit,
						draggable: true,
						enableFitLayout: true,
						zoom: true,
						initialX: pan_X,
						initialY: pan_Y,
						width: paperWidth+15,
						height: paperHeight+10,
						//width: Ext.getBody().getViewSize().width+15,
						//height: Ext.getBody().getViewSize().height+15,
						layoutAlign:'center',
						//enableFitLayout: true,
						default_zoom:zoomLevel,
						data: jsonData
					}); 
				}
			},
			failure: function(){
				Ext.Msg.show({
						title: 'Topology',
						msg: 'Request failed',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
			}
		}); 
/**
$('#diagram').renderSvg({
	renderTo: '#diagram',
	height:1500,
	zoom:true,
	width:$('#diagram').width(),
	url:url
});
**/
})
</script>

</body>
</html>


<% 
%>