Ext.define('SmItInfrastructure.controller.Main',{
	extend: 'Ext.app.Controller',
	views:[
			'Main',
			'ComponentNameSummary',
			'ResultPanel'
	],
	refs:[
		{selector:'main', ref:'main'}
	],
	init:function()
	{
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.initInfraStructureView
			},
			'main combo[id="managerId"]':
			{
				'select':this.mangerIdOnChange
			},
			'main combo[id="elementType"]':
			{
				'select':this.elementTypeChanged
			},
			'main combo[id="compTypeList"]':
			{
				'select':this.compTypeChanged
			}
		})
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : 'SmItInfrastructure/data/EgItInfrastructureJson.jsp?selectedManager=-1&selectedElement=-1&selectedType=-1',
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	mangerIdOnChange : function(obj)
	{
		var me = this;
		var s_criteria = Ext.getCmp('elementType');
		var s_userOption = Ext.getCmp('compTypeList');
		var selectedMgrId = obj.getValue();
		if(selectedMgrId=='-1')
		{
			Ext.getCmp('elementType').setValue('-1');
			Ext.getCmp('compTypeList').setValue('-1');
			Ext.getCmp('elementType').hide();
			Ext.getCmp('compTypeList').hide();
			me.removeUsedGridPanels();
		}
		else
		{
			if(selectedMgrId != null && selectedMgrId!='-1')
			{
				var url = 'SmItInfrastructure/data/EgItInfrastructureJson.jsp?selectedManager='+selectedMgrId;
				Ext.Ajax.request({
					url : url,
					method: 'POST',
					async: false,
					success: function(response)
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);

						var ea_managerIdObj = Ext.getCmp('managerId');
						ea_managerIdObj.clearValue();
						ea_managerIdObj.getStore().loadRawData(publicJSON['managersArray']);
						ea_managerIdObj.setValue(publicJSON['selectedManager']);

						var elementTypeObj = Ext.getCmp('elementType');
						elementTypeObj.clearValue();
						elementTypeObj.getStore().loadRawData(publicJSON['elementsArray']);
						elementTypeObj.setValue(publicJSON['selectedElement']);

						Ext.getCmp('elementType').show();
						Ext.getCmp('compTypeList').hide();
						me.removeUsedGridPanels();
					}
				});
			}
			else
			{
				Ext.getCmp('elementType').hide();
				Ext.getCmp('compTypeList').hide();
				me.removeUsedGridPanels();
			}
		}
	},
	elementTypeChanged : function(obj)
	{
		this.removeUsedGridPanels();
		var me = this;
		var elementName = obj.getValue();

		if(elementName=='-1')
		{
			Ext.getCmp('compTypeList').setValue('-1');
			Ext.getCmp('compTypeList').hide();
			me.removeUsedGridPanels();
		}
		else
		{
			var selectedMgrId = Ext.getCmp('managerId').getValue();
			Ext.getCmp('compTypeList').show();
			if(elementName != null && (elementName=='components' || elementName=='aggregatecomponents'))
			{
				Ext.Ajax.request({
					url : 'SmItInfrastructure/data/EgItInfrastructureJson.jsp?selectedManager='+selectedMgrId+'&selectedElement='+elementName,
					method: 'POST',
					async: false,
					success: function(response)
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);

						var ea_managerIdObj = Ext.getCmp('managerId');
						ea_managerIdObj.clearValue();
						ea_managerIdObj.getStore().loadRawData(publicJSON['managersArray']);
						ea_managerIdObj.setValue(publicJSON['selectedManager']);

						var elementTypeObj = Ext.getCmp('elementType');
						elementTypeObj.clearValue();
						elementTypeObj.getStore().loadRawData(publicJSON['elementsArray']);
						elementTypeObj.setValue(publicJSON['selectedElement']);

						var compTypeListObj = Ext.getCmp('compTypeList');
						compTypeListObj.clearValue();
						compTypeListObj.getStore().loadRawData(publicJSON['compTypesArray']);
						compTypeListObj.setValue('-1');
					},
					failure:function(response)
					{
					}
				});
			}
			else
			{
				Ext.Ajax.request({
					url : 'SmItInfrastructure/data/EgItInfrastructureJson.jsp?selectedManager='+selectedMgrId+'&selectedElement='+elementName,
					method: 'POST',
					async: false,
					success: function(response)
					{
						publicJSON = Ext.decode(response.responseText);

						var ea_managerIdObj = Ext.getCmp('managerId');
						ea_managerIdObj.clearValue();
						ea_managerIdObj.getStore().loadRawData(publicJSON['managersArray']);
						ea_managerIdObj.setValue(publicJSON['selectedManager']);

						var elementTypeObj = Ext.getCmp('elementType');
						elementTypeObj.clearValue();
						elementTypeObj.getStore().loadRawData(publicJSON['elementsArray']);
						elementTypeObj.setValue(publicJSON['selectedElement']);

						var compTypeListObj = Ext.getCmp('compTypeList');
						compTypeListObj.clearValue();
						compTypeListObj.getStore().loadRawData(publicJSON['compTypesArray']);
						compTypeListObj.setValue('-1');

						Ext.getCmp('elementType').show();
						Ext.getCmp('compTypeList').hide();

						me.showComponentSummary();
					},
					failure:function(response)
					{
					}
				});
			}
		}
	},
	compTypeChanged : function(obj)
	{
		var me = this;
		var selectedType = Ext.getCmp('compTypeList').getValue();
		if(selectedType=='-1')
		{
			me.removeUsedGridPanels();
		}
		else
		{
			me.updateInfraData('SmItInfrastructure/data/EgItInfrastructureJson.jsp?selectedManager='+Ext.getCmp('managerId').getValue()+'&selectedElement='+Ext.getCmp('elementType').getValue()+'&selectedType='+selectedType);
			me.showComponentSummary();
		}
	},
	initInfraStructureView: function()
	{
		var me = this;
		Ext.getCmp('elementType').hide();
		Ext.getCmp('compTypeList').hide();
		if (publicJSON['hasManagedComponents'])
		{
			Ext.getCmp('viewControls').show();
			Ext.getCmp('resultpanel').hide();

			var managerIdObj = Ext.getCmp('managerId');
			managerIdObj.getStore().loadRawData(publicJSON['managersArray']);
			managerIdObj.setValue(publicJSON['selectedManager']);

			var elementTypeObj = Ext.getCmp('elementType');
			elementTypeObj.getStore().loadRawData(publicJSON['elementsArray']);
			elementTypeObj.setValue(publicJSON['selectedElement']);

			var compTypeListObj = Ext.getCmp('compTypeList');
			compTypeListObj.getStore().loadRawData(publicJSON['compTypesArray']);
			compTypeListObj.setValue(publicJSON['selectedType']);
		}
		else
		{
			Ext.getCmp('viewControls').hide();
			Ext.getCmp('resultpanel').show();
			Ext.getCmp('updateMsg').update('<div class = "iconInformation" style="margin:0 auto"></div><div class="commonErrorMsgText">No managed components found.</div><div>');
			this.getMain().doLayout();
		}
	},
	showComponentSummary : function()
	{
		Ext.getCmp('resultpanel').hide();
		this.removeUsedGridPanels();
		Ext.suspendLayouts();
		this.getMain().add({
			xtype : 'componentnamesummary',
			margin : 10,
			flex:1,
			title :'<span class="font_bold">'+ publicJSON['componentCount']+'</span>',
			store: new Ext.data.Store({
				fields: ['CompType','Name', 'ManagerName'],
				data: publicJSON['showcomponentNameWise'],
			})
		});
		Ext.resumeLayouts(true);
		var componentnamesummaryObj = Ext.getCmp('componentnamesummary');
		var gridCols = publicJSON['gridCols'];
		var col = 0;
		for (var key in gridCols) {
			componentnamesummaryObj.columns[col++].setText(gridCols[key]);
		}
		this.getMain().doLayout();

		var mygrid = Ext.getCmp('componentnamesummary');
		if(publicJSON['showCompTypeColumn']) {
			mygrid.columns[0].setVisible(true);
		}
		else {
			mygrid.columns[0].setVisible(false);
		}
	},
	removeUsedGridPanels : function()
	{
		if (Ext.getCmp('componentnamesummary') != undefined) {
			this.getMain().remove('componentnamesummary');
		}
	},
	updateInfraData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response) {
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	}
});



