Ext.define('SnmpGetSubtree.controller.Main',{
	extend:'Ext.app.Controller',

	refs: [
		{
			selector:'formitems',
			ref:'formitems'
		},
	],

	init: function() {
		
		getBtnId = this;
		ValidateBckId = this;

		appnCnt = this;
		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="snmpversion"]': {
				'select': this.snmpVersionChange
			},
			'formitems radiogroup[id="encryptflag"]': {
				'change': this.changeEncFlagValue
			},
			'formitems button[id="GetSubtree"]': {
				'click': this.snmpGetSubtree
			},
			'formitems button[id="SnmpWalk"]': {
				'click': this.snmpWalk
			}
		});
	},
		
	showMibTree: function(from, fieldName)
	{
		var urlStr = 'showMibFilesJson.jsp?from='+from+'&fieldName='+fieldName;
		Ext.Ajax.request(
		{
			url: 'SnmpGetSubtree/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		var me = this;
		Ext.create('Ext.window.Window', {
			height: 478,
			width: 800,
			title: 'MIB Tree',
			id:'mibWindow',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			listeners : {
				close : function()
				{
					Ext.Ajax.request({
					url:'SnmpGetSubtree/data/snmphelpJson.jsp?selectTab=addMeasureTab&testType=Snmp',
					method:'POST'
					});
				}
			},

			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						pack:'center'
					},
					border: false,
					padding : '10 0 7 0',
					items: [
						{
							xtype: 'button',
							text: 'OK',
							id: 'ok',
							name: 'ok',
							width: 80,
							cls: 'quickMenuWhiteButton',
							listeners: {
								el: {
									click: function() {
										var curObjOid = Ext.getCmp('objOid').getValue();
										if (fieldName == 'ObjectOID')
										{
											var windowObj = Ext.getCmp('modScriptMeasureWindow');
											if(windowObj != undefined || windowObj != null)
											{
												var old_filename = Ext.getCmp('measureform').getForm().findField('fileName').getValue();
												var new_filename = Ext.getCmp('fileList').getValue();
												if(new_filename != null && old_filename !== new_filename)
												{
													Ext.getCmp('measureform').getForm().findField('fileName').setValue(new_filename);
												}
											}
											else
											{
												Ext.getCmp('oidvalue').setValue(curObjOid);
											}
										}
										else if (fieldName == 'ElementOID')
										{
											Ext.getCmp('elementOid').setValue(curObjOid);
										}
										else if (fieldName == 'StatusOID')
										{
											Ext.getCmp('validOid').setValue(curObjOid);
										}
										Ext.getCmp('mibWindow').close();
									}
								}
							}
						}
					]
				}
			],

			items: [
				{
					xtype: 'container',
					border: true,
					style: 'border: 1px solid lightGrey',
					layout:{
						type:'vbox',
						align:'stretch'
					},
					flex: 0.5,
					margin: '5 0 5 5',
					items: [
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							margin: 5,
							items: [
								{
									xtype: 'combo',
									cls : 'dropdown',
									id:'fileList',
									name:'fileList',
									fieldLabel: 'MIB Files',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									labelSeparator: '',
									editable: false,
									labelWidth: 60,
									listeners:
									{
										select:{
											fn: function (id){
												me.mibFileSelection(from,fieldName,true);
											}
										}
									},
									columnWidth: 0.9
								},
								{
									xtype: 'button',
									iconCls:'iconUpload',
									columnWidth: 0.1,
									border:0,
									style:{
										'background':'none'
									},
									tooltip: 'Upload',
									margin : '0 0 0 10',
									listeners:
									{
										click:{
											fn: function (){
												me.uploadMibFile(from,fieldName);
											}
										}
									},
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							id: 'treepanalCntnr',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							border: 1,
							style: {
								borderColor: 'darkGrey',
								borderStyle: 'solid'
							},
							margin: '0 5 5 5',
							flex: 1
						},
						{
							xtype: 'textfield',
							fieldLabel: 'OID',
							id: 'objOid',
							labelSeparator: '',
							labelWidth: 60,
							margin: '0 5 5 5'
						}
					]
				},
				{
					xtype: 'container',
					border: true,
					style: 'border: 1px solid lightGrey',
					flex: 0.5,
					layout: {
						type:'hbox',
						align:'stretch'
					},
					margin: '5 5 5 0',
					items: [
						{
							xtype: 'container',
							id:'displayFieldCntnr',
							layout: {
								type:'vbox',
								align:'stretch'
							},
							defaults: {
								labelSeparator: '',
								labelAlign: 'top',
								readOnly: true
							},
							flex: 1,
							hidden: true,
							items: [
								{
									xtype: 'textfield',
									fieldLabel: 'Name',
									id: 'name',
									margin: '9 5 5 5'
								},
								{
									xtype: 'textarea',
									fieldLabel: 'Fullname',
									id: 'fullname',
									margin: '5 5 5 5'
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.5,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											fieldLabel: 'Access',
											id: 'access'
										},
										{
											xtype: 'textfield',
											fieldLabel: 'Syntax',
											id: 'syntax',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.33,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											fieldLabel: 'Status',
											id: 'status',
											columnWidth: 0.34
										},
										{
											xtype: 'textfield',
											fieldLabel: 'IsIndexNode',
											id: 'isIndexNode',
											margin: '0 0 0 5'
										},
										{
											xtype: 'textfield',
											fieldLabel: 'IsV2Trap',
											id: 'isV2Trap',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'textarea',
									fieldLabel: 'Description',
									id: 'description',
									margin: '5 5 5 5',
									rows: 6
								}
							]
						}
					]
				}
			]
		}).show();
		Ext.getCmp('fileList').getStore().loadRawData(publicJSON.mibFilesList);
		Ext.getCmp('fileList').setValue("-1");
	},
	uploadMibFile: function(from, fieldName)
	{
		var me = this;
		Ext.widget('window', {
			width: 350,
			height: 150,
			id: 'file',
			name: 'file',
			resizable: 'false',
			items: [{
				xtype: 'form',
				id: 'uploadform',
				name: 'uploadform',
				url: '../servlet/com.eg.EgUploadServlet',
				height: 150,
				items: [{
					xtype: 'fileuploadfield',
					cls: 'fileupload',
					id: 'file1',
					name: 'file1',
					labelSeparator: '',
					emptyText: 'No File Selected',
					fieldLabel: 'Choose File',
					labelAlign: 'top',
					width: 290,
					buttonText: 'Browse',
					margin: '15 0 0 15',
				},
				{
					xtype: 'button',
					text: 'upload',
					id: 'upload',
					name: 'upload',
					action: 'upload',
					cls: 'button20',
					align: 'center',
					margin: '15 0 0 140',
					handler: function (button, e)
					{
						var selFile = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
						var n = selFile.lastIndexOf("fakepath");
						if(n > 0)
						{
							selFile = selFile.substring(n+9);
						}
						var exten_str="";
						var exten_idx = selFile.lastIndexOf(".");
						if(exten_idx > 0)
							exten_str = selFile.substring(exten_idx);
						exten_str = exten_str.toLowerCase();
		
						var validate = true;
						if(!validateSingleByte(selFile))
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg01,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if(selFile=="")
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg02,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if (exten_str != ".txt" && exten_str != ".mib")
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg04,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}

						if (!validate)
						{
							return false;
						}
						else
						{
							if(publicJSON.existingFiles.indexOf(selFile)!=-1)
							{
								Ext.Msg.show({
									title: titleMsg,
									msg: alertMsg03,
									buttons: Ext.Msg.OKCANCEL,
									icon: 'iconConfirmation',
									fn: function(response) {
										if(response == 'ok') {
											var uploadformObj = Ext.getCmp('uploadform').getForm();
											if (uploadformObj.isValid())
											{
												uploadformObj.submit({
													method: 'POST',
													success: function (form, action) {
														var jsonText = action.response.responseText;
														var tmpResult = Ext.decode(jsonText);
														if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
														{
															button.up('.window').close();															
															Ext.Msg.show({
																title:titleMsg,
																msg: alertMsg16,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function(response)
																{
																	if (response == 'ok')
																	{
																		Ext.getCmp('mibWindow').close();
																		me.showMibTree(from, fieldName);
																	}
																}
															});
														}
														else
														{
															Ext.Msg.show({
																title: titleMsg,
																msg: tmpResult.statusMsg,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function(response)
																{
																	if (response == 'ok')
																	{
																		
																	}
																}
															});
														}
													},
													failure: function (form, action) 
													{
														Ext.Msg.alert('fileUpload', 'Not able to upload the selected MIB file. Please try again');
													}
												});
											}
										}
										else
										{
											button.up('.window').close();
										}
									}
								});
							}
							else
							{
								var uploadformObj = Ext.getCmp('uploadform').getForm();
								if (uploadformObj.isValid())
								{
									uploadformObj.submit({
										method: 'POST',
										success: function (form, action) {
											var jsonText = action.response.responseText;
											var tmpResult = Ext.decode(jsonText);
											if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
											{
												button.up('.window').close();
												Ext.Msg.show({
													title: titleMsg,
													msg: alertMsg16,
													buttons: Ext.Msg.OK,
													icon: 'iconInformation',
													fn: function(response)
													{
														if (response == 'ok')
														{
															Ext.getCmp('mibWindow').close();
															me.showMibTree(from, fieldName);
														}
													}
												});
											}
											else
											{
												Ext.Msg.show({
													title: titleMsg,
													msg: tmpResult.statusMsg,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
											}
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: titleMsg,
												msg: alertMsg17+'. '+alertMsg18,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								}
							}
						}
					}
				}],
				listeners: {
					afterrender: function () {
						var formObj = Ext.getCmp('uploadform');
						formObj.add({
							xtype: 'hidden',
							name: 'uploadMIB',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'fromMIBBrowser',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'comeFrom',
							value: 'icMIB'
						});
					},
				}
			}]
		}).show()
	},
	mibFileSelection: function(from,fieldName,action,isViaSelection)
	{
		var oid = '';
		var expanded = false;
		var selFile = Ext.getCmp('fileList').getValue();
		if (fieldName == 'ElementOID')
		{
			selElmtFile = selFile;
			elmtFldName = fieldName;
		}
		else if (fieldName == 'StatusOID')
		{
			selStusFile = selFile;
			stusFldName = fieldName;
		}
		else
		{
			selMibFile = selFile;
			oidFldName = fieldName; 
		}
		var src = 'mibTree.jsp?MibFileName='+selFile+'&fieldName='+fieldName+'&from='+from+'&expanded='+expanded;
		if(selFile != '-1')
		{
			var treeStore = Ext.create('Ext.data.TreeStore', {
				fields: [
					{name: 'text', type: 'string'},
					{name: 'leaf', type: 'boolean'},
					{name: 'expanded', defaultValue: true},
					{name: 'id', type: 'string'},
					{name: 'name', type: 'string'},
					{name: 'fullName', type: 'string'},
					{name: 'syntax', type: 'string'},
					{name: 'access', type: 'string'},
					{name: 'status', type: 'string'},
					{name: 'isIndexNode', type: 'boolean'},
					{name: 'isV2Trap', type: 'boolean'},
					{name: 'description', type: 'string'},
				]
			});
			Ext.Ajax.request({
				url: src,
				success: function(response){
					var data = Ext.decode(response.responseText);
					if(data.jsonarray == null || data.jsonarray.length > 0)
					{
						treeStore.setRootNode({
							text: 'MIB Tree',
							id:'',
							iconCls: 'iconTree',
							expandable: false,
							children: data.jsonarray
						});
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('displayFieldCntnr').show();
						Ext.getCmp('objOid').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var treePanel = Ext.create('Ext.tree.Panel',{
							flex: 1,
							rootVisible: true,
							//useArrows: true,
							animate: false,
							store : treeStore,
							listeners: {
								itemclick : function(view, record){
									if(record.get('id') != "")
									{
										Ext.getCmp('objOid').setValue(record.get('id'));
										Ext.getCmp('name').setValue(record.get('name'));
										Ext.getCmp('fullname').setValue(record.get('fullName'));
										Ext.getCmp('syntax').setValue(record.get('syntax'));
										Ext.getCmp('access').setValue(record.get('access'));
										Ext.getCmp('status').setValue(record.get('status'));
										Ext.getCmp('isIndexNode').setValue(record.get('isIndexNode'));
										Ext.getCmp('isV2Trap').setValue(record.get('isV2Trap'));
										Ext.getCmp('description').setValue(record.get('description'));
									}
								}
							}
						});
						Ext.getCmp('treepanalCntnr').add(treePanel);
						if(oid != '')
						{
							Ext.getCmp('objOid').setValue("");
							Ext.getCmp('name').setValue("");
							Ext.getCmp('fullname').setValue("");
							Ext.getCmp('syntax').setValue("");
							Ext.getCmp('access').setValue("");
							Ext.getCmp('status').setValue("");
							Ext.getCmp('isIndexNode').setValue("");
							Ext.getCmp('isV2Trap').setValue("");
							Ext.getCmp('description').setValue("");
							
						}
					}
					else
					{
						var resultMsg = "Invalid MIB file";
						if (!Ext.isEmpty(data.validMsg))
						{
							resultMsg = data.validMsg;
						}
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var emptyPanel = Ext.create('Ext.container.Container',{
							html: "<table align='center'><tr height=150><td valign='bottom' align='center'><div class='iconInformation'/></td></tr><tr><td valign='top' align='center'>"+resultMsg+"</td></tr></table>",
						});
						Ext.getCmp('objOid').setValue("");
						Ext.getCmp('treepanalCntnr').add(emptyPanel);
						Ext.getCmp('displayFieldCntnr').hide();
					}
				}
			});
		}
		else
		{
			Ext.getCmp('objOid').hide();
			Ext.getCmp('treepanalCntnr').hide();
			Ext.getCmp('displayFieldCntnr').hide();
		}
	},
	snmpVersionChange: function(obj) 
	{
		var snmpVersion = Ext.getCmp('snmpversion').getValue();
			//if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
			//{
				//snmpVersion = Ext.getCmp('snmpversion').getValue();
			//}
			//else if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
			//{
				//snmpVersion = Ext.getCmp('snmpversion').getValue();
			//}

			if (!Ext.isEmpty(snmpVersion) && snmpVersion != undefined && snmpVersion == "v3"  )
			{
				Ext.getCmp('snmpcommunity').hide();
				Ext.getCmp('snmpcommunity').setDisabled(true);

				Ext.getCmp('context').setDisabled(false);
				Ext.getCmp('context').show();
				Ext.getCmp('username').setDisabled(false);
				Ext.getCmp('username').show();
				Ext.getCmp('authpass').setDisabled(false);
				Ext.getCmp('authpass').show();
				Ext.getCmp('authpassconfirmpassword').setDisabled(false);
				Ext.getCmp('authpassconfirmpassword').show();
				Ext.getCmp('authtype').setDisabled(false);
				Ext.getCmp('authtype').show();
				Ext.getCmp('encryptflag').setDisabled(false);
				Ext.getCmp('encryptflag').show();
				appnCnt.changeEncFlagValue();
			}
			else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
			{
				Ext.getCmp('snmpcommunity').show();
				Ext.getCmp('snmpcommunity').setDisabled(false);
				appnCnt.snmpV3ParamDisabeld(obj);
			}
	},

	changeEncFlagValue: function(obj) {
		var encryptEnableVal=Ext.getCmp('encryptflagyes').getValue();	
		if (encryptEnableVal == false)
		{
			Ext.getCmp('encrypttype').setDisabled(true);
			Ext.getCmp('encryptpassword').setDisabled(true);
			Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
			Ext.getCmp('encrypttype').hide();
			Ext.getCmp('encryptpassword').hide();
			Ext.getCmp('encryptpasswordconfirmpassword').hide();
		}
		else
		{
			Ext.getCmp('encrypttype').setDisabled(false);
			Ext.getCmp('encryptpassword').setDisabled(false);
			Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
			Ext.getCmp('encrypttype').show();
			Ext.getCmp('encryptpassword').show();
			Ext.getCmp('encryptpasswordconfirmpassword').show();
		}		
	},
	snmpV3ParamDisabeld: function(obj) 
	{
		var value = obj.getBox().y;

		Ext.getCmp('context').setDisabled(true);
		Ext.getCmp('context').hide();
		Ext.getCmp('username').setDisabled(true);
		Ext.getCmp('username').hide();
		Ext.getCmp('authpass').setDisabled(true);
		Ext.getCmp('authpass').hide();
		Ext.getCmp('authpassconfirmpassword').setDisabled(true);
		Ext.getCmp('authpassconfirmpassword').hide();
		Ext.getCmp('authtype').setDisabled(true);
		Ext.getCmp('authtype').hide();
		Ext.getCmp('encrypttype').setDisabled(true);
		Ext.getCmp('encrypttype').hide();
		Ext.getCmp('encryptflag').setDisabled(true);
		Ext.getCmp('encryptflag').hide();
		Ext.getCmp('encryptpassword').setDisabled(true);
		Ext.getCmp('encryptpassword').hide();
		Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
		Ext.getCmp('encryptpasswordconfirmpassword').hide();

		//appCnt.changeEncFlagValue();

		//if (!Ext.isEmpty(Ext.getCmp('encryptflag')) && Ext.getCmp('encryptflag') != undefined)
		//{
			//Ext.getCmp('encryptflag').setDisabled(true);
			//Ext.getCmp('encryptflag').hide();
		//}
		//if (!Ext.isEmpty(Ext.getCmp('encrypttype')) && Ext.getCmp('encrypttype') != undefined)
		//{
		//}
		//if (!Ext.isEmpty(Ext.getCmp('encryptpassword')) && Ext.getCmp('encryptpassword') != undefined)
		//{
			//Ext.getCmp('encryptpassword').setDisabled(true);
			//Ext.getCmp('encryptpassword').hide();
		//}
		//if (!Ext.isEmpty(Ext.getCmp('encryptpasswordconfirmpassword')) && Ext.getCmp('encryptpasswordconfirmpassword') != undefined)
		//{
			//Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
			//Ext.getCmp('encryptpasswordconfirmpassword').hide();
		//}
	},


	isSNMPParamsValidate: function ()
	{
		var snmphost = Ext.getCmp('snmphost').getValue();
		if (snmphost == "")
		{
			Ext.Msg.show({
				title: PageTitle,
				msg: alertMsg05,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('snmphost').focus();
				}
			});
			return false;
		}
		else if (!validateIp(snmphost,Ext.getCmp('snmphost')))
		{
			return false;
		}
		
		var snmpport = Ext.getCmp('snmpport').getValue();
		if (snmpport == "")
		{
			Ext.Msg.show({
				title: PageTitle,
				msg: alertMsg06,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('snmpport').focus();
				}
			});
			return false;
		}

		var snmpversion = Ext.getCmp('snmpversion').getValue();
		var snmpcommunity = Ext.getCmp('snmpcommunity').getValue();
		if(!Ext.isEmpty(snmpversion) && snmpversion != "v3")
		{
			if (Ext.isEmpty(snmpcommunity))
			{

				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg07,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('snmpcommunity').focus();
					}
				});
				return false;
			}
			else if (snmpcommunity.indexOf("\"") > -1 || snmpcommunity.indexOf("|") > -1)
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: _snmpcomma,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('snmpcommunity').focus();
					}
				});
				return false;
			}
		}
		else
		{
			var context = Ext.getCmp('context').getValue();	
			if (context == "")
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg08,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('context').focus();
					}
				});
				return false;
			}
			
			var username = Ext.getCmp('username').getValue();
			if (username == "")
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg09,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username').focus();
					}
				});
				return false;
			}
			
			var authpassword = Ext.getCmp('authpass').getValue();
			if(authpassword == "")
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg10,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpass').focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(authpassword,"|"))
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpass').focus(true);
					}
				});
				
				return false;
			}
			
			var authconfirmpassword = Ext.getCmp('authpassconfirmpassword').getValue();
			if(authconfirmpassword == "")
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpassconfirmpassword').focus(true);
					}
				});
				return false;
			}
			else if(authpassword != authconfirmpassword)
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: alertMsg12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpassconfirmpassword').focus(true);
					}
				});
				return false;
			}

			var encryptFlag = Ext.getCmp('encryptflagyes').getValue();
			if(encryptFlag)
			{
				var encryptpwd = Ext.getCmp('encryptpassword').getValue();
				if(encryptpwd == "")
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: alertMsg14,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('encryptpassword').focus(true);
						}
					});
					return false;
				}
				else if(!checkspecialnomess(encryptpwd,"|"))
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('encryptpassword').focus(true);
						}
					});
					return false;
				}
				
				var encryptcnfpwd = Ext.getCmp('encryptpasswordconfirmpassword').getValue();
				if(encryptcnfpwd == "")
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: alertMsg15,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('encryptpasswordconfirmpassword').focus(true);
						}
					});
					return false;
				}
				else if(encryptpwd != encryptcnfpwd)
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: alertMsg12,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('encryptpasswordconfirmpassword').focus(true);
						}
					});
					return false;
				}
			}
		}

		var oidvalue = Ext.getCmp('oidvalue').getValue();
		if (oidvalue == "")
		{
			Ext.Msg.show({
				title: PageTitle,
				msg: alertMsg13,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('oidvalue').focus();
				}
			});
			return false;
		}

		return true;
	},
	snmpGetSubtree : function(obj) 
	{
		if (appnCnt.isSNMPParamsValidate())
		{

		var getSubtree=Ext.getCmp('formitems').getForm();
		if(getSubtree.isValid())
		{
			getSubtree.submit({
				url : "/final/admin/SnmpGetSubtree/data/EgSnmpGetSubtreeJson.jsp?",
				timeout:600,
				waitTitle : PageTitle,
                waitMsg : 'Trying to get the output from the agent. This may take a few minutes.',
				success:function(form, action){
					console.log('action',action)
					var data= Ext.decode(action.response.responseText);
					if (data.success)
					{
						if(!Ext.isEmpty(data.resultSubTreeArr))
						{
							Ext.widget("window", {
							title: 'Subtree Output',
							width: 750,
							height: 450,
							id: "subtreeFile",
							padding: "5 10 10 10",
							name: "subtreeFile",
							resizable: "false",
							autoScroll: true,
							layout: 'fit',
							closable:true,
							items: [
								{
									xtype: 'multiselect',
									id : 'getsubtreeResultCombo',
									name: 'getsubtreeResultCombo',
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									editable: false,
									parent:this,
									store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: data.resultSubTreeArr
									}
									)
								}
							],
							dockedItems: [
								{
									xtype: 'toolbar',
									dock: 'bottom',
									ui: 'footer',
									id: 'subtreeResutlOperation',
									layout: {pack:'center'},
									padding : '10 0 0 0',
									items: [
										{
											xtype: 'button',
											cls: 'quickMenuWhiteButton',
											text: 'Download',
											width: 80,
											id: 'subtreesavebtn',
											name: 'subtreesavebtn',
											labelStyle: 'font-weight:bold',
											handler: function (button, e)
											{
												var multiObj=Ext.getCmp('getsubtreeResultCombo');
												var lineCount=multiObj.getStore().getCount();			
												if(lineCount > 0)
												{
													var temp='Subtree';//Ext.getCmp('fileToBeSave').getValue();
													for(var i=0; i<lineCount; i++)
													{		
														var valField=multiObj.getStore().getAt(i).get('valueField');
														temp=temp+'~!~'+valField;
													}
												}

												postCustomFormSubmit(temp);
											}
										},
										{
											xtype: 'button',
											cls: 'quickMenuWhiteButton',
											text: 'Close',
											width: 80,
											//height:20,
											id: 'closebt',
											name: 'closebtn',
											margin: '0 0 0 10',
											labelStyle: 'font-weight:bold',
											handler: function()
											{
												Ext.getCmp('subtreeFile').close();
											}
										}
									]
								}
								]
						 }).show();
						}
						else
						{
							Ext.Msg.show({
								title: PageTitle,
								msg: 'No data found',
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
							});
						}
						console.log('data',data);
					}
				},
				failure:function(form,action)
				{
					var data= Ext.decode(action.response.responseText);
					 Ext.Msg.show({
							title: PageTitle,
							msg: 'Failed to get subtree',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							});
					console.log('data',data);
				}
			});
		}
	}
	},
	snmpWalk : function(obj) {

		if (appnCnt.isSNMPParamsValidate())
		{
			var walkOut=Ext.getCmp('formitems').getForm();
			if(walkOut.isValid())
			{
				walkOut.submit({
					url : "/final/admin/SnmpGetSubtree/data/EgSnmpWalkJson.jsp?",
					timeout:600,
					waitTitle : PageTitle,
					waitMsg : 'Trying to get the output from the agent. This may take a few minutes.',
					success:function(form, action){
						console.log('action',action)
						var data= Ext.decode(action.response.responseText);
						if (data.success)
						{
							if(data.isLinuxAgenUsed == false)
							{
							 Ext.widget("window", {
								title: 'Snmp walk output',
								width: 750,
								height: 450,
								id: "walkFile",
								padding: "5 10 10 10",
								name: "walkFile",
								resizable: "false",
								autoScroll: true,
								layout: 'fit',
								items: [
									{
										xtype: 'multiselect',
										id : 'walkResultCombo',
										name: 'walkResultCombo',
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										editable: false,
										parent:this,
										store:new Ext.data.Store(
											{
												fields: ['displayField','valueField'],
												data: []
											}
										)
									}
								],
								dockedItems: [
									{										
										layout:{
											type:'hbox',
											align:'stretch',
											pack:'center'
										},
										dock: 'bottom',
										id: 'walkResutlOperation',
										padding : '10 0 0 0',										
										items: [
											{
												xtype: 'button',
												cls: 'quickMenuWhiteButton',
												text: 'Download',
												width: 80,												
												id: 'walksavebtn',
												name: 'walksavebtn',
												labelStyle: 'font-weight:bold',												
												handler: function (button, e)
												{
													var multiObj=Ext.getCmp('walkResultCombo');
													var lineCount=multiObj.getStore().getCount();			
													console.log('Store',lineCount);
													if(lineCount > 0)
													{
														var temp='SNMPWalk';//Ext.getCmp('fileToBeSave').getValue();
														for(var i=0; i<lineCount; i++)
														{		
															var valField=multiObj.getStore().getAt(i).get('valueField');
															temp=temp+'~!~'+valField;
														}
													}
													postCustomFormSubmit(temp);
												}
											},
											{
												xtype: 'button',
												cls: 'quickMenuWhiteButton',
												text: 'Close',
												width: 80,												
												id: 'closebt',
												name: 'closebtn',
												margin: '0 0 0 10',
												labelStyle: 'font-weight:bold',
												handler: function()
												{
													Ext.getCmp('walkFile').close();
												}
											}
										]
									}
								],
									listeners:{
									afterrender:function()
									{
										var resultWalkArr=data.resultWalkArr
										if(!Ext.isEmpty(resultWalkArr))
										{
											Ext.getCmp('walkResultCombo').getStore().removeAll();
											Ext.getCmp('walkResultCombo').getStore().loadRawData(resultWalkArr);
										}
										else
										{
											Ext.Msg.show({
														title: PageTitle,
														msg: 'No data found',
														buttons: Ext.Msg.OK,
														icon: 'iconInformation',
														fn: function(response)
														{
														if (response == 'ok')
														{
															Ext.getCmp('walkFile').close();
														}
														}
														})
											Ext.getCmp('walkFile').hide();
										}
									}
								}

							 }
						).show();
							console.log('data',data);
						}
						else
						{
							Ext.Msg.show({
								title: PageTitle,
								msg: 'SNMP walk is not supported in Linux',
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								});
							console.log('data',data);
						}
						}
					},
						failure:function(form,action)
						{
							var data= Ext.decode(action.response.responseText);
							Ext.Msg.show({
								title: PageTitle,
								msg: 'Failed to get subtree',
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								});
							console.log('data',data);
						}

						
				});
			}
		}
	},

	afterMainRender : function() {
		Ext.getCmp('snmpport').setValue('161');
		Ext.getCmp('context').setValue('none');
		Ext.getCmp('authtype').setValue('MD5');
		Ext.getCmp('snmpversion').setValue('v1');
		Ext.getCmp('encrypttype').setValue('DES');	
		var showFromObj= Ext.getCmp('installedagent');
		showFromObj.getStore().loadRawData(showFromRawData);
		showFromObj.setValue(showFromRawData[0].valueField)
	},
});


function postCustomFormSubmit(temp)
{
	var url = '/final/admin/SnmpGetSubtree/data/EgSnmpOutputSaveJson.jsp?download=true&com.eg.CSRF_NONCE='+csrfToken;

	var form = document.createElement('form');
	form.setAttribute('method', 'post');
	form.setAttribute('action', url);


	var hiddenField = document.createElement('input');
	hiddenField.setAttribute('type', 'hidden');
	hiddenField.setAttribute('name', 'formdata');
	hiddenField.setAttribute('value', filterEncode(temp));

	form.appendChild(hiddenField);

	document.body.appendChild(form);
	form.submit();
}

function validateIp(fieldvalue,obj)
{
	var s_val = fieldvalue;
	var dot_count = 0;

	var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	var isIpv6=false;
	var result=false;
	if(s_val.indexOf(":")>-1)
		isIpv6=true;
	
	if(isIpv6)
	{
		
		result = checkIPv6(s_val,obj);
		return result;
	}
	else
	{

		for(var m=0; m<s_val.length; m++)
		{
			check_char = alpha.indexOf(s_val.charAt(m))			
			if(check_char >= 0)
			{					
				Ext.Msg.show({
					title: pageName,
					msg: _checkAlpha,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(){
						obj.focus();
					}

				});
				return false;
			}
		}
		for(var k=0;k < s_val.length;k++)
		{
			if(s_val.charAt(k) == '.' && s_val.charAt(k + 1) == '.')
			{				
				Ext.Msg.show({
					title: pageName,
					msg: _checkIp,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(){
							obj.focus();
							}

				});
				return false;
			}
			else
			{
				continue;
			}
		}
		for(var i=0;i < s_val.length;i++)
		{
			if(s_val.charAt(i) == '.')
			{
				dot_count = dot_count + 1;
			}
			else
			{
				continue;
			}
		}
		if(dot_count != 3)
		{
			Ext.Msg.show({
				title: pageName,
				msg: _valIp,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
											fn:function(){
							obj.focus();
						}

			});
			return false;
		}
		if(s_val.charAt(0) == '.' || s_val.charAt(s_val.length - 1) == '.')
		{
			Ext.Msg.show({
				title: pageName,
				msg: _validateIp,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
											fn:function(){
							obj.focus();
						}

			});
			return false;
		}
		for(var j = 0; j < s_val.length; j++)
		{
			if(s_val.charAt(j) == ' ')
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkSpaceIp,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
												fn:function(){
							obj.focus();
						}

				});
				return false;
			}
		}
		var splChar = "`~!@#$%^&*()-_+={}[]|\\:;\"\'<>,?\/";

		for(var k=0; k<s_val.length; k++)
		{
			check_char = splChar.indexOf(s_val.charAt(k))			
			if(check_char != -1)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
												fn:function(){
							obj.focus();
						}

				});
				return false;
			}
		}

		if(s_val.indexOf('.') > -1 && dot_count > 2)
		{
			var number_bet_dots = s_val.split('.');

			for(var l=0;l < number_bet_dots.length;l++)
			{
				if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checknum,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
													fn:function(){
							obj.focus();
						}

					});
					return false;
				}
			}
		}
		return true;
	}
}

function checkIPv6(s_val,obj)
{	
	if(!checkspecialnomess(s_val,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
	{		
		Ext.Msg.show({
			title: pageName,
			msg: _checkspecial,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	if(!checkspace(s_val))
	{
		return false;
	}
	var regD1= /[\.]{2,}/;
	var regD2= /(^(\.){1,})|((\.){1,}$)/gi;
	var regD3= /(\.\:){1,}|(\:\.){1,}/;
	if(s_val.match(regD1) != null || s_val.match(regD3) != null  )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _checkIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	
	if(s_val.match(regD2) != null)
	{
		Ext.Msg.show({
			title: pageName,
			msg: _validateIp,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	var reg1= /[\:]{2,}/g;
	var reg1Res = s_val.match(reg1); 
	
	if( reg1Res != null &&  reg1Res != "::" )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _doubleColon,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	
	var regCntRes = s_val.split(":");
	var regColonLen = regCntRes.length;
	regColonLen--;
	var strV4, strV6;
	strV6 = s_val;
	
	if( regCntRes.length <= 7 && s_val.indexOf(".") != -1 )
	{
		var regDRes = s_val.split(".");
		var regDLength = regDRes.length;
		regDLength--;
		
		strV4 = s_val.substring((s_val.lastIndexOf(":")+1));
		strV6 = s_val.substring(0,(s_val.lastIndexOf(":")));
		
		var regIp4 = /[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}((\/){1}[0-9]{1,3})*$/gi;
		regIp4Res = s_val.match(regIp4);
			
		if(regIp4Res  == null || regIp4Res != strV4 )
		{
			Ext.Msg.show({
				title: pageName,
				msg: _valiIp,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
											fn:function(){
							obj.focus();
						}

			});
			return false;
		}
		if(strV6.indexOf(".") != -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: _checkIp,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
											fn:function(){
							obj.focus();
						}

			});
			return false;
		}
		if((regDLength > 3) || (regDLength != 3))
		{
			Ext.Msg.show({
				title: pageName,
				msg: _valIp,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
											fn:function(){
							obj.focus();
						}

			});
			return false;
		}
		var arr = strV4.split("/");
		strV4 = arr[0];
		var number_bet_dots = strV4.split('.');

		for(var l=0;l < number_bet_dots.length;l++)
		{
			if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checknum,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
												fn:function(){
							obj.focus();
						}

				});
				return false;
			}
		}
	}
	else if(regColonLen > 7)
	{
		Ext.Msg.show({
			title: pageName,
			msg: _grpIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	
	var arr = strV6.split("/");
	strV6 = arr[0];
	
	var regPartRes2 = "";
	var regPart = /^(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1}((\:){1,2}[a-z0-9]{0,4}){1,})|(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1})$/gi;
	var regPartRes1 = strV6.match(regPart);
	regPart = /^[a-f0-9]{0,4}$/gi;
	
	if(strV6.indexOf(":") == -1)
	{
		regPartRes2 = strV6.match(regPart);
	}
	if( ( (regPartRes1 == null) || (regPartRes1 != strV6) ) && (regPartRes2 != strV6) )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _digitIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}

	var regC = /(::){0,1}([a-f0-9(::)(\.)]*[\:]{1})+[a-f(::)(\.)0-9]*((\/){0,1}[0-9]{1,3})*/ig; // Right 1
	var regCRes = s_val.match(regC);

	if( regCRes == null ||  regCRes != s_val )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _validateIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
										fn:function(){
							obj.focus();
						}

		});
		return false;
	}
	return true;	
}