Ext.define('SnmpUploadMIB.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'snmpuploadmib', ref:'snmpuploadmib'}
	],
	init:function(){
		me = this;
		this.control({
			'snmpuploadmib':
			{
				'afterrender': this.afterMainRender
			},
			'snmpuploadmib button[id="deleteBtn"]':
			{
				'click': this.deleteOperation
			},
			//'snmpuploadmib trigger[id="searchTrigger"]':
			//{
				//'change': this.filterMultiselect
			//},
			'snmpuploadmib trigger[id="searchTrigger"]':
			{
				'change': this.filterGrid
			},
			'snmpuploadmib button[id="uploadNewMIbBtn"]':
			{
				'click': this.showFileUploadWindow
			},
			'snmpuploadmib grid[id="uploadmibmultiselect"]': {
				'itemmouseenter': this.showActions,
				'itemmouseleave': this.hideActions
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	handleDeleteIconClick: function(grid, rowIndex, colIndex)
	{
		var DispValues = grid.getStore().getAt(rowIndex);
		var deleteMIBName = DispValues.get('Mibname');
		Ext.Msg.show({
			title: pageName,
			msg: deleteConfirmAlert+" '"+deleteMIBName+"' ?",
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					Ext.Ajax.request({
						url:'SnmpUploadMIB/data/EgUploadMIBJson.jsp?deleteMIBFile=true&StrMIBfiles='+deleteMIBName,
						method:'POST',
						async : false,
						scope:this,
						success:function(response)
						{
							Ext.Msg.show({
								title: pageName,
								msg: alert1,
								buttons: Ext.Msg.OK,
								width: alert1.length * 7,
								icon: 'iconInformation',
								fn: function() {
									me.afterMainRender();
								}
							});
						}
					});
				}
			}
		});
	},
	handleDeleteSelected: function(){
		var grid=Ext.getCmp('uploadmibmultiselect').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedMibs="";
		if(grid=="")
		{
			Ext.Msg.show({
				title: pageName,
				msg: noDeleteMibFileAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			//Ext.MessageBox.alert(pageName,noDeleteMibFileAlert);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Mibname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedMibs +=array[j]+",";
		}
		if(selectedMibs != null && selectedMibs.length > 0 )
		{
			Ext.Msg.show({
				title: pageName,
				msg: deleteMultipleConfirmAlert,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if(response == 'yes')
					{
						if(selectedMibs.length > 1)
						{
							selectedMibs = selectedMibs.substring(0,selectedMibs.length-1);
						}
						Ext.Ajax.request({
							url:'SnmpUploadMIB/data/EgUploadMIBJson.jsp?deleteMIBFile=true&StrMIBfiles='+selectedMibs,
							method:'POST',
							async : false,
							scope:this,
							success:function(response)
							{
								Ext.Msg.show({
									title: pageName,
									msg: alert3,
									width: 350,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										me.afterMainRender();
									}
								});
							}
						});
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		var searchVal = Ext.getCmp('searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchTrigger').reset();
		}
		Ext.getCmp('searchTrigger').setDisabled(true);
		Ext.getCmp('uploadmibmultiselect').hide();

		Ext.Ajax.request({
			url: 'SnmpUploadMIB/data/EgUploadMIBJson.jsp?',
			method: 'POST',
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					var publicJson = Ext.decode(jsonText);
					var isNoMibFiles = publicJson['isNoMibFiles'];
					Ext.getCmp('uploadmibmultiselect').show();
					
					var mibUploadArr = publicJson['mibUploadDataArr'];
					var mibUploadGridArr = publicJson['mibUploadDataGridArr'];
					//componentRawData = mibUploadArr;
					componentRawData = mibUploadGridArr;
					var isDeleteButton = publicJson['isDeleteButton'];
					var isSearchBox = publicJson['isSearchBox'];
					Ext.getCmp('uploadmibmultiselect').getStore().suspendEvents(true);
					Ext.getCmp('uploadmibmultiselect').getStore().removeAll();
					Ext.getCmp('uploadmibmultiselect').getStore().loadRawData(mibUploadGridArr);
					Ext.getCmp('uploadmibmultiselect').getStore().resumeEvents();
					if (!isNoMibFiles)
					{
						Ext.getCmp('searchTrigger').setDisabled(false);
					}
					else
					{
						Ext.getCmp('searchTrigger').setDisabled(true);
					}
					Ext.getCmp('uploadmibmultiselect').getSelectionModel().deselectAll(true);
		
				}
			},
			failure: function()
			{
			}
		});
	},
	filterGridTriggerClick : function(obj)
    {
		var compStore = componentRawData;
		var compObj = Ext.getCmp('uploadmibmultiselect');

		if ( Ext.isEmpty( obj) )
		{
			Ext.getCmp('uploadmibmultiselect').show();
			compObj.getStore().loadRawData(compStore);
			Ext.getCmp('uploadmibmultiselect').getSelectionModel().deselectAll(true);
		}
		else
		{
			var findVal = obj;
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['Mibname'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['Mibname'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'Mibname': compStore[i]['Mibname'],
					});
				}
			}
			if ( isRecordFound )
			{
				Ext.getCmp('uploadmibmultiselect').show();
				compObj.getStore().removeAll();    
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
					Ext.getCmp('uploadmibmultiselect').getSelectionModel().deselectAll(true);
				}
			}
			else
			{
				compObj.getStore().removeAll();
				Ext.getCmp('uploadmibmultiselect').store.loadData('');
				Ext.getCmp('uploadmibmultiselect').getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoMibFileSearch+','+"'"+findVal+"'"+'</td></tr></table></td></tr></table>';
				Ext.getCmp('uploadmibmultiselect').getView().refresh();
			}
			Ext.getCmp('searchTrigger').focus();
		}
	},
	filterGrid : function()
    {
		var compStore = componentRawData;
		var compObj = Ext.getCmp('uploadmibmultiselect');
		var findVal = Ext.getCmp('searchTrigger').getValue();

		if ( Ext.isEmpty( findVal) || findVal == undefined )
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');

			Ext.getCmp('uploadmibmultiselect').show();
			compObj.getStore().loadRawData(compStore);
			Ext.getCmp('uploadmibmultiselect').getSelectionModel().deselectAll(true);
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');

			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['Mibname'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['Mibname'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'Mibname': compStore[i]['Mibname'],
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
				Ext.getCmp('uploadmibmultiselect').getSelectionModel().deselectAll(true);
				Ext.getCmp('uploadmibmultiselect').show();
			}
			else
			{
				compObj.getStore().removeAll();
				Ext.getCmp('uploadmibmultiselect').store.loadData('');
				Ext.getCmp('uploadmibmultiselect').getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoMibFileSearch+'.</td></tr></table></td></tr></table>';
				Ext.getCmp('uploadmibmultiselect').getView().refresh();
			}
		}
	},
	//filterMultiselect : function(obj)
    //{
		//alert('filter search operation...');
		//var compStore = componentRawData;
		//var compObj = Ext.getCmp('uploadmibmultiselect');
		//if ( Ext.isEmpty( obj) )
		//{
			//compObj.getStore().loadRawData(compStore);
			//compObj.setValue(compStore[0]['valueField']);
		//}
		//else
		//{
			//var findVal = obj.getValue();
			//var isRecordFound = false;
			//var genStore = new Ext.data.Store({
									//fields : ['displayField', 'valueField'],
									//data : []                                
								//});
			//for ( var i = 0; i < compStore.length ; i++ )
			//{
				//var getRecord = compStore[i]['displayField'];
				//if ( getRecord.indexOf(findVal) > -1 )
				//{
					//isRecordFound = true;
					//genStore.add({
						//'displayField': compStore[i]['displayField'],
						//'valueField': compStore[i]['valueField']
					//});
				//}
			//}
			//if ( isRecordFound )
			//{
				//compObj.getStore().removeAll();    
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compObj.getStore().add(getRecord);
				//}
				//compObj.setValue(genStore.getAt(0).get('valueField'));
			//}
			//else
			//{
				//compObj.getStore().removeAll();
				//compObj.getStore().add({
					//'displayField': "No MIB files found for your search '"+findVal+"'",
					//'valueField': '-1'
				//});
				//compObj.setValue('-1');
			//}
			//obj.focus();
		//}
	//},
	showFileUploadWindow: function()
	{
		var url = 'SnmpUploadMIB/data/EgFileUploadMib.jsp?page=EgUploadMIB';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: titleMsg,
						//closeAction: 'destroy',
						width: 350,
						height: 150,
						id: 'file',
						padding:'5 10 10 10',
						name: 'file',
						resizable: 'false',
						items: [{
							xtype: 'form',
							id: 'uploadform',
							name: 'uploadform',
							url: '../servlet/com.eg.EgUploadServlet',
							height: 150,
							items: [{
								xtype: 'fileuploadfield',
								cls: 'fileupload',
								id: 'file1',
								name: 'file1',
								labelSeparator: '',
								emptyText: emptyMsg,
								fieldLabel: 'MIB file to upload',
								labelAlign: 'top',
								width: 290,
								buttonText: 'Browse',
								margin: '15 0 0 15',
							},
							{
								xtype: 'button',
								text: label5,
								id: 'upload',
								name: 'upload',
								action: 'upload',
								cls: 'button20',
								align: 'center',
								margin: '15 0 0 140',
								handler: function (button, e)
								{
									var form = Ext.getCmp('uploadform').getForm().findField('file1').getValue()
									var fileExtMib = ".mib";
									var fileExtTxt = ".txt";
									var fileExtMy = ".my";
									var isDouble = publicJson['isDouble'];
									var upload_MIB = publicJsonData['uploadMIB'];
									var isUpload = false;
									for (i = 0; i <= (form.length) - 1; i++)
									{
										if (isDouble == "false")
										{
											if(!validateSingleByte(filesel))
											{
												Ext.Msg.show({
													title: pageName,
													msg: doubleByteAlert,
													width: doubleByteAlert.length * 7,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
												return false;
											}
										}
										var isFileExt = true;
										if ((form.toLowerCase().indexOf(fileExtMib) == -1) &&
											(form.toLowerCase().indexOf(fileExtTxt) == -1) &&
											(form.toLowerCase().indexOf(fileExtMy) == -1))
										{
											isFileExt = false;
										}

										if (!isFileExt)
										{
											Ext.Msg.show({
												title: pageName,
												msg: fileexten,
												width: fileexten.length * 7,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
											return false;
										}

										if (form[i].length > 0)
											isUpload = true;
									}
									if (isUpload)
									{
										if(upload_MIB == "true")
										{
											filename="";
											if(form.indexOf("\\")> -1)
												filename = form.substring(form.lastIndexOf("\\")+1,form.length);
											else if(form.indexOf("/")> -1)
												filename = form.substring(form.lastIndexOf("/")+1,form.length);
											else
												filename = form;

											var exten_str="";
											var exten_idx = filename.lastIndexOf(".");
											if(exten_idx > 0)
												exten_str = filename.substring(exten_idx);
											exten_str = exten_str.toLowerCase();
											if(exten_str != ".txt" && 
												exten_str != ".mib" && 
												exten_str != ".my")
											{
												Ext.Msg.show({
													title: pageName,
													msg: fileexten,
													width: fileexten.length * 7,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
													return false;
											}
											var existingFileNames=publicJsonData['ExistingFiles'];
											if((existingFileNames.indexOf(filename)!=-1))
											{
												Ext.Msg.show({
													title: pageName,
													msg: "'"+filename+"' "+overWriteAlert,
													buttons: Ext.MessageBox.YESNO,
													icon: 'iconConfirmation',
													fn: function(response) {
														if (response != "yes")
														{
															Ext.getCmp('file1').reset();
															return false;
														}
														else
														{
															//var uploadform = this.getUploadform().getForm();
															var uploadformObj = Ext.getCmp('uploadform').getForm();
															if (uploadformObj.isValid())
															{
																uploadformObj.submit({
																	//url: '../servlet/com.eg.EgUploadServlet',
																	method: 'POST',
																	success: function (form, action) {
																		var jsonText = action.response.responseText;
																		publicJson = Ext.decode(jsonText);
																		if (!Ext.isEmpty(publicJson.uploadStatus) && publicJson.uploadStatus == 'true')
																		{
																			Ext.Msg.show({
																				title: pageName,
																				msg: alert2,
																				width: 350,
																				buttons: Ext.Msg.OK,
																				icon: 'iconInformation',
																				fn: function() {
																					me.afterMainRender();
																				}
																			});
																			button.up('.window').close();
																		}
																		else
																		{
																			Ext.Msg.show({
																				title: pageName,
																				msg: publicJson.statusMsg,
																				//width: 350,
																				buttons: Ext.Msg.OK,
																				icon: 'iconInformation',
																				fn: function() {
																					me.afterMainRender();
																				}
																			});
																		}
																	},
																	failure: function (form, action) {
																		Ext.Msg.show({
																			title: pageName,
																			width: 350,
																			msg: action.errorMessage,
																			buttons: Ext.Msg.OK,
																			icon: 'iconExclamation'
																		});
																	}
																});
															}
														}
													}
												});
											}
											else
											{
												var uploadform = Ext.getCmp('uploadform').getForm();
												if (uploadform.isValid())
												{
													uploadform.submit({
														success: function (form, action) 
														{
															var jsonText = action.response.responseText;
															var tmpResult = Ext.decode(jsonText);

															if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
															{
																button.up('.window').close();
																//me.showMibTree(from, fieldName);
																Ext.Msg.show({
																	title: pageName,
																	msg: alert2,
																	buttons: Ext.Msg.OK,
																	icon: 'iconInformation',
																	fn: function(response)
																	{
																		if (response == 'ok')
																		{
																			me.afterMainRender();
																		}
																	}
																});
															}
															else 
															{
																Ext.Msg.show({
																	title: pageName,
																	msg: tmpResult.statusMsg,
																	//width: 350,
																	buttons: Ext.Msg.OK,
																	icon: 'iconInformation',
																	fn: function() {
																		me.afterMainRender();
																	}
																});
															}
															//Ext.Msg.alert(pageName, alert2, function(){me.afterMainRender();});
															//button.up('.window').close();
														},
														failure: function (form, action) 
														{
															Ext.Msg.show({
																title: pageName,
																msg: action.errorMessage,
																//width: 350,
																buttons: Ext.Msg.OK,
																icon: 'iconExclamation'
															});
														}
													});
												}
											}
										}
										else
										{
											var uploadform = Ext.getCmp('uploadform').getForm();
											if (uploadform.isValid())
											{
												uploadform.submit({
													success: function (form, action) 
													{
														var jsonText = action.response.responseText;
														var tmpResult = Ext.decode(jsonText);

														if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
														{
															button.up('.window').close();

															Ext.Msg.show({
																title: pageName,
																msg: alert2,
																width: 350,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function() {
																	me.afterMainRender();
																}
															});
														}
														else
														{
															Ext.Msg.show({
																title: pageName,
																msg: tmpResult.statusMsg,
																//width: 350,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function() {
																	me.afterMainRender();
																}
															});
														}
														//Ext.Msg.alert(pageName, alert2, function(){me.afterMainRender();});
													},
													failure: function (form, action) 
													{
														Ext.Msg.show({
															title: pageName,
															msg: action.errorMessage,
															//width: 350,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
													}
												});
											}
										}
									}
									else
									{
										Ext.Msg.show({
											title: pageName,
											msg: nofileselect,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
										return false;
									}
								}
							}],
							listeners: {
                                afterrender: function () {
                                    me.windowupload();
                                },
                            }
						}]
					}).show()
				}
			}
		});
	},
	windowupload: function () {
		var me = Ext.getCmp('uploadform');
		var a = me.getForm();
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'")
					.setValue(hiddenParams[hiddenParam]);
			}
		}
	},
	deleteOperation : function()
	{
		var snmpMIB = Ext.getCmp('uploadmibmultiselect').getValue();
		var isMibSelected = false;
		var selectedMibs = "";
		for (key in snmpMIB )
		{
			var snmpMibVal = snmpMIB[key];
			if(!Ext.isEmpty(snmpMibVal) && snmpMibVal != null && snmpMibVal != 'undefined')
			{
				isMibSelected = true;
				selectedMibs += snmpMibVal+',';
			}
		}
		if(!isMibSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: noDeleteMibFileAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if(selectedMibs != null && selectedMibs.length > 0 )
		{
			Ext.MessageBox.show({
				title: pageName,
				msg: deleteConfirmAlert,
				icon: 'iconConfirmation',
				buttons: Ext.Msg.YESNO,
				fn: function(btn) {
					if(btn == 'yes')
					{
						if(selectedMibs.length > 1)
						{
							selectedMibs = selectedMibs.substring(0,selectedMibs.length-1);
						}
						Ext.Ajax.request({
							url:'SnmpUploadMIB/data/EgUploadMIBJson.jsp?deleteMIBFile=true&StrMIBfiles='+selectedMibs,
							method:'POST',
							async : false,
							scope:this,
							success:function(response)
							{
								Ext.Msg.show({
									title: pageName,
									msg: alert1,
									width: 350,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										me.afterMainRender();
									}
								});
							}
						});
					}
				}
			});
		}
	}
});



