Ext.define('SpecificTestConfiguration.controller.FunctionController',{
	extend:'Ext.app.Controller',

	refs:[
		{selector:'egconfigurerulenames', ref:'egconfigurerulenames'},
		{selector:'eghlspublishedresources', ref:'eghlspublishedresources'},
		{selector:'egemailconfiguration', ref:'egemailconfiguration'},
		{selector:'siteurldetailedconfiguration', ref:'siteurldetailedconfiguration'},
		{selector:'eghorizonwssimulator', ref:'eghorizonwssimulator'},
		{selector:'egsystemproperties', ref:'egsystemproperties'},
		{selector:'egamazonwssimulator', ref:'egamazonwssimulator'},
		{selector:'excludeinterfaces', ref:'excludeinterfaces'},
		{selector:'sharefoldersconfiguration', ref:'sharefoldersconfiguration'}
	],

	init:function(){
		func = this;
		sharedFoldersFullList = '';
		this.control({
			'egconfigurerulenames button[id="addRuleNamebtn"]': {
				'click': this.addMainContact
			},
			'egconfigurerulenames button[id="clearRuleName"]': {
				'click': this.clearFilterRules
			},
			'egconfigurerulenames button[id="updateRuleName"]': {
				'click': this.updateRuleFilters
			},
			'egemailconfiguration button[id="addEmailBtn"]': {
				'click': this.addMainEmailContact
			},
			'egemailconfiguration button[id="clearEmailBtn"]': {
				'click': this.clearEmailFields
			},
			'egemailconfiguration button[id="updateEmailBtn"]': {
				'click': this.updateEmailSets
			},
			'eghlspublishedresources button[id="addMultiHLSbtn"]': {
				'click': this.addMultiHLSSource
			},
			'eghlspublishedresources button[id="clearMultiHLSbtn"]': {
				'click': this.ClearMultiHLSSource
			},
			'eghlspublishedresources button[id="updateMultiHLSbtn"]': {
				'click': this.UpdateMultiHLSSource
			},
			'siteurlconfiguration' : {
				'beforeclose': this.callSitUrlDestroy
			},
			'siteurlconfiguration button[id="addURLsConfbtn"]': {
				'click': this.addURLs
			},
			'siteurlconfiguration button[id="updateSitURLs"]': {
				'click': this.updateSiteURLs
			},
			'siteurlconfiguration button[id="clearSitURLs"]': {
				'click': this.clearSiteURLs
			},
			'siteurlconfiguration button[id="getSitURLs"]': {
				'click': this.getSiteURLs
			},
			'siteurldetailedconfiguration button[id="submitSitUrlDet"]': {
				'click': this.submitSiteURLs
			},
			'siteurldetailedconfiguration trigger[id="getsitDetailSearch"]': {
				'change': this.getSitURLsDtlSearch
			},
			'eghorizonwssimulator button[id="addResourcebtn"]': {
				'click': this.addHorizonWSResourceSet
			},
			'eghorizonwssimulator button[id="clearResourceBtn"]': {
				'click': this.clearResourceFieldSets
			},
			'eghorizonwssimulator button[id="updateResourceBtn"]': {
				'click': this.updateResourceSets
			},
			'egsystemproperties button[id="addPropBtn"]': {
				'click': this.addMainPropertySet
			},
			'egsystemproperties button[id="clearPropBtn"]': {
				'click': this.clearPropertyFields
			},
			'egsystemproperties button[id="updatePropBtn"]': {
				'click': this.updatePropertySets
			},
			'egamazonwssimulator button[id="addAmazonResourcebtn"]': {
				'click': this.addAmazonWSResourceSet
			},
			'egamazonwssimulator button[id="clearAmazonResourceBtn"]': {
				'click': this.clearAmazonResourceFieldSets
			},
			'egamazonwssimulator button[id="updateAmazonResourceBtn"]': {
				'click': this.updateAmazonResourceSets
			},
			'excludeinterfaces button[id="addExcludInf"]':{
				'click': this.addExcludInterfacs
			},
			'excludeinterfaces button[id="getExcludInf"]':{
				'click': this.getExcludInterfacs
			},
			'excludeinterfaces trigger[id="getInfacDetailSearch"]': {
				'change': this.getexInfacsSearch
			},
			'sharefoldersconfiguration button[id="submitShareFolderBtn"]': {
				'click': this.submitShareFolders
			},
			'sharefoldersconfiguration button[id="getShareFolders"]': {
				'click': this.getUpdateShares
			},

		});
	},

	snmpUtilityShow: function() 
	{
		Ext.widget('window',{
			title : SNMPUtilTitle,
			listeners : {
				afterrender : function()
				{
					var hostValue = Ext.getCmp('host').getValue()

					var snmpPortParamName = publicJson.originalParamNameObj['SNMPPORT'];
					var snmpUserContextParamName = publicJson.originalParamNameObj['CONTEXT'];
					var snmpUserParamName = publicJson.originalParamNameObj['USERNAME'];
					var snmpAuthPassParamName = publicJson.originalParamNameObj['AUTHPASS'];
					var snmpAuthPassConfirmParamName = publicJson.originalParamNameObj['AUTHPASSCONFIRMPASSWORD'];
					var snmpAuthTypeParamName = publicJson.originalParamNameObj['AUTHTYPE'];
					var snmpEncryptFlagParamName = publicJson.originalParamNameObj['ENCRYPTFLAG'];
					var snmpEncryptTypeParamName = publicJson.originalParamNameObj['ENCRYPTTYPE'];
					var snmpEncryptPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORD'];
					var snmpEncryptConPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORDCONFIRMPASSWORD'];


					var snmpHostObj = Ext.ComponentQuery.query("#snmphost")[0];
					var snmpPortObj = Ext.ComponentQuery.query("#snmpport")[0];
					var snmpVerObj = Ext.ComponentQuery.query("#snmpversion");
					if (snmpVerObj.length > 1)
					{
						snmpVerObj = snmpVerObj[1];
					}
					else
					{
						snmpVerObj = snmpVerObj[0];
					}

					var snmpCommObj = Ext.ComponentQuery.query("#snmpcommunity")[0];
					snmpHostObj.setValue(hostValue);

					var portValue = Ext.getCmp(snmpPortParamName).getValue();
					if (!Ext.isEmpty(portValue))
					{
						snmpPortObj.setValue(portValue);
					}
					else
					{
						snmpPortObj.setValue('161');
					}

					var snmpVerObject = '';
					var snmpVersion = '';
					if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpversion');
						snmpVersion = snmpVerObject.getValue();
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpVersion');
						snmpVersion = snmpVerObject.getValue();
					}

					if (!Ext.isEmpty(snmpVersion))
					{
						snmpVerObj.setValue(snmpVersion);
					}
					else
					{
						snmpVerObj.setValue('v1');
					}

					if (!Ext.isEmpty(snmpVersion) && snmpVersion == "v3"  )
					{
						var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
						var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];

						snmpCommObj.setDisabled(true);
						snmpCommObj.hide();

						var contextObj = Ext.ComponentQuery.query("#snmpcontext")[0];
						var context = Ext.getCmp(snmpUserContextParamName).getValue();
						contextObj.setDisabled(false);
						if (!Ext.isEmpty(context))
						{
							contextObj.setValue(context);
						}
						else
						{
							contextObj.setValue('none');
						}
						contextObj.show();


						var username = Ext.getCmp(snmpUserParamName).getValue();
						var userNameObj = Ext.ComponentQuery.query("#snmpusername")[0];
						userNameObj.setDisabled(false);
						if (!Ext.isEmpty(username))
						{
							userNameObj.setValue(username);
						}
						else
						{
							userNameObj.setValue('none');
						}
						userNameObj.show();


						var authpass = Ext.getCmp(snmpAuthPassParamName).getValue();
						var authPassObj = Ext.ComponentQuery.query("#snmpauthpass")[0];
						authPassObj.setDisabled(false);
						if (!Ext.isEmpty(authpass))
						{
							authPassObj.setValue(authpass);
						}
						else
						{
							authPassObj.setValue('none');
						}
						authPassObj.show();

						var authCnfPass = Ext.getCmp(snmpAuthPassConfirmParamName).getValue();
						var authCnfPassObj = Ext.ComponentQuery.query("#snmpauthpassconfirmpassword")[0];
						authCnfPassObj.setDisabled(false);
						if (!Ext.isEmpty(authCnfPass))
						{
							authCnfPassObj.setValue(authCnfPass);
						}
						else
						{
							authCnfPassObj.setValue('none');
						}
						authCnfPassObj.show();

						var authType = Ext.getCmp(snmpAuthTypeParamName).getValue();
						var authTypeObj = Ext.ComponentQuery.query("#snmpauthtype")[0];
						authTypeObj.setDisabled(false);
						if (!Ext.isEmpty(authType))
						{
							authTypeObj.setValue(authType);
						}
						else
						{
							authTypeObj.setValue(snmpAuthTypeArr[0].valueField);
						}
						authTypeObj.show();

						var encrytFlagObj = Ext.ComponentQuery.query("#snmpencryptflag")[0];
						encrytFlagObj.setDisabled(false);
						encrytFlagObj.show();


						var encrypttype = Ext.getCmp(snmpEncryptTypeParamName).getValue();
						var encrytypeObj = Ext.ComponentQuery.query("#snmpencrypttype")[0];
						encrytypeObj.setDisabled(false);
						if (!Ext.isEmpty(encrypttype))
						{
							encrytypeObj.setValue(encrypttype);
						}
						else
						{
							encrytypeObj.setValue(snmpEncTypeArr[0].valueField);
						}

						var encpwd = Ext.getCmp(snmpEncryptPwdParamName).getValue();
						var encPwdObj = Ext.ComponentQuery.query("#snmpencryptpassword")[0];
						encPwdObj.setDisabled(false);
						if (!Ext.isEmpty(encpwd))
						{
							encPwdObj.setValue(encpwd);
						}
						else
						{
							encPwdObj.setValue('none');
						}

						var encCnfPwd = Ext.getCmp(snmpEncryptConPwdParamName).getValue();
						var encCnfPwdObj = Ext.ComponentQuery.query("#snmpencryptpasswordconfirmpassword")[0];
						encCnfPwdObj.setDisabled(false);
						if (!Ext.isEmpty(encCnfPwd))
						{
							encCnfPwdObj.setValue(encCnfPwd);
						}
						else
						{
							encCnfPwdObj.setValue('none');
						}

						var disabled = Ext.getCmp('encryptflag2').getValue();
						if (disabled)
						{
							encrytypeObj.hide();
							encPwdObj.hide();
							encCnfPwdObj.hide();
						}
						else
						{
							encrytypeObj.show();
							encPwdObj.show();
							encCnfPwdObj.show();
						}
					}
					else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
					{
						var snmpCommObject = '';
						var snmpCommunity = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							snmpCommObject = Ext.getCmp('snmpcommunity');
							snmpCommunity = snmpCommObject.getValue();
						}
						else
						{
							snmpCommObject = Ext.getCmp('snmpCommunity');
							snmpCommunity = snmpCommObject.getValue();
						}

						snmpCommObj.setDisabled(false);

						if (!Ext.isEmpty(snmpCommunity))
						{
							snmpCommObj.setValue(snmpCommunity);
						}
						else
						{
							snmpCommObj.setValue('none');
						}
						snmpCommObj.show();

						func.snmpUtilV3ParamDisabeld();
					}
				}
			},
			closeAction: 'destroy',
			id : 'utilWins',

			width: 800,
			modal: true,
			floating : true,
			padding:'5 10 10 10',

			layout: 'fit',
			doClose: function() {
				this.destroy();
			},
			dockedItems: [
				{
					xtype: 'toolbar',
					dock: 'bottom',
					id: 'utilbottomToolBar',
					name: 'utilbottomToolBar',
					cls: 'testConfigToolbarBg',
					ui: 'footer',
					margin: 0,
					padding: '10 0 10 0',
					layout:{pack:'center'},
					items: [
						{
							xtype: 'button',
							id: 'GetSubtreeBtn',
							text: screenLabelMsg19,
							cls:'button20',
							width: 100,
							listeners : {
								'click' : func.snmpGetSubtree
							}
						},
						{
							xtype: 'button',
							id: 'SnmpWalkBtn',
							text: screenLabelMsg20,
							cls:'button20',
							margin: '0 0 0 10',
							width: 100,
							listeners : {
								'click' : func.snmpWalk
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'fieldset',
					title: screenLabelMsg21,
					id: 'snmputilityitems',
					scroll: true,
					autoScroll: true,
					height: 400,
					margin: 10,
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 450,
						labelWidth: 200
					},
					items : [
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg1,
							itemId:'snmphost'
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg2,
							itemId:'snmpport'
						},
						{
							xtype: 'combo',
							cls: 'dropdown',
							itemId : 'snmpversion',
							fieldLabel: screenLabelMsg3,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							parent:this,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: [
									{'displayField': 'v1','valueField':'v1'},
									{'displayField': 'v2','valueField':'v2'},
									{'displayField': 'v3','valueField':'v3'}
								]
							}),
							listeners: {
								'select': func.snmpVersionChange
							}
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg4,
							itemId:'snmpcommunity'
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg5,
							itemId:'snmpcontext',
							hidden:true
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg6,
							itemId:'snmpusername',
							hidden:true
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg7,
							itemId:'snmpauthpass',
							inputType:'password',
							hidden:true
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg8,
							itemId:'snmpauthpassconfirmpassword',
							inputType:'password',
							hidden:true
						},
						{
							xtype: 'combo',
							cls: 'dropdown',
							itemId : 'snmpauthtype',
							hidden :true,
							fieldLabel: screenLabelMsg9,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							parent:this,
							value: 'MD5',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: [
									{'displayField': 'MD5','valueField':'MD5'},
									{'displayField': 'SHA','valueField':'SHA'}
								]
							})
						},
						{
							xtype: 'radiogroup',
							cls: 'radiobt',
							fieldLabel: screenLabelMsg10,
							columns: 2,
							vertical: false,
							itemId:'snmpencryptflag',
							listeners:{
								'change': this.changeEncFlagValue
							},
							items: [
								{ boxLabel: 'Yes', name: 'snmpencryptflag', id:'snmpencryptflagyes',  inputValue: '1'},
								{ boxLabel: 'No', name: 'snmpencryptflag', id:'snmpencryptflagno',  inputValue: '2', checked: true}
							],
							hidden:true
						},
						{
							xtype: 'combo',
							cls: 'dropdown',
							itemId : 'snmpencrypttype',
							hidden :true,
							fieldLabel: screenLabelMsg11,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							parent:this,
							value: 'DES',
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: [
									{'displayField': 'DES','valueField':'DES'},
									{'displayField': 'AES','valueField':'AES'}
								]
							})
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg12,
							itemId:'snmpencryptpassword',
							inputType:'password',
							hidden:true
						},
						{
							xtype: 'textfield',
							cls:"textbox",
							fieldLabel: screenLabelMsg13,
							itemId:'snmpencryptpasswordconfirmpassword',
							inputType:'password',
							hidden:true
						},
						{
							xtype: 'radiogroup',
							cls: 'radiobt',
							fieldLabel: screenLabelMsg14,
							columns: 2,
							vertical: false,
							itemId:'snmpdataovertcp',
							items: [
								{ boxLabel: 'Yes', name: 'utildataovertcp', id:'utildatatcpyes',  inputValue: '1'},
								{ boxLabel: 'No', name: 'utildataovertcp', id:'utildatatcpno',  inputValue: '2', checked: true}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: screenLabelMsg15,
							layout: {
								type: 'column'
							},
							items:[
								{
									xtype: 'textfield',
									cls : 'textbox',
									id:'oidvalue',
									maxLength: 100,
									enforceMaxLength: true,
									columnWidth: 1
								},
								{
									xtype: 'button',
									iconCls:'iconTree',
									border:0,
									style:{
										'background':'none'
									},
									tooltip: 'Get OID',
									listeners: {
										el: {
											click: function() {
												func.showMibTree('config','ObjectOID');
											}
										}
									}
								}
							]
						},
						{
							xtype: 'combo',
							cls: 'dropdown',
							itemId : 'installedagent',
							id : 'installedagent',
							fieldLabel: screenLabelMsg16,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							parent:this,
							value: publicJson.agentsListForSNMPUtil[0].valueField,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: publicJson.agentsListForSNMPUtil
							})
						}
					]
				}
			]
		}).show();
	},
	snmpGetSubtree : function(obj) 
	{
		var result = func.isSNMPParamsValidate();
		var checkValidate = true;
		if (result.startsWith('false~@~'))
		{
			checkValidate = false;
		}

		if (checkValidate)
		{
			var waitMsg = 'Trying to get the output from the agent. This may take a few minutes.';

			var myDDMask = new Ext.LoadMask(Ext.getCmp('utilWins'), {msg: waitMsg});
			myDDMask.show()

			var queryParams = result.substring(result.indexOf('~@~')+3);
			Ext.Ajax.request({
				url : "/final/admin/SnmpGetSubtree/data/EgSnmpGetSubtreeJson.jsp?",
				timeout:6000000,
				params: queryParams,
				waitTitle : SNMPUtilTitle,
				success:function(response)
				{
					myDDMask.hide();

					var data = Ext.decode(response.responseText);
					if (data.success)
					{
						if(!Ext.isEmpty(data.resultSubTreeArr))
						{
							Ext.widget("window", {
								title: screenLabelMsg22,
								width: 800,
								height: 500,
								id: "subtreeFile",
								padding: "5 10 5 10",
								name: "subtreeFile",
								resizable: "false",
								autoScroll: true,
								layout: 'fit',
								closable:true,
								items: [
									{
										xtype: 'multiselect',
										id : 'getsubtreeResultCombo',
										name: 'getsubtreeResultCombo',
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										editable: false,
										parent:this,
										store:new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: data.resultSubTreeArr
										}
										)
									}
								],
								dockedItems: [
									{
										dock: 'bottom',
										layout:{
											type:'hbox',
											pack:'center'
										},
										border: false,
										padding : '7 0 7 0',
										items: [
											{
												xtype: 'button',
												cls: 'quickMenuWhiteButton',
												text: 'Save',
												width: 80,
												id: 'subtreesavebtn',
												name: 'subtreesavebtn',
												labelStyle: 'font-weight:bold',
												handler: function (button, e)
												{
													var multiObj=Ext.getCmp('getsubtreeResultCombo');
													var lineCount=multiObj.getStore().getCount();			
													if(lineCount > 0)
													{
														var temp='Subtree';//Ext.getCmp('fileToBeSave').getValue();
														for(var i=0; i<lineCount; i++)
														{		
															var valField=multiObj.getStore().getAt(i).get('valueField');
															temp=temp+'~!~'+valField;
														}
													}

													postCustomFormSubmit(temp);
												}
											},
											{
												xtype: 'button',
												cls: 'quickMenuWhiteButton',
												text: 'Close',
												width: 80,
												//height:20,
												id: 'closebt',
												name: 'closebtn',
												margin: '0 0 0 10',
												labelStyle: 'font-weight:bold',
												handler: function()
												{
													Ext.getCmp('subtreeFile').close();
												}
											}
										]
									}
								]
							 }).show();
						}
						else
						{
							Ext.Msg.show({
								title: SNMPUtilTitle,
								msg: 'No data found',
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
							});
						}
					}
				},
				failure:function(form,action)
				{
					myDDMask.hide()

					var data= Ext.decode(action.response.responseText);
					 Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: 'Failed to get subtree',
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
					});
				}
			});
		}
	},

	snmpWalk : function(obj) 
	{
		var result = func.isSNMPParamsValidate();
		var checkValidate = true;
		if (result.startsWith('false~@~'))
		{
			checkValidate = false;
		}

		if (checkValidate)
		{
			var waitMsg = 'Trying to get the output from the agent. This may take a few minutes.';
			var myLoadMask = new Ext.LoadMask(Ext.getCmp('utilWins'), {msg: waitMsg});
			myLoadMask.show()

			var queryParams = result.substring(result.indexOf('~@~')+3);
			Ext.Ajax.request({
				url : "/final/admin/SnmpGetSubtree/data/EgSnmpWalkJson.jsp?",
				timeout: 60000000,
				waitTitle : SNMPUtilTitle,
				params: queryParams,
				success:function(response)
				{
					myLoadMask.hide();
					var data= Ext.decode(response.responseText);
					if (data.success)
					{
						if(data.isLinuxAgenUsed == false)
						{
							var resultWalkArr = data.resultWalkArr
							if(!Ext.isEmpty(resultWalkArr))
							{
								Ext.widget("window", {
									title: screenLabelMsg23,
									width: 800,
									height: 500,
									id: "walkFile",
									padding: "5 10 5 10",
									name: "walkFile",
									resizable: "false",
									autoScroll: true,
									layout: 'fit',
									items: [
										{
											xtype: 'multiselect',
											id : 'walkResultCombo',
											name: 'walkResultCombo',
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											editable: false,
											parent:this,
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: resultWalkArr,
												}
											)
										}
									],
									dockedItems: [
										{
											dock: 'bottom',
											layout:{
												type:'hbox',
												pack:'center'
											},
											border: false,
											padding : '10 0 7 0',
											items: [
												{
													xtype: 'button',
													cls: 'quickMenuWhiteButton',
													text: 'Save',
													width: 80,
													id: 'walksavebtn',
													name: 'walksavebtn',
													labelStyle: 'font-weight:bold',
													handler: function (button, e)
													{
														var multiObj=Ext.getCmp('walkResultCombo');
														var lineCount=multiObj.getStore().getCount();			
														console.log('Store',lineCount);
														if(lineCount > 0)
														{
															var temp='SNMPWalk';//Ext.getCmp('fileToBeSave').getValue();
															for(var i=0; i<lineCount; i++)
															{		
																var valField=multiObj.getStore().getAt(i).get('valueField');
																temp=temp+'~!~'+valField;
															}
														}
														postCustomFormSubmit(temp);
													}
												},
												{
													xtype: 'button',
													cls: 'quickMenuWhiteButton',
													text: 'Close',
													width: 80,
													id: 'closebt',
													name: 'closebtn',
													margin: '0 0 0 10',
													labelStyle: 'font-weight:bold',
													handler: function()
													{
														Ext.getCmp('walkFile').close();
													}
												}
											]
										}
									],
									listeners:{
										//afterrender:function()
										//{
											//Ext.getCmp('walkResultCombo').getStore().removeAll();
											//Ext.getCmp('walkResultCombo').getStore().loadRawData(resultWalkArr);
										//}
									}
								}).show();
							}
							else
							{
								Ext.Msg.show({
									title: SNMPUtilTitle,
									msg: 'No data found',
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
						}
						else
						{
							Ext.Msg.show({
								title: SNMPUtilTitle,
								msg: 'SNMP walk is not supported in Linux',
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: SNMPUtilTitle,
							msg: 'Failed to get SNMP Walk',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
						});
					}
				},
				failure:function(form,action)
				{
					myLoadMask.hide();
					var data= Ext.decode(action.response.responseText);
					Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: 'Failed to get SNMP Walk',
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
					});
				}
			});
		}
	},
	isSNMPParamsValidate: function ()
	{
		var installedagent = Ext.getCmp('installedagent').getValue();
		var queryStr = 'installedagent='+installedagent;
		var snmpHostObj = Ext.ComponentQuery.query("#snmphost")[0];
		var snmphost = snmpHostObj.getValue();

		if (snmphost == "")
		{
			Ext.Msg.show({
				title: SNMPUtilTitle,
				msg: alertMsg05,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					snmpHostObj.focus();
				}
			});
			return 'false~@~'+queryStr;
		}
		else if (!validateIp(snmphost,snmpHostObj))
		{
			return 'false'+queryStr;
		}
		
		queryStr += '&snmphost='+snmphost;

		var snmpPortObj = Ext.ComponentQuery.query("#snmpport")[0];
		var snmpport = snmpPortObj.getValue();
		if (snmpport == "")
		{
			Ext.Msg.show({
				title: SNMPUtilTitle,
				msg: alertMsg06,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					snmpPortObj.focus();
				}
			});
			return 'false~@~'+queryStr;
		}

		queryStr += '&snmpport='+snmpport;

		var snmpVersObj = Ext.ComponentQuery.query("#snmpversion")[1];
		var snmpversion = snmpVersObj.getValue();
		queryStr += '&snmpversion='+snmpversion;

		if(!Ext.isEmpty(snmpversion) && snmpversion != "v3")
		{
			var snmpCommObj = Ext.ComponentQuery.query("#snmpcommunity")[0];
			var snmpcommunity = snmpCommObj.getValue();

			if (Ext.isEmpty(snmpcommunity))
			{

				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertMsg07,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						snmpCommObj.focus();
					}
				});
				return 'false~@~'+queryStr;
			}
			else if (snmpcommunity.indexOf("\"") > -1 || snmpcommunity.indexOf("|") > -1)
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: _snmpcomma,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						snmpCommObj.focus();
					}
				});
				return 'false~@~'+queryStr;
			}
			queryStr += '&snmpcommunity='+snmpcommunity;

		}
		else
		{
			var contextObj = Ext.ComponentQuery.query("#snmpcontext")[0];
			var context = contextObj.getValue();

			if (context == "")
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertMsg08,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						contextObj.focus();
					}
				});
				return 'false~@~'+queryStr;
			}
			queryStr += '&context='+context;


			var userNameObj = Ext.ComponentQuery.query("#snmpusername")[0];
			var username = userNameObj.getValue();

			if (username == "")
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertMsg09,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						userNameObj.focus();
					}
				});
				return 'false~@~'+queryStr;
			}
			queryStr += '&username='+username;

			var authPassObj = Ext.ComponentQuery.query("#snmpauthpass")[0];
			var authpassword = authPassObj.getValue();

			if(authpassword == "")
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertSnmpMsg10,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						authPassObj.focus(true);
					}
				});
				return 'false~@~'+queryStr;
			}
			else if(!checkspecialnomess(authpassword,"|"))
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpass').focus(true);
					}
				});
				
				return 'false~@~'+queryStr;
			}

			var authCnfPassObj = Ext.ComponentQuery.query("#snmpauthpassconfirmpassword")[0];
			var authconfirmpassword = authCnfPassObj.getValue();
			if(authconfirmpassword == "")
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertSnmpMsg11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						authCnfPassObj.focus(true);
					}
				});
				return 'false~@~'+queryStr;
			}
			else if(authpassword != authconfirmpassword)
			{
				Ext.Msg.show({
					title: SNMPUtilTitle,
					msg: alertSnmpMsg12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('authpassconfirmpassword').focus(true);
					}
				});
				return 'false~@~'+queryStr;
			}
			queryStr += '&authpass='+authpassword;

			var authTypeObj = Ext.ComponentQuery.query("#snmpauthtype")[0];
			var authtype = authTypeObj.getValue();
			queryStr += '&authtype='+authtype;

			var encryptFlag = Ext.getCmp('snmpencryptflagyes').getValue();
			if (encryptFlag)
			{
				queryStr += '&encryptflag=1';
			}
			else
			{
				queryStr += '&encryptflag=2';
			}

			if(encryptFlag)
			{
				var encTypeObj = Ext.ComponentQuery.query("#snmpencrypttype")[0];
				var encrypttype = encTypeObj.getValue();
				queryStr += '&encrypttype='+encrypttype;

				var encryPassObj = Ext.ComponentQuery.query("#snmpencryptpassword")[0];
				var encryptpwd = encryPassObj.getValue();
				if(encryptpwd == "")
				{
					Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: alertSnmpMsg14,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							encryPassObj.focus(true);
						}
					});
					return 'false~@~'+queryStr;
				}
				else if(!checkspecialnomess(encryptpwd,"|"))
				{
					Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							encryPassObj.focus(true);
						}
					});
					return 'false~@~'+queryStr;
				}
				
				var encryCnfPassObj = Ext.ComponentQuery.query("#snmpencryptpasswordconfirmpassword")[0];
				var encryptcnfpwd = encryCnfPassObj.getValue();
				if(encryptcnfpwd == "")
				{
					Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: alertSnmpMsg15,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							encryCnfPassObj.focus(true);
						}
					});
					return 'false~@~'+queryStr;
				}
				else if(encryptpwd != encryptcnfpwd)
				{
					Ext.Msg.show({
						title: SNMPUtilTitle,
						msg: alertMsg12,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							encryCnfPassObj.focus(true);
						}
					});
					return 'false~@~'+queryStr;
				}
				queryStr += '&encryptpassword='+encryptpwd;
			}
		}

		var oidvalue = Ext.getCmp('oidvalue').getValue();
		if (oidvalue == "")
		{
			Ext.Msg.show({
				title: SNMPUtilTitle,
				msg: alertSnmpMsg13,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('oidvalue').focus();
				}
			});
			return 'false~@~'+queryStr;
		}
		queryStr += '&oidvalue='+oidvalue;

		var dataovertcp = Ext.getCmp('utildatatcpyes').getValue();
		if (dataovertcp)
		{
			dataovertcp = '1';
		}
		else
		{
			dataovertcp = '2';
		}
		queryStr += '&dataovertcp='+dataovertcp;

		return 'true~@~'+queryStr;
	},
	showMibTree: function(from, fieldName)
	{
		var urlStr = 'showMibFilesJson.jsp?from='+from+'&fieldName='+fieldName;
		Ext.Ajax.request(
		{
			url: 'SnmpGetSubtree/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					mibJSON = Ext.decode( jsonText );
				}
			}
		});
		
		var me = this;
		Ext.create('Ext.window.Window', {
			height: 500,
			width: 800,
			title: 'MIB Tree',
			id:'mibWindow',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			listeners : {
				close : function()
				{
					Ext.Ajax.request({
					url:'SnmpGetSubtree/data/snmphelpJson.jsp?selectTab=addMeasureTab&testType=Snmp',
					method:'POST'
					});
				}
			},

			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						pack:'center'
					},
					border: false,
					padding : '10 0 7 0',
					items: [
						{
							xtype: 'button',
							text: 'OK',
							id: 'ok',
							name: 'ok',
							width: 80,
							cls: 'quickMenuWhiteButton',
							listeners: {
								el: {
									click: function() {
										var curObjOid = Ext.getCmp('objOid').getValue();
										if (fieldName == 'ObjectOID')
										{
											var windowObj = Ext.getCmp('modScriptMeasureWindow');
											if(windowObj != undefined || windowObj != null)
											{
												var old_filename = Ext.getCmp('measureform').getForm().findField('fileName').getValue();
												var new_filename = Ext.getCmp('fileList').getValue();
												if(new_filename != null && old_filename !== new_filename)
												{
													Ext.getCmp('measureform').getForm().findField('fileName').setValue(new_filename);
												}
											}
											else
											{
												Ext.getCmp('oidvalue').setValue(curObjOid);
											}
										}
										else if (fieldName == 'ElementOID')
										{
											Ext.getCmp('elementOid').setValue(curObjOid);
										}
										else if (fieldName == 'StatusOID')
										{
											Ext.getCmp('validOid').setValue(curObjOid);
										}
										Ext.getCmp('mibWindow').close();
									}
								}
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'container',
					border: true,
					style: 'border: 1px solid lightGrey',
					layout:{
						type:'vbox',
						align:'stretch'
					},
					flex: 0.5,
					margin: '5 0 5 5',
					items: [
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							margin: 5,
							items: [
								{
									xtype: 'combo',
									cls : 'dropdown',
									id:'fileList',
									name:'fileList',
									fieldLabel: 'MIB Files',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									labelSeparator: '',
									editable: false,
									labelWidth: 60,
									listeners:
									{
										select:{
											fn: function (id){
												me.mibFileSelection(from,fieldName,true);
											}
										}
									},
									columnWidth: 0.9
								},
								{
									xtype: 'button',
									iconCls:'iconUpload',
									columnWidth: 0.1,
									border:0,
									style:{
										'background':'none'
									},
									tooltip: 'Upload',
									margin : '0 0 0 10',
									listeners:
									{
										click:{
											fn: function (){
												me.uploadMibFile(from,fieldName);
											}
										}
									},
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							id: 'treepanalCntnr',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							border: 1,
							style: {
								borderColor: 'darkGrey',
								borderStyle: 'solid'
							},
							margin: '0 5 5 5',
							flex: 1
						},
						{
							xtype: 'textfield',
							fieldLabel: 'OID',
							id: 'objOid',
							labelSeparator: '',
							labelWidth: 60,
							margin: '0 5 5 5'
						}
					]
				},
				{
					xtype: 'container',
					border: true,
					style: 'border: 1px solid lightGrey',
					flex: 0.5,
					layout: {
						type:'hbox',
						align:'stretch'
					},
					margin: '5 5 5 0',
					items: [
						{
							xtype: 'container',
							id:'displayFieldCntnr',
							layout: {
								type:'vbox',
								align:'stretch'
							},
							defaults: {
								labelSeparator: '',
								labelAlign: 'top',
								readOnly: true
							},
							flex: 1,
							hidden: true,
							items: [
								{
									xtype: 'textfield',
									fieldLabel: 'Name',
									id: 'name',
									margin: '9 5 5 5'
								},
								{
									xtype: 'textarea',
									fieldLabel: 'Fullname',
									id: 'fullname',
									margin: '5 5 5 5'
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.5,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											fieldLabel: 'Access',
											id: 'access'
										},
										{
											xtype: 'textfield',
											fieldLabel: 'Syntax',
											id: 'syntax',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.33,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											fieldLabel: 'Status',
											id: 'status',
											columnWidth: 0.34
										},
										{
											xtype: 'textfield',
											fieldLabel: 'IsIndexNode',
											id: 'isIndexNode',
											margin: '0 0 0 5'
										},
										{
											xtype: 'textfield',
											fieldLabel: 'IsV2Trap',
											id: 'isV2Trap',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'textarea',
									fieldLabel: 'Description',
									id: 'description',
									margin: '5 5 5 5',
									rows: 6
								}
							]
						}
					]
				}
			]
		}).show();
		Ext.getCmp('fileList').getStore().loadRawData(mibJSON.mibFilesList);
		Ext.getCmp('fileList').setValue("-1");
	},
	uploadMibFile: function(from, fieldName)
	{
		var me = this;
		Ext.widget('window', {
			width: 350,
			height: 150,
			id: 'file',
			name: 'file',
			resizable: 'false',
			items: [{
				xtype: 'form',
				id: 'uploadform',
				name: 'uploadform',
				url: '../servlet/com.eg.EgUploadServlet',
				height: 150,
				items: [{
					xtype: 'fileuploadfield',
					cls: 'fileupload',
					id: 'file1',
					name: 'file1',
					labelSeparator: '',
					emptyText: 'No File Selected',
					fieldLabel: 'Choose File',
					labelAlign: 'top',
					width: 290,
					buttonText: 'Browse',
					margin: '15 0 0 15',
				},
				{
					xtype: 'button',
					text: 'upload',
					id: 'upload',
					name: 'upload',
					action: 'upload',
					cls: 'button20',
					align: 'center',
					margin: '15 0 0 140',
					handler: function (button, e)
					{
						var selFile = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
						var n = selFile.lastIndexOf("fakepath");
						if(n > 0)
						{
							selFile = selFile.substring(n+9);
						}
						var exten_str="";
						var exten_idx = selFile.lastIndexOf(".");
						if(exten_idx > 0)
							exten_str = selFile.substring(exten_idx);
						exten_str = exten_str.toLowerCase();
		
						var validate = true;
						if(!validateSingleByte(selFile))
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg01,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if(selFile=="")
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg02,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if (exten_str != ".txt" && exten_str != ".mib")
						{
							Ext.Msg.show({
								title: titleMsg,
								msg: alertMsg04,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}

						if (!validate)
						{
							return false;
						}
						else
						{
							if(mibJSON.existingFiles.indexOf(selFile)!=-1)
							{
								Ext.Msg.show({
									title: titleMsg,
									msg: alertMsg03,
									buttons: Ext.Msg.OKCANCEL,
									icon: 'iconConfirmation',
									fn: function(response) {
										if(response == 'ok') {
											var uploadformObj = Ext.getCmp('uploadform').getForm();
											if (uploadformObj.isValid())
											{
												uploadformObj.submit({
													method: 'POST',
													success: function (form, action) {
														var jsonText = action.response.responseText;
														var tmpResult = Ext.decode(jsonText);
														if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
														{
															button.up('.window').close();
															Ext.Msg.show({
																title:titleMsg,
																msg: alertSnmpMsg16,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function(response)
																{
																	if (response == 'ok')
																	{
																		Ext.getCmp('mibWindow').close();
																		me.showMibTree(from, fieldName);
																	}
																}
															});
														}
														else
														{
															Ext.Msg.show({
																title: titleMsg,
																msg: tmpResult.statusMsg,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation'
															});
														}
													},
													failure: function (form, action) 
													{
														Ext.Msg.show({
															title: titleMsg,
															msg: alertMsg17+'. '+alertMsg18,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
													}
												});
											}
										}
										else
										{
											button.up('.window').close();
										}
									}
								});
							}
							else
							{
								var uploadformObj = Ext.getCmp('uploadform').getForm();
								if (uploadformObj.isValid())
								{
									uploadformObj.submit({
										method: 'POST',
										success: function (form, action) {
											var jsonText = action.response.responseText;
											var tmpResult = Ext.decode(jsonText);
											if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
											{
												button.up('.window').close();
												Ext.Msg.show({
													title: titleMsg,
													msg: alertSnmpMsg16,
													buttons: Ext.Msg.OK,
													icon: 'iconInformation',
													fn: function(response)
													{
														if (response == 'ok')
														{
															Ext.getCmp('mibWindow').close();
															me.showMibTree(from, fieldName);
														}
													}
												});
											}
											else
											{
												Ext.Msg.show({
													title: titleMsg,
													msg: tmpResult.statusMsg,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
											}
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: titleMsg,
												msg: alertMsg17+'. '+alertMsg18,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								}
							}
						}
					}
				}],
				listeners: {
					afterrender: function () {
						var formObj = Ext.getCmp('uploadform');
						formObj.add({
							xtype: 'hidden',
							name: 'uploadMIB',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'fromMIBBrowser',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'comeFrom',
							value: 'icMIB'
						});
					},
				}
			}]
		}).show()
	},
	mibFileSelection: function(from,fieldName,action,isViaSelection)
	{
		var oid = '';
		var expanded = false;
		var selFile = Ext.getCmp('fileList').getValue();
		if (fieldName == 'ElementOID')
		{
			selElmtFile = selFile;
			elmtFldName = fieldName;
		}
		else if (fieldName == 'StatusOID')
		{
			selStusFile = selFile;
			stusFldName = fieldName;
		}
		else
		{
			selMibFile = selFile;
			oidFldName = fieldName; 
		}
		var src = 'mibTree.jsp?MibFileName='+selFile+'&fieldName='+fieldName+'&from='+from+'&expanded='+expanded;
		if(selFile != '-1')
		{
			var treeStore = Ext.create('Ext.data.TreeStore', {
				fields: [
					{name: 'text', type: 'string'},
					{name: 'leaf', type: 'boolean'},
					{name: 'expanded', defaultValue: true},
					{name: 'id', type: 'string'},
					{name: 'name', type: 'string'},
					{name: 'fullName', type: 'string'},
					{name: 'syntax', type: 'string'},
					{name: 'access', type: 'string'},
					{name: 'status', type: 'string'},
					{name: 'isIndexNode', type: 'boolean'},
					{name: 'isV2Trap', type: 'boolean'},
					{name: 'description', type: 'string'},
				]
			});
			Ext.Ajax.request({
				url: src,
				success: function(response){
					var data = Ext.decode(response.responseText);
					if(data.jsonarray == null || data.jsonarray.length > 0)
					{
						treeStore.setRootNode({
							text: 'MIB Tree',
							id:'',
							iconCls: 'iconTree',
							expandable: false,
							children: data.jsonarray
						});
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('displayFieldCntnr').show();
						Ext.getCmp('objOid').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var treePanel = Ext.create('Ext.tree.Panel',{
							flex: 1,
							rootVisible: true,
							//useArrows: true,
							animate: false,
							store : treeStore,
							listeners: {
								itemclick : function(view, record){
									if(record.get('id') != "")
									{
										Ext.getCmp('objOid').setValue(record.get('id'));
										Ext.getCmp('name').setValue(record.get('name'));
										Ext.getCmp('fullname').setValue(record.get('fullName'));
										Ext.getCmp('syntax').setValue(record.get('syntax'));
										Ext.getCmp('access').setValue(record.get('access'));
										Ext.getCmp('status').setValue(record.get('status'));
										Ext.getCmp('isIndexNode').setValue(record.get('isIndexNode'));
										Ext.getCmp('isV2Trap').setValue(record.get('isV2Trap'));
										Ext.getCmp('description').setValue(record.get('description'));
									}
								}
							}
						});
						Ext.getCmp('treepanalCntnr').add(treePanel);
						if(oid != '')
						{
							Ext.getCmp('objOid').setValue("");
							Ext.getCmp('name').setValue("");
							Ext.getCmp('fullname').setValue("");
							Ext.getCmp('syntax').setValue("");
							Ext.getCmp('access').setValue("");
							Ext.getCmp('status').setValue("");
							Ext.getCmp('isIndexNode').setValue("");
							Ext.getCmp('isV2Trap').setValue("");
							Ext.getCmp('description').setValue("");
							
						}
					}
					else
					{
						var resultMsg = "Invalid MIB file";
						if (!Ext.isEmpty(data.validMsg))
						{
							resultMsg = data.validMsg;
						}
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var emptyPanel = Ext.create('Ext.container.Container',{
							html: "<table align='center'><tr height=150><td valign='bottom' align='center'><div class='iconInformation'/></td></tr><tr><td valign='top' align='center'>"+resultMsg+"</td></tr></table>",
						});
						Ext.getCmp('objOid').setValue("");
						Ext.getCmp('treepanalCntnr').add(emptyPanel);
						Ext.getCmp('displayFieldCntnr').hide();
					}
				}
			});
		}
		else
		{
			Ext.getCmp('objOid').hide();
			Ext.getCmp('treepanalCntnr').hide();
			Ext.getCmp('displayFieldCntnr').hide();
		}
	},
	snmpVersionChange: function(obj) 
	{
		var snmpVerObj = Ext.ComponentQuery.query("#snmpversion")[1];
		var snmpCommObj = Ext.ComponentQuery.query("#snmpcommunity")[0];
		var snmpVersion = snmpVerObj.getValue();

		if (!Ext.isEmpty(snmpVersion) && snmpVersion != undefined && snmpVersion == "v3"  )
		{
			snmpCommObj.hide();
			snmpCommObj.setDisabled(true);

			var contextObj = Ext.ComponentQuery.query("#snmpcontext")[0];
			contextObj.setDisabled(false);
			contextObj.show();

			var usernameObj = Ext.ComponentQuery.query("#snmpusername")[0];
			usernameObj.setDisabled(false);
			usernameObj.show();

			var authPassObj = Ext.ComponentQuery.query("#snmpauthpass")[0];
			authPassObj.setDisabled(false);
			authPassObj.show();

			var authCnfPassObj = Ext.ComponentQuery.query("#snmpauthpassconfirmpassword")[0];
			authCnfPassObj.setDisabled(false);
			authCnfPassObj.show();

			var authTypeObj = Ext.ComponentQuery.query("#snmpauthtype")[0];
			authTypeObj.setDisabled(false);
			authTypeObj.show();

			var encrytFlagObj = Ext.ComponentQuery.query("#snmpencryptflag")[0];
			encrytFlagObj.setDisabled(false);
			encrytFlagObj.show();
			func.changeEncFlagValue();
		}
		else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2"))
		{
			snmpCommObj.show();
			snmpCommObj.setDisabled(false);

			func.snmpUtilV3ParamDisabeld(obj);
		}
	},
	changeEncFlagValue: function(obj) 
	{
		var encryptEnableVal = Ext.getCmp('snmpencryptflagyes').getValue();

		var encTypeObj = Ext.ComponentQuery.query("#snmpencrypttype")[0];
		var encPassObj = Ext.ComponentQuery.query("#snmpencryptpassword")[0];
		var encCnfPassObj = Ext.ComponentQuery.query("#snmpencryptpasswordconfirmpassword")[0];

		if (encryptEnableVal == false)
		{
			encTypeObj.setDisabled(true);
			encTypeObj.hide();

			encPassObj.setDisabled(true);
			encPassObj.hide();

			encCnfPassObj.setDisabled(true);
			encCnfPassObj.hide();
		}
		else
		{
			encTypeObj.setDisabled(false);
			encTypeObj.show();

			encPassObj.setDisabled(false);
			encPassObj.show();

			encCnfPassObj.setDisabled(false);
			encCnfPassObj.show();
		}		
	},
	snmpUtilV3ParamDisabeld: function(obj) 
	{
		var contextObj = Ext.ComponentQuery.query("#snmpcontext")[0];
		contextObj.setDisabled(true);
		contextObj.hide();

		var usernameObj = Ext.ComponentQuery.query("#snmpusername")[0];
		usernameObj.setDisabled(true);
		usernameObj.hide();

		var authPassObj = Ext.ComponentQuery.query("#snmpauthpass")[0];
		authPassObj.setDisabled(true);
		authPassObj.hide();

		var authCnfPassObj = Ext.ComponentQuery.query("#snmpauthpassconfirmpassword")[0];
		authCnfPassObj.setDisabled(true);
		authCnfPassObj.hide();

		var authTypeObj = Ext.ComponentQuery.query("#snmpauthtype")[0];
		authTypeObj.setDisabled(true);
		authTypeObj.hide();

		var encTypeObj = Ext.ComponentQuery.query("#snmpencrypttype")[0];
		encTypeObj.setDisabled(true);
		encTypeObj.hide();
	
		var encFlagObj = Ext.ComponentQuery.query("#snmpencryptflag")[0];
		encFlagObj.setDisabled(true);
		encFlagObj.hide();

		var encPassObj = Ext.ComponentQuery.query("#snmpencryptpassword")[0];
		encPassObj.setDisabled(true);
		encPassObj.hide();

		var encCnfPassObj = Ext.ComponentQuery.query("#snmpencryptpasswordconfirmpassword")[0];
		encCnfPassObj.setDisabled(true);
		encCnfPassObj.hide();
	},

	// Horizon cloud POD starts
	configHorizonMultiUsers: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.HorizonCloudMultipleUsers').show();

		var multidom = '';
		inputsmulti = 2;
		ismulti = 'false';

		var ValueConnSerName = Ext.getCmp('Connection_server_name').getValue();
		var ValueUsrdomain = Ext.getCmp('Domain_name').getValue();
		var Valueuser = Ext.getCmp('User_name').getValue();
		var Valuepass = Ext.getCmp('Password').getValue();

		var splitUsrSerName = ValueConnSerName.split(",");
		var splitUsrDomain = ValueUsrdomain.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addHorizonMultiSet();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				Ext.getCmp('servnamemultiusr'+multidom).setValue(splitUsrSerName[multidom-1]);
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	clearHorizonCloudMultiSet: function(btn) 
	{
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addServersMultiSet').setText('Add');
		Ext.getCmp('NoServersPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateServersMultiSet').disable();
		Ext.getCmp('clearServersMultiSet').disable();
	},
	updateHorizonCloudMultiSet: function(btn) 
	{
		var multiinputs = inputsmulti;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var server = Ext.getCmp('servnamemultiusr'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			if(!checkblank(server))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterServname,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('servnamemultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (!validateIpOrHNameExt(multiServersTitle,Ext.getCmp('servnamemultiusr'+mul)))
			{
				Ext.getCmp('servnamemultiusr'+mul).focus();
				return;
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(uname,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if(pass == "")
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiUsrServnameVal = "";
		var multiUsrdomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiservname= Ext.getCmp('servnamemultiusr'+mulusr).getValue();
			if(multiservname == null) continue;
			if(multiservname != null)
			{
				if(!checkblank(multiservname))
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterServname,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('servnamemultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (!validateIpOrHNameExt(multiServersTitle,Ext.getCmp('servnamemultiusr'+mulusr)))
				{
					Ext.getCmp('servnamemultiusr'+mulusr).focus();
					return;
				}
			}

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterUsr,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecial(multiUname,"@*+=|:;\"\'<>\/[]?,"))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}
			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
			}

			if(multiservname!=null && multidomain!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiServname = Ext.getCmp('servnamemultiusr'+mulusr).getValue();
				multiUsrServnameVal+=tempmultiServname+",";

				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiUsrServnameVal = multiUsrServnameVal.substring(0,multiUsrServnameVal.length-1);
		Ext.getCmp('Connection_server_name').setValue(multiUsrServnameVal);

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('Domain_name').setValue(multiUsrdomainVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('User_name').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (!Ext.isEmpty(Ext.getCmp('Passwordconfirmpassword')))
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}

		Ext.getCmp('Connection_server_name').setReadOnly(true);
		Ext.getCmp('Domain_name').setReadOnly(true);
		Ext.getCmp('User_name').setReadOnly(true);
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('horizoncloudmultipleusers').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	// Horizon cloud POD ends


	// get share folders starts
	getShareFolders: function() 
	{
		Ext.create('SpecificTestConfiguration.view.ShareFoldersConfiguration').show();
		var myDDMask = new Ext.LoadMask(Ext.getCmp('sharefoldersconfiguration'), {msg: 'Trying to collect shared folders from the agent...'});
		myDDMask.show();

		var sharedFoldersVal = Ext.getCmp('Shared_folders').getValue();
		processCompName = Ext.getCmp('componentName').getValue();

		var url = 'SpecificTestConfiguration/data/agentShareFoldderListJson.jsp?componentName='+processCompName+"&configuredFolders="+encodeURI(sharedFoldersVal)+"&shareFoldersFullList="+encodeURI(sharedFoldersFullList);
		Ext.Ajax.request({
			url: url,
			timeout: 600000000,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				publicSharedJson = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var fromFieldDataArr = publicSharedJson['fromFieldDataArr'];
					var toFieldDataArr = publicSharedJson['toFieldDataArr'];
					if(publicSharedJson.timedout)
					{
						if (!Ext.isEmpty(sharedFoldersVal))
						{
							Ext.getCmp('submitShareFolderBtn').show();
						}
						else
						{
							Ext.getCmp('submitShareFolderBtn').hide();
						}
						var errors = publicSharedJson.errors;
						var errorMessageTemplate = func.getErrorMessageTemplate();
						func.showResultWindow(pageName,errorMessageTemplate.apply(errors));
					}
					else
					{
						Ext.getCmp('noShareFolderContainer').hide();
						Ext.getCmp('submitShareFolderBtn').show();

						Ext.getCmp('sharefolderslist').show();
						maskObj = Ext.getCmp('sharefolderslist');

						if (!Ext.isEmpty(publicSharedJson.sharedFoldersFullList))
						{
							sharedFoldersFullList = publicSharedJson.sharedFoldersFullList;
						}

						Ext.getCmp('sharefolderslist').fromField.getStore().removeAll();
						Ext.getCmp('sharefolderslist').toField.getStore().removeAll();

						maskObj.fromField.getStore().loadRawData(fromFieldDataArr);
						maskObj.toField.getStore().loadRawData(toFieldDataArr);
					}
				}
				myDDMask.hide();
			}
		});
	},
	getErrorMessageTemplate :function()
	{
		 var tabledata = new Ext.XTemplate(
			'<div class="plainTable plainTableShadow">',
			'<table cellspacing="0" width="100%" cellpadding="0" border="0" ><col width="200px"><col width="70%">',
				'<thead>',
					'<tr>',
						'<th colspan="2">Error : '+sharefolderLbl7+'</th>',
					'</tr>',
				'</thead>',
			'<tbody>',
			'<tpl for=".">',
				'<tr>',
					'<td class="font_bold11">'+sharefolderLbl8+'</td>',
					'<td>{DESCRIPTION}</td>',
				'</tr>',
				//'<tr>',
					//'<td class="font_bold11">'+validationErrMsg3+'</td>',
					//'<td>{DESCRIPTION}</td>',
				//'</tr>',
			'</tpl>',
			'</tbody>',
			'</table>',
			'</div>'
		);
		return tabledata;
	},
	showResultWindow : function(title,resultText)
	{
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			bodyPadding : 20,
			scroll: true,
			width : 600,
			modal : true,
			autoScroll: true,
			doClose: function() {
				this.destroy();
			},
			html: resultText
		}).show();
	},
	getUpdateShares: function() 
	{
		var myDDMask = new Ext.LoadMask(Ext.getCmp('sharefoldersconfiguration'), {msg: 'Trying to collect latest shared folders from the agent...'});
		myDDMask.show();

		var sharedFoldersVal = Ext.getCmp('Shared_folders').getValue();
		processCompName = Ext.getCmp('componentName').getValue();
		
		var url = 'SpecificTestConfiguration/data/agentShareFoldderListJson.jsp?from=getShareBtn&componentName='+processCompName+"&configuredFolders="+encodeURI(sharedFoldersVal);
		Ext.Ajax.request({
			url: url,
			timeout: 600000000,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				publicSharedJson = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var fromFieldDataArr = publicSharedJson['fromFieldDataArr'];
					var toFieldDataArr = publicSharedJson['toFieldDataArr'];
					if(publicSharedJson.timedout)
					{
						if (Ext.isEmpty(sharedFoldersVal))
						{
							Ext.getCmp('submitShareFolderBtn').hide();
						}
						var errors = publicSharedJson.errors;
						var errorMessageTemplate = func.getErrorMessageTemplate();
						func.showResultWindow(pageName,errorMessageTemplate.apply(errors));
					}
					else
					{
						Ext.getCmp('noShareFolderContainer').hide();
						Ext.getCmp('submitShareFolderBtn').show();

						Ext.getCmp('sharefolderslist').show();
						maskObj = Ext.getCmp('sharefolderslist');

						if (!Ext.isEmpty(publicSharedJson.sharedFoldersFullList))
						{
							sharedFoldersFullList = publicSharedJson.sharedFoldersFullList;
						}
						Ext.getCmp('sharefolderslist').fromField.getStore().removeAll();
						Ext.getCmp('sharefolderslist').toField.getStore().removeAll();

						maskObj.fromField.getStore().loadRawData(fromFieldDataArr);
						maskObj.toField.getStore().loadRawData(toFieldDataArr);
					}
				}
				myDDMask.hide();
			}
		});
	},
	submitShareFolders: function()
	{
		var fromFieldCnt = Ext.getCmp('sharefolderslist').fromField.store.getCount();
		var fromFieldArr = new Array();
		for (var i=0;i < fromFieldCnt;i++)
		{
			var addingVar=Ext.getCmp('sharefolderslist').fromField.store.getAt(i).get('valueField');
			fromFieldArr[fromFieldArr.length]=addingVar;
		}
		var newInfStr="";
		for (i = 0; i < fromFieldArr.length; i++) 
		{
			if (i==0)
			{
				newInfStr=fromFieldArr[i];
			}
			else
			{
				newInfStr+="~|~"+fromFieldArr[i];
			}
		}

		//if (!Ext.isEmpty(newInfStr) && newInfStr != undefined)
		{
			Ext.getCmp('Shared_folders').setValue(newInfStr);
		}

		Ext.getCmp('sharefoldersconfiguration').destroy();

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=processconfiguration',
			method: 'POST',
			async: false
		});

	},
	// get share folders ends

	//Exclude_Interfaces config starts

	excludeInfConfigs: function(reportName){
		rptNam=reportName;
		var usrHost=Ext.getCmp('host').getValue();
		var snmpPort=Ext.getCmp('snmpPort').getValue();
		var snmpCommunity=Ext.getCmp('snmpCommunity').getValue();
		var snmpversion=Ext.getCmp('snmpversion').getValue();
		var timeout=Ext.getCmp('timeout').getValue();
		var  forFrmfieldLoad=Ext.getCmp('Exclude_Interfaces').getValue();
		var exInfcompName = Ext.getCmp('componentName').getValue();
		if(Ext.isEmpty(usrHost) || usrHost == undefined){
			Ext.Msg.show({
				title: 'EXCLUDE INTERFACES',
				msg: 'Please provide host details',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		if(Ext.isEmpty(snmpPort) || snmpPort == undefined || Ext.isEmpty(snmpversion) || snmpversion == undefined || Ext.isEmpty(snmpCommunity) || snmpCommunity == undefined || snmpCommunity == "$unconfigured" ){
			Ext.Msg.show({
				title: 'EXCLUDE INTERFACES',
				msg: 'Please provide SNMP details',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		if(Ext.isEmpty(timeout) || timeout == undefined){
			Ext.Msg.show({
				title: 'EXCLUDE INTERFACES',
				msg: 'Please provide timeout details',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		Ext.create('SpecificTestConfiguration.view.ExcludeInterfaces').show();
		if(forFrmfieldLoad=="none") {
			Ext.getCmp('exInfitemselect').fromField.getStore().removeAll();
			Ext.getCmp('exInfitemselect').toField.getStore().removeAll();

		}else{
			var urlObj1 = 'SpecificTestConfiguration/data/ExcludeInterfacesJson.jsp?';
			Ext.Ajax.request({
				url: urlObj1,
				url: urlObj1,
				params: {
					forFrmfieldLoad:forFrmfieldLoad
				},
				method: "POST",
				timeout: 120000000,
				//async: false,
				success: function(res1) {
					
					if (res1.status == 200 && !Ext.isEmpty(res1.responseText)) {	
						var c = res1.responseText;
						publicfrmFldJson = Ext.decode(c);
						var frmFldArr=publicfrmFldJson['frmFldArr'];
						if (frmFldArr.length!=0) 
						{
							Ext.getCmp('exInfitemselect').fromField.getStore().loadRawData(frmFldArr);
							Ext.getCmp('exInfitemselect').toField.getStore().removeAll();
						} 
					}
				}
			});
		}
	},
	
	getExcludInterfacs: function(){

		var usrHost=Ext.getCmp('host').getValue();
		var snmpPort=Ext.getCmp('snmpPort').getValue();
		var snmpCommunity=Ext.getCmp('snmpCommunity').getValue();
		var snmpversion=Ext.getCmp('snmpversion').getValue();
		var timeout=Ext.getCmp('timeout').getValue();
		var  exInfVal=Ext.getCmp('Exclude_Interfaces').getValue();
		var exInfcompName = Ext.getCmp('componentName').getValue();

		var fromFieldCnt = Ext.getCmp('exInfitemselect').fromField.store.getCount();
		var fromFieldArr = new Array();
		for (var i=0;i < fromFieldCnt;i++)
		{
			var frmFldVar=Ext.getCmp('exInfitemselect').fromField.store.getAt(i).get('valueField');
			fromFieldArr[fromFieldArr.length]=frmFldVar;
		}

		var toFieldCnt = Ext.getCmp('exInfitemselect').toField.store.getCount();
		var toFieldArr = new Array();
		for (var t=0;t < toFieldCnt;t++)
		{
			var toFldVar = Ext.getCmp('exInfitemselect').toField.store.getAt(t).get('valueField');
			toFieldArr[toFieldArr.length]=toFldVar;	
		}

		var exInfMask = new Ext.LoadMask(Ext.getCmp('excludeinterfaces'), {msg: 'Trying to get interface information from the agent.This may take a few minutes.'});
		exInfMask.show();
		var excludInfInput=usrHost+'~'+snmpPort+'~'+snmpCommunity+'~'+snmpversion+'~'+timeout+'~'+rptNam;
		var urlObj = 'SpecificTestConfiguration/data/ExcludeInterfacesJson.jsp?';
		Ext.Ajax.request({
            url: urlObj,
			params:{
				excludInfInput:excludInfInput,
				exInfVal:exInfVal,
				componentName:exInfcompName,
				usrHost:usrHost
			},
            method: "POST",
			timeout: 120000000,
            //async: false,
            success: function(res) {	
                if (res.status == 200 && !Ext.isEmpty(res.responseText)) {
					exInfMask.hide();
                    var b = res.responseText;
					publicExInfJson = Ext.decode(b);
					var toArray=publicExInfJson['exInfFromArr'];

					if (toArray.length > 0) 
					{
						var testArray = new Array();

						var existArray = new Array();
						for (var i=0;i < toArray.length;i++)
						{
							var tmpValueField = toArray[i].valueField;
							if (!Ext.isEmpty(tmpValueField))
							{
								existArray[i]=tmpValueField;
							}
						}

						if (!Ext.isEmpty(fromFieldArr) && fromFieldArr.length != 0)
						{	
							for (var f=0;f < fromFieldArr.length;f++)
							{
								var strFromField = fromFieldArr[f];
								if (!Ext.isEmpty(existArray) && Ext.Array.contains(existArray,strFromField))
								{
									var index = existArray.indexOf(strFromField);
									existArray.splice(index, 1);
								}
							}
						}

						if (!Ext.isEmpty(toFieldArr) && toFieldArr.length != 0)
						{
							for (var t=0;t < toFieldArr.length;t++)
							{
								var strValue = toFieldArr[t];
								var ispresent=false;
								if (!Ext.isEmpty(strValue))
								{
									for(var c=0;c<existArray.length;c++){
										if(existArray[c]==strValue){
											ispresent =true;
										}
									}
									if(!ispresent){
										existArray.push(strValue);
									}
								}
							}
						}

						for (var e=0;e < existArray.length;e++)
						{	
							var resStr=existArray[e]
							var resStrArr=resStr.split('#');
							var testObj ={'groupField':resStrArr[2],'displayField':resStrArr[1],'valueField': resStr};
							testArray.push(testObj);
						}
						if (testArray.length > 0)
						{
							Ext.getCmp('exInfitemselect').toField.getStore().removeAll();

							Ext.getCmp('exInfitemselect').toField.getStore().loadRawData(testArray);
							Ext.getCmp('exInfitemselect').toField.getStore().sort([
								{ property : 'groupField',direction: 'ASC'},{ property : 'displayField',direction: 'ASC'},{property : 'valueField',direction: 'ASC'}]);

						}

						else
						{
							Ext.Msg.show({
								title: 'EXCLUDE INTERFACE',
								msg: 'No interfaces found for configuration ',
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});	
						}
					} 
					else
					{
						exInfMask.hide();
						Ext.Msg.show({
							title: 'EXCLUDE INTERFACE',
							msg: 'No interfaces found for configuration',
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});	
					}
                }
            }
        });
	},

	getexInfacsSearch: function(){
		interfacSearchStr = Ext.getCmp('getInfacDetailSearch').getValue();
		var userdetailsgrid = Ext.getCmp('exInfitemselect');
		userdetailsgrid.show();
		if (interfacSearchStr == "" || interfacSearchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');

			userdetailsgrid.toField.getStore().clearFilter();
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');


			userdetailsgrid.toField.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var dispName = item.get('displayField');
					if (dispName.toLowerCase().indexOf(interfacSearchStr.toLowerCase()) != -1)
					{
						return true;
					}
				}
			});
			userdetailsgrid.toField.getStore().filter(userFilter);
		}
	},

	addExcludInterfacs: function(){
		var fromFieldCnt = Ext.getCmp('exInfitemselect').fromField.store.getCount();
		var fromFieldArr = new Array();
		for (var i=0;i < fromFieldCnt;i++)
		{
			var addingVar=Ext.getCmp('exInfitemselect').fromField.store.getAt(i).get('valueField');
			fromFieldArr[fromFieldArr.length]=addingVar;
		}
		var newInfStr="";
		for (i = 0; i < fromFieldArr.length; i++) {
			if(i==0){
				newInfStr=fromFieldArr[i];
			}else{
				newInfStr+="|"+fromFieldArr[i];
			}
		}
		if(!Ext.isEmpty(newInfStr) && newInfStr != undefined){
			Ext.getCmp('Exclude_Interfaces').setValue(newInfStr);
			Ext.getCmp('excludeinterfaces').close();
		}else{
			Ext.getCmp('Exclude_Interfaces').setValue("none");
			Ext.getCmp('excludeinterfaces').close();
		}
		
	},
	//Exclude_Interfaces config ends

	// AmazonWS workspace logon simulator starts...
	updateAmazonResourceSets: function(btn) 
	{
		var setPublisResource = "";
		var setRegCode = "";
		var setDomain = "";
		var setUsername = "";
		var setPassword = "";

		var rdCnt = 0;
		var totalRules = inputsResourceSet;
		var arrPublisResource = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('publisresource'+j) == undefined)
			{
				continue;
			}

			var pubresource = Ext.getCmp('publisresource'+j).getValue();
			var regcode = Ext.getCmp('regcode'+j).getValue();
			var domain = Ext.getCmp('domain'+j).getValue();
			var uname = Ext.getCmp('username'+j).getValue();
			var pass = Ext.getCmp('pwd'+j).getValue();
			var confpass = Ext.getCmp('confpwd'+j).getValue();

			if (!checkblank(pubresource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(pubresource,"`*+=#.|;\"\'<>\/[]{}()?:"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(pubresource) == "")
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if(!checkHyphenText(pubresource,pubresource))
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if (pubresource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}

			if(!checkblank(regcode))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterRegcode,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(regcode,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}
			else if (domain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domain'+j).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domain'+j).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}

			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if (pass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pwd'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiRegCodeVal = "";
		var multiDomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";

		for(var multi=1; multi<totalRules; multi++)
		{
			if (Ext.getCmp('publisresource'+multi) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?:"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
			}

			var multiRegCode = Ext.getCmp('regcode'+multi).getValue();
			if(!checkblank(multiRegCode))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterRegcode,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiRegCode.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			
			if (multiRegCode.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiRegCode.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(multiRegCode,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}

			var multiDomain = Ext.getCmp('domain'+multi).getValue();
			if(!checkblank(multiDomain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiDomain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (!checkDomain(multiDomain,"true"))
			{
				Ext.getCmp('domain'+multi).focus(true,true);
				return;
			}
			else if (multiDomain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(multiDomain,multiDomain))
			{
				Ext.getCmp('domain'+multi).focus();
				return;
			}
			else if (multiDomain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}

			var multiUname = Ext.getCmp('username'+multi).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+multi).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('username'+multi).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwd'+multi).getValue();
			var multiconfpasswd = Ext.getCmp('confpwd'+multi).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwd'+multi).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
			}
			
			if (multiPublishSrcVal != null && 
				multiRegCode != null && 
				multiDomain != null && 
				multiUname!=null && 
				multipass!=null && 
				multiconfpasswd!=null )
			{
				var tempRegCode = Ext.getCmp('regcode'+multi).getValue();
				multiRegCodeVal+=tempRegCode+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempDomain = Ext.getCmp('domain'+multi).getValue();
				multiDomainVal+=tempDomain+",";

				var tempmultiUsr = Ext.getCmp('username'+multi).getValue();
				multiUsrVal+=tempmultiUsr+"|";

				var tempmultiUsrPass = Ext.getCmp('pwd'+multi).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}

		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);


		multiRegCodeVal = multiRegCodeVal.substring(0,multiRegCodeVal.length-3);
		Ext.getCmp('Registration_code').setValue(multiRegCodeVal);
		Ext.getCmp('Registration_code').backupValue = multiRegCodeVal;

		multiDomainVal = multiDomainVal.substring(0,multiDomainVal.length-1);
		Ext.getCmp('Domain').setValue(multiDomainVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('Username').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}

		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);


		Ext.getCmp('Username').setReadOnly(true);
		Ext.getCmp('Username').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('Registration_code').setReadOnly(true);
		Ext.getCmp('Registration_code').hide();
		Ext.getCmp('Domain').setReadOnly(true);
		Ext.getCmp('Domain').hide();

		Ext.getCmp('egamazonwssimulator').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearAmazonResourceFieldSets: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('backupamazonresrccontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addAmazonResourcebtn').setText('Add');
		Ext.getCmp('NoAmazonResourcePattern').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateAmazonResourceBtn').disable();
		Ext.getCmp('clearAmazonResourceBtn').disable();
	},
	addAmazonWSResourceSet: function(btn) 
	{
		addAmazonResourceSetFields(btn);
	}, 
	configAmazonWSResourceSet: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.EgAmazonWSSimulator').show();
		ismulti = 'false';

		var rname = '';
		inputsResourceSet = 2;
		
		Ext.suspendLayouts();


		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}


		var domain = Ext.getCmp('Domain').getValue();
		var username = Ext.getCmp('Username').getValue();
		var password = Ext.getCmp('Password').getValue();
		var ValueRegCode = Ext.getCmp('Registration_code').getValue();

		var splitPublisResource = ValuePublisresources.split("|");
		var splitUser = username.split(",");
		var splitPass = password.split("#~#");
		var splitRegCode = ValueRegCode.split("#~#");
		var splitDomain = domain.split(",");

		if (splitPublisResource != null || splitPublisResource != undefined)
		{
			for (var k =0;k<splitPublisResource.length-1;k++ )
			{
				addAmazonResourceSetFields();
			}

			for (rname=1;rname<splitPublisResource.length+1;rname++)
			{
				if (Ext.getCmp('publisresource'+rname) == undefined)
				{
					continue;
				}

				var tmpPubResource = splitPublisResource[rname-1];
				if (!Ext.isEmpty(tmpPubResource) && tmpPubResource.indexOf('~#~') != -1)
				{
					tmpPubResource = tmpPubResource.replace(/~#~/g,',');
				}
				var tmpDomain = splitDomain[rname-1];
				var tmpUserId = splitUser[rname-1];
				var tmpPassword = splitPass[rname-1];

				var strRegCode = splitRegCode[rname-1];

				Ext.getCmp('publisresource'+rname).setValue(tmpPubResource);
				Ext.getCmp('regcode'+rname).setValue(strRegCode);
				Ext.getCmp('regcode'+rname).backupValue = strRegCode;
				Ext.getCmp('domain'+rname).setValue(tmpDomain);
				Ext.getCmp('username'+rname).setValue(tmpUserId);
				Ext.getCmp('pwd'+rname).setValue(tmpPassword);
				Ext.getCmp('confpwd'+rname).setValue(tmpPassword);
				Ext.getCmp('pwd'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpwd'+rname).backupValue = tmpPassword;
			}
		}

		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=configureawslogonsimulator',
			method: 'POST',
			async: false
		});
	},
	// AmazonWS workspace logon simulator ends...

	// System properties works starts...
	updatePropertySets: function(btn) 
	{
		var setPropKey = "";
		var setPropVal = "";
		var rdCnt = 0;
		var totalRules = inputsEmail;
		var arrEmailIds = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('syspropkey'+j) == undefined)
			{
				continue;
			}
			var propKey = Ext.getCmp('syspropkey'+j).getValue();
			var propVal = Ext.getCmp('syspropval'+j).getValue();

			if(propKey!=null)
			{
				if (!checkblank(propKey))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: enterSystemPropKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(propKey,"@*+=|:;\"\'<>\/[]?,!"))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}
				else if (propKey.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}

				if (!checkblank(propVal))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: enterSystemPropValue,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(propVal,"~#@*+=|:;\"\'<>\/[]?"))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				else if (propVal.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				setPropKey += propKey + ",";
				if (propVal.indexOf(",") != -1)
				{
					propVal = propVal.replace(/,/g,'~#~');
				}
				setPropVal += propVal + ",";
			}
		}

		setPropKey = setPropKey.substring(0,setPropKey.length-1);
		setPropVal = setPropVal.substring(0,setPropVal.length-1);

		Ext.getCmp('system_property_key').setValue(setPropKey);
		Ext.getCmp('system_property_value').setValue(setPropVal);
		Ext.getCmp('egsystemproperties').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearPropertyFields: function(btn) 
	{
		var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
		propetiesmorecontainer.removeAll();
		Ext.getCmp('addPropBtn').setText('Add');
		Ext.getCmp('NoPropContainer').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updatePropBtn').disable();
		Ext.getCmp('clearPropBtn').disable();
	},
	addMainPropertySet: function(btn) 
	{
		addSystemProperties(btn);
	},
	configSystemProperties: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.EgSystemProperties').show();
		ismulti = 'false';

		var rname = '';
		inputsEmail = 2;
		
		Ext.suspendLayouts();

		var propKey = Ext.getCmp('system_property_key').getValue();
		var propValue = Ext.getCmp('system_property_value').getValue();

		var splitPropKey = propKey.split(",");
		var splitPropVal = propValue.split(",");

		if (splitPropKey != null || splitPropKey != undefined)
		{
			for (var k =0;k<splitPropKey.length-1;k++ )
			{
				addSystemProperties();
			}
			for (rname=1;rname<splitPropKey.length+1;rname++)
			{
				if (Ext.getCmp('syspropkey'+rname) == undefined)
				{
					continue;
				}

				var sysPropKey = splitPropKey[rname-1];
				var sysPropVal = splitPropVal[rname-1];
				
				if (!Ext.isEmpty(sysPropVal) && sysPropVal.indexOf("~#~") != -1)
				{
					sysPropVal = sysPropVal.replace(/~#~/g,',');
				}
				Ext.getCmp('syspropkey'+rname).setValue(sysPropKey);
				Ext.getCmp('syspropval'+rname).setValue(sysPropVal);
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// System properties works ends...

	// Horizon Workspace simulator starts...
	updateResourceSets: function(btn) 
	{
		var setPublisResource = "";
		var setUsername = "";
		var setPassword = "";
		var setSSO = "";

		var rdCnt = 0;
		var totalRules = inputsResourceSet;
		var arrPublisResource = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('publisresource'+j) == undefined)
			{
				continue;
			}

			pubresource = Ext.getCmp('publisresource'+j).getValue();
			uname = Ext.getCmp('username'+j).getValue();
			pass = Ext.getCmp('pwd'+j).getValue();
			confpass = Ext.getCmp('confpwd'+j).getValue();

			var twoFactAuth = Ext.getCmp('twofacttoken'+j).getValue();
			var twofa = Ext.getCmp('twofact'+j).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();

			if (!checkblank(pubresource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(pubresource,"`*+=#.|;\"\'<>\/[]{}()?:"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(pubresource) == "")
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if(!checkHyphenText(pubresource,pubresource))
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if (pubresource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}

			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if (pass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pwd'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
			}

			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		//var multiUsrSSOVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";

		for(var multi=1; multi<totalRules; multi++)
		{
			if (Ext.getCmp('publisresource'+multi) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?:"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
			}

			//var multisso = Ext.getCmp('sso'+multi+'_1').getValue();
			//if(multisso == null) continue;

			var multiUname = Ext.getCmp('username'+multi).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+multi).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('username'+multi).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwd'+multi).getValue();
			var multiconfpasswd = Ext.getCmp('confpwd'+multi).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwd'+multi).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
			}
			
			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+multi+'_1').getValue();
			if(multidisclaimer == null) continue;

			var multi2FAuth= Ext.getCmp('twofacttoken'+multi).getValue();
			var multitwofa = Ext.getCmp('twofact'+multi).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}


			//if(multiPublishSrcVal != null && multisso!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			if(multiPublishSrcVal != null && multiUname!=null && multipass!=null && multiconfpasswd!=null && multi2FAuth != null && multidisclaimer!=null)
			{
				//var tempmultiUsrSSO = Ext.getCmp('sso'+multi+'_1').getValue();
				//var strSSOValue = 'false';
				//if (tempmultiUsrSSO)
				//{
				//	strSSOValue = 'true';
				//}
				//multiUsrSSOVal+=strSSOValue+"|";

				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+multi+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+",";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+multi).getValue();
				var multi2FA = Ext.getCmp('twofact'+multi).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('username'+multi).getValue();
				multiUsrVal+=tempmultiUsr+"|";

				var tempmultiUsrPass = Ext.getCmp('pwd'+multi).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}

		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);


		//multiUsrSSOVal = multiUsrSSOVal.substring(0,multiUsrSSOVal.length-1);
		//Ext.getCmp('Single_signon').setValue(multiUsrSSOVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('User_id').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);
		Ext.getCmp('Two_factor_auth_password').setValue(multi2FAuthVal);
		Ext.getCmp('Two_factor_auth_password').backupValue = multi2FAuthVal;

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);
		Ext.getCmp('Disclaimer').setValue(multiUsrdisclaimVal);


		//Ext.getCmp('Single_signon').setReadOnly(true);
		//Ext.getCmp('Single_signon').hide();
		Ext.getCmp('User_id').setReadOnly(true);
		Ext.getCmp('User_id').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('Two_factor_auth_password').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').hide();
		Ext.getCmp('Disclaimer').setReadOnly(true);
		Ext.getCmp('Disclaimer').hide();

		Ext.getCmp('eghorizonwssimulator').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearResourceFieldSets: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('backupmulticontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addResourcebtn').setText('Add');
		Ext.getCmp('NoResourcePattern').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateResourceBtn').disable();
		Ext.getCmp('clearResourceBtn').disable();
	},
	addHorizonWSResourceSet: function(btn) 
	{
		addResourceSetFields(btn);
	}, 
	configHorizonWSResourceSet: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.EgHorizonWSSimulator').show();
		ismulti = 'false';

		var rname = '';
		inputsResourceSet = 2;
		
		Ext.suspendLayouts();


		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}


		var username = Ext.getCmp('User_id').getValue();
		var password = Ext.getCmp('Password').getValue();
		var ValueUsrdisclaimer = Ext.getCmp('Disclaimer').getValue();
		var ValueUsr2FA = Ext.getCmp('Two_factor_auth_password').getValue();

		//var sso = Ext.getCmp('Single_signon').getValue();

		var splitPublisResource = ValuePublisresources.split("|");
		var splitUser = username.split("|");
		//var splitSSO = sso.split("|");
		var splitPass = password.split("#~#");
		var splitUsr2FA = ValueUsr2FA.split("#~#");
		var splitUsrDisclaim = ValueUsrdisclaimer.split(",");

		if (splitPublisResource != null || splitPublisResource != undefined)
		{
			for (var k =0;k<splitPublisResource.length-1;k++ )
			{
				addResourceSetFields();
			}

			for (rname=1;rname<splitPublisResource.length+1;rname++)
			{
				if (Ext.getCmp('publisresource'+rname) == undefined)
				{
					continue;
				}

				var tmpPubResource = splitPublisResource[rname-1];
				if (!Ext.isEmpty(tmpPubResource) && tmpPubResource.indexOf('~#~') != -1)
				{
					tmpPubResource = tmpPubResource.replace(/~#~/g,',');
				}
				var tmpUserId = splitUser[rname-1];
				var tmpPassword = splitPass[rname-1];

				var str2FAToken = splitUsr2FA[rname-1];
				var strDisClaimer = splitUsrDisclaim[rname-1];
				if (!Ext.isEmpty(str2FAToken) && (str2FAToken != 'FF6EBC35F4F93E0C1057BBC2E53B1DF3' && str2FAToken.toLowerCase() != 'none'))
				{
					Ext.getCmp('twofactlabel'+rname+'_1').setValue(true);
					Ext.getCmp('twofacttoken'+rname).setVisible(true);
					Ext.getCmp('twofacttoken'+rname).setValue(str2FAToken);
					Ext.getCmp('twofacttoken'+rname).backupValue = str2FAToken;
				}

				if (!Ext.isEmpty(strDisClaimer))
				{
					if (strDisClaimer.toLowerCase() == 'true')
					{
						Ext.getCmp('disclaimermultiusr'+rname+'_1').setValue(true);
					}
					else
					{
						Ext.getCmp('disclaimermultiusr'+rname+'_2').setValue(true);
					}
				}

				Ext.getCmp('publisresource'+rname).setValue(tmpPubResource);
				Ext.getCmp('username'+rname).setValue(tmpUserId);
				Ext.getCmp('pwd'+rname).setValue(tmpPassword);
				Ext.getCmp('confpwd'+rname).setValue(tmpPassword);
				Ext.getCmp('pwd'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpwd'+rname).backupValue = tmpPassword;
				//var strSSO = splitSSO[rname-1];
				//if (!Ext.isEmpty(strSSO))
				//{
				//	if (strSSO.toLowerCase() == 'true')
				//	{
				//		Ext.getCmp('sso'+rname+'_1').setValue(true);
				//	}
				//	else
				//	{
				//		Ext.getCmp('sso'+rname+'_2').setValue(true);
				//	}
				//}
			}
		}

		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// Horizon Workspace simulator ends...
	
	// Site URL configuration starts...
	addURLs: function(btn) {
		firstClick = true;
		// not yet start
		addURLsConf('isTextFocus');
	},
	callSitUrlDestroy: function()
	{
		firstClick = true;
	},
	siteUrlConfigs: function() { 
		frstClk = true;
		var isChecked=false;
		var processinfo=false;
		var dbServerf=Ext.getCmp('Database_Server').getValue();
		var dbusrNamef=Ext.getCmp('Database_User_name').getValue();
		var dbPassf=Ext.getCmp('Database_password').getValue();
		var dbinstancf=Ext.getCmp('instance').getValue();
		var dbNamf=Ext.getCmp('Database_name').getValue();
		var sqlPortf=Ext.getCmp('SQL_Port_number').getValue();
		var sslsitf=Ext.getCmp('ssl1').getValue();
		var isntlmvf=Ext.getCmp('isntlmv21').getValue();
		var dbDomainf=Ext.getCmp('Database_Domain').getValue();
		var sitChkDBInput=dbServerf+'~'+dbusrNamef+'~'+dbPassf+'~'+dbinstancf+'~'+dbNamf+'~'+sqlPortf+'~'+dbDomainf+'~'+sslsitf+'~'+isntlmvf;
		var sitcomponentNamef = Ext.getCmp('componentName').getValue();
		//empty validation
		if(Ext.isEmpty(dbServerf) || dbServerf == undefined || Ext.isEmpty(dbusrNamef) || dbusrNamef == undefined || Ext.isEmpty(dbPassf) || dbPassf == undefined || Ext.isEmpty(dbinstancf) || dbinstancf == undefined || Ext.isEmpty(dbNamf) || dbNamf == undefined ){
			Ext.Msg.show({
				title: 'SITE URL CONFIGURATION',
				msg: 'Please provide user credentials and database information',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		if(Ext.isEmpty(sqlPortf) || sqlPortf == undefined || Ext.isEmpty(dbDomainf) || dbDomainf == undefined){
			Ext.Msg.show({
				title: 'SITE URL CONFIGURATION',
				msg: 'Please provide user credentials and database information',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		if(dbServerf == '$unconfigured' || dbusrNamef == '$unconfigured' || dbPassf == '$unconfigured' ||  dbDomainf == '$unconfigured' || dbNamf == '$unconfigured' ){
			Ext.Msg.show({
				title: 'SITE URL CONFIGURATION',
				msg: 'Please provide user credentials and database information',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		Ext.create('SpecificTestConfiguration.view.SiteURLConfiguration').show();
		var cNme = publicJson['componentName'];
		if (cNme != null && cNme.indexOf(":NULL") > -1)
		{
			cNme = cNme.substring(0,cNme.indexOf(":NULL"));
		}	
		noServiceConfig = 'false';
		//var sitUrls = Ext.getCmp('site_URL(S)').getValue();
		var sitUrls = Ext.getCmp('site_URL(S)').backupValue;
		var siteUrlsArray = new Array();
		var siteUrlNamArr=new Array();
		var situArray=new Array();
		var siteArrOne=new Array();
		if(!Ext.isEmpty(sitUrls) && sitUrls.indexOf(',') != -1){
			situArray = sitUrls.split(',');	
			for(b=0; b<situArray.length; b++){
				if(situArray[b].indexOf('~#~') != -1){
					siteArrOne=situArray[b].split('~#~');
					siteUrlNamArr[b]=siteArrOne[0];
					siteUrlsArray[b] = siteArrOne[1];
				}
				else{
					siteUrlNamArr[b]=situArray[b];
					siteUrlsArray[b]=situArray[b];
				}
			}	
		}
		else{
			if(sitUrls.indexOf('~#~') != -1){
				siteArrOne=sitUrls.split('~#~');
				siteUrlNamArr[0]=siteArrOne[0];
				siteUrlsArray[0] = siteArrOne[1];
			}else{
				siteUrlNamArr[0]=sitUrls;
				siteUrlsArray[0]=sitUrls;
			}
		}
		if (!Ext.getCmp(siteUrlsArray) && siteUrlsArray != undefined){
			var s = '';
			inputsService = 2;
			var mainSiturlForm = Ext.getCmp('siteurlcontainer');
			Ext.suspendLayouts();
			for (var k =0;k<siteUrlsArray.length-1;k++ ){
				addURLsConf('');
			}
			for (s=0;s<siteUrlsArray.length;s++){
				Ext.getCmp('siteUsageUnam'+(s+1)).setValue(siteUrlNamArr[s]);
				Ext.getCmp('siteUsage'+(s+1)).setValue(siteUrlsArray[s]);
			}
			Ext.resumeLayouts(true);
			mainSiturlForm.doLayout();
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=siteurlconfiguration',
			method: 'POST',
			async: false
		});
	},

	updateSiteURLs: function(btn) {
		frstClk = true;
		var result="";
		var checkWithVar = this.checkBeforeUrlAdding();
		if(checkWithVar)
		{
			var tmpBackupVal = '';
			for(var k=1;k<inputsService;k++)
			{
				if (Ext.isEmpty(Ext.getCmp('siteUsage'+k)) || Ext.getCmp('siteUsage'+k) == undefined)
				{
					continue;
				}
					url_name = Ext.getCmp('siteUsage'+k).getValue();
					site_Nam=Ext.getCmp('siteUsageUnam'+k).getValue();
					var fullNam=site_Nam+'~#~'+url_name
					if(result.length==0)
					{
						result = fullNam;
						tmpBackupVal = site_Nam;
					}
					else
					{
						result += "," + fullNam;
						tmpBackupVal += "," + site_Nam;
					}
			}
			this.callUrlSessionAttribute(result);
			Ext.getCmp('siteurlconfiguration').destroy();
			
			firstgetService = true;
			if (!Ext.isEmpty(result) && result != undefined)
			{
				Ext.getCmp('site_URL(S)').setValue(tmpBackupVal);
				Ext.getCmp('site_URL(S)').backupValue = result;
			}
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	callUrlSessionAttribute: function(result) {
			Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/setSessionAttributeJson.jsp',
			method: 'POST',
			params: {'whereFrom':'serviceConfig','attributeName':'paramValue','attributeValue':result},
			success: function( response )
			{
			}
		});
	},

	checkBeforeUrlAdding: function() {
		var allowToUpdate = true;
		for(var k=1;k<inputsService;k++)
		{
			if (Ext.isEmpty(Ext.getCmp('siteUsage'+k)) || Ext.getCmp('siteUsage'+k) == undefined)
			{
				continue;
			}

			siteUsageValue = Ext.getCmp('siteUsage'+k).getValue();
			if(siteUsageValue.trim() == ""){
				Ext.Msg.show({
						title: 'SITE URL CONFIGURATION',
						msg:'Please enter URL ',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('siteUsage'+k).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
			}
			if(siteUsageValue.indexOf("$") > -1){
				Ext.Msg.show({
						title: 'SITE URL CONFIGURATION',
						msg:'Please enter URL ',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('siteUsage'+k).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
			}

			siteUsageUnamValue = Ext.getCmp('siteUsageUnam'+k).getValue();
			if(siteUsageUnamValue.trim() == ""){
				Ext.Msg.show({
						title: 'SITE URL CONFIGURATION',
						msg:'Please enter URL Name',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('siteUsageUnam'+k).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
			}
			if(siteUsageUnamValue.indexOf("$") > -1){
				Ext.Msg.show({
						title: 'SITE URL CONFIGURATION',
						msg:'Please enter URL Name',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('siteUsageUnam'+k).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
			}

			for(l=k+1;l<inputsService;l++)
			{
				if(Ext.getCmp("siteUsageUnam"+l) == null || Ext.getCmp("siteUsageUnam"+l)=='null')
				{
					continue;
				}
				site_name_2 = Ext.getCmp("siteUsageUnam"+l).value;
				if (siteUsageUnamValue == site_name_2)
				{
					Ext.Msg.show({
						title:'SITE URL CONFIGURATION',
						msg:alert_2,
						buttons:Ext.Msg.OK,
						icon:'iconExclamation',
						fn: function() {
							Ext.getCmp("siteUsageUnam"+l).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
				}
				else if (siteUsageUnamValue.toLowerCase() == site_name_2.toLowerCase())
				{
					Ext.Msg.show({
						title:'SITE URL CONFIGURATION',
						msg:alert_3,
						buttons:Ext.Msg.OK,
						icon:'iconExclamation',
						fn: function() {
							Ext.getCmp("siteUsageUnam"+l).focus(true,true);
						}
					});
					allowToUpdate = false;
					break;
				}
			}
		}
		return allowToUpdate;
	},

	clearSiteURLs: function(btn) {
		var siteurlcontainer = Ext.getCmp('siteurlcontainer');
		siteurlcontainer.removeAll();

		Ext.getCmp('addURLsConfbtn').setText('Add');
		Ext.getCmp('NoSiteurlConf').show();
		if (Ext.getCmp('siteurl_conf1') != null || Ext.getCmp('siteurl_conf1') != undefined)
		{
			noSiteurlConfig = 'true';
			Ext.getCmp('siteurl_conf1').removeAll();
			Ext.getCmp('siteurl_conf1').hide();
		}
		Ext.getCmp('updateSitURLs').disable();
		Ext.getCmp('clearSitURLs').disable();
	},

	getSiteURLs: function() {
		frstClk = true;
		Ext.create('SpecificTestConfiguration.view.SiteUrlDetailedConfiguration').show();
		Ext.getCmp('getsitDetailSearch').hide();
		Ext.getCmp('siteurlselect').hide();
		var userdetailsgrid = Ext.getCmp('siteurlselect');
		userdetailsgrid.getStore().clearFilter();
		var myDDMask = new Ext.LoadMask(Ext.getCmp('siteurldetailedconfiguration'), {msg: 'Please wait. It will take a while to get site URLs...'});
		myDDMask.show();
		var sitcomponentName = Ext.getCmp('componentName').getValue();
		var dispName = sitcomponentName;
		if (!Ext.isEmpty(sitcomponentName) && sitcomponentName.lastIndexOf(":NULL") != -1){
			dispName = sitcomponentName.substring(0,sitcomponentName.lastIndexOf(":NULL"));
		}
		dont_show = "";
		
		//credential validation
		var dbServer=Ext.getCmp('Database_Server').getValue();
		var dbusrName=Ext.getCmp('Database_User_name').getValue();
		var dbPass=Ext.getCmp('Database_password').getValue();
		var dbinstanc=Ext.getCmp('instance').getValue();
		var dbNam=Ext.getCmp('Database_name').getValue();
		var sqlPort=Ext.getCmp('SQL_Port_number').getValue();
		var sslsit=Ext.getCmp('ssl1').getValue();
		var isntlmv2sit=Ext.getCmp('isntlmv21').getValue();
		var dbDomain=Ext.getCmp('Database_Domain').getValue();
		sitLstInput=dbServer+'~'+dbusrName+'~'+dbPass+'~'+dbinstanc+'~'+dbNam+'~'+sqlPort+'~'+dbDomain+'~'+sslsit+'~'+isntlmv2sit;

		var urlObj = 'SpecificTestConfiguration/data/siteURLsListJson.jsp?dummy=dummy&componentName='+encodeURIComponent(sitcomponentName)+'&sitLstInput='+sitLstInput;
		Ext.Ajax.request({
			url: urlObj,
			method: 'POST',
			timeout: 60000000,
			success: function( response )
			{
				var jsonText = response.responseText;
				publicServiceJson = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					if(publicServiceJson.timedout)//|| publicServiceJson.alreadyConfigured 
					{
						myDDMask.hide();
						Ext.getCmp('noSiteurlContainer').show();
						Ext.getCmp('noSiteurlLabel').update(publicServiceJson.timedoutOrAlreadyConfigLabel);
						Ext.getCmp('siteurlselect').hide();
					}
					else if(publicServiceJson.isEmptyList)
					{
						myDDMask.hide();
						Ext.getCmp('noSiteurlContainer').show();
						Ext.getCmp('noSiteurlLabel').update(publicServiceJson.isEmptyListLabel);
						Ext.getCmp('siteurlselect').hide();
					} 
					else if(publicServiceJson.existView){
						myDDMask.hide();
						Ext.getCmp('noSiteurlContainer').show();
						Ext.getCmp('noSiteurlLabel').update(publicServiceJson.isexistViewLabel);
						Ext.getCmp('siteurlselect').hide();
					}
					else
					{
						Ext.getCmp('noSiteurlContainer').hide();
						Ext.getCmp('submitSitUrlDet').show();
						Ext.getCmp('siteurlselect').show();
						var dataArr = publicServiceJson['sitUrlListArr'];

						if(dataArr[0].valueField=='Connection failed'){
							myDDMask.hide();
							Ext.Msg.show({
								title: 'SITE URL CONFIGURATION',
								msg: 'Please check credentials',
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp('siteurldetailedconfiguration').destroy();
							Ext.getCmp('siteurlconfiguration').destroy();
							return false;
						} else {
							
							var outputArr = new Array();
							var newCnt = 0;
							var urlArr=new Array();
							urlArr=[];
							for(var k=1;k<inputsService;k++) {
								
								if (Ext.isEmpty(Ext.getCmp('siteUsage'+k)) || Ext.getCmp('siteUsage'+k) == undefined){
									urlArr[k-1]='$unconfigured';
									continue;
								}
								else{
									urlArr[k-1]=Ext.getCmp('siteUsage'+k).getValue();
								}
							}

							var unconfigCnt=0;
							for (var e=0;e<dataArr.length ;e++ ){
								var ischkData=true;
								var strFrmt=dataArr[e].displayField;
								for (var q=0;q<urlArr.length ;q++ ){
									if(urlArr[q]!='$unconfigured')
									{
										if(urlArr[q].toLowerCase() === strFrmt.toLowerCase()){
											ischkData=false;
											break;
										}
									}else {
										unconfigCnt++;
									}
								}
								if(ischkData){
									outputArr[newCnt] = dataArr[e];
									newCnt++;
								}
							}

							if(urlArr.length==unconfigCnt) {
								Ext.getCmp('getsitDetailSearch').show();
								Ext.getCmp('siteurlselect').getStore().removeAll();
								Ext.getCmp('siteurlselect').getStore().loadRawData(dataArr);
								unconfigCnt=0;
							}
							else
							{
								if(outputArr.length==0) 
								{
									myDDMask.hide();
									Ext.getCmp('noSiteurlContainer').show();
									Ext.getCmp('noSiteurlLabel').update("<table align='center' height='250'><tr><td align='center' ><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+allConfiguredLbl+".</td></tr></table></td></tr></table>");
									Ext.getCmp('siteurlselect').hide();
								} else
								{
									Ext.getCmp('getsitDetailSearch').show();
									Ext.getCmp('siteurlselect').getStore().loadRawData('');
									Ext.getCmp('siteurlselect').getStore().loadRawData(outputArr);
								}
							}
						}
					}
				}
				myDDMask.hide();
			},
			failure: function(form)
			{
				myDDMask.hide();
				console.log('form',form);
			}
		});
	},

	getSitURLsDtlSearch : function(){
		urlSearchStr = Ext.getCmp('getsitDetailSearch').getValue();
		var userdetailsgrid = Ext.getCmp('siteurlselect');
		
		Ext.getCmp('submitSitUrlDet').show();
		Ext.getCmp('noSiteurlContainer').hide()
		userdetailsgrid.show();

		if (urlSearchStr == "" || urlSearchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');

			userdetailsgrid.getStore().clearFilter();
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');


			userdetailsgrid.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var dispName = item.get('displayField');
					if (dispName.toLowerCase().indexOf(urlSearchStr.toLowerCase()) != -1)
					{
						return true;
					}
				}
			});
			userdetailsgrid.getStore().filter(userFilter);
		}

		if (userdetailsgrid.getStore().getCount() == 0)
		{
			userdetailsgrid.hide();
			Ext.getCmp('submitSitUrlDet').hide();
			Ext.getCmp('noSiteurlContainer').show();
			Ext.getCmp('noSiteurlLabel').update('<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No record found for your current search.</td></tr></table></td></tr></table>');

		}
	},
	
	submitSiteURLs: function(){
		frstClk = true;
		var sitUrlCotnrCount = Ext.getCmp('siteurlcontainer').items;
		var sittUsageArr = new Array();
		for(var c=1;c<inputsService;c++){
			if(Ext.isEmpty(Ext.getCmp('siteUsage'+c)) || Ext.getCmp('siteUsage'+c) == undefined){
				sittUsageArr[0]='$unconfigured';
				break;
				//continue;
			}else{	
				sittUsageArr[c-1]=Ext.getCmp('siteUsage'+c).getValue();
			}	
		}

		var submitToMain = Ext.getCmp('siteurlselect').getValue();
		var strSubmitToMain = submitToMain;
		var submitToMain = submitToMain.toString().trim();
		if (submitToMain.length <=1)
		{
			strSubmitToMain = submitToMain.toString().trim();
		}

		if (Ext.isEmpty(strSubmitToMain) || strSubmitToMain == undefined )
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectSitUrlName,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var siteurlArr = new Array();
		if (!Ext.isEmpty(submitToMain) && submitToMain.indexOf(',') != -1)
		{
			siteurlArr = submitToMain.split(',');
		}
		else
		{
			siteurlArr[0] = submitToMain;
		}
		if(siteurlArr.length!=0){
			var chkIsExist=false;
			var errCount=0;
			for(var e=0;e<sittUsageArr.length;e++){
				for(var f=0;f<siteurlArr.length;f++){
					if(sittUsageArr[e].toLowerCase()==siteurlArr[f].toLowerCase()){
						chkIsExist=true;
						errCount++;
					}	
				}
			}
			if(chkIsExist){
				if(errCount==1){
					Ext.Msg.show({
						title: pageName,
						msg: 'URL is already selected',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}else{
					Ext.Msg.show({
						title: pageName,
						msg: errCount+' URLs are already selected',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;	
				}
			}
		}
		var existcount = inputsService;
		Ext.getCmp('siteurldetailedconfiguration').destroy();
		//Ext.getCmp('siteUrlSearchTrigger').reset();
		var noDataSearchLabelObj = Ext.getCmp('noSearchDataLabel');
		if (!Ext.isEmpty(noDataSearchLabelObj) && noDataSearchLabelObj != undefined)
		{
			var siturlcontainer = Ext.getCmp('siteurlcontainer');
			siturlcontainer.remove(Ext.getCmp('noSearchDataLabel'));
		}

		var addedServiceCount = 0;
		var totalServiceCount = 0;
		var ss = 0;
		var serviceLength = siteurlArr.length;

		var defaultSiturlObj = Ext.getCmp('siteUsage1');
		if (!Ext.isEmpty(defaultSiturlObj) && defaultSiturlObj != undefined)
		{
			totalServiceCount++;
			ss = 1;

			var firstNameVal = Ext.getCmp('siteUsage1').getValue();
			if((Ext.isEmpty(firstNameVal) || firstNameVal == '$unconfigured') && firstNameVal != undefined)
			{
				addedServiceCount++;
			}
		}

		var serviceObject = Ext.getCmp('siteurlcontainer').items;
		var serviceCount = serviceObject.length;
		if (serviceCount > 0)
		{
			for (var t = 0;t<serviceCount;t++)
			{
				totalServiceCount++;
				var pattXtype = serviceObject.items[t].xtype;
				if (pattXtype == 'fieldset')
				{
					var pattId = serviceObject.items[t].id;
					var tempPattId = pattId.substring(pattId.lastIndexOf("_conf")+5);
					var serviceVal = Ext.getCmp('siteUsage'+tempPattId).getValue();
					if ((Ext.isEmpty(serviceVal) || serviceVal == '$unconfigured') &&
						serviceVal != undefined)
					{
						addedServiceCount++;
					}
				}
			}
		}

		if (addedServiceCount > 0 && serviceLength > addedServiceCount)
		{
			serviceLength = serviceLength - addedServiceCount;
		}
		else if (addedServiceCount > 0 && serviceLength < addedServiceCount)
		{
			serviceLength =  0;
		}
		else if (serviceLength == addedServiceCount)
		{
			serviceLength = 0;
		}

		var mainSiteForm = Ext.getCmp('siteurlcontainer');
		Ext.suspendLayouts();
		for (var m=0;m<serviceLength;m++ )
		{
			addURLsConf('');
			totalServiceCount++;
		}
		Ext.resumeLayouts(true);
		mainSiteForm.doLayout();

		var cnt = 0;
		for (var s=ss;s<inputsService;s++)
		{
			if (Ext.getCmp('siteUsage'+s) == undefined)
			{
				continue;
			}
			var siteVal = Ext.getCmp('siteUsage'+s).getValue();
			if (!Ext.isEmpty(siteVal) &&
				siteVal != undefined &&
				siteVal != '$unconfigured')
			{
				continue;
			}
			var siteUrlNam = siteurlArr[cnt];
			cnt++;	
			if (siteUrlNam != undefined)
			{		
				Ext.getCmp('siteUsage'+s).setValue(siteUrlNam);
			}

		}
		frstClk = true;

		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=siteurlconfiguration',
			method:'POST'
		});
	},
	// Site URL configuration ends...
	
	// for Horizon Logon simulator starts
	configMultiHLSFieldSet: function(btn) {
		Ext.create('SpecificTestConfiguration.view.EgHLSPublishedResources').show();

		var multidom = '';
		inputsmultisrc = 2;
		ismultisrc = 'false';

		//var ValuePublisresources = Ext.getCmp('Published_resources').getValue();
		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		var ValueUsrdomain = Ext.getCmp('Domain').getValue();
		var ValueUsrdisclaimer = Ext.getCmp('Disclaimer').getValue();
		var ValueUsr2FA = Ext.getCmp('Two_factor_auth_password').getValue();
		var Valueuser = Ext.getCmp('Username').getValue();
		var Valuepass = Ext.getCmp('Password').getValue();
		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}

		var splitPublisSrc = ValuePublisresources.split("|");
		var splitUsr2FA = ValueUsr2FA.split("#~#");
		var splitUsrDomain = ValueUsrdomain.split(",");
		var splitUsrDisclaim = ValueUsrdisclaimer.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addMultiHLSContact();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				if (!Ext.isEmpty(splitPublisSrc[multidom-1]) && splitPublisSrc[multidom-1].indexOf('~#~') != -1)
				{
					splitPublisSrc[multidom-1] = splitPublisSrc[multidom-1].replace(/~#~/g,',');
				}

				var str2FAToken = splitUsr2FA[multidom-1];
				var strDisClaimer = splitUsrDisclaim[multidom-1];
				if (!Ext.isEmpty(str2FAToken) && (str2FAToken != 'FF6EBC35F4F93E0C1057BBC2E53B1DF3' && str2FAToken.toLowerCase() != 'none'))
				{
					Ext.getCmp('twofactlabel'+multidom+'_1').setValue(true);
					Ext.getCmp('twofacttoken'+multidom).setVisible(true);
					Ext.getCmp('twofacttoken'+multidom).setValue(str2FAToken);
					Ext.getCmp('twofacttoken'+multidom).backupValue = str2FAToken;
				}

				Ext.getCmp('publisresource'+multidom).setValue(splitPublisSrc[multidom-1]);
				
				if (!Ext.isEmpty(strDisClaimer))
				{
					if (strDisClaimer.toLowerCase() == 'true')
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_1').setValue(true);
					}
					else
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_2').setValue(true);
					}
				}
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	addMultiHLSSource: function(btn) {
		addMultiHLSContact(btn);
	},
	ClearMultiHLSSource: function() {
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addMultiHLSbtn').setText('Add');
		Ext.getCmp('NoMultiUsrPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismultisrc = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateMultiHLSbtn').disable();
		Ext.getCmp('clearMultiHLSbtn').disable();
	},
	UpdateMultiHLSSource: function() {

		var multiinputs = inputsmultisrc;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var publishResource = Ext.getCmp('publisresource'+mul).getValue();
			var twoFactAuth = Ext.getCmp('twofacttoken'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			var twofa = Ext.getCmp('twofact'+mul).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();

			if (!checkblank(publishResource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(publishResource,"`*+=#.|;\"\'<>\/[]{}()?"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(publishResource) == "")
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			else if(!checkHyphenText(publishResource,publishResource))
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			else if (publishResource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf(":") > -1)
			{
				var val = publishResource;
				if (val.indexOf(",") != -1)
				{
					var values = val.split(",");
					for(var v=0;v < values.length;v++)
					{
						var tmpVal = values[v];

						if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < tmpVal.length;k++)
							{
								if (tmpVal.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mul).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
								else
								{
									continue;
								}
							}
							
							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
				else
				{
					if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
					{
						Ext.Msg.show ({
							title: pageName,
							msg: "Published resource should not start or end with a colon",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('publisresource'+mul).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var moreColons = new Array();
						for(var k=0;k < val.length;k++)
						{
							if (val.charAt(k) == ':')
							{
								moreColons.push(k);
							}

							if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Cannot have ':' in consecutive positions",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return ;
							}
							else
							{
								continue;
							}
						}

						if (moreColons.length > 1)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							moreColons = new Array();
							return;
						}
					}
				}
			}
			
			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if(pass == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiUsrdomainVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf(":") > -1)
				{
					var val = multiSrcPublis;
					if (val.indexOf(",") != -1)
					{
						var values = val.split(",");
						for(var v=0;v < values.length;v++)
						{
							var tmpVal = values[v];

							if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Published resource should not start or end with a colon",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								return;
							}
							else
							{
								var moreColons = new Array();
								for(var k=0;k < tmpVal.length;k++)
								{
									if (tmpVal.charAt(k) == ':')
									{
										moreColons.push(k);
									}
									if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
									{
										Ext.Msg.show ({
											title: pageName,
											msg: "Cannot have ':' in consecutive positions",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function() {
												Ext.getCmp('publisresource'+mulusr).focus(true,true);
											}
										});
										moreColons = new Array();
										return;
									}
									else
									{
										continue;
									}
								}

								if (moreColons.length > 1)
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
							}
						}
					}
					else
					{
						if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mulusr).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < val.length;k++)
							{
								if (val.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return ;
								}
								else
								{
									continue;
								}
							}

							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
			}

			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
			if(multidisclaimer == null) continue;

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multi2FAuth= Ext.getCmp('twofacttoken'+mulusr).getValue();
			var multitwofa = Ext.getCmp('twofact'+mulusr).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}
			
			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
			}

			if(multiPublishSrcVal != null && multi2FAuth != null && multidomain!=null && multidisclaimer!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+",";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+mulusr).getValue();
				var multi2FA = Ext.getCmp('twofact'+mulusr).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);
		Ext.getCmp('Two_factor_auth_password').setValue(multi2FAuthVal);
		Ext.getCmp('Two_factor_auth_password').backupValue = multi2FAuthVal;

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('Domain').setValue(multiUsrdomainVal);

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);
		Ext.getCmp('Disclaimer').setValue(multiUsrdisclaimVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('Username').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').hide();
		Ext.getCmp('Domain').setReadOnly(true);
		Ext.getCmp('Domain').hide();
		Ext.getCmp('Disclaimer').setReadOnly(true);
		Ext.getCmp('Disclaimer').hide();
		Ext.getCmp('Username').setReadOnly(true);
		Ext.getCmp('Username').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('eghlspublishedresources').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	// for Horizon Logon simulator ends
	
	// Exchange site email starts...
	updateEmailSets: function(btn) 
	{
		var setEmailId = "";
		var setPassword = "";
		var rdCnt = 0;
		var totalRules = inputsEmail;
		var arrEmailIds = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('emailid'+j) == undefined)
			{
				continue;
			}
			emailID = Ext.getCmp('emailid'+j).getValue();
			pass = Ext.getCmp('pass'+j).getValue();
			confpass = Ext.getCmp('confpass'+j).getValue();

			if(emailID!=null)
			{
				var result = validateEmail(emailID);
				rdCnt++;
				if(!checkblank(emailID) || (emailID == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: mailRcv_valid,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!validateSingleByte(emailID))
				{
					Ext.Msg.show(
					{
						title : ExchangeTitle,
						msg : mailIDDBL+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if(result == null || result == undefined || result == false)
				{
					Ext.Msg.show({
						title : ExchangeTitle,
						msg : mailRcv_valid+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if (emailID.indexOf(',') != -1)
				{
					Ext.Msg.show({
						title : ExchangeTitle,
						msg : mail_valid+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}

				var x_idx = arrEmailIds.indexOf(emailID);
				if (x_idx != -1)
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: duplicateMailId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				arrEmailIds[j] = emailID;
			}


			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pass'+j).focus(true,true);
						}
					});
					return;
				}
				else if (pass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pass'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpass'+j).focus(true,true);
						}
					});
					return;
				}
			}

			setEmailId += emailID+"|";
			setPassword += pass+"#~#";
		}

		setEmailId = setEmailId.substring(0,setEmailId.length-1);
		setPassword = setPassword.substring(0,setPassword.length-3);

		Ext.getCmp('Email_id').setValue(setEmailId);
		Ext.getCmp('Email_password').setValue(setPassword);
		Ext.getCmp('Email_password').backupValue = setPassword;
		Ext.getCmp('egemailconfiguration').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearEmailFields: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('emailmorecontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addEmailBtn').setText('Add');
		Ext.getCmp('NoEmailContainer').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateEmailBtn').disable();
		Ext.getCmp('clearEmailBtn').disable();
	},
	addMainEmailContact: function(btn) 
	{
		addEmailContactFields(btn);
	},
	configEMailCredential: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.EgEMailConfiguration').show();
		ismulti = 'false';

		var rname = '';
		inputsEmail = 2;
		
		Ext.suspendLayouts();

		var emailID = Ext.getCmp('Email_id').getValue();
		var password = Ext.getCmp('Email_password').getValue();

		var splitMailID = emailID.split("|");
		var splitPass = password.split("#~#");

		if (splitMailID != null || splitMailID != undefined)
		{
			for (var k =0;k<splitMailID.length-1;k++ )
			{
				addEmailContactFields();
			}
			for (rname=1;rname<splitMailID.length+1;rname++)
			{
				if (Ext.getCmp('emailid'+rname) == undefined)
				{
					continue;
				}
				var tmpMailId = splitMailID[rname-1];
				var tmpPassword = splitPass[rname-1];
				Ext.getCmp('emailid'+rname).setValue(tmpMailId);
				Ext.getCmp('pass'+rname).setValue(tmpPassword);
				Ext.getCmp('confpass'+rname).setValue(tmpPassword);
				Ext.getCmp('pass'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpass'+rname).backupValue = tmpPassword;
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// Exchange site email ends...

	overrideFilterLogicForUpdate: function(obj) 
	{
		var allOk = true;
		var fieldID = obj.id;
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;

		if (!Ext.isEmpty(textValue))
		{
			if (textValue.charAt(0) == ' ' || textValue.charAt(textValue.length - 1) == ' ')
			{
				textValue = textValue.trim();
			}
		}
		textId = textId.substring(textId.lastIndexOf("c")+1);

		//Ext.getCmp('flaccept_'+textId).setDisabled(true);
		//Ext.getCmp('flaccept_'+textId).show();

		var childIncArr = new Array();
		var mainContainer = Ext.getCmp('includePatternContainer'+textId);
		var conLength = mainContainer.items.length;
		var isFromDisable = false;
		var disableId = '';
		if (conLength > 0)
		{
			for (var cnt=0;cnt< conLength;cnt++ )
			{
				var tmpLevelObj = Ext.getCmp('rulename'+textId+'_outercont'+(cnt+1));
				if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					isFromDisable = true;
					disableId = tmpLevelObj.id;
					continue;
				}
				childIncArr.push((cnt+1).toString());
			}
		}

		if (isFromDisable)
		{
			var fieldLength = disableId.length;
			var levelNumber = disableId.charAt((fieldLength-1));

			if (!Ext.isEmpty(textValue) && textValue.indexOf(levelNumber) != -1)
			{
				allOk = false;
				return false;
			}
			else
			{
				allOk = filterLogicFromRemoveMsg(Ext.getCmp('filterlogic'+textId),disableId);
			}
		}

		if (!Ext.isEmpty(childIncArr))
		{
			if (Ext.isEmpty(textValue))
			{
				allOk = false;
				return false;
			}
			else if (!checkFilterLogicFormat(textValue))
			{
				allOk = false;
				return false;
			}

			var valuesArr = new Array();
			valuesArr  = textValue.split(' ');

			var tmpArr = new Array();
			for (var v=0;v<valuesArr.length ;v++ )
			{
				var tmpStr = valuesArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			valuesArr = new Array();
			valuesArr = tmpArr;
			delete tmpArr;

			if (childIncArr != null && childIncArr.length > 0)
			{
				var definedFilters = '';
				childIncArr.forEach(function(item,index){
					if (!Ext.isEmpty(item))
					{
						if (valuesArr.indexOf(item.toString()) == -1) 
						{
							definedFilters += item+',';
						}
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					allOk = false;
					return false;
				}
			}

			if (valuesArr != null && valuesArr.length > 0)
			{
				var definedFilters = '';
				valuesArr.forEach(function(item,index){
					if (childIncArr.indexOf(item.toString()) == -1) 
					{
						definedFilters += item+',';
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					allOk = false;
					return false;
				}
			}
		}

		if (allOk)
		{
			Ext.getCmp('errorState_'+textId).update('');
			Ext.getCmp('flaccept_'+textId).setDisabled(false);
		}
		return allOk;
	},
	overrideFilterLogic: function(obj) 
	{
		var allOk = true;
		var fieldID = obj.id;
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;

		if (!Ext.isEmpty(textValue))
		{
			if (textValue.charAt(0) == ' ' || textValue.charAt(textValue.length - 1) == ' ')
			{
				textValue = textValue.trim();
			}
		}
		textId = textId.substring(textId.lastIndexOf("c")+1);

		Ext.getCmp('flaccept_'+textId).setDisabled(true);
		Ext.getCmp('flaccept_'+textId).show();

		var childIncArr = new Array();
		var mainContainer = Ext.getCmp('includePatternContainer'+textId);
		var conLength = mainContainer.items.length;
		var isFromDisable = false;
		var disableId = '';
		if (conLength > 0)
		{
			for (var cnt=0;cnt< conLength;cnt++ )
			{
				var tmpLevelObj = Ext.getCmp('rulename'+textId+'_outercont'+(cnt+1));
				if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					isFromDisable = true;
					disableId = tmpLevelObj.id;
					continue;
				}
				childIncArr.push((cnt+1).toString());
			}
		}

		if (isFromDisable)
		{
			var fieldLength = disableId.length;
			var levelNumber = disableId.charAt((fieldLength-1));

			if (!Ext.isEmpty(textValue) && textValue.indexOf(levelNumber) != -1)
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+deleteFilterMsg+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}
			else
			{
				allOk = filterLogicFromRemoveMsg(Ext.getCmp('filterlogic'+textId),disableId);
			}
		}

		if (!Ext.isEmpty(childIncArr))
		{
			if (Ext.isEmpty(textValue))
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+_checkempty+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}
			else if (!checkFilterLogicFormat(textValue))
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+filterLogicPatternMsg+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}

			var valuesArr = new Array();
			valuesArr  = textValue.split(' ');

			var tmpArr = new Array();
			for (var v=0;v<valuesArr.length ;v++ )
			{
				var tmpStr = valuesArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			valuesArr = new Array();
			valuesArr = tmpArr;
			delete tmpArr;

			if (childIncArr != null && childIncArr.length > 0)
			{
				var definedFilters = '';
				childIncArr.forEach(function(item,index){
					if (!Ext.isEmpty(item))
					{
						if (valuesArr.indexOf(item.toString()) == -1) 
						{
							definedFilters += item+',';
						}
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					definedFilters = definedFilters.substring(0,definedFilters.length-1);
					var alertMsg = 'Filter condition '+definedFilters+' is defined but not referenced in your filter logic';
					if (!Ext.isEmpty(definedFilters) && definedFilters.indexOf(',') != -1)
					{
						alertMsg = 'Filter conditions '+definedFilters+' are defined but not referenced in your filter logic';
					}

					var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+alertMsg+'</td></tr></table>';

					Ext.getCmp('errorState_'+textId).update(htm1);
					allOk = false;
					return false;
				}
			}

			if (valuesArr != null && valuesArr.length > 0)
			{
				var definedFilters = '';
				valuesArr.forEach(function(item,index){
					if (childIncArr.indexOf(item.toString()) == -1) 
					{
						definedFilters += item+',';
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					var tmpStr = 'The filter logic references an undefined filter';
					var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+tmpStr+'</td></tr></table>';

					Ext.getCmp('errorState_'+textId).update(htm1);
					allOk = false;
					return false;
				}
			}
		}

		if (allOk)
		{
			Ext.getCmp('errorState_'+textId).update('');
			Ext.getCmp('flaccept_'+textId).setDisabled(false);
		}
		return true;
	},
	buildFilterLogic: function(obj) 
	{
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;
		if (Ext.isEmpty(textValue))
		{
			Ext.Msg.show({
				title: rulePageTitle,
				msg: _checkempty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp(obj.id).focus(true,true);
				}
			});
			return;
		}
	},
	addMainContact: function(btn) 
	{
		addRuleContact(btn);
	},
	clearFilterRules: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('rulenamescontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addRuleNamebtn').setText('Add');
		Ext.getCmp('NoRuleNamePattern').show();
		if (Ext.getCmp('configrule_1') != null || Ext.getCmp('configrule_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('configrule_1').removeAll();
			Ext.getCmp('configrule_1').hide();
		}
		Ext.getCmp('updateRuleName').disable();
		Ext.getCmp('clearRuleName').disable();
	},
	createRulesForSyslog: function(btn) 
	{  
		var testName = publicJson['testName'];

		Ext.create('SpecificTestConfiguration.view.EgConfigureRulenames').show();
		ismulti = 'false';

		var rname = '';
		inputsRule = 2;
		
		Ext.suspendLayouts();

		var ruleName = Ext.getCmp('rule_name').getValue();
		var facility = Ext.getCmp('facility').getValue();
		var filterHost = Ext.getCmp('filter_host').getValue();
		var level = Ext.getCmp('level').getValue();
		var filterLogic = Ext.getCmp('filter_logic').getValue();
		var excludePattern = Ext.getCmp('exclude_Patterns').getValue();

		var splitRuleName = ruleName.split("^#^");
		var splitFacility = facility.split("^#^");
		var splitFilterHost = filterHost.split("^#^");
		var splitLevel = level.split("^#^");
		var splitFilterLogic = filterLogic.split("^#^");
		if (!Ext.isEmpty(splitFilterLogic) && (splitFilterLogic == '$unconfigured' || splitFilterLogic == 'none'))
		{
			splitFilterLogic = '1';
		}

		var splitExcPattern = excludePattern.split("^#^");
		if (splitRuleName != null || splitRuleName != undefined)
		{
			for (var k =0;k<splitRuleName.length-1;k++ )
			{
				addRuleContact();
			}
			for (rname=1;rname<splitRuleName.length+1;rname++)
			{
				if (Ext.getCmp('rulename'+rname) == undefined)
				{
					continue;
				}

				if (testName == 'DeviceSyslogMsgs')
				{
					Ext.getCmp('filterhost'+rname).hide();
				}

				var tmpRuleName = splitRuleName[rname-1];
				var tmpFacility = splitFacility[rname-1];
				var tmpFilterHost = splitFilterHost[rname-1];
				var tmpLevel = splitLevel[rname-1];
				var tmpFltLogic = splitFilterLogic[rname-1];
				var tmpExcPattern = splitExcPattern[rname-1];
				
				var includePatterns = tmpRuleName.substring(tmpRuleName.indexOf("=")+1);
				tmpRuleName = tmpRuleName.substring(0,tmpRuleName.indexOf("="));
				var incPattArr = includePatterns.split("|");
				tmpFacility = tmpFacility.substring(tmpFacility.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFacility) && tmpFacility.indexOf("|") != -1)
				{
					tmpFacility = tmpFacility.replace(/\|/g,',');
				}

				tmpFilterHost = tmpFilterHost.substring(tmpFilterHost.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFilterHost) && tmpFilterHost.indexOf("|") != -1)
				{
					tmpFilterHost = tmpFilterHost.replace(/\|/g,',');
				}

				tmpLevel = tmpLevel.substring(tmpLevel.indexOf("=")+1);
				if (!Ext.isEmpty(tmpLevel) && tmpLevel.indexOf("|") != -1)
				{
					tmpLevel = tmpLevel.replace(/\|/g,',');
				}

				tmpFltLogic = tmpFltLogic.substring(tmpFltLogic.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFltLogic) && tmpFltLogic.indexOf("|") != -1)
				{
					tmpFltLogic = tmpFltLogic.replace(/\|/g,',');
				}

				tmpExcPattern = tmpExcPattern.substring(tmpExcPattern.indexOf("=")+1);
				if (!Ext.isEmpty(tmpExcPattern) && tmpExcPattern.indexOf("|") != -1)
				{
					tmpExcPattern = tmpExcPattern.replace(/\|/g,',');
				}

				Ext.getCmp('rulename'+rname).setValue(tmpRuleName);
				Ext.getCmp('facility'+rname).setValue(tmpFacility);
				Ext.getCmp('filterhost'+rname).setValue(tmpFilterHost);
				Ext.getCmp('level'+rname).setValue(tmpLevel);
				if (incPattArr != null && incPattArr.length > 0)
				{
					for (var ip =1;ip<incPattArr.length;ip++ )
					{
						addIncludePatternWithValue('multiPatternDiv'+rname);
					}

					for (var inc = 0;inc<incPattArr.length ;inc++ )
					{
						Ext.getCmp('rulename'+rname+'_incpatt'+(inc+1)).setValue(incPattArr[inc]);
					}
				}

				//Ext.getCmp('filterlogic'+rname).setValue(tmpFltLogic);
				Ext.getCmp('filterlogic'+rname).setRawValue(tmpFltLogic);
				Ext.getCmp('excludepattern'+rname).setValue(tmpExcPattern);
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},

	updateRuleFilters: function(btn) 
	{
		var setRuleName = "";
		var setFacility = "";
		var setFilterHost = "";
		var setLevel = "";
		var setFilterLogic  = "";
		var setExcPattern = "";
		var rdCnt = 0;
		var totalRules = inputsRule;
		var arrURLNames = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('rulename'+j) == undefined)
			{
				continue;
			}
			ruleName = Ext.getCmp('rulename'+j).getValue();
			facility = Ext.getCmp('facility'+j).getValue();
			filterHost = Ext.getCmp('filterhost'+j).getValue();
			level = Ext.getCmp('level'+j).getValue();
			filterLogic = Ext.getCmp('filterlogic'+j).getValue();
			excPattern = Ext.getCmp('excludepattern'+j).getValue();

			if(ruleName!=null)
			{
				rdCnt++;
				if(!checkblank(ruleName) || (ruleName == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterRuleName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}
				//else if(!checkspace(ruleName))
				//{
					//Ext.getCmp('rulename'+j).focus(true,true);
					//return;
				//}
				else if(!checkspecialExt(ruleName,"$@*.+=|:;\"\'<>\/[]?,\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}

				var x_idx = arrURLNames.indexOf(ruleName);
				if (x_idx != -1)
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: duplicateRuleName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}
				arrURLNames[j] = ruleName;
			}

			if(facility!=null)
			{
				if(!checkblank(facility) || (facility == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFacility,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('facility'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(facility))
				{
					Ext.getCmp('facility'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(facility,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('facility'+j).focus(true,true);
						}
					});
					return;
				}
				else if (facility.indexOf(",") > -1)
				{
					if (facility.indexOf(",") == 0 || 
						facility.lastIndexOf(",") == facility.length-1 || 
						facility.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('facility'+j).focus(true,true);
							}
						});
						return
					}
				}
			}

			if(filterHost!=null)
			{
				if(!checkblank(filterHost) || (filterHost == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFilterHost,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('filterhost'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(filterHost))
				{
					Ext.getCmp('filterhost'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(filterHost,"$@*+=|;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('filterhost'+j).focus(true,true);
						}
					});
					return;
				}
				else if (filterHost.indexOf(",") > -1)
				{
					if (filterHost.indexOf(",") == 0 || 
						filterHost.lastIndexOf(",") == filterHost.length-1 || 
						filterHost.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('filterhost'+j).focus(true,true);
							}
						});
						return;
					}
				}
			}

			if(level!=null)
			{
				if(!checkblank(level) || (level == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterLevel,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('level'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(level))
				{
					Ext.getCmp('level'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(level,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('level'+j).focus(true,true);
						}
					});
					return;
				}
				else if (level.indexOf(",") > -1)
				{
					if (level.indexOf(",") == 0 || 
						level.lastIndexOf(",") == level.length-1 || 
						level.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('level'+j).focus(true,true);
							}
						});
						return
					}
				}
			}

			var mainContainer = Ext.getCmp('includePatternContainer'+j);
			var conLength = mainContainer.items.length;
			var includeMsgArr = new Array();
			if (conLength > 0)
			{
				for (var cnt=0;cnt< conLength;cnt++ )
				{
					var incPattOther = Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).getValue();
					if(!checkblank(incPattOther) || (incPattOther == "$unconfigured" ))
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: enterIncPattern,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).focus(true,true);
							}
						});
						return;
					}
					else if(!checkspecialExt(incPattOther,"$,@*.+=|:;\"\'<>\/[]?\\&"))
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).focus(true,true);
							}
						});
						return;
					}
					else
					{
						func.buildFilterLogic(Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)));
					}
					includeMsgArr.push(incPattOther);
				}
			}

			if (filterLogic != null)
			{
				if(!checkblank(filterLogic) || (filterLogic == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFilterLogic,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('filterlogic'+j).focus(true,true);
						}
					});
					return;
				}
				else
				{
					var itsOkFirstCondition = func.overrideFilterLogicForUpdate(Ext.getCmp('filterlogic'+j));
					if (!itsOkFirstCondition)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: filterLogicPatternMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('filterlogic'+j).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var filterLogicArr = filterLogic.split(" ");
						var hasParenthesis = (filterLogic.indexOf("(") != -1);
						var availAndArray = new Array();
						var availOrArray = new Array();
						for (var f=0;f<filterLogicArr.length ;f++ )
						{
							var tmpFLogic = filterLogicArr[f];
							if (!Ext.isEmpty(tmpFLogic) && tmpFLogic.toLowerCase() == 'and')
							{
								availAndArray.push(tmpFLogic);
							}
							else if (!Ext.isEmpty(tmpFLogic) && tmpFLogic.toLowerCase() == 'or')
							{
								availOrArray.push(tmpFLogic);
							}
						}

						var newOperandsArr = Ext.Array.map(filterLogicArr,function(item,index) {

							if (index != (filterLogicArr.length -2))
							{
								if (!Ext.isEmpty(item) && ((item.toLowerCase() == 'and' && filterLogicArr[index+2].toLowerCase() == 'or') || (item.toLowerCase() == 'or' && filterLogicArr[index+2].toLowerCase() == 'and')))
								{
									var number = filterLogicArr[index+1];
									if (number.indexOf(')') == -1 && number.indexOf('(') == -1)
									{
										hasParenthesis = false;
									}
								}
							}
						});

						var hasBothOperators = ((!Ext.isEmpty(availAndArray) && availAndArray.length > 0) && (!Ext.isEmpty(availOrArray) && availOrArray.length > 0))
						if (!hasParenthesis && hasBothOperators)
						{
							Ext.Msg.show({
								title: rulePageTitle,
								msg: enterFilterLogicMsg1,
								minWidth : 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('filterlogic'+j).focus(true,true);
								}
							});
							return;
						}
					}
				}
			}

			if(excPattern!=null)
			{
				if (Ext.isEmpty(excPattern))
				{
					excPattern = "none";
				}

				if(!checkblank(excPattern) || (excPattern == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterExecPattern,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(excPattern))
				{
					Ext.getCmp('excludepattern'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(excPattern,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
				else if (excPattern.indexOf(",") > -1)
				{
					if (excPattern.indexOf(",") == 0 || 
						excPattern.lastIndexOf(",") == excPattern.length-1 || 
						excPattern.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('excludepattern'+j).focus(true,true);
							}
						});
						return;
					}
				}

				var isIncludeAndExcludeSame = false;
				includeMsgArr.forEach(function(item){
					if (excPattern.indexOf(',') != -1)
					{
						if (excPattern.indexOf(item+',') != -1 || excPattern.indexOf(','+item+',') != -1 || excPattern.indexOf(','+item) != -1 )
						{
							isIncludeAndExcludeSame = true;
						}
					}
					else
					{
						if (item == excPattern)
						{
							isIncludeAndExcludeSame = true;
						}
					}
				});

				if (isIncludeAndExcludeSame)
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: repeatedKeywords,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
			}

			var inputPattCont = Ext.getCmp('includePatternContainer'+j);
			var inputPattCount = inputPattCont.items.getCount();
			var otherIncPatterns = '';
			if (inputPattCount > 0)
			{
				for (var it=0;it<inputPattCount ;it++ )
				{
					otherIncPatterns += Ext.getCmp('rulename'+j+'_incpatt'+(it+1)).getValue() +"|";
				}
			}

			if (!Ext.isEmpty(otherIncPatterns))
			{
				otherIncPatterns = otherIncPatterns.substring(0,otherIncPatterns.length -1);
			}

			var combinePatterns = otherIncPatterns;
			if (combinePatterns.charAt(combinePatterns.length -1) == '|')
			{
				combinePatterns = combinePatterns.substring(0,combinePatterns.length -1);
			}

			facility = facility.replace(/,/g,'|');
			level = level.replace(/,/g,'|');
			filterHost = filterHost.replace(/,/g,'|');
			excPattern = excPattern.replace(/,/g,'|');

			setRuleName += ruleName+"="+combinePatterns+"^#^";
			setFacility += ruleName+"="+facility+"^#^";
			setFilterHost += ruleName+"="+filterHost +"^#^";
			setLevel += ruleName+"="+level +"^#^";
			setFilterLogic += ruleName+"="+filterLogic +"^#^";
			setExcPattern += ruleName+"="+excPattern +"^#^";
		}

		setRuleName = setRuleName.substring(0,setRuleName.length-3);
		setFacility = setFacility.substring(0,setFacility.length-3);
		setFilterHost = setFilterHost.substring(0,setFilterHost.length-3);
		setLevel = setLevel.substring(0,setLevel.length-3);
		setFilterLogic = setFilterLogic.substring(0,setFilterLogic.length-3);
		setExcPattern = setExcPattern.substring(0,setExcPattern.length-3);

		Ext.getCmp('rule_name').setValue(setRuleName);
		Ext.getCmp('facility').setValue(setFacility);
		Ext.getCmp('filter_host').setValue(setFilterHost);
		Ext.getCmp('level').setValue(setLevel);
		Ext.getCmp('filter_logic').setValue(setFilterLogic);
		Ext.getCmp('exclude_Patterns').setValue(setExcPattern);
		Ext.getCmp('egconfigurerulenames').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	}

});

// system properties works starts...

function addSystemProperties(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egsystemproperties');
	var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
	var conId = "con_"+inputsEmail

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			/*layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},*/
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Property',
							style:{'white-space':'nowrap'},
							id: 'syspropkey'+inputsEmail,
							name: 'syspropkey'+inputsEmail,
							value: 'none',
							margin: '2 5 2 2',
							columnWidth:.48
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Value',
							style:{'white-space':'nowrap'},
							id: 'syspropval'+inputsEmail,
							name: 'syspropval'+inputsEmail,
							value: 'none',
							margin: '2 5 2 5',
							columnWidth: 0.48
						},
						{
							xtype: 'component',
							html: '<center><div class="iconMinus" style="cursor:pointer;" data-qtip="<b>Remove</b>" onclick="javascript:removeProperties('+conId+')"></center>',
							columnWidth: 0.04,
							margin: '24 0 0 2'
						}
					]
				}
			]
	};
	propetiesmorecontainer.add(tmpContainer);
	propetiesmorecontainer.doLayout();
	Ext.getCmp('addPropBtn').setText('Add More');
	Ext.getCmp('updatePropBtn').enable();
	Ext.getCmp('clearPropBtn').enable();
	Ext.getCmp('NoPropContainer').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('syspropkey'+inputsEmail).focus(true);
	}
	inputsEmail++;
}

function removeProperties(containerSet) 
{
	var containerID = containerSet;
	if (!Ext.isEmpty(containerID) && containerID instanceof Object)
	{
		containerID = containerSet.id;
	}

	var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
	propetiesmorecontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = propetiesmorecontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addPropBtn').setText('Add');
			Ext.getCmp('NoPropContainer').show();
			Ext.getCmp('updatePropBtn').disable();
			Ext.getCmp('clearPropBtn').disable();
		}
	}
}
// system propeties works ends

function addEmailContactFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egemailconfiguration');
	var emailmorecontainer = Ext.getCmp('emailmorecontainer');
	var conId = "con_"+inputsEmail

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			/*layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},*/
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeEmailNameContact(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Email ID',
							style:{'white-space':'nowrap'},
							id: 'emailid'+inputsEmail,
							name: 'emailid'+inputsEmail,
							value: '$unconfigured',
							columnWidth:.34
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pass'+inputsEmail,
							name: 'pass'+inputsEmail,
							//value: '$unconfigured',
							columnWidth: 0.33,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpass'+inputsEmail,
							name: 'confpass'+inputsEmail,
							//value: '$unconfigured',
							columnWidth: 0.33,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						}
					]
				}
			]
	};
	emailmorecontainer.add(tmpContainer);
	emailmorecontainer.doLayout();
	Ext.getCmp('addEmailBtn').setText('Add More');
	Ext.getCmp('updateEmailBtn').enable();
	Ext.getCmp('clearEmailBtn').enable();
	Ext.getCmp('NoEmailContainer').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('emailid'+inputsEmail).focus(true);
	}
	inputsEmail++;
}

function removeEmailNameContact(containerID) 
{
	var emailmorecontainer = Ext.getCmp('emailmorecontainer');
	emailmorecontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = emailmorecontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addEmailBtn').setText('Add');
			Ext.getCmp('NoEmailContainer').show();
			Ext.getCmp('updateEmailBtn').disable();
			Ext.getCmp('clearEmailBtn').disable();
		}
	}
}

function addRuleContact(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var rulenamescontainer = Ext.getCmp('rulenamescontainer');
	var conId = "con_"+inputsRule

	var tmpContainer = {
		xtype: 'container',
		id : conId,
		padding: 4,
		margin: '5 5 5 5',
		border: true,
		style: 'border: lightGrey 3px solid !important',
		layout : {
			type : 'hbox',
			pack : 'start'
		},
		items : [
			{
				xtype: 'container',
				layout : {
					type : 'vbox',
					pack : 'start',
					align : 'stretch'
				},
				flex: 0.30,
				defaults: {
					labelSeparator: ' ',
					labelAlign: 'top',
					margin: 5
				},
				items: [
					{
						xtype: 'container',
						layout: {
							type: 'hbox',
							pack: 'start'
						},
						margin: '0 0 2 0',
						items : [
							{
								xtype : 'button',
								iconCls : 'img_removeShift',
								tooltip : '<b>Remove rule</b>',
								style : {
									background : 'none',
									border : '0px'
								},
								margin: 0,
								padding: 0,
								handler: function()
								{
									removeRuleNameContact(conId);
								}
							}
						]
					},
					{
						xtype: 'textfield',
						id: 'rulename'+inputsRule,
						cls: 'textbox',
						fieldLabel: ruleNameLbl,
						value: ''
					},
					{
						xtype: 'textfield',
						id: 'facility'+inputsRule,
						cls: 'textbox',
						fieldLabel: faceLbl,
						value: 'all'
					},
					{
						xtype: 'textfield',
						id: 'filterhost'+inputsRule,
						cls: 'textbox',
						fieldLabel: filterHostLbl,
						value: 'all'
					},
					{
						xtype: 'textfield',
						id: 'level'+inputsRule,
						cls: 'textbox',
						fieldLabel: levelLbl,
						value: 'all'
					}
				]
			},
			{
				xtype: 'container',
				layout : {
					type : 'vbox',
					pack : 'start',
					align : 'stretch'
				},
				flex: 1,
				margin: '0 0 0 5',
				items: [
					{
						xtype: 'fieldset',
						title: incPattLbl,
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						margin: '0 0 5 0',
						items: [
							{
								xtype: 'container',
								id : 'includePatternContainer'+inputsRule,
								layout: 'column',
								columnWidth: 1,
								defaults: {
									labelSeparator: '',
									margin: '0 5 5 5',
									columnWidth: 0.25
								},
								items: [
									{
										xtype : 'container',
										id: 'multiPatternDiv'+inputsRule,
										layout: 'column',
										items : [
											{
												xtype: 'textfield',
												id : 'rulename'+inputsRule+'_incpatt1',
												name : 'rulename'+inputsRule+'_incpatt1',
												fieldLabel: ' 1',
												labelAlign: 'top',
												labelSeparator: ' ',
												cls:"textbox",
												value: '$unconfigured',
												columnWidth: 0.90,
												listeners: {
													blur: function()
													{
														func.buildFilterLogic(this);
													}
												}
											},
											{
												xtype: 'component',
												id:'rulename'+inputsRule+'_icon1',
												html: '<center><div class="iconPlus" style="cursor:pointer;"  onclick="javascript:addIncludePattern(multiPatternDiv'+inputsRule+')"></center>',
												columnWidth: 0.03,
												margin: '24 0 0 2'
											}
										]
									}
								]
							},
							{
									xtype: 'fieldcontainer',
									id: 'flfieldcontainer'+inputsRule,
									layout: 'column',
									columnWidth: 1,
									margin: '10 0 0 0',
									items: [
										{
											xtype: 'textfield',
											id: 'filterlogic'+inputsRule,
											cls: 'textbox',
											margin: '5 0 5 5',
											fieldLabel: filterLogLbl,
											labelAlign: 'top',
											columnWidth: 0.90,
											labelSeparator: ' ',
											enableKeyEvents:true,
											value: '1',
											listeners: {
												change: function()
												{
													func.overrideFilterLogic(this);
												}
											}
										},
										{
											xtype: 'button',
											cls: 'button20',
											id: 'flaccept_'+inputsRule,
											name: 'flaccept_'+inputsRule,
											hidden:true,
											text: 'OK',
											margin:'26 0 0 10',
											columnWidth: 0.10,
											handler: function()
											{
												allOKEvent(this);
											}
										}
									]
								},
								{
									xtype: 'component',
									id:'errorState_'+inputsRule,
									anchor:'100%',
									margin:'0px 0px 0px 5px',
									bodyPadding:'0px'
								}
						]
					},
					{
						xtype: 'fieldset',
						title: execPattLbl,
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						margin: 0,
						items: [
							{
								xtype: 'textfield',
								id: 'excludepattern'+inputsRule,
								name: 'excludepattern'+inputsRule,
								cls: 'textbox',
								value: 'none'
							}
						]
					}
				]
			}
		]
	};
	rulenamescontainer.add(tmpContainer);
	mainForm.doLayout();
	Ext.getCmp('addRuleNamebtn').setText('Add More');
	Ext.getCmp('updateRuleName').enable();
	Ext.getCmp('clearRuleName').enable();
	Ext.getCmp('NoRuleNamePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('rulename'+inputsRule).focus(true);
	}

	if (testName == 'DeviceSyslogMsgs')
	{
		Ext.getCmp('filterhost'+inputsRule).hide();
	}

	inputs++;
	inputsRule++;

}

function removeRuleNameContact(containerID) 
{
	var rulenamescontainer = Ext.getCmp('rulenamescontainer');
	rulenamescontainer.remove(containerID);
	if (containerID == 'configrule_1')
	{
		ismulti = 'true';
		Ext.getCmp('configrule_1').removeAll();
		Ext.getCmp('configrule_1').hide();
	}

	var bckitemsmultiLen = rulenamescontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addRuleNamebtn').setText('Add');
			Ext.getCmp('NoRuleNamePattern').show();
			Ext.getCmp('updateRuleName').disable();
			Ext.getCmp('clearRuleName').disable();
		}
	}
}

function checkFilterLogicFormat(value)
{
	var numbers = "andorANDOR0123456789 ";
	var logicAlpha = "andorANDOR";
	var logicNumbers = "0123456789";
	var logicOtherChars = " ()";
	var hasNonNumericalCharacter = "false";
	var hasLogicAlphas = false;
	var hasLogicNums = false;
	for (var i=0;i<value.length;i++)
	{
		var strChar = value.charAt(i);
		if (logicOtherChars.indexOf(strChar) != -1)
		{
			continue;
		}
		if (numbers.indexOf(strChar) == -1)
		{
			hasNonNumericalCharacter = "true";
			break;
		}

		if (logicAlpha.indexOf(strChar) != -1)
		{
			hasLogicAlphas = true;
		}

		if (logicNumbers.indexOf(strChar) != -1)
		{
			hasLogicNums = true;
		}
	}

	var valuesArr = new Array();
	valuesArr  = value.split(' ');

	if (valuesArr != null && valuesArr.length >0)
	{
		valuesArr.forEach(function(item){
			if (item.indexOf('(') != -1)
			{
				item = item.replace(/\(/g,"");
			}
			if (item.indexOf(')') != -1)
			{
				item = item.replace(/\)/g,"");
			}
			if (logicNumbers.indexOf(item) == -1 && item.toLowerCase() != 'and' && item.toLowerCase() !='or')
			{
				hasNonNumericalCharacter = "true";
			}
		});
	}
	var map = new Ext.util.HashMap();
	var open = 0;
	var close = 0;
	for (var v=0;v<valuesArr.length; v++ )
	{
		var item = valuesArr[v];
		var closeItem = item;

		if (valuesArr[0].toLowerCase() == 'and' || valuesArr[0].toLowerCase() == 'or' || valuesArr[valuesArr.length - 1].toLowerCase() == 'and' || valuesArr[valuesArr.length - 1].toLowerCase() == 'or')
		{
			hasNonNumericalCharacter = "true";
			break;
		}

		if (v != (valuesArr.length -1))
		{
			var checkSequence = item;
			var checkNextSequence = valuesArr[v+1];
			if (checkSequence.indexOf('(') != -1)
			{
				checkSequence = checkSequence.replace(/\(/g,"");
			}
			if (checkSequence.indexOf(')') != -1)
			{
				checkSequence = checkSequence.replace(/\)/g,"");
			}

			if (checkNextSequence.indexOf('(') != -1)
			{
				checkNextSequence = checkNextSequence.replace(/\(/g,"");
			}

			if (checkNextSequence.indexOf(')') != -1)
			{
				checkNextSequence = checkNextSequence.replace(/\)/g,"");
			}

			if (logicNumbers.indexOf(checkSequence) != -1 && logicNumbers.indexOf(checkNextSequence) != -1)
			{
				hasNonNumericalCharacter = "true";
				break;
			}
			else if (logicAlpha.indexOf(checkSequence) != -1 && logicAlpha.indexOf(checkNextSequence) != -1)
			{
				hasNonNumericalCharacter = "true";
				break;
			}
		}

		for(var k=0;k < item.length;k++)
		{
			if(item.charAt(k) == '(' && item.charAt(k + 1) == ')')
			{
				hasNonNumericalCharacter = "true";
				break;
			}
			else if((item.charAt(k) == '(' &&  logicAlpha.indexOf(item.charAt(k+1)) != -1) ||					(item.charAt(k) == ')' && logicAlpha.indexOf(item.charAt(k-1)) != -1))
			{
				hasNonNumericalCharacter = "true";
				break;
			}
		}

		if (hasNonNumericalCharacter == 'true')
		{
			map = new Ext.util.HashMap();
			break;
		}

		while(item.indexOf('(') != -1)
		{
			if (item.indexOf('(') != -1)
			{
				map.add('(',++open);
				item = item.substring(item.indexOf('(')+1);
			}
		}

		while(closeItem.indexOf(')') != -1)
		{
			if (closeItem.indexOf(')') != -1)
			{
				map.add(')',++close);
				closeItem = closeItem.substring(closeItem.indexOf(')')+1);
			}
		}
	}

	if (hasNonNumericalCharacter != "true")
	{
		var hasParanthesis = false;
		if (value.indexOf("(") != -1 && value.indexOf(")") != -1)
		{
			hasParanthesis = true;
		}

		if (!Ext.isEmpty(map))
		{
			var openCnt = map.get('(');
			var closeCnt = map.get(')');
			if (openCnt != closeCnt)
			{
				hasNonNumericalCharacter = 'true';
			}
		}

		if ((value.indexOf("(") != -1 && value.indexOf(")") == -1) || (value.indexOf(")") != -1 && value.indexOf("(") == -1))
		{
			hasNonNumericalCharacter = "true";
		}

		if (hasLogicAlphas && !hasLogicNums)
		{
			hasNonNumericalCharacter = "true";
		}
		else if (hasLogicAlphas && hasLogicNums)
		{
			var firstChar = value.charAt(0);
			var lastChar = value.charAt(value.length -1);
			if (!hasParanthesis)
			{
				if (logicNumbers.indexOf(firstChar) == -1 || logicNumbers.indexOf(lastChar) == -1)
				{
					hasNonNumericalCharacter = "true";
				}
			}

			for(var a=0;a < value.length;a++)
			{
				var eachChar = value.charAt(a);
				if (logicNumbers.indexOf(eachChar) != -1)
				{
					if (!hasParanthesis)
					{
						if (a == value.length-1)
						{
							if (value.charAt(a-1) != ' ')
							{
								hasNonNumericalCharacter = "true";
								break;
							}
							continue;
						}

						if (value.charAt(a+1) != ' ')
						{
							hasNonNumericalCharacter = "true";
							break;
						}
					}
					else
					{
						if ((firstChar == '(' && (a == 0)) && (lastChar == ')' && (a == value.length-2)))
						{
							continue;
						}

						if (lastChar != ')')
						{
							if (a == value.length-1)
							{
								continue;
							}
						}
						if (value.charAt(a+1) != ' ' && value.charAt(a+1) != '(' && 
						value.charAt(a+1) != ')')
						{
							hasNonNumericalCharacter = "true";
							break;
						}
					}
				}
			}
		}
	}

	if (hasNonNumericalCharacter == "true")
	{
		return false;
	}
	else
	{
		return true;
	}
}

function checkspecialExt(field,s_spl)
{
	if (typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function allOKEvent(obj)
{
	var selectedRuleID = obj.id;
	if (!Ext.isEmpty(obj))
	{
		selectedRuleID = selectedRuleID.substring(selectedRuleID.indexOf("_")+1);
	}
	
	var isHTMLData = Ext.getCmp('errorState_'+selectedRuleID).html;
	if (Ext.isEmpty(isHTMLData))
	{
		//set value after click OK button ...

		var mainContainer = Ext.getCmp('includePatternContainer'+selectedRuleID);
		var conLength = mainContainer.items.length;
		var hasApplyDisabledCls = false;
		var disableElementId = '';
		if (conLength > 0)
		{
			inputsIncPatt = 0;
			var existValues = new Array();
			for (var i = 0;i<=conLength;i++)
			{
				var tmpLevelObj = Ext.getCmp('rulename'+selectedRuleID+'_outercont'+(i+1));
				if (tmpLevelObj == null || tmpLevelObj == undefined)
				{
					continue;
				}
				else if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					hasApplyDisabledCls = true;
					disableElementId = tmpLevelObj.id;
					mainContainer.remove(tmpLevelObj);
					continue;
				}

				var tmpID = tmpLevelObj.getId();
				var value = Ext.getCmp('rulename'+selectedRuleID+'_incpatt'+(i+1)).getValue();
				existValues[inputsIncPatt] = value;
				inputsIncPatt++;
				mainContainer.remove(tmpLevelObj);
			}

			if (existValues != null && existValues.length > 0)
			{
				for (var e=0;e<existValues.length;e++)
				{
					var existVal =existValues[e];
					addIncludePatternWithValue('multiPatternDiv'+selectedRuleID,existVal);
				}
			}
		}


		var filterLogicValue = Ext.getCmp('filterlogic'+selectedRuleID).getValue();
		if (hasApplyDisabledCls)
		{
			var disableIDLength = disableElementId.length;
			var levelNumber = disableElementId.charAt((disableIDLength-1));
			var changedFLValue = filterLogicValue;
			var filterLogicValueArr = new Array();
			filterLogicValueArr = filterLogicValue.split(" ");

			var tmpArr = new Array();
			for (var v=0;v<filterLogicValueArr.length ;v++ )
			{
				var tmpStr = filterLogicValueArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			filterLogicValueArr = new Array();
			filterLogicValueArr = tmpArr;
			delete tmpArr;

			var map = new Ext.util.HashMap();
			var intLevel = parseInt(levelNumber);

			if (filterLogicValueArr != null)
			{
				for (var fl=intLevel;fl<=filterLogicValueArr.length ;fl++ )
				{
					map.add(fl+1,fl);
				}
			}

			if (!Ext.isEmpty(map))
			{
				var mapKeyArr = map.getKeys();
				for (var m=0;m<mapKeyArr.length;m++ )
				{
					var mapKey = mapKeyArr[m];
					var mapKey1 = map.get(m);
					if (!Ext.isEmpty(changedFLValue) && changedFLValue.indexOf(mapKey) != -1)
					{
						var mapValue = map.get(mapKey).toString();
						changedFLValue = changedFLValue.replace(new RegExp(mapKey, 'g'), mapValue);
					}
				}

				if (!Ext.isEmpty(changedFLValue))
				{
					if (changedFLValue.charAt(0) == ' ' || changedFLValue.charAt(changedFLValue.length - 1) == ' ')
					{
						changedFLValue = changedFLValue.trim();
					}
				}
				Ext.getCmp('filterlogic'+selectedRuleID).setRawValue(changedFLValue);
			}
		}
		else
		{
			if (!Ext.isEmpty(filterLogicValue))
			{
				if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
				{
					filterLogicValue = filterLogicValue.trim();
				}
			}
			Ext.getCmp('filterlogic'+selectedRuleID).setRawValue(filterLogicValue);
		}

		if (!Ext.isEmpty(Ext.get('rulename'+selectedRuleID+'_icon1')))
		{
			Ext.get('rulename'+selectedRuleID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;" onclick="javascript:addIncludePattern(multiPatternDiv'+selectedRuleID+')"></center>';

			var incPattContainer = Ext.getCmp('includePatternContainer'+selectedRuleID);
			var includePattLength = incPattContainer.items.length;
			if (includePattLength > 1)
			{
				for (var i = 1;i<includePattLength;i++)
				{
					var tmpLevelObj = Ext.getCmp('rulename'+selectedRuleID+'_icon'+(i+1));
					if ((tmpLevelObj == null || tmpLevelObj == undefined) || (!Ext.isEmpty(selectedRuleID) && selectedRuleID == (i+1)))
					{
						continue;
					}
					Ext.get('rulename'+selectedRuleID+'_icon'+(i+1)).dom.innerHTML='<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern(rulename'+selectedRuleID+"_outercont"+(i+1)+')"></center>';
				}
			}
		}
		Ext.getCmp('flaccept_'+selectedRuleID).setDisabled(true);
		Ext.getCmp('flaccept_'+selectedRuleID).hide();
		//set value after click OK button ...
	}
}

function addIncludePattern(fieldValue)
{
	var fieldID = Ext.get(fieldValue).id;
	if (Ext.isEmpty(fieldID))
	{
		fieldID = fieldValue;
	}
	fieldID = fieldID.substring(fieldID.indexOf('Div')+3);

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var escMailIDsDiv = Ext.getCmp('includePatternContainer'+fieldID);
	if ((escMailIDsDiv.items.getCount()) == totalIncPatt)
	{
		Ext.Msg.show({
			title: rulePageTitle,
			msg: limitedIncludePatterns,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var isFilterLogicOk = true;
	var filterLogicValue = Ext.getCmp('filterlogic'+fieldID).getValue();
	isFilterLogicOk = func.overrideFilterLogic(Ext.getCmp('filterlogic'+fieldID));
	if (isFilterLogicOk)
	{
		var levelStr = (escMailIDsDiv.items.getCount() + 1);
		var conId = 'rulename'+fieldID+"_outercont"+(escMailIDsDiv.items.getCount() + 1);
		var tmpContainer = {
			xtype : 'container',
			id : conId,
			layout: 'column',
			items : [
				{
					xtype:'textfield',
					id: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
					name: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
					cls: 'textbox',
					fieldLabel : ' '+levelStr,
					value : '$unconfigured',
					labelAlign: 'top',
					labelSeparator: ' ',
					columnWidth: 0.90,
					listeners: {
						blur: function()
						{
							//func.buildFilterLogic(this);
						}
					}
				},
				{
					xtype: 'component',
					id: 'rulename'+fieldID+'_icon'+(escMailIDsDiv.items.getCount() + 1),
					html: '<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern('+conId+')"></center>',
					columnWidth: 0.03,
					margin: '24 0 0 2'
				}
			]
		}
		escMailIDsDiv.add(tmpContainer);
		mainForm.doLayout();

		var isFilterLogicContHide = Ext.getCmp('filterlogic'+fieldID).isHidden();
		if (!isFilterLogicContHide)
		{
			var existFilterLogicValues = Ext.getCmp('filterlogic'+fieldID).getValue();
			Ext.getCmp('filterlogic'+fieldID).setRawValue(existFilterLogicValues+" and "+levelStr);
		}
		Ext.getCmp('flaccept_'+fieldID).setDisabled(true);
		Ext.getCmp('flaccept_'+fieldID).hide();
	}

}

function removeIncludePattern(containerID)
{
	var fieldID = containerID.id;
	var mainContID = fieldID;
	mainContID = mainContID.substring(0,mainContID.indexOf("_"));
	mainContID = mainContID.substring(mainContID.lastIndexOf("e")+1);

	var fieldLength = fieldID.length;
	var levelNumber = fieldID.charAt((fieldLength-1));

	var isFilterLogicContHide = Ext.getCmp('filterlogic'+mainContID).isHidden();
	if (!isFilterLogicContHide)
	{
		var mainContainer = Ext.getCmp('includePatternContainer'+mainContID);
		var auxiliaryInputMsgDiv = Ext.getCmp(fieldID);
		Ext.getCmp('rulename'+mainContID+'_incpatt'+levelNumber).setReadOnly(true);
		auxiliaryInputMsgDiv.addCls('disabled-mycomponent');
		var filterLogicValue = Ext.getCmp('filterlogic'+mainContID).getValue();

		if (!Ext.isEmpty(filterLogicValue))
		{
			if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
			{
				filterLogicValue = filterLogicValue.trim();
			}
		}

		Ext.getCmp('flaccept_'+mainContID).setDisabled(true);
		Ext.getCmp('flaccept_'+mainContID).show();

		if (!Ext.isEmpty(Ext.get('rulename'+mainContID+'_icon1')))
		{
			Ext.get('rulename'+mainContID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;"></div></center>';

			var incPattContainer = Ext.getCmp('includePatternContainer'+mainContID);
			var includePattLength = incPattContainer.items.length;
			if (includePattLength > 1)
			{
				for (var i = 1;i<includePattLength;i++)
				{
					var tmpLevelObj = Ext.getCmp('rulename'+mainContID+'_icon'+(i+1));
					if ((tmpLevelObj == null || tmpLevelObj == undefined))
					{
						continue;
					}
					else if (!Ext.isEmpty(levelNumber) && levelNumber == (i+1))
					{
						continue;
					}
					Ext.get('rulename'+mainContID+'_icon'+(i+1)).dom.innerHTML='<center><div class="iconMinus" style="cursor:pointer;"></div></center>';
				}
			}
		}

		if (!Ext.isEmpty(filterLogicValue))
		{
			if (filterLogicValue.indexOf(levelNumber) != -1)
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+deleteFilterMsg+'</td></tr></table>';
				Ext.getCmp('errorState_'+mainContID).update(htm1);
			}

			Ext.getCmp('filterlogic'+mainContID).reset();
			Ext.getCmp('filterlogic'+mainContID).setValue(filterLogicValue);
		}
		Ext.getCmp('filterlogic'+mainContID).focus();
	}
	else
	{
		var mainContainer = Ext.getCmp('includePatternContainer'+mainContID);
		var conLength = mainContainer.items.length;

		if (!Ext.isEmpty(Ext.get('rulename'+mainContID+'_icon1')))
		{
			Ext.get('rulename'+mainContID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;" onclick="javascript:addIncludePattern(MultiPatternDiv'+mainContID+')"></center>';
		}

		if (conLength > 0)
		{
			inputsIncPatt = 0;
			var existValues = new Array();
			for (var i = 0;i<=conLength;i++)
			{
				var tmpLevelObj = Ext.getCmp('rulename'+mainContID+'_outercont'+(i+1));
				if (tmpLevelObj == null || tmpLevelObj == undefined)
				{
					continue;
				}
				else if (!Ext.isEmpty(levelNumber) && levelNumber == (i+1))
				{
					mainContainer.remove(tmpLevelObj);
					continue;
				}

				var tmpID = tmpLevelObj.getId();
				var value = Ext.getCmp('rulename'+mainContID+'_incpatt'+(i+1)).getValue();
				existValues[inputsIncPatt] = value;
				inputsIncPatt++;
				mainContainer.remove(tmpLevelObj);
			}

			if (existValues != null && existValues.length > 0)
			{
				for (var e=0;e<existValues.length;e++)
				{
					var existVal =existValues[e];
					addIncludePatternWithValue('MultiPatternDiv'+mainContID,existVal);
				}
			}
		}

	// set value after click OK button ...
	}
}

function filterLogicFromRemoveMsg(obj,removeId) 
{
	var fieldID = obj.id;
	var removeContent = removeId;

	var fieldLength = removeContent.length;
	var levelNumber = removeContent.charAt((fieldLength-1));

	var blockNumber = fieldID;
	blockNumber = blockNumber.substring(blockNumber.lastIndexOf("c")+1);
	var filterLogicValue = obj.value;

	if (!Ext.isEmpty(filterLogicValue))
	{
		if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
		{
			filterLogicValue = filterLogicValue.trim();
		}
	}

	if (Ext.isEmpty(filterLogicValue))
	{
		var errMsg = "You must enter a value";
		var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+errMsg+'</td></tr></table>';
		Ext.getCmp('errorState_'+blockNumber).update(htm1);
		return false;
	}
	else if (!checkFilterLogicFormat(filterLogicValue))
	{
		var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+filterLogicPatternMsg+'</td></tr></table>';

		Ext.getCmp('errorState_'+blockNumber).update(htm1);
		return false;
	}
	return true;
}

function addIncludePatternWithValue(fieldObj,fieldValue)
{
	var fieldID = fieldObj;
	fieldID = fieldID.substring(fieldID.indexOf('Div')+3);

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var escMailIDsDiv = Ext.getCmp('includePatternContainer'+fieldID);
	if (!Ext.isEmpty(escMailIDsDiv.items))
	{
		if ((escMailIDsDiv.items.getCount()) == totalIncPatt)
		{
			Ext.Msg.show({
				title: rulePageTitle,
				msg: limitedIncludePatterns,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	}

	var levelStr = (escMailIDsDiv.items.getCount() + 1);
	var conId = 'rulename'+fieldID+"_outercont"+(escMailIDsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
				name: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
				cls: 'textbox',
				fieldLabel : ' '+levelStr,
				value : fieldValue,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.90,
				listeners: {
					blur: function()
					{
						func.buildFilterLogic(this);
					}
				}
			},
			{
				xtype: 'component',
				id: 'rulename'+fieldID+'_icon'+(escMailIDsDiv.items.getCount() + 1),
				html: '<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern('+conId+')"></center>',
				columnWidth: 0.03,
				margin: '24 0 0 2'
			}
		]
	};
	escMailIDsDiv.add(tmpContainer);
	mainForm.doLayout();
}

// for Horizon Logon simulator
function addMultiHLSContact() 
{
	var mainForm = Ext.getCmp('eghlspublishedresources');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmultisrc
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeMultiHLSSet(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Published resources',
						style:{'white-space':'nowrap'},
						id:'publisresource'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 1
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Domain,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: User,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						id: 'twofaCont'+inputsmultisrc,
						fieldLabel: 'Is 2FA enabled?',
						columnWidth: 0.5,
						layout: 'column',
						items : [
							{
								xtype: 'radiogroup',
								columnWidth: 0.6,
								cls: 'radiobt',
								id: 'twofact'+inputsmultisrc,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_1',  inputValue: 'true'},
									{ boxLabel: 'No', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
								],
								listeners : {
									'change' : function(obj, value)
									{
										var value = this.getChecked()[0];
										var twofa = this.getId().replace("twofact","twofacttoken");
										if (value.getGroupValue() == 'false')
										{
											Ext.getCmp(twofa).setVisible(false);
										}
										else
										{
											Ext.getCmp(twofa).setVisible(true);
										}
									}
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'twofacttoken'+inputsmultisrc,
								inputType: 'password',
								emptyText: '2FA code',
								columnWidth: 0.4,
								margin: '0 0 0 5',
								hidden: true,
								backupValue: '',
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function() {
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							}
						]
					},
					{
						xtype: 'radiogroup',
						columnWidth: 0.5,
						cls: 'radiobt',
						id: 'disclaimer_radioGrp'+inputsmultisrc,
						fieldLabel: 'Is disclaimer enabled?',
						vertical: false,
						columns: 2,
						items: [
							{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_1',  inputValue: 'true'},
							{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
						]
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	Ext.getCmp('publisresource'+inputsmultisrc).focus(true);

	Ext.getCmp('addMultiHLSbtn').setText('Add More');
	Ext.getCmp('updateMultiHLSbtn').enable();
	Ext.getCmp('clearMultiHLSbtn').enable();
	Ext.getCmp('NoMultiUsrPattern').hide();

	inputsmultisrc++;
}

function removeMultiHLSSet(containerID) 
{
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismultisrc = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addMultiHLSbtn').setText('Add');
		if (ismultisrc == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('clearMultiHLSbtn').disable();
			Ext.getCmp('updateMultiHLSbtn').disable();
		}
	}
}

//site url config starts  // i should know about - inputsService
function addURLsConf(data) {
	var mainSiteUrlForm = Ext.getCmp('siteurlconfiguration');
	var siteurlcontainer = Ext.getCmp('siteurlcontainer');
	var conSiteurlId = "siteurl_conf"+inputsService
	var dftValue = '$unconfigured';

	if (!Ext.isEmpty(data) && data != undefined && data != 'isTextFocus')
	{
		dftValue = data;
	}
	var tempSiteurlcontainer = {
		xtype : 'fieldset',
		id : conSiteurlId,
		width: 800,
		layout : {
			type : 'vbox',
			pack : 'start',
			align : 'stretch'
		},
		padding: '5 0 5 10',
		margin: '0 10 5 10',
		items: [
			//{
				//xtype: 'container',
				//layout: {
					//type: 'hbox',
					//pack: 'end'
				//},
				//margin:'0 10 0 0',
				//items : [
					//{
						//xtype : 'button',
						//iconCls : 'img_removeShift',
						//tooltip : '<b>Remove</b>',
						//style : {
							//background : 'none',
							//border : '0px'
						//},
						//handler: function()
						//{
							//removeSiteurlContact(conSiteurlId);
						//}
					//}
				//]
			//},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					//margin: 5,
					labelSeparator:' ',
					labelWidth: 40
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Name',
						id: 'siteUsageUnam'+inputsService,
						name: 'siteUsageUnam'+inputsService,
						value: '$unconfigured',
						columnWidth: .26,
						margin: '5 0 5 0'
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'URL',
						id: 'siteUsage'+inputsService,
						name: 'siteUsage'+inputsService,
						//value: '$unconfigured',
						value: dftValue,
						columnWidth: .70,
						margin: '5 0 5 20'
					},
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						columnWidth: .04,
						margin: '5 0 0 5',
						handler: function()
						{
							removeSiteurlContact(conSiteurlId);
						}
					}
				]
			}
		]
	}
	siteurlcontainer.add(tempSiteurlcontainer);
	if (data == 'isTextFocus')
	{
		Ext.getCmp('siteUsageUnam'+inputsService).focus();
		Ext.getCmp('siteUsage'+inputsService).focus();
	}
	mainSiteUrlForm.doLayout();
	inputsService++;
	Ext.getCmp('addURLsConfbtn').setText('Add More');
	//Ext.getCmp('siteUrlSearchTrigger').enable();
	Ext.getCmp('updateSitURLs').enable();
	Ext.getCmp('clearSitURLs').enable();
	Ext.getCmp('NoSiteurlConf').hide();
}

function removeSiteurlContact(SiturlcontainerID) {
	
	var siteurlcontainer = Ext.getCmp('siteurlcontainer');
	siteurlcontainer.remove(SiturlcontainerID);
	if (SiturlcontainerID == 'siteurl_conf1')
	{
		noServiceConfig = 'true';
		Ext.getCmp('siteurl_conf1').removeAll();
		Ext.getCmp('siteurl_conf1').hide();
	}

	var bckitemsServLen = siteurlcontainer.items.length;

	if (bckitemsServLen == 0)
	{
		Ext.getCmp('addURLsConfbtn').setText('Add');
		if (noServiceConfig == 'true')
		{
			Ext.getCmp('NoSiteurlConf').show();
			Ext.getCmp('updateSitURLs').disable();
			Ext.getCmp('clearSitURLs').disable();
		}	
	}
}

//site url config ends

//Horizon workspace logon simulator starts...
function addResourceSetFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conId = "con_"+inputsResourceSet

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeResourceSet(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
					{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Published resources',
							style:{'white-space':'nowrap'},
							id:'publisresource'+inputsResourceSet,
							name:'publisresource'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'username'+inputsResourceSet,
							name:'username'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pwd'+inputsResourceSet,
							name: 'pwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpwd'+inputsResourceSet,
							name: 'confpwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							id: 'twofaCont'+inputsResourceSet,
							fieldLabel: 'Is 2FA enabled?',
							columnWidth: 0.5,
							layout: 'column',
							items : [
								{
									xtype: 'radiogroup',
									columnWidth: 0.6,
									cls: 'radiobt',
									id: 'twofact'+inputsResourceSet,
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: 'twofactlabel'+inputsResourceSet, id: 'twofactlabel'+inputsResourceSet+'_1',  inputValue: 'true'},
										{ boxLabel: 'No', name: 'twofactlabel'+inputsResourceSet, id: 'twofactlabel'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
									],
									listeners : {
										'change' : function(obj, value)
										{
											var value = this.getChecked()[0];
											var twofa = this.getId().replace("twofact","twofacttoken");
											if (value.getGroupValue() == 'false')
											{
												Ext.getCmp(twofa).setVisible(false);
											}
											else
											{
												Ext.getCmp(twofa).setVisible(true);
											}
										}
									}
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									style:{'white-space':'nowrap'},
									id:'twofacttoken'+inputsResourceSet,
									inputType: 'password',
									emptyText: '2FA code',
									columnWidth: 0.4,
									margin: '0 0 0 5',
									hidden: true,
									backupValue: '',
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								}
							]
						},
						{
							xtype: 'radiogroup',
							columnWidth: 0.5,
							cls: 'radiobt',
							id: 'disclaimer_radioGrp'+inputsResourceSet,
							fieldLabel: 'Is disclaimer enabled?',
							vertical: false,
							columns: 2,
							items: [
								{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsResourceSet, id: 'disclaimermultiusr'+inputsResourceSet+'_1',  inputValue: 'true'},
								{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsResourceSet, id: 'disclaimermultiusr'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
							]
						}
						//,{
							//xtype: 'radiogroup',
							//columnWidth: 0.5,
							//cls: 'radiobt',
							//id: 'sso_radioGrp'+inputsResourceSet,
							//fieldLabel: 'Single Sign On',
							//vertical: false,
							//columns: 2,
							//items: [
								//{ boxLabel: 'Yes', name: 'sso'+inputsResourceSet, id: 'sso'+inputsResourceSet+'_1',  inputValue: 'true'},
								//{ boxLabel: 'No', name: 'sso'+inputsResourceSet, id: 'sso'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
							//]
						//}
					]
				}
			]
	};
	backupmulticontainer.add(tmpContainer);
	backupmulticontainer.doLayout();
	Ext.getCmp('addResourcebtn').setText('Add More');
	Ext.getCmp('updateResourceBtn').enable();
	Ext.getCmp('clearResourceBtn').enable();
	Ext.getCmp('NoResourcePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('publisresource'+inputsResourceSet).focus(true);
	}
	inputsResourceSet++;
}

function removeResourceSet(containerID) 
{
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	backupmulticontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = backupmulticontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addResourcebtn').setText('Add');
			Ext.getCmp('NoResourcePattern').show();
			Ext.getCmp('updateResourceBtn').disable();
			Ext.getCmp('clearResourceBtn').disable();
		}
	}
}
//Horizon workspace logon simulator ends...

// AmazonWS workspace logon simulator starts...
function addAmazonResourceSetFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}
	var backupmulticontainer = Ext.getCmp('backupamazonresrccontainer');
	var conId = "con_"+inputsResourceSet

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeAmazonResourceSet(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
					{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Published resources',
							style:{'white-space':'nowrap'},
							id:'publisresource'+inputsResourceSet,
							name:'publisresource'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: registrationCode,
							style:{'white-space':'nowrap'},
							inputType: 'password',
							id:'regcode'+inputsResourceSet,
							name:'regcode'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Domain,
							style:{'white-space':'nowrap'},
							id:'domain'+inputsResourceSet,
							name:'domain'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'username'+inputsResourceSet,
							name:'username'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pwd'+inputsResourceSet,
							name: 'pwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpwd'+inputsResourceSet,
							name: 'confpwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						}
					]
				}
			]
	};
	backupmulticontainer.add(tmpContainer);
	backupmulticontainer.doLayout();
	Ext.getCmp('addAmazonResourcebtn').setText('Add More');
	Ext.getCmp('updateAmazonResourceBtn').enable();
	Ext.getCmp('clearAmazonResourceBtn').enable();
	Ext.getCmp('NoAmazonResourcePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('publisresource'+inputsResourceSet).focus(true);
	}
	inputsResourceSet++;
}

function removeAmazonResourceSet(containerID) 
{
	var backupmulticontainer = Ext.getCmp('backupamazonresrccontainer');
	backupmulticontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = backupmulticontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addAmazonResourcebtn').setText('Add');
			Ext.getCmp('NoAmazonResourcePattern').show();
			Ext.getCmp('updateAmazonResourceBtn').disable();
			Ext.getCmp('clearAmazonResourceBtn').disable();
		}
	}
}
// AmazonWS workspace logon simulator ends...

// Horizon cloud POD starts
function addHorizonMultiSet() {
	if (inputs == totalInputs)
	{
		Ext.Msg.show({
			title: alertTitle,
			msg: limitedLevel,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var mainForm = Ext.getCmp('horizoncloudmultipleusers');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmulti
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeHorizonMultiSet(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:120
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: serNameLbl,
						style:{'white-space':'nowrap'},
						id:'servnamemultiusr'+inputsmulti,
						value: '$unconfigured',
						labelWidth:150,
						columnWidth: 1
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: domNameLbl,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: userNameLbl,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmulti,
						inputType: 'password',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmulti,
						inputType: 'password',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	inputsmulti++;
	Ext.getCmp('addServersMultiSet').setText('Add More');
	Ext.getCmp('updateServersMultiSet').enable();
	Ext.getCmp('clearServersMultiSet').enable();
	Ext.getCmp('NoServersPattern').hide();
}
function removeHorizonMultiSet(containerID) {
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismulti = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addServersMultiSet').setText('Add');
		if (ismulti == 'true')
		{
			Ext.getCmp('NoServersPattern').show();
			Ext.getCmp('updateServersMultiSet').disable();
			Ext.getCmp('clearServersMultiSet').disable();
		}
	}
}

// Horizon cloud POD starts

function postCustomFormSubmit(temp)
{
	var url = '/final/admin/SnmpGetSubtree/data/EgSnmpOutputSaveJson.jsp?download=true&com.eg.CSRF_NONCE='+csrfToken;

	var form = document.createElement('form');
	form.setAttribute('method', 'post');
	form.setAttribute('action', url);


	var hiddenField = document.createElement('input');
	hiddenField.setAttribute('type', 'hidden');
	hiddenField.setAttribute('name', 'formdata');
	hiddenField.setAttribute('value', filterEncode(temp));

	form.appendChild(hiddenField);

	document.body.appendChild(form);
	form.submit();
}





