Ext.define('SpecificTestConfiguration.controller.IntermediateController',{
	extend:'Ext.app.Controller',

	refs:[
		{selector:'egvcconfig', ref:'egvcconfig'},
		{selector:'eghmcconfig', ref:'eghmcconfig'},
		{selector:'servicedetailedconfiguration', ref:'servicedetailedconfiguration'},
		{selector:'egdetailstest', ref:'egdetailstest'},
		{selector:'egxmsconfig', ref:'egxmsconfig'},
		{selector:'sitedetailedconfiguration', ref:'sitedetailedconfiguration'}
	],

	init:function(){
		testInterViews = this;
		this.control({
		});
	},
	egnutconfiginter: function(vchost) {
		var getComboVc = Ext.getCmp(vchost).getValue();
		if (getComboVc == 'Other')
		{
			Ext.create('SpecificTestConfiguration.view.EgNutConfig').show();
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egvcconfig',
				method: 'POST',
				async: false
			});
		}
		else if (getComboVc == 'None')
		{
			Ext.getCmp('Prism_user').setValue('$unconfigured');
			Ext.getCmp('Prism_password').setValue('$unconfigured');
			Ext.getCmp('Prism_passwordconfirmpassword').setValue('$unconfigured');
			Ext.getCmp('webPort').setValue('9440');
			Ext.getCmp('Prism_password').backupValue = '$unconfigured';
			Ext.getCmp('Prism_passwordconfirmpassword').backupValue = '$unconfigured';

		}
		else
		{
			var getVcComboVal = publicJson['virtualComboObj'][getComboVc];
			var splitValue = getVcComboVal.split('#');

			var splitPassword = splitValue[2];
			if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
			{
				splitPassword = splitPassword.replace(/~HASH~/g,'#');
			}

			Ext.getCmp('Prism_user').setValue(splitValue[1]);
			Ext.getCmp('Prism_password').setValue(splitPassword);
			Ext.getCmp('Prism_passwordconfirmpassword').setValue(splitPassword);
			Ext.getCmp('webPort').setValue(splitValue[4]);
			Ext.getCmp('Prism_password').backupValue = splitPassword;
			Ext.getCmp('Prism_passwordconfirmpassword').backupValue = splitPassword;
		}
	},
	clearNutInter: function(btn) {
		Ext.getCmp('vCenterIP').setValue('');
		Ext.getCmp('UsrVc').setValue('');
		Ext.getCmp('PwdVc').setValue('');
		Ext.getCmp('ConfPwdVc').setValue('');
		Ext.getCmp('PwdVc').backupValue = '';
		Ext.getCmp('ConfPwdVc').backupValue = '';
		Ext.getCmp('SslVc').reset();
		Ext.getCmp('WebPort').reset();
	},
	updateNutInter: function(btn) {
		var chekVc = this;
		var isVcValidate = chekVc.validateNutInter();
		if (isVcValidate)
		{
			var vcip = Ext.getCmp('vCenterIP').getValue();
			var uname = Ext.getCmp('UsrVc').getValue();
			var pass = Ext.getCmp('PwdVc').getValue();
			var sslVal = Ext.getCmp('SslVc').getValue();
			var webport = Ext.getCmp('WebPort').getValue();
			var ssl = false;
			if (sslVal == 'true')
			{
				ssl = true;
			}
			//else
			//{
				//ssl = 'False';
			//}
			var isDisc = Ext.getCmp('DiscVc').getValue();

			var qStr = "&uname="+uname+"&pass="+pass+"&ssl="+ssl+"&isDiscovery="+isDisc+"&webport="+webport+"&from=nutAdd";

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgchangeportspJson.jsp?'+qStr,
				method: 'POST',
				async: false,
				success: function( response )
				{
					Ext.getCmp('Prism_IP').setValue(vcip);
					Ext.getCmp('Prism_user').setValue(uname);
					Ext.getCmp('Prism_password').setValue(pass);
					Ext.getCmp('Prism_passwordconfirmpassword').setValue(pass);
					Ext.getCmp('Prism_password').backupValue = pass;
					Ext.getCmp('Prism_passwordconfirmpassword').backupValue = pass;

					Ext.getCmp('webPort').setValue(webport);
					if (ssl)
					{
						Ext.getCmp('ssl1').setValue(true);
					}
					else
					{
						Ext.getCmp('ssl2').setValue(true);
					}
				}
			});
			Ext.getCmp('nutconfig').destroy();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	validateNutInter: function(btn) {
		var me = this;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var vcip = Ext.getCmp('vCenterIP').getValue();
		var webPortValue = Ext.getCmp('WebPort').getValue();
		var uname = Ext.getCmp('UsrVc').getValue();
		var pass = Ext.getCmp('PwdVc').getValue();
		var confpasswd = Ext.getCmp('ConfPwdVc').getValue();

		for(var q=0;q<ex_nutStr.length;q++)
		{
			var ip = ex_nutStr[q].trim();
			if(vcip == ip)
			{
				Ext.Msg.show({
					title: alertNutTitle,
					msg: existNut ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('vCenterIP').focus(true);
					}
				});
				me.clearNutInter();
				return;
			}
		}

		if(!checkblank(vcip)||vcip=='None'||vcip == 'none'||vcip == 'other'||vcip == 'Other')
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: enterNut ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('vCenterIP').focus(true);
				}
			});
			return;
		}

		if(!validateIpOrHName(vcip))
		{
			Ext.getCmp('vCenterIP').focus(true);
			return;
		}
		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: enterUsrId ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true);
				}
			});
			return;
		}
		else if(!checkspecialExt(uname,"*+=|:;\"\'<>,\/[]?"))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: _checkspecial ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true);
				}
			});
			return;
		}
		else if (!checkHyphenText(uname,uname))
		{
			Ext.getCmp('UsrVc').focus();
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('UsrVc').focus();
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: _checkdots ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true);
				}
			});
			return;
		}
		else if (uname.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: _checkSpaces ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true);
				}
			});
			return;
		}
		if(pass == "")
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: enterPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdVc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(pass,"|"))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: PwdNotContainPipe ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdVc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkForPassValidity(pass))
		{
			Ext.getCmp('PwdVc').focus();
			sub = false;
			return;
		}
		else if(confpasswd == "")
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: enterCnfPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdVc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(pass != confpasswd)
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: matchPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdVc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkblank(webPortValue))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: PortBlank ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspace(webPortValue))
		{
			Ext.getCmp('WebPort').focus();
			sub = false;
			return;
		}
		else if(!checkcomma(webPortValue))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: CommaPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if (((!checknumber("+",webPortValue) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || webPortValue.indexOf(',') > -1)
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: validPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(webPortValue,splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.show({
				title: alertNutTitle,
				msg: specialCharacterPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else
		{
			return true;
		}
	},
	callNutInterDestroy: function() {
		Ext.getCmp('Prism_IP').setValue('None');
		Ext.getCmp('Prism_user').setValue('$unconfigured');
		Ext.getCmp('Prism_password').setValue('$unconfigured');
		Ext.getCmp('Prism_passwordconfirmpassword').setValue('$unconfigured');
		Ext.getCmp('Prism_password').backupValue = '$unconfigured';
		Ext.getCmp('Prism_passwordconfirmpassword').backupValue = '$unconfigured';

		Ext.getCmp('ssl1').setValue(true);
		Ext.getCmp('webPort').setValue('9440');
	}, //Nutanix ends
	egxmsIPsconfig: function(vchost) {
		var getComboVc = Ext.getCmp(vchost).getValue();
		if (getComboVc == 'Other')
		{
			Ext.create('SpecificTestConfiguration.view.EgXMSConfig').show();
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egxmsipconfig',
				method: 'POST',
				async: false
			});
		}
		else if (getComboVc == 'None')
		{
			Ext.getCmp('XtremIO_user').setValue('$unconfigured');
			Ext.getCmp('XtremIO_password').setValue('$unconfigured');
			Ext.getCmp('XtremIO_passwordconfirmpassword').setValue('$unconfigured');
			Ext.getCmp('XtremIO_password').backupValue = '$unconfigured';
			Ext.getCmp('XtremIO_passwordconfirmpassword').backupValue = '$unconfigured';

			Ext.getCmp('ssl2').setValue(true);
		}
		else
		{
			var getVcComboVal = publicJson['xmsIPComboObj'][getComboVc];
			var splitValue = getVcComboVal.split('#');

			if (!Ext.isEmpty(splitValue[0]) && (splitValue[0].toLowerCase() == 'false' || splitValue[0].toLowerCase() == 'no'))
			{
				Ext.getCmp('ssl1').setValue(true);
			}
			else
			{
				Ext.getCmp('ssl2').setValue(true);
			}

			Ext.getCmp('XtremIO_user').setValue(splitValue[1]);

			var splitPassword = splitValue[2];
			if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
			{
				splitPassword = splitPassword.replace(/~HASH~/g,'#');
			}

			Ext.getCmp('XtremIO_password').setValue(splitPassword);
			Ext.getCmp('XtremIO_passwordconfirmpassword').setValue(splitPassword);

			Ext.getCmp('XtremIO_password').backupValue = splitPassword;
			Ext.getCmp('XtremIO_passwordconfirmpassword').backupValue = splitPassword;

		}
	},
	clearXMSIPs: function(btn) {
		Ext.getCmp('xmsIP').setValue('');
		Ext.getCmp('UsrXMSIP').setValue('');
		Ext.getCmp('PwdXMSIP').setValue('');
		Ext.getCmp('ConfPwdXMSIP').setValue('');
		Ext.getCmp('PwdXMSIP').backupValue = '';
		Ext.getCmp('ConfPwdXMSIP').backupValue = '';
	},
	updateXMSIPs: function(btn) {
		var checkXMSIP = this;
		var isXMSIPValidate = checkXMSIP.validateXMSIP();
		if (isXMSIPValidate)
		{
			var xmsip = Ext.getCmp('xmsIP').getValue();
			var uname = Ext.getCmp('UsrXMSIP').getValue();
			var pass = Ext.getCmp('PwdXMSIP').getValue();
			var sslVal = Ext.getCmp('SslXMSIP').getValue();
			var ssl = '';
			if (sslVal.toLowerCase() == 'yes' || sslVal.toLowerCase() == 'true')
			{
				ssl = 'Yes';
			}
			else
			{
				ssl = 'No';
			}

			var isDisc = Ext.getCmp('DiscXMSIP').getValue();

			var qStr = "&ipAdd="+xmsip+"&uname="+uname+"&pass="+pass+"&ssl="+ssl+"&isDiscovery="+isDisc+"&from=xmsadd";

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgchangeportspJson.jsp?'+qStr,
				method: 'POST',
				async: false,
				success: function( response )
				{
					Ext.getCmp('xms_ip').setValue(xmsip);
					Ext.getCmp('XtremIO_user').setValue(uname);
					Ext.getCmp('XtremIO_password').setValue(pass);
					Ext.getCmp('XtremIO_passwordconfirmpassword').setValue(pass);
					Ext.getCmp('XtremIO_password').backupValue = pass;
					Ext.getCmp('XtremIO_passwordconfirmpassword').backupValue = pass;

					if (!Ext.isEmpty(sslVal) && (sslVal.toLowerCase() == 'false' || sslVal.toLowerCase() == 'no'))
					{
						Ext.getCmp('ssl1').setValue(true);
					}
					else
					{
						Ext.getCmp('ssl2').setValue(true);
					}
				}
			});
			Ext.getCmp('egxmsconfig').destroy();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	validateXMSIP: function(btn) {
		var me = this;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var xmsip = Ext.getCmp('xmsIP').getValue();
		var uname = Ext.getCmp('UsrXMSIP').getValue();
		var pass = Ext.getCmp('PwdXMSIP').getValue();
		var confpasswd = Ext.getCmp('ConfPwdXMSIP').getValue();

		for(var q=0;q<ex_xmsIPStr.length;q++)
		{
			var ip = ex_xmsIPStr[q].trim();
			if(xmsip == ip)
			{
				Ext.Msg.show({
					title: alertXMSTitle,
					msg: existXMSIP ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('xmsIP').focus(true,true);
					}
				});
				me.clearVcs();
				return;
			}
		}

		if(!checkblank(xmsip)|| xmsip=='None' || xmsip == 'none' || xmsip == 'other' || xmsip == 'Other')
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: enterXMSIP,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('xmsIP').focus(true,true);
				}
			});
			return;
		}

		if(!validateIpOrHNameExt(alertXMSTitle,Ext.getCmp('xmsIP')))
		{
			return;
		}
		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: enterUsrId ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrXMSIP').focus(true,true);
				}
			});
			return;
		}
		else if(!checkspecialExt(uname,"@*+=|:;\"\'<>,\/[]?"))
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: _checkspecial ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrXMSIP').focus(true,true);
				}
			});
			return;
		}
		else if (!checkHyphenText(uname,uname))
		{
			Ext.getCmp('UsrXMSIP').focus();
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('UsrXMSIP').focus();
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: _checkdots ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrXMSIP').focus(true,true);
				}
			});
			return;
		}
		else if (uname.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: _checkSpaces ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrXMSIP').focus(true,true);
				}
			});
			return;
		}
		if(pass == "")
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: enterPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdXMSIP').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(pass,"|"))
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: PwdNotContainPipe ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdXMSIP').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkForPassValidity(pass))
		{
			Ext.getCmp('PwdXMSIP').focus();
			sub = false;
			return;
		}
		else if(confpasswd == "")
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: enterCnfPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdXMSIP').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(pass != confpasswd)
		{
			Ext.Msg.show({
				title: alertXMSTitle,
				msg: matchPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdXMSIP').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else
		{
			return true;
		}
	},
	callXMSIPsDestroy: function() {
		Ext.getCmp('XtremIO_user').setValue('none');
		Ext.getCmp('XtremIO_password').setValue('none');
		Ext.getCmp('XtremIO_passwordconfirmpassword').setValue('none');
		Ext.getCmp('XtremIO_password').backupValue = 'none';
		Ext.getCmp('XtremIO_passwordconfirmpassword').backupValue = 'none';
	}, //XMS IP ends
	egvcsconfig: function(vchost) {
		var getComboVc = Ext.getCmp(vchost).getValue();
		if (getComboVc == 'Other')
		{
			Ext.create('SpecificTestConfiguration.view.EgVcConfig').show();
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egvcconfig',
				method: 'POST',
				async: false
			});
		}
		else if (getComboVc == 'None')
		{
			Ext.getCmp('Esx_user').setValue('$unconfigured');
			Ext.getCmp('Esx_password').setValue('$unconfigured');
			Ext.getCmp('Esx_passwordconfirmpassword').setValue('$unconfigured');
			Ext.getCmp('webPort').setValue('443');
			Ext.getCmp('Esx_password').backupValue = '$unconfigured';
			Ext.getCmp('Esx_passwordconfirmpassword').backupValue = '$unconfigured';

		}
		else
		{
			var getVcComboVal = publicJson['virtualComboObj'][getComboVc];
			var splitValue = getVcComboVal.split('#');

			var splitPassword = splitValue[2];
			if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
			{
				splitPassword = splitPassword.replace(/~HASH~/g,'#');
			}
			Ext.getCmp('Esx_user').setValue(splitValue[1]);
			Ext.getCmp('Esx_password').setValue(splitPassword);
			Ext.getCmp('Esx_passwordconfirmpassword').setValue(splitPassword);
			Ext.getCmp('webPort').setValue(splitValue[4]);
			Ext.getCmp('Esx_password').backupValue = splitPassword;
			Ext.getCmp('Esx_passwordconfirmpassword').backupValue = splitPassword;
		}
	},
	combosslVcs: function() {
		var sslvc = Ext.getCmp('SslVc').getValue();
		if (sslvc == "True")
		{
			Ext.getCmp('WebPort').setValue(443);
		}
		else
		{
			Ext.getCmp('WebPort').setValue(80);
		}
	},
	clearVcs: function(btn) {
		Ext.getCmp('vCenterIP').setValue('');
		Ext.getCmp('UsrVc').setValue('');
		Ext.getCmp('PwdVc').setValue('');
		Ext.getCmp('ConfPwdVc').setValue('');
		Ext.getCmp('PwdVc').backupValue = '';
		Ext.getCmp('ConfPwdVc').backupValue = '';
	},
	updateVcs: function(btn) {
		var chekVc = this;
		var isVcValidate = chekVc.validateVc();
		if (isVcValidate)
		{
			var vcip = Ext.getCmp('vCenterIP').getValue();
			var uname = Ext.getCmp('UsrVc').getValue();
			var pass = Ext.getCmp('PwdVc').getValue();
			var sslVal = Ext.getCmp('SslVc').getValue();
			var webport = Ext.getCmp('WebPort').getValue();
			var ssl = '';
			if (sslVal == 'Yes')
			{
				ssl = 'True';
			}
			else
			{
				ssl = 'False';
			}
			var isDisc = Ext.getCmp('DiscVc').getValue();
			//var srvType = Ext.getCmp('ServerTypeVc').getValue();

			var qStr = "&ipAdd="+vcip+"&uname="+uname+"&pass="+pass+"&ssl="+ssl+"&isDiscovery="+isDisc+"&webport="+webport+"&from=add";

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgchangeportspJson.jsp?'+qStr,
				method: 'POST',
				async: false,
				success: function( response )
				{
					Ext.getCmp('virtual_center').setValue(vcip);
					Ext.getCmp('Esx_user').setValue(uname);
					Ext.getCmp('Esx_password').setValue(pass);
					Ext.getCmp('Esx_passwordconfirmpassword').setValue(pass);
					Ext.getCmp('Esx_password').backupValue = pass;
					Ext.getCmp('Esx_passwordconfirmpassword').backupValue = pass;

				}
			});
			Ext.getCmp('vcconfig').destroy();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	validateVc: function(btn) {
		var me = this;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var vcip = Ext.getCmp('vCenterIP').getValue();
		var webPortValue = Ext.getCmp('WebPort').getValue();
		var uname = Ext.getCmp('UsrVc').getValue();
		var pass = Ext.getCmp('PwdVc').getValue();
		var confpasswd = Ext.getCmp('ConfPwdVc').getValue();

		for(var q=0;q<ex_vcStr.length;q++)
		{
			var ip = ex_vcStr[q].trim();
			if(vcip == ip)
			{
				Ext.Msg.show({
					title: alertVcTitle,
					msg: existVc ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('vCenterIP').focus(true,true);
					}
				});
				me.clearVcs();
				return;
			}
		}

		if(!checkblank(vcip)||vcip=='None'||vcip == 'none'||vcip == 'other'||vcip == 'Other')
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: enterVc ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('vCenterIP').focus(true,true);
				}
			});
			return;
		}

		if(!validateIpOrHNameExt(alertVcTitle,Ext.getCmp('vCenterIP')))
		{
			//Ext.getCmp('vCenterIP').focus(true);
			return;
		}
		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: enterUsrId ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true,true);
				}
			});
			return;
		}
		else if(!checkspecialExt(uname,"*+=|:;\"\'<>,\/[]?"))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: _checkspecial ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true,true);
				}
			});
			return;
		}
		else if (!checkHyphenText(uname,uname))
		{
			Ext.getCmp('UsrVc').focus();
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('UsrVc').focus();
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: _checkdots ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true,true);
				}
			});
			return;
		}
		else if (uname.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: _checkSpaces ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrVc').focus(true,true);
				}
			});
			return;
		}
		if(pass == "")
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: enterPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdVc').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(pass,"|"))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: PwdNotContainPipe ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdVc').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkForPassValidity(pass))
		{
			Ext.getCmp('PwdVc').focus();
			sub = false;
			return;
		}
		else if(confpasswd == "")
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: enterCnfPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdVc').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(pass != confpasswd)
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: matchPwd ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdVc').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkblank(webPortValue))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: PortBlank ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspace(webPortValue))
		{
			Ext.getCmp('WebPort').focus();
			sub = false;
			return;
		}
		else if(!checkcomma(webPortValue))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: CommaPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if (((!checknumber("+",webPortValue) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || webPortValue.indexOf(',') > -1)
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: validPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(webPortValue,splChar) && (webPortValue != 'NULL'))
		{
			Ext.Msg.show({
				title: alertVcTitle,
				msg: specialCharacterPrt ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('WebPort').focus(true,true);
				}
			});
			sub = false;
			return;
		}
		else
		{
			return true;
		}
	},
	callVcsDestroy: function() {
		Ext.getCmp('Esx_user').setValue('none');
		Ext.getCmp('Esx_password').setValue('none');
		Ext.getCmp('Esx_passwordconfirmpassword').setValue('none');
		Ext.getCmp('Esx_password').backupValue = 'none';
		Ext.getCmp('Esx_passwordconfirmpassword').backupValue = 'none';

	}, //Vc ends

	eghmcsconfig: function(hmchost) { //Hmc
		var getComboHmc = Ext.getCmp(hmchost).getValue();
		if (getComboHmc == 'Other')
		{
			Ext.create('SpecificTestConfiguration.view.EgHMCConfig').show();
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=eghmcconfig',
				method: 'POST',
				async: false
			});
		}
		else if (getComboHmc == 'None')
		{
			var getHmcComboVal = publicJson['hmcComboObj'][getComboHmc];
			if (!Ext.isEmpty(getHmcComboVal))
			{
				var splitHmc = getHmcComboVal.split('#');

				var splitPassword = splitHmc[2];
				if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
				{
					splitPassword = splitPassword.replace(/~HASH~/g,'#');
				}

				Ext.getCmp('management_user').setValue(splitHmc[1]);
				Ext.getCmp('management_password').setValue(splitPassword);
				Ext.getCmp('management_passwordconfirmpassword').setValue(splitPassword);
				Ext.getCmp('management_password').backupValue = splitPassword;
				Ext.getCmp('management_passwordconfirmpassword').backupValue = splitPassword;

			}
			else
			{
				Ext.getCmp('management_user').setValue('$unconfigured');
				Ext.getCmp('management_password').setValue('$unconfigured');
				Ext.getCmp('management_passwordconfirmpassword').setValue('$unconfigured');
				Ext.getCmp('management_password').backupValue = '$unconfigured';
				Ext.getCmp('management_passwordconfirmpassword').backupValue = '$unconfigured';

			}
		}
		else
		{
			var getHmcComboVal = publicJson['hmcComboObj'][getComboHmc];
			var splitHmc = getHmcComboVal.split('#');
			var splitPassword = splitHmc[2];
			if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
			{
				splitPassword = splitPassword.replace(/~HASH~/g,'#');
			}
			Ext.getCmp('management_user').setValue(splitHmc[1]);
			Ext.getCmp('management_password').setValue(splitPassword);
			Ext.getCmp('management_passwordconfirmpassword').setValue(splitPassword);
			Ext.getCmp('management_password').backupValue = splitPassword;
			Ext.getCmp('management_passwordconfirmpassword').backupValue = splitPassword;
		}
	},
	clearHmcs: function(btn) {
		Ext.getCmp('hmcIP').setValue('');
		Ext.getCmp('hmcHostName').setValue('');
		Ext.getCmp('UsrHmc').setValue('');
		Ext.getCmp('PwdHmc').setValue('');
		Ext.getCmp('ConfPwdHmc').setValue('');
		Ext.getCmp('PwdHmc').backupValue = '';
		Ext.getCmp('ConfPwdHmc').backupValue = '';
	},
	updateHmcs: function(btn) {
		var chekHmc = this;
		var isHmcValidate = chekHmc.validateHmc();
		if (isHmcValidate)
		{
			var ipAdd = Ext.getCmp('hmcIP').getValue();
			var hName = Ext.getCmp('hmcHostName').getValue();
			var uname = Ext.getCmp('UsrHmc').getValue();
			var pass = Ext.getCmp('PwdHmc').getValue();
			var sslVal = Ext.getCmp('SslHmc').getValue();
			var ssl = '';
			if (sslVal == 'Yes')
			{
				ssl = 'True';
			}
			else
			{
				ssl = 'False';
			}
			var isDisc = Ext.getCmp('DiscHmc').getValue();

			var qStr = "&uname="+uname+"&pass="+pass+"&ssl="+ssl+"&isDiscovery="+isDisc+"&ipAdd="+ipAdd+"&from=hmcAdd&hName="+hName;

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgchangeportspJson.jsp?'+qStr,
				method: 'POST',
				async: false,
				success: function( response )
				{
					Ext.getCmp('management_server').setValue(ipAdd);
					Ext.getCmp('management_user').setValue(uname);
					Ext.getCmp('management_password').setValue(pass);
					Ext.getCmp('management_passwordconfirmpassword').setValue(pass);
					Ext.getCmp('management_password').backupValue = pass;
					Ext.getCmp('management_passwordconfirmpassword').backupValue = pass;
				}
			});
			Ext.getCmp('hmcconfig').destroy();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	validateHmc: function(btn) {
		var hmcme = this;
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";

		var ipValue = Ext.getCmp('hmcIP').getValue().trim();
		var hostName = Ext.getCmp('hmcHostName').getValue().trim();
		var userName = Ext.getCmp('UsrHmc').getValue().trim();
		var password = Ext.getCmp('PwdHmc').getValue();
		var confirmPwd = Ext.getCmp('ConfPwdHmc').getValue();

		for(var r=0;r<ex_hmcStr.length;r++)
		{
			var ip = ex_hmcStr[r].trim();
			if(ipValue == ip)
			{
				Ext.Msg.show({
					title: alerthmcTitle,
					msg: existHmc ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						hmcme.clearHmcs();
						Ext.getCmp('hmcIP').focus(true);
					}
				});
				return;
			}
		}

		if (ipValue == "")
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: enterHmcIP,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('hmcIP').focus(true);
				}
			});
			return;
		}
		else if (!validateIp(ipValue))
		{
			Ext.getCmp('hmcIP').focus();
			return;
		}
		else if (hostName == "")
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: enterHmcHstName,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('hmcHostName').focus(true);
				}
			});
			return;
		}
		else if (!validateIpOrHName(hostName))
		{
			Ext.getCmp('hmcHostName').focus();
			return;
		}
		else if (userName == "")
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: enterHmcUsr,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrHmc').focus(true);
				}
			});
			return;
		}
		else if(!checkspecial(userName,"@*+=|:;\"\'<>,\/[]?"))
		{
			Ext.getCmp('UsrHmc').focus();
			return;
		}
		else if (userName.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: _checkdots,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrHmc').focus(true);
				}
			});
			return;
		}
		else if (userName.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: _checkSpaces,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrHmc').focus(true);
				}
			});
			return;
		}
		else if(password == "")
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: enterPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdHmc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(password,"|"))
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: PwdNotContainPipe,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdHmc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkForPassValidity(password))
		{
			Ext.getCmp('PwdHmc').focus();
			sub = false;
			return;
		}
		else if(confirmPwd == "")
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: enterCnfPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdHmc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(password != confirmPwd)
		{
			Ext.Msg.show({
				title: alerthmcTitle,
				msg: matchPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdHmc').focus(true);
				}
			});
			sub = false;
			return;
		}
		else
		{
			return true;
		}
	},
	callHmcsDestroy: function() {
		Ext.getCmp('management_user').setValue('none');
		Ext.getCmp('management_password').setValue('none');
		Ext.getCmp('management_passwordconfirmpassword').setValue('none');
		Ext.getCmp('management_password').backupValue = 'none';
		Ext.getCmp('management_passwordconfirmpassword').backupValue = 'none';
	}, //Hmc ends

	egrhevsconfig: function(rhevhost) { //Rhev starts
		var getComboVal = Ext.getCmp(rhevhost).getValue();
		if (getComboVal == 'Other')
		{
			Ext.create('SpecificTestConfiguration.view.EgRhevConfig').show();
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egrhevconfig',
				method: 'POST',
				async: false
			});
		}
		else if (getComboVal == 'None')
		{
			Ext.getCmp('Rhel_mgr_user').setValue('$unconfigured');
			Ext.getCmp('Rhel_mgr_password').setValue('$unconfigured');
			Ext.getCmp('Rhel_mgr_passwordconfirmpassword').setValue('$unconfigured');
			Ext.getCmp('Rhel_mgr_password').backupValue = '$unconfigured';
			Ext.getCmp('Rhel_mgr_passwordconfirmpassword').backupValue = '$unconfigured';


			Ext.getCmp('Rhel_mgr_domain').setValue('internal');
			Ext.getCmp('Rhel_mgr_port').setValue('443');
			if (Ext.getCmp('Hypervisor_user') != null || Ext.getCmp('Hypervisor_user') != undefined)
			{
				Ext.getCmp('Hypervisor_user').setValue('$unconfigured');
				Ext.getCmp('Hypervisor_password').setValue('$unconfigured');
				Ext.getCmp('Hypervisor_passwordconfirmpassword').setValue('$unconfigured');
				Ext.getCmp('Hypervisor_password').backupValue = '$unconfigured';
				Ext.getCmp('Hypervisor_passwordconfirmpassword').backupValue = '$unconfigured';

			}
		}
		else
		{
			var getRhevComboVal = publicJson['rhevComboObj'][getComboVal];
			var splitRhev = getRhevComboVal.split('#');
			Ext.getCmp('Rhel_mgr_user').setValue(splitRhev[1]);

			var splitPassword = splitRhev[2];
			if (!Ext.isEmpty(splitPassword) && splitPassword.indexOf("~HASH~") != -1)
			{
				splitPassword = splitPassword.replace(/~HASH~/g,'#');
			}
			Ext.getCmp('Rhel_mgr_password').setValue(splitPassword);
			Ext.getCmp('Rhel_mgr_passwordconfirmpassword').setValue(splitPassword);
			Ext.getCmp('Rhel_mgr_port').setValue(splitRhev[4]);
			Ext.getCmp('Rhel_mgr_domain').setValue(splitRhev[5]);
			Ext.getCmp('Rhel_mgr_password').backupValue = splitPassword;
			Ext.getCmp('Rhel_mgr_passwordconfirmpassword').backupValue = splitPassword;

		}
	},
	combosslrhevs: function() {
		var sslrhev = Ext.getCmp('SslRhev').getValue();
		if (sslrhev == "True")
		{
			Ext.getCmp('MgrPort').setValue(8443);
		}
		else
		{
			Ext.getCmp('MgrPort').setValue(8080);
		}
	},
	clearRhevs: function(btn) {
		Ext.getCmp('RhevMgrId').setValue('');
		Ext.getCmp('UsrRhev').setValue('');
		Ext.getCmp('PwdRhev').setValue('');
		Ext.getCmp('ConfPwdRhev').setValue('');
		Ext.getCmp('PwdRhev').backupValue = '';
		Ext.getCmp('ConfPwdRhev').backupValue = '';
		Ext.getCmp('DomainRhev').setValue('');
	},
	updateRhevs: function(btn) {
		var chekRhev = this;
		var isRhevValidate = chekRhev.validateRhev();
		if (isRhevValidate)
		{
			var ipAdd = Ext.getCmp('RhevMgrId').getValue();
			var uname = Ext.getCmp('UsrRhev').getValue();
			var pass = Ext.getCmp('PwdRhev').getValue();
			var MgrPort = Ext.getCmp('MgrPort').getValue();
			var sslVal = Ext.getCmp('SslRhev').getValue();
			var ssl = '';
			if (sslVal == 'Yes')
			{
				ssl = 'True';
			}
			else
			{
				ssl = 'False';
			}
			var isDisc = Ext.getCmp('DiscRhev').getValue();
			var domain = Ext.getCmp('DomainRhev').getValue();

			var qStr = "ipAdd="+ipAdd+"&uname="+uname+"&pass="+pass+"&ssl="+ssl+"&isDiscovery="+isDisc+"&domain="+domain+"&from=rhevadd&webport="+MgrPort;

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgRHEVdiscoverypJson.jsp?'+qStr,
				method: 'POST',
				async: false,
				success: function( response )
				{
					Ext.getCmp('Rhel_mgr_host').setValue(ipAdd);
					Ext.getCmp('Rhel_mgr_user').setValue(uname);
					Ext.getCmp('Rhel_mgr_password').setValue(pass);
					Ext.getCmp('Rhel_mgr_passwordconfirmpassword').setValue(pass);
					Ext.getCmp('Rhel_mgr_domain').setValue(domain);
					Ext.getCmp('Rhel_mgr_port').setValue(MgrPort);
					Ext.getCmp('Rhel_mgr_password').backupValue = pass;
					Ext.getCmp('Rhel_mgr_passwordconfirmpassword').backupValue = pass;
				}
			});
			Ext.getCmp('rhevconfig').destroy();
		}

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	validateRhev: function(btn) {
		var me = this;
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var mgrPortValue = Ext.getCmp('MgrPort').getValue();
		var uname = Ext.getCmp('UsrRhev').getValue();
		var pass = Ext.getCmp('PwdRhev').getValue();
		var confpasswd = Ext.getCmp('ConfPwdRhev').getValue();
		var RhevMgrId = Ext.getCmp('RhevMgrId').getValue();

		for(var q=0;q<ex_rhevStr.length;q++)
		{
			var ip = ex_rhevStr[q].trim();
			if(RhevMgrId == ip)
			{
				Ext.Msg.show({
					title: alertrhevTitle,
					msg: existRhev,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('RhevMgrId').focus(true);
					}
				});
				me.clearRhevs();
				return;
			}
		}

		if(!checkblank(RhevMgrId)||RhevMgrId=='None'||RhevMgrId == 'none'||RhevMgrId == 'other'||RhevMgrId == 'Other')
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: enterRhev,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('RhevMgrId').focus(true);
				}
			});
			return;
		}

		if(!validateIpOrHName(RhevMgrId))
		{
			Ext.getCmp('RhevMgrId').focus();
			return;
		}
		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: enterUsrId,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrRhev').focus(true);
				}
			});
			return;
		}
		else if(!checkspecial(uname,"@*+=|:;\"\'<>,\/[]?"))
		{
			Ext.getCmp('UsrRhev').focus();
			return;
		}
		else if (!checkHyphenText(uname,uname))
		{
			Ext.getCmp('UsrRhev').focus();
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('UsrRhev').focus();
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: _checkdots,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrRhev').focus(true);
				}
			});
			return;
		}
		else if (uname.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: _checkSpaces,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('UsrRhev').focus(true);
				}
			});
			return;
		}
		if(pass == "")
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: enterPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdRhev').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(pass,"|"))
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: PwdNotContainPipe,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('PwdRhev').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkForPassValidity(pass))
		{
			Ext.getCmp('PwdRhev').focus();
			sub = false;
			return;
		}
		else if(confpasswd == "")
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: enterCnfPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdRhev').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(pass != confpasswd)
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: matchPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('ConfPwdRhev').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkblank(mgrPortValue))
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: PortBlank,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('MgrPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspace(mgrPortValue))
		{
			Ext.getCmp('MgrPort').focus();
			sub = false;
			return;
		}
		else if(!checkcomma(mgrPortValue))
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: CommaPrt,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('MgrPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if (((!checknumber("+",mgrPortValue) && mgrPortValue.indexOf(',') == -1) || mgrPortValue == 0 || mgrPortValue.indexOf('.') > -1) && (mgrPortValue == 'NULL') || mgrPortValue.indexOf(',') > -1)
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: validPrt,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('MgrPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else if(!checkspecialnomess(mgrPortValue,splChar) && (mgrPortValue != 'NULL'))
		{
			Ext.Msg.show({
				title: alertrhevTitle,
				msg: specialCharacterPrt,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('MgrPort').focus(true);
				}
			});
			sub = false;
			return;
		}
		else
		{
			return true;
		}
	},
	callRhevsDestroy: function() {
		Ext.getCmp('Rhel_mgr_user').setValue('none');
		Ext.getCmp('Rhel_mgr_password').setValue('none');
		Ext.getCmp('Rhel_mgr_passwordconfirmpassword').setValue('none');
		Ext.getCmp('Rhel_mgr_password').backupValue = 'none';
		Ext.getCmp('Rhel_mgr_passwordconfirmpassword').backupValue = 'none';

	}, //Rhev ends
	EgOidsValue: function() {  //EgOidsValues starts
		Ext.create('SpecificTestConfiguration.view.EgOidsValue').show();
		var dom = '';
		inputs = 2;
		isVmg = 'false';
		removedOid=[];
		var strTestName = publicJson['testName'];
		var oids_id='measure_oid';
		var Valuedomain = Ext.getCmp(oids_id).getValue();
		var splitDomain = Valuedomain.split(",");
		var fieldLength=splitDomain.length;
		if(fieldLength > 8)
		{
			fieldLength=8;
		}
		if (Valuedomain != null || Valuedomain != undefined)
		{
			for (var k =0;k<fieldLength-1;k++ )
			{
				addOids();
			}
			 for (dom=1;dom<fieldLength+1;dom++)
			{
				Ext.getCmp('oidVal'+dom).setValue(splitDomain[dom-1]);
			}  
		} 
		 Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=EgOidsValue',
			method: 'POST',
			async: false
		}); 
	},
	ClearOids: function(btn) {
		var backuppcontainer = Ext.getCmp('backupcontainer');
		backuppcontainer.removeAll();
		Ext.getCmp('addOidbtn').setText('Add');
		Ext.getCmp('NoOidPattern').show();

		if (Ext.getCmp('conoid_1') != null || Ext.getCmp('conoid_1') != undefined)
		{
			isVmg = 'true';
			Ext.getCmp('conoid_1').removeAll();
			Ext.getCmp('conoid_1').hide();
		}
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			isVmg = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateOid').disable();
		Ext.getCmp('clearOid').disable();
		inputs=1;
		removedOid=[];
	},
	UpdateOids: function (btn){
		var vmginputs = 9;
		var strTestName = publicJson['testName'];
		var oids_id='measure_oid';
		var multidomainVal = "";
		for(var n=1;n<vmginputs; n++)
		{		
			if (Ext.getCmp('oidVal'+n) == undefined)
			{
				continue;
			}
			var multidomain= Ext.getCmp('oidVal'+n).getValue();
			if(multidomain == undefined) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('oidVal'+n).focus(true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('oidVal'+n).focus(true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('oidVal'+n).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('oidVal'+n).focus();
					return;
				}
				else if(!checkspecialnomess(multidomain,"`~!@#$%^&*()+=-/?'\"]}[{\\|;:,><"))
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: infosalert_2,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('oidVal'+n).focus(true);
						}
					});
					return;
				}
				else if(checkAlpha(multidomain))
				{
					Ext.Msg.show({
					title: alertTitle,
					msg: infosalert_5,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
						Ext.getCmp('oidVal'+n).OidObj.focus(true);
						}
					}
					});
					return;
				}
				var dom_Val = Ext.getCmp(oids_id).getValue();
				var tempmultidoma = Ext.getCmp('oidVal'+n).getValue();
				multidomainVal+=tempmultidoma+",";
			}
		}
		multidomainVal = multidomainVal.substring(0,multidomainVal.length-1);
		Ext.getCmp(oids_id).setValue(multidomainVal);
		Ext.getCmp(oids_id).setReadOnly(true);
		Ext.getCmp('EgOidsValue').destroy();
		var compTypeVal = Ext.getCmp('componentType').getValue();
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	vmgusers: function() {  //vmgusers starts
		Ext.create('SpecificTestConfiguration.view.VmgUsers').show();
		inputs = 0;
		inputsVmg = 0;
//		isVmg = 'false';

		var Valuedomain = Ext.getCmp('domain').getValue();
		var Valueadmin_user = Ext.getCmp('admin_user').getValue();
		var Valueadmin_pass = Ext.getCmp('admin_password').getValue();

		var splitDomain = Valuedomain.split(",");
		var splitadmin_user = Valueadmin_user.split(",");
		var splitadmin_pass = Valueadmin_pass.split("#~#");

		if (Valuedomain != null || Valuedomain != undefined)
		{
			for (var k =0;k<splitDomain.length;k++ )
			{
				addContact();
			}
			for (var dom = 0; dom < splitDomain.length; dom++)
			{
				Ext.getCmp('domainvmg'+dom).setValue(splitDomain[dom]);
				Ext.getCmp('admusrvmg'+dom).setValue(splitadmin_user[dom]);
				Ext.getCmp('admpwdvmg'+dom).setValue(splitadmin_pass[dom]);
				Ext.getCmp('confpwdvmg'+dom).setValue(splitadmin_pass[dom]);
				Ext.getCmp('admpwdvmg'+dom).backupValue = splitadmin_pass[dom];
				Ext.getCmp('confpwdvmg'+dom).backupValue = splitadmin_pass[dom];
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=vmgusers',
			method: 'POST',
			async: false
		});
	},
	ClearConfigUsr: function(btn) {
		var backuppcontainer = Ext.getCmp('backupcontainer');
		backuppcontainer.removeAll();

		inputs = 0;
		inputsVmg = 0;
		addContact();

		var value = '$unconfigured';
		if(insideView == 'tcp')
		{
			value = 'none';
		}
		Ext.getCmp('domainvmg'+(inputs-1)).setValue(value);
		Ext.getCmp('admusrvmg'+(inputs-1)).setValue(value);
		Ext.getCmp('admpwdvmg'+(inputs-1)).setValue(value);
		Ext.getCmp('confpwdvmg'+(inputs-1)).setValue(value);
		Ext.getCmp('admpwdvmg'+(inputs-1)).backupValue = value;
		Ext.getCmp('confpwdvmg'+(inputs-1)).backupValue = value;
	},
	UpdateConfigUsr: function(btn) {
		var vmginputs = inputs;
		var domains = [];
		var usernames = [];
		for (var m=0;m<vmginputs;m++)
		{
			if (Ext.getCmp('domainvmg'+m) == undefined)
			{
				continue;
			}
			var domain = Ext.getCmp('domainvmg'+m).getValue();
			var uname = Ext.getCmp('admusrvmg'+m).getValue();
			var pass = Ext.getCmp('admpwdvmg'+m).getValue();
			var confpasswd = Ext.getCmp('confpwdvmg'+m).getValue();
			domains.push(domain);
			usernames.push(uname);

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainvmg'+m).focus(true);
					}
				});
				return;
			}

			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainvmg'+m).focus(true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainvmg'+m).focus(true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainvmg'+m).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainvmg'+m).focus(true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admusrvmg'+m).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admusrvmg'+m).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialExt(uname,"@*+=|:;\"<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('admusrvmg'+m).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('admusrvmg'+m).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('admusrvmg'+m).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admusrvmg'+m).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admusrvmg'+m).focus(true);
					}
				});
				return;
			}
			if(pass == "")
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admpwdvmg'+m).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admpwdvmg'+m).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admpwdvmg'+m).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('admpwdvmg'+m).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('admpwdvmg'+m).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdvmg'+m).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdvmg'+m).focus(true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdvmg'+m).focus(true);
					}
				});
				sub = false;
				return;
			}
		}

		//Bug ID:11075 --> We should allow to give multiple same users with different password for IBM Pseries component in Test specification screen instead of showing alert message (user name already exists)

		//var error = false;
		//for(var i = 0; i < domains.length; i++)
		//{
			//var count = 0;
			//var validDom = domains[i];
			//var validUN = usernames[i];
			//for(var j = 0; j < usernames.length; j++)
			//{
				//if(j == i)
				//{
					//j++;
				//}
				//if(usernames[j] == undefined)
				//{
					//continue;
				//}
				//if(validUN == usernames[j])
				//{
					//if(validDom == domains[j])
					//{
						//error = true;
						//break;
					//}
				//}
			//}
			//if(error)
			//{
				//break;
			//}
		//}
		//if(error)
		//{
			//Ext.Msg.show({
				//title: alertTitle,
				//msg: alertMsg83,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation'
			//});
			//return;
		//}

		var multidomainVal = "";
		var multiunameVal = "";
		var multipassVal = "";
		for(var n=0;n<vmginputs; n++)
		{
			if (Ext.getCmp('domainvmg'+n) == undefined)
			{
				continue;
			}
			var multidomain= Ext.getCmp('domainvmg'+n).getValue();
			if(multidomain == undefined) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainvmg'+n).focus(true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainvmg'+n).focus(true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{

					Ext.Msg.show({
						title: alertTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainvmg'+n).focus();
					return;
				}
			}
			var multiUname = Ext.getCmp('admusrvmg'+n).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admusrvmg'+n).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admusrvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"@*+=|:;\"<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('admusrvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('admusrvmg'+n).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admusrvmg'+n).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admusrvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('admusrvmg'+n).focus();
					return;
				}
			}
			var multipass = Ext.getCmp('admpwdvmg'+n).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdvmg'+n).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admpwdvmg'+n).focus(true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admpwdvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admpwdvmg'+n).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('admpwdvmg'+n).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('admpwdvmg'+n).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdvmg'+n).focus(true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdvmg'+n).focus(true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdvmg'+n).focus(true);
						}
					});
					return;
				}
			}
			if(multidomain!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var dom_Val = Ext.getCmp('domain').getValue();
				var adminVal = Ext.getCmp('admin_user').getValue();
				var adminPassVal = Ext.getCmp('admin_password').getValue();

				var tempmultidoma = Ext.getCmp('domainvmg'+n).getValue();
				multidomainVal+=tempmultidoma+",";

				var tempmultiUname = Ext.getCmp('admusrvmg'+n).getValue();
				multiunameVal+=tempmultiUname+",";

				var tempmultiPass = Ext.getCmp('admpwdvmg'+n).getValue();
				multipassVal+=tempmultiPass+"#~#";
			}
		}

		multidomainVal = multidomainVal.substring(0,multidomainVal.length-1);
		Ext.getCmp('domain').setValue(multidomainVal);

		multiunameVal = multiunameVal.substring(0,multiunameVal.length-1);
		Ext.getCmp('admin_user').setValue(multiunameVal);

		multipassVal = multipassVal.substring(0,multipassVal.length-3);
		Ext.getCmp('admin_password').setValue(multipassVal);
		Ext.getCmp('admin_password').backupValue = multipassVal;

		if (Ext.getCmp('Admincpwd') != null && Ext.getCmp('Admincpwd') != undefined)
		{
			Ext.getCmp('Admincpwd').setValue(multipassVal);
			Ext.getCmp('Admincpwd').backupValue = multipassVal;
			Ext.getCmp('Admincpwd').setReadOnly(true);
		}
		if (Ext.getCmp('admin_passwordconfirmpassword') != null && Ext.getCmp('admin_passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('admin_passwordconfirmpassword').setValue(multipassVal);
			Ext.getCmp('admin_passwordconfirmpassword').setReadOnly(true);
			Ext.getCmp('admin_passwordconfirmpassword').backupValue = multipassVal;
		}
		Ext.getCmp('domain').setReadOnly(true);
		Ext.getCmp('admin_user').setReadOnly(true);
		Ext.getCmp('admin_password').setReadOnly(true);
		Ext.getCmp('vmgusers').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	interConfigMultiSource: function(btn) 
	{  
		Ext.create('SpecificTestConfiguration.view.EgConfigurePublishedResources').show();

		var multidom = '';
		inputsmultisrc = 2;
		ismultisrc = 'false';

		//var ValuePublisresources = Ext.getCmp('Published_resources').getValue();
		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		var ValueUsrdomain = Ext.getCmp('Domain').getValue();
		var ValueUsrdisclaimer = Ext.getCmp('Disclaimer').getValue();
		var ValueUsr2FA = Ext.getCmp('Two_factor_auth_password').getValue();
		var Valueuser = Ext.getCmp('Username').getValue();
		var Valuepass = Ext.getCmp('Password').getValue();
		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}

		var splitPublisSrc = ValuePublisresources.split("|");
		var splitUsr2FA = ValueUsr2FA.split("#~#");
		var splitUsrDomain = ValueUsrdomain.split(",");
		var splitUsrDisclaim = ValueUsrdisclaimer.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addMultiSourceContact();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				if (!Ext.isEmpty(splitPublisSrc[multidom-1]) && splitPublisSrc[multidom-1].indexOf('~#~') != -1)
				{
					splitPublisSrc[multidom-1] = splitPublisSrc[multidom-1].replace(/~#~/g,',');
				}

				var str2FAToken = splitUsr2FA[multidom-1];
				var strDisClaimer = splitUsrDisclaim[multidom-1];
				if (!Ext.isEmpty(str2FAToken) && (str2FAToken != 'FF6EBC35F4F93E0C1057BBC2E53B1DF3' && str2FAToken.toLowerCase() != 'none'))
				{
					Ext.getCmp('twofactlabel'+multidom+'_1').setValue(true);
					Ext.getCmp('twofacttoken'+multidom).setVisible(true);
					Ext.getCmp('twofacttoken'+multidom).setValue(str2FAToken);
					Ext.getCmp('twofacttoken'+multidom).backupValue = str2FAToken;
				}

				Ext.getCmp('publisresource'+multidom).setValue(splitPublisSrc[multidom-1]);
				
				if (!Ext.isEmpty(strDisClaimer))
				{
					if (strDisClaimer.toLowerCase() == 'true')
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_1').setValue(true);
					}
					else
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_2').setValue(true);
					}
				}
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	interMultiSourceClr: function(btn) 
	{
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addMultiSrcbtn').setText('Add');
		Ext.getCmp('NoMultiUsrPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismultisrc = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateMultiConfSrc').disable();
		Ext.getCmp('clearMultiConfSrc').disable();
	},
	interMultiSourceUpdate: function(btn) 
	{
		var multiinputs = inputsmultisrc;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var publishResource = Ext.getCmp('publisresource'+mul).getValue();
			var twoFactAuth = Ext.getCmp('twofacttoken'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			var twofa = Ext.getCmp('twofact'+mul).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();

			if (!checkblank(publishResource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(publishResource,"`*=#.|;\"\'<>\/[]?"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(publishResource) == "")
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			//else if(!checkHyphenText(publishResource,"published_resources"))
			//{
				//Ext.getCmp('publisresource'+mul).focus();
				//return;
			//}
			else if (publishResource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf(":") > -1)
			{
				var val = publishResource;
				if (val.indexOf(",") != -1)
				{
					var values = val.split(",");
					for(var v=0;v < values.length;v++)
					{
						var tmpVal = values[v];

						if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < tmpVal.length;k++)
							{
								if (tmpVal.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mul).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
								else
								{
									continue;
								}
							}
							
							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
				else
				{
					if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
					{
						Ext.Msg.show ({
							title: pageName,
							msg: "Published resource should not start or end with a colon",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('publisresource'+mul).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var moreColons = new Array();
						for(var k=0;k < val.length;k++)
						{
							if (val.charAt(k) == ':')
							{
								moreColons.push(k);
							}

							if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Cannot have ':' in consecutive positions",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return ;
							}
							else
							{
								continue;
							}
						}

						if (moreColons.length > 1)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							moreColons = new Array();
							return;
						}
					}
				}
			}
			
			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if(pass == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiUsrdomainVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*=#.|;\"\'<>\/[]?"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				//else if(!checkHyphenText(multiSrcPublis,"published_resources"))
				//{
					//Ext.getCmp('publisresource'+mulusr).focus();
					//return;
				//}
				else if (multiSrcPublis.indexOf(":") > -1)
				{
					var val = multiSrcPublis;
					if (val.indexOf(",") != -1)
					{
						var values = val.split(",");
						for(var v=0;v < values.length;v++)
						{
							var tmpVal = values[v];

							if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Published resource should not start or end with a colon",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								return;
							}
							else
							{
								var moreColons = new Array();
								for(var k=0;k < tmpVal.length;k++)
								{
									if (tmpVal.charAt(k) == ':')
									{
										moreColons.push(k);
									}
									if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
									{
										Ext.Msg.show ({
											title: pageName,
											msg: "Cannot have ':' in consecutive positions",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function() {
												Ext.getCmp('publisresource'+mulusr).focus(true,true);
											}
										});
										moreColons = new Array();
										return;
									}
									else
									{
										continue;
									}
								}

								if (moreColons.length > 1)
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
							}
						}
					}
					else
					{
						if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mulusr).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < val.length;k++)
							{
								if (val.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return ;
								}
								else
								{
									continue;
								}
							}

							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
			}

			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
			if(multidisclaimer == null) continue;

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multi2FAuth= Ext.getCmp('twofacttoken'+mulusr).getValue();
			var multitwofa = Ext.getCmp('twofact'+mulusr).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}
			
			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
			}

			if(multiPublishSrcVal != null && multi2FAuth != null && multidomain!=null && multidisclaimer!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+",";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+mulusr).getValue();
				var multi2FA = Ext.getCmp('twofact'+mulusr).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);
		Ext.getCmp('Two_factor_auth_password').setValue(multi2FAuthVal);
		Ext.getCmp('Two_factor_auth_password').backupValue = multi2FAuthVal;

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('Domain').setValue(multiUsrdomainVal);

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);
		Ext.getCmp('Disclaimer').setValue(multiUsrdisclaimVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('Username').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').hide();
		Ext.getCmp('Domain').setReadOnly(true);
		Ext.getCmp('Domain').hide();
		Ext.getCmp('Disclaimer').setReadOnly(true);
		Ext.getCmp('Disclaimer').hide();
		Ext.getCmp('Username').setReadOnly(true);
		Ext.getCmp('Username').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('egconfigurepublishedresources').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	configMultiUser: function(btn) {  //Config Multiple User
		Ext.create('SpecificTestConfiguration.view.EgConfigureMultipleUsers').show();

		var multidom = '';
		inputsmulti = 2;
		ismulti = 'false';

		var ValueUsrdomain = Ext.getCmp('domain').getValue();
		var Valueuser = Ext.getCmp('user').getValue();
		var Valuepass = Ext.getCmp('password').getValue();

		var splitUsrDomain = ValueUsrdomain.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addMultiUsrContact();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	ClearMultiConfigUsr: function(btn) {
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addMultiUsrbtn').setText('Add');
		Ext.getCmp('NoMultiUsrPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateMultiConfUsr').disable();
		Ext.getCmp('clearMultiConfUsr').disable();
	},
	UpdateMultiConfigUsr: function(btn) {
		var multiinputs = inputsmulti;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(uname,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if(pass == "")
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiUsrdomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}
			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}
			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecial(multiUname,"@*+=|:;\"\'<>\/[]?,"))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}
			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
			}
			if(multidomain!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('domain').setValue(multiUsrdomainVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('user').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('password').setValue(multiUsrpassVal);
		Ext.getCmp('password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('passwordconfirmpassword') != null && Ext.getCmp('passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('domain').setReadOnly(true);
		Ext.getCmp('user').setReadOnly(true);
		Ext.getCmp('password').setReadOnly(true);
		Ext.getCmp('egconfiguremultipleusers').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	//Targets starts
	configTgtsSysProps: function(btn){
		Ext.create('SpecificTestConfiguration.view.EgConfigureTargetsAndSysProps').show();
		inputsTrgtUrl = 2;
		var ValueTrgtUrl = Ext.getCmp('targets').getValue();
		var splitTgtUrls = ValueTrgtUrl.split(",");

		if(ValueTrgtUrl!='' || ValueTrgtUrl != null || ValueTrgtUrl != undefined){
			var	v_systempropkeys = Ext.getCmp('systempropskey').getValue();
			var	v_systempropvalues = Ext.getCmp('systempropsvalue').getValue();

			var split_systempropkeys=v_systempropkeys.split(",");
			var	split_systempropvalues=v_systempropvalues.split(",");

			Ext.suspendLayouts();
			for (var k =0;k<splitTgtUrls.length-1;k++ )
			{
				addTrgtUrlContact();
			}
			for (cnt=1;cnt<splitTgtUrls.length+1;cnt++)
			{
				var tgtHostPort=splitTgtUrls[cnt-1];
				if(tgtHostPort.indexOf("https://")!=-1 || tgtHostPort.indexOf("https:\\")!=-1){
					var oriStr=tgtHostPort.substring(0,8);
					var httpsStr=tgtHostPort.substring(8);
					if(httpsStr.indexOf(':')!=-1){
						var hst=httpsStr.substring(0,httpsStr.indexOf(':'));
    					var prt=httpsStr.substring(httpsStr.indexOf(':')+1,tgtHostPort.length);
						Ext.getCmp('hostTrgt'+cnt).setValue(oriStr+hst);
						Ext.getCmp('portTrgt'+cnt).setValue(prt);
					}else{
						Ext.getCmp('hostTrgt'+cnt).setValue(oriStr+httpsStr);
						Ext.getCmp('portTrgt'+cnt).setValue("");
					}
				}else if(tgtHostPort.indexOf("http://")!=-1 || tgtHostPort.indexOf("http:\\")!=-1){
					var oriStr1=tgtHostPort.substring(0,7);
					var httpStr=tgtHostPort.substring(7);
					if(httpStr.indexOf(':')!=-1){
						var hst=httpStr.substring(0,httpStr.indexOf(':'));
    					var prt=httpStr.substring(httpStr.indexOf(':')+1,tgtHostPort.length);
						Ext.getCmp('hostTrgt'+cnt).setValue(oriStr1+hst);
						Ext.getCmp('portTrgt'+cnt).setValue(prt);
					}else{
						Ext.getCmp('hostTrgt'+cnt).setValue(oriStr1+httpStr);
						Ext.getCmp('portTrgt'+cnt).setValue("");
					}
				}else if(tgtHostPort.indexOf(':')!=-1){
					var hst1=tgtHostPort.substring(0,tgtHostPort.indexOf(':'));
    				var prt1=tgtHostPort.substring(tgtHostPort.indexOf(':')+1,tgtHostPort.length);
					Ext.getCmp('hostTrgt'+cnt).setValue(hst1);
					Ext.getCmp('portTrgt'+cnt).setValue(prt1);
				}else{
					Ext.getCmp('hostTrgt'+cnt).setValue(tgtHostPort);
					Ext.getCmp('portTrgt'+cnt).setValue("");
				}
				if(v_systempropkeys!='none'){
					Ext.getCmp('tgtpropsfieldset'+cnt).show();
					var sysPropKey = split_systempropkeys[cnt-1];
					var sysPropVal = split_systempropvalues[cnt-1];

					if(typeof sysPropKey !== 'undefined' && typeof sysPropVal !== 'undefined'){
						var keysArr = sysPropKey.split('!@!');
						var valsArr = sysPropVal.split('!@!');
						if (keysArr != null && keysArr.length > 0)
						{
							for (var ip =1;ip<keysArr.length;ip++ )
							{
								addTrgtPropsContainerWithValue('tgtPropsContainer_'+cnt+'_'+(ip+1));
							}
							for (var inc = 0;inc<keysArr.length ;inc++ )
							{
								Ext.getCmp('tgtpropkey_'+cnt+'_'+(inc+1)).setValue(keysArr[inc]);
								var dispValue = valsArr[inc];
								if (dispValue.indexOf("~#~") != -1)
								{
									dispValue = dispValue.replace(/~#~/g,',');
								}
								Ext.getCmp('tgtpropval_'+cnt+'_'+(inc+1)).setValue(dispValue);
							}
						}
					}
				}
			}
			Ext.resumeLayouts(true);
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=EgConfigureTargetsAndSysProps',
			method: 'POST',
			async: false
		});
	},

	updateTargetUrl: function() {

		var hostAndPort = "";
		var multiSystemPropKey= "";
		var multiSystemPropValue= "";
		var trgtInputs = inputsTrgtUrl;
		for (var m=1;m<trgtInputs;m++)
		{
			if (Ext.getCmp('hostTrgt'+m) == undefined)
			{
				continue;
			}

			var v_tgtHost = Ext.getCmp('hostTrgt'+m).getValue();
			var v_tgtPort = Ext.getCmp('portTrgt'+m).getValue();
			if (v_tgtHost == null || v_tgtPort == null) 
			{
				continue;
			}
			if (v_tgtHost.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigTgt,
					msg: 'Please enter a valid host',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('hostTrgt'+m).focus(true);
					}
				});
				return;
			}
			if (v_tgtPort.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigTgt,
					msg: 'Please enter a valid port',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('portTrgt'+m).focus(true);
					}
				});
				return;
			}

			var v_systempropvalue='';
			var v_systempropkey='';

			var inputSysPropsCont = Ext.getCmp('tgtPropsMainContainer'+m);
			var inputSysPropsCount = inputSysPropsCont.items.getCount();
			if (inputSysPropsCount > 0)
			{
				for (var it=0;it<inputSysPropsCount ;it++ )
				{
					v_systempropkey = Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).getValue();
					v_systempropvalue = Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).getValue();
					if (!checkblank(v_systempropkey))
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: enterSystemPropKey,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(v_systempropkey,"@*+=|:;\"\'<>\/[]?,!"))
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (v_systempropkey.indexOf("  ") > -1)
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: _checkSpaces,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (v_systempropkey.indexOf("$unconfigured") > -1)
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg:'Please enter value for system property',
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					if (!checkblank(v_systempropvalue))
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: enterSystemPropValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(v_systempropvalue,"~#@*+=|:;\"\'<>\/[]?"))
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (v_systempropvalue.indexOf("  ") > -1)
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: _checkSpaces,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
					else if (v_systempropvalue.indexOf("$unconfigured") > -1)
					{
						Ext.Msg.show({
							title: alertconfigTgt,
							msg: 'Please enter value for system property value',
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).focus(true,true);
							}
						});
						return;
					}
				}
			}		

			if(v_tgtPort!=null && v_tgtPort!=''){
				hostAndPort = hostAndPort + "," + v_tgtHost + ":" + v_tgtPort;
			}else{
				hostAndPort = hostAndPort + "," + v_tgtHost;
			}

			var inputPattCont = Ext.getCmp('tgtPropsMainContainer'+m);
			var inputPattCount = inputPattCont.items.getCount();
			var otherkeyPatterns = '';
			var othervalPatterns = '';
			if (inputPattCount > 0)
			{
				for (var it=0;it<inputPattCount ;it++ )
				{
					otherkeyPatterns += Ext.getCmp('tgtpropkey_'+m+'_'+(it+1)).getValue() +"!@!";
					othervalPatterns += Ext.getCmp('tgtpropval_'+m+'_'+(it+1)).getValue() +"!@!";
				}
			}
			if (!Ext.isEmpty(otherkeyPatterns))
			{
				otherkeyPatterns = otherkeyPatterns.substring(0,otherkeyPatterns.length -3);
				othervalPatterns = othervalPatterns.substring(0,othervalPatterns.length -3);
			}
			multiSystemPropKey = multiSystemPropKey + "," + otherkeyPatterns ;
			var sysPropVal = othervalPatterns;
			if (sysPropVal.indexOf(",") != -1)
			{
				sysPropVal = sysPropVal.replace(/,/g,'~#~');
			}
			multiSystemPropValue = multiSystemPropValue + "," + sysPropVal ;
		}
		hostAndPort = hostAndPort.substring(1);
		multiSystemPropKey = multiSystemPropKey.substring(1);
		multiSystemPropValue = multiSystemPropValue.substring(1);

		Ext.getCmp('systempropskey').setValue(multiSystemPropKey);
		Ext.getCmp('systempropsvalue').setValue(multiSystemPropValue);
		Ext.getCmp('targets').setValue(hostAndPort);
		Ext.getCmp('EgConfigureTargetsAndSysProps').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'+&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	clearTargetUrl: function(btn) 
	{
		var tgtcredcontainer = Ext.getCmp('targeturlcontainer');
		tgtcredcontainer.removeAll();
		Ext.getCmp('addTgtUrlbtn').setText('Add');
		Ext.getCmp('NoTrgtUrlPattern').show();
		if (Ext.getCmp('contrgt_1') != null || Ext.getCmp('contrgt_1') != undefined)
		{
			istrgt = 'true';
			Ext.getCmp('contrgt_1').removeAll();
			Ext.getCmp('contrgt_1').hide();
		}
		Ext.getCmp('updateTgtUrl').disable();
		Ext.getCmp('clearTgtUrl').disable();
	},

	//Targtes - end

	configCerdentialurls: function(btn) 
	{ // Credentials Url
		Ext.create('SpecificTestConfiguration.view.EgConfigureUrlAndCredentials').show();

		var creddom = '';
		inputsCredUrl = 2;
		BTNamingSegmentCount = 2;
		iscred = 'false';
		var isHiddenUrls = publicJson['isHiddenUrls'];

		var ValueCredUrl = Ext.getCmp('url').getValue();
		var ValueHiddenCredUrl = decodeURIComponent(Ext.getCmp('hiddenURLs').getValue());
		var ValueCredentials = Ext.getCmp('credentials').getValue();
		var ValueCredContent = Ext.getCmp('content').getValue();
		var ValueCredEncode = Ext.getCmp('encoding').getValue();
		var v_fileValues = '';
		var v_systempropkeys = '';
		var v_systempropvalues = '';

		if (!Ext.isEmpty(ValueHiddenCredUrl))
		{
			isHiddenUrls = true;
		}
		var getPrivateKeyParamExist = publicJson['isPrivateKeyParamExist'];
		if (getPrivateKeyParamExist == true)
		{
			v_fileValues = Ext.getCmp('privateKey').getValue();
		}
		
		var getSystemPropKeyParamExist = publicJson['isSystemPropKeyParamExist'];
		if (getSystemPropKeyParamExist == true)
		{
			v_systempropkeys = Ext.getCmp('systempropertykey').getValue();
			v_systempropvalues = Ext.getCmp('systempropertyvalue').getValue();
		}

		var splitUsrDomain = ValueCredUrl.split(",");
		var splitHiddenUsrDomain = '';
		if (isHiddenUrls)
		{
			splitHiddenUsrDomain = ValueHiddenCredUrl.split("|");
		}
		var splitCredentials = ValueCredentials.split(",");
		var splitCredContent = ValueCredContent.split(",");
		var splitCredEncode = ValueCredEncode.split(",");
		var splitFileVal = '';
		var splitSysPropKey = '';
		var splitSysPropVal = '';
		if (v_fileValues != '$unconfigured')
		{
			splitFileVal = v_fileValues.split(",");
		}
		
		if (v_systempropkeys != '$unconfigured')
		{
			splitSysPropKey = v_systempropkeys.split(",");
		}

		if (v_systempropvalues != '$unconfigured')
		{
			splitSysPropVal = v_systempropvalues.split(",");
		}

		var splitUrlNme = '';
		var splitUrlValue = '';
		var splitCredUnme = '';
		var splitCredPass = '';
		var splitContNme = '';
		var splitContVal = '';
		var splitFileKey = '';
		var splitFilePwd = '';

		if (ValueCredUrl != null || ValueCredUrl != undefined)
		{
			Ext.suspendLayouts();
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addCredUrlContact();
			}
			for (creddom=1;creddom<splitUsrDomain.length+1;creddom++)
			{

				if (isHiddenUrls)
				{
					splitUrlNme = splitUsrDomain[creddom-1]; //splitUsrDomain[creddom-1].substring(0,splitUsrDomain[creddom-1].indexOf(":"));
					var encodeSplitUrlName = splitHiddenUsrDomain[creddom-1].substring(0,splitHiddenUsrDomain[creddom-1].indexOf(":"));
					if (encodeSplitUrlName == splitUrlNme)
					{
						splitUrlValue = splitHiddenUsrDomain[creddom-1].substring(splitHiddenUsrDomain[creddom-1].indexOf(":")+1);
					}
				}
				else
				{
					splitUrlNme = splitUsrDomain[creddom-1].substring(0,splitUsrDomain[creddom-1].indexOf(":"));
					splitUrlValue = splitUsrDomain[creddom-1].substring(splitUsrDomain[creddom-1].indexOf(":")+1);
				}

				splitCredUnme = splitCredentials[creddom-1].substring(0,splitCredentials[creddom-1].indexOf(":"));
				splitCredPass = splitCredentials[creddom-1].substring(splitCredentials[creddom-1].indexOf(":")+1);

				splitContNme = splitCredContent[creddom-1].substring(0,splitCredContent[creddom-1].indexOf(":"));
				splitContVal = splitCredContent[creddom-1].substring(splitCredContent[creddom-1].indexOf(":")+1);

				if (Ext.getCmp('nameCred'+creddom) == undefined)
				{
					continue;
				}
				Ext.getCmp('nameCred'+creddom).setValue(splitUrlNme);
				Ext.getCmp('urlCred'+creddom).setValue(splitUrlValue);
				Ext.getCmp('usrnameCred'+creddom).setValue(splitCredUnme);
				Ext.getCmp('pwdCred'+creddom).setValue(splitCredPass);
				Ext.getCmp('pwdCred'+creddom).backupValue = splitCredPass;
				if (splitContNme == "Inc")
				{
					Ext.getCmp('contentCred'+creddom).setValue("Inc");
				}
				else if (splitContNme == "Exc")
				{
					Ext.getCmp('contentCred'+creddom).setValue("Exc");
				}
				else
				{
					Ext.getCmp('contentCred'+creddom).setValue("none");
				}
				Ext.getCmp('subcontentCred'+creddom).setValue(splitContVal);
				Ext.getCmp('encodeCred'+creddom).setValue(splitCredEncode[creddom-1]);

				if (getPrivateKeyParamExist == true)
				{
					Ext.getCmp('privateKey'+creddom).show();
					Ext.getCmp('passKey'+creddom).show();

					splitFileKey = splitFileVal[creddom-1].substring(0,splitFileVal[creddom-1].indexOf("#~~#"));
					splitFilePwd = splitFileVal[creddom-1].substring(splitFileVal[creddom-1].indexOf("#~~#")+4);
					Ext.getCmp('privateKey'+creddom).setValue(splitFileKey);
					Ext.getCmp('passKey'+creddom).setValue(splitFilePwd);
					Ext.getCmp('passKey'+creddom).backupValue = splitFilePwd;
				}
				
				if (getSystemPropKeyParamExist == true)
				{
					Ext.getCmp('syspropsfieldset'+creddom).show();
					var sysPropKey = splitSysPropKey[creddom-1];
					var sysPropVal = splitSysPropVal[creddom-1];
					var keysArr = sysPropKey.split('!@!');
					var valsArr = sysPropVal.split('!@!');
					if (keysArr != null && keysArr.length > 0)
					{
						for (var ip =1;ip<keysArr.length;ip++ )
						{
							addSysPropsContainerWithValue('sysPropsContainer_'+creddom+'_'+(ip+1));
						}

						for (var inc = 0;inc<keysArr.length ;inc++ )
						{
							Ext.getCmp('syspropkey_'+creddom+'_'+(inc+1)).setValue(keysArr[inc]);
							var dispValue = valsArr[inc];
							if (dispValue.indexOf("~#~") != -1)
							{
								dispValue = dispValue.replace(/~#~/g,',');
							}
							Ext.getCmp('syspropval_'+creddom+'_'+(inc+1)).setValue(dispValue);
						}
					}

					//Ext.getCmp('systempropertykey'+creddom).show();
					//Ext.getCmp('systempropertyvalue'+creddom).show();
					//Ext.getCmp('systempropertykey'+creddom).setValue(splitSysPropKey[creddom-1]);
					//if (sysPropVal.indexOf("~#~") != -1)
					//{
						//sysPropVal = sysPropVal.replace(/~#~/g,',');
					//}
					//Ext.getCmp('systempropertyvalue'+creddom).setValue(sysPropVal);
				}
			}
			Ext.resumeLayouts(true);
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigureurlandcredentials',
			method: 'POST',
			async: false
		});
	},
	clearCredUrl: function(btn) 
	{
		var urlcredcontainer = Ext.getCmp('credurlcontainer');
		urlcredcontainer.removeAll();
		Ext.getCmp('addCredUrlbtn').setText('Add');
		Ext.getCmp('NoCredUrlPattern').show();
		if (Ext.getCmp('concred_1') != null || Ext.getCmp('concred_1') != undefined)
		{
			iscred = 'true';
			Ext.getCmp('concred_1').removeAll();
			Ext.getCmp('concred_1').hide();
		}
		Ext.getCmp('updateCredUrl').disable();
		Ext.getCmp('clearCredUrl').disable();
	},
	updateCredUrl: function() {
		var isPrivateKeyParamExist = publicJson['isPrivateKeyParamExist'];
		var isSystemPropKeyParamExist = publicJson['isSystemPropKeyParamExist'];
		var isHiddenUrls = publicJson['isHiddenUrls'];
		var urlNames = "";
		var hiddenUrls = "";
		var urls = "";
		var multiUsrAndPwd = "";
		var multiContents = "";
		var multiEncodings = "";
		var multiFilePath= "";
		var multiSystemPropKey= "";
		var multiSystemPropValue= "";
		var arrURLNames = new Array();
		var isvalidUrl = false;
		var isvalidVal = false;
		var isvalidUname = false;
		var isvalidPass = false;
		var isvalidContent = false;
		var isvalidEncod = false;
		var urlDisp = '';

		var credInputs = inputsCredUrl;

		for (var m=1;m<credInputs;m++)
		{
			if (Ext.getCmp('nameCred'+m) == undefined)
			{
				continue;
			}
			var v_urlname = Ext.getCmp('nameCred'+m).getValue();
			var v_urlvalue = Ext.getCmp('urlCred'+m).getValue();
			var v_username = Ext.getCmp('usrnameCred'+m).getValue();
			var v_password = Ext.getCmp('pwdCred'+m).getValue();
			var v_contentname = Ext.getCmp('contentCred'+m).getValue();
			var v_contentvalue = Ext.getCmp('subcontentCred'+m).getValue();
			var v_encoding = Ext.getCmp('encodeCred'+m).getValue();
			var v_filepath='';
			var v_filepassword='';
			var v_systempropvalue='';
			var v_systempropkey='';
			if(isPrivateKeyParamExist == true)
			{
				v_filepath = Ext.getCmp('privateKey'+m).getValue();
				v_filepassword = Ext.getCmp('passKey'+m).getValue();
			}
			
			//if(isSystemPropKeyParamExist == true)
			//{
				//v_systempropkey = Ext.getCmp('systempropertykey'+m).getValue();
				//v_systempropvalue = Ext.getCmp('systempropertyvalue'+m).getValue();
			//}

			if (v_urlname == null || v_urlvalue == null || v_username == null ||
				v_password == null || v_contentname == null || v_contentvalue == null || v_encoding == null || v_filepath == null || v_filepassword==null ) //|| v_systempropkey == null || v_systempropvalue==null)
			{
				continue;
			}

			var x_idx = arrURLNames.indexOf(v_urlname);
			if (x_idx != -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: duplicateNtAlwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameCred'+m).focus(true);
					}
				});
				return;
			}
			arrURLNames[m] = v_urlname;

			//URL name
			if (v_urlname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_urlname))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: entName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialExt(v_urlname,"@*+=|:;\"\'<>[]?,"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('nameCred'+m).focus(true,true);
					}
				});
				//Ext.getCmp('nameCred'+m).focus(true);
				return;
			}
			else if (v_urlname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_urlname,v_urlname))
			{
				Ext.getCmp('nameCred'+m).focus();
				return;
			}
			else
			{
				isvalidUrl = true;
			}

			//URL value
			if (v_urlvalue.indexOf("$hostIp") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlCred'+m).focus(true);
					}
				});
				return;
			}
			else if (v_urlvalue.indexOf("$portNo") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlCred'+m).focus(true);
					}
				});
				return;
			}
			else if (v_urlvalue.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_urlvalue))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlCred'+m).focus(true);
					}
				});
				return;
			}
			//else if (!checkspecialnomess(v_urlvalue,",|\"'"))
			else if (!checkspecialnomess(v_urlvalue,"|\"'"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_urlvalue,v_urlvalue))
			{
				Ext.getCmp('urlCred'+m).focus();
				return;
			}
			else
			{
				isvalidVal = true;
			}

			//Username
			if (!checkblank(v_username))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterUsr,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialExt(v_username,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('usrnameCred'+m).focus(true,true);
					}
				});
				return;
			}
			else if (v_username.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (v_username.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_username,v_username))
			{
				Ext.getCmp('usrnameCred'+m).focus();
				return;
			}
			else
			{
				isvalidUname = true;
			}

			//Password
			if (!checkblank(v_password))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdCred'+m).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(v_password,",|"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: PwdNotPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdCred'+m).focus(true);
					}
				});
				return;
			}
			else
			{
				isvalidPass = true;
			}

			//Content value
			if (!checkblank(v_contentvalue))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterContent,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('subcontentCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialExt(v_contentvalue,",|:\"\'<>"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('subcontentCred'+m).focus(true,true);
					}
				});
				return;
			}
			//else if (v_contentvalue.indexOf(" ") > -1)
			//{
				//Ext.Msg.show({
					//title: alertconfigUrl,
					//msg: _spaceMessage,
					//buttons: Ext.Msg.OK,
					//icon: 'iconExclamation',
					//fn: function() {
						//Ext.getCmp('subcontentCred'+m).focus(true);
					//}
				//});
				//return;
			//}
			else if (!checkHyphenText(v_contentvalue,v_contentvalue))
			{
				Ext.getCmp('subcontentCred'+m).focus();
				return;
			}
			else
			{
				isvalidContent = true;
			}

			//Encoding
			if (!checkblank(v_encoding))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterEncoding,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('encodeCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialExt(v_encoding,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('encodeCred'+m).focus(true,true);
					}
				});
				return;
			}
			else if (v_encoding.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('encodeCred'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_encoding,v_encoding))
			{
				Ext.getCmp('encodeCred'+m).focus();
				return;
			}
			else
			{
				isvalidEncod = true;
			}


			if (isSystemPropKeyParamExist)
			{
				var inputSysPropsCont = Ext.getCmp('sysPropsMainContainer'+m);
				var inputSysPropsCount = inputSysPropsCont.items.getCount();
				if (inputSysPropsCount > 0)
				{
					for (var it=0;it<inputSysPropsCount ;it++ )
					{
						v_systempropkey = Ext.getCmp('syspropkey_'+m+'_'+(it+1)).getValue();
						v_systempropvalue = Ext.getCmp('syspropval_'+m+'_'+(it+1)).getValue();

						if (!checkblank(v_systempropkey))
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: enterSystemPropKey,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('syspropkey_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
						else if (!checkspecialExt(v_systempropkey,"@*+=|:;\"\'<>\/[]?,!"))
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: _checkspecial,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function()
								{
									Ext.getCmp('syspropkey_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
						else if (v_systempropkey.indexOf("  ") > -1)
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: _checkSpaces,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('syspropkey_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
						if (!checkblank(v_systempropvalue))
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: enterSystemPropValue,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('syspropval_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
						else if (!checkspecialExt(v_systempropvalue,"~#@*+=|:;\"\'<>\/[]?"))
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: _checkspecial,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function()
								{
									Ext.getCmp('syspropval_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
						else if (v_systempropvalue.indexOf("  ") > -1)
						{
							Ext.Msg.show({
								title: alertconfigUrl,
								msg: _checkSpaces,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('syspropval_'+m+'_'+(it+1)).focus(true,true);
								}
							});
							return;
						}
					}
				}
				//Encoding
				
			}
			//File path
			if(isPrivateKeyParamExist == true)
			{
				if (v_filepath.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertconfigUrl,
						msg: enterValidPath,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('privateKey'+m).focus(true);
						}
					});
					return;
				}
				else if (!checkblank(v_filepath))
				{
					Ext.Msg.show({
						title: alertconfigUrl,
						msg: enterFilePath,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('privateKey'+m).focus(true);
						}
					});
					return;
				}
				else if (v_filepath.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertconfigUrl,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('privateKey'+m).focus(true);
						}
					});
					return;
				}

				//File password
				if (!checkblank(v_filepassword))
				{
					Ext.Msg.show({
						title: alertconfigUrl,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('passKey'+m).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(v_filepassword,",|"))
				{
					Ext.Msg.show({
						title: alertconfigUrl,
						msg: PwdNotPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('passKey'+m).focus(true);
						}
					});
					return;
				}
			}

			urlNames = urlNames + "," + v_urlname;
			urls = urls + "," + v_urlname + ":" + v_urlvalue;
			hiddenUrls = hiddenUrls + "|" + v_urlname + ":" + v_urlvalue;
			multiUsrAndPwd = multiUsrAndPwd + "," + v_username + ":" + v_password;
			multiContents = multiContents + "," + v_contentname + ":" + v_contentvalue ;
			multiEncodings = multiEncodings + "," + v_encoding;
			if(isPrivateKeyParamExist == true)
			{
				multiFilePath = multiFilePath + "," + v_filepath + "#~~#" + v_filepassword;
			}
			
			if(isSystemPropKeyParamExist == true)
			{
				var inputPattCont = Ext.getCmp('sysPropsMainContainer'+m);
				var inputPattCount = inputPattCont.items.getCount();
				var otherkeyPatterns = '';
				var othervalPatterns = '';
				if (inputPattCount > 0)
				{
					for (var it=0;it<inputPattCount ;it++ )
					{
						otherkeyPatterns += Ext.getCmp('syspropkey_'+m+'_'+(it+1)).getValue() +"!@!";
						othervalPatterns += Ext.getCmp('syspropval_'+m+'_'+(it+1)).getValue() +"!@!";
					}
				}

				if (!Ext.isEmpty(otherkeyPatterns))
				{
					otherkeyPatterns = otherkeyPatterns.substring(0,otherkeyPatterns.length -3);
					othervalPatterns = othervalPatterns.substring(0,othervalPatterns.length -3);
				}

				multiSystemPropKey = multiSystemPropKey + "," + otherkeyPatterns ;
				var sysPropVal = othervalPatterns;
				if (sysPropVal.indexOf(",") != -1)
				{
					sysPropVal = sysPropVal.replace(/,/g,'~#~');
				}
				multiSystemPropValue = multiSystemPropValue + "," + sysPropVal ;

				//multiSystemPropKey = multiSystemPropKey + "," + v_systempropkey ;
				//var sysPropVal = v_systempropvalue;
				//if (sysPropVal.indexOf(",") != -1)
				//{
					//sysPropVal = sysPropVal.replace(/,/g,'~#~');
				//}
				//multiSystemPropValue = multiSystemPropValue + "," + sysPropVal ;
			}
		}

		urlNames = urlNames.substring(1);
		urls = urls.substring(1);
		hiddenUrls = hiddenUrls.substring(1);
		multiUsrAndPwd = multiUsrAndPwd.substring(1);
		multiContents = multiContents.substring(1);
		multiEncodings = multiEncodings.substring(1);
		if(isPrivateKeyParamExist == true)
		{
			multiFilePath = multiFilePath.substring(1);
			Ext.getCmp('privateKey').setValue(multiFilePath);
		}
	
		if(isSystemPropKeyParamExist == true)
		{
			multiSystemPropKey = multiSystemPropKey.substring(1);
			multiSystemPropValue = multiSystemPropValue.substring(1);
			Ext.getCmp('systempropertykey').setValue(multiSystemPropKey);
			Ext.getCmp('systempropertyvalue').setValue(multiSystemPropValue);
		}

		if (isHiddenUrls)
		{
			Ext.getCmp('url').setValue(urlNames);
			Ext.getCmp('hiddenURLs').setValue(hiddenUrls);
		}
		else
		{
			Ext.getCmp('url').setValue(urls);
		}
		//Ext.getCmp('url').setValue(urlNames);
		//Ext.getCmp('hiddenURLs').setValue(urls);
		Ext.getCmp('credentials').setValue(multiUsrAndPwd);
		Ext.getCmp('content').setValue(multiContents);
		Ext.getCmp('encoding').setValue(multiEncodings);

		Ext.getCmp('egconfigureurlandcredentials').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'+&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	configurlnamepatterns: function(btn) {  //url name
		Ext.create('SpecificTestConfiguration.view.EgConfigureNamePattern').show();

		var urlnme = '';
		inputsUrlNme = 2;
		isNamePtn = 'false';

		var ValueName = Ext.getCmp('name').getValue();
		var ValuePattern = Ext.getCmp('pattern').getValue();
		var ValueThreshold = Ext.getCmp('threshold_value').getValue();

		var splitName = ValueName.split(",");
		var splitPattern = ValuePattern.split(",");
		var splitThreshold = ValueThreshold.split(",");

		if (splitName != null || splitName != undefined)
		{
			for (var k =0;k<splitName.length-1;k++ )
			{
				addUrlNameContact();
			}
			for (urlnme=1;urlnme<splitName.length+1;urlnme++)
			{
				if (Ext.getCmp('nameurl'+urlnme) == undefined)
				{
					continue;
				}
				Ext.getCmp('nameurl'+urlnme).setValue(splitName[urlnme-1]);
				Ext.getCmp('patternurl'+urlnme).setValue(splitPattern[urlnme-1]);
				Ext.getCmp('thresholdurl'+urlnme).setValue(splitThreshold[urlnme-1]);
			}
		}

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=winservicesconfiguration',
			method: 'POST',
			async: false
		});
	},
	clearUrlName: function(btn) {
		var urlpatterncontainer = Ext.getCmp('urlpatterncontainer');
		urlpatterncontainer.removeAll();
		Ext.getCmp('addUrlNamebtn').setText('Add');
		Ext.getCmp('NoUrlPattern').show();
		if (Ext.getCmp('con_1') !=null || Ext.getCmp('con_1') != undefined)
		{
			isNamePtn = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateUrlPattern').disable();
		Ext.getCmp('clearUrlPattern').disable();
	},
	updateUrlName: function(btn) {
		var regNum = /^([0-9]+\.|\.)?[0-9]+$/gi;
		var regSpace = /\s/gi;
		var regColon = /(;)$/gi
		var urlname = "";
		var urlPattern = "";
		var urlthresh = "";
		var multiUrlName = "";
		var multiUrlPattern  = "";
		var multiThresh = "";
		var rdCnt = 0;
		var urlinputs = inputsUrlNme;

		for(var j=1; j<urlinputs; j++)
		{
			if (Ext.getCmp('nameurl'+j) == undefined)
			{
				continue;
			}
			multiUrlName = Ext.getCmp('nameurl'+j).getValue();
			multiUrlPattern = Ext.getCmp('patternurl'+j).getValue();
			multiThresh = Ext.getCmp('thresholdurl'+j).getValue();

			// URL NAME STARTS
			if(multiUrlName == null) continue;
			if(multiUrlName!=null)
			{
				rdCnt++;
				if(!checkblank(multiUrlName) || (multiUrlName == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: enterName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('nameurl'+j).focus(true);
						}
					});
					return;
				}
				else if (!nonNumeric(multiUrlName))
				{
					Ext.getCmp('nameurl'+j).focus();
					return;
				}
				else if(!checkspace(multiUrlName))
				{
					Ext.getCmp('nameurl'+j).focus();
					return;
				}
				else if ((multiUrlName).indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('nameurl'+j).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUrlName,multiUrlName))
				{
					Ext.getCmp('nameurl'+j).focus();
					return;
				}
				else if(!checkspecial(multiUrlName,"$@*.+=|:;\"\'<>\/[]?,\\&"))
				{
					Ext.getCmp('nameurl'+j).focus();
					return;
				}

				var subStrUrl = urlname.substring(urlname.lastIndexOf((","+multiUrlName))) // Substring from last index to length of the string (default)
				if((subStrUrl  == (","+multiUrlName)) || (urlname.indexOf((","+multiUrlName)+",") != -1 ) )
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _uniqueName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('nameurl'+j).focus(true);
						}
					});
					return;
				}
			}// end url name

			// PATTERN NAME STARTS
			if(multiUrlPattern !=null)
			{
				if(!checkblank(multiUrlPattern) || (multiUrlPattern == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: enterPattern,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('patternurl'+j).focus(true);
						}
					});
					return;
				}
				else if (!nonNumeric(multiUrlPattern))
				{
					Ext.getCmp('patternurl'+j).focus();
					return;
				}
				else if(!checkspecial(multiUrlPattern,"$@+|:\"\'<>[]-,"))
				{
					Ext.getCmp('patternurl'+j).focus();
					return;
				}
				else if(!checkspace(multiUrlPattern))
				{
					Ext.getCmp('patternurl'+j).focus();
					return;
				}
				else if (trim(multiUrlPattern) == "")
				{
					Ext.getCmp('patternurl'+j).focus();
					return;
				}
				else if (multiUrlPattern.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('patternurl'+j).focus(true);
						}
					});
					return;
				}
				else if (multiUrlPattern.indexOf(";;") > -1)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _checkSemicolons,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('patternurl'+j).focus(true);
						}
					});
					return;
				}
				else if (multiUrlPattern.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('patternurl'+j).focus(true);
						}
					});
					return;
				}
				else if(multiUrlPattern.match(regColon) != null)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _invalidPattern,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('patternurl'+j).focus(true);
						}
					});
					return;
				}
			}// end pattern name

			// THRESH NAME STARTS
			if(multiThresh !=null)
			{
				if(!checkblank(multiThresh)  || (multiThresh == "$unconfigured") )
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: enterThresh,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('thresholdurl'+j).focus(true);
						}
					});
					return;
				}
				else if(!checkspace(multiThresh))
				{
					Ext.getCmp('thresholdurl'+j).focus();
					return;
				}
				else if(multiThresh.match(regNum) == null)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _numeralsOnly,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('thresholdurl'+j).focus(true);
						}
					});
					return;
				}
				else if(!checkspecial(multiThresh,"@$*+=|:;\"\'<>\/[]?,"))
				{
					Ext.getCmp('thresholdurl'+j).focus();
					return;
				}
				else if (trim(multiThresh) == "")
				{
					Ext.getCmp('thresholdurl'+j).focus();
					return;
				}
				else if(!checkHyphenText(multiThresh,multiThresh))
				{
					Ext.getCmp('thresholdurl'+j).focus();
					return;
				}
				else if (multiThresh.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertNameTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('thresholdurl'+j).focus(true);
						}
					});
					return;
				}
			}// end threshold

			if(rdCnt > 1)
			{
				Ext.getCmp('name').setReadOnly(true);
				Ext.getCmp('pattern').setReadOnly(true);
				Ext.getCmp('threshold_value').setReadOnly(true);
			}

			urlname = urlname +","+multiUrlName;
			urlPattern = urlPattern +","+multiUrlPattern;
			urlthresh = urlthresh +","+multiThresh;
		}

		if(rdCnt <= 1)
		{
			Ext.getCmp('name').setReadOnly(false);
			Ext.getCmp('pattern').setReadOnly(false);
			Ext.getCmp('threshold_value').setReadOnly(false);
		}

		urlname = urlname.replace(",","");
		urlPattern = urlPattern.replace(",","");
		urlthresh = urlthresh.replace(",","");

		Ext.getCmp('name').setValue(urlname);
		Ext.getCmp('pattern').setValue(urlPattern);
		Ext.getCmp('threshold_value').setValue(urlthresh);
		Ext.getCmp('egconfigurenamepattern').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	}, //url name

	configWindowShareds: function(btn) { //Window shared folders
		Ext.create('SpecificTestConfiguration.view.EgConfigureWinSharedFolders').show();

		var winshrd = '';
		inputWinShared = 2;
		noWinConfig = 'false';

		var ValueShrName = Ext.getCmp('sharename').getValue();
		var ValueShrDom = Ext.getCmp('domainname').getValue();
		var ValueShrUsrName = Ext.getCmp('shareusername').getValue();
		var ValueShrPass = Ext.getCmp('password').getValue();

		var splitShrName = ValueShrName.split(",");
		var splitShrDom = ValueShrDom.split(",");
		var splitShrUsrName = ValueShrUsrName.split(",");
		var splitShrPass = ValueShrPass.split("#~#");

		var splitDispNme = '';
		var ShrNme = '';
		var ShrDom = '';
		var ShrUsrDom = '';
		var ShrUsrPass = '';

		if (splitShrName != null || splitShrName != undefined)
		{
			for (var k =0;k<splitShrName.length-1;k++ )
			{
				addWinSharedContact();
			}
			for (winshrd=1;winshrd<splitShrName.length+1;winshrd++)
			{
				splitDispNme = splitShrName[winshrd-1].substring(0,splitShrName[winshrd-1].indexOf("@"));
				ShrNme = splitShrName[winshrd-1].substring(splitShrName[winshrd-1].indexOf("@")+1);
				ShrDom = splitShrDom[winshrd-1].substring(splitShrDom[winshrd-1].indexOf("@")+1);
				ShrUsrDom = splitShrUsrName[winshrd-1].substring(splitShrUsrName[winshrd-1].indexOf("@")+1);
				ShrUsrPass = splitShrPass[winshrd-1].substring(splitShrPass[winshrd-1].indexOf("@")+1);

				if (Ext.getCmp('displayNme'+winshrd) == undefined)
				{
					continue;
				}
				if (ValueShrName == "$unconfigured")
				{
					Ext.getCmp('displayNme'+winshrd).setValue('$unconfigured');
				}
				else
				{
					Ext.getCmp('displayNme'+winshrd).setValue(splitDispNme);
				}
				Ext.getCmp('shareNme'+winshrd).setValue(ShrNme);
				Ext.getCmp('domainNme'+winshrd).setValue(ShrDom);
				Ext.getCmp('userNme'+winshrd).setValue(ShrUsrDom);
				Ext.getCmp('pwdNme'+winshrd).setValue(ShrUsrPass);
				Ext.getCmp('confPwdNme'+winshrd).setValue(ShrUsrPass);
				Ext.getCmp('pwdNme'+winshrd).backupValue = ShrUsrPass;
				Ext.getCmp('confPwdNme'+winshrd).backupValue = ShrUsrPass;
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigurewinsharedfolders',
			method: 'POST',
			async: false
		});
	},
	clearWinShared: function(btn) {
		var winsharedcontainer = Ext.getCmp('winsharedcontainer');
		winsharedcontainer.removeAll();
		if (Ext.getCmp('con_win1') != null || Ext.getCmp('con_win1') != undefined)
		{
			noWinConfig = 'true';
			Ext.getCmp('con_win1').removeAll();
			Ext.getCmp('con_win1').hide();
		}
		Ext.getCmp('addwinsharedbtn').setText('Add');
		Ext.getCmp('NoWinSharedPattern').show();
		Ext.getCmp('updateWinShared').disable();
		Ext.getCmp('clearWinShared').disable();
	},
	updateWinShared: function(btn) {
		var sharenames = "";
		var domainnames = "";
		var shareusernames = "";
		var passwords = "";
		var arrDisplayNames = new Array();
		var winInputs = inputWinShared;

		for(var k=1; k<winInputs; k++)
		{
			if (Ext.getCmp('displayNme'+k) == undefined)
			{
				continue;
			}
			var v_sharename = Ext.getCmp('displayNme'+k).getValue();
			var v_sharevalue = Ext.getCmp('shareNme'+k).getValue();
			var v_domainname = Ext.getCmp('domainNme'+k).getValue();
			var v_username = Ext.getCmp('userNme'+k).getValue();
			var v_password = Ext.getCmp('pwdNme'+k).getValue();
			var v_confirmpwd = Ext.getCmp('confPwdNme'+k).getValue();

			if (v_sharename == null || v_sharevalue == null || v_domainname == null ||
				v_username == null || v_password == null || v_confirmpwd == null)
			{
				continue;
			}

			var x_idx = arrDisplayNames.indexOf(v_sharename);
			if (x_idx != -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: duplicateDisp,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('displayNme'+k).focus(true);
					}
				});
				return;
			}
			arrDisplayNames[k] = v_sharename;

			//Display name
			if (v_sharename.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterValidDisp,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('displayNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_sharename))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterDisp,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('displayNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_sharename,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('displayNme'+k).focus();
				return;
			}
			else if (v_sharename.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('displayNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_sharename,v_sharename))
			{
				Ext.getCmp('displayNme'+k).focus();
				return;
			}

			//Share Name
			if (v_sharevalue.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterValidShare,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('shareNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_sharevalue))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterShare,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('shareNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_sharevalue,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('shareNme'+k).focus();
				return;
			}
			else if (v_sharevalue.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('shareNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_sharevalue,v_sharevalue))
			{
				Ext.getCmp('shareNme'+k).focus();
				return;
			}

			//Domain name
			if (!checkblank(v_domainname))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkDomain(v_domainname,"true"))
			{
				Ext.getCmp('domainNme'+k).focus(true);
				return;
			}
			else if (v_domainname.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_domainname,v_domainname))
			{
				Ext.getCmp('domainNme'+k).focus();
				return;
			}
			else if (v_domainname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainNme'+k).focus(true);
					}
				});
				return;
			}

			//Username
			if (!checkblank(v_username))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterUsr,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('userNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_username.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('userNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_username,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('userNme'+k).focus();
				return;
			}
			else if (v_username.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('userNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_username.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('userNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_username,v_username))
			{
				Ext.getCmp('userNme'+k).focus();
				return;
			}

			//Password
			if (!checkblank(v_password))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_password.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdNme'+k).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialnomess(v_password,",|"))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: PwdNotPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_password.indexOf("#~#") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdNme'+k).focus(true);
					}
				});
				return;
			}

			//Confirm Password
			if (!checkblank(v_confirmpwd))
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confPwdNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_confirmpwd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confPwdNme'+k).focus(true);
					}
				});
				return;
			}
			else if (v_password != v_confirmpwd)
			{
				Ext.Msg.show({
					title: alertWinShared,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confPwdNme'+k).focus(true);
					}
				});
				return;
			}

		sharenames = sharenames + "," + v_sharename + "@" + v_sharevalue;
		domainnames = domainnames + "," + v_sharename + "@" + v_domainname;
		shareusernames = shareusernames + "," + v_sharename + "@" + v_username;
		passwords = passwords + "#~#" + v_sharename + "@" + v_password;
		}
		sharenames = sharenames.substring(1);
		domainnames = domainnames.substring(1);
		shareusernames = shareusernames.substring(1);
		passwords = passwords.substring(3);

		Ext.getCmp('sharename').setValue(sharenames);
		Ext.getCmp('domainname').setValue(domainnames);
		Ext.getCmp('shareusername').setValue(shareusernames);
		Ext.getCmp('password').setValue(passwords);
		//Ext.getCmp('password').backupValue(passwords);

		Ext.getCmp('egconfigurewinsharedfolders').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	}, //win shared ends

	configureWsdlUrls: function() { //Wsdl configure
		Ext.create('SpecificTestConfiguration.view.EgConfigureWsdlUrlAndCredentials').show();

		var wsdldom = '';
		inputsWsdlUrl = 2;
		noWsdl = 'false';

		var ValueWsdlUrl = Ext.getCmp('WSDL_URL').getValue();
		var ValueWsdlCredentials = Ext.getCmp('credentials').getValue();
		var ValueWsdlContent = Ext.getCmp('content').getValue();
		var ValueWsdlEncode = Ext.getCmp('encoding').getValue();

		var splitWsdl = ValueWsdlUrl.split(",");
		var splitWsdlCredentials = ValueWsdlCredentials.split(",");
		var splitWsdlCredContent = ValueWsdlContent.split(",");
		var splitWsdlCredEncode = ValueWsdlEncode.split(",");

		var splitWsdlNme = '';
		var splitWsdlValue = '';
		var splitWsdlUnme = '';
		var splitWsdlPass = '';
		var splitWsdlCont = '';
		var splitWsdlContVal = '';

		if (ValueWsdlUrl != null || ValueWsdlUrl != undefined)
		{
			for (var k =0;k<splitWsdl.length-1;k++ )
			{
				addWsdlUrlContact();
			}
			for (wsdldom=1;wsdldom<splitWsdl.length+1;wsdldom++)
			{
				splitWsdlNme = splitWsdl[wsdldom-1].substring(0,splitWsdl[wsdldom-1].indexOf(":"));
				splitWsdlValue = splitWsdl[wsdldom-1].substring(splitWsdl[wsdldom-1].indexOf(":")+1);

				splitWsdlUnme = splitWsdlCredentials[wsdldom-1].substring(0,splitWsdlCredentials[wsdldom-1].indexOf(":"));
				splitWsdlPass = splitWsdlCredentials[wsdldom-1].substring(splitWsdlCredentials[wsdldom-1].indexOf(":")+1);

				splitWsdlCont = splitWsdlCredContent[wsdldom-1].substring(0,splitWsdlCredContent[wsdldom-1].indexOf(":"));
				splitWsdlContVal = splitWsdlCredContent[wsdldom-1].substring(splitWsdlCredContent[wsdldom-1].indexOf(":")+1);

				if (Ext.getCmp('nameWsdl'+wsdldom) == undefined)
				{
					continue;
				}
				if (splitWsdl == '$unconfigured')
				{
					Ext.getCmp('nameWsdl'+wsdldom).setValue('$unconfigured');
				}
				else
				{
					Ext.getCmp('nameWsdl'+wsdldom).setValue(splitWsdlNme);
				}
				Ext.getCmp('urlWsdl'+wsdldom).setValue(splitWsdlValue);
				Ext.getCmp('usrnameWsdl'+wsdldom).setValue(splitWsdlUnme);
				Ext.getCmp('pwdWsdl'+wsdldom).setValue(splitWsdlPass);
				Ext.getCmp('pwdWsdl'+wsdldom).backupValue = splitWsdlPass;
				if (splitWsdlCont == "Inc")
				{
					Ext.getCmp('contentWsdl'+wsdldom).setValue("Inc");
				}
				else if (splitWsdlCont == "Exc")
				{
					Ext.getCmp('contentWsdl'+wsdldom).setValue("Exc");
				}
				else
				{
					Ext.getCmp('contentWsdl'+wsdldom).setValue("none");
				}
				Ext.getCmp('subcontentWsdl'+wsdldom).setValue(splitWsdlContVal);
				Ext.getCmp('encodeWsdl'+wsdldom).setValue(splitWsdlCredEncode[wsdldom-1]);
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigurewsdlurlandcredentials',
			method: 'POST',
			async: false
		});
	},
	clearWsdlUrl: function(btn) {
		var urlwsdlcontainer = Ext.getCmp('wsdlurlcontainer');
		urlwsdlcontainer.removeAll();
		Ext.getCmp('addWsdlUrlbtn').setText('Add');
		Ext.getCmp('NoWsdlUrlPattern').show();
		if (Ext.getCmp('con_wsdl1') != null || Ext.getCmp('con_wsdl1') != undefined)
		{
			noWsdl = 'true';
			Ext.getCmp('con_wsdl1').removeAll();
			Ext.getCmp('con_wsdl1').hide();
		}
		Ext.getCmp('updateWsdlUrl').disable();
		Ext.getCmp('clearWsdlUrl').disable();
	},
	updateWsdlUrl: function() {
		var urls = "";
		var multiUsrAndPwd = "";
		var multiContents = "";
		var multiEncodings = "";
		var arrURLNames = new Array();
		var wsdlInputs = inputsWsdlUrl;

		for (var m=1;m<wsdlInputs;m++)
		{
			if (Ext.getCmp('nameWsdl'+m) == undefined)
			{
				continue;
			}
			var v_urlname = Ext.getCmp('nameWsdl'+m).getValue();
			var v_urlvalue = Ext.getCmp('urlWsdl'+m).getValue();
			var v_username = Ext.getCmp('usrnameWsdl'+m).getValue();
			var v_password = Ext.getCmp('pwdWsdl'+m).getValue();
			var v_contentname = Ext.getCmp('subcontentWsdl'+m).getValue();
			var v_contentvalue = Ext.getCmp('contentWsdl'+m).getValue();
			var v_encoding = Ext.getCmp('encodeWsdl'+m).getValue();

			if (v_urlname == null || v_urlvalue == null || v_username == null ||
				v_password == null || v_contentname == null || v_contentvalue == null || v_encoding == null)
			{
				continue;
			}

			var x_idx = arrURLNames.indexOf(v_urlname);
			if (x_idx != -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: duplicateNtAlwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameWsdl'+m).focus(true);
					}
				});
				return;
			}
			arrURLNames[m] = v_urlname;

			//URL name
			if (v_urlname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_urlname))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: entName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_urlname,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('nameWsdl'+m).focus();
				return;
			}
			else if (v_urlname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('nameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_urlname,v_urlname))
			{
				Ext.getCmp('nameWsdl'+m).focus();
				return;
			}

			//URL value
			if (v_urlvalue.indexOf("$hostIp") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (v_urlvalue.indexOf("$portNo") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (v_urlvalue.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkblank(v_urlvalue))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecialnomess(v_urlvalue,",|\"'"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: validUrl,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('urlWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_urlvalue,v_urlvalue))
			{
				Ext.getCmp('urlWsdl'+m).focus();
				return;
			}

			//Username
			if (!checkblank(v_username))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterUsr,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (v_username.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (v_username.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usrnameWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_username,v_username))
			{
				Ext.getCmp('usrnameWsdl'+m).focus();
				return;
			}

			//Password
			if (!checkblank(v_password))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(v_password,",|"))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: PwdNotPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdWsdl'+m).focus(true);
					}
				});
				return;
			}

			//Content value
			if (!checkblank(v_contentvalue))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterContent,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('contentWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_contentvalue,",|:\"\'<>"))
			{
				Ext.getCmp('contentWsdl'+m).focus();
				return;
			}
			//else if (v_contentvalue.indexOf(" ") > -1)
			//{
				//Ext.Msg.show({
					//title: alertconfigUrl,
					//msg: _spaceMessage,
					//buttons: Ext.Msg.OK,
					//icon: 'iconExclamation',
					//fn: function() {
						//Ext.getCmp('contentWsdl'+m).focus(true);
					//}
				//});
				//return;
			//}
			else if (!checkHyphenText(v_contentvalue,v_contentvalue))
			{
				Ext.getCmp('contentWsdl'+m).focus();
				return;
			}

			//Encoding
			if (!checkblank(v_encoding))
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: enterEncoding,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('encodeWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(v_encoding,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('encodeWsdl'+m).focus();
				return;
			}
			else if (v_encoding.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertconfigUrl,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('encodeWsdl'+m).focus(true);
					}
				});
				return;
			}
			else if (!checkHyphenText(v_encoding,v_encoding))
			{
				Ext.getCmp('encodeWsdl'+m).focus();
				return;
			}

			urls = urls + "," + v_urlname + ":" + v_urlvalue;
			multiUsrAndPwd = multiUsrAndPwd + "," + v_username + ":" + v_password;
			//multiContents = multiContents + "," + v_contentvalue + ":" + v_contentname;
			multiContents = multiContents + "," + v_contentname + ":" + v_contentvalue ;
			multiEncodings = multiEncodings + "," + v_encoding;
		}

		urls = urls.substring(1);
		multiUsrAndPwd = multiUsrAndPwd.substring(1);
		multiContents = multiContents.substring(1);
		multiEncodings = multiEncodings.substring(1);

		Ext.getCmp('WSDL_URL').setValue(urls).setReadOnly(true);
		Ext.getCmp('credentials').setValue(multiUsrAndPwd);
		Ext.getCmp('content').setValue(multiContents);
		Ext.getCmp('encoding').setValue(multiEncodings);

		Ext.getCmp('egconfigurewsdlurlandcredentials').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},  //configure wsdl ends

	checkspecialnomess: function(field,s_spl) {
		if(typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}

		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				return false;
			}
		}
		return true;
	},
	checkHyphenText: function(paramValue,paramName) {
		var check = true;
		if (paramName == "recordpattern" ||
			paramName == "process" ||
			paramName == "exclude" ||
			paramName == "content" ||
			paramName == "servicename") // No hyphen check
		{
			Ext.Msg.show({
				title: pageName,
				msg: _checkhyphen,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return check;
		}

		if (paramValue.charAt(0)=='-' || paramValue.charAt(paramValue.length-1)=='-')
		{
			Ext.Msg.show({
				title: pageName,
				msg: _checkhyphen,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			check = false;
		}
		else
		{
			for(i =0; i<paramValue.length; i++)
			{
				if (paramValue.charAt(i)=='-')
				{
					if (paramValue.charAt(i+1)==' ' || paramValue.charAt(i-1)==' ')
					{
						Ext.Msg.show({
							title: pageName,
							msg: _valhyphen,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						check = false;
						break;
					}
				}
			}
		}
		return check;
	},

	configEjbss: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigEjb').show();
		var cname = Ext.getCmp('componentName').getValue();
		var server = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];
		this.buildEjbsData(cname,tname);
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigejb',
			method: 'POST',
			async: false
		});
	},
	addNewConfigEjbs: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigEjbsCreation').show();
		var cname = Ext.getCmp('componentName').getValue();
		var server = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigEjbJson.jsp?test='+tname+"&comp="+cname+"&mode=add&server="+server,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicEjbsJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectejb').fromField.store.add(publicEjbsJSON['managedArry']);
				Ext.getCmp('itemselectejb').toField.store.add(publicEjbsJSON['allElementsArry']);
			}
		});
	},
	buildEjbsData: function(cname,tname) {
			Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigEjbJson.jsp?test='+tname+"&comp="+cname,//+"&mode="+mode+"&group="+group,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicEjbsJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('EjbsViewGrid').getStore().removeAll();
				Ext.getCmp('EjbsViewGrid').getStore().loadRawData(publicEjbsJSON['ejbGridArr']);
			}
		});
	},
	deleteEjbWindow: function(task)
	{
		var group = task.get('EjbName');
		var ejbTest = publicEjbsJSON['hiddenInfoObj']['test'];
		var ejbComp = publicEjbsJSON['hiddenInfoObj']['comp'];
		var server = publicEjbsJSON['hiddenInfoObj']['server'];
		Ext.Msg.show ({
			title: infosTitle,
			msg: infosalert_4,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					myDDMask.show();
					Ext.Ajax.request({
						url: 'SpecificTestConfiguration/data/Egconfigejbp.jsp?test='+ejbTest+'&comp='+ejbComp+'&server='+server+'&group='+group+'&mode=del',
						method: 'POST',
						scope: this,
						success: function(response)
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								myDDMask.hide();
								var delEjbJson = Ext.decode( response.responseText );
								if (delEjbJson['success'])
								{
									testInterViews.buildEjbsData(delEjbJson['comp'],delEjbJson['test'])
								}
							}
						}
					});
				}
			}
		});
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigejb',
			method: 'POST',
			async: false
		});
	},
	showEditEjbWindow: function(task) {
		var curGrp = task.get('EjbName');
        var me = this;
        var taskEditWindow = Ext.create('SpecificTestConfiguration.view.EgConfigEjbsCreation');
		var tname = publicEjbsJSON['hiddenInfoObj']['test'];
		var cname = publicEjbsJSON['hiddenInfoObj']['comp'];
		var server = publicEjbsJSON['hiddenInfoObj']['server'];

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigEjbJson.jsp?test='+tname+"&comp="+cname+"&group="+curGrp+"&mode=modify&server="+server,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicEjbsJSON = Ext.decode( jsonText );
					taskEditWindow.show();
					if (Ext.getCmp('itemselectejb').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectejb').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselectejb').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectejb').toField.store.removeAll();
					}
					Ext.getCmp('groupnme').setValue('');

					Ext.getCmp('itemselectejb').fromField.store.add(publicEjbsJSON['managedArry']);
					Ext.getCmp('itemselectejb').toField.store.add(publicEjbsJSON['allElementsArry']);
					Ext.getCmp('groupnme').setValue(curGrp);
					Ext.getCmp('groupnme').setReadOnly(true);
				}
			}
		});
	},

	updateConfigEjbs: function() {
		var funmng = new Array();
		var fmng = new Array();
		var mnglen = Ext.getCmp('itemselectejb').fromField.store.getCount();

		var tname = publicJson['testName'];
		var cType = Ext.getCmp('componentType').getValue();
		var mode = publicEjbsJSON['hiddenInfoObj']['mode'];

		var flg="true";
		var group = Ext.getCmp('groupnme').getValue();

		if (from !=null && from=="modify")
		{
			flg="false";
		}

		if(mnglen == 0)
		{
			Ext.Msg.show({
				title: ejbTitle,
				msg: infosalert_1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if(!checkblank(group))
		{
			Ext.Msg.show({
				title: ejbTitle,
				msg: enterGrpNme,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('groupnme').focus(true);
				}
			});
			return;
		}
		else if(!checkspace(group))
		{
			Ext.getCmp('groupnme').focus();
			return;
		}
		else if(!checkspecialnomess(group,"`~!@#$%^&*()+=-/?'\"]}[{\\|;:.,><"))
		{
			Ext.Msg.show({
				title: ejbTitle,
				msg: infosalert_2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('groupnme').focus(true);
				}
			});
			return;
		}
		else if(flg == "true")
		{
			if(ejbGroupExists(group))
			{
				Ext.Msg.show({
					title: ejbTitle,
					msg: infosalert_3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('groupnme').focus(true);
					}
				});
				return;
			}
		}

		var toFieldStore = Ext.getCmp('itemselectejb').toField.store;
		var fromFieldStore = Ext.getCmp('itemselectejb').fromField.store;
		var fdissociate = ',';
		var fassociate = ',';
		for (var i = 0; i < toFieldStore.getCount(); i++)
		{
			var value = toFieldStore.getAt(i).get('valueField');
			if (!Ext.isEmpty(value) && value != undefined)
			{
				fdissociate += value+',';
			}
		}
		for (var i = 0; i < fromFieldStore.getCount(); i++)
		{
			var value = fromFieldStore.getAt(i).get('valueField');
			if (!Ext.isEmpty(value) && value != undefined)
			{
				fassociate += value+',';
			}
		}
		if (!Ext.isEmpty(fdissociate) && fdissociate.indexOf(',') == 0)
		{
			fdissociate = fdissociate.substring(1);
		}
		if (!Ext.isEmpty(fassociate) && fassociate.indexOf(',') == 0)
		{
			fassociate = fassociate.substring(1);
		}

		var flag = 'true';
		var cname = Ext.getCmp('componentName').getValue();

		if(!(cname.indexOf(":") > -1))
		{
			cname = cname + ":NULL";
			flag = "false";
		}

		var me = this;
		if((fassociate != "" || fdissociate != "") && flg=="true")
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/Egconfigejbp.jsp?mode='+mode+"&test="+tname+"&comp="+cname+"&group="+group+"&fassociate="+fassociate+"&server="+cType,
				method: 'POST',
				async: false,
				success: function(response)
				{
					Ext.getCmp('egconfigejbscreation').destroy();
					me.buildEjbsData(cname,tname);
				}
			});
		}
		else if((fassociate != "" || fdissociate != "") && flg=="false")
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/Egconfigejbp.jsp?mode='+mode+'&test='+tname+"&comp="+cname+"&group="+group+"&fassociate="+fassociate+"&server="+cType,
				method: 'POST',
				async: false,
				success: function(response)
				{
					Ext.getCmp('egconfigejbscreation').destroy();
					me.buildEjbsData(cname,tname);
				}
			});
		}
		from = '';
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigejb',
			method: 'POST',
			async: false
		});
	},
	configInfoss: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigInfos').show();
		var cname = Ext.getCmp('componentName').getValue();
		var tname = publicJson['testName'];
		this.buildInfosData(cname,tname);
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiginfos',
			method: 'POST',
			async: false
		});
	},
	addconfigInfoss: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigInfosCreation').show();
		var cname = Ext.getCmp('componentName').getValue();
		var tname = publicJson['testName'];
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigInfosJson.jsp?test='+tname+"&comp="+cname,//+"&mode="+mode+"&group="+group,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicInfosJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectinfos').fromField.store.add(publicInfosJSON['managedArry']);
				Ext.getCmp('itemselectinfos').toField.store.add(publicInfosJSON['allElementsArry']);
				if (publicInfosJSON['applyToOtherComp'])
				{
					Ext.getCmp('applyAllContainer').show();
				}
				else
				{
					Ext.getCmp('applyAllContainer').hide();
				}
			}
		});
	},
	buildInfosData: function(cname,tname) {
			Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigInfosJson.jsp?test='+tname+"&comp="+cname,//+"&mode="+mode+"&group="+group,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicInfosJSON = Ext.decode( jsonText );
					var infoGridArr = publicInfosJSON['infoGridArr'];
					Ext.getCmp('InfosViewGrid').getStore().removeAll();
					Ext.getCmp('InfosViewGrid').getStore().loadRawData(infoGridArr);
				}
			}
		});
	},
	deleteInfoWindow: function(task)
	{
		var group = task.get('InfoName');
		var infoTest = publicInfosJSON['hiddenInfoObj']['test'];
		var infoComp = publicInfosJSON['comp'];
		var infoFlag = publicInfosJSON['hiddenInfoObj']['flag'];
		Ext.Msg.show ({
			title: infosTitle,
			msg: infosalert_4,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					myDDMask.show();
					Ext.Ajax.request({
						url: 'SpecificTestConfiguration/data/EgconfiginfospJson.jsp?test='+infoTest+'&comp='+infoComp+'&group='+group+'&flag='+infoFlag+'&delGroup=true',
						method: 'POST',
						scope: this,
						success: function(response)
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								myDDMask.hide();
								var delInfoJson = Ext.decode( response.responseText );
								if (delInfoJson['success'])
								{
									testInterViews.buildInfosData(delInfoJson['comp'],delInfoJson['test'])
								}
							}
						}
					});
				}
			}
		});
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiginfos',
			method: 'POST',
			async: false
		});
	},
	showEditInfoWindow: function(task) {
		var curGrp = task.get('InfoName');
        var me = this;
        var taskEditWindow = Ext.create('SpecificTestConfiguration.view.EgConfigInfosCreation');
		var tname = publicInfosJSON['hiddenInfoObj']['test'];
		var cname = publicInfosJSON['hiddenInfoObj']['comp'];
		var flag = publicInfosJSON['hiddenInfoObj']['flag'];
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgconfiginfospJson.jsp?test='+tname+"&comp="+cname+"&group="+curGrp+"&action=modify&flag="+flag,
			method: 'POST',
			async: false,
			success: function(response)
			{
			}
		});

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigInfosJson.jsp?test='+tname+"&comp="+cname+"&group="+curGrp+"&from=modify",
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicInfosJSON = Ext.decode( jsonText );
					taskEditWindow.show();
					if (Ext.getCmp('itemselectinfos').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectinfos').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselectinfos').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselectinfos').toField.store.removeAll();
					}
					Ext.getCmp('groupnmeinfos').setValue('');

					Ext.getCmp('itemselectinfos').fromField.store.add(publicInfosJSON['managedArry']);
					Ext.getCmp('itemselectinfos').toField.store.add(publicInfosJSON['allElementsArry']);
					Ext.getCmp('groupnmeinfos').setValue(curGrp);
					Ext.getCmp('groupnmeinfos').setReadOnly(true);
					if (publicInfosJSON['applyToOtherComp'])
					{
						Ext.getCmp('applyAllContainer').show();
					}
					else
					{
						Ext.getCmp('applyAllContainer').hide();
					}
				}
			}
		});
	},
	getInterMediateHiddenFields : function(hiddenObj) {
		var hiddenFields = publicInfosJSON[hiddenObj];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	applyAllCheckEvent: function()
	{
		var checkEnabled = Ext.getCmp('applyAllCheck').getValue();
		var params = '';
		var from = publicInfosJSON['from'];
		var hiddenQstr = this.getInterMediateHiddenFields('hiddenInfoObj');
		if (!Ext.isEmpty(hiddenQstr) && hiddenQstr != undefined)
		{
			params = hiddenQstr;
		}
		if (!Ext.isEmpty(from) && from != undefined)
		{
			params += 'from='+from;
		}
		if (checkEnabled)
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgApplyEjbConfigJson.jsp?'+params,
				method: 'POST',
				async: false,
				success: function(response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var applyAllInfoJson = Ext.decode( response.responseText );
						Ext.getCmp('compMultiSelectContainer').show();
						if (!Ext.isEmpty(applyAllInfoJson['compArr']) && applyAllInfoJson['compArr'] != undefined)
						{
							Ext.getCmp('availableCompMultiSelect').getStore().removeAll();
							Ext.getCmp('availableCompMultiSelect').getStore().loadRawData(applyAllInfoJson['compArr']);
						}

					}
				}
			});
		}
		else
		{
			Ext.getCmp('availableCompMultiSelect').getStore().removeAll();
			Ext.getCmp('compMultiSelectContainer').hide();
		}
	},
	updateConfigInfos: function() {
		var funmng = new Array();
		var fmng = new Array();
		var mnglen = Ext.getCmp('itemselectinfos').fromField.store.getCount();

		var tname = publicJson['testName'];
		var cType = Ext.getCmp('componentType').getValue();
		var from = publicInfosJSON['from'];
		var flg="true";
		var group = Ext.getCmp('groupnmeinfos').getValue();

		if (from !=null && from=="modify")
		{
			flg="false";
		}

		if(mnglen == 0)
		{
			Ext.Msg.show({
				title: infosTitle,
				msg: infosalert_1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if(!checkblank(group))
		{
			Ext.Msg.show({
				title: infosTitle,
				msg: enterGrpNme,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('groupnmeinfos').focus(true);
				}
			});
			return;
		}
		else if(!checkspace(group))
		{
			Ext.getCmp('groupnmeinfos').focus();
			return;
		}
		else if(!checkspecialnomess(group,"`~!@#$%^&*()+=-/?'\"]}[{\\|;:.,><"))
		{
			Ext.Msg.show({
				title: infosTitle,
				msg: infosalert_2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('groupnmeinfos').focus(true);
				}
			});
			return;
		}
		else if(flg == "true")
		{
			if(groupExists(group))
			{
				Ext.Msg.show({
					title: infosTitle,
					msg: infosalert_3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('groupnmeinfos').focus(true);
					}
				});
				return;
			}
		}

		//var fdissociate = Ext.getCmp('itemselectinfos').getValue();
		var toFieldStore = Ext.getCmp('itemselectinfos').toField.store;
		//var fassociate = Ext.getCmp('itemselectinfos').fromField.getValue();
		var fromFieldStore = Ext.getCmp('itemselectinfos').fromField.store;
		var fdissociate = ',';
		var fassociate = ',';
		for (var i = 0; i < toFieldStore.getCount(); i++)
		{
			var value = toFieldStore.getAt(i).get('valueField');
			if (!Ext.isEmpty(value) && value != undefined)
			{
				fdissociate += value+',';
			}
		}
		for (var i = 0; i < fromFieldStore.getCount(); i++)
		{
			var value = fromFieldStore.getAt(i).get('valueField');
			if (!Ext.isEmpty(value) && value != undefined)
			{
				fassociate += value+',';
			}
		}
		if (!Ext.isEmpty(fdissociate) && fdissociate.indexOf(',') == 0)
		{
			fdissociate = fdissociate.substring(1);
		}
		if (!Ext.isEmpty(fassociate) && fassociate.indexOf(',') == 0)
		{
			fassociate = fassociate.substring(1);
		}

		var flag = 'true';
		var cname = Ext.getCmp('componentName').getValue();

		if(!(cname.indexOf(":") > -1))
		{
			cname = cname + ":NULL";
			flag = 'false';
		}
		var checkEnabled = Ext.getCmp('applyAllCheck').getValue();
		var params = "test="+encodeURIComponent(tname)+"&comp="+encodeURIComponent(cname)+"&group="+encodeURIComponent(group)+"&fassociate="+encodeURIComponent(fassociate)+"&server="+encodeURIComponent(cType);

		if (checkEnabled)
		{
			var otherSelectComps = Ext.getCmp('availableCompMultiSelect').getValue();

			if (!Ext.isEmpty(otherSelectComps) && otherSelectComps.length > 0)
			{
				var selectedComps = ',';
				for (var i = 0; i < otherSelectComps.length; i++ )
				{
					var tmpComp = otherSelectComps[i];
					if(!Ext.isEmpty(tmpComp) && tmpComp != undefined)
					{
						selectedComps += tmpComp + ',';
					}
				}
				if (!Ext.isEmpty(selectedComps) && selectedComps.lastIndexOf(',') != -1)
				{
					selectedComps = selectedComps.substring(0,selectedComps.lastIndexOf(','));
					params += '&source=applyConfig&selectedComps='+selectedComps;
				}
			}
		}

		if((fassociate != "" || fdissociate != "") && flg=="true")
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgconfiginfospJson.jsp?flag='+flag+'&'+params,
				method: 'POST',
				async: false,
				success: function(response)
				{
					Ext.getCmp('egconfiginfoscreation').destroy();
					testInterViews.buildInfosData(cname,tname);
				}
			});
		}
		else if((fassociate != "" || fdissociate != "") && flg=="false")
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgconfiginfospJson.jsp?edit=true&'+params,
				method: 'POST',
				async: false,
				success: function(response)
				{
					Ext.getCmp('egconfiginfoscreation').destroy();
					testInterViews.buildInfosData(cname,tname);
				}
			});
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiginfos',
			method: 'POST',
			async: false
		});
	},
	configureVcTasks: function() { //VCTasks starts
		var compType = Ext.getCmp('componentType').getValue();
		var compName = Ext.getCmp('componentName').getValue();
		var testType =Ext.getCmp('testType').getValue();
		var testName = publicJson['testName'];
		var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
		var showUnconfigCompType = 'false';
		if (isChecked)
		{
			showUnconfigCompType = 'true';
		}

		var strQuery = '&componentType='+encodeURIComponent(compType)+'&testType='+encodeURIComponent(testType)+'&testName='+encodeURIComponent(testName)+'&componentName='+encodeURIComponent(compName)+'&clickedFrom='+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType;

		window.location.href = "/final/admin/EgAgentSettings.jsp?fromPage=TestConfiguration&fromVc=VcTasks&requestFrom=EgConfigureComponentTests.jsp"+strQuery;
	},
	configureVcEvents: function() { //VCEvents starts
		var compType = Ext.getCmp('componentType').getValue();
		var compName = Ext.getCmp('componentName').getValue();
		var testType =Ext.getCmp('testType').getValue();
		var testName = publicJson['testName'];
		var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
		var showUnconfigCompType = 'false';
		if (isChecked)
		{
			showUnconfigCompType = 'true';
		}

		var strQuery = '&componentType='+encodeURIComponent(compType)+'&testType='+encodeURIComponent(testType)+'&testName='+encodeURIComponent(testName)+'&componentName='+encodeURIComponent(compName)+'&clickedFrom='+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType;
		window.location.href = "/final/admin/EgAgentSettings.jsp?fromPage=TestConfiguration&fromVc=VcEvents&requestFrom=EgConfigureComponentTests.jsp"+strQuery;
	},
	configAggregatee: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigAggregate').show();
		var cname = Ext.getCmp('componentName').getValue();
		var ctype = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigAggregateJson.jsp?test='+tname+"&comp="+encodeURIComponent(cname)+"&server="+ctype,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicAggJSON  = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectAgg').fromField.store.add(publicAggJSON['enabledTests']);
				Ext.getCmp('itemselectAgg').toField.store.add(publicAggJSON['disableTests']);
			}
		});
	},
	configCompositee: function() {
		Ext.create('SpecificTestConfiguration.view.EgConfigComposite').show();
		var cname = Ext.getCmp('componentName').getValue();
		var ctype = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];

		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgConfigCompositeJson.jsp?test='+tname+"&comp="+encodeURIComponent(cname)+"&server="+ctype,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicAggJSON  = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectAgg').fromField.store.add(publicAggJSON['enabledTests']);
				Ext.getCmp('itemselectAgg').toField.store.add(publicAggJSON['disableTests']);
			}
		});
	},
	updateAggregatee: function() {
		var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myDDMask.show();

		var previousIncludedDescriptors = publicAggJSON['previousIncludedDescriptors'];

		var DDdisabledTestList = Ext.getCmp('itemselectAgg').getValue();
		var cname = Ext.getCmp('componentName').getValue();
		var ctype = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];

		var Arr = new Array();
		for (var i=0;i<Ext.getCmp('itemselectAgg').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectAgg').getStore().getAt(i).get('valueField');
			var isData = false;
			for (var j=0;j<DDdisabledTestList.length ;j++ )
			{
				if (allValue == DDdisabledTestList[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				Arr[Arr.length]=allValue;
			}
		}
		var DDenabledTestList = Arr;

		if (DDdisabledTestList == undefined)
		{
			DDdisabledTestList = "";
		}
		if (DDenabledTestList == undefined)
		{
			DDenabledTestList = "";
		}

		var qrString = "previousIncludedDescriptors="+encodeURIComponent(previousIncludedDescriptors)+"&fdissociate="+encodeURIComponent(DDdisabledTestList)+"&n_fassociate="+encodeURIComponent(DDenabledTestList)+"&comp="+encodeURIComponent(cname)+"&test="+tname+"&server="+ctype;

		if (DDenabledTestList != "" || DDdisabledTestList != "")
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgconfigaggregatepJson.jsp?'+qrString,
				method: 'POST',
				success: function( response )
				{
					myDDMask.hide();
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.Msg.show({
								title: resultStatus['title'],
								msg: resultStatus['message1'],
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						}
					}
				}
			});
		}
		else
		{
			myDDMask.hide();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	updateCompositee: function() {
		var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myDDMask.show();

		var myArray = new Array();
		var previousIncludedDescriptors = publicAggJSON['previousIncludedDescriptors'];
		var isThisMasterInfoTest = publicAggJSON['masterInfoTestFound'];
		var masterInfoTest = "";
		var masterInfoTestDisplay = "";
		if(isThisMasterInfoTest)
		{
			var previousIncludedMasterTestDescriptors = publicAggJSON['previousIncludedMasterTestDescriptors'];
			if(previousIncludedMasterTestDescriptors != null && previousIncludedMasterTestDescriptors.indexOf(":")>-1)
			{
				myArray = previousIncludedMasterTestDescriptors.split(",");
			}
			masterInfoTest = publicAggJSON['masterInfoTest'];
			masterInfoTestDisplay = publicAggJSON['masterInfoTestDisplay'];
		}
		var DDdisabledTestList = Ext.getCmp('itemselectAgg').getValue();

		var allowMe = Ext.getCmp('itemselectAgg').getStore().getCount()==0;
		var cname = Ext.getCmp('componentName').getValue();
		var ctype = Ext.getCmp('componentType').getValue();
		var tname = publicJson['testName'];

		var Arr = new Array();
		for (var i=0;i<Ext.getCmp('itemselectAgg').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectAgg').getStore().getAt(i).get('valueField');
			var isData = false;
			for (var j=0;j<DDdisabledTestList.length ;j++ )
			{
				if (allValue == DDdisabledTestList[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				Arr[Arr.length]=allValue;
			}
		}
		var DDenabledTestList = Arr;
		if (DDdisabledTestList == undefined)
		{
			DDdisabledTestList = "";
		}
		if (DDenabledTestList == undefined)
		{
			DDenabledTestList = "";
		}
		var proceed = true;
		if(isThisMasterInfoTest && myArray.length>0 && DDdisabledTestList.length>0)
		{
			for(var j=0;j<DDdisabledTestList.length;j++)
			{
				if(myArray.indexOf(DDdisabledTestList[j])>-1)
				{
					proceed=false;
					break;
				}
			}
		}
		if(!proceed)
		{
			Ext.Msg.show({
				title: pageName,
				msg: masterInfoTestDisplay+' '+masterTestInfoAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
				}
			});
			myDDMask.hide();
		}
		else
		{
			var qrString = "previousIncludedDescriptors="+encodeURIComponent(previousIncludedDescriptors)+"&fdissociate="+encodeURIComponent(DDdisabledTestList)+"&n_fassociate="+encodeURIComponent(DDenabledTestList)+"&comp="+encodeURIComponent(cname)+"&test="+tname+"&server="+ctype;
			if(DDenabledTestList != "" || DDdisabledTestList != "" || allowMe)
			{
				Ext.Ajax.request({
					url: 'SpecificTestConfiguration/data/EgconfigcompositepJson.jsp?'+qrString,
					method: 'POST',
					success: function( response )
					{
						myDDMask.hide();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								Ext.Msg.show({
									title: resultStatus['title'],
									msg: resultStatus['message1'],
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
						}
					}
				});
			}
			else
			{
				myDDMask.hide();
			}
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},
	configDbCreations: function() {  //Config Db Creation
		var hostndb = Ext.getCmp('host').getValue();
		var portndb = Ext.getCmp('port').getValue();
		var cname = Ext.getCmp('componentName').getValue();
		var sidndb = cname.substring(cname.lastIndexOf(":")+1);

		if (publicJson['cantopenDbUserCreation'] == "true")
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: dbConn,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else
		{
			Ext.create('SpecificTestConfiguration.view.EgDbUserCreation').show();
			Ext.getCmp('hostnamedb').setValue(hostndb).setReadOnly(true);
			Ext.getCmp('portdb').setValue(portndb).setReadOnly(true);
			Ext.getCmp('siddb').setValue(sidndb).setReadOnly(true);
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egdbusercreation',
				method: 'POST',
				async: false
			});
		}
	},
	comboVersions: function(btn) {
		var getVersion = Ext.getCmp('dbversion').getValue();
		if(getVersion != null && getVersion == "Oracle12.x")
		{
			pwd_flag = "false";
			Ext.getCmp('syspwd').hide();
			Ext.getCmp('dbconnection_radioGrp').show();
			Ext.getCmp('dbconnection_radioGrp').setDisabled(false);
		}
		else if(getVersion != null && getVersion == "Oracle 7.x")
		{
			pwd_flag = "true";
			Ext.getCmp('dbconnection_radioGrp').hide();
			Ext.getCmp('dbconnection_radioGrp').setDisabled(true);
			Ext.getCmp('syspwd').show();
			Ext.getCmp('syspwd').setValue('');
			Ext.getCmp('syspwd').backupValue = '';
		}
		else
		{
			pwd_flag = "false";
			Ext.getCmp('dbconnection_radioGrp').hide();
			Ext.getCmp('dbconnection_radioGrp').setDisabled(true);
			Ext.getCmp('syspwd').hide();
		}
		Ext.getCmp('dbadmin').setValue('');
		Ext.getCmp('dbadminpwd').setValue('');
		Ext.getCmp('dbadminpwd').backupValue = '';
		Ext.getCmp('dbuser').setValue('');
		Ext.getCmp('dbuserpwd').setValue('');
		Ext.getCmp('dbuserpwd').backupValue = '';
		Ext.getCmp('defaulttablespace').setValue('');
		Ext.getCmp('temptablespace').setValue('');
	},
	clearDbs: function() {
		Ext.getCmp('temptablespace').setValue('');
		Ext.getCmp('defaulttablespace').setValue('');
		Ext.getCmp('dbuserpwd').setValue('');
		Ext.getCmp('dbuserpwd').backupValue = '';
		Ext.getCmp('dbuser').setValue('');
		Ext.getCmp('dbadminpwd').setValue('');
		Ext.getCmp('dbadminpwd').backupValue = '';
		Ext.getCmp('dbadmin').setValue('');

		var getVersion = Ext.getCmp('dbversion').getValue();
		if(getVersion != null && getVersion == "Oracle 7.x")
		{
			Ext.getCmp('syspwd').setValue('');
		}
	},
	ApplyNewDbs: function() {
		if (newdbupdated == 'true')
		{
			Ext.getCmp('ApplyBTN').enable();
			var dbuser = Ext.getCmp('dbuser').getValue();
			var dbuserpwd = Ext.getCmp('dbuserpwd').getValue();
			Ext.getCmp('user').setValue(dbuser);
			Ext.getCmp('password').setValue(dbuserpwd);
			Ext.getCmp('password').backupValue = dbuserpwd;
			Ext.getCmp('passwordconfirmpassword').setValue(dbuserpwd);
			Ext.getCmp('passwordconfirmpassword').backupValue = dbuserpwd;
			Ext.getCmp('egdbusercreation').destroy();
		}
		else
		{
			Ext.getCmp('ApplyBTN').disable();
			Ext.Msg.show({
				title: dbTitle,
				msg: invalidHName,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	AddNewDbs: function(btn) {
		newdbupdated = 'false';
		var hostnamedb = Ext.getCmp('hostnamedb').getValue();
		var portdb = Ext.getCmp('portdb').getValue();
		var siddb = Ext.getCmp('siddb').getValue();
		var dbversion = Ext.getCmp('dbversion').getValue();
		var syspwd = Ext.getCmp('syspwd').getValue();
		var dbconnectionChecked = Ext.getCmp('dbconnection1').getValue();
		var dbconnection = "";
		if (dbconnectionChecked)
		{
			dbconnection = "cdb";
		}
		else
		{
			dbconnection = "pdb";
		}

		var dbadmin = Ext.getCmp('dbadmin').getValue();
		var dbadminpwd = Ext.getCmp('dbadminpwd').getValue();
		var dbuser = Ext.getCmp('dbuser').getValue();
		var dbuserpwd = Ext.getCmp('dbuserpwd').getValue();
		var defaulttablespace = Ext.getCmp('defaulttablespace').getValue();
		var temptablespace = Ext.getCmp('temptablespace').getValue();

		var checkValiddb = this;
		var validatedbCred = checkValiddb.isValidDbCredentials(dbversion,defaulttablespace,temptablespace,dbuser,dbadmin,dbadminpwd,dbuserpwd,syspwd,dbconnection);
		if (validatedbCred)
		{
			var qdbStr = "hostname="+hostnamedb+"&port="+portdb+"&sid="+siddb+"&pwd_flag="+pwd_flag+"&version="+dbversion+"&syspwd="+syspwd+"&dbauser="+dbadmin+"&dbapwd="+dbadminpwd+"&dbuser="+encodeURIComponent(dbuser)+"&dbuserpwd="+dbuserpwd+"&deftablespace="+defaulttablespace+"&temptablespace="+temptablespace+"&dbconnection="+(dbconnection);

			Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgdbusercreationpJson.jsp?'+qdbStr,
			method: 'POST',
			success: function( response )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						newdbupdated = 'true';
						var resultStr = publicJSON['result'];
						Ext.Msg.show({
							title: resultStr['title'],
							msg: resultStr['message1'],
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
						Ext.getCmp('ApplyBTN').enable();
					}
					else
					{
						Ext.getCmp('ApplyBTN').disable();
						var errorStatus = publicJSON['error'];
						Ext.Msg.show({
							title: errorStatus['title'],
							msg: errorStatus['message1'],
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		});
		}
	},
	isValidDbCredentials: function(dbversion,defaulttablespace,temptablespace,dbuser,dbadmin,dbadminpwd,dbuserpwd,syspwd,dbconnection) {
		var start_chars = "0123456789$#_";
		var sub = true;
		var regExp = /^[A-Za-z]+/;
		if(dbversion == "-1")
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: selectDBver,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			sub = false;
		}
		else if(!checkblank(dbadmin))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: enterDBAdmin,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbadmin').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspace(dbadmin))
		{
			Ext.getCmp('dbadmin').focus();
			sub = false;
		}
		else if(!checkspecial(dbadmin,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
		{
			Ext.getCmp('dbadmin').focus();
			sub = false;
		}
		else if(dbadminpwd == "")
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: enterDBPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbadmin').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspecialnomess(dbadminpwd,"\"|"))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: _notAllowCharInPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbadminpwd').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkblank(dbuser))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: enterDBUsr,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbuser').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspace(dbuser))
		{
			Ext.getCmp('dbuser').focus();
			sub = false;
		}
		//else if(!checkspecial(dbuser,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
		else if(!checkspecial(dbuser,"&\""))
		{
			Ext.getCmp('dbuser').focus();
			sub = false;
		}
		else if(!regExp.test(dbuser))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: DBNmeAlphabet,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbuser').focus(true);
				}
			});
			sub = false;
		}
		else if(dbversion == "Oracle12.x" && dbconnection == 'cdb' )
		{
			var startPosition = dbuser.substring(0,3) ; 
			if (!Ext.isEmpty(startPosition) && startPosition.toLowerCase() != "c##")
			{
				Ext.Msg.show({
					title: dbTitle,
					msg: DbUsrMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('dbuser').focus(true);
					}
				});
				sub = false;
			}
		}
		else if(dbuserpwd == "")
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: enterPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbuserpwd').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspecialnomess(dbuserpwd,"\"|"))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: _notAllowCharInPwd,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('dbuserpwd').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkblank(defaulttablespace))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: enterdeftb,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('defaulttablespace').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspace(defaulttablespace))
		{
			Ext.getCmp('defaulttablespace').focus();
			sub = false;
		}
		else if(start_chars.indexOf(defaulttablespace.charAt(0)) > -1)
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: startswithalpha,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('defaulttablespace').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspecial(defaulttablespace,"`~!@%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
		{
			Ext.getCmp('defaulttablespace').focus();
			sub = false;
		}
		else if(!checkblank(temptablespace))
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: entertemptb,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('temptablespace').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspace(temptablespace))
		{
			Ext.getCmp('temptablespace').focus();
			sub = false;
		}
		else if(start_chars.indexOf(temptablespace.charAt(0)) > -1)
		{
			Ext.Msg.show({
				title: dbTitle,
				msg: startstbwithalpha,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('temptablespace').focus(true);
				}
			});
			sub = false;
		}
		else if(!checkspecial(temptablespace,"`~!@%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
		{
			Ext.getCmp('temptablespace').focus();
			sub = false;
		}
		else if(dbversion == "Oracle7.x")
		{
			if(syspwd == "")
			{
				Ext.Msg.show({
					title: dbTitle,
					msg: enterDBPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('syspwd').focus(true);
					}
				});
				sub = false;
			}
			else if(!checkspecialnomess(syspwd,"\"|"))
			{
				Ext.Msg.show({
					title: dbTitle,
					msg: _notAllowCharInPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('syspwd').focus(true);
					}
				});
				sub = false;
			}
			else
			{
				sub = true;
			}
		}
		else
		{
			sub = true;
		}
		return sub;
	},
	showModificationWindow: function(title,windowId,reqFrom,width,margin1,margin2,fieldId,fieldLabel,hideField)
	{
		Ext.widget('window',{
		title: title,
		id: windowId,
		width: 500,
		resizable: false,
		padding: '5 10 10 10',
		border: false,
		modal: true,
		closeAction: 'destory',
		doClose: function() {
			this.destroy();
		},
		dockedItems: [
			{
				id: 'dockedToolBarBtn',
				name: 'dockedToolBarBtn',
				dock: 'bottom',
				layout:{
					type:'hbox',
					align:'stretch',
					pack:'center'
				},
				border:false,
				padding : '10 0 0 0',
				items: [
					{
						xtype: 'button',
						cls: 'quickMenuWhiteButton',
						text: Update,
						width: 80,
						id: 'update_Process',
						name: 'update_Process',
						listeners: {
							click: function (button) {
								if(reqFrom == 'process')
									me.modifyProces();
								else if(reqFrom == 'service')
									me.modifyService();
							}
						}
					}
				]
			}
		],
		items:[
			{
				xtype: 'container',
				id:'mainContainer',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				defaults: {
					labelSeparator: '',
					margin: margin1,
					width: width,
					labelWidth: 100
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						id: fieldId,
						fieldLabel: fieldLabel,
						allowBlank: false,
						margin: margin2
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						id: 'process_pattern',
						fieldLabel: processPatternLabel,
						allowBlank: false,
						margin: '5 10 10 10',
						hidden: hideField
					}
				]
			}
		]
		}).show();
	},
	showResultWindow : function(title,reqFrom)
	{	
		Ext.widget('window',{
		title: title,
		closeAction: 'destory',
		bodyPadding : 05,
		id:'resultWindow',
		resizable:false,
		scroll: true,
		width : 310,
		height : 130,
		modal : true,
		padding:'5 10 10 10',
		doClose: function() {
			this.destroy();
		},
		items: [
			{
				xtype: 'displayfield',
				width: 250,
				value: '<table align="left" border="0" bordercolor="blue" width="100%"><tr><td align="center" height="05"><table border="0" bordercolor="green"><tr><td align="center" width="07%"><img src="/final/images/spacer.gif" class="iconConfirmation"></td><td align="center" width="70%" valign="top">'+updateChanges+'</td></tr></table></td></tr></table>',
				margin: '00 10 00 00'
			},
			{
				xtype: 'button',
				id: 'yes_button',
				text: 'Yes',
				cls: 'button20',
				width: 70,
				margin: '10 05 15 70',
				listeners: {
					click: function (button) {
						showMsgWindow = true;
						var status = false;
						allowToAsignIndex = true;
						if(reqFrom == 'service')
							status = testInterViews.checkBeforeAdding("",true);
						else if(reqFrom == 'process')
							status = testInterViews.validateBeforeAdding("",true);
						if(status)
						{
							if(reqFrom == 'service')
								me.updateService(true,'fromClose');
							else if(reqFrom == 'process')
								me.updateProcessPattern(true,'fromClose');
						}
						button.up('window').close();
					}
				}
			},
			{
				xtype: 'button',
				id: 'no_button',
				text: 'No',
				cls: 'button20',
				width: 70,
				margin: '10 00 15 00',
				listeners: {
					click: function (button) {
						if(reqFrom == 'service')
							Ext.getCmp('winservicesconfiguration').destroy();
						else
							Ext.getCmp('processconfiguration').destroy();
						button.up('window').close();
					}
				}
			}
		]
		}).show();
	},
	addNewService: function(){
		isNewService = true;
		isManualEdit = true;
		showMsgWindow = true;
		this.showModificationWindow(winServTitle,'egservicemodification','service',350,5,'15 10 15 10','service_name',serviceNameLabel,true);
		serviceWidget = Ext.getCmp('egservicemodification');
		Ext.getCmp('service_name').focus(false,200);
	},
	editService: function(rowIndex,service){
		isNewService = false;
		if(!Ext.isEmpty(rowIndex))
		{
			isManualEdit = true;
			serviceName = Ext.getCmp('serviceNamesGrid').getStore().getAt(rowIndex).get('serviceName');
		}
		else if(!Ext.isEmpty(service))
		{
			isManualEdit = false;
			serviceName = service;
		}
		currentRow = serviceNamesArray.indexOf(serviceName);
		this.showModificationWindow(winServTitle,'egservicemodification','service',350,5,'15 10 15 10','service_name',serviceNameLabel,true);
		serviceWidget = Ext.getCmp('egservicemodification');
		Ext.getCmp('service_name').setValue(serviceName);
		Ext.getCmp('service_name').focus(false,200);
	},
	modifyServices: function(){
		if(isManualEdit)
			showMsgWindow = true;
		newServiceName = Ext.getCmp('service_name').getValue();
		var checkStatus = this.checkBeforeAdding(newServiceName,false);
		if(checkStatus)
		{
			var serviceNamesStoreArr = new Array();
			if(isNewService)
			{
				var searchComp = Ext.getCmp('winServiceSearchTrigger');
				if(!Ext.isEmpty(searchComp.getValue()))
				{
					searchComp.reset();
				}
				serviceNamesArray.push(newServiceName);
			}
			else
			{
				serviceNamesArray.splice(serviceNamesArray.indexOf(serviceName),1,newServiceName);
			}
			if(!Ext.isEmpty(serviceNamesArray) && serviceNamesArray != undefined)
			{
				for(var z=0;z<serviceNamesArray.length;z++)
				{
					if(serviceNamesArray[z] == '$unconfigured')
					{
						Ext.Array.remove(serviceNamesArray,'$unconfigured');
						continue;
					}
					var map = {'serviceName': serviceNamesArray[z]};
					serviceNamesStoreArr.push(map);
				}
			}
			var serviceObj = Ext.getCmp('serviceNamesGrid');
			this.unCheckHeaderCheckBox(serviceObj);
			Ext.suspendLayouts();
			serviceObj.getStore().removeAll();
			serviceObj.getStore().loadRawData(serviceNamesStoreArr);
			Ext.resumeLayouts(true);
			if(isNewService)
			{
				Ext.Msg.show ({
					title: winServTitle,
					msg: addedServiceMsg,
					buttons: Ext.MessageBox.YESNO,
					icon: 'iconConfirmation',
					fn: function(response) {
						if (response == "yes")
						{
							me.addService();
						}
					}
				});
			}
			else if(!isManualEdit)
			{
				showMsgWindow = false;
				serviceWidget.destroy();
				checkStatus = this.checkBeforeAdding(newServiceName,true);
			}
			if(isManualEdit)
			{
				serviceWidget.destroy();
			}
			if(!Ext.isEmpty(serviceNamesStoreArr))
			{
				Ext.getCmp('winServiceSearchTrigger').enable();
				Ext.getCmp('DeleteOver').show();
				Ext.getCmp('updateService').enable();
			}
		}
		if(checkStatus && !isManualEdit)
		{
			serviceWidget.destroy();
			showMsgWindow = true;
			me.updateService(true);
		}
		return checkStatus;
	},
	winServicesSearch: function(){
		searchStr = Ext.getCmp('winServiceSearchTrigger').getValue();
		searchList = new Array();
		var searchString = searchStr.split(' ');
		for(var s=0;s<searchString.length;s++)
		{
			var str = searchString[s].trim();
			if(str != "")
				searchList.push(str);
		}
		var userdetailsgrid = Ext.getCmp('serviceNamesGrid');
		userdetailsgrid.show();
		Ext.getCmp('updateService').enable();
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
			userdetailsgrid.getStore().clearFilter();
			totalRecords = userdetailsgrid.getStore().getCount();
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
			var isDataFetch = false;
			userdetailsgrid.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var serviceName = item.get('serviceName');
					if(doesExist(searchList,serviceName))
					{
						return true;
					}
				}
			});
			userdetailsgrid.getStore().suspendEvents(true);
			userdetailsgrid.getStore().filter(userFilter);
			userdetailsgrid.getStore().resumeEvents();
			totalRecords = userdetailsgrid.getStore().getCount();
		}
		if(totalRecords == 0)
		{
			Ext.getCmp('updateService').disable(true);
			Ext.getCmp('DeleteOver').hide();
			userdetailsgrid.getView().emptyText = '<table align="center"><tr><td align="center" height="320"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noSearchResult+'</td></tr></table></td></tr></table>';
			userdetailsgrid.getView().refresh();
		}
		else
		{
			Ext.getCmp('DeleteOver').show();
		}
	},
	removeSeletedServices: function(serviceName)
	{
		if(Ext.isEmpty( Ext.getCmp('winServiceSearchTrigger').getValue()))
		{
			totalRecords = Ext.getCmp('serviceNamesGrid').store.totalCount;
		}
		var grid = Ext.getCmp('serviceNamesGrid').getSelectionModel().getSelection();
		var serviceNamesStoreArr = new Array();
		var deletePageMsg = '';
		var isSelectedDelete = false;
		if(Ext.isEmpty(serviceName) && serviceName == undefined)
		{
			if(grid.length == 0)
			{
				Ext.Msg.show({
					title: winServTitle,
					msg: notSelectMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						return false;
					}
				});
				return false;
			}
			isSelectedDelete = true;
			deletePageMsg = confirmDeleteMsg1;
		}
		else
		{
			deletePageMsg = confirmDeleteMsg2+" '"+serviceName+"'?";
		}
		Ext.Msg.show ({
			title: winServTitle,
			msg: deletePageMsg,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					if(isSelectedDelete)
					{
						for(var z=0;z<grid.length;z++)
						{
							var values = grid[z];
							var selecedServiceName = values.get('serviceName');
							if(selecedServiceName != null)
							{
								Ext.Array.remove(serviceNamesArray,selecedServiceName);
								totalRecords--;
							}
						}
					}
					else
					{
						Ext.Array.remove(serviceNamesArray,serviceName);
						totalRecords--;
					}
					if(!Ext.isEmpty(serviceNamesArray) && serviceNamesArray != undefined)
					{
						for(var z=0;z<serviceNamesArray.length;z++)
						{
							var map = {'serviceName': serviceNamesArray[z]};
							serviceNamesStoreArr.push(map);
						}
					}
					var serviceGridObj = Ext.getCmp('serviceNamesGrid');
					Ext.suspendLayouts();
					serviceGridObj.getStore().removeAll();
					serviceGridObj.getStore().loadRawData(serviceNamesStoreArr);
					Ext.resumeLayouts(true);
					if(totalRecords == 0)
					{
						Ext.getCmp('winServiceSearchTrigger').reset();
						serviceGridObj.getSelectionModel().toggleUiHeader(false);
					}
					if(Ext.isEmpty(serviceNamesArray))
					{
						Ext.getCmp('winServiceSearchTrigger').disable();
						Ext.getCmp('winServiceSearchTrigger').reset();
						Ext.getCmp('updateService').disable(true);
						Ext.getCmp('DeleteOver').hide();
						serviceGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="320"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noconfServices+'</td></tr></table></td></tr></table>';
						serviceGridObj.getView().refresh();
					}
				}
			}
		});
	},
	winServiceConfigs: function() {
		var serviceNames = Ext.getCmp('serviceName').getValue();
		serviceNamesArray = new Array();
		var serviceNamesStoreArr = new Array();
		if (!Ext.isEmpty(serviceNames) && serviceNames.indexOf(',') != -1)
		{
			tempServiceNamesArray = serviceNames.split(',');
			var filtered = tempServiceNamesArray.filter(function(value){
				return !Ext.isEmpty(value);
			});
			serviceNamesArray = filtered;
		}
		else
		{
			serviceNamesArray[0] = serviceNames;
		}
		if (!Ext.getCmp(serviceNamesArray) && serviceNamesArray != undefined)
		{
			for (var s=0;s<serviceNamesArray.length;s++)
			{
				if(Ext.isEmpty(serviceNamesArray[s]) || serviceNamesArray[s] == '$unconfigured' || serviceNamesArray[s].toLowerCase() == '$servicename')
				{
					Ext.Array.remove(serviceNamesArray,serviceNamesArray[s]);
					continue;
				}
				for (var t=s+1;t<serviceNamesArray.length;t++)
				{
					if (serviceNamesArray[s].toLowerCase() == serviceNamesArray[t].toLowerCase())
					{
						Ext.Array.splice(serviceNamesArray,serviceNamesArray.lastIndexOf(serviceNamesArray[t]),1);
					}
				}
				var map = {'serviceName': serviceNamesArray[s]};
				serviceNamesStoreArr.push(map);
			}
		}
		Ext.create('SpecificTestConfiguration.view.WinServicesConfiguration').show();
		var serviceGrid = Ext.getCmp('serviceNamesGrid');
		serviceGrid.getStore().clearFilter();
		serviceGrid.getStore().loadRawData(serviceNamesStoreArr);

		if(Ext.isEmpty(serviceNamesStoreArr))
		{
			Ext.getCmp('winServiceSearchTrigger').disable();
			Ext.getCmp('updateService').disable(true);
			Ext.getCmp('DeleteOver').hide();
		}
	},
	updateServices: function(response,fromBtn) {
		firstClick = true;
		Ext.getCmp('winServiceSearchTrigger').reset();
		if(fromBtn != undefined && fromBtn == 'fromButton')
		{
			showMsgWindow = true;
			response = testInterViews.checkBeforeAdding("",true);
		}
		if(response)
		{
			var result = configuredServices.toString();
			this.callSessionAttribute(result);
			firstgetService = true;
			if (!Ext.isEmpty(result) && result != undefined)
			{
				Ext.getCmp('serviceName').setValue(result);
			}
			else
			{
				Ext.getCmp('serviceName').setValue('$unconfigured');
			}
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
			Ext.getCmp('winservicesconfiguration').destroy();
		}
	},
	callSessionAttribute: function(result) {
			Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/setSessionAttributeJson.jsp',
			method: 'POST',
			params: {'whereFrom':'serviceConfig','attributeName':'paramValue','attributeValue':filterEncode(result)},
			success: function( response )
			{
			}
		});
	},
	checkBeforeAdding: function(serviceName,isDiscover) {
		var allowToUpdate = true;
		var credentialValue = "";
		var parameters="";
		var tcKeywords="";
		var doubleQuotesParams="";
		var allowedParams = publicJson.hiddenObj['allowedParams'];
		var strTcKeywords = publicJson.hiddenObj['strTcKeywords'];
		var strDoubleQuotesParams = publicJson.hiddenObj['strDoubleQuotesParams'];
		configuredServices = new Array();
		finalArray = new Array();
		if(!Ext.isEmpty(allowedParams))
		{
			parameters = allowedParams;
		}

		if(!Ext.isEmpty(strTcKeywords))
		{
			tcKeywords = strTcKeywords;
			tcKeywords = tcKeywords.split(",");
		}

		if(!Ext.isEmpty(strDoubleQuotesParams))
		{
			doubleQuotesParams = strDoubleQuotesParams;
			doubleQuotesParams = doubleQuotesParams.split(",");
		}
		var paramId = "serviceName";
		var checkHyphenValidation = true;
		for(var z=0;z<doubleQuotesParams.length;z++)
		{
			if(doubleQuotesParams[z] == paramId.toLowerCase())
			{
				checkHyphenValidation = false;
				break;
			}
		}
		var serviceNamesStr = serviceNamesArray.toString();
		if (!Ext.getCmp(serviceNamesStr) && serviceNamesStr.indexOf(',') != -1)
		{
			configuredServices = serviceNamesStr.split(',');
		}
		else if(!Ext.isEmpty(serviceNamesStr))
		{
			configuredServices[0] = serviceNamesStr;
		}
		if(isDiscover)
		{
			pageTitle = winServTitle;
			finalArray = configuredServices;
		}
		else
		{
			pageTitle = Ext.getCmp('egservicemodification').title;
			var isExists = false;
			for(var i=0;i<configuredServices.length;i++)
			{
				if(!isNewService && i == currentRow)
					continue;
				sName = configuredServices[i];
				if(sName.toLowerCase() == serviceName.toLowerCase())
				{
					isExists = true;
					break;
				}
			}
			if(isExists)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alreadyConfigMsgPart1+" '"+serviceName+"' "+alreadyConfigMsgPart2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						 Ext.getCmp('service_name').focus(false,200);
					}
				});
				return false;
			}
			finalArray.push(serviceName);
		}
		for(var i=0;i<finalArray.length;i++)
		{
			configServiceName = finalArray[i];
			if (Ext.isEmpty(configServiceName))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: blankServiceMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editService("",configServiceName.toString());
						else
							Ext.getCmp('service_name').focus(false,200);
					}
				});
				allowToUpdate = false;
				break;
			}
			allowToUpdate = isAllowDoubleByte(configServiceName,winServTitle,'service','service_name',isDiscover,serviceErrMsg1,false);
			if(!allowToUpdate)
				break;
			if(isDiscover)
			{
				for(var j=i+1;j<finalArray.length;j++)
				{
					var configServiceName_2 = finalArray[j];
					if(Ext.isEmpty(configServiceName_2))
					{
						continue;
					}
					if(configServiceName.toLowerCase() == configServiceName_2.toLowerCase())
					{
						Ext.Msg.show({
							title: winServTitle,
							msg: addedSameService+" '"+configServiceName+"'. "+addedSameService1,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								return false;
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
			if(configServiceName.indexOf("$") > -1)
			{
				var parameter=parameters.split(",");
				var parameterFound=false;
				var tcKeyWordCaught=false;
				for (parameterCount=0;parameterCount<parameter.length;parameterCount++ )
				{
					temp_parameter=(parameter[parameterCount].toUpperCase());
					if ((temp_parameter.replace(/^\s*/, '').replace(/\s*$/, ''))==(paramId).toUpperCase())
					{
						for (var z=0;z<tcKeywords.length;z++)
						{
							if (tcKeywords[z].toLowerCase() == configServiceName.toLowerCase())
							{
								tcKeyWordCaught = true;
								break;
							}
						}
						parameterFound=true;
						break;
					}
				}

				if(!parameterFound && paramId.toLowerCase() != "filter")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editService("",configServiceName.toString());
							else
								Ext.getCmp('service_name').focus(false,200);
						}
					});
					allowToUpdate = false;
					break;
				}

				if (tcKeyWordCaught)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: _tcKeyword,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editService("",configServiceName.toString());
							else
								Ext.getCmp('service_name').focus(false,200);
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			if(!checkblank(configServiceName))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editService("",configServiceName.toString());
						else
							Ext.getCmp('service_name').focus(false,200);
					}
				});
				allowToUpdate = false;
				break;
			}
			else
			{
				if(checkHyphenValidation && !checkhyphen(configServiceName, paramId.toLowerCase()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: _checkhyphen,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editService("",configServiceName.toString());
							else
								Ext.getCmp('service_name').focus(false,200);
						}
					});
					allowToUpdate = false;
					break;
				}
			}

			if(paramId.toLowerCase() == "servicename")
			{
				if(!checkspecialExt(configServiceName,"|\""))
				{
					if(showMsgWindow)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: _checkspecial ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								if(isDiscover)
								{
									testInterViews.editService("",configServiceName.toString());
								}
								else
									Ext.getCmp('service_name').focus(false,200);
							}
						});
					}
					else if(isDiscover)
					{
						testInterViews.editService("",configServiceName.toString());
					}
					allowToUpdate = false;
					break;
				}

				if(!Ext.isEmpty(configServiceName) && configServiceName.indexOf(",") != -1)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: 'Comma(s) are not allowed in service',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editService("",configServiceName.toString());
							else
								Ext.getCmp('service_name').focus(false,200);
						}
					});
					allowToUpdate = false;
					break;
				}
			}
		}
		return allowToUpdate;
	},
	getSite: function() {
		var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Trying to get list of websites from the agent...'});
		myDDMask.show();
		var hostname = Ext.getCmp('host').getValue();
		var port = Ext.getCmp('port').getValue();
		var componentName = Ext.getCmp('componentName').getValue();
		var dispName = componentName;
		if (!Ext.isEmpty(componentName) && componentName.lastIndexOf(":NULL") != -1)
		{
			dispName = componentName.substring(0,componentName.lastIndexOf(":NULL"));
		}
		var url = 'SpecificTestConfiguration/data/siteListJson.jsp?componentName='+encodeURIComponent(componentName)+'&host='+hostname+'&port='+port+'&dummy=dummy';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 60000000,
			success: function( response )
			{
				myDDMask.hide();
				var jsonText = response.responseText;
				var sitenameJson = Ext.decode(jsonText);
				if( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					if(sitenameJson.timedout)
					{
						Ext.Msg.show({
							title: 'Site Information',
							msg: sitenameJson.timeOutLabel,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
					else if(sitenameJson.showAlertMessage)
					{
						Ext.Msg.show({
							title: 'Site Information',
							msg: sitenameJson.alertMessasge,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
					else
					{
						Ext.create('SpecificTestConfiguration.view.SiteDetailedConfiguration').show();
						Ext.getCmp('sitenameContainer').show();
						Ext.getCmp('buttonContainer').show();
						Ext.getCmp("sitename_popup").clearValue();
						Ext.getCmp('sitename_popup').getStore().clearFilter(true);
						Ext.getCmp('sitename_popup').getStore().loadRawData(sitenameJson['sitenames']);
						Ext.getCmp('sitename_popup').setValue("-1");
					}
				}
			},
			failue: function(response)
			{
				myDDMask.hide();
			}
		});
	},
	getServices: function() {
		Ext.create('SpecificTestConfiguration.view.ServiceDetailedConfiguration').show();
		var myDDMask = new Ext.LoadMask(Ext.getCmp('servicedetailedconfiguration'), {msg: 'Trying to collect running services information from agent...'});
		myDDMask.show();
		Ext.getCmp('winServiceViewSearchTrigger').hide();
		Ext.getCmp('serviceLabelContainer').hide();
		configServices = "";
		var componentName = Ext.getCmp('componentName').getValue();
		var dispName = componentName;
		if (!Ext.isEmpty(componentName) && componentName.lastIndexOf(":NULL") != -1)
		{
			dispName = componentName.substring(0,componentName.lastIndexOf(":NULL"));
		}
		var configServiceArray = new Array();
		if(!Ext.isEmpty(serviceNamesArray) && serviceNamesArray.indexOf(',') != -1)
		{
			configServiceArray = configServiceArray.split(',');
		}
		else
		{
			configServiceArray[0] = serviceNamesArray;
		}
		for(var s=0;s<serviceNamesArray.length;s++)
		{
			configServiceName = serviceNamesArray[s];
			if(configServiceName.length == 0)
				continue;
			if(configServices.length==0)
				configServices = configServiceName;
			else
				configServices += "," + configServiceName;
		}
		var isNoConfig = Ext.isEmpty(serviceNamesArray);
		var url = 'SpecificTestConfiguration/data/winServicesListJson.jsp?componentName='+encodeURIComponent(componentName)+'&s_val='+encodeURIComponent(filterEncode(configServices))+"&dummy=dummy";
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 60000000,
			params: {
				'noConf': isNoConfig
			},
			success: function( response )
			{
				var jsonText = response.responseText;
				publicServiceJson = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					if(publicServiceJson.timedout || publicServiceJson.alreadyConfigured )
					{
						Ext.getCmp('noServiceContainer').show();
						Ext.getCmp('noServiceLabel').update(publicServiceJson.timedoutOrAlreadyConfigLabel);
						Ext.getCmp('submitServiceDet').hide();
						Ext.getCmp('serviceselect').hide();
					}
					else
					{
						Ext.getCmp('serviceLabelContainer').show();
						Ext.getCmp('winServiceViewSearchTrigger').show();
						Ext.getCmp('noServiceContainer').hide();
						Ext.getCmp('submitServiceDet').show();
						Ext.getCmp('serviceselect').show();
						var dataArr = publicServiceJson['winSerListArr'];
						Ext.getCmp('servicetitle').setText(runningServices+' '+dispName);
						Ext.getCmp('serviceselect').getStore().loadRawData('');
						Ext.getCmp('serviceselect').getStore().loadRawData(dataArr);
					}
				}
				myDDMask.hide();
			}
		});
	},
	winServicesViewSearch: function() {
		var searchServiceStr = Ext.getCmp('winServiceViewSearchTrigger').getValue();
		var noServiceContainer = Ext.getCmp('noServiceContainer');
		if (searchServiceStr == "" || searchServiceStr.length == 0)
		{
			Ext.get('Trigger_0').setStyle('display','none');
			Ext.get('Trigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('Trigger_1').setStyle('display','none');
			Ext.get('Trigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url : 'SpecificTestConfiguration/data/winServicesListJson.jsp?',
			params :
			{
				'searchValue' : filterEncode(searchServiceStr),
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					var serviceList = jsonData['winSerListArr'];
					if(serviceList != null && serviceList != '')
					{
						noServiceContainer.hide();
						Ext.getCmp('serviceselect').show();
						Ext.getCmp('submitServiceDet').setDisabled(false);
						Ext.getCmp('serviceselect').store.removeAll();
						Ext.getCmp('serviceselect').getStore().loadRawData(serviceList);
					}
					else
					{
						var  noSearchDataLabel = {
						xtype: 'label',
						id: 'noSearchDataLabel',
						name: 'noSearchDataLabel',
						html: '<table align="center"><tr><td align="center" height="217"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noProcessFound+'.</td></tr></table></td></tr></table>'
						};
						noServiceContainer.show();
						noServiceContainer.removeAll();
						Ext.getCmp('serviceselect').hide();
						noServiceContainer.add(noSearchDataLabel);
						Ext.getCmp('submitServiceDet').setDisabled(true);
					}
				}
			}
		});
	},
	submitservices: function() {
		firstClick = true;
		var submitToMain = Ext.getCmp('serviceselect').getValue();
		var strSubmitToMain = submitToMain;
		var submitToMain = submitToMain.toString().trim();
		if (submitToMain.length <=1)
		{
			strSubmitToMain = submitToMain.toString().trim();
		}

		if (Ext.isEmpty(strSubmitToMain) || strSubmitToMain == undefined )
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectWinName,
				buttons: Ext.Msg.OK,
				info: 'iconExclamation'
			});
			return false;
		}
		var serviceNamesArr = new Array();
		var serviceNamesStoreArr = new Array();
		if (!Ext.isEmpty(submitToMain) && submitToMain.indexOf(',') != -1)
		{
			serviceNamesArr = submitToMain.split(',');
		}
		else
		{
			serviceNamesArr[0] = submitToMain;
		}
		
		if (!Ext.isEmpty(serviceNamesArr) && serviceNamesArr != undefined)
		{
			for (var s=0;s<serviceNamesArr.length;s++)
			{
				serviceNamesArray.push(serviceNamesArr[s]);
			}
		}
		if(!Ext.getCmp(serviceNamesArray) && serviceNamesArray != undefined)
		{
			for (var s=0;s<serviceNamesArray.length;s++)
			{
				if(serviceNamesArray[s] == '$unconfigured')
				{
					Ext.Array.remove(serviceNamesArray,'$unconfigured');
					continue;
				}
				if(Ext.isEmpty(serviceNamesArray[s]))
				{
					Ext.Array.remove(serviceNamesArray,serviceNamesArray[s]);
					continue;
				}
				var map = {'serviceName': serviceNamesArray[s]};
				serviceNamesStoreArr.push(map);
			}
		}
		var serviceGridObj = Ext.getCmp('serviceNamesGrid');
		this.unCheckHeaderCheckBox(serviceGridObj);
		Ext.suspendLayouts();
		serviceGridObj.getStore().removeAll();
		serviceGridObj.getStore().loadRawData(serviceNamesStoreArr);
		Ext.resumeLayouts(true);
		if(!Ext.isEmpty(serviceNamesStoreArr))
		{
			Ext.getCmp('updateService').enable();
			Ext.getCmp('DeleteOver').show();
			Ext.getCmp('winServiceSearchTrigger').enable();
		}

		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=winservicesconfiguration',
			method:'POST'
		});
		Ext.getCmp('servicedetailedconfiguration').destroy();
		Ext.getCmp('winServiceSearchTrigger').reset();
		firstClick = true;
	},// Win Service ends
	winServiceConfigs_pr: function()
	{
		firstClick = true;
		Ext.create('SpecificTestConfiguration.view.MinMaxValues').show();
		noServiceConfig = 'false';
		var prMeasureArray = publicJson.prMeasureArray;
		if(prMeasureArray != null && prMeasureArray != undefined && prMeasureArray.length>0)
		{
			inputsService = 2;
			var mainServiceForm = Ext.getCmp('ratingMeasuresContr');
			Ext.suspendLayouts();
			for(var k =0;k<prMeasureArray.length;k++ )
			{
				var prMeasureData = publicJson['prMeasureObject'][prMeasureArray[k]];
				addServiceConf_pr(prMeasureArray[k],prMeasureData,publicJson.prMeasureDispnameArray[k]);
			}
			Ext.resumeLayouts(true);
			mainServiceForm.doLayout();
		}
		var minmaxvalues_all = Ext.getCmp('min_max_values').getValue();
		if(minmaxvalues_all.indexOf('~')>0)
		{
			var map = new Ext.util.HashMap();
			var textAreaArray = minmaxvalues_all.split("~~");
			for(var k =0;k<textAreaArray.length;k++)
			{
				var rowArray = textAreaArray[k].split("~");
				if(rowArray.length==5)
				{
					var mkey = rowArray[0]+':'+rowArray[1]+':'+rowArray[2];
					var mkeyvalue = rowArray[3]+':'+rowArray[4];
					map.add(mkey,mkeyvalue);
				}
			}
			for (var k =0;k<prMeasureArray.length;k++)
			{
				var gridid = prMeasureArray[k];
				var gridStore = Ext.getCmp(gridid).getStore();
				for(var i=0;i<gridStore.getCount();i++)
				{
					var prm_name = gridStore.getAt(i).get('pr_measure_name');
					var associatedTest = gridStore.getAt(i).get('associated_test_name');
					var associatedMeasure = gridStore.getAt(i).get('associated_measure_name');
					var minimumThreshold = gridStore.getAt(i).get('associated_measure_min_threshold');
					var maximumThreshold = gridStore.getAt(i).get('associated_measure_max_threshold');
					var mkey = Ext.util.Format.trim(prm_name)+':'+Ext.util.Format.trim(associatedTest)+':'+Ext.util.Format.trim(associatedMeasure);
					if(map.containsKey(mkey))
					{
						var mkeyvalue = map.get(mkey);
						min_min_values = mkeyvalue.substring(0,mkeyvalue.indexOf(':'));
						if(min_min_values=='-1') min_min_values='None';
						max_max_values = mkeyvalue.substring(mkeyvalue.indexOf(':')+1);
						if(max_max_values=='-1') max_max_values='None';
						gridStore.getAt(i).set('associated_measure_min_threshold',min_min_values);
						gridStore.getAt(i).set('associated_measure_max_threshold',max_max_values);
					}
				}
			}
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=winservicesconfiguration',
			method: 'POST',
			async: false
		});
	},
	updateServices_pr: function(btn)
	{
		firstClick = true;
		var result="";
		var checkWithVar = this.checkBeforeAdding_pr();
		if(checkWithVar)
		{
			var prMeasureArray = publicJson.prMeasureArray;
			if(prMeasureArray != null && prMeasureArray != undefined && prMeasureArray.length>0)
			{
				for (var k =0;k<prMeasureArray.length;k++ )
				{
					var gridid = prMeasureArray[k];
					var gridObj = Ext.getCmp(gridid);
					var gridPlugin = gridObj.getPlugin(gridid);
					Ext.getCmp(gridid).getSelectionModel().selectAll();
					var selectedObj = Ext.getCmp(gridid).getSelectionModel();
					var gridStore = Ext.getCmp(gridid).getStore();
					for(var i = 0;i<gridStore.getCount();i++)
					{
						var prm_name = gridStore.getAt(i).get('pr_measure_name');
						var associatedTest = gridStore.getAt(i).get('associated_test_name');
						var associatedMeasure = gridStore.getAt(i).get('associated_measure_name');
						var minimumThreshold = gridStore.getAt(i).get('associated_measure_min_threshold');
						var maximumThreshold = gridStore.getAt(i).get('associated_measure_max_threshold');
						if(minimumThreshold.toLowerCase()=="none")
						{
							minimumThreshold="-1";
						}
						if(maximumThreshold.toLowerCase()=="none")
						{
							maximumThreshold="-1";
						}
						result+="~~"+Ext.util.Format.trim(prm_name)+"~"+Ext.util.Format.trim(associatedTest)+"~"+Ext.util.Format.trim(associatedMeasure)+"~"+Ext.util.Format.trim(minimumThreshold)+"~"+Ext.util.Format.trim(maximumThreshold);
					}
				}
			}
			if(result.length>0)
			{
				result=result.substring(2);
			}
			Ext.getCmp('minmaxvalues').destroy();
			firstgetService = true;
			if (!Ext.isEmpty(result) && result != undefined)
			{
				Ext.getCmp('min_max_values').setValue(result);
			}
			else
			{
				Ext.getCmp('min_max_values').setValue('none');
			}
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	checkBeforeAdding_pr: function()
	{
		var prMeasureArray = publicJson.prMeasureArray;
		if(prMeasureArray != null && prMeasureArray != undefined && prMeasureArray.length>0)
		{
			for (var k =0;k<prMeasureArray.length;k++ )
			{
				var gridid = prMeasureArray[k];
				var gridObj = Ext.getCmp(gridid);
				var gridPlugin = gridObj.getPlugin(gridid);
				var gridStore = gridObj.getStore();
				for(var i = 0;i<gridStore.getCount();i++)
				{
					//if(selectedObj.isSelected(gridStore.getAt(i)))
					{
						var minimumThres = gridStore.getAt(i).get('associated_measure_min_threshold');
						var maximumThres = gridStore.getAt(i).get('associated_measure_max_threshold');

						if(minimumThres.indexOf(' ')>-1)
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert28,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							return false;
						}
						if(maximumThres.indexOf(' ')>-1)
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert29,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							return false;
						}
						if(minimumThres=='-1')
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert30,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							allowUpdate=false;
							return false;
						}
						if(maximumThres=='-1')
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert31,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							allowUpdate=false;
							return false;
						}
						if(minimumThres.trim().toLowerCase()=="none")
						{
							minimumThres="-1";
						}
						if(maximumThres.trim().toLowerCase()=="none")
						{
							maximumThres="-1";
						}
						if(minimumThres=='-1' && maximumThres=='-1')
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert27,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							allowUpdate=false;
							return false;
						}
						if(minimumThres=='-/-/-' || !correctFormat(minimumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert32,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							return false;
						}
						else if (!checkValidValue_rx(minimumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: minimumValuesAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							return false;
						}
						else if(!checkAscendingOrder(minimumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: minThreshAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							return false;
						}
						else if((returnCode=validateTargetValues(minimumThres,true))!='0')
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: returnCode,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 5});
								}
							});
							return false;
						}

						if(maximumThres=='-/-/-' || !correctFormat(maximumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: alert33,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							return false;
						}
						else if (!checkValidValue_rx(maximumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: maximumValuesAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							return false;
						}
						else if(!checkDescendingOrder(maximumThres))
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: maxThreshAlert,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							return false;
						}
						else if((returnCode=validateTargetValues(maximumThres,false))!='0')
						{
							Ext.Msg.show({
								title: alertTitle,
								msg: returnCode,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									gridPlugin.startEditByPosition({row: i,column: 6});
								}
							});
							return false;
						}
					}
				}
			}
		}
		return true;
	},
	configVMLogDisplay: function() {
		Ext.create('SpecificTestConfiguration.view.EgVmLogDisplay').show();
		var cName = publicJson['remoteAgent'];
		var type = publicJson['vmType'];
		var phyServer = publicJson['componentName'];
		var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'The log file is being loaded. This may take a few minutes...'});
		myDDMask.show();

		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgVmLogDisplayJson.jsp?componentName='+encodeURIComponent(cName)+'&file=eg_vm.ini&vmtable=true&from=testconfig&phyServer='+encodeURIComponent(phyServer)+'&type='+encodeURIComponent(type),
			method:'POST',
			asynchronous: false,
			//scope: this,
			timeout: 10000000000,
			success:function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					myDDMask.hide();
					var type = jsonData['type'];
					var componentViewGridArr = jsonData['componentViewGridArr'];
					var componentViewGridTitle = jsonData['componentViewGridTitle'];
					if (componentViewGridTitle != null && !Ext.isEmpty(componentViewGridTitle))
					{
						Ext.getCmp('egvmlogdisplay').setTitle(componentViewGridTitle);
					}

					if (componentViewGridArr != null && !Ext.isEmpty(componentViewGridArr))
					{
						Ext.getCmp('noVmDetailsContainer').hide();
						Ext.getCmp('hyperComponentViewGrid').hide();
						Ext.getCmp('xenComponentViewGrid').hide();
						Ext.getCmp('esxComponentViewGrid').hide();
						var typeOfHeaders = jsonData[type];
						if (type != null && !Ext.isEmpty(type) && type == 'esx')
						{
							if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
							{
								Ext.getCmp('esx1').setText(typeOfHeaders[0]);
								Ext.getCmp('esx2').setText(typeOfHeaders[1]);
								Ext.getCmp('esx3').setText(typeOfHeaders[2]);
								Ext.getCmp('esx4').setText(typeOfHeaders[3]);
								Ext.getCmp('esx5').setText(typeOfHeaders[4]);
								Ext.getCmp('esx6').setText(typeOfHeaders[5]);
								Ext.getCmp('esx7').setText(typeOfHeaders[6]);
							}
							Ext.getCmp('esxComponentViewGrid').show();
							Ext.getCmp('esxComponentViewGrid').getStore().removeAll();
							Ext.getCmp('esxComponentViewGrid').getStore().loadRawData(componentViewGridArr);
						}
						else if (type != null && !Ext.isEmpty(type) && (type == 'xen' || type == 'Xen'))
						{
							if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
							{
								Ext.getCmp('xen1').setText(typeOfHeaders[0]);
								Ext.getCmp('xen2').setText(typeOfHeaders[1]);
								Ext.getCmp('xen3').setText(typeOfHeaders[2]);
								Ext.getCmp('xen4').setText(typeOfHeaders[3]);
								Ext.getCmp('xen5').setText(typeOfHeaders[4]);
							}
							Ext.getCmp('xenComponentViewGrid').show();
							Ext.getCmp('xenComponentViewGrid').getStore().removeAll();
							Ext.getCmp('xenComponentViewGrid').getStore().loadRawData(componentViewGridArr);
						}
						else if (type != null && !Ext.isEmpty(type) && type == 'hyper')
						{
							if(typeOfHeaders != null && !Ext.isEmpty(typeOfHeaders))
							{
								Ext.getCmp('hyper1').setText(typeOfHeaders[0]);
								Ext.getCmp('hyper2').setText(typeOfHeaders[1]);
								Ext.getCmp('hyper3').setText(typeOfHeaders[3]);
								Ext.getCmp('hyper4').setText(typeOfHeaders[2]);
							}
							Ext.getCmp('hyperComponentViewGrid').show();
							Ext.getCmp('hyperComponentViewGrid').getStore().removeAll();
							Ext.getCmp('hyperComponentViewGrid').getStore().loadRawData(componentViewGridArr);
						}
					}
					else
					{
						NoDataMsg = jsonData['NoDataMsg'];
						Ext.getCmp('xenComponentViewGrid').hide();
						Ext.getCmp('esxComponentViewGrid').hide();
						Ext.getCmp('hyperComponentViewGrid').hide();
						Ext.getCmp('noVmDetailsContainer').show();
					}
				}
			},
			failure: function(response) {
				myDDMask.hide();
			}
		});
	},

	processConfigs: function() { //Process Config
		submitFrmConcise = false;
		if(!Ext.isEmpty(Ext.getCmp('wide2')) && Ext.getCmp('wide2').getValue())
		{
			submitFrmConcise = true;
		}
		var processNames = Ext.getCmp('process').getValue();
		processNamesArray = new Array();
		var tempProcessNamesArray = new Array();
		var processNamesArrayStore = new Array();
		if (!Ext.isEmpty(processNames) && processNames.indexOf(',') != -1)
		{
			tempProcessNamesArray = processNames.split(',');
		}
		else
		{
			tempProcessNamesArray[0] = processNames;
		}
		if(!Ext.isEmpty(tempProcessNamesArray) && tempProcessNamesArray != undefined)
		{
			for(var z=0;z<tempProcessNamesArray.length;z++)
			{
				var fullPattern = tempProcessNamesArray[z];
				if(Ext.isEmpty(fullPattern) || fullPattern == '$name:$pattern' || fullPattern == '$processName:$processPattern')
				{
					continue;
				}
				var name = fullPattern.indexOf(":")>-1?fullPattern.substring(0,fullPattern.indexOf(":")):fullPattern;
				var pattern = fullPattern.indexOf(":*")>-1?fullPattern.substring(fullPattern.indexOf(":")+2,fullPattern.lastIndexOf("*")):fullPattern.indexOf(":")>-1?fullPattern.substring(fullPattern.indexOf(":")+1):"";
				processNamesArray.push(name+":"+pattern);
			}
		}
		if (!Ext.isEmpty(processNamesArray) && processNamesArray != undefined)
		{
			for (p=0;p<processNamesArray.length;p++)
			{
				if(Ext.isEmpty(processNamesArray[p]))
				{
					Ext.Array.remove(processNamesArray,processNamesArray[p]);
					continue;
				}
				var process = processNamesArray[p];
				var processInGrid = process.indexOf(":")>-1?process.substring(0,process.indexOf(":")):process;
				var patternInGrid = process.indexOf(":")>-1?process.substring(process.indexOf(":")+1):"";
				var map = {'processName':processInGrid,'processPattern':patternInGrid};
				processNamesArrayStore.push(map);
			}
		}
		Ext.create('SpecificTestConfiguration.view.ProcessConfiguration').show();
		var processGridObj = Ext.getCmp('processNamesGrid');
		processGridObj.getStore().clearFilter();
		processGridObj.getStore().loadRawData(processNamesArrayStore);

		if(Ext.isEmpty(processNamesArray))
		{
			Ext.getCmp('processSearchTrigger').disable();
			Ext.getCmp('updateProcessPatt').disable(true);
			Ext.getCmp('DeleteOver').hide();
		}
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=processconfiguration',
			method: 'POST',
			async: false
		});
	},
	processesViewSearch: function() {
		var searchProcessStr = Ext.getCmp('processViewSearchTrigger').getValue();
		var noProcessContainer = Ext.getCmp('noProcessContainer');
		if (searchProcessStr == "" || searchProcessStr.length == 0)
		{
			Ext.get('Trigger_0').setStyle('display','none');
			Ext.get('Trigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('Trigger_1').setStyle('display','none');
			Ext.get('Trigger_0').setStyle('display','block');
		}
		var viewType = Ext.getCmp('processconciseconfiguration').title;
		var objID = "";
		if(viewType == 'Detailed View')
		{
			viewType = 'detailed';
			objID = 'processdetailedsel';
		}
		else if(viewType == 'Concise View')
		{
			viewType ='concised';
			objID = 'processconcisesel';
		}

		Ext.Ajax.request({
			url : 'SpecificTestConfiguration/data/agentProcessListJson.jsp?',
			params :
			{
				'searchValue' : filterEncode(searchProcessStr),
				's_wide' : viewType
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					var processList = jsonData['absPathArr'];
					if(processList != null && processList != '')
					{
						noProcessContainer.hide();
						Ext.getCmp(objID).show();
						Ext.getCmp('submitProcessConc').setDisabled(false);
						Ext.getCmp(objID).store.removeAll();
						Ext.getCmp(objID).getStore().loadRawData(processList);
					}
					else
					{
						var  noSearchDataLabel = {
						xtype: 'label',
						id: 'noSearchDataLabel',
						name: 'noSearchDataLabel',
						html: '<table align="center"><tr><td align="center" height="337"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noProcessFound+'.</td></tr></table></td></tr></table>'
						};
						noProcessContainer.show();
						noProcessContainer.removeAll();
						Ext.getCmp(objID).hide();
						noProcessContainer.add(noSearchDataLabel);
						Ext.getCmp('submitProcessConc').setDisabled(true);
					}
				}
			}
		});
	},
	winProcessSearch: function(){
		searchStr = Ext.getCmp('processSearchTrigger').getValue();
		searchList = new Array();
		var searchString = searchStr.split(' ');
		for(var s=0;s<searchString.length;s++)
		{
			var str = searchString[s].trim();
			if(str != "")
				searchList.push(str);
		}
		var userdetailsgrid = Ext.getCmp('processNamesGrid');
		userdetailsgrid.show();
		Ext.getCmp('updateProcessPatt').enable();
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
			userdetailsgrid.getStore().clearFilter();
			totalRecords = userdetailsgrid.getStore().getCount();
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
			userdetailsgrid.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var name = item.get('processName');
					var pattern = item.get('processPattern');
					if(doesExist(searchList,name+pattern))
					{
						return true;
					}
				}
			});
			userdetailsgrid.getStore().suspendEvents(true);
			userdetailsgrid.getStore().filter(userFilter);
			userdetailsgrid.getStore().resumeEvents();
			totalRecords = userdetailsgrid.getStore().getCount();
		}
		if(totalRecords == 0)
		{
			Ext.getCmp('updateProcessPatt').disable(true);
			Ext.getCmp('DeleteOver').hide();
			userdetailsgrid.getView().emptyText = '<table align="center"><tr><td align="center" height="310"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noProcessFound+'</td></tr></table></td></tr></table>';
			userdetailsgrid.getView().refresh();
		}
		else
		{
			Ext.getCmp('DeleteOver').show();
		}
	},
	removeSeletedProcess: function(rowIndex)
	{
		if(Ext.isEmpty( Ext.getCmp('processSearchTrigger').getValue()))
		{
			totalRecords = Ext.getCmp('processNamesGrid').store.totalCount;
		}
		var grid = Ext.getCmp('processNamesGrid').getSelectionModel().getSelection();
		var processNamesStoreArr = new Array();
		var deletePageMsg = '';
		var isSelectedDelete = false;
		if(Ext.isEmpty(rowIndex) && rowIndex == undefined)
		{
			if(grid.length == 0)
			{
				Ext.Msg.show({
					title: processConfTitle,
					msg: notSelectMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						return false;
					}
				});
				return false;
			}
			isSelectedDelete = true;
			deletePageMsg = confirmDeleteMsg3;
		}
		else
		{
			var name = Ext.getCmp('processNamesGrid').getStore().getAt(rowIndex).get('processName');
			var pattern = Ext.getCmp('processNamesGrid').getStore().getAt(rowIndex).get('processPattern');
			fullProcessPattern = name+":"+pattern;
			deletePageMsg = confirmDeleteMsg4+" '"+name+"'?";
		}
		Ext.Msg.show ({
			title: processConfTitle,
			msg: deletePageMsg,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					if(isSelectedDelete)
					{
						for(var z=0;z<grid.length;z++)
						{
							var values = grid[z];
							var name = values.get('processName');
							var pattern = values.get('processPattern');
							var selectedProcessName = name+":"+pattern;
							if(selectedProcessName != null)
							{
								Ext.Array.remove(processNamesArray,selectedProcessName);
								totalRecords--;
							}
						}
					}
					else
					{
						Ext.Array.remove(processNamesArray,fullProcessPattern);
						totalRecords--;
					}
					if(!Ext.isEmpty(processNamesArray) && processNamesArray != undefined)
					{
						for(var z=0;z<processNamesArray.length;z++)
						{
							var process = processNamesArray[z];
							var name = process.substring(0,process.indexOf(":"));
							var pattern = process.substring(process.indexOf(":")+1);
							var map = {'processName': name,'processPattern': pattern};
							processNamesStoreArr.push(map);
						}
					}
					var processGridObj = Ext.getCmp('processNamesGrid');
					Ext.suspendLayouts();
					processGridObj.getStore().removeAll();
					processGridObj.getStore().loadRawData(processNamesStoreArr);
					Ext.resumeLayouts(true);
					if(totalRecords == 0)
					{
						Ext.getCmp('processSearchTrigger').reset();
						processGridObj.getSelectionModel().toggleUiHeader(false);
					}
					if(Ext.isEmpty(processNamesArray))
					{
						Ext.getCmp('updateProcessPatt').disable(true);
						Ext.getCmp('processSearchTrigger').disable();
						Ext.getCmp('processSearchTrigger').reset();
						Ext.getCmp('DeleteOver').hide();
						processGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="310"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noconfProcess+'</td></tr></table></td></tr></table>';
						processGridObj.getView().refresh();
					}
				}
			}
		});
	},
	addNewProcess: function(){
		isNewProcess = true;
		isManualEdit = true;
		this.showModificationWindow(processConfTitle,'egprocessmodification','process',450,10,'10 10 5 10','process_name',processNameLabel,false);
		processWidget = Ext.getCmp('egprocessmodification');
		Ext.getCmp('process_name').focus(false,200);
	},
	editProcess: function(rowIndex,process,focusToName,curIndex){
		curentIndex = -1;
		if(curIndex != undefined)
		{
			curentIndex = curIndex;
		}
		isNewProcess = false;
		if(!Ext.isEmpty(rowIndex))
		{
			isManualEdit = true;
			processName = Ext.getCmp('processNamesGrid').getStore().getAt(rowIndex).get('processName');
			processPattern = Ext.getCmp('processNamesGrid').getStore().getAt(rowIndex).get('processPattern');
		}
		else if(!Ext.isEmpty(process))
		{
			isManualEdit = false;
			processName = process.indexOf(":")>-1?process.substring(0,process.indexOf(":")):process;
			processPattern = process.indexOf(":")>-1?process.substring(process.indexOf(":")+1):"";
		}
		currentRow = processNamesArray.indexOf(processName+":"+processPattern);
		this.showModificationWindow(processConfTitle,'egprocessmodification','process',450,10,'10 10 5 10','process_name',processNameLabel,false);
		processWidget = Ext.getCmp('egprocessmodification');
		Ext.getCmp('process_name').setValue(processName);
		Ext.getCmp('process_pattern').setValue(processPattern);
		if(focusToName)
			Ext.getCmp('process_name').focus(false,200);
		else
			Ext.getCmp('process_pattern').focus(false,200);
	},
	modifyProceses: function(){
		if(isManualEdit)
			showMsgWindow = true;
		newProcessName = Ext.getCmp('process_name').getValue();
		newProcessPattern = Ext.getCmp('process_pattern').getValue();
		var checkStatus = this.validateBeforeAdding(newProcessName+":"+newProcessPattern,false);
		if(checkStatus)
		{
			if(isNewProcess)
			{
				var searchComp = Ext.getCmp('processSearchTrigger');
				if(!Ext.isEmpty(searchComp.getValue()))
				{
					searchComp.reset();
				}
				var newProcess = newProcessName+":"+newProcessPattern;
				processNamesArray.push(newProcess);
			}
			else
			{
				var existingProcess = processName+":"+processPattern;
				var newProcess = newProcessName+":"+newProcessPattern;
				if(curentIndex != -1)
				{
					processNamesArray.splice(curentIndex,1,newProcess);
				}
				else
				{
					processNamesArray.splice(processNamesArray.indexOf(existingProcess),1,newProcess);
				}
			}
			var processNamesStoreArr = new Array();
			if(!Ext.isEmpty(processNamesArray) && processNamesArray != undefined)
			{
				for(var z=0;z<processNamesArray.length;z++)
				{
					var process = processNamesArray[z];
					if(Ext.isEmpty(process) || process == '$name:$pattern')
					{
						Ext.Array.remove(processNamesArray,process);
						continue;
					}
					var name = process.substring(0,process.indexOf(":"));
					var pattern = process.substring(process.indexOf(":")+1);
					var map = {'processName': name,'processPattern': pattern};
					processNamesStoreArr.push(map);
				}
			}
			var processNamesGrid = Ext.getCmp('processNamesGrid');
			this.unCheckHeaderCheckBox(processNamesGrid);
			Ext.suspendLayouts();
			processNamesGrid.getStore().removeAll();
			processNamesGrid.getStore().loadRawData(processNamesStoreArr);
			Ext.resumeLayouts(true);
			if(isNewProcess)
			{
				Ext.Msg.show ({
					title: processConfTitle,
					msg: addedProcessMsg,
					buttons: Ext.MessageBox.YESNO,
					icon: 'iconConfirmation',
					fn: function(response) {
						if (response == "yes")
						{
							me.addProcess();
						}
					}
				});
			}
			else if(!isManualEdit)
			{
				showMsgWindow = false;
				processWidget.destroy();
				checkStatus = this.validateBeforeAdding(newProcessName+":"+newProcessPattern,true);
			}
			if(isManualEdit)
			{
				processWidget.destroy();
			}
			if(!Ext.isEmpty(processNamesStoreArr))
			{
				Ext.getCmp('updateProcessPatt').enable();
				Ext.getCmp('processSearchTrigger').enable();
				Ext.getCmp('DeleteOver').show();
			}
		}
		if(checkStatus && !isManualEdit)
		{
			showMsgWindow = true;
			processWidget.destroy();
			me.updateProcessPattern(true);
		}
	},
	clearProcessPatterns: function(btn) {
		Ext.Array.erase(processNamesArray,0,processNamesArray.length);
		Ext.getCmp('updateProcessPatt').disable(true);
		var processGridObj = Ext.getCmp('processNamesGrid');
		Ext.suspendLayouts();
		processGridObj.getStore().removeAll();
		processGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="310"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noconfProcess+'</td></tr></table></td></tr></table>';
		processGridObj.getView().refresh();
		Ext.resumeLayouts(true);
	},
	getProcessPatterns: function() {
		var cNme = publicJson['componentName'];
		if (cNme != null && cNme.indexOf(":NULL") > -1)
		{
			cNme = cNme.substring(0,cNme.indexOf(":NULL"));
		}
		var wide = false;
		var hasWideParam = false;
		if (!Ext.isEmpty(Ext.getCmp('wide1')) && Ext.getCmp('wide1') != undefined)
		{
			hasWideParam = true;
			wide = Ext.getCmp('wide1').getValue();
		}
		var showOnlyConcise = '';
		var maskObj = '';
		var s_wide = '';
		Ext.create('SpecificTestConfiguration.view.ProcessConciseConfiguration').show();
		if(submitFrmConcise)
		{
			showOnlyConcise = "true";
			s_wide = "concise";
		}
		else
		{
			showOnlyConcise = "false";
			s_wide = "detailed";
		}
		var myDDMask = new Ext.LoadMask(Ext.getCmp('processconciseconfiguration'), {msg: 'Trying to collect running processes information from agent...'});
		myDDMask.show();
		Ext.getCmp('processViewSearchTrigger').hide();
		Ext.getCmp('processLabelContainer').hide();
		configProcess = "";
		var processNames = Ext.getCmp('process').getValue();
		processCompName = Ext.getCmp('componentName').getValue();
		var processNameArr = new Array();
		
		if (!Ext.isEmpty(processNames) && processNames.indexOf(',') != -1)
		{
			processNameArr = processNames.split(',');
		}
		else
		{
			processNameArr[0] = processNames;
		}
		for(var i=0;i<processNamesArray.length;i++)
		{
			var process = processNamesArray[i];
			if(Ext.isEmpty(process))
				continue;
			if(configProcess.length == 0)
				configProcess = process;
			else
				configProcess +=","+process;
		}
		var isNoConfig = Ext.isEmpty(processNamesArray);
		var url = 'SpecificTestConfiguration/data/agentProcessListJson.jsp?componentName='+encodeURIComponent(processCompName)+'&s_wide='+s_wide+"&showOnlyConcise="+showOnlyConcise+"&dummy=dummy";
		Ext.Ajax.request({
			url: url,
			timeout: 600000000,
			method: 'POST',
			params: {
				s_val : filterEncode(configProcess),
				'noConf': isNoConfig
			},
			success: function( response )
			{
				var jsonText = response.responseText;
				publicProcessJson = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var dataArr = publicProcessJson['absPathArr'];
					var s_wide = publicProcessJson['s_wide'];
					if(publicProcessJson.timedout || publicProcessJson.alreadyConfigured )
					{
						Ext.getCmp('noProcessContainer').show();
						Ext.getCmp('noProcessLabel').update(publicProcessJson.timedoutOrAlreadyConfigLabel);
						Ext.getCmp('processdetailedsel').hide();
						Ext.getCmp('processconcisesel').hide();
						Ext.getCmp('submitProcessConc').hide();
					}
					else
					{
						Ext.getCmp('processLabelContainer').show();
						Ext.getCmp('processViewSearchTrigger').show();
						Ext.getCmp('noProcessContainer').hide();
						Ext.getCmp('submitProcessConc').show();

						if (!Ext.isEmpty(s_wide) && s_wide != undefined && s_wide == 'detailed')
						{
							Ext.getCmp('processdetailedsel').show();
							if (hasWideParam)
							{
								Ext.getCmp('processDetailedbtn').show();
								Ext.getCmp('processconcisesel').hide();
								Ext.getCmp('processConcisebtn').hide();
							}
							maskObj = Ext.getCmp('processdetailedsel');
							Ext.getCmp('processconciseconfiguration').setTitle(detailedView);
							Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
						}
						else
						{
							Ext.getCmp('processconcisesel').show();
							if (hasWideParam)
							{
								Ext.getCmp('processConcisebtn').show();
								Ext.getCmp('processdetailedsel').hide();
								Ext.getCmp('processDetailedbtn').hide();
							}
							maskObj = Ext.getCmp('processconcisesel');
							Ext.getCmp('processconciseconfiguration').setTitle(conciseView);
							Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
						}
						maskObj.getStore().loadRawData(dataArr);
					}
				}
				myDDMask.hide();
			}
		});
	},
	getDetailedPatterns: function() {
		if (!Ext.isEmpty(processNamesArray))
		{
			Ext.Msg.show ({
				title: processConfTitle,
				msg: Concisetodetailed,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					testInterViews.confirmConciseDelete(response);
					Ext.getCmp('processViewSearchTrigger').reset();
				}
			});
		}
		else
		{
			var cNme = publicJson['componentName'];
			if (cNme != null && cNme.indexOf(":NULL") > -1)
			{
				cNme = cNme.substring(0,cNme.indexOf(":NULL"));
			}
			Ext.getCmp('processconciseconfiguration').hide();
			Ext.getCmp('processconciseconfiguration').show();
			Ext.getCmp('processViewSearchTrigger').reset();
			Ext.getCmp('processconciseconfiguration').setWidth(850);
			Ext.getCmp('processdetailedsel').show();
			Ext.getCmp('processDetailedbtn').show();
			Ext.getCmp('processconcisesel').hide();
			Ext.getCmp('processConcisebtn').hide();
			showConcise = 'false';
			s_view = 'detailed';
			last_view = 'detailed';
			storeObj = Ext.getCmp('processdetailedsel');
			Ext.getCmp('processconciseconfiguration').setTitle(detailedView);
			Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
			testInterViews.confirmConciseDelete('yes');
		}
	},
	confirmConciseDelete: function(btn) {
		if (btn == 'yes')
		{
			this.clearProcessPatterns();
			var url = 'SpecificTestConfiguration/data/agentProcessListJson.jsp?componentName='+encodeURIComponent(processCompName)+'&s_wide=detailed&showOnlyConcise=true&dummy=dummy&deleteConfiguredPatterns=true';
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				params: {
					s_val: filterEncode(configProcess)
				},
				success: function( response )
				{
					var jsonText = response.responseText;
					publicDelJson = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var dataArr = publicDelJson['absPathArr'];
						storeObj.getStore().loadRawData(dataArr);
					}
				}
			});
			var cNme = publicJson['componentName'];
			if (cNme != null && cNme.indexOf(":NULL") > -1)
			{
				cNme = cNme.substring(0,cNme.indexOf(":NULL"));
			}
			Ext.getCmp('processconciseconfiguration').setWidth(850);
			Ext.getCmp('processdetailedsel').show();
			Ext.getCmp('processDetailedbtn').show();
			Ext.getCmp('processconcisesel').hide();
			Ext.getCmp('processConcisebtn').hide();
			showConcise = 'false';
			s_view = 'detailed';
			last_view = 'detailed';
			storeObj = Ext.getCmp('processdetailedsel');
			Ext.getCmp('processconciseconfiguration').setTitle(detailedView);
			Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
		}
	},
	confirmDetailedDelete: function(btn) {
		if (btn == 'yes')
		{
			this.clearProcessPatterns();
			var url = 'SpecificTestConfiguration/data/agentProcessListJson.jsp?componentName='+encodeURIComponent(processCompName)+'&s_wide=concise&showOnlyConcise=false&dummy=dummy&deleteConfiguredPatterns=true';
			Ext.Ajax.request({
				url: url,
				method: 'POST',
				params: {
					s_val: filterEncode(configProcess)
				},
				success: function( response )
				{
					var jsonText = response.responseText;
					publicDelJson = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var dataArr = publicDelJson['absPathArr'];
						storeObj.getStore().loadRawData(dataArr);
					}
				}
			});
			Ext.getCmp('processconciseconfiguration').setWidth(850);
			Ext.getCmp('processconcisesel').show();
			Ext.getCmp('processConcisebtn').show();
			Ext.getCmp('processdetailedsel').hide();
			Ext.getCmp('processDetailedbtn').hide();
			showConcise = 'false';
			s_view = 'concise';
			last_view = 'concise';
			var cNme = publicJson['componentName'];
			if (cNme != null && cNme.indexOf(":NULL") > -1)
			{
				cNme = cNme.substring(0,cNme.indexOf(":NULL"));
			}
			storeObj = Ext.getCmp('processconcisesel');
			Ext.getCmp('processconciseconfiguration').setTitle(conciseView);
			Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
		}
	},
	getConcisePatterns: function() {
		if (!Ext.isEmpty(processNamesArray))
		{
			Ext.Msg.show ({
				title: processConfTitle,
				msg: detailedtoConcise,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					testInterViews.confirmDetailedDelete(response);
					Ext.getCmp('processViewSearchTrigger').reset();
				}
			});
		}
		else
		{
			Ext.getCmp('processconciseconfiguration').setWidth(850);
			Ext.getCmp('processconcisesel').show();
			Ext.getCmp('processConcisebtn').show();
			Ext.getCmp('processViewSearchTrigger').reset();
			Ext.getCmp('processdetailedsel').hide();
			Ext.getCmp('processDetailedbtn').hide();
			showConcise = 'false';
			s_view = 'concise';
			last_view = 'concise';
			var cNme = publicJson['componentName'];
			if (cNme != null && cNme.indexOf(":NULL") > -1)
			{
				cNme = cNme.substring(0,cNme.indexOf(":NULL"));
			}
			storeObj = Ext.getCmp('processconcisesel');
			Ext.getCmp('processconciseconfiguration').setTitle(conciseView);
			Ext.getCmp('processsel').setText(runningProcess+' '+cNme);
			testInterViews.confirmDetailedDelete('yes');
		}
	},
	validateBeforeAdding: function(newProcess,isDiscover){
		isAllowToUpdate = true;
		var finalArray = new Array();
		if(!Ext.isEmpty(newProcess) && !isDiscover)
		{
			msgWindowTitle = Ext.getCmp('egprocessmodification').title;
			var isExists = false;
			for(var i=0;i<processNamesArray.length;i++)
			{
				if(!isNewProcess && i == currentRow)
					continue;
				var process = processNamesArray[i];
				existingName = process.substring(0,process.indexOf(":"));
				var newName = newProcess.substring(0,newProcess.indexOf(":"));
				if(existingName.toLowerCase() == newName.toLowerCase())
				{
					isExists = true;
					break;
				}
			}
			if(isExists)
			{
				Ext.Msg.show({
					title: msgWindowTitle,
					msg: alreadyConfigProcessPart1+" '"+existingName+"' "+alreadyConfigProcessPart2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('process_name').focus(false,200);
					}
				});
				return false;
			}
			else
			{
				finalArray.push(newProcess);
			}
		}
		else
		{
			msgWindowTitle = processConfTitle;
			finalArray = processNamesArray;
		}
		for(var i=0;i<finalArray.length;i++)
		{
			var process = finalArray[i];
			var processName = process.indexOf(":")>-1?process.substring(0,process.indexOf(":")):process;
			var processPattern =  process.indexOf(":")>-1?process.substring(process.indexOf(":")+1):"";
			if(Ext.isEmpty(processName) && !isDiscover)
			{
				Ext.Msg.show({
					title:msgWindowTitle,
					msg:notprocessNme,
					buttons:Ext.Msg.OK,
					icon:'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,true);
						else
							Ext.getCmp('process_name').focus(false,200);
					}
				});
				isAllowToUpdate = false;
				break;
			}
			if(!validateProcessName(processName))
			{
				if(showMsgWindow)
				{
					Ext.Msg.show({
						title:msgWindowTitle,
						msg:notProcessSpl,
						buttons:Ext.Msg.OK,
						icon:'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editProcess("",process,true);
							else
								Ext.getCmp('process_name').focus(false,200);
						}
					});
				}
				else if(isDiscover)
				{
					testInterViews.editProcess("",process,true);
				}
				isAllowToUpdate = false;
				break;
			}
			isAllowToUpdate = isAllowDoubleByte(process,msgWindowTitle,'process','process_name',isDiscover,patternErrorMsg3,true);
			if(!isAllowToUpdate)
				break;
			isAllowToUpdate = isAllowDoubleByte(process,msgWindowTitle,'process','process_pattern',isDiscover,patternErrorMsg4,false);
			if(!isAllowToUpdate)
				break;
			if (((processName+":"+processPattern) == "$processName:$processPattern") || ((processName+":"+processPattern) == "$name:$pattern"))
			{
				Ext.Msg.show({
					title:msgWindowTitle,
					msg:_tcKeyword,
					buttons:Ext.Msg.OK,
					icon:'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,true);
						else
							Ext.getCmp('process_name').focus(false,200);
					}
				});
				isAllowToUpdate = false;
				break;
			}
			if(Ext.isEmpty(processPattern))
			{
				Ext.Msg.show({
					title:msgWindowTitle,
					msg:alert_1,
					buttons:Ext.Msg.OK,
					icon:'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,false);
						else
							Ext.getCmp('process_pattern').focus(false,200);
					}
				});
				isAllowToUpdate = false;
				break;
			}
			if(!validateProcessPattern(processPattern,submitFrmConcise))
			{
				if(showMsgWindow)
				{
					Ext.Msg.show({
						title:msgWindowTitle,
						msg: patternErrorMsg1,
						buttons:Ext.Msg.OK,
						icon:'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editProcess("",process,false);
							else
								Ext.getCmp('process_pattern').focus(false,200);
						}
					});
				}
				else if(isDiscover)
				{
					testInterViews.editProcess("",process,true);
				}
				isAllowToUpdate = false;
				break;
			}
			if(isDiscover)
			{
				for(j=i+1;j<processNamesArray.length;j++)
				{
					var process_2 = processNamesArray[j];
					if(Ext.isEmpty(process_2))
					{
						continue;
					}
					var processName_2 = process_2.substring(0,process_2.indexOf(":"));
					if (processName == processName_2)
					{
						var processNow = process_2;
						if(allowToAsignIndex)
						{
							procIndex = j;
							allowToAsignIndex = false;
						}
						Ext.Msg.show({
							title:msgWindowTitle,
							msg:alreadyConfigProcessPart1+" '"+processNow.substring(0,process_2.indexOf(":"))+"' "+alreadyConfigProcessPart2,
							buttons:Ext.Msg.OK,
							icon:'iconExclamation',
							fn: function() {
								if(isDiscover)
									testInterViews.editProcess("",processNow,true,procIndex);
								else
									Ext.getCmp('process_name').focus(false,200);
							}
						});
						isAllowToUpdate = false;
						return isAllowToUpdate;
						//break;
					}
					else if (processName.toLowerCase() == processName_2.toLowerCase())
					{
						var processNow = process_2;
						if(allowToAsignIndex)
						{
							procIndex = j;
							allowToAsignIndex = false;
						}
						Ext.Msg.show({
							title:msgWindowTitle,
							msg:alert_3,
							buttons:Ext.Msg.OK,
							icon:'iconExclamation',
							fn: function() {
								if(isDiscover)
									testInterViews.editProcess("",processNow,true,procIndex);
								else
									Ext.getCmp('process_name').focus(false,200);
							}
						});
						isAllowToUpdate = false;
						return isAllowToUpdate;
						//break;
					}
				}
			}
			var checkProcess = this.checkBeforeAddingProcess(process,isDiscover);
			if(!checkProcess)
			{
				isAllowToUpdate = false;
				break;
			}
		}
		return isAllowToUpdate;
	},
	updateProcessPatterns: function(response,fromBtn){
		var result = "";
		if(fromBtn != undefined && fromBtn == 'fromButton')
		{
			showMsgWindow = true;
			allowToAsignIndex = true;
			response = testInterViews.validateBeforeAdding("",true);
		}
		if(response)
		{
			if(!Ext.isEmpty(processNamesArray) && processNamesArray != undefined)
			{
				for(var i=0;i<processNamesArray.length;i++)
				{
					var process = processNamesArray[i];
					var processName = process.substring(0,process.indexOf(":"));
					var processPattern = process.substring(process.indexOf(":")+1);
					processPattern = (processPattern.substring(0,1)=="*")?processPattern.substring(1):processPattern;
					processPattern = (processPattern.lastIndexOf("*")==processPattern.length-1)?processPattern.substring(0,processPattern.length-1):processPattern;
					if(result.length==0)
						result = processName+":*"+processPattern+"*";
					else
						result += "," + processName+":*"+processPattern+"*";
				}
			}
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/setSessionAttributeJson.jsp',
				method: 'POST',
				params: {'attributeName':'paramValue','attributeValue':filterEncode(result)},
				async: false,
				success: function( response )
				{
				}
			});
			firstgetProcess = true;
			var strTestName = publicJson['testName'];
			if (!Ext.isEmpty(result) && result != undefined)
			{
				Ext.getCmp('process').setValue(result);
			}
			else
			{
				Ext.getCmp('process').setValue(strTestName == 'WinProcessTest'?'$name:$pattern':'$processName:$processPattern');
			}

			if (submitFrmConcise)
			{
				if (!Ext.isEmpty(Ext.getCmp('wide1')) && Ext.getCmp('wide1') != undefined)
				{
					Ext.getCmp('wide1').setValue(false);
					Ext.getCmp('wide2').setValue(true);
				}
			}
			else
			{
				if (!Ext.isEmpty(Ext.getCmp('wide1')) && Ext.getCmp('wide1') != undefined)
				{
					Ext.getCmp('wide1').setValue(true);
					Ext.getCmp('wide2').setValue(false);
				}
			}

			var compTypeVal = Ext.getCmp('componentType').getValue();
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
			Ext.getCmp('processconfiguration').destroy();
		}
	},
	checkBeforeAddingProcess: function(process,isDiscover)
	{
		var allowedParams = publicJson.hiddenObj['allowedParams'];
		var strTcKeywords = publicJson.hiddenObj['strTcKeywords'];
		var strDoubleQuotesParams = publicJson.hiddenObj['strDoubleQuotesParams'];

		if(!Ext.isEmpty(allowedParams))
		{
			parameters = allowedParams;
		}

		if(!Ext.isEmpty(strTcKeywords))
		{
			tcKeywords = strTcKeywords;
			tcKeywords = tcKeywords.split(",");
		}

		if(!Ext.isEmpty(strDoubleQuotesParams))
		{
			doubleQuotesParams = strDoubleQuotesParams;
			doubleQuotesParams = doubleQuotesParams.split(",");
		}

		var allowToUpdate = true;
		var credentialValue = "";
		var parameters="";
		var tcKeywords="";
		var doubleQuotesParams="";

		var paramId = "process";
		var checkHyphenValidation = true;
		for(var z=0;z<doubleQuotesParams.length;z++)
		{
			if(doubleQuotesParams[z] == paramId.toLowerCase())
			{
				checkHyphenValidation = false;
				break;
			}
		}
		if(process.indexOf("$") > -1)
		{
			var parameter=parameters.split(",");
			var parameterFound=false;
			var tcKeyWordCaught=false;
			for(parameterCount=0;parameterCount<parameter.length;parameterCount++ )
			{
				temp_parameter=(parameter[parameterCount].toUpperCase());
				if((temp_parameter.replace(/^\s*/, '').replace(/\s*$/, ''))==(paramId).toUpperCase())
				{
					for(var z=0;z<tcKeywords.length;z++)
					{
						if(tcKeywords[z].toLowerCase() == process.toLowerCase())
						{
							tcKeyWordCaught = true;
							break;
						}
					}
					parameterFound=true;
					break;
				}
			}
			if(!parameterFound && paramId.toLowerCase() != "filter" && paramId.toLowerCase() != "process")
			{
				Ext.Msg.show({
					title: msgWindowTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,true);
						else
							Ext.getCmp('process_name').focus(false,200);
					}
				});
				return false;
			}
			if(tcKeyWordCaught)
			{
				Ext.Msg.show({
					title: msgWindowTitle,
					msg: _tcKeyword,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,true);
						else
							Ext.getCmp('process_name').focus(false,200);
					}
				});
				return false;
			}
		}
		if(!checkblank(process))
		{
			Ext.Msg.show({
				title: msgWindowTitle,
				msg: _checkempty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					if(isDiscover)
						testInterViews.editProcess("",process,true);
					else
						Ext.getCmp('process_name').focus(false,200);
				}
			});
			return false;
		}
		else
		{
			if(checkHyphenValidation && !checkhyphen(process, paramId.toLowerCase()))
			{
				Ext.Msg.show({
					title: msgWindowTitle,
					msg: _checkhyphen,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						if(isDiscover)
							testInterViews.editProcess("",process,true);
						else
							Ext.getCmp('process_name').focus(false,200);
					}
				});
				return false;
			}
		}
		if(paramId.toLowerCase() == "process")
		{
			var textvalTemp = process.replace(/~/g,'');
			if(textvalTemp.toUpperCase() != "NONE")
			{
				if(!processvalidation(textvalTemp,"textfield"))
				{
					Ext.Msg.show({
						title: msgWindowTitle,
						msg: patternErrorMsg2,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							if(isDiscover)
								testInterViews.editProcess("",process,true);
							else
								Ext.getCmp('process_name').focus(false,200);
						}
					});
					return false;
				}
			}
		}
		return true;
	},
	processWindowClose: function()
	{
		var isDetailedView = false;
		if (!Ext.isEmpty(Ext.getCmp('wide1')) && Ext.getCmp('wide1') != undefined)
		{
			isDetailedView = Ext.getCmp('wide1').getValue();
		}
		if (isDetailedView)
		{
			last_view = 'detailed';
		}
		else
		{
			last_view = 'concise';
		}
	},
	submitProcesses: function() {
		//firstProcessClick = true;
		submitFrmConcise = Ext.getCmp('processconcisesel').isVisible();
		submitFrmDetailed = Ext.getCmp('processdetailedsel').isVisible();
		var submitToCtrl = '';
		var processNamesStoreArray = new Array();
		if (submitFrmConcise)
		{
			submitToCtrl = Ext.getCmp('processconcisesel').getValue();
			submitToCtrl = submitToCtrl.toString().trim();
		}
		else
		{
			submitToCtrl = Ext.getCmp('processdetailedsel').getValue();
			submitToCtrl = submitToCtrl.toString().trim();
		}
		if (Ext.isEmpty(submitToCtrl) || submitToCtrl == undefined)
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectAProcess,
				buttons: Ext.Msg.OK,
				info: 'iconExclamation'
			});
			return false;
		}
		var servProArr = new Array();
		if (!Ext.isEmpty(submitToCtrl) && submitToCtrl.indexOf(',') != -1)
		{
			servProArr = submitToCtrl.split(',');
		}
		else
		{
			servProArr[0] = submitToCtrl;
		}
		if(!Ext.isEmpty(servProArr) && servProArr != undefined)
		{
			for(var x=0;x<servProArr.length;x++)
			{
				processNamesArray.push(servProArr[x]);
			}
		}
		if(!Ext.isEmpty(processNamesArray) && processNamesArray != undefined)
		{
			for(var z=0;z<processNamesArray.length;z++)
			{
				if(Ext.isEmpty(processNamesArray[z]))
				{
					continue;
				}
				var process = processNamesArray[z];
				var name = process.substring(0,process.indexOf(":"));
				var pattern = process.substring(process.indexOf(":")+1);
				var map = {'processName':name,'processPattern':pattern};
				processNamesStoreArray.push(map);
			}
		}
		Ext.getCmp('processconciseconfiguration').destroy();
		Ext.getCmp('processSearchTrigger').reset();
		Ext.getCmp('addProcessConfbtn').enable();
		if(!Ext.isEmpty(processNamesArray.length))
		{
			Ext.getCmp('updateProcessPatt').enable();
			Ext.getCmp('processSearchTrigger').enable();
			Ext.getCmp('DeleteOver').show();
		}
		var processGridObj = Ext.getCmp('processNamesGrid');
		this.unCheckHeaderCheckBox(processGridObj);
		Ext.suspendLayouts();
		processGridObj.getStore().removeAll();
		processGridObj.getStore().loadRawData(processNamesStoreArray);
		Ext.resumeLayouts(true);
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=processconfiguration',
			method: 'POST',
			async: false
		});
	},
	configuredescriptors: function(tempDescParam) {
		var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
			selType: 'checkboxmodel',
			mode: 'MULTI',
			checkOnly: true,
			renderer : function(val, meta, record, rowIndex, colIndex, store,view){
				meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			},
			selectAll: function(){
				var rowIndex=0;
				while(typeof(Ext.getCmp('gridDescriptorTest').getStore().getAt(rowIndex))!='undefined') {
					var record = Ext.getCmp('gridDescriptorTest').getStore().getAt(rowIndex);
					Ext.getCmp('gridDescriptorTest').getSelectionModel().select(rowIndex, true);
					rowIndex++;
				}
				var view = Ext.getCmp('gridDescriptorTest').getView();
				var headerCt = view.headerCt;
				var hdSelectStatus = this.selected.getCount() === this.store.getCount();

				var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
				if (checkHd) {
					checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
				}
			},
			deselectAll: function(){
				var rowIndex=0;
				while(typeof(Ext.getCmp('gridDescriptorTest').getStore().getAt(rowIndex))!='undefined') {
					var record = Ext.getCmp('gridDescriptorTest').getStore().getAt(rowIndex);
					Ext.getCmp('gridDescriptorTest').getSelectionModel().deselect(rowIndex, true);
					rowIndex++;
				}
				var view = Ext.getCmp('gridDescriptorTest').getView();
				var headerCt = view.headerCt;
				var hdSelectStatus = this.selected.getCount() === this.store.getCount();
				var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
				if (checkHd) {
					checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
				}
			}
		});
		Ext.create('SpecificTestConfiguration.view.EgDetailsTest').show();
		var tmpGrid = {
			xtype: 'grid',
			cls: 'gridSkin',
			id: 'gridDescriptorTest',
			store:new Ext.data.Store(
			{
				fields: ['Descriptor','Value'],
				data: []
			}),
			scroll: true,
			autoScroll: true,
			flex: 1,
			margin: '5 10 10 10',
			selModel:mySelectionModel,
			listeners : {
				beforeselect: function(selModel, record, index) {
				},
				rowclick : function (in_this, rowIndex, e) {
					var record = in_this.getStore().getAt(rowIndex);
				}
			},
			viewConfig: {
				deferEmptyText: true
			},
			plugins: [
				Ext.create('Ext.grid.plugin.CellEditing', {
					pluginId : 'applicationPorts',
					clicksToEdit: 1
				})
			],
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: descriptorLbl,
						dataIndex: 'Descriptor',
						id: 'descriptor',
						flex: 1
					},
					{
						dataIndex: 'Value',
						id: 'value',
						text: valueLbl,
						flex: 1,
						editor: {
							xtype: 'textfield',
							cls: 'textbox',
							minValue: 1,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowBlank: false
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								testInterViews.handleDescDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							return "<div style='cursor:pointer' onclick=\"javascript:testInterViews.handleDescDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
						}
					}
				]
			}
		}
		var tmpObj = Ext.getCmp('tmp');
		Ext.suspendLayouts();
		tmpObj.removeAll();
		tmpObj.add(tmpGrid);
		Ext.resumeLayouts(true);
		var testtName = publicJson['testName'];
		var ccName = publicJson['componentName'];
		var tempDescValue = Ext.getCmp(tempDescParam).getValue();

		Ext.Ajax.request({
			url: "SpecificTestConfiguration/data/EgDetailsTestJson.jsp?t_name="+testtName+"&c_name="+encodeURIComponent(ccName)+"&p_value="+tempDescValue+"&p_name="+tempDescParam,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicDescJSON = Ext.decode( jsonText );
				}

				if (publicDescJSON['noDescForTest'] != null && publicDescJSON['noDescForTest'] != undefined)
				{
					Ext.getCmp('NoDescriptorDetails').show();
					Ext.getCmp('testDesc').hide();
					Ext.getCmp('testParamDesc').hide();
					Ext.getCmp('componentDesc').hide();
					Ext.getCmp('gridDescriptorTest').hide();
					Ext.getCmp('updateDescriptor').hide();
				}
				else
				{
					Ext.getCmp('testDesc').show();
					Ext.getCmp('testParamDesc').show();
					Ext.getCmp('componentDesc').show();
					Ext.getCmp('gridDescriptorTest').show();
					Ext.getCmp('updateDescriptor').show();
					Ext.getCmp('NoDescriptorDetails').hide();

					Ext.getCmp('testDesc').setValue(publicDescJSON['testName']);
					Ext.getCmp('testParamDesc').setValue(publicDescJSON['paramName']);
					Ext.getCmp('componentDesc').setValue(publicDescJSON['compDisplayName']);
					Ext.getCmp('gridDescriptorTest').getStore().loadRawData(publicDescJSON['gridDescTests']);
				}
			}
		});
	},
	handleDescDeleteSelected: function() {
		var grid=Ext.getCmp('gridDescriptorTest').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var valDesc=new Array();
		var selectedGroups="";
		var selectedValues="";
		if(grid=="")
		{
			Ext.Msg.show ({
				title: descTitle,
				msg: noItemsSel,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Descriptor');
			vall=values.get('Value');
			if(id!=null)
			{
				array.push(id);
				valDesc.push(vall);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		for(var m=0; m < valDesc.length; m++)
		{
			selectedValues +=valDesc[m]+",";
		}
		Ext.Msg.show ({
			title: descTitle,
			msg: deleteSelected,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					var testtName = publicJson['testName'];
					var ccName = publicJson['componentName'];
					var tempDescValue = Ext.getCmp(tempDescParam).getValue();

					Ext.Ajax.request({
						url: "SpecificTestConfiguration/data/EgDetailsTestpJson.jsp?t_name="+testtName+"&c_name="+encodeURIComponent(ccName)+"&p_value="+tempDescValue+"&p_name="+tempDescParam+"&info="+selectedGroups+"&q_value="+selectedValues+"&modify=deleteRecord",
						method: 'POST',
						success: function( response )
						{
							var jsonText = response.responseText;
							publicDelJSON = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
							{
								var resultStatus = publicDelJSON['requestStatus'];
								if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
								{
									var resultStatus = publicDelJSON['result'];
									Ext.Msg.show ({
										title: resultStatus['title'],
										msg: resultStatus['message1'],
										buttons: Ext.MessageBox.OK,
										icon: 'iconInformation',
										fn: function() {
											testInterViews.buildDescData(tempDescParam);
											if (publicDelJSON['noDescForTest'] != null && publicDelJSON['noDescForTest'] != undefined)
											{
												Ext.getCmp('NoDescriptorDetails').show();
												Ext.getCmp('testDesc').hide();
												Ext.getCmp('testParamDesc').hide();
												Ext.getCmp('componentDesc').hide();
												Ext.getCmp('gridDescriptorTest').hide();
												Ext.getCmp('updateDescriptor').hide();
											}
											else
											{
												Ext.getCmp('testDesc').show();
												Ext.getCmp('testParamDesc').show();
												Ext.getCmp('componentDesc').show();
												Ext.getCmp('gridDescriptorTest').show();
												Ext.getCmp('updateDescriptor').show();
												Ext.getCmp('NoDescriptorDetails').hide();

												Ext.getCmp('testDesc').setValue(publicDelJSON['testName']);
												Ext.getCmp('testParamDesc').setValue(publicDelJSON['paramName']);
												Ext.getCmp('componentDesc').setValue(publicDelJSON['compDisplayName']);
												Ext.getCmp('gridDescriptorTest').getStore().removeAll();
												Ext.getCmp('gridDescriptorTest').getStore().loadRawData(publicDelJSON['gridDescTests']);
											}
										}
									});
								}
							}
						}
					});
				}
			}
		});
	},
	buildDescData: function(tempDescParam){
		var testtName = publicJson['testName'];
		var ccName = publicJson['componentName'];
		var tempDescValue = Ext.getCmp(tempDescParam).getValue();

		Ext.Ajax.request({
			url: "SpecificTestConfiguration/data/EgDetailsTestJson.jsp?t_name="+testtName+"&c_name="+encodeURIComponent(ccName)+"&p_value="+tempDescValue+"&p_name="+tempDescParam,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicDelJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	handleDescDeleteIconClick: function(gridView, row, col){
		var task = Ext.getCmp('gridDescriptorTest').getStore().getAt(row);
		this.deleteDescTask(task,row);
	},
	deleteDescTask: function(task,rowIndex){
		var DescriptorNme = task.get('Descriptor');
		var qDescValue = task.get('Value');
		this.commonDescDelete(DescriptorNme,qDescValue,rowIndex);
	},
	commonDescDelete: function(DescriptorNme,qDescValue,rowIndex) {
		Ext.Msg.show({
			title: 'DESCRIPTOR DETAILS',
			msg: deletedSingleDescMsg,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
			if(response === 'yes') {
					var testtName = publicJson['testName'];
					var ccName = publicJson['componentName'];
					var tempDescValue = Ext.getCmp(tempDescParam).getValue();

					Ext.Ajax.request({
					url: "SpecificTestConfiguration/data/EgDetailsTestpJson.jsp?t_name="+testtName+"&c_name="+encodeURIComponent(ccName)+"&p_value="+tempDescValue+"&p_name="+tempDescParam+"&info="+DescriptorNme+"&q_value="+qDescValue+"&modify=deleteRecord",
					method: 'POST',
					success: function( response )
					{
						var jsonText = response.responseText;
						publicDelJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicDelJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicDelJSON['result'];
								Ext.Msg.show ({
									title: resultStatus['title'],
									msg: resultStatus['message1'],
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: function() {
										testInterViews.buildDescData(tempDescParam);
										var noDescForTest = publicDelJSON['noDescForTest'];
										if (!Ext.isEmpty(noDescForTest) && noDescForTest != 'undefined' && noDescForTest != undefined) 
										{
											Ext.getCmp('NoDescriptorDetails').show();
											Ext.getCmp('testDesc').hide();
											Ext.getCmp('testParamDesc').hide();
											Ext.getCmp('componentDesc').hide();
											Ext.getCmp('gridDescriptorTest').hide();
											Ext.getCmp('updateDescriptor').hide();
										}
										else
										{
											Ext.getCmp('testDesc').show();
											Ext.getCmp('testParamDesc').show();
											Ext.getCmp('componentDesc').show();
											Ext.getCmp('gridDescriptorTest').show();
											Ext.getCmp('updateDescriptor').show();
											Ext.getCmp('NoDescriptorDetails').hide();

											Ext.getCmp('testDesc').setValue(publicDelJSON['testName']);
											Ext.getCmp('testParamDesc').setValue(publicDelJSON['paramName']);
											Ext.getCmp('componentDesc').setValue(publicDelJSON['compDisplayName']);
											Ext.getCmp('gridDescriptorTest').getStore().removeAll();
											Ext.getCmp('gridDescriptorTest').getStore().loadRawData(publicDelJSON['gridDescTests']);
										}
									}
								});
							}
						}
					}
					});
				}
			}
		});
	},
	updatedescriptors: function() {
		var grid=Ext.getCmp('gridDescriptorTest').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var valDesc=new Array();
		var selectedGroups="";
		var selectedValues="";
		if(grid=="")
		{
			Ext.Msg.show({
				title: descTitle,
				msg: noItemsSel,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Descriptor');
			vall=values.get('Value');
			if(id!=null)
			{
				array.push(id);
				valDesc.push(vall);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		for(var m=0; m < valDesc.length; m++)
		{
			selectedValues +=valDesc[m]+",";
		}
		var testtName = publicJson['testName'];
		var ccName = publicJson['componentName'];
		var tempDescValue = Ext.getCmp(tempDescParam).getValue();

		var isValidDescriptor = testInterViews.checkDescriptor(valDesc);
		if (isValidDescriptor)
		{
			Ext.Ajax.request({
			url: "SpecificTestConfiguration/data/EgDetailsTestpJson.jsp?t_name="+testtName+"&c_name="+encodeURIComponent(ccName)+"&p_value="+tempDescValue+"&p_name="+tempDescParam+"&info="+selectedGroups+"&q_value="+selectedValues+"&modify=updateRecord",
			method: 'POST',
			async: false,
			success: function( response )
			{
				var jsonText = response.responseText;
				publicDelJSON = Ext.decode(jsonText);
				testInterViews.buildDescData(tempDescParam);
				Ext.getCmp('gridDescriptorTest').store.loadData(publicDelJSON['gridDescTests']);
				Ext.getCmp('egdetailstest').destroy();
			}
			});
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+testtName+'&testName='+testtName,
			method:'POST'
		});
	},
	checkDescriptor: function(valDesc) {
		var allowDescToUpdate = true;
		for(var m=0; m < valDesc.length; m++)
		{
			var tempDescripValue = valDesc[m];
			if (tempDescripValue == "")
			{
				Ext.Msg.show({
					title: descTitle,
					msg: _checkcomma,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				allowDescToUpdate = false;
				return;
			}
			else if (!checkDescSpecial(tempDescripValue," `~!@#$%^&*()+-,.={}[]|:;\"\'<>_?\/\\"))
			{
				allowDescToUpdate = false;
				return;
			}
		}
		return allowDescToUpdate;
	},
	policyCreationPage: function() {  //View Policy
		Ext.create('SpecificTestConfiguration.view.EgPolicyCreation').show();
		Ext.getCmp('egpolicycreation').setTitle(polCreationPageName);

		var tNme = publicJson['testName'];
		if (tNme == 'SecurityLogTest')
		{
			Ext.getCmp('evtdescriptors').setFieldLabel('EVENT USERS');

			Ext.getCmp('evtdescriptors_SL').show();
			Ext.getCmp('mainContainer').setAutoScroll(true);
			Ext.getCmp('mainContainer').setHeight(430);

		}

		var currentLogType = Ext.getCmp('logType').getValue();
		var qStr = "server="+jsonVal['server']+"&test="+jsonVal['parmTestName']+"&change=add&showAll="+jsonVal['showAll']+"&q="+jsonVal['q']+"&logtype="+currentLogType+"&requestFrom="+jsonVal['requestFrom'];
		var urlValue = "SpecificTestConfiguration/data/EgPolicyCreationJson.jsp?"+qStr;
		Ext.Ajax.request({
			url:urlValue,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					polCreationJson = Ext.decode(response.responseText);
				}
			}
		});
	},
	configViewPolicy: function() {
		var externalPageLink = publicJson['externalPageLink'];
		var currentLogType = Ext.getCmp('logType').getValue();

		if (!Ext.isEmpty(currentLogType))
		{
			externalPageLink += "&currentLogType="+encodeURIComponent(currentLogType);
		}

		if (Ext.create('SpecificTestConfiguration.view.ViewPolicy').isHidden())
		{
			var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
			selType: 'checkboxmodel',
			mode: 'MULTI',
			checkOnly: true,
			renderer : function(val, meta, record, rowIndex, colIndex, store,view){
				var eventPolName = record.get('Events');
				var isDelLink = record.get('Delete');
				var isDisabled = record.get('isDisabled');

				if (!Ext.isEmpty(eventPolName) && eventPolName != undefined && eventPolName == 'all')
				{
					isDelLink = 'yes';
				}
				if( isDisabled &&  isDelLink)
				{
					meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
					return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
				}
				else
				{
					meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
					return '<img src="/final/images/spacer.gif" class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
				}
			},
			selectAll: function(){
				var rowIndex=0;
				while(typeof(Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex))!='undefined') {
					var record = Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex);
					if (record.get('isDisabled')){
						Ext.getCmp('EventsViewGrid').getSelectionModel().deselect(rowIndex, true);
					}
					else {
						Ext.getCmp('EventsViewGrid').getSelectionModel().select(rowIndex, true);
					}
					rowIndex++;
				}
				var view = Ext.getCmp('EventsViewGrid').getView();
				var headerCt = view.headerCt;
				var hdSelectStatus = this.selected.getCount() === this.store.getCount();
				var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
				if (checkHd) {
					checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
				}
			},
			deselectAll: function(){
				var rowIndex=0;
				while(typeof(Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex))!='undefined') {
					var record = Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex);
					Ext.getCmp('EventsViewGrid').getSelectionModel().deselect(rowIndex, true);
					rowIndex++;
				}
				var view = Ext.getCmp('EventsViewGrid').getView();
				var headerCt = view.headerCt;
				var hdSelectStatus = this.selected.getCount() === this.store.getCount();
				var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
				if (checkHd) {
					checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
				}
			}
		});
		Ext.create('SpecificTestConfiguration.view.ViewPolicy').show();
			var tmpGridPolicy = {
				xtype: 'grid',
				cls: 'gridSkin',
				id: 'EventsViewGrid',
				name: 'EventsViewGrid',
				flex: 1,
				store:new Ext.data.Store({
					fields: ['Events','View','Modify','Delete','isDisabled'],
					data: []
				}),
				selModel:mySelectionModel,
				listeners : {
					beforeselect: function(selModel, record, index) {
						if (record.get('isDisabled')) {
							 return false;
						}
					},
					rowclick : function (in_this, rowIndex, e) {
						var record = in_this.getStore().getAt(rowIndex);
						if (record.get('isDisabled')){
							in_this.getSelectionModel().deselectRow(rowIndex);
						}
					}
				},
				viewConfig: {
					deferEmptyText: true
				},
				emptyText: '<table align="center"><tr><td align="center" height="220"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noPolicyFound+'</td></tr></table></td></tr></table>',
				scroll : true,
				autoScroll : true,
				columns: {
					defaults: {
						sortable: true,
						hideable: false,
						menuDisabled: true,
						draggable: false,
						resizable: false,
						isCheckerHd: false
					},
					items: [
						{
							text: label15,
							dataIndex: 'Events',
							id: 'events',
							flex: 1
						},
						{
							xtype: 'actioncolumn',
							width: 36,
							id: 'ViewOver',
							sortable: false,
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var isViewLink = record.get('View');
								metaData.tdAttr = "data-qtip='"+label8+"' data-qclass='yellowTip'";
								if (!Ext.isEmpty(isViewLink))
								{
									return "<div style='cursor:pointer' onclick=\"javascript:me.handleViewIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconShowAssociates'></div>";
								}
								else
								{
									return '<div class="iconShowAssociates"></div>';
								}
							}
						},
						{
							xtype: 'actioncolumn',
							width: 36,
							id: 'EditOver',
							iconCls: 'iconModify',
							sortable: false,
							handler:  function(grid, rowIndex, colIndex, column, e) {
								var isModifyLink = grid.getStore().getAt(rowIndex).get('Modify');
								if (!Ext.isEmpty(isModifyLink))
								{
									me.handleEditIconClick(grid, rowIndex, colIndex);
								}
								else
								{
									return false;
								}
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var isModifyLink = record.get('Modify');
								metaData.tdAttr = "data-qtip='"+label6+"' data-qclass='yellowTip'";
								if (!Ext.isEmpty(isModifyLink))
								{
									//return "<div style='cursor:pointer' onclick=\"javascript:me.handleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconModify'></div>";
								}
								else
								{
									metaData.style = "filter:alpha(opacity=20);opacity:.2;cursor:hand;";
								}
							}
						},
						{
							header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
							xtype: 'actioncolumn',
							width: 36,
							id: 'DeleteOver',
							sortable: false,
							listeners: {
								headerclick: function(g, index, ev) {
									me.handleDeleteSelected();
								}
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var isDeleteLink = record.get('Delete');
								var isDisabled = record.get('isDisabled');
								metaData.tdAttr = "data-qtip='"+label9+"' data-qclass='yellowTip'";

								if (isDisabled)
								{
									return '<div class="iconDeleteDisabled"></div>';
								}
								else
								{
									return "<div style='cursor:pointer' onclick=\"javascript:"+isDeleteLink+"\" class='iconDelete'></div>";
								}
							}
						}
					]
				},
				margin: 10,
				tbar: [
					{
						xtype:'tbfill',
					},
					{
						xtype: 'trigger',
						id: 'searchTrigger',
						trigger1Cls: 'x-form-clear-trigger',
						trigger2Cls: 'x-form-search-trigger',
						cls: 'whitedropdown_search',
						emptyText: 'Search',
						getTriggerMarkup: function() {
							var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
							// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
							// single triggerCls config. Should rethink this, perhaps something more structured like a list of
							// trigger config objects that hold cls, handler, etc.
							// triggerCls is a synonym for trigger1Cls, so copy it.
							if (!me.trigger1Cls) {
								me.trigger1Cls = me.triggerCls;
							}
							// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
							for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
								if (i == 0)
								{
									triggerConfigs.push({
										tag: 'td',
										role: 'presentation',
										valign: 'top',
										cls: cls,
										id : 'MyTrigger_'+i,
										style: style + "display:none;",
										cn: {
											cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
											role: 'presentation'
										}
									});
								}
								else
								{
									triggerConfigs.push({
										tag: 'td',
										role: 'presentation',
										valign: 'top',
										cls: cls,
										id : 'MyTrigger_'+i,
										style: style,
										cn: {
											cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
											role: 'presentation'
										}
									 });
								}
							}
							triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
							return Ext.DomHelper.markup(triggerConfigs);
						},
						onTrigger1Click: function()
						{
							this.reset();
							me.policyMainSearch();
						},
						onTrigger2Click: function()
						{
							me.policyMainSearch();
						}
					},
					{
						xtype: 'toolbar',
						ui: 'footer',
						items:[
							{
								xtype: 'button',
								cls: 'button20',
								text: label14,
								name: 'addPolicy',
								id: 'addPolicy'
							}
						]
					}
				]
			}
		var tmpObj = Ext.getCmp('tempPolicy');
		Ext.suspendLayouts();
		tmpObj.removeAll();
		tmpObj.add(tmpGridPolicy);
		Ext.resumeLayouts(true);
	}
		Ext.Ajax.request({
			url:externalPageLink,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					jsonVal = Ext.decode(response.responseText);
					var girdDataArr = jsonVal['gridDataArr'];
					Ext.getCmp('EventsViewGrid').getStore().removeAll();
					Ext.getCmp('EventsViewGrid').getStore().loadRawData(girdDataArr);

					//var view = Ext.getCmp('EventsViewGrid').getView();
					//var headerCt = view.headerCt;
					//var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
					//if (checkHd) {
						//checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');//x-grid-hd-checker-on
					//}
				}
			}
		});
	},
	policySearch : function() {
		searchStr = Ext.getCmp('searchTrigger').getValue();
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		var currentLogType = Ext.getCmp('logType').getValue();
		var params ='server='+jsonVal['server']+'&test='+jsonVal['polTestName']+'&port=true&showAll='+jsonVal['showAll']+'&logtype='+currentLogType+'&requestFrom='+jsonVal['requestFrom']+'&testType='+jsonVal['polTestType']+'&currentLogType='+encodeURIComponent(currentLogType);
		if (searchStr == null || searchStr == "")
		{
			urlVal = 'SpecificTestConfiguration/data/ViewPolicyJson.jsp?'+params;
		}
		else if (searchStr != null)
		{
			urlVal ='SpecificTestConfiguration/data/ViewPolicyJson.jsp?egTitleSearchStr='+encodeURI(searchStr)+'&'+params;
		}
		Ext.Ajax.request({
			url: urlVal,
			method: 'POST',
			scope: this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var viewPolJson = Ext.decode(jsonText);
					var noPreDefSearchStr = viewPolJson['no_search_item'];
					if (noPreDefSearchStr != null && noPreDefSearchStr != 'undefined')
					{
						Ext.getCmp('EventsViewGrid').store.loadData('');
						Ext.getCmp('EventsViewGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="320"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noPolicyFound+'.</td></tr></table></td></tr></table>'
						Ext.getCmp('EventsViewGrid').getView().refresh();
					}
					else
					{
						Ext.getCmp('EventsViewGrid').show();
						Ext.getCmp('EventsViewGrid').getStore().loadRawData(viewPolJson['gridDataArr']);
					}
				}
			}
		});
	},
	policyValidate: function() {
		var view = polCreationJson['hiddenPolicyObj']['change'];
		policyName = Ext.getCmp('pol_name').getValue();
		if(Ext.isEmpty(policyName) || policyName == undefined)
		{
			Ext.Msg.show({
				title: polCreationPageName,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					Ext.getCmp('pol_name').focus(true);
				}
			});
			sucFlag=false;
			return;
		}
		var reg_expression = /[`~!@#$%^&()|{}/+=.?\\\"\'><,\:\;]/;
		if(!Ext.isEmpty(policyName) && policyName != undefined)
		{
			var policyNameresult = reg_expression.test(policyName);
			var myhypen = "-";
			var mycomma = ",";
			var mylen = policyName.length;
			if(policyNameresult && policyNameresult != undefined)
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg16,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						Ext.getCmp('pol_name').focus(true);
					}
				});
				sucFlag=false;
				return;
			}
			if(policyName.charAt(0) == myhypen || policyName.charAt(mylen-1)== myhypen)
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg17,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						Ext.getCmp('pol_name').focus(true);
					}
				});
				sucFlag=false;
				return;
			}
		}

		sucFlag=true;
		var evtSrcComboValue = Ext.getCmp('Source').getValue();
		var evtIdComboValue = Ext.getCmp('Id').getValue();
		var evtDescComboValue = Ext.getCmp('Desc').getValue();
		var EvScIn = Ext.getCmp('EvScIn').getValue();
		var EvScEx = Ext.getCmp('EvScEx').getValue();
		var EvIdIn = Ext.getCmp('EvIdIn').getValue();
		var EvIdEx = Ext.getCmp('EvIdEx').getValue();
		var EvDescIn = Ext.getCmp('EvDescIn').getValue();
		var EvDescEx = Ext.getCmp('EvDescEx').getValue();
		
		//for security log

		var tNme = publicJson['testName'];
		var EvDescIn_SL = '';
		var EvDescEx_SL = '';
		var evtDescSLComboValue = '';
		if (tNme == 'SecurityLogTest')
		{
			evtDescSLComboValue = Ext.getCmp('Desc_SL').getValue();
			EvDescIn_SL = Ext.getCmp('EvDescIn_SL').getValue();
			EvDescEx_SL = Ext.getCmp('EvDescEx_SL').getValue();

			if (evtDescSLComboValue == "Included")
			{
				EvDescIn_SL =  Ext.getCmp('EVENT_DESCRIPTIONS_SL').getValue();
			}
			else
			{
				EvDescEx_SL = Ext.getCmp('EVENT_DESCRIPTIONS_SL').getValue();
			}
		}

		if (evtSrcComboValue == "Included")
		{
			EvScIn =  Ext.getCmp('EVENT_SOURCES').getValue();
		}
		else
		{
			EvScEx = Ext.getCmp('EVENT_SOURCES').getValue();
		}

		if (evtIdComboValue == "Included")
		{
			EvIdIn = Ext.getCmp('EVENT_IDS').getValue();
		}
		else
		{
			EvIdEx = Ext.getCmp('EVENT_IDS').getValue();
		}

		if (evtDescComboValue == "Included")
		{
			EvDescIn =  Ext.getCmp('EVENT_DESCRIPTIONS').getValue();
		}
		else
		{
			EvDescEx = Ext.getCmp('EVENT_DESCRIPTIONS').getValue();
		}

		var evt_src_in = EvScIn;
		var evt_src_ex = EvScEx;
		var option = evtSrcComboValue;
		if (option == "Included")
		{
			var flag = this.checkEventSource(evt_src_in,"Included");
			if (!flag)
			{
				sucFlag = false;
				return;
			}

			var flag1 = this.checkForAllKeyword(evt_src_in,"EvtSrc","Included");
			if (!flag1)
			{
				Ext.getCmp('EVENT_SOURCES').focus(true);
				sucFlag = false;
				return;
			}

			var flag2 = this.checkForNoneKeyword(evt_src_in,"EvtSrc","Included");
			if (!flag2)
			{
				Ext.getCmp('EVENT_SOURCES').focus(true);
				sucFlag = false;
				return;
			}

			if (evt_src_in == "all")
			{
				if (EvScEx == "")
				{
					EvScEx = "none";
				}
			}
			else
			{
				EvScEx = "none";
			}
		}
		else
		{
			var flag = this.checkEventSource(evt_src_ex,"Excluded");
			if (!flag)
			{
				sucFlag = false;
				return;
			}

			var flag1 = this.checkForNoneKeyword(evt_src_ex,"EvtSrc","Excluded");
			if (!flag1)
			{
				Ext.getCmp('EVENT_SOURCES').focus(true);
				sucFlag = false;
				return;
			}

			var flag2 = this.checkForAllKeyword(evt_src_ex,"EvtSrc","Excluded");
			if (!flag2)
			{
				Ext.getCmp('EVENT_SOURCES').focus(true);
				sucFlag = false;
				return;
			}

			if (evt_src_ex == "none")
			{
				if (EvScIn == "")
				{
					EvScIn = "all";
				}
			}
			else
			{
				EvScIn = "all";
			}
		}

		var evt_id_in = EvIdIn;
		var evt_id_ex = EvIdEx;
		option = evtIdComboValue;
		if (option == "Included")
		{
			var flag = this.checkEventID(evt_id_in,"Included");
			if (!flag)
			{
				sucFlag = false;
				return;
			}
			if (evt_id_in == "all")
			{
				if (EvIdEx == "")
				{
					EvIdEx = "none";
				}
			}
			else
			{
				EvIdEx = "none";
			}
		}
		else
		{
			var flag = this.checkEventID(evt_id_ex,"Excluded");
			if (!flag)
			{
				sucFlag = false;
				return;
			}
			if (evt_id_ex == "none")
			{
				if (EvIdIn == "")
				{
					EvIdIn = "all";
				}
			}
			else
			{
				EvIdIn = "all";
			}
		}

		var evt_desc_in = EvDescIn;
		var evt_desc_ex = EvDescEx;
		option = evtDescComboValue;
		if (option == "Included")
		{
			var flag = this.checkEventDescription(evt_desc_in,"Included");
			if (!flag)
			{
				sucFlag = false;
				return;
			}

			var flag1 = this.checkForAllKeyword(evt_desc_in,"EvtDesc","Included");
			if (!flag1)
			{
				Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
				sucFlag = false;
				return;
			}

			var flag2 = this.checkForNoneKeyword(evt_desc_in,"EvtDesc","Included");
			if (!flag2)
			{
				Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
				sucFlag = false;
				return;
			}

			if (evt_desc_in == "all")
			{
				if (EvDescEx == "")
				{
					EvDescEx = "none";
				}
			}
			else
			{
				EvDescEx = "none";
			}
		}
		else
		{
			var flag = this.checkEventDescription(evt_desc_ex,"Excluded");
			if (!flag)
			{
				sucFlag = false;
				return;
			}

			var flag1 = this.checkForNoneKeyword(evt_desc_ex,"EvtDesc","Excluded");
			if (!flag1)
			{
				Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
				sucFlag = false;
				return;
			}

			var flag2 = this.checkForAllKeyword(evt_desc_ex,"EvtDesc","Excluded");
			if (!flag2)
			{
				Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
				sucFlag = false;
				return;
			}

			if (evt_desc_ex == "none")
			{
				if (EvDescIn == "")
				{
					EvDescIn = "all";
				}
			}
			else
			{
				EvDescIn = "all";
			}
		}
		if (tNme == 'SecurityLogTest')
		{
			var evt_desc_in = EvDescIn_SL;
			var evt_desc_ex = EvDescEx_SL;
			option = evtDescSLComboValue;
			if (option == "Included")
			{
				var flag = this.checkEventDescriptionSL(evt_desc_in,"Included");
				if (!flag)
				{
					sucFlag = false;
					return;
				}

				var flag1 = this.checkForAllKeywordSL(evt_desc_in,"Included");
				if (!flag1)
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					sucFlag = false;
					return;
				}

				var flag2 = this.checkForNoneKeywordSL(evt_desc_in,"Included");
				if (!flag2)
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					sucFlag = false;
					return;
				}

				if (evt_desc_in == "all")
				{
					if (EvDescEx_SL == "")
					{
						EvDescEx_SL = "none";
					}
				}
				else
				{
					EvDescEx_SL = "none";
				}
			}
			else
			{
				var flag = this.checkEventDescriptionSL(evt_desc_ex,"Excluded");
				if (!flag)
				{
					sucFlag = false;
					return;
				}

				var flag1 = this.checkForNoneKeywordSL(evt_desc_ex,"Excluded");
				if (!flag1)
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					sucFlag = false;
					return;
				}

				var flag2 = this.checkForAllKeywordSL(evt_desc_ex,"Excluded");
				if (!flag2)
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					sucFlag = false;
					return;
				}

				if (evt_desc_ex == "none")
				{
					if (EvDescIn_SL == "")
					{
						EvDescIn_SL = "all";
					}
				}
				else
				{
					EvDescIn_SL = "all";
				}
			}
		}

		var msgAlert  = alertMsg73;
		if(view=="add" && sucFlag)
		{
			msgAlert = alertMsg72;
			var existingPolicyName = polCreationJson['strDescriptors'];
			var arr = existingPolicyName.split(",");
			for(var i=0;i<arr.length;i++)
			{
				var temp = arr[i].toLowerCase();
				if(temp == policyName.toLowerCase())
				{
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertMsg68,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							Ext.getCmp('pol_name').focus(true);
						}
					});
					sucFlag=false;
				}
			}
		}

		if(sucFlag)
		{
			var urlValue = "SpecificTestConfiguration/data/EgPolicyUpdateJson.jsp?";
			var change = polCreationJson['hiddenPolicyObj']['change'];
			var testName = polCreationJson['hiddenPolicyObj']['testName'];
			var logtype = polCreationJson['hiddenPolicyObj']['logtype'];
			var server = polCreationJson['hiddenPolicyObj']['server'];
			var requestFrom = polCreationJson['hiddenPolicyObj']['requestFrom'];
			var field_Name = polCreationJson['hiddenPolicyObj']['field_Name'];
			var q1 = polCreationJson['hiddenPolicyObj']['q1'];
			var processParams = "pol_name="+policyName+"&EvScIn="+EvScIn+"&EvScEx="+EvScEx+"&EvIdIn="+EvIdIn+"&EvIdEx="+EvIdEx+"&EvDescIn="+EvDescIn+"&EvDescEx="+EvDescEx+"&field_Name="+field_Name+"&change="+change+"&testName="+testName+"&logtype="+logtype+"&server="+encodeURIComponent(server)+"&requestFrom="+requestFrom+"&q1="+q1;

			if (tNme == 'SecurityLogTest')
			{
				processParams += "&EvDescIn_SL="+EvDescIn_SL+"&EvDescEx_SL="+EvDescEx_SL;
			}

			Ext.Ajax.request({
				url: urlValue+processParams,
				method: 'POST',
				success: function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var resultJson = Ext.decode(response.responseText);
						var dispTestName = resultJson.dispTestName;
						var dispLogType = resultJson.dispLogType;
						Ext.Msg.show({
							title: polCreationPageName,
							msg: msgAlert,//'Parameters Configured for '+ dispTestName +' '+ dispLogType,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response)
							{
								Ext.getCmp('egpolicycreation').destroy();
								Ext.getCmp('viewpolicy').destroy();
								me.configViewMainPolicy();

								//filter_combo
								//var tempStore = new Ext.data.Store({fields: ['displayField','valueField'],data: [{'displayField':policyName,'valueField':policyName}]});
								//console.log(tempStore);
								//var filterArr = publicJson['filterArr'];
								//var selectedPolicyFilter = publicJson['selectedPolicyFilter'];
								//var tempStore = new Array();
								//tempStore.push({'displayField': policyName,'valueField': policyName});
								//Ext.getCmp('filter_combo').getStore().suspendEvents(true);
								var filterComboObj = Ext.getCmp('filter_combo');
								if ( !Ext.isEmpty(deletedRecords) && deletedRecords != undefined)
								{
									var tempStore = new Array();
									if (deletedRecords.indexOf(",") != -1)
									{
										var delRecArray = new Array();
										delRecArray = deletedRecords.split(',');
										for (var i=0;i<delRecArray.length ;i++ )
										{
											var index = filterComboObj.getStore().find( 'valueField', delRecArray[i].toString(), 0, false, true, true ) ;
											filterComboObj.getStore().removeAt(index);
										}
									}
									else
									{
										var index = filterComboObj.getStore().find( 'valueField', deletedRecords.toString(), 0, false, true, true ) ;
										filterComboObj.getStore().removeAt(index);
									}
									deletedRecords = '';
								}

								if (!Ext.isEmpty(change) && change == 'add')
								{
									filterComboObj.getStore().add({displayField:policyName, valueField:policyName});
								}
								var selectedPolValue = Ext.getCmp('filter_combo').getValue();
								var availPoliciesCount = Ext.getCmp('filter_combo').getStore().getCount();
								if (!Ext.isEmpty(availPoliciesCount) && availPoliciesCount > 0)
								{
									for (var i =0;i < availPoliciesCount ; i++)
									{
										var polNameObj = Ext.getCmp('filter_combo').getStore().getAt(i);
										if (!Ext.isEmpty(polNameObj))
										{
											var polName =  Ext.getCmp('filter_combo').getStore().getAt(i).get('valueField');
											if (!Ext.isEmpty(polName) && polName == 'all')
											{
												Ext.getCmp('filter_combo').getStore().removeAt(i);
											}
										}
									}	
								}
								availPoliciesCount = Ext.getCmp('filter_combo').getStore().getCount();
								//var availPolicies = Ext.getCmp('filter_combo').getStore().getNewRecords();
								var genStore = new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: []
								});
								var recordFound = false;
								if (!Ext.isEmpty(availPoliciesCount) && availPoliciesCount > 0)
								{
									availPolicies = new Array();
									for (var i =0;i < availPoliciesCount ; i++)
									{
										availPolicies[i] = filterComboObj.getStore().getAt(i).get('valueField');
										recordFound = true;
										genStore.add({
											'displayField': availPolicies[i],
											'valueField': availPolicies[i]
										});
									}
								}

								if (availPolicies.indexOf('all') == -1)
								{
									availPolicies.push('all');
								}

								filterComboObj.getStore().removeAll();
								if (recordFound)
								{
									for ( var i = 0; i < genStore.getCount() ; i++ )
									{
										var getRecord = genStore.getAt(i);
										filterComboObj.getStore().add(getRecord);
									}
								}
								//Ext.getCmp('filter_combo').getStore().sort('displayField', 'ASC');
								Ext.getCmp('filter_combo').getStore().sort([{ property : 'displayField',direction: 'ASC'},{property : 'valueField',direction: 'ASC'}]);
								filterComboObj.getStore().insert(0,{displayField:'all', valueField:'all'});
								Ext.getCmp('filter_combo').setValue(selectedPolValue);
							}
						});
					}
				}

			});
		}
	},
	openWindow: function(type) {
		var fieldvar="";
		var change = "No";
		var fieldVal = '';
		var ObjField ='';
		if(type.id == "viewsource")
		{
			fieldVal = Ext.getCmp('EVENT_SOURCES').getValue();
			fieldvar = "EVENT SOURCES";
			objField = Ext.getCmp('EVENT_SOURCES');
		}
		else if(type.id == "viewid")
		{
			fieldVal = Ext.getCmp('EVENT_IDS').getValue();
			fieldvar = "EVENT IDS";
			objField = Ext.getCmp('EVENT_IDS');
		}
		else
		{
			fieldVal = Ext.getCmp('EVENT_DESCRIPTIONS').getValue();
			fieldvar="EVENT DESCRIPTIONS";
			objField = Ext.getCmp('EVENT_DESCRIPTIONS');
		}

		Ext.widget('window', {
			width: 450,
			height: 250,
			resizable: 'false',
			title: 'Data Entry Window',
			id : 'dataFullViewForm',
			name : 'dataFullViewForm',
			autoScroll: true,
			modal: true,
			items:[
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'center',
						pack: 'center'
					},
					defaults: {
						labelAlign: 'top',
						labelSeparator: ' ',
						width: 250,
						margin: 10
					},
					items: [
						{
							xtype: 'textareafield',
							cls: 'text-area',
							name: 'viewTextArea',
							id: 'viewTextArea',
							fieldLabel: fieldvar,
							height: 150,
							width: 350,
							value: fieldVal
						},
						{
							xtype: 'button',
							cls: 'button20',
							text: label1,
							id: 'ApplyBtn',
							width: 80,
							handler: function() {
								objField.setValue(Ext.getCmp('viewTextArea').getValue());
								Ext.getCmp('dataFullViewForm').destroy();
							}
						}
					]
				}
			]
		}).show();
	},
	checkInter: function (fromComp) {
		var operation = polCreationJson['hiddenPolicyObj']['change'];
		var EvScIn = Ext.getCmp('EvScIn').getValue();
		var EvScEx = Ext.getCmp('EvScEx').getValue();
		var EvIdIn = Ext.getCmp('EvIdIn').getValue();
		var EvIdEx = Ext.getCmp('EvIdEx').getValue();
		var EvDescIn = Ext.getCmp('EvDescIn').getValue();
		var EvDescEx = Ext.getCmp('EvDescEx').getValue();

		//for security log
		var EvDescIn_SL = Ext.getCmp('EvDescIn_SL').getValue();
		var EvDescEx_SL = Ext.getCmp('EvDescEx_SL').getValue();

		if (operation == "add" || operation == "modify")
		{
			if (fromComp == "Source")
			{
				var srcValue = Ext.getCmp('Source').getValue();
				if (!Ext.isEmpty(srcValue) && srcValue == "Included")
				{
					var evt_src_ex = trim(Ext.getCmp('EVENT_SOURCES').getValue());
					var flag = this.checkEventSource(evt_src_ex,"Excluded");
					if (!flag)
					{
						Ext.getCmp('Source').setValue('Excluded');
						return;
					}

					var flag1 = this.checkForNoneKeyword(evt_src_ex,"EvtSrc","Excluded");
					if (!flag1)
					{
						Ext.getCmp('Source').setValue('Excluded');
						return;
					}

					var flag2 = this.checkForAllKeyword(evt_src_ex,"EvtSrc","Excluded");
					if (!flag2)
					{
						Ext.getCmp('Source').setValue('Excluded');
						return;
					}

					if (evt_src_ex == "none")
					{
						if (EvScIn == "" || EvScIn == undefined)
						{
							Ext.getCmp('EvScIn').setValue("all");
						}
					}
					else
					{
						Ext.getCmp('EvScIn').setValue("all");
					}

					Ext.getCmp('EvScEx').setValue(evt_src_ex);
					Ext.getCmp('EVENT_SOURCES').setValue(Ext.getCmp('EvScIn').getValue());
				}
				else
				{
					var evt_src_in = trim(Ext.getCmp('EVENT_SOURCES').getValue());
					var flag = this.checkEventSource(evt_src_in,"Included");
					if (!flag)
					{
						Ext.getCmp('Source').setValue('Included');
						return;
					}

					var flag1 = this.checkForAllKeyword(evt_src_in,"EvtSrc","Included");
					if (!flag1)
					{
						Ext.getCmp('Source').setValue('Included');
						return;
					}

					var flag2 = this.checkForNoneKeyword(evt_src_in,"EvtSrc","Included");
					if (!flag2)
					{
						Ext.getCmp('Source').setValue('Included');
						return;
					}

					if (evt_src_in == "all")
					{
						if (EvScEx == "" || EvScEx == undefined)
						{
							Ext.getCmp('EvScEx').setValue("none");
						}
					}
					else
					{
						Ext.getCmp('EvScEx').setValue("none");
					}
					Ext.getCmp('EvScIn').setValue(evt_src_in);
					Ext.getCmp('EVENT_SOURCES').setValue(Ext.getCmp('EvScEx').getValue());
				}
			}
			else if (fromComp == "Id")
			{
				var IdValue = Ext.getCmp('Id').getValue();
				if (!Ext.isEmpty(IdValue) && IdValue == "Included")
				{
					var evt_id_ex = trim(Ext.getCmp('EVENT_IDS').getValue());
					var flag = this.checkEventID(evt_id_ex,"Excluded");

					if (!flag)
					{
						Ext.getCmp('Id').setValue('Excluded');
						Ext.getCmp('EVENT_IDS').focus(true);
						return false;
					}

					if (evt_id_ex == "none")
					{
						if (EvIdIn.value == "")
						{
							Ext.getCmp('EvIdIn').setValue("all");
						}
					}
					else
					{
						Ext.getCmp('EvIdIn').setValue("all");
					}

					Ext.getCmp('EvIdEx').setValue(evt_id_ex);;
					Ext.getCmp('EVENT_IDS').setValue(Ext.getCmp('EvIdIn').getValue());
				}
				else
				{
					var evt_id_in = trim(Ext.getCmp('EVENT_IDS').getValue());
					var flag = this.checkEventID(evt_id_in,"Included");
					if (!flag)
					{
						Ext.getCmp('Id').setValue('Included');
						Ext.getCmp('EVENT_IDS').focus(true);
						return false;
					}

					if (evt_id_in == "all")
					{
						if (EvIdEx == "")
						{
							Ext.getCmp('EvIdEx').setValue("none");
						}
					}
					else
					{
						Ext.getCmp('EvIdEx').setValue("none");
					}

					Ext.getCmp('EvIdIn').setValue(evt_id_in);;
					Ext.getCmp('EVENT_IDS').setValue(Ext.getCmp('EvIdEx').getValue());
				}
			}
			else if (fromComp == "Desc_SL")
			{
				var descValue = Ext.getCmp('Desc_SL').getValue();
				if (!Ext.isEmpty(descValue) && descValue == "Included")
				{
					var evt_desc_ex = trim(Ext.getCmp('EVENT_DESCRIPTIONS_SL').getValue());
					var flag = this.checkEventDescriptionSL(evt_desc_ex,"Excluded");
					if (!flag)
					{
						Ext.getCmp('Desc_SL').setValue('Excluded');
						//return;
					}

					var flag1 = this.checkForNoneKeywordSL(evt_desc_ex,"Excluded");
					if (!flag1)
					{
						Ext.getCmp('Desc_SL').setValue('Excluded');
						//return;
					}

					var flag2 = this.checkForAllKeywordSL(evt_desc_ex,"Excluded");
					if (!flag2)
					{
						Ext.getCmp('Desc_SL').setValue('Excluded');
						//return;
					}

					if (evt_desc_ex == "none")
					{
						if (EvDescIn_SL == "" || EvDescIn_SL == undefined)
						{
							Ext.getCmp('EvDescIn_SL').setValue("all");
						}
					}
					else
					{
						Ext.getCmp('EvDescIn_SL').setValue("all");
					}

					Ext.getCmp('EvDescEx_SL').setValue(evt_desc_ex);
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(Ext.getCmp('EvDescIn_SL').getValue());
				}
				else
				{
					var evt_desc_in = trim(Ext.getCmp('EVENT_DESCRIPTIONS_SL').getValue());
					var flag = this.checkEventDescriptionSL(evt_desc_in,"Included");
					if (!flag)
					{
						Ext.getCmp('Desc_SL').setValue('Included');
						return;
					}

					var flag1 = this.checkForAllKeywordSL(evt_desc_in,"Included");
					if (!flag1)
					{
						Ext.getCmp('Desc_SL').setValue('Included');
						//return;
					}

					var flag2 = this.checkForNoneKeywordSL(evt_desc_in,"Included");
					if (!flag2)
					{
						Ext.getCmp('Desc_SL').setValue('Included');
						//return;
					}

					if (evt_desc_in == "all")
					{
						if (EvDescEx == "" || EvDescEx == undefined)
						{
							Ext.getCmp('EvDescEx_SL').setValue("none");
						}
					}
					else
					{
						Ext.getCmp('EvDescEx_SL').setValue("none");
					}

					Ext.getCmp('EvDescIn_SL').setValue(evt_desc_in);
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(Ext.getCmp('EvDescEx_SL').getValue());
				}
			}
			else
			{
				var descValue = Ext.getCmp('Desc').getValue();
				if (!Ext.isEmpty(descValue) && descValue == "Included")
				{
					var evt_desc_ex = trim(Ext.getCmp('EVENT_DESCRIPTIONS').getValue());
					var flag = this.checkEventDescription(evt_desc_ex,"Excluded");
					if (!flag)
					{
						Ext.getCmp('Desc').setValue('Excluded');
						//return;
					}

					var flag1 = this.checkForNoneKeyword(evt_desc_ex,"EvtDesc","Excluded");
					if (!flag1)
					{
						Ext.getCmp('Desc').setValue('Excluded');
						//return;
					}

					var flag2 = this.checkForAllKeyword(evt_desc_ex,"EvtDesc","Excluded");
					if (!flag2)
					{
						Ext.getCmp('Desc').setValue('Excluded');
						//return;
					}

					if (evt_desc_ex == "none")
					{
						if (EvDescIn == "" || EvDescIn == undefined)
						{
							Ext.getCmp('EvDescIn').setValue("all");
						}
					}
					else
					{
						Ext.getCmp('EvDescIn').setValue("all");
					}

					Ext.getCmp('EvDescEx').setValue(evt_desc_ex);
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(Ext.getCmp('EvDescIn').getValue());
				}
				else
				{
					var evt_desc_in = trim(Ext.getCmp('EVENT_DESCRIPTIONS').getValue());
					var flag = this.checkEventDescription(evt_desc_in,"Included");
					if (!flag)
					{
						Ext.getCmp('Desc').setValue('Included');
						return;
					}

					var flag1 = this.checkForAllKeyword(evt_desc_in,"EvtDesc","Included");
					if (!flag1)
					{
						Ext.getCmp('Desc').setValue('Included');
						//return;
					}

					var flag2 = this.checkForNoneKeyword(evt_desc_in,"EvtDesc","Included");
					if (!flag2)
					{
						Ext.getCmp('Desc').setValue('Included');
						//return;
					}

					if (evt_desc_in == "all")
					{
						if (EvDescEx == "" || EvDescEx == undefined)
						{
							Ext.getCmp('EvDescEx').setValue("none");
						}
					}
					else
					{
						Ext.getCmp('EvDescEx').setValue("none");
					}

					Ext.getCmp('EvDescIn').setValue(evt_desc_in);
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(Ext.getCmp('EvDescEx').getValue());
				}
			}
		}
		else if (operation == "view")
		{
			if (fromComp == "Source")
			{
				var srcValue = Ext.getCmp('Source').getValue();
				if (!Ext.isEmpty(srcValue) && srcValue == "Included")
				{
					Ext.getCmp('EVENT_SOURCES').setValue(Ext.getCmp('EvScIn').getValue());
				}
				else
				{
					Ext.getCmp('EVENT_SOURCES').setValue(Ext.getCmp('EvScEx').getValue());
				}
			}
			else if(fromComp == "Id")
			{
				var idValue = Ext.getCmp('Id').getValue();
				if (!Ext.isEmpty(idValue) && idValue == "Included")
				{
					Ext.getCmp('EVENT_IDS').setValue(Ext.getCmp('EvIdIn').getValue());
				}
				else
				{
					Ext.getCmp('EVENT_IDS').setValue(Ext.getCmp('EvIdEx').getValue());
				}
			}
			else if(fromComp == "Desc_SL")
			{
				var descValue = Ext.getCmp('Desc_SL').getValue();
				if (!Ext.isEmpty(descValue) && descValue == "Included")
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(Ext.getCmp('EvDescIn_SL').getValue());
				}
				else
				{
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(Ext.getCmp('EvDescEx_SL').getValue());
				}
			}
			else
			{
				var descValue = Ext.getCmp('Desc').getValue();
				if (!Ext.isEmpty(descValue) && descValue == "Included")
				{
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(Ext.getCmp('EvDescIn').getValue());
				}
				else
				{
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(Ext.getCmp('EvDescEx').getValue());
				}
			}
		}
	},
	windowCloseEvent: function() {
		if ( !Ext.isEmpty(deletedRecords) && deletedRecords != undefined )
		{
			var tempStore = new Array();
			var filterComboObj = Ext.getCmp('filter_combo');
			if (deletedRecords.indexOf(",") != -1)
			{
				var delRecArray = new Array();
				delRecArray = deletedRecords.split(',');
				for (var i=0;i<delRecArray.length ;i++ )
				{
					if (Ext.isEmpty(delRecArray[i].toString().trim()) || delRecArray[i].toString().trim() == undefined)
					{
						continue;
					}
					var index = filterComboObj.getStore().find( 'valueField', delRecArray[i].toString(), 0, false, true, true ) ;
					filterComboObj.getStore().removeAt(index);
				}
			}
			else
			{
				var index = filterComboObj.getStore().find( 'valueField', deletedRecords.toString(), 0, false, true, true ) ;
				filterComboObj.getStore().removeAt(index);
			}
			deletedRecords = '';
			var selectedPolValue = Ext.getCmp('filter_combo').getValue();
			var availPoliciesCount = Ext.getCmp('filter_combo').getStore().getCount();
			if (!Ext.isEmpty(availPoliciesCount) && availPoliciesCount > 0)
			{
				for (var i =0;i < availPoliciesCount ; i++)
				{
					var polNameObj = Ext.getCmp('filter_combo').getStore().getAt(i);
					if (!Ext.isEmpty(polNameObj))
					{
						var polName =  Ext.getCmp('filter_combo').getStore().getAt(i).get('valueField');
						if (!Ext.isEmpty(polName) && polName == 'all')
						{
							Ext.getCmp('filter_combo').getStore().removeAt(i);
						}
					}
				}
			}
			filterComboObj.getStore().sort('displayField', 'ASC');
			filterComboObj.getStore().insert(0,{displayField:'all', valueField:'all'});
			Ext.getCmp('filter_combo').setValue(selectedPolValue);
			availPoliciesCount = Ext.getCmp('filter_combo').getStore().getCount();
			if (!Ext.isEmpty(availPoliciesCount) && availPoliciesCount > 0)
			{
				availPolicies = new Array();
				for (var i =0;i < availPoliciesCount ; i++)
				{
					availPolicies[i] = filterComboObj.getStore().getAt(i).get('valueField');
				}
			}
		}
		else
		{
			var evtViewGrid = Ext.getCmp("EventsViewGrid");
			var evtViewGridStore = evtViewGrid.getStore();

			var filterComboObj = Ext.getCmp('filter_combo');
			var filterComboStore = filterComboObj.getStore();
			if (!Ext.isEmpty(evtViewGrid))
			{
				var count = evtViewGridStore.getCount();
				for (var c=0;c<count ;c++ )
				{
					var record = evtViewGridStore.getAt(c).get("Events")
					var index = filterComboObj.getStore().find( 'valueField', record.toString(), 0, false, true, true ) ;

					if (index == -1)
					{
						filterComboObj.getStore().add({displayField:record, valueField:record});
					}

				}
			}
		}
		//else
		//{
			//me.configViewPolicy();
			//Ext.getCmp('viewpolicy').destroy();
			//filter_combo
			//var tempStore = new Ext.data.Store({fields: ['displayField','valueField'],data: [{'displayField':policyName,'valueField':policyName}]});
			//console.log(tempStore);
			//var filterArr = publicJson['filterArr'];
			//var selectedPolicyFilter = publicJson['selectedPolicyFilter'];
			//var tempStore = new Array();
			//tempStore.push({'displayField': policyName,'valueField': policyName});
			//Ext.getCmp('filter_combo').getStore().suspendEvents(true);
			//var filterComboObj = Ext.getCmp('filter_combo');
			//if ( !Ext.isEmpty(deletedRecords) && deletedRecords != undefined)
			//{
				//var tempStore = new Array();
				//if (deletedRecords.indexOf(",") != -1)
				//{
					//var delRecArray = new Array();
					//delRecArray = deletedRecords.split(',');
					//for (var i=0;i<delRecArray.length ;i++ )
					//{
						//var index = filterComboObj.getStore().find( 'valueField', delRecArray[i].toString(), 0, false, true, true ) ;
						//filterComboObj.getStore().removeAt(index);
					//}
				//}
				//else
				//{
					//var index = filterComboObj.getStore().find( 'valueField', deletedRecords.toString(), 0, false, true, true ) ;
					//filterComboObj.getStore().removeAt(index);
				//}
				//deletedRecords = '';
			//}

			//Ext.getCmp('filter_combo').getStore().removeAt(0);
			//filterComboObj.getStore().add({displayField:policyName, valueField:policyName});
			//filterComboObj.getStore().sort('displayField', 'ASC');
			//filterComboObj.getStore().insert(0,{displayField:'all', valueField:'all'});
		//}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	checkForAllKeywordSL: function (strValue,strOption) {
		var alertAllKeywordMsg = '';
		if (strValue.indexOf(",") > -1)
		{
			var arr = new Array();
			arr = strValue.split(",");
			for (var i=0;i<arr.length;i++)
			{
				var arrValue = trim(arr[i]);
				if (arrValue.toLowerCase() == "all")
				{
					if (strOption == "Included")
					{
						alertAllKeywordMsg = alertMsg46;
					}
					else
					{
						alertAllKeywordMsg = alertMsg48;
					}
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertAllKeywordMsg ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}
		else if (trim(strValue.toLowerCase())=="all")
		{
			if (strOption == "Included")
			{
				var k = trim(strValue);
				for (var i=0;i<3;i++)
				{
					if (k.charAt(i)=="A" || k.charAt(i)=="L")
					{
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertMsg51 ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(response){
								Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
							}
						});
						return false;
					}
				}
			}
			else
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg54 ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	checkForAllKeyword: function (strValue,strSource,strOption) {
		var field_Name = polCreationJson['fieldName'];
		var alertAllKeywordMsg = '';
		if (strValue.indexOf(",") > -1)
		{
			var arr = new Array();
			arr = strValue.split(",");
			for (var i=0;i<arr.length;i++)
			{
				var arrValue = trim(arr[i]);
				if (arrValue.toLowerCase() == "all")
				{
					if (strSource == "EvtSrc")
					{
						if (strOption == "Included")
						{
							alertAllKeywordMsg = alertMsg44;
						}
						else
						{
							alertAllKeywordMsg = alertMsg45;
						}
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertAllKeywordMsg ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
					else
					{
						if (strOption == "Included")
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertAllKeywordMsg = alertMsg46;
							}
							else
							{
								alertAllKeywordMsg = alertMsg47;
							}
						}
						else
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertAllKeywordMsg = alertMsg48;
							}
							else
							{
								alertAllKeywordMsg = alertMsg49;
							}
						}
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertAllKeywordMsg ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
					return false;
				}
			}
		}
		else if (trim(strValue.toLowerCase())=="all")
		{
			if (strOption == "Included")
			{
				var k = trim(strValue);
				for (var i=0;i<3;i++)
				{
					if (k.charAt(i)=="A" || k.charAt(i)=="L")
					{
						if (strSource == "EvtSrc")
						{
							Ext.Msg.show({
								title: polCreationPageName,
								msg: evtSrcMsg ,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(response){
									Ext.getCmp('EVENT_SOURCES').focus(true);
								}
							});
						}
						else
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertAllKeywordMsg = alertMsg51;
							}
							else
							{
								alertAllKeywordMsg = alertMsg52;
							}
							Ext.Msg.show({
								title: polCreationPageName,
								msg: alertAllKeywordMsg ,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(response){
									Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
								}
							});
						}
						return false;
					}
				}
			}
			else
			{
				if (strSource == "EvtSrc")
				{
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertMsg53 ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response){
							Ext.getCmp('EVENT_SOURCES').focus(true);
						}
					});
				}
				else
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						alertAllKeywordMsg = alertMsg54;
					}
					else
					{
						alertAllKeywordMsg = alertMsg55;
					}
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertAllKeywordMsg ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response){
							Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
						}
					});
				}
				return false;
			}
		}
		return true;
	},
	checkForNoneKeywordSL: function (strValue,strOption) {
		var alertNoneMsg = '';
		if(strValue.indexOf(",") > -1)
		{
			var arr = new Array();
			arr = strValue.split(",");
			for (var i=0;i<arr.length;i++)
			{
				var arrValue = trim(arr[i]);
				if (arrValue.toLowerCase() == "none")
				{
					if (strOption == "Included")
					{
						alertNoneMsg = alertMsg58;
					}
					else
					{
						alertNoneMsg = alertMsg60;
					}
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertNoneMsg ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}
		else if (trim(strValue.toLowerCase())=="none")
		{
			if (strOption =="Included")
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg63 ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					}
				});
				return false;
			}
			else
			{
				var k = trim(strValue);
				for (var i=0;i<4;i++)
				{
					if (k.charAt(i)=="N" || k.charAt(i)=="O" || k.charAt(i)=="E")
					{
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertMsg66,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(response){
								Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
							}
						});
						return false;
					}
				}
			}
		}
		return true;
	},
	checkForNoneKeyword: function (strValue,strSource,strOption) {
		var field_Name = polCreationJson['fieldName'];
		var alertNoneMsg = '';
		if(strValue.indexOf(",") > -1)
		{
			var arr = new Array();
			arr = strValue.split(",");
			for (var i=0;i<arr.length;i++)
			{
				var arrValue = trim(arr[i]);
				if (arrValue.toLowerCase() == "none")
				{
					if (strSource == "EvtSrc")
					{
						if (strOption == "Included")
						{
							alertNoneMsg = alertMsg56;
						}
						else
						{
							alertNoneMsg = alertMsg57;
						}
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertNoneMsg ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
					else
					{
						if (strOption == "Included")
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertNoneMsg = alertMsg58;
							}
							else
							{
								alertNoneMsg = alertMsg59;
							}
						}
						else
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertNoneMsg = alertMsg60;
							}
							else
							{
								alertNoneMsg = alertMsg61;
							}
						}
						Ext.Msg.show({
							title: polCreationPageName,
							msg: alertNoneMsg ,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
					return false;
				}
			}
		}
		else if (trim(strValue.toLowerCase())=="none")
		{
			if (strOption =="Included")
			{
				if (strSource == "EvtSrc")
				{
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertMsg62 ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response){
							Ext.getCmp('EVENT_SOURCES').focus(true);
						}
					});
					return false;
				}
				else
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						alertNoneMsg = alertMsg63;
					}
					else
					{
						alertNoneMsg = alertMsg64;
					}
					Ext.Msg.show({
						title: polCreationPageName,
						msg: alertNoneMsg ,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response){
							Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
						}
					});
					return false;
				}
			}
			else
			{
				var k = trim(strValue);
				for (var i=0;i<4;i++)
				{
					if (k.charAt(i)=="N" || k.charAt(i)=="O" || k.charAt(i)=="E")
					{
						if (strSource == "EvtSrc")
						{
							Ext.Msg.show({
								title: polCreationPageName,
								msg: alertMsg65 ,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(response){
									Ext.getCmp('EVENT_SOURCES').focus(true);
								}
							});
							return false;
						}
						else
						{
							if (field_Name == "EVENT DESCRIPTIONS")
							{
								alertNoneMsg = alertMsg66;
							}
							else
							{
								alertNoneMsg = alertMsg67;
							}
							Ext.Msg.show({
								title: polCreationPageName,
								msg: alertNoneMsg ,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(response){
									Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
								}
							});
							return false;
						}
					}
				}
			}
		}
		return true;
	},
	checkEventSource: function(eventSource,eventOption) {
		var evtSrcMsg = '';
		if (Ext.isEmpty(eventSource) || eventSource == undefined)
		{
			if (eventOption == "Included")
			{
				evtSrcMsg = alertMsg18;
			}
			else
			{
				evtSrcMsg = alertMsg19;
			}
			Ext.Msg.show({
				title: polCreationPageName,
				msg: evtSrcMsg ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response){
					Ext.getCmp('EVENT_SOURCES').focus(true);
				}
			});

			return false;
		}
		if (eventSource != null && eventSource != "")
		{
			if (eventSource.indexOf(",") == 0 || eventSource.lastIndexOf(",") == (eventSource.length-1))
			{
				if (eventOption == "Included")
				{
					evtSrcMsg = alertMsg20;
				}
				else
				{
					evtSrcMsg = alertMsg21;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtSrcMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_SOURCES').focus(true);
					}
				});
				return false;
			}
			if (eventSource.indexOf(",,") > 0)
			{
				if (eventOption == "Included")
				{
					evtSrcMsg = alertMsg22;
				}
				else
				{
					evtSrcMsg = alertMsg23;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtSrcMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_SOURCES').focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	checkEventID: function (eventID,eventOption) {
		var eventid_regexp = /^[0-9,]+$/;
		var evtIdMsg = '';
		if (Ext.isEmpty(eventID) || eventID == undefined)
		{
			if (eventOption == "Included")
			{
				evtIdMsg = alertMsg24;
			}
			else
			{
				evtIdMsg = alertMsg25;
			}
			Ext.Msg.show({
				title: polCreationPageName,
				msg: evtIdMsg ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response){
					Ext.getCmp('EVENT_IDS').focus(true);
				}
			});
			return false;
		}
		if (eventID != null && eventID != "")
		{
			var eventidresult = eventid_regexp.test(eventID);
			if(eventOption == "Included" && eventID != "all" && !eventidresult)
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg29,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_IDS').focus(true);
					}
				});
				return false;
			}
			else if(eventOption == "Excluded" && eventID != "none" && !eventidresult)
			{
				Ext.Msg.show({
					title: polCreationPageName,
					msg: alertMsg28,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_IDS').focus(true);
					}
				});
				return false;
			}
			if (eventID.indexOf(",")==0 || eventID.lastIndexOf(",") == (eventID.length-1))
			{
				if (eventOption == "Included")
				{
					evtIdMsg = alertMsg26;
				}
				else
				{
					evtIdMsg = alertMsg27;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtIdMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_IDS').focus(true);
					}
				});
				return false;
			}
			if (eventID.indexOf(",,")>0)
			{
				if (eventOption == "Included")
				{
					evtIdMsg = alertMsg30;
				}
				else
				{
					evtIdMsg = alertMsg31;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtIdMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_IDS').focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	checkEventDescriptionSL: function (eventDescription,eventOption) {
		var evtDescMsg = '';
		if (Ext.isEmpty(eventDescription) || eventDescription == undefined)
		{
			if (eventOption == "Included")
			{
				evtDescMsg = alertMsg32;
			}
			else
			{
				evtDescMsg = alertMsg34;
			}
			Ext.Msg.show({
				title: polCreationPageName,
				msg: evtDescMsg ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response){
					Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
				}
			});
			return false;
		}
		else
		{
			if (eventDescription.indexOf(",")==0 || eventDescription.lastIndexOf(",") == (eventDescription.length-1))
			{
				if (eventOption == "Included")
				{
					evtDescMsg = alertMsg36;
				}
				else
				{
					evtDescMsg = alertMsg37;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtDescMsg ,
					buttons: Ext.Msg.OK,
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					}
				});
				return false;
			}
			if (eventDescription.indexOf(",,")>0)
			{
				if (eventOption == "Included")
				{
					evtDescMsg = alertMsg40;
				}
				else
				{
					evtDescMsg = alertMsg42;
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtDescMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	checkEventDescription: function (eventDescription,eventOption,obj) {
		var evtDescMsg = '';
		var field_Name = polCreationJson['fieldName'];
		if (Ext.isEmpty(eventDescription) || eventDescription == undefined)
		{
			if (eventOption == "Included")
			{
				if (field_Name == "EVENT DESCRIPTIONS")
				{
					evtDescMsg = alertMsg32;
				}
				else
				{
					evtDescMsg = alertMsg33;
				}
			}
			else
			{
				if (field_Name == "EVENT DESCRIPTIONS")
				{
					evtDescMsg = alertMsg34;
				}
				else
				{
					evtDescMsg = alertMsg35;
				}
			}
			Ext.Msg.show({
				title: polCreationPageName,
				msg: evtDescMsg ,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response){
					Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
				}
			});
			return false;
		}
		if (eventDescription != null && eventDescription != "")
		{
			if (eventDescription.indexOf(",")==0 || eventDescription.lastIndexOf(",") == (eventDescription.length-1))
			{
				if (eventOption == "Included")
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						evtDescMsg = alertMsg36;
					}
					else
					{
						evtDescMsg = alertMsg38;
					}
				}
				else
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						evtDescMsg = alertMsg37;
					}
					else
					{
						evtDescMsg = alertMsg39;
					}
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtDescMsg ,
					buttons: Ext.Msg.OK,
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
					}
				});
				return false;
			}
			if (eventDescription.indexOf(",,")>0)
			{
				if (eventOption == "Included")
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						evtDescMsg = alertMsg40;
					}
					else
					{
						evtDescMsg = alertMsg41;
					}
				}
				else
				{
					if (field_Name == "EVENT DESCRIPTIONS")
					{
						evtDescMsg = alertMsg42;
					}
					else
					{
						evtDescMsg = alertMsg43;
					}
				}
				Ext.Msg.show({
					title: polCreationPageName,
					msg: evtDescMsg ,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response){
						Ext.getCmp('EVENT_DESCRIPTIONS').focus(true);
					}
				});
				return false;
			}
		}
		return true;
	},
	handleDeleteSelectedInter: function() {
		var grid = Ext.getCmp('EventsViewGrid').getSelectionModel().getSelection();
		var values = '';
		var selectedPolicies = '';
		var array=new Array();
		var selectedGroups="";
		if(grid == "")
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg71,
				icon:'iconExclamation',
				buttons: Ext.Msg.OK
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values = grid[i];
			id = values.get('Events');
			if(id != null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedPolicies +=array[j]+",";
		}
		Ext.Msg.show ({
			title: pageName,
			msg: alertMsg70,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == "yes")
				{
					if (Ext.isEmpty(deletedRecords) || deletedRecords == '')
					{
						deletedRecords = selectedPolicies;
					}
					else
					{
						deletedRecords += ','+selectedPolicies;
					}
					var server = jsonVal['server'];
					var test = jsonVal['parmTestName'];
					var logtype = jsonVal['logtype'];
					var show = jsonVal['showAll'];
					var requestFrom = jsonVal['requestFrom'];
					var q = jsonVal['q'];
					var currentLogType = Ext.getCmp('logType').getValue();
					urlVal = "SpecificTestConfiguration/data/ViewPolicyJson.jsp?server="+encodeURIComponent(server)+"&test="+test+"&policy="+encodeURI(selectedPolicies)+"&delpolicy=yes&log_type="+currentLogType+"&showAll="+show+"&q="+q+"&logtype="+currentLogType+"&requestFrom="+requestFrom+"&currentLogType="+currentLogType;
					Ext.Ajax.request({
						url:urlVal,
						method:'post',
						scope:this,
						success:function(response)
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = response.responseText;
								var policyJsonObj = Ext.decode(jsonText);
								Ext.getCmp('EventsViewGrid').getStore().removeAll();
								Ext.getCmp('EventsViewGrid').getStore().loadRawData(policyJsonObj['gridDataArr']);
								Ext.getCmp('EventsViewGrid').getSelectionModel().deselectAll(true);
							}
						}
					});
				}
			}
		});
	},
	handleEditIconClickInter: function(view, rowIndex, colIndex, column, e) {
		var task = Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex);
		this.showEditWindow(task);
    },
	showEditWindow: function(task) {
		var policyName = task.get('Events');
        var me = this;
        var taskEditWindow = Ext.create('SpecificTestConfiguration.view.EgPolicyCreation');
		var currentLogType = Ext.getCmp('logType').getValue();

		var qStr = "change=modify&policy="+policyName+"&server="+jsonVal['server']+"&test="+jsonVal['parmTestName']+"&showAll="+jsonVal['showAll']+"&q="+jsonVal['q']+"&logtype="+currentLogType+"&requestFrom="+jsonVal['requestFrom'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgPolicyCreationJson.jsp?'+qStr,
			method:'post',
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					polCreationJson = Ext.decode(jsonText);
					taskEditWindow.setTitle(modifyPolicyTitle);
					taskEditWindow.show();

					var polName = polCreationJson['pol_name'];
					var selectedEvtId = polCreationJson['selectedEvtId'];
					var EvtidText = polCreationJson['EvtidText'];
					var selectedEvtSource = polCreationJson['selectedEvtSource'];
					var EvtsourceText = polCreationJson['EvtsourceText'];
					var selectedEvtDesc = polCreationJson['selectedEvtDesc'];
					var EvtdescText = polCreationJson['EvtdescText'];
					var isReadOnly = polCreationJson['isReadOnly'];
					var isReadOnlyText = polCreationJson['isReadOnlyText'];
					Ext.getCmp('pol_name').setValue(polName);
					if (!Ext.isEmpty(isReadOnly) && isReadOnly != undefined)
					{
						Ext.getCmp('pol_name').setReadOnly(true);
					}
					Ext.getCmp('Source').setValue(selectedEvtSource);
					Ext.getCmp('EVENT_SOURCES').setValue(EvtsourceText);
					Ext.getCmp('Id').setValue(selectedEvtId);
					Ext.getCmp('EVENT_IDS').setValue(EvtidText);
					Ext.getCmp('Desc').setValue(selectedEvtDesc);
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(EvtdescText);
					if (!Ext.isEmpty(isReadOnlyText) && isReadOnlyText != undefined)
					{
						Ext.getCmp('EVENT_SOURCES').setReadOnly(true);
						Ext.getCmp('EVENT_IDS').setReadOnly(true);
						Ext.getCmp('EVENT_DESCRIPTIONS').setReadOnly(true);
					}
					var EvScIn = Ext.getCmp('EvScIn').setValue(polCreationJson['hiddenPolicyObj']['EvScIn']);
					var EvScEx = Ext.getCmp('EvScEx').setValue(polCreationJson['hiddenPolicyObj']['EvScEx']);
					var EvIdIn = Ext.getCmp('EvIdIn').setValue(polCreationJson['hiddenPolicyObj']['EvIdIn']);
					var EvIdEx = Ext.getCmp('EvIdEx').setValue(polCreationJson['hiddenPolicyObj']['EvIdEx']);
					var EvDescIn = Ext.getCmp('EvDescIn').setValue(polCreationJson['hiddenPolicyObj']['EvDescIn']);
					var EvDescEx = Ext.getCmp('EvDescEx').setValue(polCreationJson['hiddenPolicyObj']['EvDescEx']);
					Ext.getCmp('EvtLogDescriptors').setValue(polCreationJson['hiddenPolicyObj']['EvtLogDescriptors']);

					var testName = polCreationJson['hiddenPolicyObj']['testName'];
					if (!Ext.isEmpty(testName) && testName == 'SecurityLogTest')
					{
						Ext.getCmp('evtdescriptors').setFieldLabel('EVENT USERS');

						Ext.getCmp('evtdescriptors_SL').show();
						Ext.getCmp('mainContainer').setAutoScroll(true);
						Ext.getCmp('mainContainer').setHeight(430);

						var selectedEvtDesc_SL = polCreationJson['selectedEvtDesc_SL'];
						var EvtdescText_SL = polCreationJson['EvtdescText_SL'];

						Ext.getCmp('Desc_SL').setValue(selectedEvtDesc_SL);
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(EvtdescText_SL);

						if (!Ext.isEmpty(isReadOnlyText) && isReadOnlyText != undefined)
						{
							Ext.getCmp('EVENT_DESCRIPTIONS_SL').setReadOnly(true);
						}
						Ext.getCmp('EvDescIn_SL').setValue(polCreationJson['hiddenPolicyObj']['EvDescIn_SL']);
						Ext.getCmp('EvDescEx_SL').setValue(polCreationJson['hiddenPolicyObj']['EvDescEx_SL']);
					}
				}
			}
		});
	},
	handleViewIconClickInter: function(view, rowIndex, colIndex) {
		var task = Ext.getCmp('EventsViewGrid').getStore().getAt(rowIndex);
		this.viewPolicyTask(task);
    },
	viewPolicyTask: function(task) {
		var policyName = task.get('Events');
        var me = this;
        var taskEditWindow = Ext.create('SpecificTestConfiguration.view.EgPolicyCreation');
		var currentLogType = Ext.getCmp('logType').getValue();

		var qStr = "change=view&policy="+policyName+"&server="+encodeURIComponent(jsonVal['server'])+"&test="+jsonVal['parmTestName']+"&showAll="+jsonVal['showAll']+"&q="+jsonVal['q']+"&logtype="+currentLogType+"&requestFrom="+jsonVal['requestFrom'];

		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgPolicyCreationJson.jsp?'+qStr,
			method:'post',
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					polCreationJson = Ext.decode(jsonText);
					taskEditWindow.setTitle(viewPolicyTitle);
					taskEditWindow.show();
					Ext.getCmp('egpolicycreation').removeDocked(Ext.getCmp('dockedToolBarBtn'));
					var polName = polCreationJson['pol_name'];
					var selectedEvtId = polCreationJson['selectedEvtId'];
					var EvtidText = polCreationJson['EvtidText'];
					var selectedEvtSource = polCreationJson['selectedEvtSource'];
					var EvtsourceText = polCreationJson['EvtsourceText'];
					var selectedEvtDesc = polCreationJson['selectedEvtDesc'];
					var EvtdescText = polCreationJson['EvtdescText'];
					var isReadOnly = polCreationJson['isReadOnly'];
					var isReadOnlyText = polCreationJson['isReadOnlyText'];
					Ext.getCmp('pol_name').setValue(policyName);
					if (!Ext.isEmpty(isReadOnly) && isReadOnly != undefined)
					{
						Ext.getCmp('pol_name').setReadOnly(true);
					}
					Ext.getCmp('Source').setValue(selectedEvtSource);
					Ext.getCmp('EVENT_SOURCES').setValue(EvtsourceText);
					Ext.getCmp('Id').setValue(selectedEvtId);
					Ext.getCmp('EVENT_IDS').setValue(EvtidText);
					Ext.getCmp('Desc').setValue(selectedEvtDesc);
					Ext.getCmp('EVENT_DESCRIPTIONS').setValue(EvtdescText);
					if (!Ext.isEmpty(isReadOnlyText) && isReadOnlyText != undefined)
					{
						Ext.getCmp('EVENT_SOURCES').setReadOnly(true);
						Ext.getCmp('EVENT_IDS').setReadOnly(true);
						Ext.getCmp('EVENT_DESCRIPTIONS').setReadOnly(true);
					}
					var EvScIn = Ext.getCmp('EvScIn').setValue(polCreationJson['hiddenPolicyObj']['EvScIn']);
					var EvScEx = Ext.getCmp('EvScEx').setValue(polCreationJson['hiddenPolicyObj']['EvScEx']);
					var EvIdIn = Ext.getCmp('EvIdIn').setValue(polCreationJson['hiddenPolicyObj']['EvIdIn']);
					var EvIdEx = Ext.getCmp('EvIdEx').setValue(polCreationJson['hiddenPolicyObj']['EvIdEx']);
					var EvDescIn = Ext.getCmp('EvDescIn').setValue(polCreationJson['hiddenPolicyObj']['EvDescIn']);
					var EvDescEx = Ext.getCmp('EvDescEx').setValue(polCreationJson['hiddenPolicyObj']['EvDescEx']);
					Ext.getCmp('EvtLogDescriptors').setValue(polCreationJson['hiddenPolicyObj']['EvtLogDescriptors']);

					var testName = polCreationJson['hiddenPolicyObj']['testName'];
					if (!Ext.isEmpty(testName) && testName == 'SecurityLogTest')
					{
						Ext.getCmp('evtdescriptors').setFieldLabel('EVENT USERS');

						Ext.getCmp('evtdescriptors_SL').show();
						Ext.getCmp('mainContainer').setAutoScroll(true);
						Ext.getCmp('mainContainer').setHeight(430);

						var selectedEvtDesc_SL = polCreationJson['selectedEvtDesc_SL'];
						var EvtdescText_SL = polCreationJson['EvtdescText_SL'];

						Ext.getCmp('Desc_SL').setValue(selectedEvtDesc_SL);
						Ext.getCmp('EVENT_DESCRIPTIONS_SL').setValue(EvtdescText_SL);

						if (!Ext.isEmpty(isReadOnlyText) && isReadOnlyText != undefined)
						{
							Ext.getCmp('EVENT_DESCRIPTIONS_SL').setReadOnly(true);
						}
						Ext.getCmp('EvDescIn_SL').setValue(polCreationJson['hiddenPolicyObj']['EvDescIn_SL']);
						Ext.getCmp('EvDescEx_SL').setValue(polCreationJson['hiddenPolicyObj']['EvDescEx_SL']);
					}
				}
			}
		});
	},
	saveWebConfig: function() {  //Web Service Configuration
		var selectedService = Ext.getCmp('wsdlService').getValue();
		if(Ext.isEmpty(selectedService) || selectedService == undefined)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertWebMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var option = 'htmlview';
		var viewOption = Ext.getCmp('xmlandhtmlview').getActiveTab().getItemId();
		if (viewOption == 'xmlview')
		{
			option = 'xmlview'
		}

		var keyValues='';
		var requestMsg='';
		if(option=='htmlview')
		{
			//to get the input parameters -- start
			var parameters = [];
			var text='';
			var mainkeys=[];

			$("td[class='hiddentd x-grid-cell']").each(function(){
				var txt = $(this).text();
				//if(txt!='' && txt.indexOf("@#@")>-1)
					//txt = txt.substring(txt.lastIndexOf("@")+1);
				mainkeys.push(txt);
			});

			$("td[class='parameterName x-grid-cell']").each(function(){
					text=$(this).text();
					if(text.indexOf("*")>-1)
					{
						text = text.substring(0,text.indexOf("*"));
					}
					parameters.push(text);
			});
			var inputs = [];
			//$("#inputTbl").find("#inputRow").each(function(index){
			$("#inputTbl").find("tr#inputRow").each(function(index){
				var inputValue = '';
				inputValue = $.trim($(this).find("td:eq(2)").find("input#inputValue").val());
				if(inputValue=='' || inputValue=='undefined')
				{
					inputValue = $.trim($(this).find("td:eq(2)").find("select#selectValue").val());
				}
				if(inputValue!="undefined")
				{
					inputs.push(inputValue);
				}
			});
			$(".linesquare").find("#subinputRow").each(function(){

				var inputValue = '';
				inputValue = $.trim($(this).find("td:eq(2)").find("input#inputValue").val());
				if(inputValue=='' || inputValue=='undefined')
				{
					inputValue = $.trim($(this).find("td:eq(2)").find("select#selectValue").val());
				}
				if(inputValue!="undefined")
				{
					inputs.push(inputValue);
				}
			});
			var your_obj = this.combine(mainkeys, parameters, inputs);//alert(your_obj);
			for(var y=0;y<your_obj.length;y++)
			{
				keyValues=keyValues+"~"+your_obj[y];
			}
			if(keyValues.indexOf('~') == 0)
			{
				keyValues = keyValues.substring(keyValues.indexOf(",")+1);
			}
		//end
		}
		else if(option=='xmlview')
		{
			requestMsg = $('#soapRequest').val();
		}


		//if(option=='htmlview')
		//{
			////to get the input parameters -- start
			//var parameters = [];
			//var text='';
			//var mainkeys=[];

			//var hiddentd = Ext.getCmp('hiddentd').getValue();
			//if (!Ext.isEmpty(hiddentd) && hiddentd != undefined)
			//{
				//mainkeys.push(hiddentd);
			//}

			//var parameterName = Ext.getCmp('parameterName').getValue();
			//if (!Ext.isEmpty(parameterName) && parameterName != undefined)
			//{
				//parameters.push(parameterName);
			//}

			//var inputs = [];

			//var inputValue = Ext.getCmp('inputValue').getValue();
			//if(Ext.isEmpty(inputValue)  || inputValue == undefined)
			//{
				//inputValue = Ext.getCmp('selectValue').getValue();
			//}
			//if(Ext.isEmpty(inputValue)  || inputValue == undefined)
			//{
				//inputs.push('');
			//}
			//else
			//{
				//inputs.push(inputValue);
			//}
			//var your_obj = this.combine(mainkeys, parameters, inputs);//alert(your_obj);
			//for(var y=0;y<your_obj.length;y++)
			//{
				//keyValues=keyValues+"~"+your_obj[y];
			//}
			//if(keyValues.indexOf('~') == 0)
			//{
				//keyValues = keyValues.substring(keyValues.indexOf(",")+1);
			//}
		//}
		//else if(option=='xmlview')
		//{
			////requestMsg = Ext.getCmp('soapRequest').getValue();
			//requestMsg = $('#soapRequest').val();
			//alert('requestMsg : '+requestMsg);
		//}

		var operations = '';
		var selectedOperation = Ext.getCmp('wsdlOperation').fromField.getValue();
		var fromFieldData = Ext.getCmp('wsdlOperation').fromField.store;
		if (fromFieldData.getCount() > 1)
		{
			for (var i=0; i< fromFieldData.getCount();i++ )
			{
				var tmpData = fromFieldData.getAt(i).get('valueField');
				if (!Ext.isEmpty(tmpData) && tmpData != undefined)
				{
					operations +=','+tmpData;
				}
			}
		}
		else
		{
			operations = selectedOperation;
		}
		if(operations.indexOf(',') == 0)
		{
			operations = operations.substring(operations.indexOf(",")+1);
		}

		var wsdlOperationObj = Ext.getCmp('wsdlOperation');
		var wsdlOperationFromFieldStore = wsdlOperationObj.fromField.store;
		var wsdlOperationToFieldStore = wsdlOperationObj.toField.store;

		var wsdlMain = publicWebServJSON['wsdl'];
		var mainOperation = publicfinalwebJSON['mainOperation'];
		var componentName = publicWebServJSON['componentName'];
		var wsdlurl = Ext.getCmp('wsdlUrl').getValue();
		var credentialWithPattern = publicWebServJSON['credentialWithPattern'];
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var configMode = Ext.getCmp('agentListObj').getValue();
		var from = 'save';
		var associatedOp = operations;

		var myMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
			method: 'POST',
			params: 'selectedUrlValue='+encodeURI(wsdlurl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&associatedOp="+encodeURI(associatedOp)+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
			timeout: 6000000,
			success: function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var publicSaveJson = Ext.decode(jsonText);
					var alertMsg = publicSaveJson['defaultMsg'];
					if(configMode != 'EgManager' && option == 'htmlview')
					{
						if(alertMsg=='Failed to get required configuration information from agent' || alertMsg=='Agent not installed or not running')
						{
							Ext.Msg.show({
								title: pageName,
								msg: alertMsg,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
					var operations = publicSaveJson['finalValue'];
					if(operations==null || operations=='')
					{
						Ext.getCmp('Operations').setValue(mainOperation);
					}
					else
					{
						Ext.getCmp('Operations').setValue(operations);
					}

					var definedOperationsArry = publicSaveJson['definedOperationsArry'];
					var monitoredOperationsArry = publicSaveJson['monitoredOperationsArry'];

					if (wsdlOperationToFieldStore.getCount() >= 1)
					{
						wsdlOperationToFieldStore.removeAll();
					}
					if (wsdlOperationFromFieldStore.getCount() >= 1)
					{
						wsdlOperationFromFieldStore.removeAll();
					}

					if (!Ext.isEmpty(definedOperationsArry) && definedOperationsArry != undefined)
					{
						wsdlOperationToFieldStore.add(definedOperationsArry);
					}
					if (!Ext.isEmpty(monitoredOperationsArry) && monitoredOperationsArry != undefined)
					{
						wsdlOperationFromFieldStore.add(monitoredOperationsArry);
					}

					Ext.getCmp('xmlTable').removeAll();
					Ext.getCmp('xmlTable').hide();
					Ext.getCmp('inputTable').removeAll();
					Ext.getCmp('htmlviewer').hide();

					Ext.getCmp('xmlandhtmlview').setDisabled(true);
					Ext.getCmp('saveAndConfigContainer').hide();
				}
				myMask.hide();
			}
		});
	},
	combine: function (mainkeys, keys, values) {
		var l = Math.min(mainkeys.length,keys.length,values.length), ret = [], i;
		for( i=0; i<l; i++) ret.push(mainkeys[i]+":"+keys[i]+":"+values[i]);
		return ret;
	},
	sendRequestWebConfig: function () {
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var selectedOperations = Ext.getCmp('wsdlOperation').fromField.getValue();
		if(Ext.isEmpty(selectedService) || selectedService == undefined)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertWebMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		//to get the input parameters-- start
		var viewOption =Ext.getCmp('xmlandhtmlview').getActiveTab().getItemId();
		var option = 'xmlview';
		if(viewOption == 'htmlview')
		{
			option = 'htmlview';
		}
		var keyValues='';
		var requestMsg='';

		if(option=='htmlview')
		{
			//to get the input parameters -- start
			var parameters = [];
			var text='';
			var mainkeys=[];

			$("td[class='hiddentd x-grid-cell']").each(function(){
				var txt = $(this).text();
				//if(txt!='' && txt.indexOf("@#@")>-1)
					//txt = txt.substring(txt.lastIndexOf("@")+1);
				mainkeys.push(txt);
			});

			$("td[class='parameterName x-grid-cell']").each(function(){
					text=$(this).text();
					if(text.indexOf("*")>-1)
					{
						text = text.substring(0,text.indexOf("*"));
					}
					parameters.push(text);
			});
			var inputs = [];
			//$("#inputTbl").find("#inputRow").each(function(index){
			$("#inputTbl").find("tr#inputRow").each(function(index){
				var inputValue = '';
				inputValue = $.trim($(this).find("td:eq(2)").find("input#inputValue").val());
				if(inputValue=='' || inputValue=='undefined')
				{
					inputValue = $.trim($(this).find("td:eq(2)").find("select#selectValue").val());
				}
				if(inputValue!="undefined")
				{
					inputs.push(inputValue);
				}
			});
			$(".linesquare").find("#subinputRow").each(function(){

				var inputValue = '';
				inputValue = $.trim($(this).find("td:eq(2)").find("input#inputValue").val());
				if(inputValue=='' || inputValue=='undefined')
				{
					inputValue = $.trim($(this).find("td:eq(2)").find("select#selectValue").val());
				}
				if(inputValue!="undefined")
				{
					inputs.push(inputValue);
				}
			});

			var your_obj = this.combine(mainkeys, parameters, inputs);//alert(your_obj);
			for(var y=0;y<your_obj.length;y++)
			{
				keyValues=keyValues+"~"+your_obj[y];
			}
			if(keyValues.indexOf('~') == 0)
			{
				keyValues = keyValues.substring(keyValues.indexOf(",")+1);
			}
		//end
		}
		else if(option=='xmlview')
		{
			requestMsg = $('#soapRequest').val();
		}

		var credentialWithPattern = publicWebServJSON['credentialWithPattern'];
		var wsdlMain = publicWebServJSON['wsdl'];
		var mainOperation = publicWebServJSON['finalValue'];
		var componentName = publicWebServJSON['componentName'];
		var selectedUrl = Ext.getCmp('wsdlUrl').getValue();
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var selectedOperation = Ext.getCmp('wsdlOperation').fromField.getValue();
		var configMode = Ext.getCmp('agentListObj').getValue();
		var from = 'sendRequest';
		var urlToDisplay='/final/admin/EgWebServiceResponse.jsp';
		if(option == 'htmlview')
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
				method: 'POST',
				params:'selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom="+encodeURI(from)+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
				timeout:1200000,
				success: function(response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var publicSendReqJson = Ext.decode(jsonText);
						var soapReqText = publicSendReqJson['SOAPReq'];

						var existSoapVal = $('#soapRequest').val();
						if(Ext.isEmpty(existSoapVal))
						{
							$('#soapRequest').val(soapReqText);
						}
						else
						{
							$('#soapRequest').val("");
							$('#soapRequest').val(soapReqText);
						}

						var href = 'SpecificTestConfiguration/data/EgWebServiceResponse.jsp';

						Ext.Ajax.request({
							url: href,
							timeout: 1200000,
							params: "selectedUrlValue="+encodeURI(window.parent.filterEncode(selectedUrl))+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI((soapReqText))+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+"&wsdl="+encodeURI(window.parent.filterEncode(wsdlMain))+ "&operation="+encodeURI(window.parent.filterEncode(mainOperation))+"&credentialWithPattern="+encodeURI(window.parent.filterEncode(credentialWithPattern)),
							method: 'POST',
							success: function(response)
							{
								if (response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									Ext.widget('window', {
										title: 'Web Service Response',
										//closeAction: 'destroy',
										width: '532px',
										height: '212px',
										id: 'file',
										padding:'5 10 10 10',
										name: 'file',
										resizable: 'false',
										scroll:true,
										autoScroll:true,
										items: [
											{
												xtype: 'component',
												html: jsonText
											}
										]
									}).show();
								}
							}
						});
						Ext.getCmp('wsdlUrl').setDisabled(false);
						Ext.getCmp('agentListObj').setDisabled(false);
					}
				}
			});
		}
		else if(option=='xmlview')
		{
			var queryStr = 'selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom=sendRequestXml"+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern)
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp?',
				params:queryStr,
				method: "POST",
				timeout:1200000,
				success: function(msg) {
					var inputTable = $(msg).find('#inputTable').html();
					$('#inputTable').html(inputTable);
				}
			});

			var href = 'selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+"&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&credentialWithPattern="+encodeURI(credentialWithPattern);
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgWebServiceResponse.jsp',
				method: 'POST',
				params: href,
				timeout:1200000,
				success: function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						Ext.widget('window', {
							title: 'Web Service Response',
							//closeAction: 'destroy',
							width: '532px',
							height: '212px',
							id: 'file',
							name: 'file',
							resizable: 'false',
							scroll:true,
							autoScroll:true,
							items: [
								{
									xtype: 'component',
									html: jsonText
								}
							]
						}).show();
					}
				}
			});
			Ext.getCmp('wsdlUrl').setDisabled(false);
			Ext.getCmp('agentListObj').setDisabled(false);
		}
	},
	webServiceConfig: function() {
		var wsdlURL = '';
		if (!Ext.isEmpty(Ext.getCmp('WSDL_URL')) && Ext.getCmp('WSDL_URL') != undefined)
		{
			wsdlURL = Ext.getCmp('WSDL_URL').getValue();
		}
		else if (!Ext.isEmpty(Ext.getCmp('wsdl_url')) && Ext.getCmp('wsdl_url') != undefined)
		{
			wsdlURL = Ext.getCmp('wsdl_url').getValue();
		}

		if (!Ext.isEmpty(wsdlURL) && wsdlURL.indexOf('$') != -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: invalidUrlMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else
		{
			Ext.create('SpecificTestConfiguration.view.EgWebServiceConfiguration').show();
			Ext.getCmp('saveAndConfigContainer').hide();
			Ext.getCmp('xmlTable').removeAll();
			Ext.getCmp('xmlTable').hide();
			Ext.getCmp('inputTable').removeAll();
			Ext.getCmp('htmlviewer').hide();
			Ext.getCmp('xmlandhtmlview').setDisabled(true);
			var cName = Ext.getCmp('componentName').getValue();
			var credentials = Ext.getCmp('credentials').getValue();
			var operations = Ext.getCmp('Operations').getValue();

			var credentialWithPattern='';
			var pattern='';
			var partsOfUrl = wsdlURL.split(',');
			var partsOfCreden = credentials.split(',');
			for(var i=0;i<partsOfUrl.length;i++)
			{
				var urlPart = partsOfUrl[i];
				var credenPart = partsOfCreden[i];
				var pattern = urlPart.substring(0,urlPart.indexOf(":"));
				var values = pattern+":"+credenPart;
				credentialWithPattern=credentialWithPattern+","+values;
			}
			if(credentialWithPattern.indexOf(",") == 0)
			{
				credentialWithPattern = credentialWithPattern.substring(credentialWithPattern.indexOf(",")+1);
			}
			var myWebConfMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Updating...'});
			myWebConfMask.show();

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp?',
				method: 'POST',
				params: 'wsdl='+encodeURIComponent(wsdlURL)+"&operation="+encodeURIComponent(operations)+"&credentialWithPattern="+encodeURIComponent(credentialWithPattern)+"&componentName="+encodeURIComponent(cName)+'&reqFrom=testConfig',
				timeout:1200000,
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						myWebConfMask.hide();

						var jsonText = response.responseText;
						publicWebServJSON = Ext.decode( jsonText );
						selectedMgr = publicWebServJSON['selectedMgr'];
						if (Ext.getCmp('agentListObj').getStore().getCount() > 1)
						{
							Ext.getCmp('agentListObj').getStore().removeAll();
						}
						Ext.getCmp('agentListObj').getStore().loadRawData(publicWebServJSON['choosemgrArry']);
						if (!Ext.isEmpty(selectedMgr) && selectedMgr != undefined)
						{
							Ext.getCmp('agentListObj').setValue(selectedMgr);
						}
						else
						{
							Ext.getCmp('agentListObj').setValue(publicWebServJSON['choosemgrArry'][0].valueField);
						}
						Ext.getCmp('wsdlUrl').getStore().loadRawData(publicWebServJSON['selectUrlArry']);
						Ext.getCmp('wsdlUrl').setValue(publicWebServJSON['selectUrlArry'][0].valueField);
					}
					else
					{
						myWebConfMask.hide();
					}
				}
			});
		}
	},
	selectService: function (value) {
		Ext.getCmp('saveAndConfigContainer').hide();
		//Ext.getCmp('soapRequest').hide();
		Ext.getCmp('xmlTable').removeAll();
		Ext.getCmp('xmlTable').hide();
		Ext.getCmp('inputTable').removeAll();
		Ext.getCmp('htmlviewer').hide();
		Ext.getCmp('xmlandhtmlview').setDisabled(true);
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var wsdlOperationObj = Ext.getCmp('wsdlOperation');
		var wsdlOperationFromFieldStore = wsdlOperationObj.fromField.store;
		var wsdlOperationToFieldStore = wsdlOperationObj.toField.store;
		if (wsdlOperationToFieldStore.getCount() >= 1)
		{
			wsdlOperationToFieldStore.removeAll();
		}
		if (wsdlOperationFromFieldStore.getCount() >= 1)
		{
			wsdlOperationFromFieldStore.removeAll();
		}
		if(Ext.isEmpty(selectedService) || selectedService == 'Select Service')
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertWebMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else
		{
			var configMode = Ext.getCmp('agentListObj').getValue();
			var wsdlUrl = Ext.getCmp('wsdlUrl').getValue();
			var componentName = Ext.getCmp('componentName').getValue();
			var wsdlMain = publicWebServJSON['wsdl']
			var credentialWithPattern = publicWebServJSON['credentialWithPattern']
			var mainOperation = Ext.getCmp('Operations').getValue();
			var reqFrom='selectService';

			var myMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg:"Loading..."});
			myMask.show();

			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
				method: 'POST',
				params:'wsdl='+encodeURI(wsdlMain)+"&operation="+encodeURI(mainOperation)+"&credentialWithPattern="+encodeURI(credentialWithPattern)+"&componentName="+encodeURI(componentName)+"&selectedUrlValue="+encodeURI(wsdlUrl)+"&configMode="+configMode+"&reqFrom="+reqFrom+"&selectedServiceValue="+encodeURI(selectedService),
				timeout:1200000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						myMask.hide();
						var jsonText = response.responseText;
						publicWebServJSON = Ext.decode( jsonText );
						var definedOperationsArry = publicWebServJSON['definedOperationsArry'];
						var monitoredOperationsArry = publicWebServJSON['monitoredOperationsArry'];

						if (!Ext.isEmpty(definedOperationsArry) && definedOperationsArry != undefined)
						{
							wsdlOperationToFieldStore.add(definedOperationsArry);
						}
						if (!Ext.isEmpty(monitoredOperationsArry) && monitoredOperationsArry != undefined)
						{
							wsdlOperationFromFieldStore.add(monitoredOperationsArry);
						}
						if(wsdlOperationToFieldStore.getCount() == 0 && wsdlOperationFromFieldStore.getCount() == 0)
						{
							Ext.Msg.show({
								title: pageName,
								msg: 'No Operation available',
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
				}
			});
		}
	},
	selectUrl: function() {
		Ext.getCmp('saveAndConfigContainer').hide();
		Ext.getCmp('xmlandhtmlview').setDisabled(true);
		Ext.getCmp('xmlTable').removeAll();
		Ext.getCmp('xmlTable').hide();
		Ext.getCmp('inputTable').removeAll();
		Ext.getCmp('htmlviewer').hide();

		var wsdlUrl = Ext.getCmp('wsdlUrl').getValue();
		var componentName = publicWebServJSON['componentName'];
		var wsdlMain = publicWebServJSON['wsdl'];
		var credentialWithPattern = publicWebServJSON['credentialWithPattern'];
		var mainOperation = Ext.getCmp('Operations').getValue();
		var reqFrom='selectUrl';

		var confMode = Ext.getCmp('agentListObj').getValue();
		var configMode = '';
		if (confMode.indexOf('eG Manager') != -1)
		{
			configMode = 'EgManager';
		}
		else
		{
			configMode = confMode;
		}

		var myWebConfMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Updating...'});
		myWebConfMask.show();
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
			method: 'POST',
			params:'wsdl='+encodeURI(wsdlMain)+"&operation="+encodeURI(mainOperation)+"&credentialWithPattern="+encodeURI(credentialWithPattern)+"&componentName="+encodeURI(componentName)+"&selectedUrlValue="+encodeURI(wsdlUrl)+"&configMode="+configMode+"&reqFrom="+reqFrom,
			timeout:1200000,
			//async: false,
			scope: this,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					myWebConfMask.hide();
					var jsonText = response.responseText;
					publicWebServJSON = Ext.decode( jsonText );
					var selectServiceArry = publicWebServJSON['selectServiceArry'];
					var selectedService = publicWebServJSON['selectedService'];
					var definedOperationsArry = publicWebServJSON['definedOperationsArry'];
					var monitoredOperationsArry = publicWebServJSON['monitoredOperationsArry'];
					if (!Ext.isEmpty(selectServiceArry) && selectServiceArry != undefined)
					{
						Ext.getCmp('wsdlService').getStore().loadRawData(selectServiceArry);//put weather has been selected [1]
					}

					if (!Ext.isEmpty(selectedService))
					{
						Ext.getCmp('wsdlService').setValue(selectedService);
					}
					else
					{
						Ext.getCmp('wsdlService').setValue(selectServiceArry[0].valueField);
					}

					var serviceCount = Ext.getCmp('wsdlService').getStore().getCount();
					if(serviceCount == 1)
					{
						if(Ext.isEmpty(wsdlUrl) || wsdlUrl == undefined)
						{
							Ext.Msg.show({
								title: pageName,
								msg: selectAUrl,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg: noServiceAvail,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}

					var wsdlOperationObj = Ext.getCmp('wsdlOperation');
					var wsdlOperationFromFieldStore = wsdlOperationObj.fromField.store;
					var wsdlOperationToFieldStore = wsdlOperationObj.toField.store;
					if (wsdlOperationToFieldStore.getCount() >= 1)
					{
						wsdlOperationToFieldStore.removeAll();
					}
					if (wsdlOperationFromFieldStore.getCount() >= 1)
					{
						wsdlOperationFromFieldStore.removeAll();
					}

					if(serviceCount == 2)
					{
						if (!Ext.isEmpty(definedOperationsArry) && definedOperationsArry != undefined)
						{
							wsdlOperationToFieldStore.add(definedOperationsArry);
						}
						if (!Ext.isEmpty(monitoredOperationsArry) && monitoredOperationsArry != undefined)
						{
							wsdlOperationFromFieldStore.add(monitoredOperationsArry);
						}
						if(wsdlOperationToFieldStore.getCount() == 0 && wsdlOperationFromFieldStore.getCount() == 0)
						{
							Ext.Msg.show({
								title: pageName,
								msg: noOprAvail,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					}
				}
			}
		});
	},
	configureoperations: function() {
		var monitoredOpr = Ext.getCmp('wsdlOperation').fromField.getValue();
		var isUnconfigTestSelected = false;
		var selectedOperationArr = new Array();
		var unconfigTestsPicked = 0;
		if (!Ext.isEmpty(monitoredOpr) && monitoredOpr.length > 0)
		{
			for (var i = 0; i < monitoredOpr.length; i++ )
			{
				var selectedOperations = monitoredOpr[i];
				if(!Ext.isEmpty(selectedOperations) && selectedOperations != null && selectedOperations != 'undefined')
				{
					isUnconfigTestSelected = true;
					unconfigTestsPicked++;
				}
			}
		}
		if (!isUnconfigTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertWebMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		if (unconfigTestsPicked != 1)
		{
			isUnconfigTestSelected = false;
			Ext.Msg.show({
				title: pageName,
				msg: alertWebMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		if (isUnconfigTestSelected)
		{
			var selectedUrlVal = Ext.getCmp('wsdlUrl').getValue();
			var selectedService = Ext.getCmp('wsdlService').getValue();
			var selectedOpr = Ext.getCmp('wsdlOperation').fromField.getValue();
			var cNme = Ext.getCmp('componentName').getValue();

			var confMode = Ext.getCmp('agentListObj').getValue();
			var configMode = '';
			if (confMode.indexOf('eG Manager') != -1)
			{
				configMode = 'EgManager';
			}
			else
			{
				configMode = confMode;
			}

			var fromFieldLen = Ext.getCmp('wsdlOperation').fromField.store.getCount();
			var fromFieldList = Ext.getCmp('wsdlOperation').fromField.store;

			for (var i = 0 ; i < fromFieldLen ; i++)
			{
				var fromFieldData = fromFieldList.getAt(i).get('valueField');
				selectedOperationArr[i]  = fromFieldData;
			}
			var mainOperation = publicWebServJSON['mainOperation'];
			if (!Ext.isEmpty(selectedOperationArr) && selectedOperationArr.length > 0)
			{
				mainOperation = '';
				var name = '';
				if (!Ext.isEmpty(selectedUrlVal) && selectedUrlVal != undefined)
				{
					name = selectedUrlVal.substring(0,selectedUrlVal.indexOf(':'));
				}
				if (!Ext.isEmpty(selectedService) && selectedService != undefined)
				{
					name += ':'+selectedService;
				}
				for (var i=0; i < selectedOperationArr.length ; i++ )
				{
					mainOperation +=name+'_'+selectedOperationArr[i]+',';
				}
				if (!Ext.isEmpty(mainOperation) && mainOperation != undefined )
				{
					mainOperation = mainOperation.substring(0,mainOperation.length - 1);
				}
			}
			var groupLabel = '';// publicWebServJSON['groupLabel'];
			if (Ext.isEmpty(groupLabel) || groupLabel == undefined)
			{
				var findIndex = fromFieldList.find( 'valueField', selectedOpr, 0, false, true, true ) ;
				groupLabel = fromFieldList.getAt(findIndex).get('groupField');
			}

			var credentials = publicWebServJSON['credentialWithPattern'];
			var reqFrom = 'configure';
			var myWebConfMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Updating...'});
			myWebConfMask.show();
			$.ajax({
				type: "POST",
				url: 'SpecificTestConfiguration/data/EgWebServiceConfig.jsp?com.eg.CSRF_NONCE='+csrfToken,
				timeout:1200000,
				data: 'selectedUrlValue='+encodeURI(selectedUrlVal)+'&selectedServiceValue='+encodeURI(selectedService)+'&componentName='+encodeURI(cNme)+'&wsdl='+encodeURI(selectedUrlVal)+'&operation='+encodeURI(mainOperation)+'&configMode='+configMode+'&reqFrom='+reqFrom+'&selectedOperationValue='+encodeURI(selectedOpr)+'&credentialWithPattern='+encodeURI(credentials)+'&groupLabel='+encodeURI(groupLabel),
				success: function(msg)
				{
					var alertMsg = $.trim($(msg).find('#alertResultDiv').text());
					if(configMode!='EgManager')
					{
						if(alertMsg=='Failed to get required configuration information from agent' || alertMsg=='Agent not installed or not running')
						{
							Ext.Msg.show({
								title: pageName,
								msg: alertMsg,
								buttons: Ext.Msg.Ok,
								info: 'iconExclamation'
							});
							return;
						}
					}
					myWebConfMask.hide();
					var soapRequestHtml = $(msg).find('#requestMsg').html();
					var soapReqText = $(msg).find('#requestMsg').text();
					Ext.getCmp('saveAndConfigContainer').show();
					Ext.getCmp('xmlandhtmlview').setDisabled(false);

					Ext.getCmp('xmlTable').update(soapRequestHtml);
					var inputTable = $(msg).find('#inputTable').html();
					var inputTable1 = $(msg).find('#inputTable').text();
					Ext.getCmp('inputTable').update(inputTable);

					var optionview = Ext.getCmp('xmlandhtmlview').getActiveTab().getItemId();
					if (optionview == 'xmlview')
					{
						Ext.getCmp('htmlviewer').hide();
						Ext.getCmp('xmlTable').show();
					}
					else
					{
						Ext.getCmp('xmlTable').hide();
						Ext.getCmp('htmlviewer').show();
					}
					Ext.getCmp("save").setDisabled(false);
					testInterViews.disableSendReq();
				}
			});
		}
	},
	disableSendReq: function () {
		var selectedType = Ext.getCmp('agentListObj').getValue();
		if(selectedType == 'EgManager')
			Ext.getCmp('sendReq').setDisabled(false);
		else
			Ext.getCmp('sendReq').setDisabled(true);
	},
	radXmlHtml: function() {
		var optionview = Ext.getCmp('xmlandhtmlview').getActiveTab().getItemId();
		if (optionview == 'xmlview')
		{
			Ext.getCmp('htmlviewer').hide();
			Ext.getCmp('xmlTable').show();
		}
		else
		{
			Ext.getCmp('htmlviewer').show();
			Ext.getCmp('xmlTable').hide();
		}
	},

	getPopUpView : function(ResourceId)
	{
		if (Ext.getCmp('egconfigureresource') != undefined)
		{
			Ext.getCmp('egconfigureresource').removeAll();
			Ext.getCmp('backupmultirescontainer').removeAll();
			Ext.getCmp('backupmultirescontainer').doLayout();
		}
		var resValue = Ext.getCmp(ResourceId).getValue();
		inputResource = 1;
		popUpWin = Ext.create('Ext.Window', {
			layout: 'fit',
			border: false,
			title: multiResourceTitle,
			id: 'egconfigureresource',
			width: 700,
			height: 335,
			padding:'5 10 10 10',
			autoScroll: true,
			modal: true,

			layout: {
				type: 'auto',
				pack: 'start',
				align: 'stretch'
			},
			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 0 0 0',
					items: [
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							id: 'addMultiresbtn',
							width: 80,
							text: 'Add More',
							listeners : 
							{
								'click' : function()
								{
									addMultiResourceContact();
								}
							}
						},
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							text: 'Update',
							width: 80,
							id: 'updateMultires',
							name: 'updateMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									testInterViews.updateMultiResourceContact(ResourceId);
								}
							}
						},
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							text: 'Clear',
							width: 80,
							id: 'clearMultires',
							name: 'clearMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									testInterViews.clearMultiResourceContact();
								}
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'container',
					id: 'backupmultirescontainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					}
				},
				{
					xtype: 'container',
					id: 'NoMultiResPattern',
					hidden: true,
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'center'
					},
					border:true,
					flex:1,
					columnWidth:1,
					style:{
						'height':'100%',
					},
					items: [
						{
							xtype: 'label',
							html: '<table border="0px" height="300"><tr><td align="center"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+NoPublishedResource+'</div></td></tr></table></td></tr></table>'
						}
					]
				}
			]
		});
		popUpWin.show();
		var multidom = '';
		var splitresValue = resValue.split(",");
		if (resValue != null || resValue != undefined)
		{
			var val = splitresValue.length-1;
			for (var k =0;k<=splitresValue.length-1;k++ )
			{
				addMultiResourceContact();
			}
			for (multidom=1;multidom<splitresValue.length+1;multidom++)
			{
				if (splitresValue[multidom-1].indexOf("\\") != -1)
				{
					var folderName = splitresValue[multidom-1].split("\\");
					Ext.getCmp('folderName'+multidom).setValue(splitresValue[multidom-1].split('\\')[0]);
					if (splitresValue[multidom-1].split('\\')[1].indexOf(":") != -1)
					{
						var temp = splitresValue[multidom-1].split('\\')[1];
						Ext.getCmp('resourceName'+multidom).setValue(temp.split(':')[0]);
						Ext.getCmp('winTitle'+multidom).setValue(temp.split(':')[1]);
					}
					else
					{
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1].split('\\')[1]);
						Ext.getCmp('winTitle'+multidom).setValue('none');
					}
				}
				else
				{
					if (splitresValue[multidom-1].indexOf(":") != -1)
					{
						Ext.getCmp('folderName'+multidom).setValue('none');
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1].split(':')[0]);
						Ext.getCmp('winTitle'+multidom).setValue(splitresValue[multidom-1].split(':')[1]);
					}
					else
					{
						Ext.getCmp('folderName'+multidom).setValue('none');
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1]);
						Ext.getCmp('winTitle'+multidom).setValue('none');
					}
				}
				
			}
		}
	},

	clearMultiResourceContact : function()
	{
		var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
		backupmulticontainer.removeAll();
		inputResource = 1;
		addMultiResourceContact();
	},

	updateMultiResourceContact : function(resourceId)
	{
		var multiinputs = inputResource;
		var publishResource = "";
		for (var mul=1;mul<=multiinputs-1;mul++)
		{
			if (Ext.getCmp('folderName'+mul) == undefined)
			{
				continue;
			}
			var folderName = Ext.getCmp('folderName'+mul).getValue();
			var resourceName = Ext.getCmp('resourceName'+mul).getValue();
			var winTitle = Ext.getCmp('winTitle'+mul).getValue();
			if (!checkblank(folderName))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: enterFolderName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (folderName.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(folderName,"`*=#.|;:\"\'<>,\/[]{}()?\\"))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(folderName) == "")
			{
				Ext.getCmp('folderName'+mul).focus();
				return;
			}
			//else if(!checkHyphenText(folderName,folderName))
			//{
				//Ext.getCmp('folderName'+mul).focus();
				//return;
			//}
			else if (folderName.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (folderName.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(resourceName))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: enterResourceName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("none") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: validResourceName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(resourceName,"`*=#.|;:\"\'<>,\/[]?\\"))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(resourceName) == "")
			{
				Ext.getCmp('resourceName'+mul).focus();
				return;
			}
			//else if(!checkHyphenText(resourceName,resourceName))
			//{
				//Ext.getCmp('resourceName'+mul).focus();
				//return;
			//}
			else if (resourceName.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(winTitle))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: enterwinTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (winTitle.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(winTitle,"`*=#.|;:\"\'<>,\/[]{}()?\\"))
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(winTitle) == "")
			{
				Ext.getCmp('winTitle'+mul).focus();
				return;
			}
			//else if(!checkHyphenText(winTitle,winTitle))
			//{
				//Ext.getCmp('winTitle'+mul).focus();
				//return;
			//}
			else if (winTitle.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (winTitle.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: multiResourceTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			if (folderName != 'none' && winTitle != 'none')
			{
				publishResource += folderName+"\\"+resourceName+":"+winTitle; 
			}
			else if (folderName == 'none' && winTitle != 'none')
			{
				publishResource += resourceName+":"+winTitle;
			}
			else if (folderName != 'none' && winTitle == 'none')
			{
				publishResource += folderName+"\\"+resourceName;
			}
			else if (folderName == 'none' && winTitle == 'none')
			{
				publishResource += resourceName;
			}
			publishResource += ",";
		}
		publishResource = publishResource.substring(0,publishResource.lastIndexOf(","));
		Ext.getCmp(resourceId).setValue(publishResource);
		Ext.getCmp('egconfigureresource').close();
	},
	getPopupSitename: function()
	{
		var selected_sitename = Ext.getCmp('sitename_popup').getValue();
		if(selected_sitename =='-1')
		{
			Ext.Msg.show({
				title: 'Site Information',
				msg: 'Please select a site name',
				buttons: Ext.Msg.OK,
				icon: 'iconInformation'
			});
		}
		else
		{
			Ext.getCmp('website_name').setValue(selected_sitename);
			Ext.getCmp('sitedetailedconfiguration').destroy();
		}
	},
	unCheckHeaderCheckBox: function(grid){
		var recordCount = grid.getStore().getCount(); 
		var selectionCount = grid.getSelectionModel().getCount();
		if(recordCount != 0 && recordCount == selectionCount)
		{
			grid.getSelectionModel().toggleUiHeader(false);
		}
	}
});

function checkDescSpecial(field,s_spl)
{
	obj_val = field;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			Ext.Msg.show({
				title: descTitle,
				msg: _desccheckspecial,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
	}
	return true;
}
function addContact() {
	if (inputsVmg == totalInputs)
	{
		Ext.Msg.show({
			title: alertTitle,
			msg: limitedLevel,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var mainForm = Ext.getCmp('vmgusers');
	var backupcontainer = Ext.getCmp('backupcontainer');
	var conId = "con_"+inputs

	var tmpContainer = {
		xtype : 'fieldset',
		id : conId,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeContact(conId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:120
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Domain,
						style:{'white-space':'nowrap'},
						id:'domainvmg'+inputs,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: AdminUser,
						style:{'white-space':'nowrap'},
						id:'admusrvmg'+inputs,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: AdminPwd,
						style:{'white-space':'nowrap'},
						id:'admpwdvmg'+inputs,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: AdminConfPwd,
						style:{'white-space':'nowrap'},
						id:'confpwdvmg'+inputs,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					}
				]
			}
		]
	}
	backupcontainer.add(tmpContainer);
	mainForm.doLayout();
	inputs++;
	inputsVmg++;
	Ext.getCmp('addVmgUsrbtn').setText('Add More');
	Ext.getCmp('updateConfUsr').enable();
	Ext.getCmp('clearConfUsr').enable();
	Ext.getCmp('NoVmgPattern').hide();
}
function removeContact(containerID) {
	var backupcontainer = Ext.getCmp('backupcontainer');
	backupcontainer.remove(containerID);

	inputsVmg--;
	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addVmgUsrbtn').setText('Add');
		Ext.getCmp('NoVmgPattern').show();
		Ext.getCmp('updateConfUsr').disable();
		Ext.getCmp('clearConfUsr').disable();

	}
}

function addMultiSourceContact() 
{
	var mainForm = Ext.getCmp('egconfigurepublishedresources');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmultisrc
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeMultiSrc(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						defaults: {
							labelSeparator:' ',
							labelWidth: 150
						},
						columnWidth: 1,
						items: [
							{
								xtype: 'textfield',
								cls: 'textbox',
								fieldLabel: 'Published resources',
								style:{'white-space':'nowrap'},
								id:'publisresource'+inputsmultisrc,
								value: '$unconfigured',
								columnWidth: 0.97,
								readOnly : true
							},
							{
								xtype: 'button',
								columnWidth: 0.03,
								tooltip: pubResourceToolTip,
								id:'button'+inputsmultisrc,
								iconCls : 'iconConfigure',
								style : {
									background : 'none',
									border : '0px'
								},
								margin: '0 0 0 2',
								listeners: {
									click: function() {
										var resId = this.getId().replace("button","publisresource");
										testInterViews.getPopUpView(resId);
									}
								}
							}
						]
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Domain,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: User,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						id: 'twofaCont'+inputsmultisrc,
						fieldLabel: 'Is 2FA enabled?',
						columnWidth: 0.5,
						layout: 'column',
						items : [
							{
								xtype: 'radiogroup',
								columnWidth: 0.6,
								cls: 'radiobt',
								id: 'twofact'+inputsmultisrc,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_1',  inputValue: 'true'},
									{ boxLabel: 'No', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
								],
								listeners : {
									'change' : function(obj, value)
									{
										var value = this.getChecked()[0];
										var twofa = this.getId().replace("twofact","twofacttoken");
										if (value.getGroupValue() == 'false')
										{
											Ext.getCmp(twofa).setVisible(false);
										}
										else
										{
											Ext.getCmp(twofa).setVisible(true);
										}
									}
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'twofacttoken'+inputsmultisrc,
								inputType: 'password',
								emptyText: '2FA code',
								columnWidth: 0.4,
								margin: '0 0 0 5',
								hidden: true,
								backupValue: '',
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function() {
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							}
						]
					},
					{
						xtype: 'radiogroup',
						columnWidth: 0.5,
						cls: 'radiobt',
						id: 'disclaimer_radioGrp'+inputsmultisrc,
						fieldLabel: 'Is disclaimer enabled?',
						vertical: false,
						columns: 2,
						items: [
							{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_1',  inputValue: 'true'},
							{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
						]
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	Ext.getCmp('publisresource'+inputsmultisrc).focus(true);

	Ext.getCmp('addMultiSrcbtn').setText('Add More');
	Ext.getCmp('updateMultiConfSrc').enable();
	Ext.getCmp('clearMultiConfSrc').enable();
	Ext.getCmp('NoMultiUsrPattern').hide();

	inputsmultisrc++;
}

function removeMultiSrc(containerID) 
{
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismultisrc = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addMultiSrcbtn').setText('Add');
		if (ismultisrc == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('updateMultiConfSrc').disable();
			Ext.getCmp('clearMultiConfSrc').disable();
		}
	}
}
function addMultiUsrContact() {
	if (inputs == totalInputs)
	{
		Ext.Msg.show({
			title: alertTitle,
			msg: limitedLevel,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var mainForm = Ext.getCmp('egconfiguremultipleusers');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmulti
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeMultiContact(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:120
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Domain,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: User,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmulti,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmulti,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	inputsmulti++;
	Ext.getCmp('addMultiUsrbtn').setText('Add More');
	Ext.getCmp('updateMultiConfUsr').enable();
	Ext.getCmp('clearMultiConfUsr').enable();
	Ext.getCmp('NoMultiUsrPattern').hide();
}
function removeMultiContact(containerID) {
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismulti = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addMultiUsrbtn').setText('Add');
		if (ismulti == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('updateMultiConfUsr').disable();
			Ext.getCmp('clearMultiConfUsr').disable();
		}
	}
}
function addCredUrlContact() 
{ //credentials url
	var maincredentialForm = Ext.getCmp('egconfigureurlandcredentials');
	var credurlcontainer = Ext.getCmp('credurlcontainer');
	var hideVar = true;
	var sysPropHideVar = true;
	var getPrivateKeyParamExist = publicJson['isPrivateKeyParamExist'];
	var getSystemPropKeyParamExist = publicJson['isSystemPropKeyParamExist'];
	if (getPrivateKeyParamExist == true)
	{
		hideVar = false;
	}
	if (getSystemPropKeyParamExist == true)
	{
		sysPropHideVar = false;
	}
	var conCredUrlId = "con_"+inputsCredUrl
	var tempcredcontainer = {
		xtype : 'fieldset',
		id : conCredUrlId,
		width: 800,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'stretch'
		},
		style: {
			background : 'none',
			border : '1px solid lightGrey'
		},
		margin: '5 5 5 5',
		items: [
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'end'
				},
				margin:'0 10 0 0',
				items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeCredUrlContact(conCredUrlId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator: ' ',
					labelAlign: 'top'
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Name,
						id: 'nameCred'+inputsCredUrl,
						name: 'nameCred'+inputsCredUrl,
						value: '$unconfigured',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlLbl,
						id: 'urlCred'+inputsCredUrl,
						name: 'urlCred'+inputsCredUrl,
						value: '$unconfigured',
						columnWidth: 0.75
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlUnmeLbl,
						id: 'usrnameCred'+inputsCredUrl,
						name: 'usrnameCred'+inputsCredUrl,
						value: 'none',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlPwdLbl,
						id: 'pwdCred'+inputsCredUrl,
						name: 'pwdCred'+inputsCredUrl,
						inputType: 'password',
						//value: 'none',
						columnWidth: 0.25,
						backupValue: 'none',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						columnWidth: 0.30,
						fieldLabel: urlContentLbl,
						items: [
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id : 'contentCred'+inputsCredUrl,
								name: 'contentCred'+inputsCredUrl,
								displayField: 'displayField',
								columnWidth: 0.4,
								valueField: 'valueField',
								queryMode: 'local',
								value: 'none',
								editable: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: [{'displayField':'None','valueField':'none'},
										{'displayField':'Include','valueField':'Inc'},{'displayField':'Exclude','valueField':'Exc'}
										]
									}
								)
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								id: 'subcontentCred'+inputsCredUrl,
								name: 'subcontentCred'+inputsCredUrl,
								columnWidth: 0.6,
								margin: '0 0 0 5',
								value: 'none'
							}
						]
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlEncodeLbl,
						id: 'encodeCred'+inputsCredUrl,
						name: 'encodeCred'+inputsCredUrl,
						value: 'none',
						columnWidth: 0.20
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlPrivateLbl,
						id: 'privateKey'+inputsCredUrl,
						name: 'privateKey'+inputsCredUrl,
						value: 'none',
						columnWidth: 0.75,
						hidden: hideVar
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlPwdLbl,
						id: 'passKey'+inputsCredUrl,
						name: 'passKey'+inputsCredUrl,
						//value: 'none',
						inputType: 'password',
						columnWidth: 0.25,
						hidden: hideVar,
						backupValue: 'none',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					//{
						//xtype: 'textfield',
						//cls: 'textbox',
						//fieldLabel: urlSystemKeyLbl,
						//id: 'systempropertykey'+inputsCredUrl,
						//name: 'systempropertykey'+inputsCredUrl,
						//value: 'none',
						//columnWidth: 0.5,
						//hidden: sysPropHideVar
					//},
					//{
						//xtype: 'textfield',
						//cls: 'textbox',
						//fieldLabel: urlSystemValLbl,
						//id: 'systempropertyvalue'+inputsCredUrl,
						//name: 'systempropertyvalue'+inputsCredUrl,
						//value: 'none',
						//columnWidth: 0.5,
						//hidden: sysPropHideVar
					//}
					{
						xtype: 'fieldset',
						id:'syspropsfieldset'+inputsCredUrl,
						name:'syspropsfieldset'+inputsCredUrl,
						columnWidth: 1,
						hidden: sysPropHideVar,
						title: urlSystemPropsTitleLbl,
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						margin: '10 10 0 10',
						items: [
							{
								xtype: 'container',
								id : 'sysPropsMainContainer'+inputsCredUrl,
								layout: 'column',
								columnWidth: 1,
								defaults: {
									labelSeparator: '',
									margin: '0 5 5 5'
								},
								items: [
									{
										xtype : 'container',
										id: 'sysPropsContainer_'+inputsCredUrl+'_1',
										name: 'sysPropsContainer_'+inputsCredUrl+'_1',
										layout: 'column',
										columnWidth: 1,
										items : [
											{
												xtype: 'textfield',
												cls: 'textbox',
												fieldLabel: urlSystemKeyLbl,
												id: 'syspropkey_'+inputsCredUrl+'_1',
												name: 'syspropkey_'+inputsCredUrl+'_1',
												value: 'jsse.enableSNIExtension',
												margin: 5,
												columnWidth: 0.48,
												labelSeparator: ' ',
												labelAlign: 'top'
											},
											{
												xtype: 'textfield',
												cls: 'textbox',
												fieldLabel: urlSystemValLbl,
												id: 'syspropval_'+inputsCredUrl+'_1',
												name: 'syspropval_'+inputsCredUrl+'_1',
												value: 'false',
												columnWidth: 0.48,
												margin: 5,
												labelSeparator: ' ',
												labelAlign: 'top'
											},
											{
												xtype: 'component',
												html: '<center><div class="iconPlus" style="cursor:pointer;" data-qtip="<b>Add System Property</b>" onclick="javascript:addSysPropsContainer(sysPropsContainer_'+inputsCredUrl+'_1)"></center>',
												columnWidth: 0.04,
												margin: '25 0 0 2'
											}
										]
									}
								]
							}
						]
					}
				]
			}
		]
	}
	credurlcontainer.add(tempcredcontainer);
	Ext.getCmp('nameCred'+inputsCredUrl).focus();
	maincredentialForm.doLayout();
	inputsCredUrl++;
	Ext.getCmp('addCredUrlbtn').setText('Add More');
	Ext.getCmp('updateCredUrl').enable();
	Ext.getCmp('clearCredUrl').enable();
	Ext.getCmp('NoCredUrlPattern').hide();
}
function removeCredUrlContact(credID) {
	var credrl = Ext.getCmp('credurlcontainer');
	var credurlcontainer = Ext.getCmp('credurlcontainer');
	credurlcontainer.remove(credID);

	if (credID == 'concred_1')
	{
		iscred = 'true';
		Ext.getCmp('concred_1').removeAll();
		Ext.getCmp('concred_1').hide();
	}

	var bckitemscredLen = credurlcontainer.items.length;
	if (bckitemscredLen == 0)
	{
		Ext.getCmp('addCredUrlbtn').setText('Add');
		if (iscred == 'true')
		{
			Ext.getCmp('NoCredUrlPattern').show();
			Ext.getCmp('updateCredUrl').disable();
			Ext.getCmp('clearCredUrl').disable();
		}
	}
}
function addUrlNameContact() {
	var mainurlNmeForm = Ext.getCmp('egconfigurenamepattern');
	var urlpatterncontainer = Ext.getCmp('urlpatterncontainer');
	var conUrlId = "con_"+inputsUrlNme
	var tempurlcontainer = {
		xtype : 'fieldset',
		id : conUrlId,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeUrlNameContact(conUrlId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelAlign: 'top'
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Name,
						id: 'nameurl'+inputsUrlNme,
						name: 'nameurl'+inputsUrlNme,
						value: '$unconfigured',
						columnWidth: 0.40
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Pattern,
						id: 'patternurl'+inputsUrlNme,
						name: 'patternurl'+inputsUrlNme,
						value: '$unconfigured',
						columnWidth: 0.40
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Threshold_Value,
						id: 'thresholdurl'+inputsUrlNme,
						name: 'thresholdurl'+inputsUrlNme,
						value: '$unconfigured',
						columnWidth: 0.20
					}
				]
			}
		]
	}
	urlpatterncontainer.add(tempurlcontainer);
	Ext.getCmp('nameurl'+inputsUrlNme).focus();
	mainurlNmeForm.doLayout();
	inputsUrlNme++;
	Ext.getCmp('addUrlNamebtn').setText('Add More');
	Ext.getCmp('updateUrlPattern').enable();
	Ext.getCmp('clearUrlPattern').enable();
	Ext.getCmp('NoUrlPattern').hide();
}
function removeUrlNameContact(namecontainerID) {
	var urlpatterncontainer = Ext.getCmp('urlpatterncontainer');
	urlpatterncontainer.remove(namecontainerID);
	if (namecontainerID == 'con_1')
	{
		isNamePtn = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsLen = urlpatterncontainer.items.length;
	if (bckitemsLen ==0)
	{
		Ext.getCmp('addUrlNamebtn').setText('Add');
		if (isNamePtn == 'true')
		{
			Ext.getCmp('NoUrlPattern').show();
			Ext.getCmp('updateUrlPattern').disable();
			Ext.getCmp('clearUrlPattern').disable();
		}
	}
}
function addWinSharedContact() {
	var mainWinSharedForm = Ext.getCmp('egconfigurewinsharedfolders');
	var winsharedcontainer = Ext.getCmp('winsharedcontainer');
	var conWinId = "con_"+inputWinShared
	var tempWincontainer = {
		xtype : 'fieldset',
		id : conWinId,
		width: 800,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'stretch'
		},
		margin: '5 5 5 5',
		items: [
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'end'
				},
				margin:'0 10 0 0',
				items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeWinSharedContact(conWinId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator: ' ',
					labelAlign: 'top'
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: dispWinLbl,
						id: 'displayNme'+inputWinShared,
						name: 'displayNme'+inputWinShared,
						value: '$unconfigured',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: shrWinLbl,
						id: 'shareNme'+inputWinShared,
						name: 'shareNme'+inputWinShared,
						value: '$unconfigured',
						columnWidth: 0.75
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: dmnWinLbl,
						id: 'domainNme'+inputWinShared,
						name: 'domainNme'+inputWinShared,
						value: '$unconfigured',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: unmeWinLbl,
						id: 'userNme'+inputWinShared,
						name: 'userNme'+inputWinShared,
						value: '$unconfigured',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						id: 'pwdNme'+inputWinShared,
						name: 'pwdNme'+inputWinShared,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.25,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						id: 'confPwdNme'+inputWinShared,
						name: 'confPwdNme'+inputWinShared,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.25,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					}
				]
			}
		]
	}
	winsharedcontainer.add(tempWincontainer);
	Ext.getCmp('displayNme'+inputWinShared).focus();
	mainWinSharedForm.doLayout();
	inputWinShared++;
	Ext.getCmp('addwinsharedbtn').setText('Add More');
	Ext.getCmp('updateWinShared').enable();
	Ext.getCmp('clearWinShared').enable();
	Ext.getCmp('NoWinSharedPattern').hide();
}
function removeWinSharedContact(wincontainerID) {
	var winsharedcontainer = Ext.getCmp('winsharedcontainer');
	winsharedcontainer.remove(wincontainerID);

	if (wincontainerID == 'con_win1')
	{
		noWinConfig = 'true';
		Ext.getCmp('con_win1').removeAll();
		Ext.getCmp('con_win1').hide();
	}

	var bckitemswinLen = winsharedcontainer.items.length;
	if (bckitemswinLen == 0)
	{
		Ext.getCmp('addwinsharedbtn').setText('Add');
		if (noWinConfig == 'true')
		{
			Ext.getCmp('NoWinSharedPattern').show();
			Ext.getCmp('updateWinShared').disable();
			Ext.getCmp('clearWinShared').disable();
		}
	}
}
function addWsdlUrlContact() {
	var mainWsdlForm = Ext.getCmp('egconfigurewsdlurlandcredentials');
	var wsdlurlcontainer = Ext.getCmp('wsdlurlcontainer');
	var conWsdlUrlId = "con_"+inputsWsdlUrl
	var tempwsdlcontainer = {
		xtype : 'fieldset',
		id : conWsdlUrlId,
		width: 800,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'stretch'
		},
		margin: '5 5 5 5',
		items: [
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'end'
				},
				margin:'0 10 0 0',
				items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeWsdlUrlContact(conWsdlUrlId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator: ' ',
					labelAlign: 'top'
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Name,
						id: 'nameWsdl'+inputsWsdlUrl,
						name: 'nameWsdl'+inputsWsdlUrl,
						value: '$unconfigured',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlLbl,
						id: 'urlWsdl'+inputsWsdlUrl,
						name: 'urlWsdl'+inputsWsdlUrl,
						value: '$unconfigured',
						columnWidth: 0.75
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlUnmeLbl,
						id: 'usrnameWsdl'+inputsWsdlUrl,
						name: 'usrnameWsdl'+inputsWsdlUrl,
						value: 'none',
						columnWidth: 0.25
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlPwdLbl,
						id: 'pwdWsdl'+inputsWsdlUrl,
						name: 'pwdWsdl'+inputsWsdlUrl,
						inputType: 'password',
						//value: 'none',
						columnWidth: 0.25,
						backupValue: 'none',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						columnWidth: 0.30,
						fieldLabel: urlContentLbl,
						items: [
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id : 'contentWsdl'+inputsWsdlUrl,
								name: 'contentWsdl'+inputsWsdlUrl,
								displayField: 'displayField',
								columnWidth: 0.4,
								valueField: 'valueField',
								queryMode: 'local',
								value: 'none',
								editable: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: [{'displayField':'None','valueField':'none'},
										{'displayField':'Include','valueField':'Inc'},{'displayField':'Exclude','valueField':'Exc'}
										]
									}
								)
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								id: 'subcontentWsdl'+inputsWsdlUrl,
								name: 'subcontentWsdl'+inputsWsdlUrl,
								columnWidth: 0.6,
								margin: '0 0 0 5',
								value: 'none'
							}
						]
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: urlEncodeLbl,
						id: 'encodeWsdl'+inputsWsdlUrl,
						name: 'encodeWsdl'+inputsWsdlUrl,
						value: 'none',
						columnWidth: 0.20
					}
				]
			}
		]
	}
	wsdlurlcontainer.add(tempwsdlcontainer);
	Ext.getCmp('nameWsdl'+inputsWsdlUrl).focus();
	mainWsdlForm.doLayout();
	inputsWsdlUrl++;
	Ext.getCmp('NoWsdlUrlPattern').hide();
	Ext.getCmp('addWsdlUrlbtn').setText('Add More');
	Ext.getCmp('updateWsdlUrl').enable();
	Ext.getCmp('clearWsdlUrl').enable();
}
function removeWsdlUrlContact(wsdlcontainerID) {
	var wsdlcontainer = Ext.getCmp('wsdlurlcontainer');
	wsdlcontainer.remove(wsdlcontainerID);

	if (wsdlcontainerID == 'con_wsdl1')
	{
		noWsdl = 'true';
		Ext.getCmp('con_wsdl1').removeAll();
		Ext.getCmp('con_wsdl1').hide();
	}

	var bckwsdlitemsLen = wsdlcontainer.items.length;
	if (bckwsdlitemsLen ==0)
	{
		Ext.getCmp('addWsdlUrlbtn').setText('Add');
		if (noWsdl == 'true')
		{
			Ext.getCmp('NoWsdlUrlPattern').show();
			Ext.getCmp('updateWsdlUrl').disable();
			Ext.getCmp('clearWsdlUrl').disable();
		}
	}
}
function addElementsConfigEjbs() { //config Ejbs
	var mainconfigEjbsForm = Ext.getCmp('egconfigejb');
	var addedEjbscontainer = Ext.getCmp('addedEjbscontainer');
	var conEjbsId = "conEjbs_"+inputsEjbs
	var tempEjbscontainer = Ext.form.Panel({
		title: 'ConfigEjbs',
		collapsible: false,
		id : conEjbsId,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'center'
		},
		padding: '0 10 0 10',
		width: 700,
		margin: 15,
		items: [
			{
				xtype: 'label',
				id: 'addejbs'+inputsEjbs,
				width: 700,
				html: '',
			}
		],
		tools: [
		{
			xtype: 'button',
			id: 'modifyejbs'+inputsEjbs,
			width: 80,
			margin: '0 20 0 0',
			backupId: inputsEjbs,
			text: 'Modify',
			listeners: {
				click: function(){
					testInterViews.modifyEjbsItemSelector('addejbs'+this.backupId,this.backupId);
				}
			}
		},
		{
			xtype: 'button',
			id: 'deleteejbs'+inputsEjbs,
			width: 80,
			text: 'Delete',
			backupId: inputsEjbs,
			listeners: {
				click: function(){
					testInterViews.deleteEjbsManagedElements('addejbs'+this.backupId,this.backupId);
				}
			}
		}
	]
	});
	addedEjbscontainer.add(tempEjbscontainer);
	mainconfigEjbsForm.doLayout();
	inputsEjbs++;
}

function addMultiResourceContact()
{
	var mainForm = Ext.getCmp('egconfigureresource');
	var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
	var conIdRes = "conRes_"+inputResource
	var tmpMultiContainer = {
		xtype : 'fieldset',
		id : conIdRes,
		//style: {
			//'background' : '#ffffff',
			//'border' : '1px solid lightGrey',
			//'box-shadow':'none'
		//},
		padding:'10 0 10 10',
		margin: '10 10 0 10',
		items: [
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						columnWidth: 1,
						defaults: {
							margin: 5,
							labelSeparator:' ',
							labelAlign: 'top',
						},
						items: [
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'folderName'+inputResource,
								fieldLabel: 'Tab Name',
								value: 'none',
								columnWidth: 0.33
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								fieldLabel: 'Application/Desktop Name',
								id:'resourceName'+inputResource,
								columnWidth: 0.34
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								fieldLabel: 'Window Title',
								id:'winTitle'+inputResource,
								value: 'none',
								columnWidth: 0.33
							}
						]
					},
					{
						xtype: 'container',
						style:{
							'position':'absolute',
							'top':'2px',
							'right':'2px',
							'width':'20px',
							'height':'20px'
						},
						margin:'0 0 0 0',
						items : [
							{
								xtype : 'button',
								iconCls : 'img_removeShift',
								tooltip : '<b>Remove</b>',
								style : {
									background : 'none',
									border : '0px'
								},
								handler: function()
								{
									removeMultiResource(conIdRes);
								}
							}
						]
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();

	Ext.getCmp('addMultiresbtn').setText('Add More');
	Ext.getCmp('updateMultires').enable();
	Ext.getCmp('clearMultires').enable();
	Ext.getCmp('NoMultiResPattern').hide();

	inputResource++;
}

function removeMultiResource(containerID)
{
	var backupcontainer = Ext.getCmp('backupmultirescontainer');
	backupcontainer.remove(containerID);
	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		inputResource = 1;
		Ext.getCmp('NoMultiResPattern').show();
		Ext.getCmp('updateMultires').disable();
		Ext.getCmp('clearMultires').disable();
		Ext.getCmp('addMultiresbtn').setText('Add');
	}
}

function groupExists(grpname)
{
	var grplist = publicInfosJSON['s_grp_list'];
	if(grplist.indexOf(",") > -1)
	{
		var arr_grps = grplist.split(',');
		for(var i=0;i < arr_grps.length;i++)
		{
			if(arr_grps[i].toLowerCase() == grpname.toLowerCase())
			{
				return true;
			}
		}
	}
	else
	{
		if(grplist.toLowerCase() == grpname.toLowerCase())
		{
			return true;
		}
	}
	return false;
}

function ejbGroupExists(grpname)
{
	var grplist = publicEjbsJSON['s_grp_list'];
	if(grplist.indexOf(",") > -1)
	{
		var arr_grps = grplist.split(',');
		for(var i=0;i < arr_grps.length;i++)
		{
			if(arr_grps[i].toLowerCase() == grpname.toLowerCase())
			{
				return true;
			}
		}
	}
	else
	{
		if(grplist.toLowerCase() == grpname.toLowerCase())
		{
			return true;
		}
	}
	return false;
}

function addServiceConf_pr(grid_name,data,pr_measure_diplayname)
{
	var performanceRatingForm = Ext.getCmp('minmaxvalues');
	var performanceRatingContainer = Ext.getCmp('ratingMeasuresContr');
	var tempRatingContainer = {
		xtype: 'grid',
		cls:'gridSkin',
		title: 'Measure : '+pr_measure_diplayname,
		id: grid_name,
		hidden:false,
		flex:1,
		autoScroll:true,
		scroll:true,
		margin:'10 10 0 10',
		columnLines:true,
		sortableColumns:false,
		plugins: Ext.create('Ext.grid.plugin.CellEditing', {
			pluginId: grid_name,
			clicksToEdit: 1
		}),
		store:Ext.create('Ext.data.Store',{
			fields:['pr_measure_name','associated_test_name','associated_test_description','associated_measure_name','associated_measure_description','associated_measure_min_threshold','associated_measure_max_threshold'],
			data:data
		}),
		columns: {
			defaults: {
				sortable: true,
				hideable: false,
				menuDisabled: true,
				draggable: false,
				resizable: true,
				isCheckerHd: false
			},
			items: [
				{
					dataIndex: 'pr_measure_name',
					hidden: true
				},
				{
					dataIndex: 'associated_test_name',
					hidden: true
				},
				{
					header: 'Test Name',
					dataIndex: 'associated_test_description',
					flex: 2
				},
				{
					dataIndex: 'associated_measure_name',
					hidden: true
				},
				{
					header: 'Measure Name',
					dataIndex: 'associated_measure_description',
					flex: 2
				},
				{
					header: 'Mininum Values',
					dataIndex: 'associated_measure_min_threshold',
					flex: 1,
					field: {
						cls:'textbox',
						allowBlank: false
					},
					cellEditing:true,
					renderer : function(value, metadata) {
						metadata.tdAttr = 'data-qtip="Critical/Major/Minor in ascending order"';
						metadata.tdCls = "grid_editable_cell";
						return value;
					}
				},
				{
					header: 'Maximum Values',
					dataIndex: 'associated_measure_max_threshold',
					flex: 1,
					field: {
						cls:'textbox',
						allowBlank: false
					},
					cellEditing:true,
					renderer : function(value, metadata) {
						metadata.tdAttr = 'data-qtip="Critical/Major/Minor in descending order"';
						metadata.tdCls = "grid_editable_cell";
						return value;
					}
				}
			]
		}
	}
	performanceRatingContainer.add(tempRatingContainer);
	performanceRatingForm.doLayout();
}

function addOids()
{
	if (inputs == 9)
	{
		Ext.Msg.show({
		title: 'ADD OID',
		msg: 'Cannot add more than 8 OIDs',
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	var mainForm = Ext.getCmp('EgOidsValue');
	var backupcontainer = Ext.getCmp('backupcontainer');
	if(removedOid.length > 0)
	{
		var conId = "con_"+removedOid[0];
		var oidFeild="oidVal"+removedOid[0];
		removedOid.splice(0,1);
	}
	else
	{
		var conId = "con_"+inputs;
		var oidFeild='oidVal'+inputs;
	}
	var tmpContainer = {
		xtype : 'fieldset',
		id : conId,
		layout : {
			type : 'vbox',
			pack : 'start',
			align : 'stretch'
		},
		margin: '5 5 5 5',
		items: [
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					labelSeparator:' ',
					labelWidth:25
				},
				margin: 0,
				columnWidth: 1,
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'OID',
						style:{'white-space':'nowrap'},
						id: oidFeild,
						value: '$unconfigured',
						columnWidth: 1
					},
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						margin: '0 0 0 5',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeOid(conId);
						}
					}
				]
			}
		]
	}
	backupcontainer.add(tmpContainer);
	mainForm.doLayout();
	inputs++;
	Ext.getCmp('addOidbtn').setText('Add More');
	Ext.getCmp('updateOid').enable();
	Ext.getCmp('clearOid').enable();
	Ext.getCmp('NoOidPattern').hide();
}
function removeOid(containerID)
{
	var backupcontainer = Ext.getCmp('backupcontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conoid_1')
	{
		isVmg = 'true';
		Ext.getCmp('conoid_1').removeAll();
		Ext.getCmp('conoid_1').hide();
		removedOid.push('1');
	}
	else
	{
		removedOid.push(containerID.substring(4, 5));
	}
	if (containerID == 'con_1')
	{
		isVmg = 'true';
	}
	inputs--;
	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addOidbtn').setText('Add');
		if (isVmg == 'true')
		{
			Ext.getCmp('NoOidPattern').show();
			Ext.getCmp('updateOid').disable();
			Ext.getCmp('clearOid').disable();
			inputs=1;
			removedOid=[];
		}
	}
}
function validateProcessName(val)
{
	chars_not_valid_for_process_name="|#\"";
	for(var i=0; i<val.length; i++)
	{
		idx = chars_not_valid_for_process_name.indexOf(val.charAt(i))
		if(idx >= 0)
		{
			return false;
		}
	}
	return true;
}
function validateProcessPattern(pattern,isConcise)
{
	var checkChars = ":\\/";
	var isValid = true;
	if(isConcise)
	{
		for(var i=0;i<checkChars.length;i++)
		{
			if(pattern.indexOf(checkChars.charAt(i)) >-1)
			{
				isValid = false;
				break;
			}
		}
	}
	return isValid;
}
function checkspecialExt(field,s_spl)
{
	if (typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function checkAscendingOrder(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}
function checkDescendingOrder(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}
function checkValidValue_rx(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	var regExp_rx = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp_rx.test(Cri);
	if(!ret)
	{
		ret = regExp_rx.test(Maj);
	}
	if(!ret)
	{
		ret = regExp_rx.test(Min);
	}
	return ret;
}
function validateTargetValues(val, min_trgt_val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return '0';//success
	}
	var arr = val.split("/");
	if(arr.length != 3) {
		if(min_trgt_val)
			return alert25;
		else
			return alert26;
	}
	var critical_part = arr[0].trim();
	var major_part = arr[1].trim();
	var minor_part = arr[2].trim();
	var result = null;
	if(critical_part != "-")
	{
		result = privatemethod(critical_part,min_trgt_val,"critical");
		if(result != '0')
			return result;
	}
	if(major_part != "-")
	{
		result = privatemethod(major_part,min_trgt_val,"major");
		if(result != '0')
			return result;
	}
	if(minor_part != "-")
	{
		result = privatemethod(minor_part,min_trgt_val,"minor");
		if(result != '0')
			return result;
	}
	return '0';//success
}
function privatemethod(val,min_trgt_val,state)
{
	var private_result='0';
	var regExp_rx= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	if((val.indexOf('-')!=val.lastIndexOf('-')) || (val.indexOf('.')!=val.lastIndexOf('.')))
	{
		if(min_trgt_val) {
			if(state=='critical')
				private_result = alert1;
			else if(state=='major')
				private_result=alert2;
			else if(state=='minor')
				private_result=alert3;
		}
		else {
			if(state=='critical')
				private_result = alert4;
			else if(state=='major')
				private_result=alert5;
			else if(state=='minor')
				private_result=alert6;
		}
	}
	else if(parseFloat(val) < 0)
	{
		if(min_trgt_val) {
			if(state=='critical')
				private_result = alert19;
			else if(state=='major')
				private_result=alert20;
			else if(state=='minor')
				private_result=alert21;
		}
		else {
			if(state=='critical')
				private_result = alert22;
			else if(state=='major')
				private_result=alert23;
			else if(state=='minor')
				private_result=alert24;
		}
	}
	else if(!regExp_rx.test(val))
	{
		var i_part = val;
		var f_part = '';
		var idx = val.indexOf('.');
		if(idx>-1)
		{
			i_part = val.substring(0,idx);
			f_part = val.substring(idx+1);
		}
		if(i_part.length>10)
		{
			if(min_trgt_val) {
				if(state=='critical')
					private_result = alert7;
				else if(state=='major')
					private_result=alert8;
				else if(state=='minor')
					private_result=alert9;
			}
			else {
				if(state=='critical')
					private_result = alert10;
				else if(state=='major')
					private_result=alert11;
				else if(state=='minor')
					private_result=alert12;
			}
		}
		else if(f_part.length>4)
		{
			if(min_trgt_val) {
				if(state=='critical')
					private_result = alert13;
				else if(state=='major')
					private_result=alert14;
				else if(state=='minor')
					private_result=alert15;
			}
			else {
				if(state=='critical')
					private_result = alert16;
				else if(state=='major')
					private_result=alert17;
				else if(state=='minor')
					private_result=alert18;
			}
		}
	}
	return private_result;
}
function correctFormat(val)
{
	val = val.trim();
	if(val.toLowerCase()=='-1')
	{
		return true;
	}
	if(val.toLowerCase().indexOf('none')>-1)
	{
		return false;
	}
	var arr = val.split("/");
	if(arr.length != 3)
	{
		return false;
	}
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if(Ext.isEmpty(Cri) || Ext.isEmpty(Maj) || Ext.isEmpty(Min))
	{
		return false;
	}
	if(Cri.length==0 || Maj.length==0 || Min.length==0)
	{
		return false;
	}
	return true;
}

//Targets starts
function addTgtPropsContainer(fieldValue)
{
	var fieldID = Ext.get(fieldValue).id;
	if (Ext.isEmpty(fieldID))
	{
		fieldID = fieldValue;
	}
	var mainFormID = fieldID.substring(fieldID.indexOf('_')+1);
	mainFormID = mainFormID.substring(0,mainFormID.indexOf('_'));
	fieldID = fieldID.substring(fieldID.lastIndexOf('_')+1);
	var mainForm = Ext.getCmp('EgConfigureTargetsAndSysProps');
	var auxiliarySysPropsDiv = Ext.getCmp('tgtPropsMainContainer'+mainFormID);
	if ((auxiliarySysPropsDiv.items.getCount()) == totalSystemProperties)
	{
		Ext.Msg.show({
			title: alertconfigUrl,
			msg: limitedSysPropsMsg,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation'
		});
		return;
	}

	var levelStr = (auxiliarySysPropsDiv.items.getCount() + 1);
	var conId = 'tgtPropsContainer_'+mainFormID+'_'+(auxiliarySysPropsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		columnWidth: 1,
		items : [
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemKeyLbl,
				id: 'tgtpropkey_'+mainFormID+'_'+levelStr,
				name: 'tgtpropkey_'+mainFormID+'_'+levelStr,
				value: 'none',
				margin: 5,
				columnWidth: 0.48,
				labelSeparator: ' ',
				labelAlign: 'top'
			},
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemValLbl,
				id: 'tgtpropval_'+mainFormID+'_'+levelStr,
				name: 'tgtpropval_'+mainFormID+'_'+levelStr,
				value: 'none',
				columnWidth: 0.48,
				margin: 5,
				labelSeparator: ' ',
				labelAlign: 'top'
			},
			{
				xtype: 'component',
				html: '<center><div class="iconMinus" data-qtip="<b>Remove System Property</b>" style="cursor:pointer;" onclick="javascript:removeTgtPropsContainer('+conId+')"></center>',
				columnWidth: 0.04,
				margin: '25 0 0 2'
			}
		]
	}
	auxiliarySysPropsDiv.add(tmpContainer);
	mainForm.doLayout();
}

function removeTgtPropsContainer(containerID)
{
	var fieldID = containerID.id;
	var mainContID = fieldID;
	mainContID = mainContID.substring(mainContID.indexOf("_")+1);
	mainContID = mainContID.substring(0,mainContID.indexOf("_"));
	var mainContainer = Ext.getCmp('tgtPropsMainContainer'+mainContID);
	var auxiliarySysPropsDiv = Ext.getCmp(fieldID);
	mainContainer.remove(auxiliarySysPropsDiv);

	var conLength = mainContainer.items.length;
	if (conLength > 0)
	{
		inputsIncPatt = 0;
		var existValues = new Array();
		for (var i = 1;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp('tgtPropsContainer_'+mainContID+'_'+(i+1));
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var key = Ext.getCmp('tgtpropkey_'+mainContID+'_'+(i+1)).getValue();
			var value = Ext.getCmp('tgtpropval_'+mainContID+'_'+(i+1)).getValue();
			existValues[inputsIncPatt] = key+'~!~'+value;
			inputsIncPatt++;
			mainContainer.remove(tmpLevelObj);
		}
		if (existValues != null && existValues.length > 0)
		{
			for (var e=0;e<existValues.length;e++)
			{
				var existVal =existValues[e];
				addTrgtPropsContainerWithValue('tgtPropsContainer_'+mainContID+'_'+(e+2),existVal);
			}
		}
	}
}

function addTrgtPropsContainerWithValue(fieldObj,fieldValue)
{
	var fieldID = fieldObj;
	var keyValPair = fieldValue;
	var key ='none';
	var value ='none';
	if (!Ext.isEmpty(keyValPair) && keyValPair.indexOf("~!~") != -1)
	{
		key = keyValPair.substring(0,keyValPair.indexOf('~'));
		value = keyValPair.substring(keyValPair.lastIndexOf('~')+1);
	}
	var mainFormID = fieldID.substring(fieldID.indexOf('_')+1);
	mainFormID = mainFormID.substring(0,mainFormID.indexOf('_'));
	fieldID = fieldID.substring(fieldID.lastIndexOf('_')+1);

	var mainForm = Ext.getCmp('EgConfigureTargetsAndSysProps');
	var auxiliarySysPropsDiv = Ext.getCmp('tgtPropsMainContainer'+mainFormID);
	if (!Ext.isEmpty(auxiliarySysPropsDiv.items))
	{
		if ((auxiliarySysPropsDiv.items.getCount()) == totalSystemProperties)
		{
			Ext.Msg.show({
				title: alertconfigUrl,
				msg: limitedSysPropsMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation'
			});
			return;
		}
	}

	var levelStr = (auxiliarySysPropsDiv.items.getCount() + 1);
	var conId = 'tgtPropsContainer_'+mainFormID+'_'+(auxiliarySysPropsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		columnWidth: 1,
		items : [
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemKeyLbl,
				id: 'tgtpropkey_'+mainFormID+'_'+levelStr,
				name: 'tgtpropkey_'+mainFormID+'_'+levelStr,
				value: key,
				margin: 5,

				columnWidth: 0.48,
				labelSeparator: ' ',
				labelAlign: 'top'
			},
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemValLbl,
				id: 'tgtpropval_'+mainFormID+'_'+levelStr,
				name: 'tgtpropval_'+mainFormID+'_'+levelStr,
				value: value,
				columnWidth: 0.48,
				margin: 5,
				labelSeparator: ' ',
				labelAlign: 'top'
			},
			{
				xtype: 'component',
				html: '<center><div class="iconMinus" data-qtip="<b>Remove System Property</b>" style="cursor:pointer;" onclick="javascript:removeTgtPropsContainer('+conId+')"></center>',
				columnWidth: 0.04,
				margin: '25 0 0 2'
			}
		]
	};
	auxiliarySysPropsDiv.add(tmpContainer);
	mainForm.doLayout();
}

function addTrgtUrlContact() 
{ 
	var mainTgtForm = Ext.getCmp('EgConfigureTargetsAndSysProps');
	var trgturlcontainer = Ext.getCmp('targeturlcontainer');
	var conTrgtUrlId = "con_"+inputsTrgtUrl
	var tempTrgtcontainer = {
		xtype : 'fieldset',
		id : conTrgtUrlId,
		width: 600,
		layout : {
			type : 'vbox',
			pack : 'center',
			align : 'stretch'
		},
		style: {
			background : 'none',
			border : '1px solid lightGrey'
		},
		margin: '5 5 5 5',
		items: [
			{
				xtype: 'container',
				layout: {
					type: 'hbox',
					pack: 'end'
				},
				margin:'0 10 0 0',
				items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeTrgtUrlContact(conTrgtUrlId);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 5,
					labelSeparator: ' ',
					labelAlign: 'top'
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Host',
						id: 'hostTrgt'+inputsTrgtUrl,
						name: 'hostTrgt'+inputsTrgtUrl,
						value: '$unconfigured',
						columnWidth: 0.38
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Port',
						id: 'portTrgt'+inputsTrgtUrl,
						name: 'portTrgt'+inputsTrgtUrl,
						value: '$unconfigured',
						columnWidth: 0.62
					},
					{
							xtype: 'fieldcontainer',
							layout: 'column',
							columnWidth: 0.01
					},
					{
						xtype: 'fieldset',
						id:'tgtpropsfieldset'+inputsTrgtUrl,
						name:'tgtpropsfieldset'+inputsTrgtUrl,
						columnWidth: 1,
						title: 'System Properties',
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						items: [
							{
								xtype: 'container',
								id : 'tgtPropsMainContainer'+inputsTrgtUrl,
								layout: 'column',
								columnWidth: 1,
								defaults: {
									labelSeparator: '',
									margin: '0 5 5 5'
								},
								items: [
									{
										xtype : 'container',
										id: 'tgtPropsContainer_'+inputsTrgtUrl+'_1',
										name: 'tgtPropsContainer_'+inputsTrgtUrl+'_1',
										layout: 'column',
										columnWidth: 1,
										items : [
											{
												xtype: 'textfield',
												cls: 'textbox',
												fieldLabel: urlSystemKeyLbl,
												id: 'tgtpropkey_'+inputsTrgtUrl+'_1',
												name: 'tgtpropkey_'+inputsTrgtUrl+'_1',
												value: 'none',
												margin: 5,
												columnWidth: 0.48,
												labelSeparator: ' ',
												labelAlign: 'top'
											},
											{
												xtype: 'textfield',
												cls: 'textbox',
												fieldLabel: urlSystemValLbl,
												id: 'tgtpropval_'+inputsTrgtUrl+'_1',
												name: 'tgtpropval_'+inputsTrgtUrl+'_1',
												value: 'none',
												columnWidth: 0.48,
												margin: 5,
												labelSeparator: ' ',
												labelAlign: 'top'
											},
											{
												xtype: 'component',
												html: '<center><div class="iconPlus" style="cursor:pointer;" data-qtip="<b>Add System Property</b>" onclick="javascript:addTgtPropsContainer(tgtPropsContainer_'+inputsTrgtUrl+'_1)"></center>',
												columnWidth: 0.04,
												margin: '25 0 0 2'
											}
										]
									}
								]
							}
						]
					}
				]
			}
		]
	}
	trgturlcontainer.add(tempTrgtcontainer);
	Ext.getCmp('hostTrgt'+inputsTrgtUrl).focus();
	mainTgtForm.doLayout();
	inputsTrgtUrl++;
	Ext.getCmp('addTgtUrlbtn').setText('Add More');
	Ext.getCmp('updateTgtUrl').enable();
	Ext.getCmp('clearTgtUrl').enable();
	Ext.getCmp('NoTrgtUrlPattern').hide();
}

function removeTrgtUrlContact(trgtID) {
	var credrl = Ext.getCmp('targeturlcontainer');
	var trgturlcontainer = Ext.getCmp('targeturlcontainer');
	trgturlcontainer.remove(trgtID);

	if (trgtID == 'contrgt_1')
	{
		istrgt = 'true';
		Ext.getCmp('contrgt_1').removeAll();
		Ext.getCmp('contrgt_1').hide();
	}

	var bckitemscredLen = trgturlcontainer.items.length;
	if (bckitemscredLen == 0)
	{
		Ext.getCmp('addTgtUrlbtn').setText('Add');
		if (istrgt == 'true')
		{
			Ext.getCmp('NoTrgtUrlPattern').show();
			Ext.getCmp('updateTgtUrl').disable();
			Ext.getCmp('clearTgtUrl').disable();
		}
	}
}
//Target end

function addSysPropsContainer(fieldValue)
{
	var fieldID = Ext.get(fieldValue).id;
	if (Ext.isEmpty(fieldID))
	{
		fieldID = fieldValue;
	}
	var mainFormID = fieldID.substring(fieldID.indexOf('_')+1);
	mainFormID = mainFormID.substring(0,mainFormID.indexOf('_'));
	fieldID = fieldID.substring(fieldID.lastIndexOf('_')+1);
	var mainForm = Ext.getCmp('egconfigureurlandcredentials');
	var auxiliarySysPropsDiv = Ext.getCmp('sysPropsMainContainer'+mainFormID);
	if ((auxiliarySysPropsDiv.items.getCount()) == totalSystemProperties)
	{
		Ext.Msg.show({
			title: alertconfigUrl,
			msg: limitedSysPropsMsg,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation'
		});
		return;
	}

	var levelStr = (auxiliarySysPropsDiv.items.getCount() + 1);
	var conId = 'sysPropsContainer_'+mainFormID+'_'+(auxiliarySysPropsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		columnWidth: 1,
		items : [
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemKeyLbl,
				id: 'syspropkey_'+mainFormID+'_'+levelStr,
				name: 'syspropkey_'+mainFormID+'_'+levelStr,
				value: 'none',
				margin: 5,

				columnWidth: 0.48,
				labelSeparator: ' ',
				labelAlign: 'top'
				//,hidden: true
			},
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemValLbl,
				id: 'syspropval_'+mainFormID+'_'+levelStr,
				name: 'syspropval_'+mainFormID+'_'+levelStr,
				value: 'none',
				columnWidth: 0.48,
				margin: 5,
				labelSeparator: ' ',
				labelAlign: 'top'
				//,hidden: true
			},
			{
				xtype: 'component',
				html: '<center><div class="iconMinus" data-qtip="<b>Remove System Property</b>" style="cursor:pointer;" onclick="javascript:removeSysPropsContainer('+conId+')"></center>',
				columnWidth: 0.04,
				margin: '25 0 0 2'
			}
		]
	}
	auxiliarySysPropsDiv.add(tmpContainer);
	mainForm.doLayout();
}

function addSysPropsContainerWithValue(fieldObj,fieldValue)
{
	var fieldID = fieldObj;
	//fieldID = fieldID.substring(fieldID.indexOf('Div')+3);

	var keyValPair = fieldValue;
	var key ='none';
	var value ='none';
	if (!Ext.isEmpty(keyValPair) && keyValPair.indexOf("~!~") != -1)
	{
		key = keyValPair.substring(0,keyValPair.indexOf('~'));
		value = keyValPair.substring(keyValPair.lastIndexOf('~')+1);

	}
	var mainFormID = fieldID.substring(fieldID.indexOf('_')+1);
	mainFormID = mainFormID.substring(0,mainFormID.indexOf('_'));
	fieldID = fieldID.substring(fieldID.lastIndexOf('_')+1);

	var mainForm = Ext.getCmp('egconfigureurlandcredentials');
	var auxiliarySysPropsDiv = Ext.getCmp('sysPropsMainContainer'+mainFormID);
	if (!Ext.isEmpty(auxiliarySysPropsDiv.items))
	{
		if ((auxiliarySysPropsDiv.items.getCount()) == totalSystemProperties)
		{
			Ext.Msg.show({
				title: alertconfigUrl,
				msg: limitedSysPropsMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation'
			});
			return;
		}
	}

	var levelStr = (auxiliarySysPropsDiv.items.getCount() + 1);
	var conId = 'sysPropsContainer_'+mainFormID+'_'+(auxiliarySysPropsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		columnWidth: 1,
		items : [
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemKeyLbl,
				id: 'syspropkey_'+mainFormID+'_'+levelStr,
				name: 'syspropkey_'+mainFormID+'_'+levelStr,
				value: key,
				margin: 5,

				columnWidth: 0.48,
				labelSeparator: ' ',
				labelAlign: 'top'
				//,hidden: true
			},
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel: urlSystemValLbl,
				id: 'syspropval_'+mainFormID+'_'+levelStr,
				name: 'syspropval_'+mainFormID+'_'+levelStr,
				value: value,
				columnWidth: 0.48,
				margin: 5,
				labelSeparator: ' ',
				labelAlign: 'top'
				//,hidden: true
			},
			{
				xtype: 'component',
				html: '<center><div class="iconMinus" data-qtip="<b>Remove System Property</b>" style="cursor:pointer;" onclick="javascript:removeSysPropsContainer('+conId+')"></center>',
				columnWidth: 0.04,
				margin: '25 0 0 2'
			}
		]
	};
	auxiliarySysPropsDiv.add(tmpContainer);
	mainForm.doLayout();
}

function removeSysPropsContainer(containerID)
{
	var fieldID = containerID.id;
	var mainContID = fieldID;
	mainContID = mainContID.substring(mainContID.indexOf("_")+1);
	mainContID = mainContID.substring(0,mainContID.indexOf("_"));
	//mainContID = mainContID.substring(mainContID.lastIndexOf("ner")+3);

	var mainContainer = Ext.getCmp('sysPropsMainContainer'+mainContID);
	var auxiliarySysPropsDiv = Ext.getCmp(fieldID);
	mainContainer.remove(auxiliarySysPropsDiv);

	var conLength = mainContainer.items.length;
	if (conLength > 0)
	{
		inputsIncPatt = 0;
		var existValues = new Array();
		for (var i = 1;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp('sysPropsContainer_'+mainContID+'_'+(i+1));
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var key = Ext.getCmp('syspropkey_'+mainContID+'_'+(i+1)).getValue();
			var value = Ext.getCmp('syspropval_'+mainContID+'_'+(i+1)).getValue();
			existValues[inputsIncPatt] = key+'~!~'+value;
			inputsIncPatt++;
			mainContainer.remove(tmpLevelObj);
		}
		if (existValues != null && existValues.length > 0)
		{
			for (var e=0;e<existValues.length;e++)
			{
				var existVal =existValues[e];
				addSysPropsContainerWithValue('sysPropsContainer_'+mainContID+'_'+(e+2),existVal);
			}
		}
	}
}

function validateIpOrHNameExt(pageName,field)
{
	var fieldvalue = field.getValue();
	var s_val = fieldvalue;
	var dot_count = 0;
	var ishostName= false;
	var isIpv6 = false;
	var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	if(s_val.indexOf(":")>-1)
		isIpv6=true;

	if(isIpv6)
	{
		result = checkIPv6Ext(pageName,field);
		return result;
	}
	else
	{
		for(var m=0; m<s_val.length; m++)
		{
			check_char = alpha.indexOf(s_val.charAt(m))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				ishostName=true;
			}
		}

		if(!ishostName)
		{
			for(var k=0;k < s_val.length;k++)
			{
				if(s_val.charAt(k) == '.' && s_val.charAt(k + 1) == '.')
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkIp,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function() {
							field.focus(true,true);
						}
					});
					return false;
				}
				else
				{
					continue;
				}
			}
			for(var i=0;i < s_val.length;i++)
			{
				if(s_val.charAt(i) == '.')
				{
					dot_count = dot_count + 1;
				}
				else
				{
					continue;
				}
			}

			if(dot_count != 3)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _valIp,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						field.focus(true,true);
					}
				});
				return false;
			}

			if(s_val.charAt(0) == '.' || s_val.charAt(s_val.length - 1) == '.')
			{
				Ext.Msg.show({
					title: pageName,
					msg: _validateIp,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						field.focus(true,true);
					}
				});
				return false;
			}
		}
		for(var j = 0; j < s_val.length; j++)
		{
			if(s_val.charAt(j) == ' ')
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspaceIp,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						field.focus(true,true);
					}
				});
				return false;
			}
		}
		var splChar = "`~!@#$%^&*()_+={}[]|\\:;\"\'<>,?\/";

		for(var k=0; k<s_val.length; k++)
		{
			check_char = splChar.indexOf(s_val.charAt(k))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 1)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						field.focus(true,true);
					}
				});
				return false;
			}
		}

		if(s_val.indexOf('.') > -1 && dot_count > 2)
		{
			var number_bet_dots = s_val.split('.');
			for(var l=0;l < number_bet_dots.length;l++)
			{
				if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checknum,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function() {
							field.focus(true,true);
						}
					});
					return false;
				}
			}
		}
		return true;
	}
}

function checkspaceExt(field)
{
	var s_val;
	if(typeof(field)=='object')
	{
		s_val = field.value;
	}
	else
	{
		s_val = field;
	}
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			//alert(_checkblank);
			return false;
		}
	}
	return true;
}

function checkIPv6Ext(pageName,field)
{
	/** IPv6 Validation Starts
	 * 
	 */
	var s_val = field.getValue();
	if(!checkspecialnomess(s_val,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
	{
		//alert(_checkspecial);
		Ext.Msg.show({
			title: pageName,
			msg: _checkspecial,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}

	if(!checkspaceExt(s_val))
	{
		Ext.Msg.show({
			title: pageName,
			msg: _checkblank,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	var regD1= /[\.]{2,}/;
	var regD2= /(^(\.){1,})|((\.){1,}$)/gi;
	var regD3= /(\.\:){1,}|(\:\.){1,}/;
	if(s_val.match(regD1) != null || s_val.match(regD3) != null  )
	{
		//alert(_chkIpv6);
		Ext.Msg.show({
			title: pageName,
			msg: _chkIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	
	if(s_val.match(regD2) != null)
	{
		Ext.Msg.show({
			title: pageName,
			msg: _validateIp,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	var reg1= /[\:]{2,}/g;
	var reg1Res = s_val.match(reg1); 
	
	if( reg1Res != null &&  reg1Res != "::" )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _doubleColon,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	
	var regCntRes = s_val.split(":");
	var regColonLen = regCntRes.length;
	regColonLen--;
	var strV4, strV6;
	strV6 = s_val;
	
	if( regCntRes.length <= 7 && s_val.indexOf(".") != -1 )
	{
		var regDRes = s_val.split(".");
		var regDLength = regDRes.length;
		regDLength--;
		
		strV4 = s_val.substring((s_val.lastIndexOf(":")+1));
		strV6 = s_val.substring(0,(s_val.lastIndexOf(":")));
		
		var regIp4 = /[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}((\/){1}[0-9]{1,3})*$/gi;
		regIp4Res = s_val.match(regIp4);
			
		if(regIp4Res  == null || regIp4Res != strV4 )
		{
			//alert(_valIp);
			Ext.Msg.show({
				title: pageName,
				msg: _valIp,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function() {
					field.focus(true,true);
				}
			});
			return false;
		}
		if(strV6.indexOf(".") != -1)
		{
			//alert(_checkIp);
			Ext.Msg.show({
				title: pageName,
				msg: _checkIp,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function() {
					field.focus(true,true);
				}
			});
			return false;
		}
		if((regDLength > 3) || (regDLength != 3))
		{
			//alert(_valIp);
			Ext.Msg.show({
				title: pageName,
				msg: _valIp,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function() {
					field.focus(true,true);
				}
			});
			return false;
		}
		var arr = strV4.split("/");
		strV4 = arr[0];
		var number_bet_dots = strV4.split('.');

		for(var l=0;l < number_bet_dots.length;l++)
		{
			if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checknum,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						field.focus(true,true);
					}
				});
				return false;
			}
		}
	}
	else if((regColonLen > 7)||(reg1Res != "::")&&(regColonLen<7))
	{
		Ext.Msg.show({
			title: pageName,
			msg: _grpIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	
	var arr = strV6.split("/");
	strV6 = arr[0];
	
	var regPartRes2 = "";
	var regPart = /^(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1}((\:){1,2}[a-z0-9]{0,4}){1,})|(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1})$/gi;
	var regPartRes1 = strV6.match(regPart);
	regPart = /^[a-f0-9]{0,4}$/gi;
	
	if(strV6.indexOf(":") == -1)
	{
		regPartRes2 = strV6.match(regPart);
	}
	if( ( (regPartRes1 == null) || (regPartRes1 != strV6) ) && (regPartRes2 != strV6) )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _digitIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}

	var regC = /(::){0,1}([a-f0-9(::)(\.)]*[\:]{1})+[a-f(::)(\.)0-9]*((\/){0,1}[0-9]{1,3})*/ig; // Right 1
	var regCRes = s_val.match(regC);

	if( regCRes == null ||  regCRes != s_val )
	{
		Ext.Msg.show({
			title: pageName,
			msg: _validateIpv6,
			buttons: Ext.Msg.OK,
			icon: 'iconInformation',
			fn: function() {
				field.focus(true,true);
			}
		});
		return false;
	}
	return true;	
}
function doesExist(searchList,serviceName)
{
	for(var i=0;i<searchList.length;i++)
	{
		var searchStr = searchList[i];
		if(serviceName.indexOf(searchStr) !=-1 || serviceName.toLowerCase().indexOf(searchStr.toLowerCase()) !=-1)
			return true;
	}
	return false;
}
function isAllowDoubleByte(name,MsgTitle,from,fieldId,isDiscover,errMsg,isProcessName)
{
	var checkName = name;
	if(from == 'process')
	{
		checkName = name.indexOf(":")>-1?name.substring(0,name.indexOf(":")):name;
		if(!isProcessName)
			checkName =  name.indexOf(":")>-1?name.substring(name.indexOf(":")+1):"";
	}
	if(!isDoubleByteMgr && !validateSingleByte(checkName))
	{
		Ext.Msg.show({
			title: MsgTitle,
			msg: errMsg,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation',
			fn: function() {
				if(isDiscover){
					if(from == 'service')
						testInterViews.editService("",name.toString());
					else if(from == 'process')
						testInterViews.editProcess("",name.toString(),isProcessName);
				}
				else
					Ext.getCmp(fieldId).focus(false,200);
			}
		});
		return false;
	}
	return true;
}

function addBtmPatternProps() { //credentials url
	var maincredentialForm = Ext.getCmp('egconfigureurlandcredentials');
	var credurlcontainer = Ext.getCmp('credurlcontainer');
	var patternDataSize = publicBtmJSON['patternCount'];
	// patternDataSize = patternDataSize+1;
		var mypatternData = publicBtmJSON['patternData'][0];
	////console.log("patternDataSize : " + patternDataSize)
	////console.log("patternDataSize : " + mypatternData['descc'])
	////console.log("patternDataSize : " + mypatternData['url'])


		Ext.getCmp('name').setValue(mypatternData['descc']);
		Ext.getCmp('uri_1').setValue("EQ");
		Ext.getCmp('nameURL1').setValue(mypatternData['url']);
		maincredentialForm.doLayout();
		// return;
		var innerPropsCount = mypatternData['size'];
		////console.log('innerPropsCount :-' + innerPropsCount);
		for (var t = 0; t < innerPropsCount; t++) {
			var propsID = t + 1;

			// Show hide ADD | Remove buttons
			var hideRemoveBtn = false;
			var hideAddBtn = false;
			if (propsID == "1") {
				hideAddBtn = false;
				hideRemoveBtn = true;
			} else {
				hideAddBtn = true;
				hideRemoveBtn = false;
			}

			var innerProps= mypatternData['propsData'][t];
			var showSegmentData = innerProps['isSegMent'];
			var hideSegment = true;
			var showParameterData = innerProps['isParameter'];
			var hideParameter = true;
	
			var dataValue = "1stFew";
			if (showSegmentData) {
				hideParameter = true;
				hideSegment = false;
				dataValue = "1stFew";
			}

			if (showParameterData) {
				hideParameter = false;
				hideSegment = true;
				dataValue='param';
				
			}
			var id = inputsCredUrl;
				var tmpContainer = {
								xtype:'container',
								margin: '10 0 10 0',
								id: 'urlProperty_1_'+id,
								layout:{
									type:'column',
									align:'stretch'
								},
								items:[
								{
									// hidden : true,
									xtype:'label',
									textAlign:'center',
									margin: '5 0 15 0',
									style:{'text-align':'center'},
									columnWidth:1.3,
									// html:'<span style="border:#abb2bd 1px solid;padding:0px 5px;">And</span>',
									text : ' And ',
								},
								{
									xtype: 'combo',
									cls: 'dropdown',
									labelWidth: 'auto',
									fieldLabel: 'Use',
									margin: '3 0',
									displayField: 'displayField',
									valueField: 'valueField',
									value :dataValue,
									editable : false,
									id: 'urlsegment_1_'+id,
									// columnWidth:0.50,
									labelSeparator: ' ',
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: [{
												'displayField': 'first few URI segment(s)',
												'valueField': '1stFew'
											}, {
												'displayField': 'last few URL segment(s)',
												'valueField': 'lastfew'
											}, {
												'displayField': 'specific URL segment(s)',
												'valueField': 'specific'
											}, {
												'displayField': 'a parameter value',
												'valueField': 'param'
											}
										]
									}),
									listeners:{
											change: function() {
												var changeValue = this.getValue();
												if (changeValue != "param")
												{
													Ext.getCmp('urlsegmentContainer_1_'+id).show();
													Ext.getCmp('urlparamContainer_1_'+id).hide();
												}
												if (changeValue == "param")
												{
													Ext.getCmp('urlsegmentContainer_1_'+id).hide();
													Ext.getCmp('urlparamContainer_1_'+id).show();
												}
											}
									}
								},
								{
									xtype: 'fieldcontainer',
									hidden : hideSegment,
									columnWidth:1,
									layout: 'hbox',
									id : 'urlsegmentContainer_1_'+id,
									items: [{
											xtype: 'textfield',
											cls: 'textbox',
											labelWidth: 60,
											value: innerProps['Segment'],
											id: 'urlsegmentNo_1_' + id,
											labelSeparator: ' ',
											margin: '0 5',
											fieldLabel: ': Use first',
										}, {
											xtype: 'label',
											forId: 'segementsURL',
											margin: '0 5',
											text: 'Segements of the URL',
										},
										{
											// hidden : true,
											xtype: 'button',
											margin: '0 270',
											id: 'removebutton1_' + id,
											iconCls: 'iconMinus',
											tooltip: '<b>remove URL Property</b>',
											style: {
												background: 'none',
												border: '0px'
											},
											handler: function () {
												removeUrlPropsContainer(this.getId());
											}
										}
									]
								},
								
								{
									xtype: 'fieldcontainer',
									layout: 'hbox',
									id : 'urlparamContainer_1_'+id,
									hidden:hideParameter,
									columnWidth:1,
									items:[
										{
									xtype: 'textfield',
									cls: 'textbox',
									labelSeparator: ' ',
									id: 'urlParam_1_'+id,
									value : innerProps['Parameter'],
									margin: '0 5',
									labelWidth:'auto',
									fieldLabel: ': Use value of request parameter key 	',
								},{
									xtype: 'textfield',
									cls: 'textbox',
									id: 'urlRegEx_1_'+id,
									labelWidth:'auto',
									value : innerProps['RegX'],
									margin: '0 0',
									labelSeparator: ' ',
									//width:150,
									fieldLabel: ' and apply regex',
								},
								{
										xtype : 'button',
										margin:'0 33',
										id : 'removebutton2_'+id,
										iconCls : 'iconMinus',
										tooltip : '<b>remove URL Property</b>',
										style : {
											background : 'none',
											border : '0px'
										},
										handler: function()
										{
											removeUrlPropsContainer(this.getId());
										}
									}
									]
								},
								
								]
							}
			var auxiliarySysPropsDiv = Ext.getCmp('urlPropsfieldset1');
			auxiliarySysPropsDiv.add(tmpContainer);
			
			inputsCredUrl++;
			maincredentialForm.doLayout();
		}
		// credurlcontainer.add(tempcredcontainer);
		// maincredentialForm.doLayout();
		////console.log('after insertion - bckitemscredLen ' + credurlcontainer.items.length);
		// Ext.getCmp('nameCred'+inputsCredUrl).focus();
	// }
	maincredentialForm.doLayout();
	// Ext.getCmp('addPatternbtn').setText('Add More');
	Ext.getCmp('updateCredUrl').enable();
	// Ext.getCmp('clearCredUrl').enable();
	// Ext.getCmp('NoCredUrlPattern').hide();
}

function addUrlPropsContainer(fieldValue,urlSegmentType,iniCount,paramKey,regex) {
	
	urlSegmentType = (urlSegmentType==undefined) ? '1stFew' : urlSegmentType;
	iniCount = !Ext.isDefined(iniCount) ? 3 : iniCount;
	paramKey = !Ext.isDefined(paramKey) ? '':paramKey;
	regex = !Ext.isDefined(regex) ? '':regex;

	var fieldID = Ext.get(fieldValue).id;
	var mainForm = Ext.getCmp('businesstransactionrule');
	var auxiliarySysPropsDiv = Ext.getCmp(fieldValue);
	var totalyurlProperties = 7

	if (Ext.isEmpty(fieldID)) {
		fieldID = fieldValue;
	}
	if ((auxiliarySysPropsDiv.items.getCount()) == totalyurlProperties) {
		Ext.Msg.show({
			title: ' Configure URL rules',
			msg: 'You have reached the maximum number of rules',
			buttons: Ext.Msg.OK,
			icon: 'iconInformation'
		});
		return;
	}
	
	var id = BTNamingSegmentCount;
	var conId = 'urlProperty_1_'+id;
	////console.log(' new URL props added :- '+conId);
	var tmpContainer = {
		xtype:'container',
		margin: '10 0 10 0',
		id: conId,
		layout:{
			type:'column',
			align:'stretch'
		},
		items: [
			{
				// hidden : true,
				xtype:'label',
				textAlign:'center',
				margin: '5 0 15 0',
				style:{'text-align':'center'},
				columnWidth:1.3,
				// html:'<span style="border:#abb2bd 1px solid;padding:0px 5px;">And</span>',
				text : ' And '
			},
			{
				xtype: 'combo',
				cls: 'dropdown',
				labelWidth: 60,
				fieldLabel: 'Use',
				margin: '3 0',
				displayField: 'displayField',
				valueField: 'valueField',
				value : urlSegmentType,
				editable : false,
				id: 'urlsegment_1_'+id,
				// columnWidth:0.50,
				labelSeparator: ' ',
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: [{
							'displayField': 'first few URI segment(s)',
							'valueField': '1stFew'
						//}, {
							//'displayField': 'last few URL segment(s)',
	//												'valueField': 'lastfew'
						}, {
							'displayField': 'specific URL segment(s)',
							'valueField': 'specific'
						}, {
							'displayField': 'a parameter value',
							'valueField': 'param'
						}
					]
				}),
				listeners: 
				{
					change : function() 
					{
						//console.log("inside Listener in intermediateJs.");
						var changeValue = this.getValue();
							//console.log('yes change Value is param');
						if (changeValue == "param") {
						Ext.getCmp('urlsegmentContainer_1_'+id).hide();
						Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
						Ext.getCmp('urlparamContainer_1_'+id).hide();
						Ext.getCmp('urlparamContainer_1_'+id).show();			
						Ext.getCmp('urlParam_1_'+id).focus(true,true);
					}else {
						if(changeValue == 'specific'){
							Ext.getCmp('urlsegmentContainer_1_'+id).hide();
							Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
							Ext.getCmp('urlparamContainer_1_'+id).hide();			
							Ext.getCmp('urlspecificsegmentContainer_1_'+id).show();
							Ext.getCmp('urlspecificsegmentNo_1_'+id).focus(true,true);
						}else{
							Ext.getCmp('urlsegmentContainer_1_'+id).hide();
							Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
							Ext.getCmp('urlparamContainer_1_'+id).hide();
							Ext.getCmp('urlsegmentContainer_1_'+id).show();
							Ext.getCmp('urlsegmentNo_1_'+id).focus(true,true);
						}
					}
					},
					afterrender : function() 
					{
						//console.log("inside Listener in intermediateJs.");
						var changeValue = this.getValue();
							//console.log('yes change Value is param');
						if (changeValue == "param") 
						{
							Ext.getCmp('urlsegmentContainer_1_'+id).hide();
							Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
							Ext.getCmp('urlparamContainer_1_'+id).hide();
							Ext.getCmp('urlparamContainer_1_'+id).show();
							Ext.getCmp('urlParam_1_'+id).focus(true,true);
						}
						else 
						{
							if(changeValue == 'specific'){
								Ext.getCmp('urlsegmentContainer_1_'+id).hide();
								Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
								Ext.getCmp('urlparamContainer_1_'+id).hide();			
								Ext.getCmp('urlspecificsegmentContainer_1_'+id).show();
								Ext.getCmp('urlspecificsegmentNo_1_'+id).focus(true,true);
							
							}else{
								Ext.getCmp('urlsegmentContainer_1_'+id).hide();
								Ext.getCmp('urlspecificsegmentContainer_1_'+id).hide();				
								Ext.getCmp('urlparamContainer_1_'+id).hide();
								Ext.getCmp('urlsegmentContainer_1_'+id).show();
								Ext.getCmp('urlsegmentNo_1_'+id).focus(true,true);
							}
						}
					}
				}
			},
			{
				xtype: 'fieldcontainer',
				// hidden : true,
				columnWidth:1,
				layout: 'hbox',
				id : 'urlsegmentContainer_1_'+id,
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						labelWidth:60,
						value: iniCount,
						id: 'urlsegmentNo_1_' + id,
						labelSeparator: ' ',
						margin: '0 5',
//						width: 200,
						fieldLabel: ': Use first'
					}, {
						xtype: 'label',
						width: 200,
						forId: 'segementsURL',
						margin: '0 5',
						text: 'Segements of the URL'
					},
					{
						xtype: 'component',
						flex: 1
					},
					{
						// hidden : true,
						xtype: 'button',
						margin: '0 100 0 0',
						id: 'removebutton1_' + id,
						iconCls: 'iconMinus',
						tooltip: '<b>remove URL Property</b>',
						style: {
							background: 'none',
							border: '0px'
						},
						handler: function () {
							removeUrlPropsContainer(this.getId());
						}
					}
				]
			},
			{
				xtype: 'fieldcontainer',
				 hidden : true,
				columnWidth:1,
				layout: 'hbox',
				id : 'urlspecificsegmentContainer_1_'+id,
				items: [{
						xtype: 'textfield',
						cls: 'textbox',
						labelWidth:60,
						value: iniCount,
						//width: 200,
						id: 'urlspecificsegmentNo_1_' + id,
						labelSeparator: ' ',
						margin: '0 5',
						fieldLabel: ': Use',
					}, 
					{
						xtype: 'label',
						forId: 'segementsURL',
						width: 200,
						margin: '0 5',
						text: 'Segement of the URL'
					},
					{
						xtype: 'component',
						flex: 1
					},
					{
						// hidden : true,
						xtype: 'button',
						//width: 200,
						id: 'removebutton3_' + id,
						margin: '0 100 0 0',
						iconCls: 'iconMinus',
						tooltip: '<b>remove URL Property</b>',
						style: {
							background: 'none',
							border: '0px'
						},
						handler: function () {
							removeUrlPropsContainer(this.getId());
						}
					}
				]
			},
			{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				id : 'urlparamContainer_1_'+id,
				hidden:true,
				columnWidth:1,
				items:[
					{
						xtype: 'textfield',
						value:paramKey,
						cls: 'textbox',
						labelSeparator: ' ',
						id: 'urlParam_1_'+id,
						margin: '0 5',
						labelWidth:'auto',
						fieldLabel: ': Use value of request parameter key'
					},{
						xtype: 'textfield',
						cls: 'textbox',
						id: 'urlRegEx_1_'+id,
						labelWidth:'auto',
						margin: '0 0',
						value:regex,
						labelSeparator: ' ',
						//width:150,
						fieldLabel: ' and apply regex'
					},
					{
								xtype: 'component',
								flex: 1
					},
					{
						xtype : 'button',
						id : 'removebutton2_'+id,
						margin: '0 100 0 0',
						iconCls : 'iconMinus',
						tooltip : '<b>remove URL Property</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							BTNamingSegmentCount--;
							removeUrlPropsContainer(this.getId());
						}
					}
				]
			}
		]
	};
	auxiliarySysPropsDiv.add(tmpContainer);
	BTNamingSegmentCount++;
	mainForm.doLayout();
}


function removeUrlPropsContainer(buttonID) {
	var idNo = buttonID.substring(buttonID.lastIndexOf("_") + 1);
	////console.log(' idNo:- '+idNo);
	var hi = Ext.getCmp('urlProperty_1_'+idNo);
	 Ext.getCmp('urlPropsfieldset1').remove(hi);
}


function removeSysPropsContainer(containerID) {
	var fieldID = containerID.id;
	var mainContID = fieldID;
	mainContID = mainContID.substring(mainContID.indexOf("_") + 1);
	mainContID = mainContID.substring(0, mainContID.indexOf("_"));
	//mainContID = mainContID.substring(mainContID.lastIndexOf("ner")+3);

	var mainContainer = Ext.getCmp('sysPropsMainContainer' + mainContID);
	var auxiliarySysPropsDiv = Ext.getCmp(fieldID);
	mainContainer.remove(auxiliarySysPropsDiv);

	var conLength = mainContainer.items.length;
	if (conLength > 0) 
	{
		inputsIncPatt = 0;
		var existValues = new Array();
		var existInputSources = new Array();
		for (var i = 1; i <= conLength; i++) {
			var tmpLevelObj = Ext.getCmp('sysPropsContainer_' + mainContID + '_' + (i + 1));
			if (tmpLevelObj == null || tmpLevelObj == undefined) {
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var inputSource = Ext.getCmp('inputsource_' + mainContID + '_' + (i + 1)).getValue();
			var urlSegmentValue = 'none';
			var urlSegmentValue = 'none';
			var values = 'none';
			if (inputSource != null) {
				if (inputSource == "US") {
					var segment = Ext.getCmp('urlsegmentindex_' + mainContID + '_' + (i + 1)).getValue();
					values = segment;
				} else if (inputSource == "QP") {
					var key = Ext.getCmp('syspropkey_' + mainContID + '_' + (i + 1)).getValue();
					var value = Ext.getCmp('syspropval_' + mainContID + '_' + (i + 1)).getValue();
					values = key + '~!~' + value
				} else {
					inputSource = 'none';
				}

			} else {
				inputSource = 'none';
			}

			existValues[inputsIncPatt] = values;
			existInputSources[inputsIncPatt] = inputSource;
			inputsIncPatt++;
			mainContainer.remove(tmpLevelObj);
		}
		if (existValues != null && existValues.length > 0) {
			for (var e = 0; e < existValues.length; e++) {
				var existVal = existValues[e];
				var existinputSource = existInputSources[e];
				addSysPropsContainerWithValue('sysPropsContainer_' + mainContID + '_' + (e + 2), existVal, existinputSource);
			}
		}
	}
}

function removeCredUrlContact(credID) {
	var credurlcontainer = Ext.getCmp('credurlcontainer');
	var checkme = Ext.getCmp(credID);
	if (!Ext.isEmpty(checkme)) 
	{

		////console.log(credID + ' is Not Empty, so removing');
		// checkme.hide();
		credurlcontainer.remove(credID);
		// checkme.removeAll(); //TODO: Why i cannot remove when items have more than one 1 elements
		// credurlcontainer.remove('con_2');

	} 

	if (credID == 'concred_1') {
		iscred = 'true';
		Ext.getCmp('concred_1').removeAll();
		Ext.getCmp('concred_1').hide();
		////console.log('iscred -' + iscred);
	}

	var bckitemscredLen = credurlcontainer.items.getCount();
	////console.log('after removing bckitemscredLen ' + bckitemscredLen);

	if (bckitemscredLen == 0) {
		Ext.getCmp('addPatternbtn').setText('Add');
		if (iscred == 'true') {
			Ext.getCmp('NoCredUrlPattern').show();
			Ext.getCmp('updateCredUrl').disable();
			Ext.getCmp('clearCredUrl').disable();
		}
	}
	////console.log('End');
}