Ext.define('SpecificTestConfiguration.view.ApplyToOtherComponents', {
	extend: 'Ext.form.Panel',
	alias: 'widget.applytoothercomponents',
	ui:'simplePanel simplePanelHeaderBorder',
	title: applyTitle,
	margin: '8 8 0 8',
	id: 'applyToOtherViewForm',
	isBackButton: '',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	requires: [
		'Ext.ux.form.ItemSelector'
	],
	dockedItems: [

		{
			xtype: 'toolbar',
			dock: 'bottom',
			cls: 'testConfigToolbarBg',
			ui: 'footer',
			margin: 0,
			padding: '10 0 10 0',
			layout:{pack:'center'},
			items: [
				{
					xtype: 'button',
					cls: 'button20',
					id: 'applyBtn',
					name: 'applyBtn',
					text: label1,
					width: 80
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'tmpApplyToOther'
		},
		{
			xtype: 'fieldset',
			title: 'Components',
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'center'
			},
			flex: 1,
			margin: '0 20 10 20',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							id: 'ea_criteria',
							name: 'ea_criteria',
							valueField: 'valueField',
							displayField: 'displayField',
							queryMode: 'local',
							editable: false,
							fieldLabel: viewBy,
							labelAlign: 'left',
							labelSeparator: ' ',
							width: 150,
							labelWidth: 50,
							store: new Ext.data.Store({
								fields:['displayField','valueField'],
								data:[]
							})
						},
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							id: 'ea_userOption',
							name: 'ea_userOption',
							valueField: 'valueField',
							displayField: 'displayField',
							queryMode: 'local',
							editable: false,
							fieldLabel: zoneServLbl,
							labelAlign: 'left',
							labelSeparator: ' ',
							width: 300,
							labelWidth: 60,
							margin: '0 0 0 40',
							hidden: true,
							store: new Ext.data.Store({
								fields:['displayField','valueField'],
								data:[]
							})
						}
					]
				},
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'stretch'
					},
					flex: 1,
					margin: '15 0 0 0',
					items: [
						{
							xtype: 'itemselector',
							cls: 'multiselect',
							id: 'serversItemSelectors',
							name: 'serversItemSelectors',
							fieldName: 'serversItemSelectors',
							buttons: ['add','remove'],
							buttonsText: {
								add: "Remove from configured components",
								remove: "Add to configured components"
							},
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							height: 200,
							width: 900,
							fromTitle: apply_fromTitle,
							toTitle: apply_toTitle
						}
					]
				}
			]
		},
		{
			xtype: 'hiddenfield',
			id: 'selectedComponents',
			name: 'selectedComponents',
			value: ''
		},
		{
			xtype: 'hiddenfield',
			id: 'selectedParameters',
			name: 'selectedParameters',
			value: ''
		}
	],

	tools: [
		{
			xtype: 'button',
			cls: 'backbutton',
			id: 'applyBackBtn',
			iconCls:'iconBack',
			name: 'applyBackBtn',
			text: Back
		}
	],
	listeners: {
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('applyTitle'),
				anchor: 'top',
				//anchortoTarget: true,
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageApplyDesc,
				cls: "adminInfoTooltip"
			});
		}
	}

});



