Ext.define('SpecificTestConfiguration.view.EgConfigComposite', {
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigcomposite',
	title: compositeTitle,
	id: 'egconfigcomposite',
	padding:'5 10 10 10',
	width: 800,
	height: 480,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					id: 'UpdateBTN',
					width: 80
				}
			]
		}
	],
	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'itemselector',
					cls: 'multiselect',
					name: 'itemselectAgg',
					fieldName: 'itemselectAgg',
					id: 'itemselectAgg',
					buttons: ['add','remove'],
					buttonsText: {
						add: "Add to Excluded",
						remove: "Remove from Excluded"
					},
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					width: 750,
					fromTitle: IncludedDesc,
					toTitle: ExcludedDesc,
					frame: true
				}
			]
		}
	]

});



