Ext.define('SpecificTestConfiguration.view.EgConfigEjbsCreation',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigejbscreation',

	border: false,
	title: addModifyEjbTitle,
	id: 'egconfigejbscreation',
	autoScroll: true,
	modal: true,
	width: 850,
	height: 480,
	padding:'5 10 10 10',

	requires: [
		'Ext.ux.form.ItemSelector'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [
		{
			id: 'dockedToolBarBtn',
			name: 'dockedToolBarBtn',
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: 'Update',
					width: 80,
					id: 'updateEjbsGroups',
					name: 'updateEjbsGroups'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 0 0',
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					id : 'groupnme',
					fieldLabel: ejbLabel2,
					labelSeparator: '',
					labelAlign: 'top',
					name: 'groupnme',
					width: 250
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'itemselector',
					cls: 'multiselect',
					name: 'itemselectejb',
					fieldName: 'itemselectejb',
					id: 'itemselectejb',
					buttons: ['add','remove'],
					buttonsText: {
						add: "Unmanage",
						remove: "Manage"
					},
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					width: 750,
					fromTitle: ejbLabel3,
					toTitle: ejbLabel4,
					moveRec: function(add, recs) {
						var me = this,
						fromField = me.fromField,
						toField   = me.toField,
						fromStore = add ? fromField.store : toField.store,
						toStore   = add ? toField.store   : fromField.store;
						if(add==true)
						{
							if(fromField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: ejbTitle,
									msg: operationToDisEjb,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								return;
							}
							if(fromField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: ejbTitle,
									msg: operationToDisEjb,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								return;
							}
						}
						else
						{
							if(toField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: ejbTitle,
									msg: operationToAssEjb,
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation'
								});
								return;
							}
							if(toField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: ejbTitle,
									msg: operationToAssEjb,
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation'
								});
								return;
							}
						}
						fromStore.suspendEvents();
						toStore.suspendEvents();
						fromStore.remove(recs);
						toStore.add(recs);
						fromStore.resumeEvents();
						toStore.resumeEvents();
						fromField.boundList.refresh();
						toField.boundList.refresh();
						me.syncValue();
					}
				}
			]
		}
	],

	listeners : {
		close : function()
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfigejb',
				method: 'POST',
				async: false
			});
		}
	}

});


