Ext.define('SpecificTestConfiguration.view.EgConfigInfosCreation',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfiginfoscreation',

	border: false,
	title: 'ADD/MODIFY EJB GROUPS',
	id: 'egconfiginfoscreation',
	autoScroll: true,
	modal: true,
	width: 850,
	height: 480,
	padding:'5 10 10 10',

	listeners : {
		close : function()
		{
			Ext.Ajax.request({
				url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=egconfiginfos',
				method: 'POST',
				async: false
			});
		}
	},

	dockedItems: [
		{
			id: 'dockedToolBarBtn',
			name: 'dockedToolBarBtn',
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: 'Update',
					width: 80,
					id: 'updateInfosGroups',
					name: 'updateInfosGroups'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 0 0',
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					id : 'groupnmeinfos',
					fieldLabel: 'Group name',
					labelSeparator: '',
					labelAlign: 'top',
					name: 'groupnmeinfos',
					width: 250
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			flex: 1,
			margin: '15 10 10 10',
			items: [
				{
					xtype: 'itemselector',
					cls: 'multiselect',
					name: 'itemselectinfos',
					fieldName: 'itemselectinfos',
					id: 'itemselectinfos',
					buttons: ['add','remove'],
					buttonsText: {
						add: "Unmanage",
						remove: "Manage"
					},
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					height: 200,
					width: 750,
					fromTitle: 'MANAGED ELEMENTS IN THE CURRENT GROUP',
					toTitle: 'ALL ELEMENTS',
					moveRec: function(add, recs) {
						var me = this,
						fromField = me.fromField,
						toField   = me.toField,
						fromStore = add ? fromField.store : toField.store,
						toStore   = add ? toField.store   : fromField.store;
						if(add==true)
						{
							if(fromField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: infosTitle,
									msg: operationToDisInfo,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								return;
							}
							if(fromField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: infosTitle,
									msg: operationToDisInfo,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								return;
							}
						}
						else
						{
							if(toField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: infosTitle,
									msg: operationToAssInfo,
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation'
								});
								return;
							}
							if(toField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: infosTitle,
									msg: operationToAssInfo,
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation'
								});
								return;
							}
						}
						fromStore.suspendEvents();
						toStore.suspendEvents();
						fromStore.remove(recs);
						toStore.add(recs);
						fromStore.resumeEvents();
						toStore.resumeEvents();
						fromField.boundList.refresh();
						toField.boundList.refresh();
						me.syncValue();
					}
				}
			]
		},
		{
			xtype: 'container',
			id: 'applyAllContainer',
			name: 'applyAllContainer',
			margin: '10 0 0 40',
			hidden: true,
			items: [
				{
					xtype: 'checkbox',
					cls: 'checkbt',
					id: 'applyAllCheck',
					name: 'applyAllCheck',
					fieldLabel: '',
					labelWidth: 80,
					labelSeparator: ' ',
					boxLabel: applyInfoLbl,
					checked: false,
				}
			]
		},
		{
			xtype: 'container',
			id: 'compMultiSelectContainer',
			name: 'compMultiSelectContainer',
			hidden: true,
			layout: {
				type: 'hbox',
				pack: 'start'
			},
			margin: '5 0 10 40',
			items: [
				{
					xtype: 'multiselectSi',
					cls: 'multiselect',
					id: 'availableCompMultiSelect',
					name: 'availableCompMultiSelect',
					title: availableInfoLbl,
					height: 200,
					width: 500,
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				}
			]
		}
	]

});


