Ext.define('SpecificTestConfiguration.view.EgConfigurePublishedResources',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigurepublishedresources',

	border: false,
	title: multiSrcTitle,
	id: 'egconfigurepublishedresources',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addMultiSrcbtn',
					width: 80,
					text: addmore_lbl
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateMultiConfSrc',
					name: 'updateMultiConfSrc',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearMultiConfSrc',
					name: 'clearMultiConfSrc',
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'NoMultiUsrPattern',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+NoPublishedResource+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'conmulti_1',
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeMultiSrc('conmulti_1');
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							defaults: {
								labelSeparator:' ',
								labelWidth: 150
							},
							columnWidth: 1,
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									fieldLabel: 'Published resources',
									style:{'white-space':'nowrap'},
									id:'publisresource1',
									value: '$unconfigured',
									columnWidth: 0.97,
									readOnly : true
								},
								{
									xtype: 'button',
									columnWidth: 0.03,
									tooltip: pubResourceToolTip,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									margin: '0 0 0 2',
									listeners: {
										click: function() {
											testInterViews.getPopUpView('publisresource1');
										}
									}
								}
							]
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Domain,
							style:{'white-space':'nowrap'},
							id:'domainmultiusr1',
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'usermultiusr1',
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: PasswordLbl,
							style:{'white-space':'nowrap'},
							id:'pwdmultiusr1',
							inputType: 'password',
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: CnfPassLbl,
							style:{'white-space':'nowrap'},
							id:'confpwdmultiusr1',
							inputType: 'password',
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							id: 'twofaCont1',
							fieldLabel: 'Is 2FA enabled?',
							columnWidth: 0.5,
							layout: 'column',
							items : [
								{
									xtype: 'radiogroup',
									columnWidth: 0.6,
									cls: 'radiobt',
									id: 'twofact1',
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: 'twofactlabel1', id: 'twofactlabel1_1',  inputValue: 'true'},
										{ boxLabel: 'No', name: 'twofactlabel1', id: 'twofactlabel1_2',  inputValue: 'false', checked: true}
									],
									listeners : {
										'change' : function(obj, value)
										{
											var value = Ext.getCmp('twofact1').getChecked()[0];
											if (value.getGroupValue() == 'false')
											{
												Ext.getCmp('twofacttoken1').setVisible(false);
											}
											else
											{
												Ext.getCmp('twofacttoken1').setVisible(true);
											}
										}
									}
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									style:{'white-space':'nowrap'},
									id:'twofacttoken1',
									inputType: 'password',
									emptyText: '2FA code',
									columnWidth: 0.4,
									margin: '0 0 0 5',
									hidden: true,
									backupValue: '$unconfigured',
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								}
							]
						},
						{
							xtype: 'radiogroup',
							columnWidth: 0.5,
							cls: 'radiobt',
							id: 'disclaimer_radioGrp1',
							fieldLabel: 'Is disclaimer enabled?',
							vertical: false,
							columns: 2,
							items: [
								{ boxLabel: 'Yes', name: 'disclaimermultiusr1', id: 'disclaimermultiusr1_1',  inputValue: 'true'},
								{ boxLabel: 'No', name: 'disclaimermultiusr1', id: 'disclaimermultiusr1_2',  inputValue: 'false', checked: true}
							]
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'backupmulticontainer',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			}
		}
	]
});



