Ext.define('SpecificTestConfiguration.view.EgConfigureWsdlUrlAndCredentials',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigurewsdlurlandcredentials',

	border: false,
	title: wsdlTitle,
	id: 'egconfigurewsdlurlandcredentials',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addWsdlUrlbtn',
					width: 80,
					text: addmore_lbl
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateWsdlUrl',
					name: 'updateWsdlUrl',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearWsdlUrl',
					name: 'clearWsdlUrl',
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'NoWsdlUrlPattern',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noWsdlUrl+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'con_wsdl1',
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeWsdlUrlContact('con_wsdl1');
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator: ' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Name,
							id: 'nameWsdl1',
							name: 'nameWsdl1',
							value: '$unconfigured',
							columnWidth: 0.25
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlLbl,
							id: 'urlWsdl1',
							name: 'urlWsdl1',
							value: '$unconfigured',
							columnWidth: 0.75
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlUnmeLbl,
							id: 'usrnameWsdl1',
							name: 'usrnameWsdl1',
							value: 'none',
							columnWidth: 0.25
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlPwdLbl,
							id: 'pwdWsdl1',
							name: 'pwdWsdl1',
							inputType: 'password',
							//value: 'none',
							columnWidth: 0.25,
							backupValue: 'none',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							columnWidth: 0.30,
							fieldLabel: urlContentLbl,
							items: [
								{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id : 'contentWsdl1',
									name: 'contentWsdl1',
									displayField: 'displayField',
									columnWidth: 0.4,
									valueField: 'valueField',
									queryMode: 'local',
									value: 'none',
									editable: false,
									parent:this,
									store:new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: [{'displayField':'None','valueField':'none'},
											{'displayField':'Include','valueField':'Inc'},{'displayField':'Exclude','valueField':'Exc'}
											]
										}
									)
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: 'subcontentWsdl1',
									name: 'subcontentWsdl1',
									columnWidth: 0.6,
									margin: '0 0 0 5',
									value: 'none'
								}
							]
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlEncodeLbl,
							id: 'encodeWsdl1',
							name: 'encodeWsdl1',
							value: 'none',
							columnWidth: 0.20
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'wsdlurlcontainer',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			}
		}
	]
});



