Ext.define('SpecificTestConfiguration.view.EgDbUserCreation', {
	extend: 'Ext.window.Window',
	alias: 'widget.egdbusercreation',

	id : 'egdbusercreation',
	title: dbTitle,
	modal: true,
	padding:'5 10 10 10',

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Add,
					id: 'AddBTN',
					width: 80
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					margin: '0 0 0 10',
					id: 'ClearBTN',
					width: 80
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: label1,
					id: 'ApplyBTN',
					width: 80,
					margin: '0 0 0 10',
					disabled: true
				}
			]
		}
	],

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items:[
		{
			xtype: 'container',
			padding:10,
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 400,
				labelWidth: 200
			},
			margin: 5,
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: HostName,
					id: 'hostnamedb'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: Port,
					id: 'portdb'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: Sid,
					id: 'siddb'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'dbversion',
					name: 'dbversion',
					fieldLabel: DbVersion,
					fieldName : 'dbversion',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					editable: false,
					value: 'Choose One',
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [{'displayField':'Choose One','valueField':'-1'},
							{'displayField':'Oracle 7.x','valueField':'Oracle 7.x'},
							{'displayField':'Oracle 8.x - 11g','valueField':'Above'},
							{'displayField':'Oracle 12c & above','valueField':'Oracle12.x'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: SysPwd,
					inputType: 'password',
					id: 'syspwd',
					hidden: true,
					backupValue: '',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'radiogroup',
					cls: 'radiobt',
					id: 'dbconnection_radioGrp',
					fieldLabel: DbConnection,
					vertical: false,
					columns: 2,
					hidden: true,
					disabled: true,
					items: [
						{ boxLabel: 'CDB', name: 'dbconnection', id: 'dbconnection1',  inputValue: 'cdb' },
						{ boxLabel: 'PDB', name: 'dbconnection', id: 'dbconnection2',  inputValue: 'pdb', checked: true }
					]
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: DbAdmin,
					id: 'dbadmin'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: DbAdminPwd,
					inputType: 'password',
					id: 'dbadminpwd',
					backupValue: '',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: DbUsr,
					id: 'dbuser'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: DbUsrPwd,
					inputType: 'password',
					id: 'dbuserpwd',
					backupValue: '',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: DefaultTbSpace,
					id: 'defaulttablespace'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: TempSpace,
					id: 'temptablespace'
				}
			]
		}
	]

});



